# coding: utf-8

# flake8: noqa
"""
    UniCatDB API

    UniCatDB application API documentation, with examples and live testing.  This API is built in accordance with the **JSON API 1.0 standard**. For general information, see [the documentation](http://jsonapi.org/format/).  **Notes:** * JSON API standard requires use of the JSON API media type (application/vnd.api+json) for exchanging data. Clients must send all JSON API data with the headers `Content-Type: application/vnd.api+json` (POST, PATCH) and `Accept: application/vnd.api+json` (GET, DELETE). * [Relationships](http://jsonapi.org/format/#fetching-relationships) and their [inclusions](http://jsonapi.org/format/#fetching-includes) via the `include` query parameter, as specified by the standard, **are not implemented**, since there are no relationships present in the data model. * The standard does not prescribe any filtering strategies. This API implements two strategies which can be combined: **Basic filtering** based on the used [JSON API library](https://json-api-dotnet.github.io/#/filtering) and **Custom filtering** which allow for any possible query to the MongoDB server and can be extended and customize in the future. For more information about filtering, see the description of the `filter` down bellow. * **Non-standard PATCH behavior:** Sucessfull PATCH reuest always result in HTTP 200 response with the updated resource object, even if the server does not perform any additional modifications. HTTP 204 is never used in PATCH responses.   # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

# import models into model package
from unicatdb.openapi_client.models.attachment import Attachment
from unicatdb.openapi_client.models.attachment_array_response import AttachmentArrayResponse
from unicatdb.openapi_client.models.attachment_fields_query import AttachmentFieldsQuery
from unicatdb.openapi_client.models.attachment_put_request import AttachmentPutRequest
from unicatdb.openapi_client.models.attachment_put_response import AttachmentPutResponse
from unicatdb.openapi_client.models.attachment_resource_object import AttachmentResourceObject
from unicatdb.openapi_client.models.attachment_resource_object_relationships import AttachmentResourceObjectRelationships
from unicatdb.openapi_client.models.attachment_single_response import AttachmentSingleResponse
from unicatdb.openapi_client.models.authentication_response import AuthenticationResponse
from unicatdb.openapi_client.models.credentials_request_body import CredentialsRequestBody
from unicatdb.openapi_client.models.error_response import ErrorResponse
from unicatdb.openapi_client.models.error_response_item import ErrorResponseItem
from unicatdb.openapi_client.models.existing_finding_request_body import ExistingFindingRequestBody
from unicatdb.openapi_client.models.existing_finding_schema_request_body import ExistingFindingSchemaRequestBody
from unicatdb.openapi_client.models.finding import Finding
from unicatdb.openapi_client.models.finding_array_response import FindingArrayResponse
from unicatdb.openapi_client.models.finding_fields_query import FindingFieldsQuery
from unicatdb.openapi_client.models.finding_resource_object import FindingResourceObject
from unicatdb.openapi_client.models.finding_resource_object_relationships import FindingResourceObjectRelationships
from unicatdb.openapi_client.models.finding_schema import FindingSchema
from unicatdb.openapi_client.models.finding_schema_array_response import FindingSchemaArrayResponse
from unicatdb.openapi_client.models.finding_schema_definition_group import FindingSchemaDefinitionGroup
from unicatdb.openapi_client.models.finding_schema_element import FindingSchemaElement
from unicatdb.openapi_client.models.finding_schema_element_value import FindingSchemaElementValue
from unicatdb.openapi_client.models.finding_schema_fields_query import FindingSchemaFieldsQuery
from unicatdb.openapi_client.models.finding_schema_resource_object import FindingSchemaResourceObject
from unicatdb.openapi_client.models.finding_schema_resource_object_relationships import FindingSchemaResourceObjectRelationships
from unicatdb.openapi_client.models.finding_schema_single_response import FindingSchemaSingleResponse
from unicatdb.openapi_client.models.finding_single_response import FindingSingleResponse
from unicatdb.openapi_client.models.frequency_chart import FrequencyChart
from unicatdb.openapi_client.models.frequency_chart_item import FrequencyChartItem
from unicatdb.openapi_client.models.lat_lng_gps import LatLngGps
from unicatdb.openapi_client.models.level_description_element import LevelDescriptionElement
from unicatdb.openapi_client.models.mini_map_data import MiniMapData
from unicatdb.openapi_client.models.mini_map_data_item import MiniMapDataItem
from unicatdb.openapi_client.models.new_finding_request_body import NewFindingRequestBody
from unicatdb.openapi_client.models.new_finding_schema_request_body import NewFindingSchemaRequestBody
from unicatdb.openapi_client.models.page_query import PageQuery
from unicatdb.openapi_client.models.relationship_links import RelationshipLinks
from unicatdb.openapi_client.models.relationship_resource_identifier import RelationshipResourceIdentifier
from unicatdb.openapi_client.models.relationship_resource_identifier_array_response import RelationshipResourceIdentifierArrayResponse
from unicatdb.openapi_client.models.relationship_resource_identifier_response import RelationshipResourceIdentifierResponse
from unicatdb.openapi_client.models.response_links import ResponseLinks
from unicatdb.openapi_client.models.response_meta import ResponseMeta
from unicatdb.openapi_client.models.response_relationship_one_to_many import ResponseRelationshipOneToMany
from unicatdb.openapi_client.models.response_relationship_one_to_one import ResponseRelationshipOneToOne
from unicatdb.openapi_client.models.statistical_data import StatisticalData
from unicatdb.openapi_client.models.statistical_data_item import StatisticalDataItem
from unicatdb.openapi_client.models.statistical_data_meta import StatisticalDataMeta
from unicatdb.openapi_client.models.taxonomy_name import TaxonomyName
from unicatdb.openapi_client.models.taxonomy_node import TaxonomyNode
from unicatdb.openapi_client.models.taxonomy_tree import TaxonomyTree
from unicatdb.openapi_client.models.tenant import Tenant
from unicatdb.openapi_client.models.user_script_credentials_response import UserScriptCredentialsResponse
