"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Predefined error strings
 * Error names in Amazon States Language - https://states-language.net/spec.html#appendix-a
 * Error handling in Step Functions - https://docs.aws.amazon.com/step-functions/latest/dg/concepts-error-handling.html
 */
class Errors {
}
exports.Errors = Errors;
/**
 * Matches any Error.
 */
Errors.ALL = 'States.ALL';
/**
 * A Task State either ran longer than the “TimeoutSeconds” value, or
 * failed to heartbeat for a time longer than the “HeartbeatSeconds” value.
 */
Errors.TIMEOUT = 'States.Timeout';
/**
 * A Task State failed during the execution.
 */
Errors.TASKS_FAILED = 'States.TaskFailed';
/**
 * A Task State failed because it had insufficient privileges to execute
 * the specified code.
 */
Errors.PERMISSIONS = 'States.Permissions';
/**
 * A Task State’s “ResultPath” field cannot be applied to the input the state received.
 */
Errors.RESULT_PATH_MATCH_FAILURE = 'States.ResultPathMatchFailure';
/**
 * Within a state’s “Parameters” field, the attempt to replace a field whose
 * name ends in “.$” using a Path failed.
 */
Errors.PARAMETER_PATH_FAILURE = 'States.ParameterPathFailure';
/**
 * A branch of a Parallel state failed.
 */
Errors.BRANCH_FAILED = 'States.BranchFailed';
/**
 * A Choice state failed to find a match for the condition field extracted
 * from its input.
 */
Errors.NO_CHOICE_MATCHED = 'States.NoChoiceMatched';
/**
 * Special string value to discard state input, output or result
 */
exports.DISCARD = 'DISCARD';
//# sourceMappingURL=data:application/json;base64,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