"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const __1 = require("..");
const state_1 = require("./state");
/**
 * State defined by supplying Amazon States Language (ASL) in the state machine.
 *
 * @experimental
 */
class CustomState extends state_1.State {
    constructor(scope, id, props) {
        super(scope, id, {});
        this.endStates = [this];
        this.stateJson = props.stateJson;
    }
    /**
     * Continue normal execution with the given state
     */
    next(next) {
        super.makeNext(next.startState);
        return __1.Chain.sequence(this, next);
    }
    /**
     * Returns the Amazon States Language object for this state
     */
    toStateJson() {
        return {
            ...this.renderNextEnd(),
            ...this.stateJson,
        };
    }
}
exports.CustomState = CustomState;
//# sourceMappingURL=data:application/json;base64,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