#!/usr/bin/env python
# -*- coding: UTF-8 -*-
#
# generated by wxGlade 0.9.5 on Thu Apr  2 08:19:01 2020
#
#----------------------------------------------------------------------------
# Name:         ldmStorageFolderViewFrm.py
# Purpose:      ldmStorageFolderViewFrm.py
#               GUI viewer for ldmStorageFolder
# Author:       Walter Obweger
#
# Created:      20200404
# CVS-ID:       $Id$
# Copyright:    (c) 2020 by Walter Obweger
# Licence:      MIT
#----------------------------------------------------------------------------


import wx
import wx.lib.gizmos as gizmos
import os
import logging
import traceback

from optparse import OptionParser

# begin wxGlade: dependencies
# end wxGlade

# begin wxGlade: extracode
# end wxGlade

from lindworm import __version__
import lindworm.ldmGui as ldmGui
from lindworm.ldmGuiThd import ldmGuiThd
from lindworm.ldmStorageFolder import ldmStorageFolder

gOpt=None

class ldmStorageFolderViewFrm(wx.Frame):
    WILDCARD_JSON=["json file (*.json)|*.json",
            "All files (*.*)|*.*"]
    def __init__(self, *args, **kwds):
        self.__initCfg__()
        self.__initDat__()
        # begin wxGlade: ldmStorageFolderViewFrm.__init__
        kwds["style"] = kwds.get("style", 0) | wx.DEFAULT_FRAME_STYLE
        wx.Frame.__init__(self, *args, **kwds)
        self.SetSize((600, 400))
        #self.txtBldFN = wx.TextCtrl(self, wx.ID_ANY, self.sBldFN)
        #self.cbBldFN = wx.Button(self, wx.ID_ANY, "...")
        #self.txtCfgFN = wx.TextCtrl(self, wx.ID_ANY, self.sCfgFN)
        #self.cbCfgFN = wx.Button(self, wx.ID_ANY, "...")
        tSz = (16,16)
        # +++++ beg:
        self.chcDef = wx.Choice(self, wx.ID_ANY, choices=self.CHC_DEF)
        self.txtDef = wx.TextCtrl(self, wx.ID_ANY, '')
        bmp=wx.ArtProvider.GetBitmap(wx.ART_DELETE,wx.ART_MENU, tSz)
        self.cbDel = wx.BitmapButton(self, wx.ID_ANY, bmp)
        bmp=wx.ArtProvider.GetBitmap(wx.ART_FILE_OPEN,wx.ART_MENU, tSz)
        self.cbAdd = wx.BitmapButton(self, wx.ID_ANY, bmp)
        self.cbAddBrw = wx.Button(self, wx.ID_ANY, "...")
        # ----- end:
        # +++++ beg:
        self.txtPhase = wx.TextCtrl(self, wx.ID_ANY, "", style=wx.TE_READONLY)
        self.txtStatus = wx.TextCtrl(self, wx.ID_ANY, "", style=wx.TE_READONLY)
        bmp=wx.ArtProvider.GetBitmap(wx.ART_TICK_MARK,wx.ART_MENU, tSz)
        self.cbStart = wx.BitmapButton(self, wx.ID_ANY, bmp)
        bmp=wx.ArtProvider.GetBitmap(wx.ART_CROSS_MARK,wx.ART_MENU, tSz)
        self.cbStop = wx.BitmapButton(self, wx.ID_ANY, bmp)
        # ----- end:
        #bmp=wx.ArtProvider.GetBitmap(wx.ART_DELETE,wx.ART_OTHER, tSz)
        self.trlFdr = gizmos.TreeListCtrl(self, wx.ID_ANY, style=0, agwStyle=
                                gizmos.TR_DEFAULT_STYLE|
                                wx.TR_HIDE_ROOT|
                                #| gizmos.TR_HAS_BUTTONS
                                #| gizmos.TR_TWIST_BUTTONS
                                #| gizmos.TR_ROW_LINES
                                #| gizmos.TR_COLUMN_LINES
                                #| gizmos.TR_NO_LINES
                                #| gizmos.TR_LINES_AT_ROOT
                                gizmos.TR_FULL_ROW_HIGHLIGHT
                                )
        il = wx.ImageList(*tSz)
        iIdxFdrCls  = il.Add(wx.ArtProvider.GetIcon(wx.ART_FOLDER,      wx.ART_OTHER, tSz))
        iIdxFdrOpn  = il.Add(wx.ArtProvider.GetIcon(wx.ART_FOLDER_OPEN, wx.ART_OTHER, tSz))
        iIdxFile    = il.Add(wx.ArtProvider.GetIcon(wx.ART_NORMAL_FILE, wx.ART_OTHER, tSz))
        self.dImgIdx={
            'FdrCls':iIdxFdrCls,
            'FdrOpn':iIdxFdrOpn,
            'File':iIdxFile,
            }
        self.trlFdr.SetImageList(il)
        
        self.cbOpn = wx.Button(self, wx.ID_ANY, "Opn")
        self.cpCpy00 = wx.Button(self, wx.ID_ANY, "-> 0")
        self.cbCpy01 = wx.Button(self, wx.ID_ANY, "-> 1")
        self.cbCpy02 = wx.Button(self, wx.ID_ANY, "-> 2")
        self.cbCpy03 = wx.Button(self, wx.ID_ANY, "-> 3")
        
        # Menu Bar
        self.mnViewMain = wx.MenuBar()
        wxglade_tmp_menu = wx.Menu()
        item = wxglade_tmp_menu.Append(wx.ID_ANY, "Open", "")
        self.Bind(wx.EVT_MENU, self.OnMnOpn, id=item.GetId())
        wxglade_tmp_menu.AppendSeparator()
        item = wxglade_tmp_menu.Append(wx.ID_ANY, "Exit", "")
        self.Bind(wx.EVT_MENU, self.OnMnExit, id=item.GetId())
        self.mnViewMain.Append(wxglade_tmp_menu, "File")
        self.SetMenuBar(self.mnViewMain)
        # Menu Bar end

        self.__set_properties()
        self.__do_layout()

        #self.Bind(wx.EVT_TEXT_ENTER, self.OnBldFnEnter, self.txtBldFN)
        #self.Bind(wx.EVT_BUTTON, self.OnBldFN, self.cbBldFN)
        #self.Bind(wx.EVT_TEXT_ENTER, self.OnCfgFnEnter, self.txtCfgFN)
        #self.Bind(wx.EVT_BUTTON, self.OnCfgFN, self.cbCfgFN)
        
        self.Bind(wx.EVT_BUTTON, self.OnDel, self.cbDel)
        self.Bind(wx.EVT_BUTTON, self.OnAdd, self.cbAdd)
        self.Bind(wx.EVT_BUTTON, self.OnOpn, self.cbOpn)
        self.Bind(wx.EVT_BUTTON, self.OnCpy00, self.cpCpy00)
        self.Bind(wx.EVT_BUTTON, self.OnCpy01, self.cbCpy01)
        self.Bind(wx.EVT_BUTTON, self.OnCpy02, self.cbCpy02)
        self.Bind(wx.EVT_BUTTON, self.OnCpy03, self.cbCpy03)
        # end wxGlade
        self.oThd=ldmGuiThd(self,rDly=0.2,sLogger='thdGui',iVerbose=0)
        self.oThd.BindEvtNty(self.OnThdNty)

    def __initCfg__(self):
        self.CHC_DEF=["slot 00","slot 01","slot 02","slot 03"]
    def __initDat__(self):
        global gOpt
        self.sCfgFN=gOpt.sCfgFN      #"ldmStorageFolderCfg.json"
        #self.sBldFN=gOpt.sBldFN             #None
        self.iVerbose=10
        # +++++ beg:
        self.oFdr=ldmStorageFolder(iVerbose=self.iVerbose)
        #iRet=oFdr.loadCfg(sCfgFN)
        self.oFdr.oLog.debug('fin:ldmStorageFolderViewFrm::__initDat__')
        # ----- end:
    def __set_properties(self):
        # begin wxGlade: ldmStorageFolderViewFrm.__set_properties
        self.SetTitle("ldmStorageFolder Viewer")
        #self.txtBldFN.SetToolTip("build file name\nempty field uses current time in UTC\n0 uses current local time\n1 uses current time in UTC")
        #self.txtCfgFN.SetToolTip("configuration file name")
        #self.txtStatus.SetToolTip("status message")
        #self.gagDetail.SetMinSize((-1, 7))
        #self.lcrLog.AppendColumn("No", format=wx.LIST_FORMAT_LEFT, width=80)
        #self.lcrLog.AppendColumn("Info", format=wx.LIST_FORMAT_LEFT, width=250)
        #self.lcrLog.AppendColumn("Stat", format=wx.LIST_FORMAT_LEFT, width=30)
        self.trlFdr.AddColumn('name')
        self.trlFdr.AddColumn('size')
        self.trlFdr.AddColumn('time')
        self.trlFdr.AddColumn('sha')
        self.trlFdr.SetMainColumn(0)
        self.trlFdr.SetColumnWidth(0, 250)
        # end wxGlade

    def __do_layout(self):
        # begin wxGlade: ldmStorageFolderViewFrm.__do_layout
        # +++++ beg:
        fgsMain = wx.FlexGridSizer(3, 2, 0, 0)
        # ----- end:
        # +++++ beg:
        bxsDef = wx.BoxSizer(wx.HORIZONTAL)
        bxsDef.Add(self.chcDef, 1, wx.EXPAND, 0)
        bxsDef.Add(self.txtDef, 1, wx.EXPAND, 0)
        bxsDef.Add(self.cbAdd, 0, 0, 0)
        bxsDef.Add(self.cbDel, 0, 0, 0)
        fgsMain.Add(bxsDef, 1, wx.EXPAND, 0)
        fgsMain.Add(self.cbAddBrw, 0, 0, 0)
        # ----- end:
        # +++++ beg:
        bxsStatus = wx.BoxSizer(wx.HORIZONTAL)
        bxsStatus.Add(self.txtPhase, 1, wx.EXPAND, 0)
        bxsStatus.Add(self.txtStatus, 2, wx.EXPAND, 0)
        bxsStatus.Add(self.cbStart, 0, 0, 0)
        bxsStatus.Add(self.cbStop, 0, 0, 0)
        fgsMain.Add(bxsStatus, 1, wx.EXPAND, 0)
        fgsMain.AddSpacer(2)
        # ----- end:
        # +++++ beg:
        bxsCmd = wx.BoxSizer(wx.VERTICAL)
        bxsCmd.Add(self.cbOpn, 0, 0, 0)
        bxsCmd.Add(self.cpCpy00, 0, 0, 0)
        bxsCmd.Add(self.cbCpy01, 0, 0, 0)
        bxsCmd.Add(self.cbCpy02, 0, 0, 0)
        bxsCmd.Add(self.cbCpy03, 0, 0, 0)
        fgsMain.Add(self.trlFdr, 1, wx.EXPAND, 0)
        fgsMain.Add(bxsCmd, 1, wx.EXPAND, 0)
        # ----- end:
        # +++++ beg:
        self.SetSizer(fgsMain)
        fgsMain.AddGrowableRow(2)
        fgsMain.AddGrowableCol(0)
        # ----- end:
        self.Layout()
        # end wxGlade

    def OnThdNty(self,evt):
        evt.Skip()
        try:
            # +++++ beg:
            #iSched=evt.oNty.GetSched()
            sStatOfs=evt.oNty.GetStatusOfs()
            iVal=evt.oNty.GetNormalized()
            sPhase=evt.oNty.GetPhase()
            sStatus=evt.oNty.GetStatus()
            self.gagDetail.SetValue(int(iVal))
            self.txtPhase.SetValue(sPhase)
            self.txtStatus.SetValue(sStatus)
            if evt.oNty.IsActive():
                iIdx=self.lcrLog.InsertItem(0,sStatOfs)
                self.lcrLog.SetItem(iIdx,1,sStatus)
            # ----- end:
        except:
            self.oFdr.logTB()
    def OnStart(self, event):  # wxGlade: ldmStorageFolderViewFrm.<event_handler>
        event.Skip()
        try:
            # +++++ beg:initialize
            logging.debug('beg:OnStart')
            iRet=0
            # ----- end:initialize
            # +++++ beg:schedule action
            oNty=self.oThd.GetNty()
            self.oThd.Do('%s'%(self.sSrcDN),
                        self.prcFld,*(),
                        sCfgFN=self.sCfgFN,
                        sSrcDN=self.sSrcDN,
                        sBldFN=self.sBldFN,
                        sBldDN=self.sBldDN,
                        iShaMB=self.iShaMB,
                        oNty=oNty)
            # ----- end:schedule action
            # +++++ beg:finalize
            logging.debug('end:OnStart iRet:%d'%(iRet))
            # ----- end:finalize
            return 1
        except:
            self.oFdr.logTB()
    def prcFld(self,sCfgFN=None,sSrcDN=None,
                sBldFN=None,sBldDN=None,
                iShaMB=0,oNty=None):
        try:
            # +++++ beg:initialize
            sOrg='ldmStorageFolderViewFrm::prcFld'
            self.oFdr.logDbg('beg:%s sSrcDN:%s',sOrg,sSrcDN)
            self.oFdr.clrAll()
            iRet=self.oFdr.loadCfg(self.sCfgFN)
            # ----- end:initialize
            # +++++ beg:register action
            #self.oFdr.logDbg('    sSrcDN:%r',sSrcDN)
            iRet=self.oFdr.prcBeg(sSrcDN,oRef=None)
            if iRet>0:
                if oNty is not None:
                    oNty.SetPhase('%r ...'%(sSrcDN))
                    oNty.SetStatus('')
                iRet+=1
            else:
                if oNty is not None:
                    oNty.SetPhase('%r skipped. iRet:%d'%(sSrcDN,iRet))
                    oNty.SetStatus('failed start')
                return -1
            # ----- end:register action
            # +++++ beg:perform action
            iRet=self.oFdr.prcExc()#(oGtrMD=self)
            if iRet>0:
                if oNty is not None:
                    oNty.SetPhase('%r finalize ...'%(sSrcDN))
            else:
                if oNty is not None:
                    oNty.SetPhase('%r aborted. iRet:%d'%(sSrcDN,iRet))
                    oNty.SetStatus('failed to process')
                return -2
            # ----- end:perform action
            # +++++ beg:finalize action
            self.oFdr.logDbg('    %s iShaMB:%r',sOrg,iShaMB)
            iRetFdr=self.oFdr.prcEnd(iShaMB=iShaMB,oNty=oNty)
            if iRetFdr>0:
                if oNty is not None:
                    oNty.SetPhase('%r finished.'%(sSrcDN))
                iRet+=1
            else:
                if oNty is not None:
                    oNty.SetPhase('%r aborted. iRet:%d'%(sSrcDN,iRetFdr))
                    oNty.SetStatus('failed to finalize')
            # ----- end:finalize action
            # +++++ beg:save result to json
            if iRetFdr>0:
                self.oFdr.logDbg('    %s sBldFN:%r sBldDN:%r sDefEnd:%r',
                            sOrg,sBldFN,sBldDN,self.oFdr.sDefEnd)
                if sBldFN is None:
                    sBldFN=None
                else:
                    if len(sBldFN)>0:
                        if sBldFN=='0':
                            sBldFN=0
                        elif sBldFN=='1':
                            sBldFN=1
                    else:
                        sBldFN=None
                iRetSave=self.oFdr.saveDat(sBldFN,sDN=sBldDN,
                                    lKey=[self.oFdr.sDefEnd],
                                    sAtr='dDat')
                if iRetSave>0:
                    if oNty is not None:
                        oNty.SetStatus('saved')
                    iRet+=1
                else:
                    oNty.SetStatus('save failed iRetSave:%d'%(iRetSave))
            # ----- end:save result to json
            # +++++ beg:
            if oNty is not None:
                oNty.finStatus()
                self.oThd.delay(iCnt=5)
            self.oFdr.logDbg('end:%s iRet:%d',sOrg,iRet)
            # ----- end:
            return iRet
        except:
            self.oFdr.logTB()
            return -1
    def OnStop(self, event):  # wxGlade: ldmStorageFolderViewFrm.<event_handler>
        event.Skip()
        try:
            # +++++ beg:
            iRet=0
            sOrg='ldmStorageFolderViewFrm::OnStop'
            self.oFdr.logDbg('beg:%s',sOrg)
            # ----- end:
            self.oThd.Stop()
            # +++++ beg:
            self.oFdr.logDbg('end:%s iRet:%d',sOrg,iRet)
            # ----- end:
        except:
            self.oFdr.logTB()

    def OnDel(self, event):  # wxGlade: ldmStorageFolderViewFrm.<event_handler>
        print("Event handler 'OnDel' not implemented!")
        event.Skip()

    def OnAdd(self, event):  # wxGlade: ldmStorageFolderViewFrm.<event_handler>
        print("Event handler 'OnAdd' not implemented!")
        event.Skip()

    def OnOpn(self, event):  # wxGlade: ldmStorageFolderViewFrm.<event_handler>
        print("Event handler 'OnOpn' not implemented!")
        event.Skip()

    def OnCpy00(self, event):  # wxGlade: ldmStorageFolderViewFrm.<event_handler>
        print("Event handler 'OnCpy00' not implemented!")
        event.Skip()

    def OnCpy01(self, event):  # wxGlade: ldmStorageFolderViewFrm.<event_handler>
        print("Event handler 'OnCpy01' not implemented!")
        event.Skip()

    def OnCpy02(self, event):  # wxGlade: ldmStorageFolderViewFrm.<event_handler>
        print("Event handler 'OnCpy02' not implemented!")
        event.Skip()

    def OnCpy03(self, event):  # wxGlade: ldmStorageFolderViewFrm.<event_handler>
        print("Event handler 'OnCpy03' not implemented!")
        event.Skip()
    def shwFdr(self,sFN,sKey='0'):
        try:
            # +++++ beg:initialize
            iRet=0
            self.trlFdr.DeleteAllItems()
            self.oFdr.log('beg:shwFdr iRet:%d sFN:%s sKey:%r',
                                iRet,sFN,sKey)
            iRet=self.oFdr.loadDat(sFN,sDN=None,
                            sKey=sKey,sAtr='dDat')
            itPar=self.trlFdr.AddRoot(sKey)
            if iRet>0:
                #dFdr=self.oFdr.dDat[sKey]
                iR,dFdr=self.oFdr.getDat(sKey)
                def getFmtSzHum(iSz):
                    fSz=iSz/1024/1024
                    return '%6.3f'%fSz
                def addElemFle(trlObj,itPar,dFdr):
                    iRet=0
                    iIdxFleOpn=self.dImgIdx['File']
                    iIdxFleCls=self.dImgIdx['File']
                    for sFdr,dSub in dFdr.items():
                        iRet+=1
                        itCur=trlObj.AppendItem(itPar, sFdr)
                        trlObj.SetItemImage(itCur, iIdxFleOpn, which = wx.TreeItemIcon_Normal)
                        #trlObj.SetItemImage(itCur, iIdxFdrCls , which = wx.TreeItemIcon_Expanded)
                        sSz=getFmtSzHum(dSub.get('sz',0))
                        trlObj.SetItemText(itCur,sSz, 1)
                        sTime=dSub.get('time','')
                        trlObj.SetItemText(itCur,sTime, 2)
                        sSha=dSub.get('sha','')
                        trlObj.SetItemText(itCur,sSha, 3)
                    return iRet
                def addElemFdr(trlObj,itPar,dFdr):
                    iRet=0
                    iIdxFdrOpn=self.dImgIdx['FdrOpn']
                    iIdxFdrCls=self.dImgIdx['FdrCls']
                    for sFdr,dSub in dFdr.items():
                        if sFdr=='.':
                            iRet+=1
                            itCur=trlObj.AppendItem(itPar, sFdr)
                            trlObj.SetItemImage(itCur, iIdxFdrOpn, which = wx.TreeItemIcon_Normal)
                            trlObj.SetItemImage(itCur, iIdxFdrCls , which = wx.TreeItemIcon_Expanded)
                            iR=addElemFle(trlObj,itCur,dSub)
                            if iR>0:
                                iRet+=1
                        else:
                            iRet+=1
                            itCur=trlObj.AppendItem(itPar, sFdr)
                            trlObj.SetItemImage(itCur, iIdxFdrOpn, which = wx.TreeItemIcon_Normal)
                            trlObj.SetItemImage(itCur, iIdxFdrCls , which = wx.TreeItemIcon_Expanded)
                            iR=addElemFdr(trlObj,itCur,dSub)
                            if iR>0:
                                iRet+=1
                    return iRet
                iR=addElemFdr(self.trlFdr,itPar,dFdr)

            # ----- end:initialize
            # +++++ beg:get DN
            self.oFdr.log('end:shwFdr iRet:%d sFN:%s',
                                iRet,sFN)
            # ----- end:get DN
            return iRet
        except:
            self.oFdr.logTB()
    def OnMnOpn(self, event):  # wxGlade: ldmStorageFolderViewFrm.<event_handler>
        print("Event handler 'OnMnOpn' not implemented!")
        event.Skip()
        try:
            # +++++ beg:get DN
            sBldFN='.'#self.txtBldFN.GetValue()
            # ----- end:get DN
            iRet,sBldFN=ldmGui.getFN(sBldFN,self,
                         'choose build file name',
                         lWildCard=self.WILDCARD_JSON,
                         oLog=self.oFdr)
            if iRet>0:
                iR=self.shwFdr(sBldFN,sKey='0')
                if iR>0:
                    iRet+=iR
                self.oFdr.log('fin:OnBldFN iRet:%d sBldFN:%s',
                                iRet,sBldFN)
        except:
            self.oFdr.logTB()

    def OnMnExit(self, event):  # wxGlade: ldmStorageFolderViewFrm.<event_handler>
        print("Event handler 'OnMnExit' not implemented!")
        event.Skip()
        
    def OnSrcDnEnter(self, event):  # wxGlade: ldmStorageFolderViewFrm.<event_handler>
        event.Skip()
        try:
            # +++++ beg:get DN
            sSrcDN=self.txtSrcDN.GetValue()
            if os.path.exists(sSrcDN):
                self.sSrcDN=sSrcDN
                self.oFdr.log('OnSrcOnEnter sSrcDN:%s ok',sSrcDN)
            else:
                self.oFdr.logErr('OnSrcOnEnter sSrcDN:%s does not exist',sSrcDN)
            # ----- end:get DN
        except:
            self.oFdr.logTB()
    def OnSrcDN(self, event):  # wxGlade: ldmStorageFolderViewFrm.<event_handler>
        event.Skip()
        try:
            # +++++ beg:get DN
            sSrcDN=self.txtSrcDN.GetValue()
            iRet,sSrcDN=ldmGui.getDN(sSrcDN,self,
                         'choose source directory')
            if iRet>0:
                self.sSrcDN=sSrcDN
                self.txtSrcDN.SetValue(self.sSrcDN)
                self.oFdr.log('fin:OnSrcDN iRet:%d sSrcDN:%s',
                            iRet,sSrcDN)
            # ----- end:get DN
        except:
            self.oFdr.logTB()

    def OnBldDnEnter(self, event):  # wxGlade: ldmStorageFolderViewFrm.<event_handler>
        event.Skip()
        try:
            # +++++ beg:get DN
            sBldDN=self.txtBldDN.GetValue()
            if os.path.exists(sBldDN):
                self.sBldDN=sBldDN
                self.oFdr.log('OnBldOnEnter sBldDN:%s ok',sBldDN)
            else:
                self.oFdr.logErr('OnBldOnEnter sBldDN:%s does not exist',sBldDN)
            # ----- end:get DN
        except:
            self.oFdr.logTB()
    def OnBldDN(self, event):  # wxGlade: ldmStorageFolderViewFrm.<event_handler>
        event.Skip()
        try:
            # +++++ beg:get DN
            sBldDN=self.txtBldDN.GetValue()
            iRet,sBldDN=ldmGui.getDN(sBldDN,self,
                         'choose build directory')
            if iRet>0:
                self.sBldDN=sBldDN
                self.txtBldDN.SetValue(self.sBldDN)
                self.oFdr.log('fin:OnBldDN iRet:%d sBldDN:%s',
                            iRet,sBldDN)
            # ----- end:get DN
        except:
            self.oFdr.logTB()

    def OnBldFnEnter(self, event):  # wxGlade: ldmStorageFolderViewFrm.<event_handler>
        event.Skip()
        try:
            # +++++ beg:get DN
            sBldFN=self.txtBldFN.GetValue()
            self.sBldFN=sBldFN
            self.oFdr.log('OnBldFnEnter sBldFN:%s ok',sBldFN)
        except:
            self.oFdr.logTB()

    def OnBldFN(self, event):  # wxGlade: ldmStorageFolderViewFrm.<event_handler>
        event.Skip()
        try:
            # +++++ beg:get DN
            sBldFN=self.txtBldFN.GetValue()
            # ----- end:get DN
            iRet,sBldFN=ldmGui.getFN(sBldFN,self,
                         'choose build file name',
                         lWildCard=self.WILDCARD_JSON,
                         oLog=self.oFdr)
            if iRet>0:
                self.oFdr.log('fin:OnBldFN iRet:%d sBldFN:%s',
                                iRet,sBldFN)
        except:
            self.oFdr.logTB()

    def OnLogFnEnter(self, event):  # wxGlade: ldmStorageFolderViewFrm.<event_handler>
        print("Event handler 'OnLogFnEnter' not implemented!")
        event.Skip()

    def OnLogFN(self, event):  # wxGlade: ldmStorageFolderViewFrm.<event_handler>
        print("Event handler 'OnLogFN' not implemented!")
        event.Skip()

    def OnCfgFnEnter(self, event):  # wxGlade: ldmStorageFolderViewFrm.<event_handler>
        print("Event handler 'OnCfgFnEnter' not implemented!")
        event.Skip()
    def OnCfgFN(self, event):  # wxGlade: ldmStorageFolderViewFrm.<event_handler>
        event.Skip()
        try:
            sCfgFN=self.txtCfgFN.GetValue()
            iRet,sCfgFN=ldmGui.getFN(sCfgFN,self,
                         'choose configuration file name',
                         lWildCard=self.WILDCARD_JSON,
                         oLog=self.oFdr)
            if iRet>0:
                self.sCfgFN=sCfgFN
                self.txtCfgFN.SetValue(self.sCfgFN)
                self.oFdr.log('fin:OnCfgFN iRet:%d sCfgFN:%s',
                            iRet,sCfgFN)
        except:
            self.oFdr.logTB()

    def OnShaMbChoice(self, event):  # wxGlade: ldmStorageFolderViewFrm.<event_handler>
        event.Skip()
        try:
            sVal=self.chcShaMB.GetString(self.chcShaMB.GetSelection())
            iIdx=self.chcShaMB.GetSelection()
            self.oFdr.logDbg('OnShaMbChoice sVal:%s iIdx:%d',sVal,iIdx)
            if iIdx==0:
                self.spnShaMB.SetValue(0)
                self.iShaMB=0
            elif iIdx==8:
                self.spnShaMB.SetValue(-1)
                self.iShaMB=-1
            elif iIdx==1:
                self.spnShaMB.SetValue(1)
                self.iShaMB=1
            elif iIdx==2:
                self.spnShaMB.SetValue(2)
                self.iShaMB=2
            elif iIdx==3:
                self.spnShaMB.SetValue(4)
                self.iShaMB=4
            elif iIdx==4:
                self.spnShaMB.SetValue(8)
                self.iShaMB=8
            elif iIdx==5:
                self.spnShaMB.SetValue(16)
                self.iShaMB=16
            elif iIdx==6:
                self.spnShaMB.SetValue(32)
                self.iShaMB=32
            elif iIdx==7:
                self.spnShaMB.SetValue(64)
                self.iShaMB=64
        except:
            self.oFdr.logTB()

    def OnShaMbSpin(self, event):  # wxGlade: ldmStorageFolderViewFrm.<event_handler>
        event.Skip()
        try:
            iVal=self.spnShaMB.GetValue()
            self.oFdr.logDbg('OnShaMbSpin iVal:%d',iVal)
            self.iShaMB=iVal
            #["disabled", "01 MB", "02 MB", "04 MB", "08 MB", "16 MB", "32 MB", "64 MB", "all data"]
            if iVal==0:
                self.chcShaMB.SetSelection(0)
            elif iVal<0:
                self.chcShaMB.SetSelection(8)
            elif iVal==1:
                self.chcShaMB.SetSelection(1)
            elif iVal==2:
                self.chcShaMB.SetSelection(2)
            elif iVal==4:
                self.chcShaMB.SetSelection(3)
            elif iVal==8:
                self.chcShaMB.SetSelection(4)
            elif iVal==16:
                self.chcShaMB.SetSelection(5)
            elif iVal==32:
                self.chcShaMB.SetSelection(6)
            elif iVal==64:
                self.chcShaMB.SetSelection(7)
            
        except:
            self.oFdr.logTB()

    def OnShaMbEnter(self, event):  # wxGlade: ldmStorageFolderViewFrm.<event_handler>
        print("Event handler 'OnShaMbEnter' not implemented!")
        event.Skip()

# end of class ldmStorageFolderViewFrm

class ldmApp(wx.App):
    def OnInit(self):
        global opt
        self.ldmStorageFolderViewFrm = ldmStorageFolderViewFrm(None, wx.ID_ANY, "")
        self.SetTopWindow(self.ldmStorageFolderViewFrm)
        self.ldmStorageFolderViewFrm.Show()
        return True

# end of class ldmApp

def main(args=None):
    # +++++ beg:
    # ----- end:
    
    # +++++ beg:init
    iRet=0
    iVerbose=5                                          # 20190624 wro:set default verbose level
    # ----- end:init
    # +++++ beg:define CLI arguments
    usage = "usage: %prog [options]"
    oParser=OptionParser(usage,version="%prog "+__version__)
    oParser.add_option('-c','--cfgFN',dest='sCfgFN',
            default='ldmStorageFolderViewCfg.json',
            help='configuration file',metavar='pyGatherMDCfg.json',
            )
    oParser.add_option('-l','--log',dest='sLogFN',
            default='./log/ldmStorageFolderView.log',
            help='log filename',metavar='./log/ldmStorageFolderView.log')
    oParser.add_option("-v", action="store_true", dest="verbose", default=True)
    oParser.add_option("-q", action="store_false", dest="verbose", default=True)
    # ----- end:define CLI arguments
    # +++++ beg:parse command line
    (opt,args)=oParser.parse_args(args=args)
    if opt.verbose:
        print("config FN:     %r"%(opt.sCfgFN))
        iVerbose=20
    global gOpt
    gOpt=opt
    # ----- end:parse command line
    # +++++ beg:prepare logging
    if opt.sLogFN is not None:
        import lindworm.logUtil as logUtil
        logUtil.logInit(opt.sLogFN,iLevel=logging.DEBUG)
    # ----- end:prepare logging
    # +++++ beg:
    app = ldmApp(0)
    app.MainLoop()
    iRet+=1
    # ----- end:
    return iRet

if __name__ == "__main__":
    # +++++ beg:call entry point
    main(args=None)
    # ----- end:call entry point
