#!/usr/bin/env python
# -*- coding: UTF-8 -*-
#
# generated by wxGlade 0.9.5 on Thu Apr  2 08:19:01 2020
#
#----------------------------------------------------------------------------
# Name:         ldmStorageFolderFrm.py
# Purpose:      ldmStorageFolderFrm.py
#               GUI for ldmStorageFolder
# Author:       Walter Obweger
#
# Created:      20200402
# CVS-ID:       $Id$
# Copyright:    (c) 2020 by Walter Obweger
# Licence:      MIT
#----------------------------------------------------------------------------


import wx
import os
import logging
import traceback

from optparse import OptionParser

# begin wxGlade: dependencies
# end wxGlade

# begin wxGlade: extracode
# end wxGlade

from lindworm import __version__
import lindworm.ldmGui as ldmGui
from lindworm.ldmGuiThd import ldmGuiThd
from lindworm.ldmStorageFolder import ldmStorageFolder

gOpt=None

class ldmStorageFolderFrm(wx.Frame):
    WILDCARD_JSON=["json file (*.json)|*.json",
            "All files (*.*)|*.*"]
    def __init__(self, *args, **kwds):
        self.__initDat__()
        # begin wxGlade: ldmStorageFolderFrm.__init__
        kwds["style"] = kwds.get("style", 0) | wx.DEFAULT_FRAME_STYLE
        wx.Frame.__init__(self, *args, **kwds)
        self.SetSize((600, 400))
        self.txtSrcDN = wx.TextCtrl(self, wx.ID_ANY, self.sSrcDN)
        self.cbSrcDN = wx.Button(self, wx.ID_ANY, "...")
        self.txtBldDN = wx.TextCtrl(self, wx.ID_ANY, self.sBldDN)
        self.cbBldDN = wx.Button(self, wx.ID_ANY, "...")
        self.txtBldFN = wx.TextCtrl(self, wx.ID_ANY, self.sBldFN)
        self.cbBldFN = wx.Button(self, wx.ID_ANY, "...")
        self.txtCfgFN = wx.TextCtrl(self, wx.ID_ANY, self.sCfgFN)
        self.cbCfgFN = wx.Button(self, wx.ID_ANY, "...")
        self.spnShaMB = wx.SpinCtrl(self, wx.ID_ANY, "1", min=-1, max=64)
        self.chcShaMB = wx.Choice(self, wx.ID_ANY, choices=["disabled", "01 MB", "02 MB", "04 MB", "08 MB", "16 MB", "32 MB", "64 MB", "all data"])
        self.txtPhase = wx.TextCtrl(self, wx.ID_ANY, "")
        self.cbStart = wx.Button(self, wx.ID_ANY, "start")
        self.txtStatus = wx.TextCtrl(self, wx.ID_ANY, "", style=wx.TE_READONLY)
        self.cbStop = wx.Button(self, wx.ID_ANY, "stop")
        self.gagDetail = wx.Gauge(self, wx.ID_ANY, range=1000)
        self.lcrLog = wx.ListCtrl(self, wx.ID_ANY, style=wx.LC_HRULES | wx.LC_REPORT | wx.LC_VRULES)
        self.cbLogClr = wx.Button(self, wx.ID_ANY, "clr")
        self.cbLogSave = wx.Button(self, wx.ID_ANY, "save")
        self.cbUpd = wx.Button(self, wx.ID_ANY, "upd")

        self.__set_properties()
        self.__do_layout()

        self.Bind(wx.EVT_TEXT_ENTER, self.OnSrcDnEnter, self.txtSrcDN)
        self.Bind(wx.EVT_BUTTON, self.OnSrcDN, self.cbSrcDN)
        self.Bind(wx.EVT_TEXT_ENTER, self.OnBldDnEnter, self.txtBldDN)
        self.Bind(wx.EVT_BUTTON, self.OnBldDN, self.cbBldDN)
        self.Bind(wx.EVT_TEXT_ENTER, self.OnBldFnEnter, self.txtBldFN)
        self.Bind(wx.EVT_BUTTON, self.OnBldFN, self.cbBldFN)
        self.Bind(wx.EVT_TEXT_ENTER, self.OnCfgFnEnter, self.txtCfgFN)
        self.Bind(wx.EVT_BUTTON, self.OnCfgFN, self.cbCfgFN)
        self.Bind(wx.EVT_SPINCTRL, self.OnShaMbSpin, self.spnShaMB)
        self.Bind(wx.EVT_TEXT_ENTER, self.OnShaMbEnter, self.spnShaMB)
        self.Bind(wx.EVT_CHOICE, self.OnShaMbChoice, self.chcShaMB)
        self.Bind(wx.EVT_BUTTON, self.OnStart, self.cbStart)
        self.Bind(wx.EVT_BUTTON, self.OnStop, self.cbStop)
        # end wxGlade
        self.oThd=ldmGuiThd(self,rDly=0.2,sLogger='thdGui',iVerbose=0)
        self.oThd.BindEvtNty(self.OnThdNty)

    def __initDat__(self):
        global gOpt
        self.sCfgFN=gOpt.sCfgFN      #"ldmStorageFolderCfg.json"
        self.sSrcDN=gOpt.sSrcDN             #'.'
        self.sBldDN=gOpt.sBldDN             #'.'
        self.sBldFN=gOpt.sBldFN             #None
        self.iShaMB=1
        self.iVerbose=10
        # +++++ beg:
        self.oFld=ldmStorageFolder(iVerbose=self.iVerbose)
        #iRet=oFld.loadCfg(sCfgFN)
        self.oFld.oLog.debug('fin:ldmStorageFolderFrm::__initDat__')
        # ----- end:
    def __set_properties(self):
        # begin wxGlade: ldmStorageFolderFrm.__set_properties
        self.SetTitle("ldmStorageFolder")
        self.txtSrcDN.SetToolTip("source directory name")
        self.txtBldDN.SetToolTip("build directory name")
        self.txtBldFN.SetToolTip("build file name\nempty field uses current time in UTC\n0 uses current local time\n1 uses current time in UTC")
        self.txtCfgFN.SetToolTip("configuration file name")
        self.spnShaMB.SetMinSize((20, -1))
        self.chcShaMB.SetMinSize((20, -1))
        self.chcShaMB.SetToolTip("data size to calculate SHA fingerprint in MBytes")
        self.chcShaMB.SetSelection(1)
        self.txtPhase.SetToolTip("phase")
        self.txtStatus.SetToolTip("status message")
        self.gagDetail.SetMinSize((-1, 7))
        self.lcrLog.AppendColumn("No", format=wx.LIST_FORMAT_LEFT, width=80)
        self.lcrLog.AppendColumn("Info", format=wx.LIST_FORMAT_LEFT, width=250)
        self.lcrLog.AppendColumn("Stat", format=wx.LIST_FORMAT_LEFT, width=30)
        # end wxGlade

    def __do_layout(self):
        # begin wxGlade: ldmStorageFolderFrm.__do_layout
        fgsMain = wx.FlexGridSizer(9, 3, 0, 0)
        sizer_1 = wx.BoxSizer(wx.VERTICAL)
        szShaMB = wx.BoxSizer(wx.HORIZONTAL)
        lblSrcDN = wx.StaticText(self, wx.ID_ANY, "source DN")
        lblSrcDN.SetToolTip("source folder")
        fgsMain.Add(lblSrcDN, 0, 0, 0)
        fgsMain.Add(self.txtSrcDN, 0, wx.EXPAND, 0)
        fgsMain.Add(self.cbSrcDN, 0, 0, 0)
        lblBldDN = wx.StaticText(self, wx.ID_ANY, "build DN")
        fgsMain.Add(lblBldDN, 0, 0, 0)
        fgsMain.Add(self.txtBldDN, 0, wx.EXPAND, 0)
        fgsMain.Add(self.cbBldDN, 0, 0, 0)
        lblBldFN = wx.StaticText(self, wx.ID_ANY, "build FN")
        fgsMain.Add(lblBldFN, 0, 0, 0)
        fgsMain.Add(self.txtBldFN, 0, wx.EXPAND, 0)
        fgsMain.Add(self.cbBldFN, 0, 0, 0)
        lblCfgFN = wx.StaticText(self, wx.ID_ANY, "configuration file")
        fgsMain.Add(lblCfgFN, 0, 0, 0)
        fgsMain.Add(self.txtCfgFN, 0, wx.EXPAND, 0)
        fgsMain.Add(self.cbCfgFN, 0, 0, 0)
        lblShaMB = wx.StaticText(self, wx.ID_ANY, "data for SHA [MB]")
        fgsMain.Add(lblShaMB, 0, 0, 0)
        szShaMB.Add(self.spnShaMB, 1, wx.EXPAND, 0)
        szShaMB.Add(self.chcShaMB, 2, wx.EXPAND, 0)
        fgsMain.Add(szShaMB, 1, wx.EXPAND, 0)
        lblEmpty063 = wx.StaticText(self, wx.ID_ANY, "")
        fgsMain.Add(lblEmpty063, 0, 0, 0)
        lblPhase = wx.StaticText(self, wx.ID_ANY, "phase")
        fgsMain.Add(lblPhase, 0, 0, 0)
        fgsMain.Add(self.txtPhase, 0, wx.EXPAND, 0)
        fgsMain.Add(self.cbStart, 0, 0, 0)
        lblStatus = wx.StaticText(self, wx.ID_ANY, "status")
        fgsMain.Add(lblStatus, 0, 0, 0)
        fgsMain.Add(self.txtStatus, 0, wx.EXPAND, 0)
        fgsMain.Add(self.cbStop, 0, 0, 0)
        lblEmpty = wx.StaticText(self, wx.ID_ANY, "")
        fgsMain.Add(lblEmpty, 0, 0, 0)
        fgsMain.Add(self.gagDetail, 0, wx.EXPAND, 0)
        lblEmpty_copy = wx.StaticText(self, wx.ID_ANY, "")
        fgsMain.Add(lblEmpty_copy, 0, 0, 0)
        lblLog = wx.StaticText(self, wx.ID_ANY, "log")
        fgsMain.Add(lblLog, 0, 0, 0)
        fgsMain.Add(self.lcrLog, 1, wx.EXPAND, 0)
        sizer_1.Add(self.cbLogClr, 0, 0, 0)
        sizer_1.Add(self.cbLogSave, 0, 0, 0)
        sizer_1.Add(self.cbUpd, 0, 0, 0)
        fgsMain.Add(sizer_1, 1, wx.EXPAND, 0)
        self.SetSizer(fgsMain)
        fgsMain.AddGrowableRow(8)
        fgsMain.AddGrowableCol(1)
        self.Layout()
        # end wxGlade

    def OnThdNty(self,evt):
        evt.Skip()
        try:
            # +++++ beg:
            #iSched=evt.oNty.GetSched()
            sStatOfs=evt.oNty.GetStatusOfs()
            iVal=evt.oNty.GetNormalized()
            sPhase=evt.oNty.GetPhase()
            sStatus=evt.oNty.GetStatus()
            self.gagDetail.SetValue(int(iVal))
            self.txtPhase.SetValue(sPhase)
            self.txtStatus.SetValue(sStatus)
            if evt.oNty.IsActive():
                iIdx=self.lcrLog.InsertItem(0,sStatOfs)
                self.lcrLog.SetItem(iIdx,1,sStatus)
            # ----- end:
        except:
            self.oFld.logTB()
    def OnStart(self, event):  # wxGlade: ldmStorageFolderFrm.<event_handler>
        event.Skip()
        try:
            # +++++ beg:initialize
            logging.debug('beg:OnStart')
            iRet=0
            # ----- end:initialize
            # +++++ beg:schedule action
            oNty=self.oThd.GetNty()
            self.oThd.Do('%s'%(self.sSrcDN),
                        self.prcFld,*(),
                        sCfgFN=self.sCfgFN,
                        sSrcDN=self.sSrcDN,
                        sBldFN=self.sBldFN,
                        sBldDN=self.sBldDN,
                        iShaMB=self.iShaMB,
                        oNty=oNty)
            # ----- end:schedule action
            # +++++ beg:finalize
            logging.debug('end:OnStart iRet:%d'%(iRet))
            # ----- end:finalize
            return 1
        except:
            self.oFld.logTB()
    def prcFld(self,sCfgFN=None,sSrcDN=None,
                sBldFN=None,sBldDN=None,
                iShaMB=0,oNty=None):
        try:
            # +++++ beg:initialize
            sOrg='ldmStorageFolderFrm::prcFld'
            self.oFld.logDbg('beg:%s sSrcDN:%s',sOrg,sSrcDN)
            self.oFld.clrAll()
            iRet=self.oFld.loadCfg(self.sCfgFN)
            # ----- end:initialize
            # +++++ beg:register action
            #self.oFld.logDbg('    sSrcDN:%r',sSrcDN)
            iRet=self.oFld.prcBeg(sSrcDN,oRef=None)
            if iRet>0:
                if oNty is not None:
                    oNty.SetPhase('%r ...'%(sSrcDN))
                    oNty.SetStatus('')
                iRet+=1
            else:
                if oNty is not None:
                    oNty.SetPhase('%r skipped. iRet:%d'%(sSrcDN,iRet))
                    oNty.SetStatus('failed start')
                return -1
            # ----- end:register action
            # +++++ beg:perform action
            iRet=self.oFld.prcExc()#(oGtrMD=self)
            if iRet>0:
                if oNty is not None:
                    oNty.SetPhase('%r finalize ...'%(sSrcDN))
            else:
                if oNty is not None:
                    oNty.SetPhase('%r aborted. iRet:%d'%(sSrcDN,iRet))
                    oNty.SetStatus('failed to process')
                return -2
            # ----- end:perform action
            # +++++ beg:finalize action
            self.oFld.logDbg('    %s iShaMB:%r',sOrg,iShaMB)
            iRetFdr=self.oFld.prcEnd(iShaMB=iShaMB,oNty=oNty)
            if iRetFdr>0:
                if oNty is not None:
                    oNty.SetPhase('%r finished.'%(sSrcDN))
                iRet+=1
            else:
                if oNty is not None:
                    oNty.SetPhase('%r aborted. iRet:%d'%(sSrcDN,iRetFdr))
                    oNty.SetStatus('failed to finalize')
            # ----- end:finalize action
            # +++++ beg:save result to json
            if iRetFdr>0:
                self.oFld.logDbg('    %s sBldFN:%r sBldDN:%r sDefEnd:%r',
                            sOrg,sBldFN,sBldDN,self.oFld.sDefEnd)
                if sBldFN is None:
                    sBldFN=None
                else:
                    if len(sBldFN)>0:
                        if sBldFN=='0':
                            sBldFN=0
                        elif sBldFN=='1':
                            sBldFN=1
                    else:
                        sBldFN=None
                iRetSave=self.oFld.saveDat(sBldFN,sDN=sBldDN,
                                    lKey=[self.oFld.sDefEnd],
                                    sAtr='dDat')
                if iRetSave>0:
                    if oNty is not None:
                        oNty.SetStatus('saved')
                    iRet+=1
                else:
                    oNty.SetStatus('save failed iRetSave:%d'%(iRetSave))
            # ----- end:save result to json
            # +++++ beg:
            if oNty is not None:
                oNty.finStatus()
                self.oThd.delay(iCnt=5)
            self.oFld.logDbg('end:%s iRet:%d',sOrg,iRet)
            # ----- end:
            return iRet
        except:
            self.oFld.logTB()
            return -1
    def OnStop(self, event):  # wxGlade: ldmStorageFolderFrm.<event_handler>
        event.Skip()
        try:
            # +++++ beg:
            iRet=0
            sOrg='ldmStorageFolderFrm::OnStop'
            self.oFld.logDbg('beg:%s',sOrg)
            # ----- end:
            self.oThd.Stop()
            # +++++ beg:
            self.oFld.logDbg('end:%s iRet:%d',sOrg,iRet)
            # ----- end:
        except:
            self.oFld.logTB()

    def OnSrcDnEnter(self, event):  # wxGlade: ldmStorageFolderFrm.<event_handler>
        event.Skip()
        try:
            # +++++ beg:get DN
            sSrcDN=self.txtSrcDN.GetValue()
            if os.path.exists(sSrcDN):
                self.sSrcDN=sSrcDN
                self.oFld.log('OnSrcOnEnter sSrcDN:%s ok',sSrcDN)
            else:
                self.oFld.logErr('OnSrcOnEnter sSrcDN:%s does not exist',sSrcDN)
            # ----- end:get DN
        except:
            self.oFld.logTB()
    def OnSrcDN(self, event):  # wxGlade: ldmStorageFolderFrm.<event_handler>
        event.Skip()
        try:
            # +++++ beg:get DN
            sSrcDN=self.txtSrcDN.GetValue()
            iRet,sSrcDN=ldmGui.getDN(sSrcDN,self,
                         'choose source directory')
            if iRet>0:
                self.sSrcDN=sSrcDN
                self.txtSrcDN.SetValue(self.sSrcDN)
                self.oFld.log('fin:OnSrcDN iRet:%d sSrcDN:%s',
                            iRet,sSrcDN)
            # ----- end:get DN
        except:
            self.oFld.logTB()

    def OnBldDnEnter(self, event):  # wxGlade: ldmStorageFolderFrm.<event_handler>
        event.Skip()
        try:
            # +++++ beg:get DN
            sBldDN=self.txtBldDN.GetValue()
            if os.path.exists(sBldDN):
                self.sBldDN=sBldDN
                self.oFld.log('OnBldOnEnter sBldDN:%s ok',sBldDN)
            else:
                self.oFld.logErr('OnBldOnEnter sBldDN:%s does not exist',sBldDN)
            # ----- end:get DN
        except:
            self.oFld.logTB()
    def OnBldDN(self, event):  # wxGlade: ldmStorageFolderFrm.<event_handler>
        event.Skip()
        try:
            # +++++ beg:get DN
            sBldDN=self.txtBldDN.GetValue()
            iRet,sBldDN=ldmGui.getDN(sBldDN,self,
                         'choose build directory')
            if iRet>0:
                self.sBldDN=sBldDN
                self.txtBldDN.SetValue(self.sBldDN)
                self.oFld.log('fin:OnBldDN iRet:%d sBldDN:%s',
                            iRet,sBldDN)
            # ----- end:get DN
        except:
            self.oFld.logTB()

    def OnBldFnEnter(self, event):  # wxGlade: ldmStorageFolderFrm.<event_handler>
        event.Skip()
        try:
            # +++++ beg:get DN
            sBldFN=self.txtBldFN.GetValue()
            self.sBldFN=sBldFN
            self.oFld.log('OnBldFnEnter sBldFN:%s ok',sBldFN)
        except:
            self.oFld.logTB()

    def OnBldFN(self, event):  # wxGlade: ldmStorageFolderFrm.<event_handler>
        event.Skip()
        try:
            # +++++ beg:get DN
            sBldFN=self.txtBldFN.GetValue()
            # ----- end:get DN
            iRet,sBldFN=ldmGui.getFN(sBldFN,self,
                         'choose build file name',
                         lWildCard=self.WILDCARD_JSON,
                         oLog=self.oFld)
            if iRet>0:
                sBldDN,sBldFN=ldmGui.getSplitFN(sBldFN)
                if (sBldDN is not None) and (sBldFN is not None):
                    self.sBldDN,self.sBldFN=sBldDN,sBldFN
                    self.txtBldDN.SetValue(self.sBldDN)
                    self.txtBldFN.SetValue(self.sBldFN)
                    self.oFld.log('fin:OnBldFN iRet:%d sBldFN:%s',
                                iRet,sBldFN)
        except:
            self.oFld.logTB()

    def OnLogFnEnter(self, event):  # wxGlade: ldmStorageFolderFrm.<event_handler>
        print("Event handler 'OnLogFnEnter' not implemented!")
        event.Skip()

    def OnLogFN(self, event):  # wxGlade: ldmStorageFolderFrm.<event_handler>
        print("Event handler 'OnLogFN' not implemented!")
        event.Skip()

    def OnCfgFnEnter(self, event):  # wxGlade: ldmStorageFolderFrm.<event_handler>
        print("Event handler 'OnCfgFnEnter' not implemented!")
        event.Skip()
    def OnCfgFN(self, event):  # wxGlade: ldmStorageFolderFrm.<event_handler>
        event.Skip()
        try:
            sCfgFN=self.txtCfgFN.GetValue()
            iRet,sCfgFN=ldmGui.getFN(sCfgFN,self,
                         'choose configuration file name',
                         lWildCard=self.WILDCARD_JSON,
                         oLog=self.oFld)
            if iRet>0:
                self.sCfgFN=sCfgFN
                self.txtCfgFN.SetValue(self.sCfgFN)
                self.oFld.log('fin:OnCfgFN iRet:%d sCfgFN:%s',
                            iRet,sCfgFN)
        except:
            self.oFld.logTB()

    def OnShaMbChoice(self, event):  # wxGlade: ldmStorageFolderFrm.<event_handler>
        event.Skip()
        try:
            sVal=self.chcShaMB.GetString(self.chcShaMB.GetSelection())
            iIdx=self.chcShaMB.GetSelection()
            self.oFld.logDbg('OnShaMbChoice sVal:%s iIdx:%d',sVal,iIdx)
            if iIdx==0:
                self.spnShaMB.SetValue(0)
                self.iShaMB=0
            elif iIdx==8:
                self.spnShaMB.SetValue(-1)
                self.iShaMB=-1
            elif iIdx==1:
                self.spnShaMB.SetValue(1)
                self.iShaMB=1
            elif iIdx==2:
                self.spnShaMB.SetValue(2)
                self.iShaMB=2
            elif iIdx==3:
                self.spnShaMB.SetValue(4)
                self.iShaMB=4
            elif iIdx==4:
                self.spnShaMB.SetValue(8)
                self.iShaMB=8
            elif iIdx==5:
                self.spnShaMB.SetValue(16)
                self.iShaMB=16
            elif iIdx==6:
                self.spnShaMB.SetValue(32)
                self.iShaMB=32
            elif iIdx==7:
                self.spnShaMB.SetValue(64)
                self.iShaMB=64
        except:
            self.oFld.logTB()

    def OnShaMbSpin(self, event):  # wxGlade: ldmStorageFolderFrm.<event_handler>
        event.Skip()
        try:
            iVal=self.spnShaMB.GetValue()
            self.oFld.logDbg('OnShaMbSpin iVal:%d',iVal)
            self.iShaMB=iVal
            #["disabled", "01 MB", "02 MB", "04 MB", "08 MB", "16 MB", "32 MB", "64 MB", "all data"]
            if iVal==0:
                self.chcShaMB.SetSelection(0)
            elif iVal<0:
                self.chcShaMB.SetSelection(8)
            elif iVal==1:
                self.chcShaMB.SetSelection(1)
            elif iVal==2:
                self.chcShaMB.SetSelection(2)
            elif iVal==4:
                self.chcShaMB.SetSelection(3)
            elif iVal==8:
                self.chcShaMB.SetSelection(4)
            elif iVal==16:
                self.chcShaMB.SetSelection(5)
            elif iVal==32:
                self.chcShaMB.SetSelection(6)
            elif iVal==64:
                self.chcShaMB.SetSelection(7)
            
        except:
            self.oFld.logTB()

    def OnShaMbEnter(self, event):  # wxGlade: ldmStorageFolderFrm.<event_handler>
        print("Event handler 'OnShaMbEnter' not implemented!")
        event.Skip()

# end of class ldmStorageFolderFrm

class ldmApp(wx.App):
    def OnInit(self):
        global opt
        self.ldmStorageFolderFrm = ldmStorageFolderFrm(None, wx.ID_ANY, "")
        self.SetTopWindow(self.ldmStorageFolderFrm)
        self.ldmStorageFolderFrm.Show()
        return True

# end of class ldmApp

def main(args=None):
    # +++++ beg:
    # ----- end:
    
    # +++++ beg:init
    iRet=0
    iVerbose=5                                          # 20190624 wro:set default verbose level
    # ----- end:init
    # +++++ beg:define CLI arguments
    usage = "usage: %prog [options]"
    oParser=OptionParser(usage,version="%prog "+__version__)
    oParser.add_option('-c','--cfgFN',dest='sCfgFN',
            default='ldmStorageFolderCfg.json',
            help='configuration file',metavar='pyGatherMDCfg.json',
            )
    oParser.add_option('','--srcDN',dest='sSrcDN',
            default='./',
            help='source folder',metavar='path/to/folder/to/read',
            )
    oParser.add_option('','--bldDN',dest='sBldDN',
            default='./',
            help='build directory',metavar='path/to/output/folder',
            )
    oParser.add_option('','--bldFN',dest='sBldFN',
            default='',
            help='build file',metavar='sng.json',
            )
    oParser.add_option('-l','--log',dest='sLogFN',
            default='./log/ldmStorageFolder.log',
            help='log filename',metavar='./log/ldmStorageFolder.log')
    oParser.add_option("-v", action="store_true", dest="verbose", default=True)
    oParser.add_option("-q", action="store_false", dest="verbose", default=True)
    # ----- end:define CLI arguments
    # +++++ beg:parse command line
    (opt,args)=oParser.parse_args(args=args)
    if opt.verbose:
        print("config FN:     %r"%(opt.sCfgFN))
        print("source DN:     %r"%(opt.sSrcDN))
        print(" build DN:     %r"%(opt.sBldDN))
        print(" build FN:     %r"%(opt.sBldFN))
        iVerbose=20
    global gOpt
    gOpt=opt
    # ----- end:parse command line
    # +++++ beg:prepare logging
    if opt.sLogFN is not None:
        import lindworm.logUtil as logUtil
        logUtil.logInit(opt.sLogFN,iLevel=logging.DEBUG)
    # ----- end:prepare logging
    # +++++ beg:
    app = ldmApp(0)
    app.MainLoop()
    iRet+=1
    # ----- end:
    return iRet

if __name__ == "__main__":
    # +++++ beg:call entry point
    main(args=None)
    # ----- end:call entry point
