"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnRepository = exports.SecretScanningPushProtectionStatus = exports.SecretScanningStatus = exports.AdvanceSecurityStatus = exports.toJson_SecretScanningPushProtection = exports.toJson_SecretScanning = exports.toJson_AdvanceSecurity = exports.toJson_SecurityAndAnalysis = exports.CfnRepositoryPropsVisibility = exports.toJson_CfnRepositoryProps = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Generated by cdk-import
const cdk = require("aws-cdk-lib");
/**
 * Converts an object of type 'CfnRepositoryProps' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CfnRepositoryProps(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Organization': obj.organization,
        'Name': obj.name,
        'Description': obj.description,
        'Homepage': obj.homepage,
        'Private': obj.private,
        'Visibility': obj.visibility,
        'HasIssues': obj.hasIssues,
        'HasProjects': obj.hasProjects,
        'HasWiki': obj.hasWiki,
        'IsTemplate': obj.isTemplate,
        'TeamId': obj.teamId,
        'AutoInit': obj.autoInit,
        'GitIgnoreTemplate': obj.gitIgnoreTemplate,
        'LicenseTemplate': obj.licenseTemplate,
        'AllowSquashMerge': obj.allowSquashMerge,
        'AllowMergeCommit': obj.allowMergeCommit,
        'AllowRebaseMerge': obj.allowRebaseMerge,
        'AllowAutoMerge': obj.allowAutoMerge,
        'DeleteBranchOnMerge': obj.deleteBranchOnMerge,
        'AllowForking': obj.allowForking,
        'Archived': obj.archived,
        'SecurityAndAnalysis': toJson_SecurityAndAnalysis(obj.securityAndAnalysis),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CfnRepositoryProps = toJson_CfnRepositoryProps;
/* eslint-enable max-len, quote-props */
/**
 * Can be public or private. If your organization is associated with an enterprise account using GitHub Enterprise Cloud or GitHub Enterprise Server 2.20+, visibility can also be internal. Note: For GitHub Enterprise Server and GitHub AE, this endpoint will only list repositories available to all users on the enterprise. For more information, see "Creating an internal repository" (https://docs.github.com/en/repositories/creating-and-managing-repositories/about-repositories#about-internal-repositories) in the GitHub Help documentation.
 *
 * @schema CfnRepositoryPropsVisibility
 */
var CfnRepositoryPropsVisibility;
(function (CfnRepositoryPropsVisibility) {
    /** public */
    CfnRepositoryPropsVisibility["PUBLIC"] = "public";
    /** private */
    CfnRepositoryPropsVisibility["PRIVATE"] = "private";
    /** internal */
    CfnRepositoryPropsVisibility["INTERNAL"] = "internal";
})(CfnRepositoryPropsVisibility = exports.CfnRepositoryPropsVisibility || (exports.CfnRepositoryPropsVisibility = {}));
/**
 * Converts an object of type 'SecurityAndAnalysis' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_SecurityAndAnalysis(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'AdvanceSecurity': toJson_AdvanceSecurity(obj.advanceSecurity),
        'SecretScanning': toJson_SecretScanning(obj.secretScanning),
        'SecretScanningPushProtection': toJson_SecretScanningPushProtection(obj.secretScanningPushProtection),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_SecurityAndAnalysis = toJson_SecurityAndAnalysis;
/**
 * Converts an object of type 'AdvanceSecurity' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_AdvanceSecurity(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Status': obj.status,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_AdvanceSecurity = toJson_AdvanceSecurity;
/**
 * Converts an object of type 'SecretScanning' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_SecretScanning(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Status': obj.status,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_SecretScanning = toJson_SecretScanning;
/**
 * Converts an object of type 'SecretScanningPushProtection' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_SecretScanningPushProtection(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Status': obj.status,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_SecretScanningPushProtection = toJson_SecretScanningPushProtection;
/* eslint-enable max-len, quote-props */
/**
 * Can be enabled or disabled.
 *
 * @schema AdvanceSecurityStatus
 */
var AdvanceSecurityStatus;
(function (AdvanceSecurityStatus) {
    /** enabled */
    AdvanceSecurityStatus["ENABLED"] = "enabled";
    /** disabled */
    AdvanceSecurityStatus["DISABLED"] = "disabled";
})(AdvanceSecurityStatus = exports.AdvanceSecurityStatus || (exports.AdvanceSecurityStatus = {}));
/**
 * Can be enabled or disabled.
 *
 * @schema SecretScanningStatus
 */
var SecretScanningStatus;
(function (SecretScanningStatus) {
    /** enabled */
    SecretScanningStatus["ENABLED"] = "enabled";
    /** disabled */
    SecretScanningStatus["DISABLED"] = "disabled";
})(SecretScanningStatus = exports.SecretScanningStatus || (exports.SecretScanningStatus = {}));
/**
 * Can be enabled or disabled.
 *
 * @schema SecretScanningPushProtectionStatus
 */
var SecretScanningPushProtectionStatus;
(function (SecretScanningPushProtectionStatus) {
    /** enabled */
    SecretScanningPushProtectionStatus["ENABLED"] = "enabled";
    /** disabled */
    SecretScanningPushProtectionStatus["DISABLED"] = "disabled";
})(SecretScanningPushProtectionStatus = exports.SecretScanningPushProtectionStatus || (exports.SecretScanningPushProtectionStatus = {}));
/**
 * A CloudFormation `GitHub::Repositories::Repository`
 *
 * @cloudformationResource GitHub::Repositories::Repository
 * @stability external
 * @link https://github.com/aws-ia/cloudformation-github-resource-providers.git
 */
class CfnRepository extends cdk.CfnResource {
    /**
     * Create a new `GitHub::Repositories::Repository`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnRepository.CFN_RESOURCE_TYPE_NAME, properties: toJson_CfnRepositoryProps(props) });
        this.props = props;
        this.attrOwner = cdk.Token.asString(this.getAtt('Owner'));
        this.attrHtmlUrl = cdk.Token.asString(this.getAtt('HtmlUrl'));
        this.attrGitUrl = cdk.Token.asString(this.getAtt('GitUrl'));
        this.attrDefaultBranch = cdk.Token.asString(this.getAtt('DefaultBranch'));
        this.attrLanguage = cdk.Token.asString(this.getAtt('Language'));
        this.attrForksCount = cdk.Token.asNumber(this.getAtt('ForksCount'));
        this.attrStarsCount = cdk.Token.asNumber(this.getAtt('StarsCount'));
        this.attrWatchersCount = cdk.Token.asNumber(this.getAtt('WatchersCount'));
        this.attrIssuesCount = cdk.Token.asNumber(this.getAtt('IssuesCount'));
    }
}
exports.CfnRepository = CfnRepository;
_a = JSII_RTTI_SYMBOL_1;
CfnRepository[_a] = { fqn: "@cdk-cloudformation/github-repositories-repository.CfnRepository", version: "1.2.0-alpha.7" };
/**
* The CloudFormation resource type name for this resource class.
*/
CfnRepository.CFN_RESOURCE_TYPE_NAME = "GitHub::Repositories::Repository";
//# sourceMappingURL=data:application/json;base64,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