# Generated by Django 3.2.25 on 2024-08-27 12:54

import django.core.serializers.json
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import nautobot.core.models.fields
import nautobot.extras.models.mixins
import nautobot.extras.models.roles
import nautobot.extras.models.statuses
import uuid


class Migration(migrations.Migration):

    dependencies = [
        ('extras', '0106_populate_default_statuses_and_roles_for_contact_associations'),
        ('tenancy', '0009_update_all_charfields_max_length_to_255'),
        ('ipam', '0046_update_all_charfields_max_length_to_255'),
        ('slurpit_nautobot', '0011_slurpitipaddress_ignore_dns_name'),
    ]

    operations = [
        migrations.CreateModel(
            name='SlurpitVLAN',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False, unique=True)),
                ('created', models.DateTimeField(auto_now_add=True, null=True)),
                ('last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('_custom_field_data', models.JSONField(blank=True, default=dict, encoder=django.core.serializers.json.DjangoJSONEncoder)),
                ('vid', models.PositiveSmallIntegerField(validators=[django.core.validators.MinValueValidator(1), django.core.validators.MaxValueValidator(4094)])),
                ('name', models.CharField(blank=True, db_index=True, default='', max_length=255, null=True)),
                ('description', models.CharField(blank=True, max_length=255)),
                ('enable_reconcile', models.BooleanField(default=False)),
                ('ignore_status', models.BooleanField(default=False)),
                ('ignore_vid', models.BooleanField(default=False)),
                ('ignore_role', models.BooleanField(default=False)),
                ('ignore_tenant', models.BooleanField(default=False)),
                ('ignore_description', models.BooleanField(default=False)),
                ('role', nautobot.extras.models.roles.RoleField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='slurpit_vlans', to='extras.role')),
                ('status', nautobot.extras.models.statuses.StatusField(on_delete=django.db.models.deletion.PROTECT, related_name='slurpit_vlans', to='extras.status')),
                ('tags', nautobot.core.models.fields.TagsField(through='extras.TaggedItem', to='extras.Tag')),
                ('tenant', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='slurpit_vlans', to='tenancy.tenant')),
                ('vlan_group', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='slurpit_vlans', to='ipam.vlangroup')),
            ],
            options={
                'verbose_name': 'Slurpit VLAN',
                'verbose_name_plural': 'Slurpit VLANs',
                'ordering': ('vlan_group', 'vid'),
                'unique_together': {('vlan_group', 'vid'), ('vlan_group', 'name')},
            },
            bases=(models.Model, nautobot.extras.models.mixins.DynamicGroupMixin, nautobot.extras.models.mixins.NotesMixin),
        ),
    ]
