# Generated by Django 3.2.25 on 2024-06-04 07:10

import django.core.serializers.json
from django.db import migrations, models
import django.db.models.deletion
import nautobot.core.models.fields
import nautobot.extras.models.mixins
import nautobot.extras.models.roles
import nautobot.extras.models.statuses
import nautobot.ipam.fields
import nautobot.ipam.models
import uuid


class Migration(migrations.Migration):

    dependencies = [
        ('ipam', '0046_update_all_charfields_max_length_to_255'),
        ('extras', '0106_populate_default_statuses_and_roles_for_contact_associations'),
        ('tenancy', '0009_update_all_charfields_max_length_to_255'),
        ('slurpit_nautobot', '0004_slurpitinterface_enable_reconcile'),
    ]

    operations = [
        migrations.CreateModel(
            name='SlurpitPrefix',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False, unique=True)),
                ('created', models.DateTimeField(auto_now_add=True, null=True)),
                ('last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('_custom_field_data', models.JSONField(blank=True, default=dict, encoder=django.core.serializers.json.DjangoJSONEncoder)),
                ('network', nautobot.ipam.fields.VarbinaryIPField(db_index=True, null=True)),
                ('broadcast', nautobot.ipam.fields.VarbinaryIPField(db_index=True, null=True)),
                ('prefix_length', models.IntegerField(db_index=True, null=True)),
                ('type', models.CharField(default='network', max_length=50)),
                ('ip_version', models.IntegerField(db_index=True, editable=False, null=True)),
                ('enable_reconcile', models.BooleanField(default=False)),
                ('date_allocated', models.DateTimeField(blank=True, null=True)),
                ('description', models.CharField(blank=True, max_length=255)),
                ('namespace', models.ForeignKey(default=nautobot.ipam.models.get_default_namespace_pk, on_delete=django.db.models.deletion.PROTECT, related_name='slurpit_prefixes', to='ipam.namespace')),
                ('parent', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='slurpit_children', to='slurpit_nautobot.slurpitprefix')),
                ('rir', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='slurpit_prefixes', to='ipam.rir')),
                ('role', nautobot.extras.models.roles.RoleField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='slurpit_prefixes', to='extras.role')),
                ('status', nautobot.extras.models.statuses.StatusField(on_delete=django.db.models.deletion.PROTECT, related_name='slurpit_prefixes', to='extras.status')),
                ('tags', nautobot.core.models.fields.TagsField(through='extras.TaggedItem', to='extras.Tag')),
                ('tenant', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='slurpit_prefixes', to='tenancy.tenant')),
                ('vlan', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='slurpit_prefixes', to='ipam.vlan')),
            ],
            options={
                'verbose_name_plural': 'Slurpit prefixes',
                'ordering': ('namespace', 'ip_version', 'network', 'prefix_length'),
                'unique_together': {('namespace', 'network', 'prefix_length')},
                'index_together': {('network', 'broadcast', 'prefix_length'), ('namespace', 'network', 'broadcast', 'prefix_length')},
            },
            bases=(models.Model, nautobot.extras.models.mixins.DynamicGroupMixin, nautobot.extras.models.mixins.NotesMixin),
        ),
    ]
