# Generated by Django 3.2.25 on 2024-06-04 03:05

import django.core.serializers.json
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import nautobot.core.models.fields
import nautobot.core.models.ordering
import nautobot.core.models.query_functions
import nautobot.extras.models.mixins
import slurpit_nautobot.models.interface
import uuid


class Migration(migrations.Migration):

    dependencies = [
        ('dcim', '0058_controller_data_migration'),
        ('ipam', '0046_update_all_charfields_max_length_to_255'),
        ('extras', '0106_populate_default_statuses_and_roles_for_contact_associations'),
        ('contenttypes', '0002_remove_content_type_name'),
        ('slurpit_nautobot', '0002_auto_20240603_0415'),
    ]

    operations = [
        migrations.CreateModel(
            name='SlurpitInterface',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False, unique=True)),
                ('created', models.DateTimeField(auto_now_add=True, null=True)),
                ('last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('_custom_field_data', models.JSONField(blank=True, default=dict, encoder=django.core.serializers.json.DjangoJSONEncoder)),
                ('label', models.CharField(blank=True, max_length=255)),
                ('description', models.CharField(blank=True, max_length=255)),
                ('_cable_peer_id', models.UUIDField(blank=True, null=True)),
                ('mac_address', nautobot.core.models.fields.MACAddressCharField(blank=True, default='')),
                ('mtu', models.PositiveIntegerField(blank=True, null=True, validators=[django.core.validators.MinValueValidator(1), django.core.validators.MaxValueValidator(65536)])),
                ('mode', models.CharField(blank=True, max_length=50)),
                ('enabled', models.BooleanField(default=True)),
                ('name', models.CharField(blank=True, db_index=True, max_length=255)),
                ('_name', nautobot.core.models.fields.NaturalOrderingField('name', blank=True, db_index=True, max_length=255, naturalize_function=nautobot.core.models.ordering.naturalize_interface)),
                ('type', models.CharField(max_length=50)),
                ('mgmt_only', models.BooleanField(default=False)),
                ('_cable_peer_type', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='contenttypes.contenttype')),
                ('_path', nautobot.core.models.fields.ForeignKeyWithAutoRelatedName(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='slurpit_device_interface', to='dcim.cablepath')),
                ('bridge', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='bridged_interfaces', to='slurpit_nautobot.slurpitinterface')),
                ('cable', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='dcim.cable')),
                ('device', nautobot.core.models.fields.ForeignKeyWithAutoRelatedName(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='slurpit_device_interface', to='dcim.device')),
                ('lag', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='slurpit_member_interfaces', to='slurpit_nautobot.slurpitinterface')),
                ('parent_interface', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='child_interfaces', to='slurpit_nautobot.slurpitinterface')),
                ('status', slurpit_nautobot.models.interface.InterfaceStatusField(on_delete=django.db.models.deletion.PROTECT, related_name='slurpit_device_interface', to='extras.status')),
                ('tagged_vlans', models.ManyToManyField(blank=True, related_name='slurpit_interfaces_as_tagged', to='ipam.VLAN')),
                ('tags', nautobot.core.models.fields.TagsField(through='extras.TaggedItem', to='extras.Tag')),
                ('untagged_vlan', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='slurpit_interfaces_as_untagged', to='ipam.vlan')),
                ('vrf', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='slurpit_interfaces', to='ipam.vrf')),
            ],
            options={
                'verbose_name': 'Slurpit Interface',
                'verbose_name_plural': 'Slurpit Device Interface',
                'ordering': ('device', nautobot.core.models.query_functions.CollateAsChar('_name')),
                'unique_together': {('device', 'name')},
            },
            bases=(models.Model, nautobot.extras.models.mixins.DynamicGroupMixin, nautobot.extras.models.mixins.NotesMixin),
        ),
    ]
