# Generated by Django 3.2.25 on 2024-06-03 02:20

import django.core.serializers.json
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import nautobot.core.models.fields
import nautobot.extras.models.mixins
import nautobot.ipam.fields
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('ipam', '0046_update_all_charfields_max_length_to_255'),
        ('dcim', '0058_controller_data_migration'),
        ('tenancy', '0009_update_all_charfields_max_length_to_255'),
        ('extras', '0106_populate_default_statuses_and_roles_for_contact_associations'),
    ]

    operations = [
        migrations.CreateModel(
            name='SlurpitLog',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False, unique=True)),
                ('log_time', models.DateTimeField(auto_now=True)),
                ('level', models.CharField(default='default', editable=False, max_length=100)),
                ('category', models.CharField(default='init', editable=False, max_length=50)),
                ('message', models.CharField(max_length=200)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='SlurpitSnapshot',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False, unique=True)),
                ('created', models.DateTimeField(auto_now_add=True, null=True)),
                ('last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('_custom_field_data', models.JSONField(blank=True, default=dict, encoder=django.core.serializers.json.DjangoJSONEncoder)),
                ('hostname', models.CharField(max_length=255)),
                ('planning_id', models.BigIntegerField()),
                ('content', models.JSONField()),
                ('result_type', models.CharField(default='template_result', max_length=255)),
                ('tags', nautobot.core.models.fields.TagsField(through='extras.TaggedItem', to='extras.Tag')),
            ],
            options={
                'abstract': False,
            },
            bases=(models.Model, nautobot.extras.models.mixins.DynamicGroupMixin, nautobot.extras.models.mixins.NotesMixin),
        ),
        migrations.CreateModel(
            name='SlurpitSetting',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False, unique=True)),
                ('created', models.DateTimeField(auto_now_add=True, null=True)),
                ('last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('_custom_field_data', models.JSONField(blank=True, default=dict, encoder=django.core.serializers.json.DjangoJSONEncoder)),
                ('server_url', models.CharField(max_length=200)),
                ('api_key', models.CharField(editable=False, max_length=50)),
                ('last_synced', models.DateTimeField(auto_now=True, null=True)),
                ('connection_status', models.CharField(default='', editable=False, max_length=50, null=True)),
                ('push_api_key', models.CharField(editable=False, max_length=200, null=True)),
                ('appliance_type', models.CharField(blank=True, max_length=50)),
                ('tags', nautobot.core.models.fields.TagsField(through='extras.TaggedItem', to='extras.Tag')),
            ],
            options={
                'verbose_name': 'setting',
                'verbose_name_plural': 'setting',
            },
            bases=(models.Model, nautobot.extras.models.mixins.DynamicGroupMixin, nautobot.extras.models.mixins.NotesMixin),
        ),
        migrations.CreateModel(
            name='SlurpitPlanning',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False, unique=True)),
                ('created', models.DateTimeField(auto_now_add=True, null=True)),
                ('last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('_custom_field_data', models.JSONField(blank=True, default=dict, encoder=django.core.serializers.json.DjangoJSONEncoder)),
                ('name', models.CharField(max_length=255, unique=True)),
                ('planning_id', models.BigIntegerField(unique=True)),
                ('selected', models.BooleanField(default=False)),
                ('comments', models.TextField(blank=True)),
                ('tags', nautobot.core.models.fields.TagsField(through='extras.TaggedItem', to='extras.Tag')),
            ],
            options={
                'abstract': False,
            },
            bases=(models.Model, nautobot.extras.models.mixins.DynamicGroupMixin, nautobot.extras.models.mixins.NotesMixin),
        ),
        migrations.CreateModel(
            name='SlurpitMapping',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False, unique=True)),
                ('created', models.DateTimeField(auto_now_add=True, null=True)),
                ('last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('_custom_field_data', models.JSONField(blank=True, default=dict, encoder=django.core.serializers.json.DjangoJSONEncoder)),
                ('source_field', models.CharField(max_length=255, unique=True)),
                ('target_field', models.CharField(max_length=255)),
                ('mapping_type', models.CharField(default='', max_length=255)),
                ('tags', nautobot.core.models.fields.TagsField(through='extras.TaggedItem', to='extras.Tag')),
            ],
            options={
                'abstract': False,
            },
            bases=(models.Model, nautobot.extras.models.mixins.DynamicGroupMixin, nautobot.extras.models.mixins.NotesMixin),
        ),
        migrations.CreateModel(
            name='SlurpitStagedDevice',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False, unique=True)),
                ('created', models.DateTimeField(auto_now_add=True, null=True)),
                ('last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('_custom_field_data', models.JSONField(blank=True, default=dict, encoder=django.core.serializers.json.DjangoJSONEncoder)),
                ('slurpit_id', models.BigIntegerField(unique=True)),
                ('disabled', models.BooleanField(default=False)),
                ('hostname', models.CharField(max_length=255, unique=True)),
                ('fqdn', models.CharField(max_length=128)),
                ('ipv4', models.CharField(max_length=23, null=True)),
                ('device_os', models.CharField(max_length=128)),
                ('device_type', models.CharField(max_length=255)),
                ('brand', models.CharField(max_length=255)),
                ('createddate', models.DateTimeField()),
                ('changeddate', models.DateTimeField()),
                ('tags', nautobot.core.models.fields.TagsField(through='extras.TaggedItem', to='extras.Tag')),
            ],
            options={
                'verbose_name': 'device',
                'verbose_name_plural': 'device',
                'ordering': ('hostname',),
                'unique_together': {('hostname',)},
            },
            bases=(models.Model, nautobot.extras.models.mixins.DynamicGroupMixin, nautobot.extras.models.mixins.NotesMixin),
        ),
        migrations.CreateModel(
            name='SlurpitIPAddress',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False, unique=True)),
                ('created', models.DateTimeField(auto_now_add=True, null=True)),
                ('last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('_custom_field_data', models.JSONField(blank=True, default=dict, encoder=django.core.serializers.json.DjangoJSONEncoder)),
                ('host', nautobot.ipam.fields.VarbinaryIPField(db_index=True, null=True)),
                ('mask_length', models.IntegerField(db_index=True, null=True)),
                ('type', models.CharField(default='host', max_length=50)),
                ('status', models.CharField(default='active', max_length=50)),
                ('role', models.CharField(default='loopback', max_length=50)),
                ('ip_version', models.IntegerField(db_index=True, editable=False, null=True)),
                ('dns_name', models.CharField(blank=True, db_index=True, max_length=255, validators=[django.core.validators.RegexValidator(code='invalid', message='Only alphanumeric characters, hyphens, periods, and underscores are allowed in DNS names', regex='^[0-9A-Za-z._-]+$')])),
                ('enable_reconcile', models.BooleanField(default=False)),
                ('description', models.CharField(blank=True, max_length=255)),
                ('namespace', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='slurpit_ip_namespace', to='ipam.namespace')),
                ('tags', nautobot.core.models.fields.TagsField(through='extras.TaggedItem', to='extras.Tag')),
                ('tenant', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='slurpit_ip_addresses', to='tenancy.tenant')),
            ],
            options={
                'verbose_name': 'Slurpit IP address',
                'verbose_name_plural': 'Slurpit IP addresses',
                'ordering': ('ip_version', 'host', 'mask_length'),
                'unique_together': {('host',)},
            },
            bases=(models.Model, nautobot.extras.models.mixins.DynamicGroupMixin, nautobot.extras.models.mixins.NotesMixin),
        ),
        migrations.CreateModel(
            name='SlurpitImportedDevice',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False, unique=True)),
                ('created', models.DateTimeField(auto_now_add=True, null=True)),
                ('last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('_custom_field_data', models.JSONField(blank=True, default=dict, encoder=django.core.serializers.json.DjangoJSONEncoder)),
                ('slurpit_id', models.BigIntegerField(unique=True)),
                ('disabled', models.BooleanField(default=False)),
                ('hostname', models.CharField(max_length=255, unique=True)),
                ('fqdn', models.CharField(max_length=128)),
                ('ipv4', models.CharField(max_length=23, null=True)),
                ('device_os', models.CharField(max_length=128)),
                ('device_type', models.CharField(max_length=255)),
                ('brand', models.CharField(max_length=255)),
                ('createddate', models.DateTimeField()),
                ('changeddate', models.DateTimeField()),
                ('mapped_device', models.OneToOneField(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='slurpit_imported_devices', to='dcim.device')),
                ('mapped_devicetype', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='slurpit_imported_devices', to='dcim.devicetype')),
                ('tags', nautobot.core.models.fields.TagsField(through='extras.TaggedItem', to='extras.Tag')),
            ],
            options={
                'verbose_name': 'device',
                'verbose_name_plural': 'device',
                'ordering': ('hostname',),
                'unique_together': {('hostname',)},
            },
            bases=(models.Model, nautobot.extras.models.mixins.DynamicGroupMixin, nautobot.extras.models.mixins.NotesMixin),
        ),
    ]
