# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Exception Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.ucb
# Libre Office Version: 7.2
from typing_extensions import Literal
from ooo.oenv.env_const import UNO_NONE
import typing
from ..uno.exception import Exception as Exception_85530a09
from ..uno.x_interface import XInterface as XInterface_8f010a43

class UnsupportedNameClashException(Exception_85530a09):
    """
    Exception Class

    This exception must be thrown in case the requested name clash directive is not supported, because it is not possible to implement it or if it is just not (yet) implemented.
    
    Command \"transfer\": Used if the name clash directive specified in parameter NameClash of the supplied TransferInfo is not supported. For example, if the NameClash was set to NameClash.ERROR, to NameClash.RENAME or to NameClash.ASK, the implementation must be able determine whether there are existing data. This exception must also be used if NameClash.RENAME was specified and the implementation is unable to create a valid new name after a suitable number of tries.
    
    Command \"insert\": Used if the parameter ReplaceExisting of the supplied InsertCommandArgument was set to FALSE and the implementation is unable to determine whether there are existing data. The member NameClash of the exception must be set to NameClash.ERROR

    See Also:
        `API UnsupportedNameClashException <https://api.libreoffice.org/docs/idl/ref/exceptioncom_1_1sun_1_1star_1_1ucb_1_1UnsupportedNameClashException.html>`_
    """

    typeName: Literal['com.sun.star.ucb.UnsupportedNameClashException']

    def __init__(self, Message: typing.Optional[str] = ..., Context: typing.Optional[XInterface_8f010a43] = ..., NameClash: typing.Optional[int] = ...) -> None:
        """
        Constructor

        Arguments:
            Message (str, optional): Message value.
            Context (XInterface, optional): Context value.
            NameClash (int, optional): NameClash value.
        """
    @property
    def NameClash(self) -> int:
        """
        contains the NameClash that is not supported.
        """


__all__ = ['UnsupportedNameClashException']

