# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Enum Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.sheet
# Libre Office Version: 7.2
from typing_extensions import Literal
from enum import Enum


class FilterOperator(Enum):
    """
    Enum Class

    

    See Also:
        `API FilterOperator <https://api.libreoffice.org/docs/idl/ref/namespacecom_1_1sun_1_1star_1_1sheet.html#af9e5fd8fd26fc252748d97ebd68ea6b1>`_
    """
    BOTTOM_PERCENT: Literal['BOTTOM_PERCENT']
    """
    selects a specified percentage of entries with the lowest values.
    """
    BOTTOM_VALUES: Literal['BOTTOM_VALUES']
    """
    selects a specified number of entries with the lowest values.
    """
    EMPTY: Literal['EMPTY']
    """
    selects empty entries.
    """
    EQUAL: Literal['EQUAL']
    """
    value has to be equal to the specified value.
    
    The cell value is equal to the specified value.
    """
    GREATER: Literal['GREATER']
    """
    the value has to be greater than the specified value.
    
    value has to be greater than the specified value.
    """
    GREATER_EQUAL: Literal['GREATER_EQUAL']
    """
    the value has to be greater than or equal to the specified value.
    
    The cell value is greater or equal to the specified value.
    
    value has to be greater than or equal to the specified value.
    """
    LESS: Literal['LESS']
    """
    the value has to be less than the specified value.
    
    value has to be less than the specified value.
    """
    LESS_EQUAL: Literal['LESS_EQUAL']
    """
    the value has to be less than or equal to the specified value.
    
    The cell value is less or equal to the specified value.
    
    value has to be less than or equal to the specified value.
    """
    NOT_EMPTY: Literal['NOT_EMPTY']
    """
    selects non-empty entries.
    """
    NOT_EQUAL: Literal['NOT_EQUAL']
    """
    the value must not be equal to the specified value.
    
    value must not be equal to the specified value.
    """
    TOP_PERCENT: Literal['TOP_PERCENT']
    """
    selects a specified percentage of entries with the greatest values.
    """
    TOP_VALUES: Literal['TOP_VALUES']
    """
    selects a specified number of entries with the greatest values.
    """

__all__ = ['FilterOperator']

