# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Const Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.2
# Namespace: com.sun.star.sheet
from typing_extensions import Literal


class DataPilotOutputRangeType:
    """
    Const Class

    specifies region type of DataPilot table range
    
    This constant set is used to indicate the type of output range desired when XDataPilotTable2.getOutputRangeByType() is called, which returns a different cell range depending upon the value passed to it as the argument.
    
    **since**
    
        OOo 3.0

    See Also:
        `API DataPilotOutputRangeType <https://api.libreoffice.org/docs/idl/ref/namespacecom_1_1sun_1_1star_1_1sheet_1_1DataPilotOutputRangeType.html>`_
    """
    WHOLE: Literal[0]
    """
    whole DataPilot output range including the header area above the table where the filter and page field buttons are located.
    """
    TABLE: Literal[1]
    """
    whole table but without the header area where the filter and page field buttons are located.
    """
    RESULT: Literal[2]
    """
    result area where the result values are displayed.
    
    This also includes the column and row subtotal areas when they are displayed.
    """

__all__ = ['DataPilotOutputRangeType']
