# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Service Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.2
# Namespace: com.sun.star.sdbcx
from ..beans.x_property_set import XPropertySet as XPropertySet_bc180bfa
from .x_alter_table import XAlterTable as XAlterTable_af4d0b54
from .x_columns_supplier import XColumnsSupplier as XColumnsSupplier_f0600da9
from .x_data_descriptor_factory import XDataDescriptorFactory as XDataDescriptorFactory_46170fe5
from .x_indexes_supplier import XIndexesSupplier as XIndexesSupplier_efa30d98
from .x_keys_supplier import XKeysSupplier as XKeysSupplier_c8a70c64
from .x_rename import XRename as XRename_848c09cc

class Table(XPropertySet_bc180bfa, XAlterTable_af4d0b54, XColumnsSupplier_f0600da9, XDataDescriptorFactory_46170fe5, XIndexesSupplier_efa30d98, XKeysSupplier_c8a70c64, XRename_848c09cc):
    """
    Service Class

    used to specify a table in a database.
    
    A table is described by its name and one or more columns.
    
    In addition, it may contain indexes to improve the performance in the retrieval of the table's data and keys, and to define semantic rules for the table.
    
    Note:  All properties and columns of a table could by modified before it is appended to a database. In that case, the service is in fact a descriptor. On existing tables, a user might alter columns, add or delete columns, indexes, and keys depending on the capabilities of the database and on the user's privileges.

    See Also:
        `API Table <https://api.libreoffice.org/docs/idl/ref/servicecom_1_1sun_1_1star_1_1sdbcx_1_1Table.html>`_
    """
    @property
    def CatalogName(self) -> str:
        """
        is the name of the table catalog.
        """
    @property
    def Description(self) -> str:
        """
        supplies a comment on the table.
        
        Could be empty, if not supported by the driver.
        """
    @property
    def Name(self) -> str:
        """
        is the name of the table.
        """
    @property
    def SchemaName(self) -> str:
        """
        is the name of the table schema.
        """
    @property
    def Type(self) -> str:
        """
        indicates the type of the table like (TABLE, VIEW, SYSTEM TABLE).
        
        Could be empty, if not supported by the driver.
        """


