# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Struct Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.script
# Libre Office Version: 7.2
from typing_extensions import Literal
import typing


class ContextInformation(object):
    """
    Struct Class

    provides information about a certain stack frame.
    
    .. deprecated::
    
        Class is deprecated.

    See Also:
        `API ContextInformation <https://api.libreoffice.org/docs/idl/ref/structcom_1_1sun_1_1star_1_1script_1_1ContextInformation.html>`_
    """
    typeName: Literal['com.sun.star.script.ContextInformation']

    def __init__(self, LocalVariableNames: typing.Optional[typing.Tuple[str, ...]] = ..., Name: typing.Optional[str] = ..., SourceCode: typing.Optional[str] = ..., StartLine: typing.Optional[int] = ..., StartColumn: typing.Optional[int] = ..., EndLine: typing.Optional[int] = ..., EndColumn: typing.Optional[int] = ...) -> None:
        """
        Constructor

        Arguments:
            LocalVariableNames (typing.Tuple[str, ...], optional): LocalVariableNames value.
            Name (str, optional): Name value.
            SourceCode (str, optional): SourceCode value.
            StartLine (int, optional): StartLine value.
            StartColumn (int, optional): StartColumn value.
            EndLine (int, optional): EndLine value.
            EndColumn (int, optional): EndColumn value.
        """


    @property
    def LocalVariableNames(self) -> typing.Tuple[str, ...]:
        """
        Get all names of the local variable in this context.
        """


    @property
    def Name(self) -> str:
        """
        Full qualified name to address the module or function associated with the context.
        
        If the module or function can't be addressed by name, e.g., in case that a runtime generated eval-module is executed, this string is empty
        """


    @property
    def SourceCode(self) -> str:
        """
        Source code of the Module, that is associated with the context.
        
        If the source can be accessed using the ModuleName or if the source is unknown (executing compiled code) this string can be empty.
        """


    @property
    def StartLine(self) -> int:
        """
        contains the first line in the module's source code associated with the context.
        
        If \"name\" addresses a function, all line and column values are nevertheless given relative to the module's source. If source code is not available, this value addresses a binary position in the compiled code.
        """


    @property
    def StartColumn(self) -> int:
        """
        contains the first column in the StartLine associated with the context.
        """


    @property
    def EndLine(self) -> int:
        """
        contains the last line in the module's source code associated with the context.
        """


    @property
    def EndColumn(self) -> int:
        """
        contains the first column in the EndLine that is NOT associated with the context.
        """



__all__ = ['ContextInformation']
