# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Interface Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.2
# Namespace: com.sun.star.packages.manifest
from typing_extensions import Literal
import typing
from ...uno.x_interface import XInterface as XInterface_8f010a43
if typing.TYPE_CHECKING:
    from ...beans.property_value import PropertyValue as PropertyValue_c9610c73
    from ...io.x_output_stream import XOutputStream as XOutputStream_a4e00b35

class XManifestWriter(XInterface_8f010a43):
    """
    This interface writes the manifest data to a file.
    
    The user calls writeManifestSequence() with the XOutputStream to write the data to and the sequence of manifest entries to be written passed as parameters. Each manifest entry is represented by a sequence of PropertyValues.

    See Also:
        `API XManifestWriter <https://api.libreoffice.org/docs/idl/ref/interfacecom_1_1sun_1_1star_1_1packages_1_1manifest_1_1XManifestWriter.html>`_
    """
    __pyunointerface__: Literal['com.sun.star.packages.manifest.XManifestWriter']

    def writeManifestSequence(self, rStream: 'XOutputStream_a4e00b35', rSequence: 'typing.Tuple[typing.Tuple[PropertyValue_c9610c73, ...], ...]') -> None:
        """
        Writes the supplied sequence of manifest entries to the supplied XOutputStream.
        """

__all__ = ['XManifestWriter']

