# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Interface Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.2
# Namespace: com.sun.star.lang
from typing_extensions import Literal
import typing
from ..uno.x_interface import XInterface as XInterface_8f010a43
if typing.TYPE_CHECKING:
    from ..uno.x_component_context import XComponentContext as XComponentContext_e2e10d4a

class XMultiComponentFactory(XInterface_8f010a43):
    """
    Factory interface for creating component instances giving a context from which to retrieve deployment values.

    See Also:
        `API XMultiComponentFactory <https://api.libreoffice.org/docs/idl/ref/interfacecom_1_1sun_1_1star_1_1lang_1_1XMultiComponentFactory.html>`_
    """
    __pyunointerface__: Literal['com.sun.star.lang.XMultiComponentFactory']

    def createInstanceWithArgumentsAndContext(self, ServiceSpecifier: str, Arguments: 'typing.Tuple[object, ...]', Context: 'XComponentContext_e2e10d4a') -> 'XInterface_8f010a43':
        """
        Creates an instance of a component which supports the services specified by the factory, and initializes the new instance with the given arguments and context.

        Raises:
            com.sun.star.uno.Exception: ``Exception``
        """
    def createInstanceWithContext(self, aServiceSpecifier: str, Context: 'XComponentContext_e2e10d4a') -> 'XInterface_8f010a43':
        """
        Creates an instance of a component which supports the services specified by the factory.

        Raises:
            com.sun.star.uno.Exception: ``Exception``
        """
    def getAvailableServiceNames(self) -> 'typing.Tuple[str, ...]':
        """
        Gets the names of all supported services.
        """

__all__ = ['XMultiComponentFactory']

