# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Const Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.2
# Namespace: com.sun.star.awt
from typing_extensions import Literal


class MessageBoxResults:
    """
    Const Class

    These constants are used to specify a result of executing a XMessageBox.
    
    **since**
    
        LibreOffice 4.2

    See Also:
        `API MessageBoxResults <https://api.libreoffice.org/docs/idl/ref/namespacecom_1_1sun_1_1star_1_1awt_1_1MessageBoxResults.html>`_
    """
    CANCEL: Literal[0]
    """
    The user canceled the XMessageBox, by pressing \"Cancel\" or \"Abort\" button.
    """
    OK: Literal[1]
    """
    The user pressed the \"Ok\" button.
    """
    YES: Literal[2]
    """
    The user pressed the \"Yes\" button.
    """
    NO: Literal[3]
    """
    The user pressed the \"No\" button.
    """
    RETRY: Literal[4]
    """
    The user pressed the \"Retry\" button.
    """
    IGNORE: Literal[5]
    """
    The user pressed the \"Ignore\" button.
    """

__all__ = ['MessageBoxResults']
