# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Struct Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.animations
# Libre Office Version: 7.2
from typing_extensions import Literal
import typing
from ..beans.named_value import NamedValue as NamedValue_a37a0af3


class TargetProperties(object):
    """
    Struct Class

    Properties of an animated target.
    
    This struct collects all global attributes that apply to an animation target. An animation target is anything that is referenced from a given XAnimationNode tree as a target object.

    See Also:
        `API TargetProperties <https://api.libreoffice.org/docs/idl/ref/structcom_1_1sun_1_1star_1_1animations_1_1TargetProperties.html>`_
    """
    typeName: Literal['com.sun.star.animations.TargetProperties']

    def __init__(self, Properties: typing.Optional[typing.Tuple[NamedValue_a37a0af3, ...]] = ..., Target: typing.Optional[object] = ...) -> None:
        """
        Constructor

        Arguments:
            Properties (typing.Tuple[NamedValue, ...], optional): Properties value.
            Target (object, optional): Target value.
        """


    @property
    def Properties(self) -> typing.Tuple[NamedValue_a37a0af3, ...]:
        """
        Global target properties.
        """


    @property
    def Target(self) -> object:
        """
        Target for which this struct specifies properties.
        """



__all__ = ['TargetProperties']
