from collections.abc import Generator
from typing import Any, TypeVar
from typing import Generator as DeprecatedGenerator  # noqa: UP035

from bluesky.utils import Msg, MsgGenerator
from tests.unit_tests.core.fake_util_module import (
    OtherMsgGenerator,
    OtherParametrizedMsgGenerator,
)

PlanReturningStr = MsgGenerator[str]
T = TypeVar("T")


# Valid plans
def plan_a(a: int) -> MsgGenerator: ...
def plan_b(b: str) -> MsgGenerator[None]: ...
def plan_c(c: bool) -> MsgGenerator[int]: ...
def plan_d(d: int) -> Generator[Msg, None, Any]: ...
def plan_e(e: str) -> Generator[Msg, int, Any]: ...
def plan_f(f: bool) -> PlanReturningStr: ...
def plan_g(g: T) -> MsgGenerator[T]: ...
def plan_h(h: int) -> DeprecatedGenerator[Msg, None, Any]: ...
def plan_i(i: str) -> DeprecatedGenerator[Msg, int, Any]: ...
def plan_j(j: int) -> Generator[Msg, int]: ...
def plan_k(k: str) -> Generator[Msg]: ...
def plan_l(a: str) -> OtherMsgGenerator: ...
def plan_m(m: int) -> OtherParametrizedMsgGenerator: ...
def plan_n(n: bool) -> OtherParametrizedMsgGenerator[int]: ...


# Not plans
def util_1() -> int: ...
def util_2() -> None: ...
def util_3(a: str) -> str: ...
def util_4(b: str) -> Generator[int]: ...
def util_5(c: str) -> Generator: ...
def util_6(d: str) -> Generator[int, Msg]: ...
def util_7(e: str) -> Generator[int, None, Msg]: ...
