# ```lasertram```

Welcome to the repository for `lasertram`, a package for the time resolved analysis for processing laser ablation inductively coupled plasma mass spectrometry (LA-ICP-MS) data. It is used for back-end calculations in the dashboard [LaserTRAM-DB](https://github.com/jlubbersgeo/laserTRAM-DB).

## Documentation

please see the [Documentation](https://jlubbersgeo.github.io/lasertram/) for more!

## Installation
[![PyPI](https://img.shields.io/pypi/v/lasertram.svg?style=flat)](https://pypi.python.org/pypi/lasertram)
[![Compatible Python Versions](https://img.shields.io/pypi/pyversions/lasertram.svg?style=flat)](https://pypi.org/project/lasertram/)
```
pip install lasertram
```

## Contributing

If you have features you'd like to see please open an issue or consider contributing yourself! I'm always happy to have help.

**Maintainer** Jordan Lubbers (jlubbers _at_ usgs.gov)

## Citation

The math, logic, and structure of `lasertram` is now published in _Applied Computing and Geosciences_: [`lasertram`: A Python library for time resolved analysis of laser ablation inductively coupled plasma mass spectrometry data](https://doi.org/10.1016/j.acags.2025.100225)

Here's a bib entry for you:

```tex
@article{lubbers2025lasertram,
  title={lasertram: A Python library for time resolved analysis of laser ablation inductively coupled plasma mass spectrometry data},
  author={Lubbers, Jordan and Kent, Adam JR and Russo, Chris},
  journal={Applied Computing and Geosciences},
  pages={100225},
  year={2025},
  publisher={Elsevier},
  doi={10.1016/j.acags.2025.100225}
}
```

To cite this specific version of code (v1.0.1) directly:
> Lubbers, J. (2025) lasertram - Laser Time Resolved Analysis Module (Version 1.0.1), U.S. Geological Survey Software Release, https://doi.org/10.5066/P14DFTFD