import logging

from smile_datasets.dataset import Datapipe, Dataset
from smile_datasets.mlm.dataset import DatapipeForMaksedLanguageModel, DatasetForMaskedLanguageModel
from smile_datasets.mlm.example import ExampleForMaskedLanguageModel
from smile_datasets.mlm.masking_strategy import WholeWordMask
from smile_datasets.mlm.parsers import ParserForMaskedLanguageModel
from smile_datasets.question_answering.dataset import DatapipeForQuestionAnswering, DatasetForQuestionAnswering
from smile_datasets.question_answering.example import ExampleForQuestionAnswering
from smile_datasets.question_answering.parsers import ParserForQuestionAnswering
from smile_datasets.sequence_classification.dataset import DatapipeForSequenceClassifiation, DatasetForSequenceClassification
from smile_datasets.sequence_classification.example import ExampleForSequenceClassification
from smile_datasets.sequence_classification.parsers import ParserForSequenceClassification
from smile_datasets.simcse.example import ExampleForHardNegativeSimCSE, ExampleForSupervisedSimCSE, ExampleForUnsupervisedSimCSE
from smile_datasets.simcse.hardneg_dataset import DatapipeForHardNegativeSimCSE, DatasetForHardNegativeSimCSE
from smile_datasets.simcse.parsers import ParserForHardNegSimCSE, ParserForSupervisedSimCSE, ParserForUnsupervisedSimCSE
from smile_datasets.simcse.sup_dataset import DatapipeForSupervisedSimCSE, DatasetForSupervisedSimCSE
from smile_datasets.simcse.unsup_dataset import DatapipeForUnsupervisedSimCSE, DatasetForUnsupervisedSimCSE
from smile_datasets.token_classification.dataset import DatapipeForTokenClassification, DatasetForTokenClassification
from smile_datasets.token_classification.example import ExampleForTokenClassification
from smile_datasets.token_classification.parsers import ParserForTokenClassification
from smile_datasets.token_classification.tokenizers import BertCharLevelTokenizer, LabelTokenizerForTokenClassification

__name__ = "smile_datasets"
__version__ = "0.0.6"

logging.basicConfig(format="%(asctime)s %(levelname)7s %(filename)20s %(lineno)4d] %(message)s", level=logging.INFO)
