#   Copyright 2020 Google LLC

#   Licensed under the Apache License, Version 2.0 (the "License");
#   you may not use this file except in compliance with the License.
#   You may obtain a copy of the License at
#
#       http://www.apache.org/licenses/LICENSE-2.0
#
#   Unless required by applicable law or agreed to in writing, software
#   distributed under the License is distributed on an "AS IS" BASIS,
#   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#   See the License for the specific language governing permissions and
#   limitations under the License.
"""Defines function to get NH data for unit tests."""

# pylint: disable=inconsistent-return-statements
# pylint: disable=too-many-lines
# pylint: disable=too-many-locals

import numpy as np


def build_nh_data():
    """Returns NH data for unit tests."""
    nele = 8
    norb = 6
    norb_rel = 2 * norb
    h1e = np.zeros((norb_rel,) * 2, dtype=np.complex128)
    h2e = np.zeros((norb_rel,) * 4, dtype=np.complex128)

    h1e[0, 0] = complex(-24.672897447454, -0.000000000000)
    h1e[2, 0] = complex(-0.070491548734, -0.001166128999)
    h1e[4, 0] = complex(0.019786689912, 0.000017194307)
    h1e[6, 0] = complex(-0.000059050519, -0.000024328710)
    h1e[10, 0] = complex(0.075687104000, 0.000686647124)
    h1e[0, 2] = complex(-0.070491548734, 0.001166128999)
    h1e[2, 2] = complex(-5.549044326113, 0.000000000000)
    h1e[4, 2] = complex(0.351370252363, -0.015998795651)
    h1e[6, 2] = complex(-0.000514885024, -0.001098366467)
    h1e[10, 2] = complex(0.772150932538, 0.027410230656)
    h1e[0, 4] = complex(0.019786689912, -0.000017194307)
    h1e[2, 4] = complex(0.351370252363, 0.015998795651)
    h1e[4, 4] = complex(-4.861561198836, -0.000000000000)
    h1e[6, 4] = complex(-0.000682618823, -0.001670720184)
    h1e[10, 4] = complex(0.824821956133, 0.067138840821)
    h1e[0, 6] = complex(-0.000059050519, 0.000024328710)
    h1e[2, 6] = complex(-0.000514885024, 0.001098366467)
    h1e[4, 6] = complex(-0.000682618823, 0.001670720184)
    h1e[6, 6] = complex(-5.348356491891, -0.000000000000)
    h1e[10, 6] = complex(-0.001139285150, 0.002078177444)
    h1e[8, 8] = complex(-5.347930664200, -0.000000000000)
    h1e[0, 10] = complex(0.075687104000, -0.000686647124)
    h1e[2, 10] = complex(0.772150932538, -0.027410230656)
    h1e[4, 10] = complex(0.824821956133, -0.067138840821)
    h1e[6, 10] = complex(-0.001139285150, -0.002078177444)
    h1e[10, 10] = complex(-4.108424217070, -0.000000000000)
    h1e[2, 1] = complex(-0.453115319243, -0.026137475707)
    h1e[4, 1] = complex(0.202732890726, 0.002365352146)
    h1e[6, 1] = complex(-0.000189235330, -0.000491130397)
    h1e[10, 1] = complex(0.155351295781, 0.015012772492)
    h1e[0, 3] = complex(-0.453868531885, -0.000126153653)
    h1e[4, 3] = complex(-0.019983436715, 0.001606575863)
    h1e[6, 3] = complex(-0.000060397198, 0.000115241954)
    h1e[10, 3] = complex(0.237013719794, -0.002937608717)
    h1e[0, 5] = complex(-0.202746688901, -0.000003806299)
    h1e[2, 5] = complex(-0.020035963627, 0.000692091442)
    h1e[6, 5] = complex(0.000136261776, -0.000079578678)
    h1e[10, 5] = complex(-0.306384300808, 0.003106685267)
    h1e[0, 7] = complex(0.000526288285, 0.000006301971)
    h1e[2, 7] = complex(0.000078841221, 0.000103501649)
    h1e[4, 7] = complex(0.000021579563, 0.000156314940)
    h1e[10, 7] = complex(0.000890010010, 0.000201294401)
    h1e[0, 11] = complex(0.156074730790, 0.000294701411)
    h1e[2, 11] = complex(-0.236741569369, 0.011728693203)
    h1e[4, 11] = complex(-0.305077637911, 0.028436352121)
    h1e[6, 11] = complex(0.000227318412, 0.000883721444)
    h1e[3, 0] = complex(-0.453868531885, 0.000126153653)
    h1e[5, 0] = complex(-0.202746688901, 0.000003806299)
    h1e[7, 0] = complex(0.000526288285, -0.000006301971)
    h1e[11, 0] = complex(0.156074730790, -0.000294701411)
    h1e[1, 2] = complex(-0.453115319243, 0.026137475707)
    h1e[5, 2] = complex(-0.020035963627, -0.000692091442)
    h1e[7, 2] = complex(0.000078841221, -0.000103501649)
    h1e[11, 2] = complex(-0.236741569369, -0.011728693203)
    h1e[1, 4] = complex(0.202732890726, -0.002365352146)
    h1e[3, 4] = complex(-0.019983436715, -0.001606575863)
    h1e[7, 4] = complex(0.000021579563, -0.000156314940)
    h1e[11, 4] = complex(-0.305077637911, -0.028436352121)
    h1e[1, 6] = complex(-0.000189235330, 0.000491130397)
    h1e[3, 6] = complex(-0.000060397198, -0.000115241954)
    h1e[5, 6] = complex(0.000136261776, 0.000079578678)
    h1e[11, 6] = complex(0.000227318412, -0.000883721444)
    h1e[1, 10] = complex(0.155351295781, -0.015012772492)
    h1e[3, 10] = complex(0.237013719794, 0.002937608717)
    h1e[5, 10] = complex(-0.306384300808, -0.003106685267)
    h1e[7, 10] = complex(0.000890010010, -0.000201294401)
    h1e[1, 1] = complex(-24.672897447454, 0.000000000000)
    h1e[3, 1] = complex(0.070442519823, 0.002875708616)
    h1e[5, 1] = complex(0.019785547906, 0.000213277605)
    h1e[7, 1] = complex(-0.000044484751, -0.000045825285)
    h1e[11, 1] = complex(-0.075414516075, -0.006454452833)
    h1e[1, 3] = complex(0.070442519823, -0.002875708616)
    h1e[3, 3] = complex(-5.549044326075, 0.000000000000)
    h1e[5, 3] = complex(-0.351734290510, 0.000067865687)
    h1e[7, 3] = complex(0.001213059404, 0.000001534283)
    h1e[11, 3] = complex(0.772636271560, 0.001255105931)
    h1e[1, 5] = complex(0.019785547906, -0.000213277605)
    h1e[3, 5] = complex(-0.351734290510, -0.000067865687)
    h1e[5, 5] = complex(-4.861561198850, -0.000000000000)
    h1e[7, 5] = complex(-0.001804780890, 0.000006349177)
    h1e[11, 5] = complex(-0.827548890712, -0.001310232492)
    h1e[1, 7] = complex(-0.000044484751, 0.000045825285)
    h1e[3, 7] = complex(0.001213059404, -0.000001534283)
    h1e[5, 7] = complex(-0.001804780890, -0.000006349177)
    h1e[7, 7] = complex(-5.348356491891, -0.000000000000)
    h1e[11, 7] = complex(0.002369095967, -0.000064625084)
    h1e[9, 9] = complex(-5.347930664200, 0.000000000000)
    h1e[1, 11] = complex(-0.075414516075, 0.006454452833)
    h1e[3, 11] = complex(0.772636271560, -0.001255105931)
    h1e[5, 11] = complex(-0.827548890712, 0.001310232492)
    h1e[7, 11] = complex(0.002369095967, 0.000064625084)
    h1e[11, 11] = complex(-4.108424217082, -0.000000000000)
    h2e[0, 0, 0, 0] = complex(4.133559527668, -0.000000000000)
    h2e[2, 0, 0, 0] = complex(0.056172681502, 0.000929254556)
    h2e[4, 0, 0, 0] = complex(-0.016279369195, -0.000014146503)
    h2e[6, 0, 0, 0] = complex(0.000049455655, 0.000020375643)
    h2e[10, 0, 0, 0] = complex(-0.062997221645, -0.000571522212)
    h2e[0, 0, 2, 0] = complex(0.056172681502, 0.000929254556)
    h2e[2, 0, 2, 0] = complex(0.001208013117, 0.000039978829)
    h2e[4, 0, 2, 0] = complex(-0.000316378122, -0.000005508699)
    h2e[6, 0, 2, 0] = complex(0.000000742723, -0.000000022146)
    h2e[8, 0, 2, 0] = complex(0.000000375497, -0.000000180250)
    h2e[10, 0, 2, 0] = complex(-0.001534013486, -0.000039299653)
    h2e[0, 0, 4, 0] = complex(-0.016279369195, -0.000014146503)
    h2e[2, 0, 4, 0] = complex(-0.000316378122, -0.000005508699)
    h2e[4, 0, 4, 0] = complex(0.000199346839, 0.000000353071)
    h2e[6, 0, 4, 0] = complex(-0.000012783751, -0.000022610850)
    h2e[8, 0, 4, 0] = complex(0.000018592605, -0.000009841164)
    h2e[10, 0, 4, 0] = complex(-0.000141658584, -0.000001407657)
    h2e[0, 0, 6, 0] = complex(0.000049455655, 0.000020375643)
    h2e[2, 0, 6, 0] = complex(0.000000742723, -0.000000022146)
    h2e[4, 0, 6, 0] = complex(-0.000012783751, -0.000022610850)
    h2e[6, 0, 6, 0] = complex(0.006925968824, -0.008469468982)
    h2e[8, 0, 6, 0] = complex(0.007233934735, 0.005349067368)
    h2e[10, 0, 6, 0] = complex(-0.000002589585, -0.000006092285)
    h2e[2, 0, 8, 0] = complex(0.000000375497, -0.000000180250)
    h2e[4, 0, 8, 0] = complex(0.000018592605, -0.000009841164)
    h2e[6, 0, 8, 0] = complex(0.007233934735, 0.005349067368)
    h2e[8, 0, 8, 0] = complex(-0.006324084457, 0.008991263752)
    h2e[10, 0, 8, 0] = complex(0.000006528021, -0.000003084899)
    h2e[0, 0, 10, 0] = complex(-0.062997221645, -0.000571522212)
    h2e[2, 0, 10, 0] = complex(-0.001534013486, -0.000039299653)
    h2e[4, 0, 10, 0] = complex(-0.000141658584, -0.000001407657)
    h2e[6, 0, 10, 0] = complex(-0.000002589585, -0.000006092285)
    h2e[8, 0, 10, 0] = complex(0.000006528021, -0.000003084899)
    h2e[10, 0, 10, 0] = complex(0.004489536762, 0.000081466343)
    h2e[0, 2, 0, 0] = complex(0.056172681502, -0.000929254556)
    h2e[2, 2, 0, 0] = complex(0.881258649487, 0.000000000000)
    h2e[4, 2, 0, 0] = complex(-0.127065038995, 0.005785599605)
    h2e[6, 2, 0, 0] = complex(0.000175436119, 0.000374245009)
    h2e[10, 2, 0, 0] = complex(-0.202563653096, -0.007190713913)
    h2e[0, 2, 2, 0] = complex(0.001208674528, -0.000000000000)
    h2e[2, 2, 2, 0] = complex(0.001799415547, 0.000029767407)
    h2e[4, 2, 2, 0] = complex(-0.001273426391, 0.000036888547)
    h2e[6, 2, 2, 0] = complex(0.000001503064, 0.000003177012)
    h2e[8, 2, 2, 0] = complex(0.000000255698, -0.000000193188)
    h2e[10, 2, 2, 0] = complex(-0.000538156073, -0.000028022836)
    h2e[0, 2, 4, 0] = complex(-0.000316384951, 0.000004958860)
    h2e[2, 2, 4, 0] = complex(-0.001350436501, -0.000001173507)
    h2e[4, 2, 4, 0] = complex(-0.001240336702, 0.000055395134)
    h2e[6, 2, 4, 0] = complex(0.000005810536, 0.000005289958)
    h2e[8, 2, 4, 0] = complex(0.000011323759, -0.000009009139)
    h2e[10, 2, 4, 0] = complex(0.001391041193, 0.000050589844)
    h2e[0, 2, 6, 0] = complex(0.000001176469, 0.000000820451)
    h2e[2, 2, 6, 0] = complex(0.000003962400, 0.000001632502)
    h2e[4, 2, 6, 0] = complex(0.000003515186, 0.000008019516)
    h2e[6, 2, 6, 0] = complex(-0.001377729969, 0.001607862597)
    h2e[8, 2, 6, 0] = complex(0.004682891023, 0.003875820138)
    h2e[10, 2, 6, 0] = complex(-0.000003331116, 0.000000527790)
    h2e[0, 2, 8, 0] = complex(-0.000000379501, 0.000000172056)
    h2e[4, 2, 8, 0] = complex(0.000012570799, -0.000010001280)
    h2e[6, 2, 8, 0] = complex(0.004684961523, 0.003877533883)
    h2e[8, 2, 8, 0] = complex(0.001262667870, -0.001710245811)
    h2e[10, 2, 8, 0] = complex(0.000000286061, -0.000000455578)
    h2e[0, 2, 10, 0] = complex(-0.001534473412, 0.000011461790)
    h2e[2, 2, 10, 0] = complex(0.001636227069, 0.000014844148)
    h2e[4, 2, 10, 0] = complex(0.008465046918, -0.000308511341)
    h2e[6, 2, 10, 0] = complex(-0.000008198837, -0.000019370711)
    h2e[8, 2, 10, 0] = complex(0.000000472786, -0.000000752955)
    h2e[10, 2, 10, 0] = complex(-0.004869691038, -0.000217115553)
    h2e[0, 4, 0, 0] = complex(-0.016279369195, 0.000014146503)
    h2e[2, 4, 0, 0] = complex(-0.127065038995, -0.005785599605)
    h2e[4, 4, 0, 0] = complex(0.798772089105, 0.000000000000)
    h2e[6, 4, 0, 0] = complex(0.000206846959, 0.000506261149)
    h2e[10, 4, 0, 0] = complex(-0.213163158391, -0.017351050434)
    h2e[0, 4, 2, 0] = complex(-0.000316384951, -0.000004958860)
    h2e[2, 4, 2, 0] = complex(-0.001271509871, -0.000078988983)
    h2e[4, 4, 2, 0] = complex(0.001520935396, 0.000025160560)
    h2e[6, 4, 2, 0] = complex(0.000000296536, 0.000000848330)
    h2e[8, 4, 2, 0] = complex(-0.000000134771, 0.000000087323)
    h2e[10, 4, 2, 0] = complex(-0.000652031555, -0.000063946611)
    h2e[0, 4, 4, 0] = complex(0.000199464539, 0.000000000000)
    h2e[2, 4, 4, 0] = complex(-0.001240265247, -0.000057551713)
    h2e[4, 4, 4, 0] = complex(0.000492616957, 0.000000428076)
    h2e[6, 4, 4, 0] = complex(-0.000002517034, -0.000002674458)
    h2e[8, 4, 4, 0] = complex(-0.000005826991, 0.000004027873)
    h2e[10, 4, 4, 0] = complex(-0.000343351163, -0.000028249362)
    h2e[0, 4, 6, 0] = complex(0.000009026839, 0.000023323934)
    h2e[2, 4, 6, 0] = complex(0.000004065067, -0.000005034213)
    h2e[4, 4, 6, 0] = complex(-0.000001381740, -0.000000569275)
    h2e[6, 4, 6, 0] = complex(0.000400191780, -0.000431678110)
    h2e[8, 4, 6, 0] = complex(-0.002210221544, -0.001999532630)
    h2e[10, 4, 6, 0] = complex(0.000001918839, 0.000005088541)
    h2e[0, 4, 8, 0] = complex(-0.000019576210, 0.000007708682)
    h2e[2, 4, 8, 0] = complex(-0.000013467510, 0.000008726083)
    h2e[6, 4, 8, 0] = complex(-0.002211242853, -0.002000456623)
    h2e[8, 4, 8, 0] = complex(-0.000369337608, 0.000461370132)
    h2e[10, 4, 8, 0] = complex(0.000001217766, -0.000001168668)
    h2e[0, 4, 10, 0] = complex(-0.000141628797, -0.000001160593)
    h2e[2, 4, 10, 0] = complex(0.008458064850, 0.000462041327)
    h2e[4, 4, 10, 0] = complex(-0.005883397738, -0.000053375251)
    h2e[6, 4, 10, 0] = complex(0.000003139960, 0.000008627045)
    h2e[8, 4, 10, 0] = complex(-0.000000417892, 0.000000401044)
    h2e[10, 4, 10, 0] = complex(0.003214937129, 0.000291070833)
    h2e[0, 6, 0, 0] = complex(0.000049455655, -0.000020375643)
    h2e[2, 6, 0, 0] = complex(0.000175436119, -0.000374245009)
    h2e[4, 6, 0, 0] = complex(0.000206846959, -0.000506261149)
    h2e[6, 6, 0, 0] = complex(0.966780087765, -0.000000000000)
    h2e[10, 6, 0, 0] = complex(0.000290573890, -0.000530037720)
    h2e[0, 6, 2, 0] = complex(0.000001176469, -0.000000820451)
    h2e[2, 6, 2, 0] = complex(0.000001415362, -0.000003053271)
    h2e[4, 6, 2, 0] = complex(0.000000392648, -0.000000835072)
    h2e[6, 6, 2, 0] = complex(0.001608049052, 0.000026601666)
    h2e[10, 6, 2, 0] = complex(0.000000839560, -0.000001446399)
    h2e[0, 6, 4, 0] = complex(0.000009026839, -0.000023323934)
    h2e[2, 6, 4, 0] = complex(-0.000003308991, 0.000001116711)
    h2e[4, 6, 4, 0] = complex(0.000000791694, 0.000001216965)
    h2e[6, 6, 4, 0] = complex(-0.000455179029, -0.000000395543)
    h2e[8, 6, 4, 0] = complex(-0.000000006906, -0.000000018212)
    h2e[10, 6, 4, 0] = complex(0.000003257370, -0.000005253733)
    h2e[0, 6, 6, 0] = complex(0.011110479282, 0.000000000000)
    h2e[2, 6, 6, 0] = complex(-0.002172293789, -0.002361132411)
    h2e[4, 6, 6, 0] = complex(0.000655702535, 0.001029363884)
    h2e[6, 6, 6, 0] = complex(0.000001352515, 0.000000557234)
    h2e[8, 6, 6, 0] = complex(0.000006562283, -0.000004494559)
    h2e[10, 6, 6, 0] = complex(0.002100003171, 0.000753764802)
    h2e[0, 6, 8, 0] = complex(-0.000664391211, 0.009137152312)
    h2e[2, 6, 8, 0] = complex(0.002224712955, 0.006055679436)
    h2e[4, 6, 8, 0] = complex(-0.001110231618, -0.002927611676)
    h2e[8, 6, 8, 0] = complex(0.000000510665, -0.000001934362)
    h2e[10, 6, 8, 0] = complex(-0.000699588775, -0.000751517559)
    h2e[0, 6, 10, 0] = complex(0.000003794565, -0.000006280735)
    h2e[2, 6, 10, 0] = complex(-0.000008345533, 0.000015621401)
    h2e[4, 6, 10, 0] = complex(0.000003125244, -0.000006583817)
    h2e[6, 6, 10, 0] = complex(-0.001604748401, -0.000014558568)
    h2e[8, 6, 10, 0] = complex(-0.000000001374, -0.000000001476)
    h2e[10, 6, 10, 0] = complex(-0.000004287840, 0.000008143177)
    h2e[8, 8, 0, 0] = complex(0.966731902319, -0.000000000000)
    h2e[0, 8, 2, 0] = complex(-0.000000379501, -0.000000172056)
    h2e[2, 8, 2, 0] = complex(-0.000000258078, -0.000000191070)
    h2e[4, 8, 2, 0] = complex(0.000000135933, 0.000000085962)
    h2e[8, 8, 2, 0] = complex(0.001607436821, 0.000026591538)
    h2e[10, 8, 2, 0] = complex(0.000000011680, 0.000000032878)
    h2e[0, 8, 4, 0] = complex(-0.000019576210, -0.000007708682)
    h2e[2, 8, 4, 0] = complex(-0.000012236078, -0.000007737933)
    h2e[4, 8, 4, 0] = complex(0.000006231260, 0.000003374587)
    h2e[6, 8, 4, 0] = complex(0.000000004894, -0.000000018868)
    h2e[8, 8, 4, 0] = complex(-0.000455005844, -0.000000395393)
    h2e[10, 8, 4, 0] = complex(0.000001137669, 0.000001593049)
    h2e[0, 8, 6, 0] = complex(-0.000664391211, -0.009137152312)
    h2e[2, 8, 6, 0] = complex(0.002157838719, -0.006097609151)
    h2e[4, 8, 6, 0] = complex(-0.000786335320, 0.003031767838)
    h2e[6, 8, 6, 0] = complex(0.000008806541, -0.000000065651)
    h2e[8, 8, 6, 0] = complex(0.000001351990, 0.000000557017)
    h2e[10, 8, 6, 0] = complex(-0.000857123472, 0.000713846340)
    h2e[0, 8, 8, 0] = complex(0.011100485429, -0.000000000000)
    h2e[2, 8, 8, 0] = complex(-0.002128118993, 0.001972035719)
    h2e[4, 8, 8, 0] = complex(0.000548528097, -0.000887630786)
    h2e[6, 8, 8, 0] = complex(-0.000003916748, 0.000000243397)
    h2e[10, 8, 8, 0] = complex(0.002136669248, -0.000614849289)
    h2e[0, 8, 10, 0] = complex(-0.000006412929, -0.000003347641)
    h2e[2, 8, 10, 0] = complex(-0.000000340382, -0.000000958109)
    h2e[4, 8, 10, 0] = complex(0.000000359835, 0.000000503868)
    h2e[6, 8, 10, 0] = complex(0.000000001684, -0.000000001403)
    h2e[8, 8, 10, 0] = complex(-0.001604043452, -0.000014552173)
    h2e[10, 8, 10, 0] = complex(-0.000000621941, -0.000000058023)
    h2e[0, 10, 0, 0] = complex(-0.062997221645, 0.000571522212)
    h2e[2, 10, 0, 0] = complex(-0.202563653096, 0.007190713913)
    h2e[4, 10, 0, 0] = complex(-0.213163158391, 0.017351050434)
    h2e[6, 10, 0, 0] = complex(0.000290573890, 0.000530037720)
    h2e[10, 10, 0, 0] = complex(0.764008571320, 0.000000000000)
    h2e[0, 10, 2, 0] = complex(-0.001534473412, -0.000011461790)
    h2e[2, 10, 2, 0] = complex(-0.000538788772, 0.000010207135)
    h2e[4, 10, 2, 0] = complex(-0.000653790364, 0.000042344657)
    h2e[6, 10, 2, 0] = complex(0.000000665822, 0.000001301627)
    h2e[8, 10, 2, 0] = complex(-0.000000011591, 0.000000032099)
    h2e[10, 10, 2, 0] = complex(0.001065703095, 0.000017629734)
    h2e[0, 10, 4, 0] = complex(-0.000141628797, 0.000001160593)
    h2e[2, 10, 4, 0] = complex(0.001391115643, -0.000048172044)
    h2e[4, 10, 4, 0] = complex(-0.000343421481, 0.000027653725)
    h2e[6, 10, 4, 0] = complex(-0.000002532033, -0.000002820784)
    h2e[8, 10, 4, 0] = complex(-0.000000962205, 0.000001696441)
    h2e[10, 10, 4, 0] = complex(-0.001422716309, -0.000001236317)
    h2e[0, 10, 6, 0] = complex(0.000003794565, 0.000006280735)
    h2e[2, 10, 6, 0] = complex(-0.000004842621, -0.000003863857)
    h2e[4, 10, 6, 0] = complex(-0.000000523368, -0.000004214071)
    h2e[6, 10, 6, 0] = complex(0.001328808542, -0.001613121917)
    h2e[8, 10, 6, 0] = complex(-0.000595726314, -0.000460199281)
    h2e[10, 10, 6, 0] = complex(0.000004130085, 0.000001701588)
    h2e[0, 10, 8, 0] = complex(-0.000006412929, 0.000003347641)
    h2e[2, 10, 8, 0] = complex(-0.000000204382, 0.000000565969)
    h2e[4, 10, 8, 0] = complex(-0.000000886858, 0.000001563600)
    h2e[6, 10, 8, 0] = complex(-0.000596005297, -0.000460414822)
    h2e[8, 10, 8, 0] = complex(-0.001213282281, 0.001711919210)
    h2e[0, 10, 10, 0] = complex(0.004490286136, -0.000000000000)
    h2e[2, 10, 10, 0] = complex(-0.004872829449, 0.000128729610)
    h2e[4, 10, 10, 0] = complex(0.003219687627, -0.000232694808)
    h2e[6, 10, 10, 0] = complex(-0.000004731698, -0.000008483083)
    h2e[8, 10, 10, 0] = complex(0.000000590308, -0.000000091451)
    h2e[10, 10, 10, 0] = complex(0.003947281852, 0.000035810456)
    h2e[0, 0, 0, 2] = complex(0.056172681502, -0.000929254556)
    h2e[2, 0, 0, 2] = complex(0.001208674528, -0.000000000000)
    h2e[4, 0, 0, 2] = complex(-0.000316384951, 0.000004958860)
    h2e[6, 0, 0, 2] = complex(0.000001176469, 0.000000820451)
    h2e[8, 0, 0, 2] = complex(-0.000000379501, 0.000000172056)
    h2e[10, 0, 0, 2] = complex(-0.001534473412, 0.000011461790)
    h2e[0, 0, 2, 2] = complex(0.881258649487, 0.000000000000)
    h2e[2, 0, 2, 2] = complex(0.001799415547, 0.000029767407)
    h2e[4, 0, 2, 2] = complex(-0.001350436501, -0.000001173507)
    h2e[6, 0, 2, 2] = complex(0.000003962400, 0.000001632502)
    h2e[10, 0, 2, 2] = complex(0.001636227069, 0.000014844148)
    h2e[0, 0, 4, 2] = complex(-0.127065038995, 0.005785599605)
    h2e[2, 0, 4, 2] = complex(-0.001273426391, 0.000036888547)
    h2e[4, 0, 4, 2] = complex(-0.001240336702, 0.000055395134)
    h2e[6, 0, 4, 2] = complex(0.000003515186, 0.000008019516)
    h2e[8, 0, 4, 2] = complex(0.000012570799, -0.000010001280)
    h2e[10, 0, 4, 2] = complex(0.008465046918, -0.000308511341)
    h2e[0, 0, 6, 2] = complex(0.000175436119, 0.000374245009)
    h2e[2, 0, 6, 2] = complex(0.000001503064, 0.000003177012)
    h2e[4, 0, 6, 2] = complex(0.000005810536, 0.000005289958)
    h2e[6, 0, 6, 2] = complex(-0.001377729969, 0.001607862597)
    h2e[8, 0, 6, 2] = complex(0.004684961523, 0.003877533883)
    h2e[10, 0, 6, 2] = complex(-0.000008198837, -0.000019370711)
    h2e[2, 0, 8, 2] = complex(0.000000255698, -0.000000193188)
    h2e[4, 0, 8, 2] = complex(0.000011323759, -0.000009009139)
    h2e[6, 0, 8, 2] = complex(0.004682891023, 0.003875820138)
    h2e[8, 0, 8, 2] = complex(0.001262667870, -0.001710245811)
    h2e[10, 0, 8, 2] = complex(0.000000472786, -0.000000752955)
    h2e[0, 0, 10, 2] = complex(-0.202563653096, -0.007190713913)
    h2e[2, 0, 10, 2] = complex(-0.000538156073, -0.000028022836)
    h2e[4, 0, 10, 2] = complex(0.001391041193, 0.000050589844)
    h2e[6, 0, 10, 2] = complex(-0.000003331116, 0.000000527790)
    h2e[8, 0, 10, 2] = complex(0.000000286061, -0.000000455578)
    h2e[10, 0, 10, 2] = complex(-0.004869691038, -0.000217115553)
    h2e[0, 2, 0, 2] = complex(0.001208013117, -0.000039978829)
    h2e[2, 2, 0, 2] = complex(0.001799415547, -0.000029767407)
    h2e[4, 2, 0, 2] = complex(-0.001271509871, 0.000078988983)
    h2e[6, 2, 0, 2] = complex(0.000001415362, 0.000003053271)
    h2e[8, 2, 0, 2] = complex(-0.000000258078, 0.000000191070)
    h2e[10, 2, 0, 2] = complex(-0.000538788772, -0.000010207135)
    h2e[0, 2, 2, 2] = complex(0.001799415547, -0.000029767407)
    h2e[2, 2, 2, 2] = complex(0.652177317351, 0.000000000000)
    h2e[4, 2, 2, 2] = complex(0.013782001880, -0.000627530163)
    h2e[6, 2, 2, 2] = complex(0.000000450557, 0.000000961140)
    h2e[10, 2, 2, 2] = complex(-0.092349463723, -0.003278271119)
    h2e[0, 2, 4, 2] = complex(-0.001271509871, 0.000078988983)
    h2e[2, 2, 4, 2] = complex(0.013782001880, -0.000627530163)
    h2e[4, 2, 4, 2] = complex(0.127795748592, -0.011661918919)
    h2e[6, 2, 4, 2] = complex(-0.000229130005, -0.000437584361)
    h2e[8, 2, 4, 2] = complex(-0.000136450068, 0.000073262307)
    h2e[10, 2, 4, 2] = complex(-0.003003692262, 0.000030090448)
    h2e[0, 2, 6, 2] = complex(0.000001415362, 0.000003053271)
    h2e[2, 2, 6, 2] = complex(0.000000450557, 0.000000961140)
    h2e[4, 2, 6, 2] = complex(-0.000229130005, -0.000437584361)
    h2e[6, 2, 6, 2] = complex(0.040178806132, -0.047232281442)
    h2e[8, 2, 6, 2] = complex(-0.046719345595, -0.036585171480)
    h2e[10, 2, 6, 2] = complex(-0.000020269077, -0.000046059985)
    h2e[0, 2, 8, 2] = complex(-0.000000258078, 0.000000191070)
    h2e[4, 2, 8, 2] = complex(-0.000136450068, 0.000073262307)
    h2e[6, 2, 8, 2] = complex(-0.046719345595, -0.036585171480)
    h2e[8, 2, 8, 2] = complex(-0.036788714361, 0.050205135104)
    h2e[10, 2, 8, 2] = complex(-0.000022140202, 0.000010427682)
    h2e[0, 2, 10, 2] = complex(-0.000538788772, -0.000010207135)
    h2e[2, 2, 10, 2] = complex(-0.092349463723, -0.003278271119)
    h2e[4, 2, 10, 2] = complex(-0.003003692262, 0.000030090448)
    h2e[6, 2, 10, 2] = complex(-0.000020269077, -0.000046059985)
    h2e[8, 2, 10, 2] = complex(-0.000022140202, 0.000010427682)
    h2e[10, 2, 10, 2] = complex(0.086289267609, 0.006134015822)
    h2e[0, 4, 0, 2] = complex(-0.000316378122, 0.000005508699)
    h2e[2, 4, 0, 2] = complex(-0.001273426391, -0.000036888547)
    h2e[4, 4, 0, 2] = complex(0.001520935396, -0.000025160560)
    h2e[6, 4, 0, 2] = complex(0.000000392648, 0.000000835072)
    h2e[8, 4, 0, 2] = complex(0.000000135933, -0.000000085962)
    h2e[10, 4, 0, 2] = complex(-0.000653790364, -0.000042344657)
    h2e[0, 4, 2, 2] = complex(-0.001350436501, 0.000001173507)
    h2e[2, 4, 2, 2] = complex(0.013782001880, 0.000627530163)
    h2e[4, 4, 2, 2] = complex(0.587292582649, -0.000000000000)
    h2e[6, 4, 2, 2] = complex(0.000072337473, 0.000177047092)
    h2e[10, 4, 2, 2] = complex(-0.058364955234, -0.004750789440)
    h2e[0, 4, 4, 2] = complex(-0.001240265247, 0.000057551713)
    h2e[2, 4, 4, 2] = complex(0.128327582473, -0.000000000000)
    h2e[4, 4, 4, 2] = complex(-0.042167331658, 0.001919987585)
    h2e[6, 4, 4, 2] = complex(-0.000022217485, -0.000048763112)
    h2e[8, 4, 4, 2] = complex(0.000050578812, -0.000023992305)
    h2e[10, 4, 4, 2] = complex(0.091763033710, 0.003278964657)
    h2e[0, 4, 6, 2] = complex(-0.000003308991, -0.000001116711)
    h2e[2, 4, 6, 2] = complex(-0.000066101568, -0.000157419250)
    h2e[4, 4, 6, 2] = complex(0.000048655096, 0.000103792341)
    h2e[6, 4, 6, 2] = complex(-0.015175634904, 0.016273763039)
    h2e[8, 4, 6, 2] = complex(0.015880825810, 0.013612246610)
    h2e[10, 4, 6, 2] = complex(-0.000105227206, -0.000279652285)
    h2e[0, 4, 8, 2] = complex(-0.000012236078, 0.000007737933)
    h2e[2, 4, 8, 2] = complex(0.000142483926, -0.000060610933)
    h2e[6, 4, 8, 2] = complex(0.015880933476, 0.013612338904)
    h2e[8, 4, 8, 2] = complex(0.014008291047, -0.017393960593)
    h2e[10, 4, 8, 2] = complex(-0.000038976468, 0.000016066180)
    h2e[0, 4, 10, 2] = complex(0.001391115643, 0.000048172044)
    h2e[2, 4, 10, 2] = complex(-0.002993879580, -0.000242990125)
    h2e[4, 4, 10, 2] = complex(-0.016157852788, -0.000573580181)
    h2e[6, 4, 10, 2] = complex(-0.000082090265, -0.000223997390)
    h2e[8, 4, 10, 2] = complex(0.000007479451, -0.000003083048)
    h2e[10, 4, 10, 2] = complex(0.052181507289, 0.006117513302)
    h2e[0, 6, 0, 2] = complex(0.000000742723, 0.000000022146)
    h2e[2, 6, 0, 2] = complex(0.000001503064, -0.000003177012)
    h2e[4, 6, 0, 2] = complex(0.000000296536, -0.000000848330)
    h2e[6, 6, 0, 2] = complex(0.001608049052, -0.000026601666)
    h2e[10, 6, 0, 2] = complex(0.000000665822, -0.000001301627)
    h2e[0, 6, 2, 2] = complex(0.000003962400, -0.000001632502)
    h2e[2, 6, 2, 2] = complex(0.000000450557, -0.000000961140)
    h2e[4, 6, 2, 2] = complex(0.000072337473, -0.000177047092)
    h2e[6, 6, 2, 2] = complex(0.652882649497, 0.000000000000)
    h2e[10, 6, 2, 2] = complex(0.000083082445, -0.000151551228)
    h2e[0, 6, 4, 2] = complex(0.000004065067, 0.000005034213)
    h2e[2, 6, 4, 2] = complex(-0.000066101568, 0.000157419250)
    h2e[4, 6, 4, 2] = complex(-0.000058152421, 0.000162325269)
    h2e[6, 6, 4, 2] = complex(-0.067560249795, 0.003076192772)
    h2e[8, 6, 4, 2] = complex(0.000000003347, 0.000000146021)
    h2e[10, 6, 4, 2] = complex(-0.000142376643, 0.000296679114)
    h2e[0, 6, 6, 2] = complex(-0.002172293789, 0.002361132411)
    h2e[2, 6, 6, 2] = complex(0.062928655244, -0.000000000000)
    h2e[4, 6, 6, 2] = complex(-0.022571820819, 0.000811265816)
    h2e[6, 6, 6, 2] = complex(0.000092932783, 0.000198246697)
    h2e[8, 6, 6, 2] = complex(-0.000049016758, 0.000023177612)
    h2e[10, 6, 6, 2] = complex(-0.019167069183, 0.000308683547)
    h2e[0, 6, 8, 2] = complex(0.002157838719, 0.006097609151)
    h2e[2, 6, 8, 2] = complex(0.000741923269, -0.060141289510)
    h2e[4, 6, 8, 2] = complex(0.000486118069, 0.021211236291)
    h2e[8, 6, 8, 2] = complex(0.000026166237, 0.000047904875)
    h2e[10, 6, 8, 2] = complex(0.000059475193, 0.020021783401)
    h2e[0, 6, 10, 2] = complex(-0.000004842621, 0.000003863857)
    h2e[2, 6, 10, 2] = complex(-0.000001450826, 0.000004257696)
    h2e[4, 6, 10, 2] = complex(-0.000104355279, 0.000230861264)
    h2e[6, 6, 10, 2] = complex(-0.104437556596, -0.003707380766)
    h2e[8, 6, 10, 2] = complex(0.000000000064, 0.000000021430)
    h2e[10, 6, 10, 2] = complex(-0.000088201934, 0.000148712389)
    h2e[0, 8, 0, 2] = complex(0.000000375497, 0.000000180250)
    h2e[2, 8, 0, 2] = complex(0.000000255698, 0.000000193188)
    h2e[4, 8, 0, 2] = complex(-0.000000134771, -0.000000087323)
    h2e[8, 8, 0, 2] = complex(0.001607436821, -0.000026591538)
    h2e[10, 8, 0, 2] = complex(-0.000000011591, -0.000000032099)
    h2e[8, 8, 2, 2] = complex(0.652877324645, 0.000000000000)
    h2e[0, 8, 4, 2] = complex(-0.000013467510, -0.000008726083)
    h2e[2, 8, 4, 2] = complex(0.000142483926, 0.000060610933)
    h2e[4, 8, 4, 2] = complex(-0.000052525726, -0.000019325655)
    h2e[6, 8, 4, 2] = complex(0.000000009840, 0.000000145654)
    h2e[8, 8, 4, 2] = complex(-0.067559924170, 0.003076177945)
    h2e[10, 8, 4, 2] = complex(-0.000045566933, -0.000022383877)
    h2e[0, 8, 6, 2] = complex(0.002224712955, -0.006055679436)
    h2e[2, 8, 6, 2] = complex(0.000741923269, 0.060141289510)
    h2e[4, 8, 6, 2] = complex(-0.001429295675, -0.021157777824)
    h2e[6, 8, 6, 2] = complex(-0.000049382759, 0.000026209043)
    h2e[8, 8, 6, 2] = complex(0.000092932187, 0.000198245421)
    h2e[10, 8, 6, 2] = complex(0.001373828747, -0.020043122366)
    h2e[0, 8, 8, 2] = complex(-0.002128118993, -0.001972035719)
    h2e[2, 8, 8, 2] = complex(0.062888762683, -0.000000000000)
    h2e[4, 8, 8, 2] = complex(-0.022529338111, 0.001212645216)
    h2e[6, 8, 8, 2] = complex(0.000027161424, 0.000056733644)
    h2e[10, 8, 8, 2] = complex(-0.019160880543, -0.001533762494)
    h2e[0, 8, 10, 2] = complex(-0.000000204382, -0.000000565969)
    h2e[2, 8, 10, 2] = complex(0.000021427665, 0.000011902200)
    h2e[4, 8, 10, 2] = complex(-0.000007272305, -0.000003572378)
    h2e[6, 8, 10, 2] = complex(-0.000000001470, 0.000000021453)
    h2e[8, 8, 10, 2] = complex(-0.104436066373, -0.003707327865)
    h2e[10, 8, 10, 2] = complex(-0.000006746646, -0.000004322147)
    h2e[0, 10, 0, 2] = complex(-0.001534013486, 0.000039299653)
    h2e[2, 10, 0, 2] = complex(-0.000538156073, 0.000028022836)
    h2e[4, 10, 0, 2] = complex(-0.000652031555, 0.000063946611)
    h2e[6, 10, 0, 2] = complex(0.000000839560, 0.000001446399)
    h2e[8, 10, 0, 2] = complex(0.000000011680, -0.000000032878)
    h2e[10, 10, 0, 2] = complex(0.001065703095, -0.000017629734)
    h2e[0, 10, 2, 2] = complex(0.001636227069, -0.000014844148)
    h2e[2, 10, 2, 2] = complex(-0.092349463723, 0.003278271119)
    h2e[4, 10, 2, 2] = complex(-0.058364955234, 0.004750789440)
    h2e[6, 10, 2, 2] = complex(0.000083082445, 0.000151551228)
    h2e[10, 10, 2, 2] = complex(0.600972926144, -0.000000000000)
    h2e[0, 10, 4, 2] = complex(0.008458064850, -0.000462041327)
    h2e[2, 10, 4, 2] = complex(-0.002993879580, 0.000242990125)
    h2e[4, 10, 4, 2] = complex(0.091085551947, -0.011604550045)
    h2e[6, 10, 4, 2] = complex(-0.000123149918, -0.000196794584)
    h2e[8, 10, 4, 2] = complex(0.000043343717, -0.000026455820)
    h2e[10, 10, 4, 2] = complex(0.076193473301, -0.003469285749)
    h2e[0, 10, 6, 2] = complex(-0.000008345533, -0.000015621401)
    h2e[2, 10, 6, 2] = complex(-0.000001450826, -0.000004257696)
    h2e[4, 10, 6, 2] = complex(-0.000107620288, -0.000189984964)
    h2e[6, 10, 6, 2] = complex(-0.011721149811, 0.014831907745)
    h2e[8, 10, 6, 2] = complex(0.015936335504, 0.011762817181)
    h2e[10, 10, 6, 2] = complex(-0.000078431273, -0.000167311684)
    h2e[0, 10, 8, 2] = complex(-0.000000340382, 0.000000958109)
    h2e[2, 10, 8, 2] = complex(0.000021427665, -0.000011902200)
    h2e[4, 10, 8, 2] = complex(0.000036047984, -0.000022002706)
    h2e[6, 10, 8, 2] = complex(0.015936320604, 0.011762806150)
    h2e[8, 10, 8, 2] = complex(0.010655057639, -0.015699439039)
    h2e[0, 10, 10, 2] = complex(-0.004872829449, -0.000128729610)
    h2e[2, 10, 10, 2] = complex(0.086507035696, 0.000000000000)
    h2e[4, 10, 10, 2] = complex(0.052483976181, -0.002402044351)
    h2e[6, 10, 10, 2] = complex(-0.000070266305, -0.000139168110)
    h2e[8, 10, 10, 2] = complex(0.000007031844, -0.000003806432)
    h2e[10, 10, 10, 2] = complex(-0.033380952990, -0.001184975090)
    h2e[0, 0, 0, 4] = complex(-0.016279369195, 0.000014146503)
    h2e[2, 0, 0, 4] = complex(-0.000316384951, -0.000004958860)
    h2e[4, 0, 0, 4] = complex(0.000199464539, 0.000000000000)
    h2e[6, 0, 0, 4] = complex(0.000009026839, 0.000023323934)
    h2e[8, 0, 0, 4] = complex(-0.000019576210, 0.000007708682)
    h2e[10, 0, 0, 4] = complex(-0.000141628797, -0.000001160593)
    h2e[0, 0, 2, 4] = complex(-0.127065038995, -0.005785599605)
    h2e[2, 0, 2, 4] = complex(-0.001271509871, -0.000078988983)
    h2e[4, 0, 2, 4] = complex(-0.001240265247, -0.000057551713)
    h2e[6, 0, 2, 4] = complex(0.000004065067, -0.000005034213)
    h2e[8, 0, 2, 4] = complex(-0.000013467510, 0.000008726083)
    h2e[10, 0, 2, 4] = complex(0.008458064850, 0.000462041327)
    h2e[0, 0, 4, 4] = complex(0.798772089105, 0.000000000000)
    h2e[2, 0, 4, 4] = complex(0.001520935396, 0.000025160560)
    h2e[4, 0, 4, 4] = complex(0.000492616957, 0.000000428076)
    h2e[6, 0, 4, 4] = complex(-0.000001381740, -0.000000569275)
    h2e[10, 0, 4, 4] = complex(-0.005883397738, -0.000053375251)
    h2e[0, 0, 6, 4] = complex(0.000206846959, 0.000506261149)
    h2e[2, 0, 6, 4] = complex(0.000000296536, 0.000000848330)
    h2e[4, 0, 6, 4] = complex(-0.000002517034, -0.000002674458)
    h2e[6, 0, 6, 4] = complex(0.000400191780, -0.000431678110)
    h2e[8, 0, 6, 4] = complex(-0.002211242853, -0.002000456623)
    h2e[10, 0, 6, 4] = complex(0.000003139960, 0.000008627045)
    h2e[2, 0, 8, 4] = complex(-0.000000134771, 0.000000087323)
    h2e[4, 0, 8, 4] = complex(-0.000005826991, 0.000004027873)
    h2e[6, 0, 8, 4] = complex(-0.002210221544, -0.001999532630)
    h2e[8, 0, 8, 4] = complex(-0.000369337608, 0.000461370132)
    h2e[10, 0, 8, 4] = complex(-0.000000417892, 0.000000401044)
    h2e[0, 0, 10, 4] = complex(-0.213163158391, -0.017351050434)
    h2e[2, 0, 10, 4] = complex(-0.000652031555, -0.000063946611)
    h2e[4, 0, 10, 4] = complex(-0.000343351163, -0.000028249362)
    h2e[6, 0, 10, 4] = complex(0.000001918839, 0.000005088541)
    h2e[8, 0, 10, 4] = complex(0.000001217766, -0.000001168668)
    h2e[10, 0, 10, 4] = complex(0.003214937129, 0.000291070833)
    h2e[0, 2, 0, 4] = complex(-0.000316378122, 0.000005508699)
    h2e[2, 2, 0, 4] = complex(-0.001350436501, 0.000001173507)
    h2e[4, 2, 0, 4] = complex(-0.001240265247, 0.000057551713)
    h2e[6, 2, 0, 4] = complex(-0.000003308991, -0.000001116711)
    h2e[8, 2, 0, 4] = complex(-0.000012236078, 0.000007737933)
    h2e[10, 2, 0, 4] = complex(0.001391115643, 0.000048172044)
    h2e[0, 2, 2, 4] = complex(-0.001273426391, -0.000036888547)
    h2e[2, 2, 2, 4] = complex(0.013782001880, 0.000627530163)
    h2e[4, 2, 2, 4] = complex(0.128327582473, -0.000000000000)
    h2e[6, 2, 2, 4] = complex(-0.000066101568, -0.000157419250)
    h2e[8, 2, 2, 4] = complex(0.000142483926, -0.000060610933)
    h2e[10, 2, 2, 4] = complex(-0.002993879580, -0.000242990125)
    h2e[0, 2, 4, 4] = complex(0.001520935396, -0.000025160560)
    h2e[2, 2, 4, 4] = complex(0.587292582649, -0.000000000000)
    h2e[4, 2, 4, 4] = complex(-0.042167331658, 0.001919987585)
    h2e[6, 2, 4, 4] = complex(0.000048655096, 0.000103792341)
    h2e[10, 2, 4, 4] = complex(-0.016157852788, -0.000573580181)
    h2e[0, 2, 6, 4] = complex(0.000000392648, 0.000000835072)
    h2e[2, 2, 6, 4] = complex(0.000072337473, 0.000177047092)
    h2e[4, 2, 6, 4] = complex(-0.000022217485, -0.000048763112)
    h2e[6, 2, 6, 4] = complex(-0.015175634904, 0.016273763039)
    h2e[8, 2, 6, 4] = complex(0.015880933476, 0.013612338904)
    h2e[10, 2, 6, 4] = complex(-0.000082090265, -0.000223997390)
    h2e[0, 2, 8, 4] = complex(0.000000135933, -0.000000085962)
    h2e[4, 2, 8, 4] = complex(0.000050578812, -0.000023992305)
    h2e[6, 2, 8, 4] = complex(0.015880825810, 0.013612246610)
    h2e[8, 2, 8, 4] = complex(0.014008291047, -0.017393960593)
    h2e[10, 2, 8, 4] = complex(0.000007479451, -0.000003083048)
    h2e[0, 2, 10, 4] = complex(-0.000653790364, -0.000042344657)
    h2e[2, 2, 10, 4] = complex(-0.058364955234, -0.004750789440)
    h2e[4, 2, 10, 4] = complex(0.091763033710, 0.003278964657)
    h2e[6, 2, 10, 4] = complex(-0.000105227206, -0.000279652285)
    h2e[8, 2, 10, 4] = complex(-0.000038976468, 0.000016066180)
    h2e[10, 2, 10, 4] = complex(0.052181507289, 0.006117513302)
    h2e[0, 4, 0, 4] = complex(0.000199346839, -0.000000353071)
    h2e[2, 4, 0, 4] = complex(-0.001240336702, -0.000055395134)
    h2e[4, 4, 0, 4] = complex(0.000492616957, -0.000000428076)
    h2e[6, 4, 0, 4] = complex(0.000000791694, -0.000001216965)
    h2e[8, 4, 0, 4] = complex(0.000006231260, -0.000003374587)
    h2e[10, 4, 0, 4] = complex(-0.000343421481, -0.000027653725)
    h2e[0, 4, 2, 4] = complex(-0.001240336702, -0.000055395134)
    h2e[2, 4, 2, 4] = complex(0.127795748592, 0.011661918919)
    h2e[4, 4, 2, 4] = complex(-0.042167331658, -0.001919987585)
    h2e[6, 4, 2, 4] = complex(-0.000058152421, -0.000162325269)
    h2e[8, 4, 2, 4] = complex(-0.000052525726, 0.000019325655)
    h2e[10, 4, 2, 4] = complex(0.091085551947, 0.011604550045)
    h2e[0, 4, 4, 4] = complex(0.000492616957, -0.000000428076)
    h2e[2, 4, 4, 4] = complex(-0.042167331658, -0.001919987585)
    h2e[4, 4, 4, 4] = complex(0.632865022920, -0.000000000000)
    h2e[6, 4, 4, 4] = complex(-0.000019271071, -0.000047166238)
    h2e[10, 4, 4, 4] = complex(-0.070266672479, -0.005719565178)
    h2e[0, 4, 6, 4] = complex(0.000000791694, -0.000001216965)
    h2e[2, 4, 6, 4] = complex(-0.000058152421, -0.000162325269)
    h2e[4, 4, 6, 4] = complex(-0.000019271071, -0.000047166238)
    h2e[6, 4, 6, 4] = complex(0.016315038240, -0.015964027754)
    h2e[8, 4, 6, 4] = complex(-0.015278621286, -0.014310587595)
    h2e[10, 4, 6, 4] = complex(-0.000053264781, -0.000166870717)
    h2e[0, 4, 8, 4] = complex(0.000006231260, -0.000003374587)
    h2e[2, 4, 8, 4] = complex(-0.000052525726, 0.000019325655)
    h2e[6, 4, 8, 4] = complex(-0.015278621286, -0.014310587595)
    h2e[8, 4, 8, 4] = complex(-0.015173081976, 0.017168651741)
    h2e[10, 4, 8, 4] = complex(-0.000013394199, 0.000004767538)
    h2e[0, 4, 10, 4] = complex(-0.000343421481, -0.000027653725)
    h2e[2, 4, 10, 4] = complex(0.091085551947, 0.011604550045)
    h2e[4, 4, 10, 4] = complex(-0.070266672479, -0.005719565178)
    h2e[6, 4, 10, 4] = complex(-0.000053264781, -0.000166870717)
    h2e[8, 4, 10, 4] = complex(-0.000013394199, 0.000004767538)
    h2e[10, 4, 10, 4] = complex(0.122814667600, 0.020127086862)
    h2e[0, 6, 0, 4] = complex(-0.000012783751, 0.000022610850)
    h2e[2, 6, 0, 4] = complex(0.000005810536, -0.000005289958)
    h2e[4, 6, 0, 4] = complex(-0.000002517034, 0.000002674458)
    h2e[6, 6, 0, 4] = complex(-0.000455179029, 0.000000395543)
    h2e[8, 6, 0, 4] = complex(0.000000004894, 0.000000018868)
    h2e[10, 6, 0, 4] = complex(-0.000002532033, 0.000002820784)
    h2e[0, 6, 2, 4] = complex(0.000003515186, -0.000008019516)
    h2e[2, 6, 2, 4] = complex(-0.000229130005, 0.000437584361)
    h2e[4, 6, 2, 4] = complex(-0.000022217485, 0.000048763112)
    h2e[6, 6, 2, 4] = complex(-0.067560249795, -0.003076192772)
    h2e[8, 6, 2, 4] = complex(0.000000009840, -0.000000145654)
    h2e[10, 6, 2, 4] = complex(-0.000123149918, 0.000196794584)
    h2e[0, 6, 4, 4] = complex(-0.000001381740, 0.000000569275)
    h2e[2, 6, 4, 4] = complex(0.000048655096, -0.000103792341)
    h2e[4, 6, 4, 4] = complex(-0.000019271071, 0.000047166238)
    h2e[6, 6, 4, 4] = complex(0.599470600126, -0.000000000000)
    h2e[10, 6, 4, 4] = complex(0.000090116639, -0.000164382345)
    h2e[0, 6, 6, 4] = complex(0.000655702535, -0.001029363884)
    h2e[2, 6, 6, 4] = complex(-0.022571820819, -0.000811265816)
    h2e[4, 6, 6, 4] = complex(0.023177158532, -0.000000000000)
    h2e[6, 6, 6, 4] = complex(0.000137760157, 0.000337170124)
    h2e[8, 6, 6, 4] = complex(0.000046954619, -0.000019401356)
    h2e[10, 6, 6, 4] = complex(-0.002133888899, -0.000040487821)
    h2e[0, 6, 8, 4] = complex(-0.000786335320, -0.003031767838)
    h2e[2, 6, 8, 4] = complex(-0.001429295675, 0.021157777824)
    h2e[4, 6, 8, 4] = complex(0.000692858966, -0.021231141993)
    h2e[8, 6, 8, 4] = complex(-0.000070005083, -0.000141613810)
    h2e[10, 6, 8, 4] = complex(-0.000115497015, 0.002264258315)
    h2e[0, 6, 10, 4] = complex(-0.000000523368, 0.000004214071)
    h2e[2, 6, 10, 4] = complex(-0.000107620288, 0.000189984964)
    h2e[4, 6, 10, 4] = complex(-0.000066740305, 0.000132690089)
    h2e[6, 6, 10, 4] = complex(-0.110908548681, -0.009027731791)
    h2e[8, 6, 10, 4] = complex(0.000000001397, -0.000000027392)
    h2e[10, 6, 10, 4] = complex(-0.000221601940, 0.000338919016)
    h2e[0, 8, 0, 4] = complex(0.000018592605, 0.000009841164)
    h2e[2, 8, 0, 4] = complex(0.000011323759, 0.000009009139)
    h2e[4, 8, 0, 4] = complex(-0.000005826991, -0.000004027873)
    h2e[6, 8, 0, 4] = complex(-0.000000006906, 0.000000018212)
    h2e[8, 8, 0, 4] = complex(-0.000455005844, 0.000000395393)
    h2e[10, 8, 0, 4] = complex(-0.000000962205, -0.000001696441)
    h2e[0, 8, 2, 4] = complex(0.000012570799, 0.000010001280)
    h2e[2, 8, 2, 4] = complex(-0.000136450068, -0.000073262307)
    h2e[4, 8, 2, 4] = complex(0.000050578812, 0.000023992305)
    h2e[6, 8, 2, 4] = complex(0.000000003347, -0.000000146021)
    h2e[8, 8, 2, 4] = complex(-0.067559924170, -0.003076177945)
    h2e[10, 8, 2, 4] = complex(0.000043343717, 0.000026455820)
    h2e[8, 8, 4, 4] = complex(0.599463715830, -0.000000000000)
    h2e[0, 8, 6, 4] = complex(-0.001110231618, 0.002927611676)
    h2e[2, 8, 6, 4] = complex(0.000486118069, -0.021211236291)
    h2e[4, 8, 6, 4] = complex(0.000692858966, 0.021231141993)
    h2e[6, 8, 6, 4] = complex(0.000047063402, -0.000023237565)
    h2e[8, 8, 6, 4] = complex(0.000137761695, 0.000337173891)
    h2e[10, 8, 6, 4] = complex(0.000237466121, -0.002263694913)
    h2e[0, 8, 8, 4] = complex(0.000548528097, 0.000887630786)
    h2e[2, 8, 8, 4] = complex(-0.022529338111, -0.001212645216)
    h2e[4, 8, 8, 4] = complex(0.023142194872, -0.000000000000)
    h2e[6, 8, 8, 4] = complex(0.000016803943, 0.000041583788)
    h2e[10, 8, 8, 4] = complex(-0.002121144000, -0.000287663146)
    h2e[0, 8, 10, 4] = complex(-0.000000886858, -0.000001563600)
    h2e[2, 8, 10, 4] = complex(0.000036047984, 0.000022002706)
    h2e[4, 8, 10, 4] = complex(0.000012514987, 0.000006797960)
    h2e[6, 8, 10, 4] = complex(0.000000002873, -0.000000027383)
    h2e[8, 8, 10, 4] = complex(-0.110905457147, -0.009027480147)
    h2e[10, 8, 10, 4] = complex(-0.000030362203, -0.000021218576)
    h2e[0, 10, 0, 4] = complex(-0.000141658584, 0.000001407657)
    h2e[2, 10, 0, 4] = complex(0.001391041193, -0.000050589844)
    h2e[4, 10, 0, 4] = complex(-0.000343351163, 0.000028249362)
    h2e[6, 10, 0, 4] = complex(0.000003257370, 0.000005253733)
    h2e[8, 10, 0, 4] = complex(0.000001137669, -0.000001593049)
    h2e[10, 10, 0, 4] = complex(-0.001422716309, 0.000001236317)
    h2e[0, 10, 2, 4] = complex(0.008465046918, 0.000308511341)
    h2e[2, 10, 2, 4] = complex(-0.003003692262, -0.000030090448)
    h2e[4, 10, 2, 4] = complex(0.091763033710, -0.003278964657)
    h2e[6, 10, 2, 4] = complex(-0.000142376643, -0.000296679114)
    h2e[8, 10, 2, 4] = complex(-0.000045566933, 0.000022383877)
    h2e[10, 10, 2, 4] = complex(0.076193473301, 0.003469285749)
    h2e[0, 10, 4, 4] = complex(-0.005883397738, 0.000053375251)
    h2e[2, 10, 4, 4] = complex(-0.016157852788, 0.000573580181)
    h2e[4, 10, 4, 4] = complex(-0.070266672479, 0.005719565178)
    h2e[6, 10, 4, 4] = complex(0.000090116639, 0.000164382345)
    h2e[10, 10, 4, 4] = complex(0.574398690829, -0.000000000000)
    h2e[0, 10, 6, 4] = complex(0.000003125244, 0.000006583817)
    h2e[2, 10, 6, 4] = complex(-0.000104355279, -0.000230861264)
    h2e[4, 10, 6, 4] = complex(-0.000066740305, -0.000132690089)
    h2e[6, 10, 6, 4] = complex(-0.001376684389, 0.001591167968)
    h2e[8, 10, 6, 4] = complex(0.001742611814, 0.001412911604)
    h2e[10, 10, 6, 4] = complex(-0.000027437730, -0.000067154271)
    h2e[0, 10, 8, 4] = complex(0.000000359835, -0.000000503868)
    h2e[2, 10, 8, 4] = complex(-0.000007272305, 0.000003572378)
    h2e[4, 10, 8, 4] = complex(0.000012514987, -0.000006797960)
    h2e[6, 10, 8, 4] = complex(0.001742499492, 0.001412820528)
    h2e[8, 10, 8, 4] = complex(0.001262849997, -0.001693432841)
    h2e[0, 10, 10, 4] = complex(0.003219687627, 0.000232694808)
    h2e[2, 10, 10, 4] = complex(0.052483976181, 0.002402044351)
    h2e[4, 10, 10, 4] = complex(0.124453179373, 0.000000000000)
    h2e[6, 10, 10, 4] = complex(-0.000134847656, -0.000298681041)
    h2e[8, 10, 10, 4] = complex(0.000033352883, -0.000015924217)
    h2e[10, 10, 10, 4] = complex(0.025569237766, 0.002081284296)
    h2e[0, 0, 0, 6] = complex(0.000049455655, -0.000020375643)
    h2e[2, 0, 0, 6] = complex(0.000001176469, -0.000000820451)
    h2e[4, 0, 0, 6] = complex(0.000009026839, -0.000023323934)
    h2e[6, 0, 0, 6] = complex(0.011110479282, 0.000000000000)
    h2e[8, 0, 0, 6] = complex(-0.000664391211, 0.009137152312)
    h2e[10, 0, 0, 6] = complex(0.000003794565, -0.000006280735)
    h2e[0, 0, 2, 6] = complex(0.000175436119, -0.000374245009)
    h2e[2, 0, 2, 6] = complex(0.000001415362, -0.000003053271)
    h2e[4, 0, 2, 6] = complex(-0.000003308991, 0.000001116711)
    h2e[6, 0, 2, 6] = complex(-0.002172293789, -0.002361132411)
    h2e[8, 0, 2, 6] = complex(0.002224712955, 0.006055679436)
    h2e[10, 0, 2, 6] = complex(-0.000008345533, 0.000015621401)
    h2e[0, 0, 4, 6] = complex(0.000206846959, -0.000506261149)
    h2e[2, 0, 4, 6] = complex(0.000000392648, -0.000000835072)
    h2e[4, 0, 4, 6] = complex(0.000000791694, 0.000001216965)
    h2e[6, 0, 4, 6] = complex(0.000655702535, 0.001029363884)
    h2e[8, 0, 4, 6] = complex(-0.001110231618, -0.002927611676)
    h2e[10, 0, 4, 6] = complex(0.000003125244, -0.000006583817)
    h2e[0, 0, 6, 6] = complex(0.966780087765, -0.000000000000)
    h2e[2, 0, 6, 6] = complex(0.001608049052, 0.000026601666)
    h2e[4, 0, 6, 6] = complex(-0.000455179029, -0.000000395543)
    h2e[6, 0, 6, 6] = complex(0.000001352515, 0.000000557234)
    h2e[10, 0, 6, 6] = complex(-0.001604748401, -0.000014558568)
    h2e[4, 0, 8, 6] = complex(-0.000000006906, -0.000000018212)
    h2e[6, 0, 8, 6] = complex(0.000006562283, -0.000004494559)
    h2e[8, 0, 8, 6] = complex(0.000000510665, -0.000001934362)
    h2e[10, 0, 8, 6] = complex(-0.000000001374, -0.000000001476)
    h2e[0, 0, 10, 6] = complex(0.000290573890, -0.000530037720)
    h2e[2, 0, 10, 6] = complex(0.000000839560, -0.000001446399)
    h2e[4, 0, 10, 6] = complex(0.000003257370, -0.000005253733)
    h2e[6, 0, 10, 6] = complex(0.002100003171, 0.000753764802)
    h2e[8, 0, 10, 6] = complex(-0.000699588775, -0.000751517559)
    h2e[10, 0, 10, 6] = complex(-0.000004287840, 0.000008143177)
    h2e[0, 2, 0, 6] = complex(0.000000742723, 0.000000022146)
    h2e[2, 2, 0, 6] = complex(0.000003962400, -0.000001632502)
    h2e[4, 2, 0, 6] = complex(0.000004065067, 0.000005034213)
    h2e[6, 2, 0, 6] = complex(-0.002172293789, 0.002361132411)
    h2e[8, 2, 0, 6] = complex(0.002157838719, 0.006097609151)
    h2e[10, 2, 0, 6] = complex(-0.000004842621, 0.000003863857)
    h2e[0, 2, 2, 6] = complex(0.000001503064, -0.000003177012)
    h2e[2, 2, 2, 6] = complex(0.000000450557, -0.000000961140)
    h2e[4, 2, 2, 6] = complex(-0.000066101568, 0.000157419250)
    h2e[6, 2, 2, 6] = complex(0.062928655244, -0.000000000000)
    h2e[8, 2, 2, 6] = complex(0.000741923269, -0.060141289510)
    h2e[10, 2, 2, 6] = complex(-0.000001450826, 0.000004257696)
    h2e[0, 2, 4, 6] = complex(0.000000296536, -0.000000848330)
    h2e[2, 2, 4, 6] = complex(0.000072337473, -0.000177047092)
    h2e[4, 2, 4, 6] = complex(-0.000058152421, 0.000162325269)
    h2e[6, 2, 4, 6] = complex(-0.022571820819, 0.000811265816)
    h2e[8, 2, 4, 6] = complex(0.000486118069, 0.021211236291)
    h2e[10, 2, 4, 6] = complex(-0.000104355279, 0.000230861264)
    h2e[0, 2, 6, 6] = complex(0.001608049052, -0.000026601666)
    h2e[2, 2, 6, 6] = complex(0.652882649497, 0.000000000000)
    h2e[4, 2, 6, 6] = complex(-0.067560249795, 0.003076192772)
    h2e[6, 2, 6, 6] = complex(0.000092932783, 0.000198246697)
    h2e[10, 2, 6, 6] = complex(-0.104437556596, -0.003707380766)
    h2e[4, 2, 8, 6] = complex(0.000000003347, 0.000000146021)
    h2e[6, 2, 8, 6] = complex(-0.000049016758, 0.000023177612)
    h2e[8, 2, 8, 6] = complex(0.000026166237, 0.000047904875)
    h2e[10, 2, 8, 6] = complex(0.000000000064, 0.000000021430)
    h2e[0, 2, 10, 6] = complex(0.000000665822, -0.000001301627)
    h2e[2, 2, 10, 6] = complex(0.000083082445, -0.000151551228)
    h2e[4, 2, 10, 6] = complex(-0.000142376643, 0.000296679114)
    h2e[6, 2, 10, 6] = complex(-0.019167069183, 0.000308683547)
    h2e[8, 2, 10, 6] = complex(0.000059475193, 0.020021783401)
    h2e[10, 2, 10, 6] = complex(-0.000088201934, 0.000148712389)
    h2e[0, 4, 0, 6] = complex(-0.000012783751, 0.000022610850)
    h2e[2, 4, 0, 6] = complex(0.000003515186, -0.000008019516)
    h2e[4, 4, 0, 6] = complex(-0.000001381740, 0.000000569275)
    h2e[6, 4, 0, 6] = complex(0.000655702535, -0.001029363884)
    h2e[8, 4, 0, 6] = complex(-0.000786335320, -0.003031767838)
    h2e[10, 4, 0, 6] = complex(-0.000000523368, 0.000004214071)
    h2e[0, 4, 2, 6] = complex(0.000005810536, -0.000005289958)
    h2e[2, 4, 2, 6] = complex(-0.000229130005, 0.000437584361)
    h2e[4, 4, 2, 6] = complex(0.000048655096, -0.000103792341)
    h2e[6, 4, 2, 6] = complex(-0.022571820819, -0.000811265816)
    h2e[8, 4, 2, 6] = complex(-0.001429295675, 0.021157777824)
    h2e[10, 4, 2, 6] = complex(-0.000107620288, 0.000189984964)
    h2e[0, 4, 4, 6] = complex(-0.000002517034, 0.000002674458)
    h2e[2, 4, 4, 6] = complex(-0.000022217485, 0.000048763112)
    h2e[4, 4, 4, 6] = complex(-0.000019271071, 0.000047166238)
    h2e[6, 4, 4, 6] = complex(0.023177158532, -0.000000000000)
    h2e[8, 4, 4, 6] = complex(0.000692858966, -0.021231141993)
    h2e[10, 4, 4, 6] = complex(-0.000066740305, 0.000132690089)
    h2e[0, 4, 6, 6] = complex(-0.000455179029, 0.000000395543)
    h2e[2, 4, 6, 6] = complex(-0.067560249795, -0.003076192772)
    h2e[4, 4, 6, 6] = complex(0.599470600126, -0.000000000000)
    h2e[6, 4, 6, 6] = complex(0.000137760157, 0.000337170124)
    h2e[10, 4, 6, 6] = complex(-0.110908548681, -0.009027731791)
    h2e[0, 4, 8, 6] = complex(0.000000004894, 0.000000018868)
    h2e[2, 4, 8, 6] = complex(0.000000009840, -0.000000145654)
    h2e[6, 4, 8, 6] = complex(0.000046954619, -0.000019401356)
    h2e[8, 4, 8, 6] = complex(-0.000070005083, -0.000141613810)
    h2e[10, 4, 8, 6] = complex(0.000000001397, -0.000000027392)
    h2e[0, 4, 10, 6] = complex(-0.000002532033, 0.000002820784)
    h2e[2, 4, 10, 6] = complex(-0.000123149918, 0.000196794584)
    h2e[4, 4, 10, 6] = complex(0.000090116639, -0.000164382345)
    h2e[6, 4, 10, 6] = complex(-0.002133888899, -0.000040487821)
    h2e[8, 4, 10, 6] = complex(-0.000115497015, 0.002264258315)
    h2e[10, 4, 10, 6] = complex(-0.000221601940, 0.000338919016)
    h2e[0, 6, 0, 6] = complex(0.006925968824, 0.008469468982)
    h2e[2, 6, 0, 6] = complex(-0.001377729969, -0.001607862597)
    h2e[4, 6, 0, 6] = complex(0.000400191780, 0.000431678110)
    h2e[6, 6, 0, 6] = complex(0.000001352515, -0.000000557234)
    h2e[8, 6, 0, 6] = complex(0.000008806541, 0.000000065651)
    h2e[10, 6, 0, 6] = complex(0.001328808542, 0.001613121917)
    h2e[0, 6, 2, 6] = complex(-0.001377729969, -0.001607862597)
    h2e[2, 6, 2, 6] = complex(0.040178806132, 0.047232281442)
    h2e[4, 6, 2, 6] = complex(-0.015175634904, -0.016273763039)
    h2e[6, 6, 2, 6] = complex(0.000092932783, -0.000198246697)
    h2e[8, 6, 2, 6] = complex(-0.000049382759, -0.000026209043)
    h2e[10, 6, 2, 6] = complex(-0.011721149811, -0.014831907745)
    h2e[0, 6, 4, 6] = complex(0.000400191780, 0.000431678110)
    h2e[2, 6, 4, 6] = complex(-0.015175634904, -0.016273763039)
    h2e[4, 6, 4, 6] = complex(0.016315038240, 0.015964027754)
    h2e[6, 6, 4, 6] = complex(0.000137760157, -0.000337170124)
    h2e[8, 6, 4, 6] = complex(0.000047063402, 0.000023237565)
    h2e[10, 6, 4, 6] = complex(-0.001376684389, -0.001591167968)
    h2e[0, 6, 6, 6] = complex(0.000001352515, -0.000000557234)
    h2e[2, 6, 6, 6] = complex(0.000092932783, -0.000198246697)
    h2e[4, 6, 6, 6] = complex(0.000137760157, -0.000337170124)
    h2e[6, 6, 6, 6] = complex(0.721692913237, 0.000000000000)
    h2e[10, 6, 6, 6] = complex(0.000166604669, -0.000303904658)
    h2e[0, 6, 8, 6] = complex(0.000008806541, 0.000000065651)
    h2e[2, 6, 8, 6] = complex(-0.000049382759, -0.000026209043)
    h2e[4, 6, 8, 6] = complex(0.000047063402, 0.000023237565)
    h2e[8, 6, 8, 6] = complex(-0.039986261676, 0.002904023589)
    h2e[10, 6, 8, 6] = complex(-0.000002405887, -0.000001147492)
    h2e[0, 6, 10, 6] = complex(0.001328808542, 0.001613121917)
    h2e[2, 6, 10, 6] = complex(-0.011721149811, -0.014831907745)
    h2e[4, 6, 10, 6] = complex(-0.001376684389, -0.001591167968)
    h2e[6, 6, 10, 6] = complex(0.000166604669, -0.000303904658)
    h2e[8, 6, 10, 6] = complex(-0.000002405887, -0.000001147492)
    h2e[10, 6, 10, 6] = complex(0.008801916604, 0.011838078542)
    h2e[0, 8, 0, 6] = complex(0.007233934735, -0.005349067368)
    h2e[2, 8, 0, 6] = complex(0.004682891023, -0.003875820138)
    h2e[4, 8, 0, 6] = complex(-0.002210221544, 0.001999532630)
    h2e[6, 8, 0, 6] = complex(0.000006562283, 0.000004494559)
    h2e[8, 8, 0, 6] = complex(0.000001351990, -0.000000557017)
    h2e[10, 8, 0, 6] = complex(-0.000595726314, 0.000460199281)
    h2e[0, 8, 2, 6] = complex(0.004684961523, -0.003877533883)
    h2e[2, 8, 2, 6] = complex(-0.046719345595, 0.036585171480)
    h2e[4, 8, 2, 6] = complex(0.015880825810, -0.013612246610)
    h2e[6, 8, 2, 6] = complex(-0.000049016758, -0.000023177612)
    h2e[8, 8, 2, 6] = complex(0.000092932187, -0.000198245421)
    h2e[10, 8, 2, 6] = complex(0.015936335504, -0.011762817181)
    h2e[0, 8, 4, 6] = complex(-0.002211242853, 0.002000456623)
    h2e[2, 8, 4, 6] = complex(0.015880933476, -0.013612338904)
    h2e[4, 8, 4, 6] = complex(-0.015278621286, 0.014310587595)
    h2e[6, 8, 4, 6] = complex(0.000046954619, 0.000019401356)
    h2e[8, 8, 4, 6] = complex(0.000137761695, -0.000337173891)
    h2e[10, 8, 4, 6] = complex(0.001742611814, -0.001412911604)
    h2e[8, 8, 6, 6] = complex(0.721688265776, -0.000000000000)
    h2e[0, 8, 8, 6] = complex(-0.000003916748, -0.000000243397)
    h2e[2, 8, 8, 6] = complex(0.000027161424, -0.000056733644)
    h2e[4, 8, 8, 6] = complex(0.000016803943, -0.000041583788)
    h2e[6, 8, 8, 6] = complex(0.040103033684, -0.000000000000)
    h2e[10, 8, 8, 6] = complex(0.000007770768, -0.000015607398)
    h2e[0, 8, 10, 6] = complex(-0.000596005297, 0.000460414822)
    h2e[2, 8, 10, 6] = complex(0.015936320604, -0.011762806150)
    h2e[4, 8, 10, 6] = complex(0.001742499492, -0.001412820528)
    h2e[6, 8, 10, 6] = complex(-0.000002289278, -0.000001239814)
    h2e[8, 8, 10, 6] = complex(0.000166601420, -0.000303898733)
    h2e[10, 8, 10, 6] = complex(-0.011670460935, 0.007996121329)
    h2e[0, 10, 0, 6] = complex(-0.000002589585, 0.000006092285)
    h2e[2, 10, 0, 6] = complex(-0.000003331116, -0.000000527790)
    h2e[4, 10, 0, 6] = complex(0.000001918839, -0.000005088541)
    h2e[6, 10, 0, 6] = complex(0.002100003171, -0.000753764802)
    h2e[8, 10, 0, 6] = complex(-0.000857123472, -0.000713846340)
    h2e[10, 10, 0, 6] = complex(0.000004130085, -0.000001701588)
    h2e[0, 10, 2, 6] = complex(-0.000008198837, 0.000019370711)
    h2e[2, 10, 2, 6] = complex(-0.000020269077, 0.000046059985)
    h2e[4, 10, 2, 6] = complex(-0.000105227206, 0.000279652285)
    h2e[6, 10, 2, 6] = complex(-0.019167069183, -0.000308683547)
    h2e[8, 10, 2, 6] = complex(0.001373828747, 0.020043122366)
    h2e[10, 10, 2, 6] = complex(-0.000078431273, 0.000167311684)
    h2e[0, 10, 4, 6] = complex(0.000003139960, -0.000008627045)
    h2e[2, 10, 4, 6] = complex(-0.000082090265, 0.000223997390)
    h2e[4, 10, 4, 6] = complex(-0.000053264781, 0.000166870717)
    h2e[6, 10, 4, 6] = complex(-0.002133888899, 0.000040487821)
    h2e[8, 10, 4, 6] = complex(0.000237466121, 0.002263694913)
    h2e[10, 10, 4, 6] = complex(-0.000027437730, 0.000067154271)
    h2e[0, 10, 6, 6] = complex(-0.001604748401, 0.000014558568)
    h2e[2, 10, 6, 6] = complex(-0.104437556596, 0.003707380766)
    h2e[4, 10, 6, 6] = complex(-0.110908548681, 0.009027731791)
    h2e[6, 10, 6, 6] = complex(0.000166604669, 0.000303904658)
    h2e[10, 10, 6, 6] = complex(0.551545232675, 0.000000000000)
    h2e[0, 10, 8, 6] = complex(0.000000001684, 0.000000001403)
    h2e[2, 10, 8, 6] = complex(-0.000000001470, -0.000000021453)
    h2e[4, 10, 8, 6] = complex(0.000000002873, 0.000000027383)
    h2e[6, 10, 8, 6] = complex(-0.000002289278, 0.000001239814)
    h2e[8, 10, 8, 6] = complex(-0.000006104966, -0.000010917121)
    h2e[0, 10, 10, 6] = complex(-0.000004731698, 0.000008483083)
    h2e[2, 10, 10, 6] = complex(-0.000070266305, 0.000139168110)
    h2e[4, 10, 10, 6] = complex(-0.000134847656, 0.000298681041)
    h2e[6, 10, 10, 6] = complex(0.014920294445, -0.000000000000)
    h2e[8, 10, 10, 6] = complex(-0.001197994406, -0.014289313060)
    h2e[10, 10, 10, 6] = complex(-0.000049532772, 0.000090353051)
    h2e[2, 0, 0, 8] = complex(-0.000000379501, -0.000000172056)
    h2e[4, 0, 0, 8] = complex(-0.000019576210, -0.000007708682)
    h2e[6, 0, 0, 8] = complex(-0.000664391211, -0.009137152312)
    h2e[8, 0, 0, 8] = complex(0.011100485429, -0.000000000000)
    h2e[10, 0, 0, 8] = complex(-0.000006412929, -0.000003347641)
    h2e[2, 0, 2, 8] = complex(-0.000000258078, -0.000000191070)
    h2e[4, 0, 2, 8] = complex(-0.000012236078, -0.000007737933)
    h2e[6, 0, 2, 8] = complex(0.002157838719, -0.006097609151)
    h2e[8, 0, 2, 8] = complex(-0.002128118993, 0.001972035719)
    h2e[10, 0, 2, 8] = complex(-0.000000340382, -0.000000958109)
    h2e[2, 0, 4, 8] = complex(0.000000135933, 0.000000085962)
    h2e[4, 0, 4, 8] = complex(0.000006231260, 0.000003374587)
    h2e[6, 0, 4, 8] = complex(-0.000786335320, 0.003031767838)
    h2e[8, 0, 4, 8] = complex(0.000548528097, -0.000887630786)
    h2e[10, 0, 4, 8] = complex(0.000000359835, 0.000000503868)
    h2e[4, 0, 6, 8] = complex(0.000000004894, -0.000000018868)
    h2e[6, 0, 6, 8] = complex(0.000008806541, -0.000000065651)
    h2e[8, 0, 6, 8] = complex(-0.000003916748, 0.000000243397)
    h2e[10, 0, 6, 8] = complex(0.000000001684, -0.000000001403)
    h2e[0, 0, 8, 8] = complex(0.966731902319, -0.000000000000)
    h2e[2, 0, 8, 8] = complex(0.001607436821, 0.000026591538)
    h2e[4, 0, 8, 8] = complex(-0.000455005844, -0.000000395393)
    h2e[6, 0, 8, 8] = complex(0.000001351990, 0.000000557017)
    h2e[10, 0, 8, 8] = complex(-0.001604043452, -0.000014552173)
    h2e[2, 0, 10, 8] = complex(0.000000011680, 0.000000032878)
    h2e[4, 0, 10, 8] = complex(0.000001137669, 0.000001593049)
    h2e[6, 0, 10, 8] = complex(-0.000857123472, 0.000713846340)
    h2e[8, 0, 10, 8] = complex(0.002136669248, -0.000614849289)
    h2e[10, 0, 10, 8] = complex(-0.000000621941, -0.000000058023)
    h2e[0, 2, 0, 8] = complex(0.000000375497, 0.000000180250)
    h2e[4, 2, 0, 8] = complex(-0.000013467510, -0.000008726083)
    h2e[6, 2, 0, 8] = complex(0.002224712955, -0.006055679436)
    h2e[8, 2, 0, 8] = complex(-0.002128118993, -0.001972035719)
    h2e[10, 2, 0, 8] = complex(-0.000000204382, -0.000000565969)
    h2e[0, 2, 2, 8] = complex(0.000000255698, 0.000000193188)
    h2e[4, 2, 2, 8] = complex(0.000142483926, 0.000060610933)
    h2e[6, 2, 2, 8] = complex(0.000741923269, 0.060141289510)
    h2e[8, 2, 2, 8] = complex(0.062888762683, -0.000000000000)
    h2e[10, 2, 2, 8] = complex(0.000021427665, 0.000011902200)
    h2e[0, 2, 4, 8] = complex(-0.000000134771, -0.000000087323)
    h2e[4, 2, 4, 8] = complex(-0.000052525726, -0.000019325655)
    h2e[6, 2, 4, 8] = complex(-0.001429295675, -0.021157777824)
    h2e[8, 2, 4, 8] = complex(-0.022529338111, 0.001212645216)
    h2e[10, 2, 4, 8] = complex(-0.000007272305, -0.000003572378)
    h2e[4, 2, 6, 8] = complex(0.000000009840, 0.000000145654)
    h2e[6, 2, 6, 8] = complex(-0.000049382759, 0.000026209043)
    h2e[8, 2, 6, 8] = complex(0.000027161424, 0.000056733644)
    h2e[10, 2, 6, 8] = complex(-0.000000001470, 0.000000021453)
    h2e[0, 2, 8, 8] = complex(0.001607436821, -0.000026591538)
    h2e[2, 2, 8, 8] = complex(0.652877324645, 0.000000000000)
    h2e[4, 2, 8, 8] = complex(-0.067559924170, 0.003076177945)
    h2e[6, 2, 8, 8] = complex(0.000092932187, 0.000198245421)
    h2e[10, 2, 8, 8] = complex(-0.104436066373, -0.003707327865)
    h2e[0, 2, 10, 8] = complex(-0.000000011591, -0.000000032099)
    h2e[4, 2, 10, 8] = complex(-0.000045566933, -0.000022383877)
    h2e[6, 2, 10, 8] = complex(0.001373828747, -0.020043122366)
    h2e[8, 2, 10, 8] = complex(-0.019160880543, -0.001533762494)
    h2e[10, 2, 10, 8] = complex(-0.000006746646, -0.000004322147)
    h2e[0, 4, 0, 8] = complex(0.000018592605, 0.000009841164)
    h2e[2, 4, 0, 8] = complex(0.000012570799, 0.000010001280)
    h2e[6, 4, 0, 8] = complex(-0.001110231618, 0.002927611676)
    h2e[8, 4, 0, 8] = complex(0.000548528097, 0.000887630786)
    h2e[10, 4, 0, 8] = complex(-0.000000886858, -0.000001563600)
    h2e[0, 4, 2, 8] = complex(0.000011323759, 0.000009009139)
    h2e[2, 4, 2, 8] = complex(-0.000136450068, -0.000073262307)
    h2e[6, 4, 2, 8] = complex(0.000486118069, -0.021211236291)
    h2e[8, 4, 2, 8] = complex(-0.022529338111, -0.001212645216)
    h2e[10, 4, 2, 8] = complex(0.000036047984, 0.000022002706)
    h2e[0, 4, 4, 8] = complex(-0.000005826991, -0.000004027873)
    h2e[2, 4, 4, 8] = complex(0.000050578812, 0.000023992305)
    h2e[6, 4, 4, 8] = complex(0.000692858966, 0.021231141993)
    h2e[8, 4, 4, 8] = complex(0.023142194872, -0.000000000000)
    h2e[10, 4, 4, 8] = complex(0.000012514987, 0.000006797960)
    h2e[0, 4, 6, 8] = complex(-0.000000006906, 0.000000018212)
    h2e[2, 4, 6, 8] = complex(0.000000003347, -0.000000146021)
    h2e[6, 4, 6, 8] = complex(0.000047063402, -0.000023237565)
    h2e[8, 4, 6, 8] = complex(0.000016803943, 0.000041583788)
    h2e[10, 4, 6, 8] = complex(0.000000002873, -0.000000027383)
    h2e[0, 4, 8, 8] = complex(-0.000455005844, 0.000000395393)
    h2e[2, 4, 8, 8] = complex(-0.067559924170, -0.003076177945)
    h2e[4, 4, 8, 8] = complex(0.599463715830, -0.000000000000)
    h2e[6, 4, 8, 8] = complex(0.000137761695, 0.000337173891)
    h2e[10, 4, 8, 8] = complex(-0.110905457147, -0.009027480147)
    h2e[0, 4, 10, 8] = complex(-0.000000962205, -0.000001696441)
    h2e[2, 4, 10, 8] = complex(0.000043343717, 0.000026455820)
    h2e[6, 4, 10, 8] = complex(0.000237466121, -0.002263694913)
    h2e[8, 4, 10, 8] = complex(-0.002121144000, -0.000287663146)
    h2e[10, 4, 10, 8] = complex(-0.000030362203, -0.000021218576)
    h2e[0, 6, 0, 8] = complex(0.007233934735, -0.005349067368)
    h2e[2, 6, 0, 8] = complex(0.004684961523, -0.003877533883)
    h2e[4, 6, 0, 8] = complex(-0.002211242853, 0.002000456623)
    h2e[8, 6, 0, 8] = complex(-0.000003916748, -0.000000243397)
    h2e[10, 6, 0, 8] = complex(-0.000596005297, 0.000460414822)
    h2e[0, 6, 2, 8] = complex(0.004682891023, -0.003875820138)
    h2e[2, 6, 2, 8] = complex(-0.046719345595, 0.036585171480)
    h2e[4, 6, 2, 8] = complex(0.015880933476, -0.013612338904)
    h2e[8, 6, 2, 8] = complex(0.000027161424, -0.000056733644)
    h2e[10, 6, 2, 8] = complex(0.015936320604, -0.011762806150)
    h2e[0, 6, 4, 8] = complex(-0.002210221544, 0.001999532630)
    h2e[2, 6, 4, 8] = complex(0.015880825810, -0.013612246610)
    h2e[4, 6, 4, 8] = complex(-0.015278621286, 0.014310587595)
    h2e[8, 6, 4, 8] = complex(0.000016803943, -0.000041583788)
    h2e[10, 6, 4, 8] = complex(0.001742499492, -0.001412820528)
    h2e[0, 6, 6, 8] = complex(0.000006562283, 0.000004494559)
    h2e[2, 6, 6, 8] = complex(-0.000049016758, -0.000023177612)
    h2e[4, 6, 6, 8] = complex(0.000046954619, 0.000019401356)
    h2e[8, 6, 6, 8] = complex(0.040103033684, -0.000000000000)
    h2e[10, 6, 6, 8] = complex(-0.000002289278, -0.000001239814)
    h2e[0, 6, 8, 8] = complex(0.000001351990, -0.000000557017)
    h2e[2, 6, 8, 8] = complex(0.000092932187, -0.000198245421)
    h2e[4, 6, 8, 8] = complex(0.000137761695, -0.000337173891)
    h2e[6, 6, 8, 8] = complex(0.721688265776, -0.000000000000)
    h2e[10, 6, 8, 8] = complex(0.000166601420, -0.000303898733)
    h2e[0, 6, 10, 8] = complex(-0.000595726314, 0.000460199281)
    h2e[2, 6, 10, 8] = complex(0.015936335504, -0.011762817181)
    h2e[4, 6, 10, 8] = complex(0.001742611814, -0.001412911604)
    h2e[8, 6, 10, 8] = complex(0.000007770768, -0.000015607398)
    h2e[10, 6, 10, 8] = complex(-0.011670460935, 0.007996121329)
    h2e[0, 8, 0, 8] = complex(-0.006324084457, -0.008991263752)
    h2e[2, 8, 0, 8] = complex(0.001262667870, 0.001710245811)
    h2e[4, 8, 0, 8] = complex(-0.000369337608, -0.000461370132)
    h2e[6, 8, 0, 8] = complex(0.000000510665, 0.000001934362)
    h2e[10, 8, 0, 8] = complex(-0.001213282281, -0.001711919210)
    h2e[0, 8, 2, 8] = complex(0.001262667870, 0.001710245811)
    h2e[2, 8, 2, 8] = complex(-0.036788714361, -0.050205135104)
    h2e[4, 8, 2, 8] = complex(0.014008291047, 0.017393960593)
    h2e[6, 8, 2, 8] = complex(0.000026166237, -0.000047904875)
    h2e[10, 8, 2, 8] = complex(0.010655057639, 0.015699439039)
    h2e[0, 8, 4, 8] = complex(-0.000369337608, -0.000461370132)
    h2e[2, 8, 4, 8] = complex(0.014008291047, 0.017393960593)
    h2e[4, 8, 4, 8] = complex(-0.015173081976, -0.017168651741)
    h2e[6, 8, 4, 8] = complex(-0.000070005083, 0.000141613810)
    h2e[10, 8, 4, 8] = complex(0.001262849997, 0.001693432841)
    h2e[0, 8, 6, 8] = complex(0.000000510665, 0.000001934362)
    h2e[2, 8, 6, 8] = complex(0.000026166237, -0.000047904875)
    h2e[4, 8, 6, 8] = complex(-0.000070005083, 0.000141613810)
    h2e[6, 8, 6, 8] = complex(-0.039986261676, -0.002904023589)
    h2e[10, 8, 6, 8] = complex(-0.000006104966, 0.000010917121)
    h2e[8, 8, 8, 8] = complex(0.721683619311, -0.000000000000)
    h2e[0, 8, 10, 8] = complex(-0.001213282281, -0.001711919210)
    h2e[2, 8, 10, 8] = complex(0.010655057639, 0.015699439039)
    h2e[4, 8, 10, 8] = complex(0.001262849997, 0.001693432841)
    h2e[6, 8, 10, 8] = complex(-0.000006104966, 0.000010917121)
    h2e[10, 8, 10, 8] = complex(-0.007951826194, -0.012492638935)
    h2e[0, 10, 0, 8] = complex(0.000006528021, 0.000003084899)
    h2e[2, 10, 0, 8] = complex(0.000000286061, 0.000000455578)
    h2e[4, 10, 0, 8] = complex(0.000001217766, 0.000001168668)
    h2e[6, 10, 0, 8] = complex(-0.000699588775, 0.000751517559)
    h2e[8, 10, 0, 8] = complex(0.002136669248, 0.000614849289)
    h2e[0, 10, 2, 8] = complex(0.000000472786, 0.000000752955)
    h2e[2, 10, 2, 8] = complex(-0.000022140202, -0.000010427682)
    h2e[4, 10, 2, 8] = complex(-0.000038976468, -0.000016066180)
    h2e[6, 10, 2, 8] = complex(0.000059475193, -0.020021783401)
    h2e[8, 10, 2, 8] = complex(-0.019160880543, 0.001533762494)
    h2e[0, 10, 4, 8] = complex(-0.000000417892, -0.000000401044)
    h2e[2, 10, 4, 8] = complex(0.000007479451, 0.000003083048)
    h2e[4, 10, 4, 8] = complex(-0.000013394199, -0.000004767538)
    h2e[6, 10, 4, 8] = complex(-0.000115497015, -0.002264258315)
    h2e[8, 10, 4, 8] = complex(-0.002121144000, 0.000287663146)
    h2e[0, 10, 6, 8] = complex(-0.000000001374, 0.000000001476)
    h2e[2, 10, 6, 8] = complex(0.000000000064, -0.000000021430)
    h2e[4, 10, 6, 8] = complex(0.000000001397, 0.000000027392)
    h2e[6, 10, 6, 8] = complex(-0.000002405887, 0.000001147492)
    h2e[8, 10, 6, 8] = complex(0.000007770768, 0.000015607398)
    h2e[0, 10, 8, 8] = complex(-0.001604043452, 0.000014552173)
    h2e[2, 10, 8, 8] = complex(-0.104436066373, 0.003707327865)
    h2e[4, 10, 8, 8] = complex(-0.110905457147, 0.009027480147)
    h2e[6, 10, 8, 8] = complex(0.000166601420, 0.000303898733)
    h2e[10, 10, 8, 8] = complex(0.551538006028, 0.000000000000)
    h2e[0, 10, 10, 8] = complex(0.000000590308, 0.000000091451)
    h2e[2, 10, 10, 8] = complex(0.000007031844, 0.000003806432)
    h2e[4, 10, 10, 8] = complex(0.000033352883, 0.000015924217)
    h2e[6, 10, 10, 8] = complex(-0.001197994406, 0.014289313060)
    h2e[8, 10, 10, 8] = complex(0.015012857110, -0.000000000000)
    h2e[0, 0, 0, 10] = complex(-0.062997221645, 0.000571522212)
    h2e[2, 0, 0, 10] = complex(-0.001534473412, -0.000011461790)
    h2e[4, 0, 0, 10] = complex(-0.000141628797, 0.000001160593)
    h2e[6, 0, 0, 10] = complex(0.000003794565, 0.000006280735)
    h2e[8, 0, 0, 10] = complex(-0.000006412929, 0.000003347641)
    h2e[10, 0, 0, 10] = complex(0.004490286136, -0.000000000000)
    h2e[0, 0, 2, 10] = complex(-0.202563653096, 0.007190713913)
    h2e[2, 0, 2, 10] = complex(-0.000538788772, 0.000010207135)
    h2e[4, 0, 2, 10] = complex(0.001391115643, -0.000048172044)
    h2e[6, 0, 2, 10] = complex(-0.000004842621, -0.000003863857)
    h2e[8, 0, 2, 10] = complex(-0.000000204382, 0.000000565969)
    h2e[10, 0, 2, 10] = complex(-0.004872829449, 0.000128729610)
    h2e[0, 0, 4, 10] = complex(-0.213163158391, 0.017351050434)
    h2e[2, 0, 4, 10] = complex(-0.000653790364, 0.000042344657)
    h2e[4, 0, 4, 10] = complex(-0.000343421481, 0.000027653725)
    h2e[6, 0, 4, 10] = complex(-0.000000523368, -0.000004214071)
    h2e[8, 0, 4, 10] = complex(-0.000000886858, 0.000001563600)
    h2e[10, 0, 4, 10] = complex(0.003219687627, -0.000232694808)
    h2e[0, 0, 6, 10] = complex(0.000290573890, 0.000530037720)
    h2e[2, 0, 6, 10] = complex(0.000000665822, 0.000001301627)
    h2e[4, 0, 6, 10] = complex(-0.000002532033, -0.000002820784)
    h2e[6, 0, 6, 10] = complex(0.001328808542, -0.001613121917)
    h2e[8, 0, 6, 10] = complex(-0.000596005297, -0.000460414822)
    h2e[10, 0, 6, 10] = complex(-0.000004731698, -0.000008483083)
    h2e[2, 0, 8, 10] = complex(-0.000000011591, 0.000000032099)
    h2e[4, 0, 8, 10] = complex(-0.000000962205, 0.000001696441)
    h2e[6, 0, 8, 10] = complex(-0.000595726314, -0.000460199281)
    h2e[8, 0, 8, 10] = complex(-0.001213282281, 0.001711919210)
    h2e[10, 0, 8, 10] = complex(0.000000590308, -0.000000091451)
    h2e[0, 0, 10, 10] = complex(0.764008571320, 0.000000000000)
    h2e[2, 0, 10, 10] = complex(0.001065703095, 0.000017629734)
    h2e[4, 0, 10, 10] = complex(-0.001422716309, -0.000001236317)
    h2e[6, 0, 10, 10] = complex(0.000004130085, 0.000001701588)
    h2e[10, 0, 10, 10] = complex(0.003947281852, 0.000035810456)
    h2e[0, 2, 0, 10] = complex(-0.001534013486, 0.000039299653)
    h2e[2, 2, 0, 10] = complex(0.001636227069, -0.000014844148)
    h2e[4, 2, 0, 10] = complex(0.008458064850, -0.000462041327)
    h2e[6, 2, 0, 10] = complex(-0.000008345533, -0.000015621401)
    h2e[8, 2, 0, 10] = complex(-0.000000340382, 0.000000958109)
    h2e[10, 2, 0, 10] = complex(-0.004872829449, -0.000128729610)
    h2e[0, 2, 2, 10] = complex(-0.000538156073, 0.000028022836)
    h2e[2, 2, 2, 10] = complex(-0.092349463723, 0.003278271119)
    h2e[4, 2, 2, 10] = complex(-0.002993879580, 0.000242990125)
    h2e[6, 2, 2, 10] = complex(-0.000001450826, -0.000004257696)
    h2e[8, 2, 2, 10] = complex(0.000021427665, -0.000011902200)
    h2e[10, 2, 2, 10] = complex(0.086507035696, 0.000000000000)
    h2e[0, 2, 4, 10] = complex(-0.000652031555, 0.000063946611)
    h2e[2, 2, 4, 10] = complex(-0.058364955234, 0.004750789440)
    h2e[4, 2, 4, 10] = complex(0.091085551947, -0.011604550045)
    h2e[6, 2, 4, 10] = complex(-0.000107620288, -0.000189984964)
    h2e[8, 2, 4, 10] = complex(0.000036047984, -0.000022002706)
    h2e[10, 2, 4, 10] = complex(0.052483976181, -0.002402044351)
    h2e[0, 2, 6, 10] = complex(0.000000839560, 0.000001446399)
    h2e[2, 2, 6, 10] = complex(0.000083082445, 0.000151551228)
    h2e[4, 2, 6, 10] = complex(-0.000123149918, -0.000196794584)
    h2e[6, 2, 6, 10] = complex(-0.011721149811, 0.014831907745)
    h2e[8, 2, 6, 10] = complex(0.015936320604, 0.011762806150)
    h2e[10, 2, 6, 10] = complex(-0.000070266305, -0.000139168110)
    h2e[0, 2, 8, 10] = complex(0.000000011680, -0.000000032878)
    h2e[4, 2, 8, 10] = complex(0.000043343717, -0.000026455820)
    h2e[6, 2, 8, 10] = complex(0.015936335504, 0.011762817181)
    h2e[8, 2, 8, 10] = complex(0.010655057639, -0.015699439039)
    h2e[10, 2, 8, 10] = complex(0.000007031844, -0.000003806432)
    h2e[0, 2, 10, 10] = complex(0.001065703095, -0.000017629734)
    h2e[2, 2, 10, 10] = complex(0.600972926144, -0.000000000000)
    h2e[4, 2, 10, 10] = complex(0.076193473301, -0.003469285749)
    h2e[6, 2, 10, 10] = complex(-0.000078431273, -0.000167311684)
    h2e[10, 2, 10, 10] = complex(-0.033380952990, -0.001184975090)
    h2e[0, 4, 0, 10] = complex(-0.000141658584, 0.000001407657)
    h2e[2, 4, 0, 10] = complex(0.008465046918, 0.000308511341)
    h2e[4, 4, 0, 10] = complex(-0.005883397738, 0.000053375251)
    h2e[6, 4, 0, 10] = complex(0.000003125244, 0.000006583817)
    h2e[8, 4, 0, 10] = complex(0.000000359835, -0.000000503868)
    h2e[10, 4, 0, 10] = complex(0.003219687627, 0.000232694808)
    h2e[0, 4, 2, 10] = complex(0.001391041193, -0.000050589844)
    h2e[2, 4, 2, 10] = complex(-0.003003692262, -0.000030090448)
    h2e[4, 4, 2, 10] = complex(-0.016157852788, 0.000573580181)
    h2e[6, 4, 2, 10] = complex(-0.000104355279, -0.000230861264)
    h2e[8, 4, 2, 10] = complex(-0.000007272305, 0.000003572378)
    h2e[10, 4, 2, 10] = complex(0.052483976181, 0.002402044351)
    h2e[0, 4, 4, 10] = complex(-0.000343351163, 0.000028249362)
    h2e[2, 4, 4, 10] = complex(0.091763033710, -0.003278964657)
    h2e[4, 4, 4, 10] = complex(-0.070266672479, 0.005719565178)
    h2e[6, 4, 4, 10] = complex(-0.000066740305, -0.000132690089)
    h2e[8, 4, 4, 10] = complex(0.000012514987, -0.000006797960)
    h2e[10, 4, 4, 10] = complex(0.124453179373, 0.000000000000)
    h2e[0, 4, 6, 10] = complex(0.000003257370, 0.000005253733)
    h2e[2, 4, 6, 10] = complex(-0.000142376643, -0.000296679114)
    h2e[4, 4, 6, 10] = complex(0.000090116639, 0.000164382345)
    h2e[6, 4, 6, 10] = complex(-0.001376684389, 0.001591167968)
    h2e[8, 4, 6, 10] = complex(0.001742499492, 0.001412820528)
    h2e[10, 4, 6, 10] = complex(-0.000134847656, -0.000298681041)
    h2e[0, 4, 8, 10] = complex(0.000001137669, -0.000001593049)
    h2e[2, 4, 8, 10] = complex(-0.000045566933, 0.000022383877)
    h2e[6, 4, 8, 10] = complex(0.001742611814, 0.001412911604)
    h2e[8, 4, 8, 10] = complex(0.001262849997, -0.001693432841)
    h2e[10, 4, 8, 10] = complex(0.000033352883, -0.000015924217)
    h2e[0, 4, 10, 10] = complex(-0.001422716309, 0.000001236317)
    h2e[2, 4, 10, 10] = complex(0.076193473301, 0.003469285749)
    h2e[4, 4, 10, 10] = complex(0.574398690829, -0.000000000000)
    h2e[6, 4, 10, 10] = complex(-0.000027437730, -0.000067154271)
    h2e[10, 4, 10, 10] = complex(0.025569237766, 0.002081284296)
    h2e[0, 6, 0, 10] = complex(-0.000002589585, 0.000006092285)
    h2e[2, 6, 0, 10] = complex(-0.000008198837, 0.000019370711)
    h2e[4, 6, 0, 10] = complex(0.000003139960, -0.000008627045)
    h2e[6, 6, 0, 10] = complex(-0.001604748401, 0.000014558568)
    h2e[8, 6, 0, 10] = complex(0.000000001684, 0.000000001403)
    h2e[10, 6, 0, 10] = complex(-0.000004731698, 0.000008483083)
    h2e[0, 6, 2, 10] = complex(-0.000003331116, -0.000000527790)
    h2e[2, 6, 2, 10] = complex(-0.000020269077, 0.000046059985)
    h2e[4, 6, 2, 10] = complex(-0.000082090265, 0.000223997390)
    h2e[6, 6, 2, 10] = complex(-0.104437556596, 0.003707380766)
    h2e[8, 6, 2, 10] = complex(-0.000000001470, -0.000000021453)
    h2e[10, 6, 2, 10] = complex(-0.000070266305, 0.000139168110)
    h2e[0, 6, 4, 10] = complex(0.000001918839, -0.000005088541)
    h2e[2, 6, 4, 10] = complex(-0.000105227206, 0.000279652285)
    h2e[4, 6, 4, 10] = complex(-0.000053264781, 0.000166870717)
    h2e[6, 6, 4, 10] = complex(-0.110908548681, 0.009027731791)
    h2e[8, 6, 4, 10] = complex(0.000000002873, 0.000000027383)
    h2e[10, 6, 4, 10] = complex(-0.000134847656, 0.000298681041)
    h2e[0, 6, 6, 10] = complex(0.002100003171, -0.000753764802)
    h2e[2, 6, 6, 10] = complex(-0.019167069183, -0.000308683547)
    h2e[4, 6, 6, 10] = complex(-0.002133888899, 0.000040487821)
    h2e[6, 6, 6, 10] = complex(0.000166604669, 0.000303904658)
    h2e[8, 6, 6, 10] = complex(-0.000002289278, 0.000001239814)
    h2e[10, 6, 6, 10] = complex(0.014920294445, -0.000000000000)
    h2e[0, 6, 8, 10] = complex(-0.000857123472, -0.000713846340)
    h2e[2, 6, 8, 10] = complex(0.001373828747, 0.020043122366)
    h2e[4, 6, 8, 10] = complex(0.000237466121, 0.002263694913)
    h2e[8, 6, 8, 10] = complex(-0.000006104966, -0.000010917121)
    h2e[10, 6, 8, 10] = complex(-0.001197994406, -0.014289313060)
    h2e[0, 6, 10, 10] = complex(0.000004130085, -0.000001701588)
    h2e[2, 6, 10, 10] = complex(-0.000078431273, 0.000167311684)
    h2e[4, 6, 10, 10] = complex(-0.000027437730, 0.000067154271)
    h2e[6, 6, 10, 10] = complex(0.551545232675, 0.000000000000)
    h2e[10, 6, 10, 10] = complex(-0.000049532772, 0.000090353051)
    h2e[0, 8, 0, 10] = complex(0.000006528021, 0.000003084899)
    h2e[2, 8, 0, 10] = complex(0.000000472786, 0.000000752955)
    h2e[4, 8, 0, 10] = complex(-0.000000417892, -0.000000401044)
    h2e[6, 8, 0, 10] = complex(-0.000000001374, 0.000000001476)
    h2e[8, 8, 0, 10] = complex(-0.001604043452, 0.000014552173)
    h2e[10, 8, 0, 10] = complex(0.000000590308, 0.000000091451)
    h2e[0, 8, 2, 10] = complex(0.000000286061, 0.000000455578)
    h2e[2, 8, 2, 10] = complex(-0.000022140202, -0.000010427682)
    h2e[4, 8, 2, 10] = complex(0.000007479451, 0.000003083048)
    h2e[6, 8, 2, 10] = complex(0.000000000064, -0.000000021430)
    h2e[8, 8, 2, 10] = complex(-0.104436066373, 0.003707327865)
    h2e[10, 8, 2, 10] = complex(0.000007031844, 0.000003806432)
    h2e[0, 8, 4, 10] = complex(0.000001217766, 0.000001168668)
    h2e[2, 8, 4, 10] = complex(-0.000038976468, -0.000016066180)
    h2e[4, 8, 4, 10] = complex(-0.000013394199, -0.000004767538)
    h2e[6, 8, 4, 10] = complex(0.000000001397, 0.000000027392)
    h2e[8, 8, 4, 10] = complex(-0.110905457147, 0.009027480147)
    h2e[10, 8, 4, 10] = complex(0.000033352883, 0.000015924217)
    h2e[0, 8, 6, 10] = complex(-0.000699588775, 0.000751517559)
    h2e[2, 8, 6, 10] = complex(0.000059475193, -0.020021783401)
    h2e[4, 8, 6, 10] = complex(-0.000115497015, -0.002264258315)
    h2e[6, 8, 6, 10] = complex(-0.000002405887, 0.000001147492)
    h2e[8, 8, 6, 10] = complex(0.000166601420, 0.000303898733)
    h2e[10, 8, 6, 10] = complex(-0.001197994406, 0.014289313060)
    h2e[0, 8, 8, 10] = complex(0.002136669248, 0.000614849289)
    h2e[2, 8, 8, 10] = complex(-0.019160880543, 0.001533762494)
    h2e[4, 8, 8, 10] = complex(-0.002121144000, 0.000287663146)
    h2e[6, 8, 8, 10] = complex(0.000007770768, 0.000015607398)
    h2e[10, 8, 8, 10] = complex(0.015012857110, -0.000000000000)
    h2e[8, 8, 10, 10] = complex(0.551538006028, 0.000000000000)
    h2e[0, 10, 0, 10] = complex(0.004489536762, -0.000081466343)
    h2e[2, 10, 0, 10] = complex(-0.004869691038, 0.000217115553)
    h2e[4, 10, 0, 10] = complex(0.003214937129, -0.000291070833)
    h2e[6, 10, 0, 10] = complex(-0.000004287840, -0.000008143177)
    h2e[8, 10, 0, 10] = complex(-0.000000621941, 0.000000058023)
    h2e[10, 10, 0, 10] = complex(0.003947281852, -0.000035810456)
    h2e[0, 10, 2, 10] = complex(-0.004869691038, 0.000217115553)
    h2e[2, 10, 2, 10] = complex(0.086289267609, -0.006134015822)
    h2e[4, 10, 2, 10] = complex(0.052181507289, -0.006117513302)
    h2e[6, 10, 2, 10] = complex(-0.000088201934, -0.000148712389)
    h2e[8, 10, 2, 10] = complex(-0.000006746646, 0.000004322147)
    h2e[10, 10, 2, 10] = complex(-0.033380952990, 0.001184975090)
    h2e[0, 10, 4, 10] = complex(0.003214937129, -0.000291070833)
    h2e[2, 10, 4, 10] = complex(0.052181507289, -0.006117513302)
    h2e[4, 10, 4, 10] = complex(0.122814667600, -0.020127086862)
    h2e[6, 10, 4, 10] = complex(-0.000221601940, -0.000338919016)
    h2e[8, 10, 4, 10] = complex(-0.000030362203, 0.000021218576)
    h2e[10, 10, 4, 10] = complex(0.025569237766, -0.002081284296)
    h2e[0, 10, 6, 10] = complex(-0.000004287840, -0.000008143177)
    h2e[2, 10, 6, 10] = complex(-0.000088201934, -0.000148712389)
    h2e[4, 10, 6, 10] = complex(-0.000221601940, -0.000338919016)
    h2e[6, 10, 6, 10] = complex(0.008801916604, -0.011838078542)
    h2e[8, 10, 6, 10] = complex(-0.011670460935, -0.007996121329)
    h2e[10, 10, 6, 10] = complex(-0.000049532772, -0.000090353051)
    h2e[0, 10, 8, 10] = complex(-0.000000621941, 0.000000058023)
    h2e[2, 10, 8, 10] = complex(-0.000006746646, 0.000004322147)
    h2e[4, 10, 8, 10] = complex(-0.000030362203, 0.000021218576)
    h2e[6, 10, 8, 10] = complex(-0.011670460935, -0.007996121329)
    h2e[8, 10, 8, 10] = complex(-0.007951826194, 0.012492638935)
    h2e[0, 10, 10, 10] = complex(0.003947281852, -0.000035810456)
    h2e[2, 10, 10, 10] = complex(-0.033380952990, 0.001184975090)
    h2e[4, 10, 10, 10] = complex(0.025569237766, -0.002081284296)
    h2e[6, 10, 10, 10] = complex(-0.000049532772, -0.000090353051)
    h2e[10, 10, 10, 10] = complex(0.666720377764, -0.000000000000)
    h2e[2, 1, 0, 0] = complex(0.361074525506, 0.020828200324)
    h2e[4, 1, 0, 0] = complex(-0.166797154588, -0.001946077945)
    h2e[6, 1, 0, 0] = complex(0.000158487300, 0.000411328741)
    h2e[10, 1, 0, 0] = complex(-0.129304722944, -0.012495694857)
    h2e[2, 1, 2, 0] = complex(0.007759747570, 0.000576531057)
    h2e[4, 1, 2, 0] = complex(-0.003240994971, -0.000091446624)
    h2e[6, 1, 2, 0] = complex(0.000002931845, 0.000008110141)
    h2e[8, 1, 2, 0] = complex(-0.000000217529, 0.000000131303)
    h2e[10, 1, 2, 0] = complex(-0.003144071674, -0.000356417058)
    h2e[2, 1, 4, 0] = complex(-0.002033579095, -0.000119077967)
    h2e[4, 1, 4, 0] = complex(0.002043072652, 0.000025612504)
    h2e[6, 1, 4, 0] = complex(-0.000003728812, -0.000004003805)
    h2e[8, 1, 4, 0] = complex(-0.000012169887, 0.000007914834)
    h2e[10, 1, 4, 0] = complex(-0.000290711722, -0.000028348209)
    h2e[2, 1, 6, 0] = complex(0.000006077157, 0.000002863868)
    h2e[4, 1, 6, 0] = complex(-0.000004098117, -0.000003793856)
    h2e[6, 1, 6, 0] = complex(0.000049036736, 0.000045927962)
    h2e[8, 1, 6, 0] = complex(-0.004663056913, -0.004199600399)
    h2e[10, 1, 6, 0] = complex(0.000000457692, -0.000002222619)
    h2e[2, 1, 8, 0] = complex(-0.000000217530, 0.000000131302)
    h2e[4, 1, 8, 0] = complex(-0.000012169886, 0.000007914834)
    h2e[6, 1, 8, 0] = complex(-0.004663056870, -0.004199600431)
    h2e[8, 1, 8, 0] = complex(-0.000052481112, -0.000042437579)
    h2e[10, 1, 8, 0] = complex(-0.000001513453, 0.000001112761)
    h2e[2, 1, 10, 0] = complex(-0.009856861006, -0.000658350314)
    h2e[4, 1, 10, 0] = complex(-0.001451110460, -0.000030098725)
    h2e[6, 1, 10, 0] = complex(0.000001791597, 0.000006186235)
    h2e[8, 1, 10, 0] = complex(-0.000001513453, 0.000001112761)
    h2e[10, 1, 10, 0] = complex(0.009207672177, 0.000974194839)
    h2e[0, 3, 0, 0] = complex(0.361674738938, 0.000100528206)
    h2e[4, 3, 0, 0] = complex(0.007226554178, -0.000580981524)
    h2e[6, 3, 0, 0] = complex(0.000020579060, -0.000039266244)
    h2e[10, 3, 0, 0] = complex(-0.062177435643, 0.000770643054)
    h2e[0, 3, 2, 0] = complex(0.007780034980, 0.000130866796)
    h2e[4, 3, 2, 0] = complex(0.000072467329, -0.000004621082)
    h2e[6, 3, 2, 0] = complex(0.000000532223, 0.000000421284)
    h2e[8, 3, 2, 0] = complex(-0.000000688279, 0.000000340204)
    h2e[10, 3, 2, 0] = complex(-0.000165319112, -0.000000685693)
    h2e[0, 3, 4, 0] = complex(-0.002037061128, -0.000002336380)
    h2e[4, 3, 4, 0] = complex(0.000070630000, -0.000005619331)
    h2e[6, 3, 4, 0] = complex(0.000015396088, 0.000028668117)
    h2e[8, 3, 4, 0] = complex(-0.000026200497, 0.000014285663)
    h2e[10, 3, 4, 0] = complex(0.000427009918, -0.000004921519)
    h2e[0, 3, 6, 0] = complex(0.000006231299, 0.000002510875)
    h2e[4, 3, 6, 0] = complex(0.000017569204, 0.000031494921)
    h2e[6, 3, 6, 0] = complex(-0.008624343707, 0.010560890270)
    h2e[8, 3, 6, 0] = complex(-0.009942420480, -0.007439679941)
    h2e[10, 3, 6, 0] = complex(0.000000655319, 0.000003306432)
    h2e[0, 3, 8, 0] = complex(-0.000000209647, 0.000000143553)
    h2e[4, 3, 8, 0] = complex(-0.000029085853, 0.000015858886)
    h2e[6, 3, 8, 0] = complex(-0.009946816535, -0.007442969418)
    h2e[8, 3, 8, 0] = complex(0.007868012505, -0.011202414389)
    h2e[10, 3, 8, 0] = complex(-0.000004383830, 0.000002118611)
    h2e[0, 3, 10, 0] = complex(-0.009878390700, -0.000092364506)
    h2e[4, 3, 10, 0] = complex(-0.000481563016, 0.000034322465)
    h2e[6, 3, 10, 0] = complex(0.000002345033, 0.000008997295)
    h2e[8, 3, 10, 0] = complex(-0.000007245352, 0.000003501524)
    h2e[10, 3, 10, 0] = complex(-0.001495411317, 0.000004967442)
    h2e[0, 5, 0, 0] = complex(0.166808506949, 0.000003131608)
    h2e[2, 5, 0, 0] = complex(0.007245549338, -0.000250279087)
    h2e[6, 5, 0, 0] = complex(-0.000041290004, 0.000024113909)
    h2e[10, 5, 0, 0] = complex(0.079180536788, -0.000802877322)
    h2e[0, 5, 2, 0] = complex(0.003241840259, 0.000053690068)
    h2e[2, 5, 2, 0] = complex(0.000072602770, -0.000001306082)
    h2e[6, 5, 2, 0] = complex(0.000000090187, 0.000000369317)
    h2e[8, 5, 2, 0] = complex(-0.000000298012, 0.000000145241)
    h2e[10, 5, 2, 0] = complex(0.000242567228, 0.000001552890)
    h2e[0, 5, 4, 0] = complex(-0.002043232384, -0.000001813533)
    h2e[2, 5, 4, 0] = complex(0.000070812958, -0.000002387214)
    h2e[6, 5, 4, 0] = complex(0.000006985550, 0.000012665030)
    h2e[8, 5, 4, 0] = complex(-0.000011225890, 0.000006033068)
    h2e[10, 5, 4, 0] = complex(0.000127531265, -0.000001181867)
    h2e[0, 5, 6, 0] = complex(0.000004142028, 0.000003745865)
    h2e[2, 5, 6, 0] = complex(0.000016112234, 0.000032264576)
    h2e[6, 5, 6, 0] = complex(-0.003821645082, 0.004678856344)
    h2e[8, 5, 6, 0] = complex(-0.004245355736, -0.003175267818)
    h2e[10, 5, 6, 0] = complex(-0.000004549678, -0.000008621404)
    h2e[0, 5, 8, 0] = complex(0.000012076871, -0.000008056049)
    h2e[2, 5, 8, 0] = complex(-0.000029779900, 0.000014513743)
    h2e[6, 5, 8, 0] = complex(-0.004247317492, -0.003176735096)
    h2e[8, 5, 8, 0] = complex(0.003486533065, -0.004963085717)
    h2e[10, 5, 8, 0] = complex(0.000009412543, -0.000004505542)
    h2e[0, 5, 10, 0] = complex(0.001451362603, 0.000013194487)
    h2e[2, 5, 10, 0] = complex(-0.000482628152, 0.000012289706)
    h2e[6, 5, 10, 0] = complex(0.000000857381, 0.000003518622)
    h2e[8, 5, 10, 0] = complex(-0.000003230037, 0.000001546136)
    h2e[10, 5, 10, 0] = complex(-0.001195203064, 0.000001275656)
    h2e[0, 7, 0, 0] = complex(-0.000440773975, -0.000005277991)
    h2e[2, 7, 0, 0] = complex(-0.000026863469, -0.000035265985)
    h2e[4, 7, 0, 0] = complex(-0.000006539033, -0.000047366508)
    h2e[10, 7, 0, 0] = complex(-0.000226996437, -0.000051339998)
    h2e[0, 7, 2, 0] = complex(-0.000008619154, -0.000000283352)
    h2e[2, 7, 2, 0] = complex(0.000000606971, -0.000000303856)
    h2e[4, 7, 2, 0] = complex(-0.000000375793, -0.000000057520)
    h2e[10, 7, 2, 0] = complex(-0.000000842837, -0.000000156947)
    h2e[0, 7, 4, 0] = complex(0.000005100788, -0.000001979003)
    h2e[2, 7, 4, 0] = complex(0.000032490191, -0.000001813276)
    h2e[4, 7, 4, 0] = complex(-0.000014372112, 0.000001625826)
    h2e[8, 7, 4, 0] = complex(0.000000028346, -0.000000016884)
    h2e[10, 7, 4, 0] = complex(-0.000010809218, -0.000000272348)
    h2e[0, 7, 6, 0] = complex(-0.000060833285, 0.000028518355)
    h2e[2, 7, 6, 0] = complex(0.005917294034, 0.012284027794)
    h2e[4, 7, 6, 0] = complex(-0.002867146241, -0.005317531402)
    h2e[8, 7, 6, 0] = complex(0.000011469973, 0.000007788649)
    h2e[10, 7, 6, 0] = complex(-0.001725872755, -0.003946994264)
    h2e[0, 7, 8, 0] = complex(0.005628947125, -0.002774112016)
    h2e[2, 7, 8, 0] = complex(-0.010953777228, 0.005861033815)
    h2e[4, 7, 8, 0] = complex(0.004556767933, -0.002714261916)
    h2e[8, 7, 8, 0] = complex(-0.000009308295, 0.000012917844)
    h2e[10, 7, 8, 0] = complex(0.004256554244, -0.002086053504)
    h2e[0, 7, 10, 0] = complex(-0.000006409636, -0.000000629199)
    h2e[2, 7, 10, 0] = complex(0.000009144097, 0.000001684037)
    h2e[4, 7, 10, 0] = complex(-0.000003579607, -0.000000549741)
    h2e[8, 7, 10, 0] = complex(0.000000008360, -0.000000004097)
    h2e[10, 7, 10, 0] = complex(0.000000772158, 0.000000675544)
    h2e[0, 9, 2, 0] = complex(0.000000208582, -0.000000145096)
    h2e[2, 9, 2, 0] = complex(-0.000000685751, 0.000000345271)
    h2e[4, 9, 2, 0] = complex(0.000000289888, -0.000000160845)
    h2e[10, 9, 2, 0] = complex(0.000000247735, -0.000000121987)
    h2e[0, 9, 4, 0] = complex(0.000011632537, -0.000008685323)
    h2e[2, 9, 4, 0] = complex(-0.000026094419, 0.000014478519)
    h2e[4, 9, 4, 0] = complex(0.000010890062, -0.000006620050)
    h2e[6, 9, 4, 0] = complex(-0.000000027432, -0.000000018332)
    h2e[10, 9, 4, 0] = complex(0.000009938539, -0.000005423149)
    h2e[0, 9, 6, 0] = complex(0.004924894206, 0.003889236465)
    h2e[2, 9, 6, 0] = complex(-0.009997022268, -0.007366146088)
    h2e[4, 9, 6, 0] = complex(0.004407810520, 0.002945603065)
    h2e[6, 9, 6, 0] = complex(0.000002100087, -0.000013704487)
    h2e[10, 9, 6, 0] = complex(0.003711852400, 0.002944654985)
    h2e[0, 9, 8, 0] = complex(0.000055115800, 0.000038954640)
    h2e[2, 9, 8, 0] = complex(0.007785173762, -0.011260141132)
    h2e[4, 9, 8, 0] = complex(-0.003218358188, 0.005141041062)
    h2e[6, 9, 8, 0] = complex(0.000015665095, 0.000002849534)
    h2e[10, 9, 8, 0] = complex(-0.002588473129, 0.003464856244)
    h2e[0, 9, 10, 0] = complex(0.000001438320, -0.000001208311)
    h2e[2, 9, 10, 0] = complex(-0.000007219329, 0.000003554868)
    h2e[4, 9, 10, 0] = complex(0.000003143475, -0.000001715296)
    h2e[6, 9, 10, 0] = complex(-0.000000007294, -0.000000005786)
    h2e[10, 9, 10, 0] = complex(0.000002467047, -0.000001164161)
    h2e[0, 11, 0, 0] = complex(-0.129906865096, -0.000245291061)
    h2e[2, 11, 0, 0] = complex(0.062106040555, -0.003076868577)
    h2e[4, 11, 0, 0] = complex(0.078842848894, -0.007348958871)
    h2e[6, 11, 0, 0] = complex(-0.000057977404, -0.000225392543)
    h2e[0, 11, 2, 0] = complex(-0.003163671851, -0.000058311538)
    h2e[2, 11, 2, 0] = complex(0.000165230741, -0.000005448047)
    h2e[4, 11, 2, 0] = complex(0.000241864594, -0.000018514585)
    h2e[6, 11, 2, 0] = complex(-0.000000245232, -0.000000821503)
    h2e[8, 11, 2, 0] = complex(0.000000243999, -0.000000129298)
    h2e[0, 11, 4, 0] = complex(-0.000292089504, -0.000000804879)
    h2e[2, 11, 4, 0] = complex(-0.000426533367, 0.000020760015)
    h2e[4, 11, 4, 0] = complex(0.000126996575, -0.000011725623)
    h2e[6, 11, 4, 0] = complex(-0.000004693474, -0.000009740876)
    h2e[8, 11, 4, 0] = complex(0.000009772927, -0.000005716206)
    h2e[0, 11, 6, 0] = complex(0.000000246037, -0.000002255877)
    h2e[2, 11, 6, 0] = complex(-0.000000777535, -0.000003279843)
    h2e[4, 11, 6, 0] = complex(-0.000005247146, -0.000008215573)
    h2e[6, 11, 6, 0] = complex(0.002723399463, -0.003337738136)
    h2e[8, 11, 6, 0] = complex(0.003797750623, 0.002833007494)
    h2e[0, 11, 8, 0] = complex(-0.000001401763, 0.000001250535)
    h2e[2, 11, 8, 0] = complex(0.000004302212, -0.000002279791)
    h2e[4, 11, 8, 0] = complex(0.000009007651, -0.000005268594)
    h2e[6, 11, 8, 0] = complex(0.003799529229, 0.002834334293)
    h2e[8, 11, 8, 0] = complex(-0.002484325776, 0.003540275044)
    h2e[0, 11, 10, 0] = complex(0.009258508768, 0.000101478558)
    h2e[2, 11, 10, 0] = complex(0.001494197547, -0.000060443137)
    h2e[4, 11, 10, 0] = complex(-0.001191002621, 0.000100123665)
    h2e[6, 11, 10, 0] = complex(-0.000000248416, 0.000000995428)
    h2e[8, 11, 10, 0] = complex(0.000002431349, -0.000001236987)
    h2e[2, 1, 0, 2] = complex(0.007774571271, 0.000319549618)
    h2e[4, 1, 0, 2] = complex(-0.003242246434, 0.000015804482)
    h2e[6, 1, 0, 2] = complex(0.000003247744, 0.000007920735)
    h2e[8, 1, 0, 2] = complex(0.000000219436, -0.000000128670)
    h2e[10, 1, 0, 2] = complex(-0.003154140180, -0.000252226861)
    h2e[2, 1, 2, 2] = complex(0.011566531943, 0.000667203104)
    h2e[4, 1, 2, 2] = complex(-0.013836467691, -0.000161434676)
    h2e[6, 1, 2, 2] = complex(0.000012698043, 0.000032955764)
    h2e[10, 1, 2, 2] = complex(0.003358432043, 0.000324550728)
    h2e[2, 1, 4, 2] = complex(-0.008200827396, -0.000099390102)
    h2e[4, 1, 4, 2] = complex(-0.012714692352, 0.000430357660)
    h2e[6, 1, 4, 2] = complex(0.000027900143, 0.000061674258)
    h2e[8, 1, 4, 2] = complex(0.000030254380, -0.000013527852)
    h2e[10, 1, 4, 2] = complex(0.017444178153, 0.000887578971)
    h2e[2, 1, 6, 2] = complex(0.000008529183, 0.000021338005)
    h2e[4, 1, 6, 2] = complex(0.000023896260, 0.000054048107)
    h2e[6, 1, 6, 2] = complex(-0.009421113103, 0.009856599145)
    h2e[8, 1, 6, 2] = complex(0.009329769679, 0.008202055175)
    h2e[10, 1, 6, 2] = complex(-0.000010615132, -0.000030229942)
    h2e[2, 1, 8, 2] = complex(0.000000713074, -0.000000285329)
    h2e[4, 1, 8, 2] = complex(0.000027253104, -0.000012185870)
    h2e[6, 1, 8, 2] = complex(0.009325646317, 0.008198430228)
    h2e[8, 1, 8, 2] = complex(0.008717123815, -0.010555162778)
    h2e[10, 1, 8, 2] = complex(0.000007495587, -0.000002933601)
    h2e[2, 1, 10, 2] = complex(-0.003454179559, -0.000322529449)
    h2e[4, 1, 10, 2] = complex(0.014246988619, 0.000672250147)
    h2e[6, 1, 10, 2] = complex(-0.000010197273, -0.000030210786)
    h2e[8, 1, 10, 2] = complex(0.000004535235, -0.000001774987)
    h2e[10, 1, 10, 2] = complex(-0.009964185435, -0.001321161007)
    h2e[0, 3, 0, 2] = complex(0.007780106527, -0.000126541824)
    h2e[4, 3, 0, 2] = complex(0.000072270513, -0.000007015213)
    h2e[6, 3, 0, 2] = complex(-0.000000174920, -0.000001082164)
    h2e[8, 3, 0, 2] = complex(0.000000695550, -0.000000325727)
    h2e[10, 3, 0, 2] = complex(-0.000165251885, 0.000004782869)
    h2e[0, 3, 2, 2] = complex(0.011585758965, 0.000003220285)
    h2e[4, 3, 2, 2] = complex(-0.000783822081, 0.000063015669)
    h2e[6, 3, 2, 2] = complex(0.000000052851, -0.000000100843)
    h2e[10, 3, 2, 2] = complex(-0.028346906019, 0.000351338810)
    h2e[0, 3, 4, 2] = complex(-0.008193044554, 0.000370768526)
    h2e[4, 3, 4, 2] = complex(-0.007256573984, 0.000917163768)
    h2e[6, 3, 4, 2] = complex(-0.000003520103, 0.000024769834)
    h2e[8, 3, 4, 2] = complex(-0.000034659636, 0.000033540415)
    h2e[10, 3, 4, 2] = complex(-0.000919943617, 0.000053319683)
    h2e[0, 3, 6, 2] = complex(0.000009738061, 0.000020814120)
    h2e[4, 3, 6, 2] = complex(-0.000002758683, 0.000024277182)
    h2e[6, 3, 6, 2] = complex(-0.000095737379, -0.000079919580)
    h2e[8, 3, 6, 2] = complex(-0.014133994404, -0.011830307721)
    h2e[10, 3, 6, 2] = complex(-0.000001821552, 0.000001088911)
    h2e[0, 3, 8, 2] = complex(0.000000695550, -0.000000325727)
    h2e[4, 3, 8, 2] = complex(-0.000034659643, 0.000033540414)
    h2e[6, 3, 8, 2] = complex(-0.014133994632, -0.011830307525)
    h2e[8, 3, 8, 2] = complex(0.000101745162, 0.000073042509)
    h2e[10, 3, 8, 2] = complex(0.000002013764, 0.000000749495)
    h2e[0, 3, 10, 2] = complex(-0.003466986629, -0.000124037842)
    h2e[4, 3, 10, 2] = complex(0.000171014358, -0.000007655790)
    h2e[6, 3, 10, 2] = complex(-0.000003381170, -0.000006064597)
    h2e[8, 3, 10, 2] = complex(0.000002013766, 0.000000749496)
    h2e[10, 3, 10, 2] = complex(0.026531803705, 0.000612728757)
    h2e[0, 5, 0, 2] = complex(0.003241842402, -0.000053568339)
    h2e[2, 5, 0, 2] = complex(0.000072515520, -0.000003706704)
    h2e[6, 5, 0, 2] = complex(-0.000000221043, -0.000000292305)
    h2e[8, 5, 0, 2] = complex(0.000000301163, -0.000000138893)
    h2e[10, 5, 0, 2] = complex(0.000242486949, -0.000006471246)
    h2e[0, 5, 2, 2] = complex(0.013837409413, 0.000000259779)
    h2e[2, 5, 2, 2] = complex(-0.000785882374, 0.000027146309)
    h2e[6, 5, 2, 2] = complex(-0.000014439732, 0.000008432995)
    h2e[10, 5, 2, 2] = complex(0.021679958769, -0.000219831135)
    h2e[0, 5, 4, 2] = complex(0.012708817113, -0.000578426234)
    h2e[2, 5, 4, 2] = complex(-0.007290894009, 0.000584739175)
    h2e[6, 5, 4, 2] = complex(0.000010888542, -0.000011082063)
    h2e[8, 5, 4, 2] = complex(-0.000015555765, 0.000013967210)
    h2e[10, 5, 4, 2] = complex(-0.033944369693, 0.001890637840)
    h2e[0, 5, 6, 2] = complex(-0.000024524178, -0.000053766103)
    h2e[2, 5, 6, 2] = complex(-0.000003864741, 0.000024125834)
    h2e[6, 5, 6, 2] = complex(0.000753512709, -0.001022522471)
    h2e[8, 5, 6, 2] = complex(-0.006051570472, -0.004960791521)
    h2e[10, 5, 6, 2] = complex(0.000039362313, 0.000073424932)
    h2e[0, 5, 8, 2] = complex(-0.000027109317, 0.000012502480)
    h2e[2, 5, 8, 2] = complex(-0.000036155527, 0.000031922214)
    h2e[6, 5, 8, 2] = complex(-0.006051611583, -0.004960825085)
    h2e[8, 5, 8, 2] = complex(-0.000679999943, 0.001078367942)
    h2e[10, 5, 8, 2] = complex(-0.000001327038, -0.000002382005)
    h2e[0, 5, 10, 2] = complex(-0.014253852351, -0.000506258945)
    h2e[2, 5, 10, 2] = complex(0.000171185557, 0.000000163830)
    h2e[6, 5, 10, 2] = complex(0.000018116406, -0.000013403683)
    h2e[8, 5, 10, 2] = complex(0.000000254653, 0.000000457098)
    h2e[10, 5, 10, 2] = complex(-0.019446258526, -0.000492954586)
    h2e[0, 7, 0, 2] = complex(-0.000008560341, 0.000000080253)
    h2e[2, 7, 0, 2] = complex(-0.000001054471, -0.000000299611)
    h2e[4, 7, 0, 2] = complex(0.000000354523, -0.000000092819)
    h2e[10, 7, 0, 2] = complex(-0.000000333943, -0.000000103737)
    h2e[0, 7, 2, 2] = complex(-0.000035314923, -0.000000422874)
    h2e[2, 7, 2, 2] = complex(-0.000000068991, -0.000000090570)
    h2e[4, 7, 2, 2] = complex(-0.000002286798, -0.000016564776)
    h2e[10, 7, 2, 2] = complex(-0.000064904039, -0.000014679408)
    h2e[0, 7, 4, 2] = complex(-0.000067622673, 0.000003050615)
    h2e[2, 7, 4, 2] = complex(0.000020951066, 0.000013674378)
    h2e[4, 7, 4, 2] = complex(0.000006090245, 0.000014292705)
    h2e[8, 7, 4, 2] = complex(0.000000047461, -0.000000025482)
    h2e[10, 7, 4, 2] = complex(0.000091931257, 0.000023943909)
    h2e[0, 7, 6, 2] = complex(-0.005662106571, -0.012403647372)
    h2e[2, 7, 6, 2] = complex(-0.000112932074, 0.000052906332)
    h2e[4, 7, 6, 2] = complex(0.000657746201, 0.001086601816)
    h2e[8, 7, 6, 2] = complex(0.000013121764, 0.000016958862)
    h2e[10, 7, 6, 2] = complex(-0.002441547261, -0.005258967863)
    h2e[0, 7, 8, 2] = complex(-0.011071253735, 0.005622212930)
    h2e[2, 7, 8, 2] = complex(-0.016701104632, 0.007797376712)
    h2e[4, 7, 8, 2] = complex(0.006894242034, -0.003701515219)
    h2e[8, 7, 8, 2] = complex(0.000005763349, -0.000000172751)
    h2e[10, 7, 8, 2] = complex(0.000254495724, 0.000376403835)
    h2e[0, 7, 10, 2] = complex(0.000031838500, 0.000001727955)
    h2e[2, 7, 10, 2] = complex(-0.000006925714, 0.000000496117)
    h2e[4, 7, 10, 2] = complex(0.000005479010, 0.000021859628)
    h2e[10, 7, 10, 2] = complex(0.000061707056, 0.000016887904)
    h2e[0, 9, 0, 2] = complex(-0.000000210655, 0.000000142592)
    h2e[2, 9, 0, 2] = complex(0.000000693128, -0.000000330849)
    h2e[4, 9, 0, 2] = complex(-0.000000293371, 0.000000154672)
    h2e[10, 9, 0, 2] = complex(-0.000000250166, 0.000000117092)
    h2e[0, 9, 4, 2] = complex(-0.000029316161, 0.000015456162)
    h2e[2, 9, 4, 2] = complex(-0.000034411318, 0.000033795138)
    h2e[4, 9, 4, 2] = complex(0.000014792973, -0.000014772699)
    h2e[6, 9, 4, 2] = complex(-0.000000043413, -0.000000031893)
    h2e[10, 9, 4, 2] = complex(-0.000001745303, -0.000002775427)
    h2e[0, 9, 6, 2] = complex(-0.009840686696, -0.007581503603)
    h2e[2, 9, 6, 2] = complex(-0.014220865849, -0.011725738954)
    h2e[4, 9, 6, 2] = complex(0.006306195253, 0.004632802531)
    h2e[6, 9, 6, 2] = complex(0.000009669094, -0.000019138767)
    h2e[10, 9, 6, 2] = complex(-0.000230405534, 0.000391614091)
    h2e[0, 9, 8, 2] = complex(-0.008016244554, 0.011096825323)
    h2e[2, 9, 8, 2] = complex(0.000102281167, 0.000072290162)
    h2e[4, 9, 8, 2] = complex(0.000621840687, -0.001112920276)
    h2e[6, 9, 8, 2] = complex(-0.000002634072, -0.000005129106)
    h2e[10, 9, 8, 2] = complex(-0.003377304750, 0.004739054736)
    h2e[0, 9, 10, 2] = complex(-0.000004410948, 0.000002064577)
    h2e[2, 9, 10, 2] = complex(0.000002019238, 0.000000734623)
    h2e[4, 9, 10, 2] = complex(-0.000000278548, -0.000000442948)
    h2e[10, 9, 10, 2] = complex(-0.000002900218, 0.000000840465)
    h2e[0, 11, 0, 2] = complex(-0.003163869318, 0.000046363831)
    h2e[2, 11, 0, 2] = complex(0.000164960679, -0.000010910350)
    h2e[4, 11, 0, 2] = complex(0.000241120933, -0.000026504589)
    h2e[6, 11, 0, 2] = complex(-0.000000060196, -0.000000344464)
    h2e[8, 11, 0, 2] = complex(-0.000000246574, 0.000000124477)
    h2e[0, 11, 2, 2] = complex(0.003374071483, 0.000006370946)
    h2e[2, 11, 2, 2] = complex(0.028314356754, -0.001402754930)
    h2e[4, 11, 2, 2] = complex(0.021587498426, -0.002012175363)
    h2e[6, 11, 2, 2] = complex(-0.000016577210, -0.000064445445)
    h2e[0, 11, 4, 2] = complex(0.017450135026, -0.000761534904)
    h2e[2, 11, 4, 2] = complex(0.000917332167, -0.000087412487)
    h2e[4, 11, 4, 2] = complex(-0.033671701308, 0.004691617662)
    h2e[6, 11, 4, 2] = complex(0.000020676296, 0.000092720859)
    h2e[8, 11, 4, 2] = complex(-0.000001827030, -0.000002722314)
    h2e[0, 11, 6, 2] = complex(-0.000013418801, -0.000029094092)
    h2e[2, 11, 6, 2] = complex(0.000001779900, -0.000001155742)
    h2e[4, 11, 6, 2] = complex(0.000045300252, 0.000069917807)
    h2e[6, 11, 6, 2] = complex(0.003563812624, -0.004573525494)
    h2e[8, 11, 6, 2] = complex(-0.000218661832, 0.000398290558)
    h2e[0, 11, 8, 2] = complex(0.000007185511, -0.000003627434)
    h2e[2, 11, 8, 2] = complex(-0.000002040185, -0.000000674270)
    h2e[4, 11, 8, 2] = complex(-0.000001519499, -0.000002264087)
    h2e[6, 11, 8, 2] = complex(-0.000218661557, 0.000398290125)
    h2e[8, 11, 8, 2] = complex(-0.003234929300, 0.004837360819)
    h2e[0, 11, 10, 2] = complex(-0.010044372493, -0.000375551608)
    h2e[2, 11, 10, 2] = complex(-0.026536270494, 0.000372011540)
    h2e[4, 11, 10, 2] = complex(-0.019420403957, 0.001117087757)
    h2e[6, 11, 10, 2] = complex(0.000013152577, 0.000062609678)
    h2e[8, 11, 10, 2] = complex(-0.000002873946, 0.000000926312)
    h2e[2, 1, 0, 4] = complex(-0.002033782849, -0.000115543480)
    h2e[4, 1, 0, 4] = complex(0.002043114078, 0.000022062321)
    h2e[6, 1, 0, 4] = complex(-0.000000017536, -0.000005875120)
    h2e[8, 1, 0, 4] = complex(0.000012962192, -0.000006546836)
    h2e[10, 1, 0, 4] = complex(-0.000290748726, -0.000027842080)
    h2e[2, 1, 2, 4] = complex(-0.008157865624, -0.000844243921)
    h2e[4, 1, 2, 4] = complex(-0.012701362286, -0.000726903139)
    h2e[6, 1, 2, 4] = complex(-0.000002195605, -0.000004203349)
    h2e[8, 1, 2, 4] = complex(-0.000031340027, 0.000010749592)
    h2e[10, 1, 2, 4] = complex(0.017291294785, 0.002469170983)
    h2e[2, 1, 4, 4] = complex(0.009776478737, 0.000563945787)
    h2e[4, 1, 4, 4] = complex(0.005047315152, 0.000058888707)
    h2e[6, 1, 4, 4] = complex(-0.000004427972, -0.000011492098)
    h2e[10, 1, 4, 4] = complex(-0.012075947076, -0.001166990241)
    h2e[2, 1, 6, 4] = complex(0.000001780432, 0.000005189866)
    h2e[4, 1, 6, 4] = complex(-0.000013473504, -0.000034457387)
    h2e[6, 1, 6, 4] = complex(0.004368927842, -0.004172343132)
    h2e[8, 1, 6, 4] = complex(-0.003824747709, -0.003674441199)
    h2e[10, 1, 6, 4] = complex(0.000003784110, 0.000012943324)
    h2e[2, 1, 8, 4] = complex(-0.000000313624, 0.000000107573)
    h2e[4, 1, 8, 4] = complex(-0.000011883528, 0.000004608883)
    h2e[6, 1, 8, 4] = complex(-0.003822981125, -0.003672744043)
    h2e[8, 1, 8, 4] = complex(-0.004071427904, 0.004495732138)
    h2e[10, 1, 8, 4] = complex(-0.000003395207, 0.000001139475)
    h2e[2, 1, 10, 4] = complex(-0.004177164962, -0.000583708829)
    h2e[4, 1, 10, 4] = complex(-0.003514946251, -0.000327430401)
    h2e[6, 1, 10, 4] = complex(0.000005487480, 0.000017120985)
    h2e[8, 1, 10, 4] = complex(0.000009893858, -0.000003320506)
    h2e[10, 1, 10, 4] = complex(0.006551743859, 0.001175691410)
    h2e[0, 3, 0, 4] = complex(-0.002037061983, 0.000001203975)
    h2e[4, 3, 0, 4] = complex(0.000070448430, -0.000005732305)
    h2e[6, 3, 0, 4] = complex(-0.000011844776, -0.000030673786)
    h2e[8, 3, 0, 4] = complex(0.000027629700, -0.000011285244)
    h2e[10, 3, 0, 4] = complex(0.000426980326, -0.000005664193)
    h2e[0, 3, 2, 4] = complex(-0.008192841498, -0.000375323214)
    h2e[4, 3, 2, 4] = complex(-0.007309896243, 0.000253911870)
    h2e[6, 3, 2, 4] = complex(-0.000029754577, 0.000037041642)
    h2e[8, 3, 2, 4] = complex(0.000037750831, -0.000029836127)
    h2e[10, 3, 2, 4] = complex(-0.000921026460, -0.000030504404)
    h2e[0, 3, 4, 4] = complex(0.009792730157, 0.000002721909)
    h2e[4, 3, 4, 4] = complex(0.002398177415, -0.000192802370)
    h2e[6, 3, 4, 4] = complex(0.000005707354, -0.000010890019)
    h2e[10, 3, 4, 4] = complex(-0.004959694578, 0.000061471724)
    h2e[0, 3, 6, 4] = complex(0.000002074940, 0.000005079298)
    h2e[4, 3, 6, 4] = complex(0.000006123064, -0.000000019550)
    h2e[6, 3, 6, 4] = complex(0.000911970111, -0.000884147814)
    h2e[8, 3, 6, 4] = complex(0.005780602362, 0.005277280001)
    h2e[10, 3, 6, 4] = complex(-0.000030032978, -0.000072767766)
    h2e[0, 3, 8, 4] = complex(-0.000000306944, 0.000000125370)
    h2e[4, 3, 8, 4] = complex(0.000016246588, -0.000013099669)
    h2e[6, 3, 8, 4] = complex(0.005780563255, 0.005277244155)
    h2e[8, 3, 8, 4] = complex(-0.000848611758, 0.000951386048)
    h2e[10, 3, 8, 4] = complex(-0.000000224591, -0.000000447209)
    h2e[0, 3, 10, 4] = complex(-0.004203752102, -0.000343353136)
    h2e[4, 3, 10, 4] = complex(-0.005233619757, -0.000005212233)
    h2e[6, 3, 10, 4] = complex(-0.000016649196, 0.000010604473)
    h2e[8, 3, 10, 4] = complex(0.000001170373, 0.000002330468)
    h2e[10, 3, 10, 4] = complex(0.016079877163, 0.001108453217)
    h2e[0, 5, 0, 4] = complex(-0.002043232455, 0.000001736892)
    h2e[2, 5, 0, 4] = complex(0.000070636738, -0.000002508364)
    h2e[6, 5, 0, 4] = complex(-0.000005199887, -0.000013536668)
    h2e[8, 5, 0, 4] = complex(0.000011829039, -0.000004746987)
    h2e[10, 5, 0, 4] = complex(0.000127573875, -0.000001402355)
    h2e[0, 5, 2, 4] = complex(0.012708967454, 0.000578911325)
    h2e[2, 5, 2, 4] = complex(-0.007313864456, -0.000080256090)
    h2e[6, 5, 2, 4] = complex(0.000005802335, 0.000000800119)
    h2e[8, 5, 2, 4] = complex(0.000016827998, -0.000012343879)
    h2e[10, 5, 2, 4] = complex(-0.033975665522, -0.001201936969)
    h2e[0, 5, 4, 4] = complex(-0.005047658677, -0.000000094763)
    h2e[2, 5, 4, 4] = complex(0.002404481078, -0.000083056688)
    h2e[6, 5, 4, 4] = complex(0.000003846817, -0.000002246592)
    h2e[10, 5, 4, 4] = complex(0.026100912030, -0.000264658857)
    h2e[0, 5, 6, 4] = complex(0.000013873941, 0.000034298113)
    h2e[2, 5, 6, 4] = complex(0.000006117566, 0.000000260159)
    h2e[6, 5, 6, 4] = complex(0.000081398862, 0.000074459859)
    h2e[8, 5, 6, 4] = complex(0.006862639320, 0.006158635268)
    h2e[10, 5, 6, 4] = complex(0.000022424301, 0.000050159217)
    h2e[0, 5, 8, 4] = complex(0.000011829039, -0.000004746987)
    h2e[2, 5, 8, 4] = complex(0.000016827998, -0.000012343881)
    h2e[6, 5, 8, 4] = complex(0.006862639407, 0.006158635200)
    h2e[8, 5, 8, 4] = complex(-0.000086985141, -0.000068678278)
    h2e[10, 5, 8, 4] = complex(0.000000343497, -0.000001120344)
    h2e[0, 5, 10, 4] = complex(0.003518521639, 0.000286466915)
    h2e[2, 5, 10, 4] = complex(-0.005227918852, -0.000244269141)
    h2e[6, 5, 10, 4] = complex(0.000013682189, -0.000001085676)
    h2e[8, 5, 10, 4] = complex(0.000000343495, -0.000001120344)
    h2e[10, 5, 10, 4] = complex(-0.045962352199, -0.003272491605)
    h2e[0, 7, 0, 4] = complex(0.000005463064, 0.000002161545)
    h2e[2, 7, 0, 4] = complex(-0.000032804010, -0.000002253178)
    h2e[4, 7, 0, 4] = complex(0.000014496638, 0.000000357313)
    h2e[8, 7, 0, 4] = complex(-0.000000030048, 0.000000013624)
    h2e[10, 7, 0, 4] = complex(0.000009820826, 0.000001217742)
    h2e[0, 7, 2, 4] = complex(0.000004717776, -0.000000481057)
    h2e[2, 7, 2, 4] = complex(0.000020963959, 0.000042637196)
    h2e[4, 7, 2, 4] = complex(-0.000002953086, 0.000005058316)
    h2e[8, 7, 2, 4] = complex(-0.000000049759, 0.000000020675)
    h2e[10, 7, 2, 4] = complex(0.000118978797, 0.000025146116)
    h2e[0, 7, 4, 4] = complex(0.000012314767, 0.000000147461)
    h2e[2, 7, 4, 4] = complex(-0.000007450259, -0.000009780595)
    h2e[4, 7, 4, 4] = complex(0.000000609214, 0.000004412939)
    h2e[10, 7, 4, 4] = complex(-0.000070399153, -0.000015922242)
    h2e[0, 7, 6, 4] = complex(0.002255590279, 0.005604309968)
    h2e[2, 7, 6, 4] = complex(-0.000414984227, -0.001200497790)
    h2e[4, 7, 6, 4] = complex(-0.000099880949, 0.000046838265)
    h2e[8, 7, 6, 4] = complex(-0.000014092004, -0.000018703903)
    h2e[10, 7, 6, 4] = complex(-0.000288933672, -0.000723091918)
    h2e[0, 7, 8, 4] = complex(0.004828219830, -0.002189184042)
    h2e[2, 7, 8, 4] = complex(0.007228059643, -0.003003226777)
    h2e[4, 7, 8, 4] = complex(-0.008310861168, 0.003994270100)
    h2e[8, 7, 8, 4] = complex(-0.000010900359, -0.000007166572)
    h2e[10, 7, 8, 4] = complex(0.000146040759, -0.000002546046)
    h2e[0, 7, 10, 4] = complex(-0.000017935386, -0.000001249990)
    h2e[2, 7, 10, 4] = complex(0.000002559814, 0.000019572888)
    h2e[4, 7, 10, 4] = complex(-0.000004215907, 0.000013061666)
    h2e[8, 7, 10, 4] = complex(-0.000000001767, 0.000000000031)
    h2e[10, 7, 10, 4] = complex(0.000134529890, 0.000045361204)
    h2e[0, 9, 0, 4] = complex(-0.000012511655, 0.000007371429)
    h2e[2, 9, 0, 4] = complex(0.000027545713, -0.000011488723)
    h2e[4, 9, 0, 4] = complex(-0.000011560582, 0.000005367774)
    h2e[6, 9, 0, 4] = complex(0.000000025221, 0.000000021271)
    h2e[10, 9, 0, 4] = complex(-0.000010478962, 0.000004289293)
    h2e[0, 9, 2, 4] = complex(0.000030579213, -0.000012753930)
    h2e[2, 9, 2, 4] = complex(0.000037529737, -0.000030113752)
    h2e[4, 9, 2, 4] = complex(-0.000016149530, 0.000013219140)
    h2e[6, 9, 2, 4] = complex(0.000000040061, 0.000000036035)
    h2e[10, 9, 2, 4] = complex(0.000001427866, 0.000002791673)
    h2e[0, 9, 6, 4] = complex(0.004054376547, 0.003419392345)
    h2e[2, 9, 6, 4] = complex(0.005819368352, 0.005234500931)
    h2e[4, 9, 6, 4] = complex(-0.007179661699, -0.005785936819)
    h2e[6, 9, 6, 4] = complex(-0.000010827406, 0.000020765065)
    h2e[10, 9, 6, 4] = complex(0.000065096953, 0.000130765144)
    h2e[0, 9, 8, 4] = complex(0.003772153635, -0.004749630471)
    h2e[2, 9, 8, 4] = complex(-0.000841571628, 0.000957619179)
    h2e[4, 9, 8, 4] = complex(0.000090505712, 0.000063967493)
    h2e[6, 9, 8, 4] = complex(-0.000001783370, 0.000012922740)
    h2e[10, 9, 8, 4] = complex(-0.000487697523, 0.000611017633)
    h2e[0, 9, 10, 4] = complex(-0.000009658400, 0.000003953417)
    h2e[2, 9, 10, 4] = complex(0.000001187524, 0.000002321771)
    h2e[4, 9, 10, 4] = complex(-0.000000283587, 0.000001136987)
    h2e[6, 9, 10, 4] = complex(0.000000000787, 0.000000001582)
    h2e[10, 9, 10, 4] = complex(-0.000011367302, 0.000002457103)
    h2e[0, 11, 0, 4] = complex(-0.000292078610, -0.000000297515)
    h2e[2, 11, 0, 4] = complex(-0.000426476243, 0.000021501079)
    h2e[4, 11, 0, 4] = complex(0.000127020803, -0.000011948879)
    h2e[6, 11, 0, 4] = complex(0.000003401070, 0.000009293237)
    h2e[8, 11, 0, 4] = complex(-0.000010346818, 0.000004598916)
    h2e[0, 11, 2, 4] = complex(0.017447092783, 0.000827426190)
    h2e[2, 11, 2, 4] = complex(0.000921524102, -0.000003686281)
    h2e[4, 11, 2, 4] = complex(-0.033958669360, 0.001612226859)
    h2e[6, 11, 2, 4] = complex(0.000031957354, 0.000117332897)
    h2e[8, 11, 2, 4] = complex(0.000001510235, 0.000002747994)
    h2e[0, 11, 4, 4] = complex(-0.012132181965, -0.000022908072)
    h2e[2, 11, 4, 4] = complex(0.004953999620, -0.000245431936)
    h2e[4, 11, 4, 4] = complex(0.025989597275, -0.002422495941)
    h2e[6, 11, 4, 4] = complex(-0.000017980723, -0.000069901733)
    h2e[0, 11, 6, 4] = complex(0.000004987927, 0.000012528756)
    h2e[2, 11, 6, 4] = complex(0.000032711955, 0.000071603461)
    h2e[4, 11, 6, 4] = complex(0.000026496021, 0.000048132704)
    h2e[6, 11, 6, 4] = complex(0.000511370400, -0.000587234961)
    h2e[8, 11, 6, 4] = complex(0.000068955565, 0.000128772151)
    h2e[0, 11, 8, 4] = complex(-0.000003272610, 0.000001454598)
    h2e[2, 11, 8, 4] = complex(0.000000241028, 0.000000438569)
    h2e[4, 11, 8, 4] = complex(0.000000249659, -0.000001144915)
    h2e[6, 11, 8, 4] = complex(0.000068951129, 0.000128763844)
    h2e[8, 11, 8, 4] = complex(-0.000469317623, 0.000625245866)
    h2e[0, 11, 10, 4] = complex(0.006633421318, 0.000552557240)
    h2e[2, 11, 10, 4] = complex(-0.016109930494, -0.000511133619)
    h2e[4, 11, 10, 4] = complex(-0.046075538543, 0.000540156351)
    h2e[6, 11, 10, 4] = complex(0.000021073858, 0.000140398799)
    h2e[8, 11, 10, 4] = complex(-0.000011289222, 0.000002793947)
    h2e[2, 1, 0, 6] = complex(0.000006321483, -0.000002241847)
    h2e[4, 1, 0, 6] = complex(-0.000008032227, 0.000001393582)
    h2e[6, 1, 0, 6] = complex(0.000124956232, -0.001861980081)
    h2e[8, 1, 0, 6] = complex(-0.001286314988, -0.006401302504)
    h2e[10, 1, 0, 6] = complex(0.000001680777, -0.000002881556)
    h2e[2, 1, 2, 6] = complex(0.000010159043, -0.000018752536)
    h2e[4, 1, 2, 6] = complex(-0.000002233693, 0.000005923978)
    h2e[6, 1, 2, 6] = complex(-0.013824783714, -0.000435735086)
    h2e[8, 1, 2, 6] = complex(-0.001253692436, 0.012561557124)
    h2e[10, 1, 2, 6] = complex(-0.000024440536, 0.000041146490)
    h2e[2, 1, 4, 6] = complex(0.000002679425, -0.000005614287)
    h2e[4, 1, 4, 6] = complex(-0.000003236588, 0.000007366783)
    h2e[6, 1, 4, 6] = complex(0.006128541472, -0.000028906365)
    h2e[8, 1, 4, 6] = complex(0.000356616983, -0.005384768755)
    h2e[10, 1, 4, 6] = complex(0.000009589546, -0.000018092291)
    h2e[2, 1, 6, 6] = complex(0.010336439939, 0.000596246554)
    h2e[4, 1, 6, 6] = complex(-0.004663729042, -0.000054413280)
    h2e[6, 1, 6, 6] = complex(0.000004334318, 0.000011249037)
    h2e[10, 1, 6, 6] = complex(-0.003293820615, -0.000318306837)
    h2e[4, 1, 8, 6] = complex(0.000000002218, -0.000000033497)
    h2e[6, 1, 8, 6] = complex(0.000012898403, -0.000004980300)
    h2e[8, 1, 8, 6] = complex(-0.000007004240, -0.000014298800)
    h2e[10, 1, 8, 6] = complex(0.000000000730, -0.000000009388)
    h2e[2, 1, 10, 6] = complex(0.000005471493, -0.000008776216)
    h2e[4, 1, 10, 6] = complex(0.000010514945, -0.000020107777)
    h2e[6, 1, 10, 6] = complex(0.004372673335, 0.000064612503)
    h2e[8, 1, 10, 6] = complex(0.000371889269, -0.004779910326)
    h2e[10, 1, 10, 6] = complex(-0.000009525894, 0.000013746374)
    h2e[0, 3, 0, 6] = complex(0.000006182612, -0.000002600451)
    h2e[4, 3, 0, 6] = complex(-0.000014323512, 0.000033428727)
    h2e[6, 3, 0, 6] = complex(-0.013836598751, -0.000364978472)
    h2e[8, 3, 0, 6] = complex(0.000531485056, -0.012607186541)
    h2e[10, 3, 0, 6] = complex(-0.000003356406, 0.000004226025)
    h2e[0, 3, 2, 6] = complex(0.000009067624, -0.000019303936)
    h2e[4, 3, 2, 6] = complex(0.000018548965, -0.000011714095)
    h2e[6, 3, 2, 6] = complex(0.000103013795, 0.010576649266)
    h2e[8, 3, 2, 6] = complex(-0.010378978695, -0.018195215824)
    h2e[10, 3, 2, 6] = complex(-0.000005353773, 0.000016411191)
    h2e[0, 3, 4, 6] = complex(0.000002353262, -0.000005758619)
    h2e[4, 3, 4, 6] = complex(-0.000001500548, -0.000011380970)
    h2e[6, 3, 4, 6] = complex(0.001072410354, -0.003892732958)
    h2e[8, 3, 4, 6] = complex(0.004100818271, 0.007580055827)
    h2e[10, 3, 4, 6] = complex(-0.000027007251, 0.000066893750)
    h2e[0, 3, 6, 6] = complex(0.010353622182, 0.000002877810)
    h2e[4, 3, 6, 6] = complex(0.003842345694, -0.000308906818)
    h2e[6, 3, 6, 6] = complex(0.000010901230, -0.000020800286)
    h2e[10, 3, 6, 6] = complex(-0.032057377297, 0.000397327341)
    h2e[4, 3, 8, 6] = complex(0.000000028231, 0.000000052182)
    h2e[6, 3, 8, 6] = complex(-0.000016557291, 0.000013114220)
    h2e[8, 3, 8, 6] = complex(-0.000005708285, -0.000000813347)
    h2e[10, 3, 8, 6] = complex(0.000000003173, 0.000000000033)
    h2e[0, 3, 10, 6] = complex(0.000004959529, -0.000009075366)
    h2e[4, 3, 10, 6] = complex(-0.000002415681, -0.000002701335)
    h2e[6, 3, 10, 6] = complex(-0.005797513913, -0.003150422048)
    h2e[8, 3, 10, 6] = complex(0.002964783936, 0.000030558066)
    h2e[10, 3, 10, 6] = complex(-0.000024065174, 0.000043702030)
    h2e[0, 5, 0, 6] = complex(0.000008015450, -0.000001487046)
    h2e[2, 5, 0, 6] = complex(-0.000015835525, 0.000032739561)
    h2e[6, 5, 0, 6] = complex(-0.006129084111, -0.000100518331)
    h2e[8, 5, 0, 6] = complex(0.000293736528, -0.005386068380)
    h2e[10, 5, 0, 6] = complex(0.000004294267, -0.000008107099)
    h2e[0, 5, 2, 6] = complex(0.000002164542, -0.000005949593)
    h2e[2, 5, 2, 6] = complex(0.000019064679, -0.000010854582)
    h2e[6, 5, 2, 6] = complex(0.001322508372, 0.003750854155)
    h2e[8, 5, 2, 6] = complex(-0.003750269103, -0.007759409215)
    h2e[10, 5, 2, 6] = complex(0.000041977458, -0.000100129453)
    h2e[0, 5, 4, 6] = complex(0.000003150562, -0.000007403983)
    h2e[2, 5, 4, 6] = complex(-0.000000979118, -0.000011437634)
    h2e[6, 5, 4, 6] = complex(-0.000215752539, -0.003887578652)
    h2e[8, 5, 4, 6] = complex(0.004262979529, 0.008986727986)
    h2e[10, 5, 4, 6] = complex(0.000022961234, -0.000060832680)
    h2e[0, 5, 6, 6] = complex(0.004664046459, 0.000000087561)
    h2e[2, 5, 6, 6] = complex(0.003852445386, -0.000133072935)
    h2e[6, 5, 6, 6] = complex(-0.000027499159, 0.000016059873)
    h2e[10, 5, 6, 6] = complex(0.041197543165, -0.000417736157)
    h2e[0, 5, 8, 6] = complex(-0.000000001828, 0.000000033520)
    h2e[2, 5, 8, 6] = complex(0.000000025817, 0.000000053417)
    h2e[6, 5, 8, 6] = complex(-0.000018493049, 0.000013915733)
    h2e[8, 5, 8, 6] = complex(-0.000011888234, 0.000005370985)
    h2e[10, 5, 8, 6] = complex(0.000000004121, 0.000000001605)
    h2e[0, 5, 10, 6] = complex(-0.000010280022, 0.000020228888)
    h2e[2, 5, 10, 6] = complex(-0.000002289767, -0.000002808860)
    h2e[6, 5, 10, 6] = complex(0.000780091920, 0.000350697092)
    h2e[8, 5, 10, 6] = complex(-0.000340690945, -0.000132707685)
    h2e[10, 5, 10, 6] = complex(0.000066656716, -0.000117826413)
    h2e[0, 7, 0, 6] = complex(0.001683008730, 0.000806266293)
    h2e[2, 7, 0, 6] = complex(-0.006187777320, 0.012381279668)
    h2e[4, 7, 0, 6] = complex(0.002431040079, -0.005627239121)
    h2e[8, 7, 0, 6] = complex(-0.000000155781, 0.000013825626)
    h2e[10, 7, 0, 6] = complex(0.002325013722, -0.003731506054)
    h2e[0, 7, 2, 6] = complex(0.005529363181, -0.012678353699)
    h2e[2, 7, 2, 6] = complex(0.009625912141, 0.004383827250)
    h2e[4, 7, 2, 6] = complex(-0.003971714216, -0.000208379597)
    h2e[8, 7, 2, 6] = complex(0.000004872515, 0.000020552011)
    h2e[10, 7, 2, 6] = complex(-0.000460433892, -0.006801440550)
    h2e[0, 7, 4, 6] = complex(-0.002244925076, 0.005702645660)
    h2e[2, 7, 4, 6] = complex(-0.003072807661, -0.002619405949)
    h2e[4, 7, 4, 6] = complex(0.003675893954, 0.001283596984)
    h2e[8, 7, 4, 6] = complex(-0.000005808656, -0.000022403122)
    h2e[10, 7, 4, 6] = complex(-0.000033932118, -0.000879074466)
    h2e[0, 7, 6, 6] = complex(-0.000012054307, -0.000000144342)
    h2e[2, 7, 6, 6] = complex(-0.000014230234, -0.000018681252)
    h2e[4, 7, 6, 6] = complex(-0.000004354999, -0.000031546113)
    h2e[10, 7, 6, 6] = complex(-0.000130151633, -0.000029436517)
    h2e[0, 7, 8, 6] = complex(-0.000000155781, 0.000013825626)
    h2e[2, 7, 8, 6] = complex(0.000004872514, 0.000020552013)
    h2e[4, 7, 8, 6] = complex(-0.000005808654, -0.000022403126)
    h2e[8, 7, 8, 6] = complex(-0.005964650989, 0.003344755582)
    h2e[10, 7, 8, 6] = complex(0.000000165712, 0.000000175283)
    h2e[0, 7, 10, 6] = complex(-0.001680903553, 0.004037203251)
    h2e[2, 7, 10, 6] = complex(-0.005308362030, 0.003918879878)
    h2e[4, 7, 10, 6] = complex(-0.000621765855, 0.000587315146)
    h2e[8, 7, 10, 6] = complex(0.000000165712, 0.000000175284)
    h2e[10, 7, 10, 6] = complex(0.002216598596, 0.001191003491)
    h2e[0, 9, 0, 6] = complex(0.001697611273, 0.006304712198)
    h2e[2, 9, 0, 6] = complex(0.000438484819, -0.012610763647)
    h2e[4, 9, 0, 6] = complex(-0.000007619635, 0.005394066708)
    h2e[6, 9, 0, 6] = complex(0.000012549312, -0.000005804047)
    h2e[10, 9, 0, 6] = complex(-0.000061952259, 0.004791710686)
    h2e[0, 9, 2, 6] = complex(0.000438678793, -0.012616339533)
    h2e[2, 9, 2, 6] = complex(-0.010512897409, -0.018118169559)
    h2e[4, 9, 2, 6] = complex(0.004156586155, 0.007549552405)
    h2e[6, 9, 2, 6] = complex(0.000016460117, -0.000013235982)
    h2e[10, 9, 2, 6] = complex(0.002964931518, 0.000008690137)
    h2e[0, 9, 4, 6] = complex(-0.000007623199, 0.005396559287)
    h2e[2, 9, 4, 6] = complex(0.004156614346, 0.007549603588)
    h2e[4, 9, 4, 6] = complex(-0.004733677729, -0.008747946606)
    h2e[6, 9, 4, 6] = complex(-0.000017728854, 0.000014877101)
    h2e[10, 9, 4, 6] = complex(0.000347273151, 0.000114456318)
    h2e[0, 9, 8, 6] = complex(0.000007914318, 0.000013815883)
    h2e[2, 9, 8, 6] = complex(-0.000005714128, -0.000000771222)
    h2e[4, 9, 8, 6] = complex(0.000011586593, -0.000005994034)
    h2e[6, 9, 8, 6] = complex(0.005584438856, 0.003946960094)
    h2e[10, 9, 8, 6] = complex(0.000003274412, 0.000003627318)
    h2e[0, 9, 10, 6] = complex(-0.000061981305, 0.004793954807)
    h2e[2, 9, 10, 6] = complex(0.002964928700, 0.000008690134)
    h2e[4, 9, 10, 6] = complex(0.000347250761, 0.000114448941)
    h2e[6, 9, 10, 6] = complex(0.000000087001, -0.000000224979)
    h2e[10, 9, 10, 6] = complex(-0.002014209350, 0.004300061917)
    h2e[0, 11, 0, 6] = complex(0.000001401526, -0.000003027226)
    h2e[2, 11, 0, 6] = complex(0.000003197311, -0.000004347637)
    h2e[4, 11, 0, 6] = complex(0.000003609035, -0.000008434492)
    h2e[6, 11, 0, 6] = complex(0.004381428755, 0.000364565915)
    h2e[8, 11, 0, 6] = complex(0.000080523200, 0.004791434588)
    h2e[0, 11, 2, 6] = complex(-0.000020451083, 0.000043268079)
    h2e[2, 11, 2, 6] = complex(0.000004741240, -0.000016598516)
    h2e[4, 11, 2, 6] = complex(0.000033552169, -0.000103258250)
    h2e[6, 11, 2, 6] = complex(0.005840714850, -0.003515343886)
    h2e[8, 11, 2, 6] = complex(0.002963879368, -0.000079455251)
    h2e[0, 11, 4, 6] = complex(0.000007840523, -0.000018916040)
    h2e[2, 11, 4, 6] = complex(0.000024506929, -0.000067849656)
    h2e[4, 11, 4, 6] = complex(0.000017851241, -0.000062523327)
    h2e[6, 11, 4, 6] = complex(0.000766581984, -0.000431596296)
    h2e[8, 11, 4, 6] = complex(0.000350522217, 0.000104081988)
    h2e[0, 11, 6, 6] = complex(-0.003309159175, -0.000006248378)
    h2e[2, 11, 6, 6] = complex(0.032020567492, -0.001586368686)
    h2e[4, 11, 6, 6] = complex(0.041021844538, -0.003823654936)
    h2e[6, 11, 6, 6] = complex(-0.000033242169, -0.000129232017)
    h2e[0, 11, 8, 6] = complex(-0.000000000158, -0.000000009415)
    h2e[2, 11, 8, 6] = complex(-0.000000003172, 0.000000000085)
    h2e[4, 11, 8, 6] = complex(0.000000004240, 0.000000001259)
    h2e[6, 11, 8, 6] = complex(-0.000000080274, 0.000000227466)
    h2e[8, 11, 8, 6] = complex(0.000003380798, 0.000003528373)
    h2e[0, 11, 10, 6] = complex(-0.000008187017, 0.000014583491)
    h2e[2, 11, 10, 6] = complex(0.000022427279, -0.000044564751)
    h2e[4, 11, 10, 6] = complex(0.000056683202, -0.000122935741)
    h2e[6, 11, 10, 6] = complex(-0.000047430001, 0.002515859486)
    h2e[8, 11, 10, 6] = complex(-0.001885486742, 0.004358039856)
    h2e[2, 1, 0, 8] = complex(0.000000202697, 0.000000152326)
    h2e[4, 1, 0, 8] = complex(0.000012081850, 0.000007986419)
    h2e[6, 1, 0, 8] = complex(-0.002017521274, 0.006171430679)
    h2e[8, 1, 0, 8] = complex(-0.000107937915, 0.001608557724)
    h2e[10, 1, 0, 8] = complex(0.000001238203, 0.000001449484)
    h2e[2, 1, 2, 8] = complex(-0.000000674086, -0.000000366998)
    h2e[4, 1, 2, 8] = complex(-0.000026869450, -0.000012943403)
    h2e[6, 1, 2, 8] = complex(0.000239265458, -0.012596273915)
    h2e[8, 1, 2, 8] = complex(-0.013799076320, -0.001108253273)
    h2e[10, 1, 2, 8] = complex(-0.000006860780, -0.000004224608)
    h2e[2, 1, 4, 8] = complex(0.000000298498, 0.000000143791)
    h2e[4, 1, 4, 8] = complex(0.000011731927, 0.000004949195)
    h2e[6, 1, 4, 8] = complex(0.000198837475, 0.005378301972)
    h2e[8, 1, 4, 8] = complex(0.006129270083, 0.000158191346)
    h2e[10, 1, 4, 8] = complex(0.000003142713, 0.000001724626)
    h2e[4, 1, 6, 8] = complex(-0.000000001237, -0.000000033472)
    h2e[6, 1, 6, 8] = complex(0.000012728134, -0.000006515709)
    h2e[8, 1, 6, 8] = complex(-0.000005646251, -0.000015233453)
    h2e[10, 1, 6, 8] = complex(0.000000000946, -0.000000009389)
    h2e[2, 1, 8, 8] = complex(0.010332504552, 0.000596019546)
    h2e[4, 1, 8, 8] = complex(-0.004661954605, -0.000054392577)
    h2e[6, 1, 8, 8] = complex(0.000004332632, 0.000011244662)
    h2e[10, 1, 8, 8] = complex(-0.003292373674, -0.000318167008)
    h2e[2, 1, 10, 8] = complex(0.000000235431, 0.000000144969)
    h2e[4, 1, 10, 8] = complex(0.000009936130, 0.000005452646)
    h2e[6, 1, 10, 8] = complex(-0.000481323798, 0.004778383318)
    h2e[8, 1, 10, 8] = complex(0.004331795283, 0.000727612579)
    h2e[10, 1, 10, 8] = complex(0.000002241449, 0.000001568561)
    h2e[0, 3, 0, 8] = complex(0.000000211094, 0.000000140458)
    h2e[4, 3, 0, 8] = complex(0.000030602936, 0.000012635700)
    h2e[6, 3, 0, 8] = complex(0.000483242819, 0.012594849409)
    h2e[8, 3, 0, 8] = complex(-0.013831597722, 0.000307905477)
    h2e[10, 3, 0, 8] = complex(0.000004290813, 0.000002314010)
    h2e[0, 3, 2, 8] = complex(-0.000000694011, -0.000000327763)
    h2e[4, 3, 2, 8] = complex(0.000038563453, 0.000028518974)
    h2e[6, 3, 2, 8] = complex(-0.009780409140, 0.018388683671)
    h2e[8, 3, 2, 8] = complex(-0.000088951434, -0.009127875534)
    h2e[10, 3, 2, 8] = complex(-0.000002252709, 0.000001037192)
    h2e[0, 3, 4, 8] = complex(0.000000306248, 0.000000126447)
    h2e[4, 3, 4, 8] = complex(-0.000017725045, -0.000010860310)
    h2e[6, 3, 4, 8] = complex(0.003091996335, -0.007975948925)
    h2e[8, 3, 4, 8] = complex(0.001463667207, 0.003167307382)
    h2e[10, 3, 4, 8] = complex(0.000000306867, -0.000000565646)
    h2e[4, 3, 6, 8] = complex(-0.000000021286, 0.000000054908)
    h2e[6, 3, 6, 8] = complex(-0.000024773155, -0.000003708238)
    h2e[8, 3, 6, 8] = complex(0.000010312834, -0.000009380847)
    h2e[10, 3, 6, 8] = complex(-0.000000003551, -0.000000000136)
    h2e[0, 3, 8, 8] = complex(0.010349680252, 0.000002876714)
    h2e[4, 3, 8, 8] = complex(0.003842327175, -0.000308905329)
    h2e[6, 3, 8, 8] = complex(0.000010901158, -0.000020800151)
    h2e[10, 3, 8, 8] = complex(-0.032056919869, 0.000397321671)
    h2e[0, 3, 10, 8] = complex(0.000000243352, 0.000000131238)
    h2e[4, 3, 10, 8] = complex(0.000001922779, -0.000003544238)
    h2e[6, 3, 10, 8] = complex(0.003317476202, 0.000126794778)
    h2e[8, 3, 10, 8] = complex(-0.005955836904, 0.002854636026)
    h2e[10, 3, 10, 8] = complex(0.000002962379, 0.000000869116)
    h2e[0, 5, 0, 8] = complex(-0.000012174054, -0.000007845151)
    h2e[2, 5, 0, 8] = complex(0.000029993816, 0.000014020399)
    h2e[6, 5, 0, 8] = complex(0.000261590016, 0.005378105159)
    h2e[8, 5, 0, 8] = complex(-0.006129530300, 0.000086558138)
    h2e[10, 5, 0, 8] = complex(-0.000009215991, -0.000004918661)
    h2e[0, 5, 2, 8] = complex(0.000027018388, 0.000012629557)
    h2e[2, 5, 2, 8] = complex(0.000037220502, 0.000030250712)
    h2e[6, 5, 2, 8] = complex(-0.003453119359, 0.007826439903)
    h2e[8, 5, 2, 8] = complex(0.001254140093, -0.003319688531)
    h2e[10, 5, 2, 8] = complex(0.000001732108, -0.000002871539)
    h2e[0, 5, 4, 8] = complex(-0.000011788778, -0.000004812209)
    h2e[2, 5, 4, 8] = complex(-0.000017210463, -0.000011658622)
    h2e[6, 5, 4, 8] = complex(0.003037627376, -0.009385199245)
    h2e[8, 5, 4, 8] = complex(0.000186213762, 0.003355197518)
    h2e[10, 5, 4, 8] = complex(-0.000000200854, -0.000001326253)
    h2e[0, 5, 6, 8] = complex(0.000000001627, 0.000000033455)
    h2e[2, 5, 6, 8] = complex(-0.000000023772, 0.000000053878)
    h2e[6, 5, 6, 8] = complex(-0.000026373949, -0.000002033463)
    h2e[8, 5, 6, 8] = complex(0.000017398176, -0.000007876997)
    h2e[10, 5, 6, 8] = complex(-0.000000004599, 0.000000001394)
    h2e[0, 5, 8, 8] = complex(0.004662271901, 0.000000087528)
    h2e[2, 5, 8, 8] = complex(0.003852426818, -0.000133072293)
    h2e[6, 5, 8, 8] = complex(-0.000027499467, 0.000016060053)
    h2e[10, 5, 8, 8] = complex(0.041196394799, -0.000417724513)
    h2e[0, 5, 10, 8] = complex(-0.000009998967, -0.000005336543)
    h2e[2, 5, 10, 8] = complex(0.000002082667, -0.000003452709)
    h2e[6, 5, 10, 8] = complex(-0.000380216286, 0.000115210228)
    h2e[8, 5, 10, 8] = complex(0.000798933121, -0.000317711329)
    h2e[10, 5, 10, 8] = complex(-0.000011630809, -0.000002882399)
    h2e[0, 7, 0, 8] = complex(-0.004983894765, -0.004161459073)
    h2e[2, 7, 0, 8] = complex(0.011615327987, 0.004893660305)
    h2e[4, 7, 0, 8] = complex(-0.005071188503, -0.001809831933)
    h2e[8, 7, 0, 8] = complex(0.000015833017, -0.000000018779)
    h2e[10, 7, 0, 8] = complex(-0.004261534894, -0.002219357795)
    h2e[0, 7, 2, 8] = complex(0.011610194466, 0.004891497604)
    h2e[2, 7, 2, 8] = complex(0.012519803049, 0.016644957932)
    h2e[4, 7, 2, 8] = complex(-0.005917285505, -0.006177615033)
    h2e[8, 7, 2, 8] = complex(-0.000003955109, 0.000002695722)
    h2e[10, 7, 2, 8] = complex(0.001519179704, -0.002951914263)
    h2e[0, 7, 4, 8] = complex(-0.005068846193, -0.001808996043)
    h2e[2, 7, 4, 8] = complex(-0.005917245390, -0.006177573141)
    h2e[4, 7, 4, 8] = complex(0.007516668810, 0.006388179342)
    h2e[8, 7, 4, 8] = complex(-0.000001762359, -0.000027186528)
    h2e[10, 7, 4, 8] = complex(0.000038544746, -0.000395388136)
    h2e[0, 7, 6, 8] = complex(0.000001333359, 0.000014236643)
    h2e[2, 7, 6, 8] = complex(-0.000013846233, 0.000020874435)
    h2e[4, 7, 6, 8] = complex(0.000011940821, -0.000023603746)
    h2e[8, 7, 6, 8] = complex(0.005323370353, -0.002496850502)
    h2e[10, 7, 6, 8] = complex(-0.000000672784, 0.000000139743)
    h2e[0, 7, 8, 8] = complex(-0.000012049618, -0.000000144287)
    h2e[2, 7, 8, 8] = complex(-0.000014230142, -0.000018681129)
    h2e[4, 7, 8, 8] = complex(-0.000004355048, -0.000031546467)
    h2e[10, 7, 8, 8] = complex(-0.000130149095, -0.000029435943)
    h2e[0, 7, 10, 8] = complex(-0.004259539992, -0.002218318908)
    h2e[2, 7, 10, 8] = complex(0.001519181147, -0.002951917063)
    h2e[4, 7, 10, 8] = complex(0.000038547234, -0.000395413628)
    h2e[8, 7, 10, 8] = complex(-0.000006618918, -0.000003330966)
    h2e[10, 7, 10, 8] = complex(-0.005031381550, -0.000015325562)
    h2e[0, 9, 0, 8] = complex(0.000003682266, -0.001612170894)
    h2e[2, 9, 0, 8] = complex(-0.013828950504, 0.000409913680)
    h2e[4, 9, 0, 8] = complex(0.006116309246, -0.000411576476)
    h2e[6, 9, 0, 8] = complex(-0.000006824778, -0.000014286609)
    h2e[10, 9, 0, 8] = complex(0.004368984612, -0.000169523403)
    h2e[0, 9, 2, 8] = complex(0.013841862086, 0.000213510467)
    h2e[2, 9, 2, 8] = complex(-0.000156272699, -0.009126971254)
    h2e[4, 9, 2, 8] = complex(-0.001076281959, 0.003381540566)
    h2e[6, 9, 2, 8] = complex(0.000004134409, 0.000002411737)
    h2e[10, 9, 2, 8] = complex(0.005828994871, 0.002665897618)
    h2e[0, 9, 4, 8] = complex(-0.006126669315, 0.000238535909)
    h2e[2, 9, 4, 8] = complex(0.001486988231, 0.003156425807)
    h2e[4, 9, 4, 8] = complex(-0.000363927634, -0.003340596164)
    h2e[6, 9, 4, 8] = complex(-0.000023787315, 0.000013280693)
    h2e[10, 9, 4, 8] = complex(0.000796756942, 0.000259784278)
    h2e[0, 9, 6, 8] = complex(0.000006619618, 0.000014836404)
    h2e[2, 9, 6, 8] = complex(0.000010243364, -0.000009456656)
    h2e[4, 9, 6, 8] = complex(-0.000016955847, 0.000008788791)
    h2e[6, 9, 6, 8] = complex(-0.004543180579, -0.003732565414)
    h2e[10, 9, 6, 8] = complex(-0.000003149213, -0.000005826606)
    h2e[0, 9, 10, 8] = complex(-0.004369783444, -0.000445940704)
    h2e[2, 9, 10, 8] = complex(-0.005934620211, 0.002898486377)
    h2e[4, 9, 10, 8] = complex(-0.000780955369, 0.000359643346)
    h2e[6, 9, 10, 8] = complex(-0.000000161351, 0.000007408061)
    h2e[10, 9, 10, 8] = complex(0.000105118714, -0.002169302443)
    h2e[0, 11, 0, 8] = complex(0.000001369385, 0.000001326249)
    h2e[2, 11, 0, 8] = complex(-0.000004373707, -0.000002153230)
    h2e[4, 11, 0, 8] = complex(-0.000009591226, -0.000004139577)
    h2e[6, 11, 0, 8] = complex(0.000028543230, -0.004804728290)
    h2e[8, 11, 0, 8] = complex(0.004362014034, -0.000299329738)
    h2e[0, 11, 2, 8] = complex(-0.000007228623, -0.000003558740)
    h2e[2, 11, 2, 8] = complex(0.000002212679, -0.000001120050)
    h2e[4, 11, 2, 8] = complex(0.000001488674, -0.000003004961)
    h2e[6, 11, 2, 8] = complex(0.003319893288, 0.000003630548)
    h2e[8, 11, 2, 8] = complex(0.005905670463, 0.002491434814)
    h2e[0, 11, 4, 8] = complex(0.000003291355, 0.000001420550)
    h2e[2, 11, 4, 8] = complex(-0.000000285671, 0.000000576641)
    h2e[4, 11, 4, 8] = complex(-0.000000309857, -0.000001305096)
    h2e[6, 11, 4, 8] = complex(0.000369361039, -0.000146252850)
    h2e[8, 11, 4, 8] = complex(0.000804127668, 0.000235983446)
    h2e[0, 11, 6, 8] = complex(0.000000000056, -0.000000009437)
    h2e[2, 11, 6, 8] = complex(0.000000003553, 0.000000000004)
    h2e[4, 11, 6, 8] = complex(-0.000000004468, 0.000000001769)
    h2e[6, 11, 6, 8] = complex(-0.000000431534, -0.000000534737)
    h2e[8, 11, 6, 8] = complex(-0.000003321035, -0.000005730411)
    h2e[0, 11, 8, 8] = complex(-0.003307705496, -0.000006245633)
    h2e[2, 11, 8, 8] = complex(0.032020110590, -0.001586346050)
    h2e[4, 11, 8, 8] = complex(0.041020701069, -0.003823548353)
    h2e[6, 11, 8, 8] = complex(-0.000033241520, -0.000129229497)
    h2e[0, 11, 10, 8] = complex(0.000002379390, 0.000001350179)
    h2e[2, 11, 10, 8] = complex(-0.000002992584, -0.000000758615)
    h2e[4, 11, 10, 8] = complex(-0.000011829356, -0.000001910566)
    h2e[6, 11, 10, 8] = complex(-0.002283825306, -0.004483210566)
    h2e[8, 11, 10, 8] = complex(0.000040583182, -0.002171468589)
    h2e[2, 1, 0, 10] = complex(-0.009867183157, -0.000479410218)
    h2e[4, 1, 0, 10] = complex(-0.001451429567, -0.000003766317)
    h2e[6, 1, 0, 10] = complex(0.000000978064, 0.000000840426)
    h2e[8, 1, 0, 10] = complex(0.000001385015, -0.000001352385)
    h2e[10, 1, 0, 10] = complex(0.009223831330, 0.000806980829)
    h2e[2, 1, 2, 10] = complex(-0.003468355354, -0.000076789600)
    h2e[4, 1, 2, 10] = complex(0.014258774527, -0.000339663122)
    h2e[6, 1, 2, 10] = complex(-0.000016072254, -0.000037047434)
    h2e[8, 1, 2, 10] = complex(-0.000004420769, 0.000002062736)
    h2e[10, 1, 2, 10] = complex(-0.010032790309, -0.000611298048)
    h2e[2, 1, 4, 10] = complex(-0.004216577651, 0.000099524797)
    h2e[4, 1, 4, 10] = complex(-0.003521673693, 0.000245335603)
    h2e[6, 1, 4, 10] = complex(-0.000000841398, -0.000000623663)
    h2e[8, 1, 4, 10] = complex(-0.000009288767, 0.000004800983)
    h2e[10, 1, 4, 10] = complex(0.006655622204, 0.000100637398)
    h2e[2, 1, 6, 10] = complex(0.000004236771, 0.000008869878)
    h2e[4, 1, 6, 10] = complex(0.000001642055, 0.000001457376)
    h2e[6, 1, 6, 10] = complex(0.002860296064, -0.003221238714)
    h2e[8, 1, 6, 10] = complex(-0.003644658590, -0.003028576796)
    h2e[10, 1, 6, 10] = complex(-0.000008685678, -0.000020503497)
    h2e[2, 1, 8, 10] = complex(-0.000000250723, 0.000000116988)
    h2e[4, 1, 8, 10] = complex(-0.000010077925, 0.000005208867)
    h2e[6, 1, 8, 10] = complex(-0.003642952466, -0.003027159082)
    h2e[8, 1, 8, 10] = complex(-0.002629860349, 0.003433548673)
    h2e[10, 1, 8, 10] = complex(-0.000002486479, 0.000001133309)
    h2e[2, 1, 10, 10] = complex(0.006850273639, 0.000395150756)
    h2e[4, 1, 10, 10] = complex(-0.014577040997, -0.000170075191)
    h2e[6, 1, 10, 10] = complex(0.000013235414, 0.000034350425)
    h2e[10, 1, 10, 10] = complex(0.008101979308, 0.000782955633)
    h2e[0, 3, 0, 10] = complex(-0.009878440701, 0.000086873052)
    h2e[4, 3, 0, 10] = complex(-0.000480902956, 0.000043056429)
    h2e[6, 3, 0, 10] = complex(-0.000004647024, -0.000005151836)
    h2e[8, 3, 0, 10] = complex(0.000007099012, -0.000003822309)
    h2e[10, 3, 0, 10] = complex(-0.001495080472, 0.000032097593)
    h2e[0, 3, 2, 10] = complex(-0.003467055598, 0.000122110532)
    h2e[4, 3, 2, 10] = complex(0.000170084765, -0.000019767153)
    h2e[6, 3, 2, 10] = complex(0.000000778276, 0.000011366437)
    h2e[8, 3, 2, 10] = complex(-0.000002321234, -0.000001078859)
    h2e[10, 3, 2, 10] = complex(0.026508467156, -0.001270123240)
    h2e[0, 3, 4, 10] = complex(-0.004203943406, 0.000341016291)
    h2e[4, 3, 4, 10] = complex(-0.005165505374, 0.000841251375)
    h2e[6, 3, 4, 10] = complex(-0.000007877480, 0.000038442626)
    h2e[8, 3, 4, 10] = complex(-0.000002068568, -0.000002998006)
    h2e[10, 3, 4, 10] = complex(0.016047462857, -0.001506647073)
    h2e[0, 3, 6, 10] = complex(0.000004738147, 0.000008612487)
    h2e[4, 3, 6, 10] = complex(0.000019296112, 0.000024034205)
    h2e[6, 3, 6, 10] = complex(-0.003695912988, 0.004466992943)
    h2e[8, 3, 6, 10] = complex(0.000044953141, 0.000055573302)
    h2e[10, 3, 6, 10] = complex(-0.000024517836, -0.000044655943)
    h2e[0, 3, 8, 10] = complex(-0.000000243606, 0.000000131164)
    h2e[4, 3, 8, 10] = complex(-0.000002487225, -0.000003604771)
    h2e[6, 3, 8, 10] = complex(0.000044953250, 0.000055573291)
    h2e[8, 3, 8, 10] = complex(0.003375224416, -0.004740536624)
    h2e[10, 3, 8, 10] = complex(-0.000002930086, 0.000000855489)
    h2e[0, 3, 10, 10] = complex(0.006861660835, 0.000001907212)
    h2e[4, 3, 10, 10] = complex(-0.004333341942, 0.000348380645)
    h2e[6, 3, 10, 10] = complex(-0.000009200169, 0.000017554547)
    h2e[10, 3, 10, 10] = complex(-0.010246369595, 0.000126996128)
    h2e[0, 5, 0, 10] = complex(0.001451374975, -0.000013139851)
    h2e[2, 5, 0, 10] = complex(-0.000482367733, 0.000021044704)
    h2e[6, 5, 0, 10] = complex(-0.000002270058, -0.000002716469)
    h2e[8, 5, 0, 10] = complex(0.000003168156, -0.000001684536)
    h2e[10, 5, 0, 10] = complex(-0.001194970948, 0.000022960039)
    h2e[0, 5, 2, 10] = complex(-0.014253850930, 0.000505722958)
    h2e[2, 5, 2, 10] = complex(0.000170810160, -0.000011977354)
    h2e[6, 5, 2, 10] = complex(0.000019068125, -0.000008254359)
    h2e[8, 5, 2, 10] = complex(-0.000000370260, -0.000000592839)
    h2e[10, 5, 2, 10] = complex(-0.019432266352, 0.000887175954)
    h2e[0, 5, 4, 10] = complex(0.003518577179, -0.000286338593)
    h2e[2, 5, 4, 10] = complex(-0.005198540503, 0.000604422276)
    h2e[6, 5, 4, 10] = complex(0.000010181032, -0.000013106689)
    h2e[8, 5, 4, 10] = complex(0.000000019513, 0.000001457574)
    h2e[10, 5, 4, 10] = complex(-0.045886543791, 0.004203821416)
    h2e[0, 5, 6, 10] = complex(-0.000001658919, -0.000001438151)
    h2e[2, 5, 6, 10] = complex(0.000018178132, 0.000024890529)
    h2e[6, 5, 6, 10] = complex(0.000490939589, -0.000604130834)
    h2e[8, 5, 6, 10] = complex(-0.000110545142, -0.000078646012)
    h2e[10, 5, 6, 10] = complex(0.000064165953, 0.000119631194)
    h2e[0, 5, 8, 10] = complex(0.000010016570, -0.000005325899)
    h2e[2, 5, 8, 10] = complex(-0.000002319970, -0.000003714620)
    h2e[6, 5, 8, 10] = complex(-0.000110552275, -0.000078651074)
    h2e[8, 5, 8, 10] = complex(-0.000447838393, 0.000640805898)
    h2e[10, 5, 8, 10] = complex(0.000011484993, -0.000002825820)
    h2e[0, 5, 10, 10] = complex(0.014578033123, 0.000000273683)
    h2e[2, 5, 10, 10] = complex(-0.004344732228, 0.000150077732)
    h2e[6, 5, 10, 10] = complex(0.000005477015, -0.000003198649)
    h2e[10, 5, 10, 10] = complex(-0.009497823109, 0.000096306329)
    h2e[0, 7, 0, 10] = complex(-0.000001143108, 0.000000596849)
    h2e[2, 7, 0, 10] = complex(-0.000006634608, 0.000002029341)
    h2e[4, 7, 0, 10] = complex(0.000003377024, -0.000001062111)
    h2e[8, 7, 0, 10] = complex(-0.000000008178, 0.000000004443)
    h2e[10, 7, 0, 10] = complex(0.000006339972, 0.000000809003)
    h2e[0, 7, 2, 10] = complex(0.000040365870, -0.000001194221)
    h2e[2, 7, 2, 10] = complex(0.000010627292, 0.000004106371)
    h2e[4, 7, 2, 10] = complex(0.000000356032, 0.000020775011)
    h2e[10, 7, 2, 10] = complex(0.000061637415, 0.000010869910)
    h2e[0, 7, 4, 10] = complex(0.000000891127, -0.000000550271)
    h2e[2, 7, 4, 10] = complex(0.000031493933, 0.000023409878)
    h2e[4, 7, 4, 10] = complex(0.000008231664, 0.000014411053)
    h2e[8, 7, 4, 10] = complex(0.000000001390, -0.000000000873)
    h2e[10, 7, 4, 10] = complex(0.000139123151, 0.000015738328)
    h2e[0, 7, 6, 10] = complex(0.001931475206, 0.003850594235)
    h2e[2, 7, 6, 10] = complex(0.002482535846, 0.005239352483)
    h2e[4, 7, 6, 10] = complex(0.000371161035, 0.000684277159)
    h2e[8, 7, 6, 10] = complex(0.000000010143, 0.000000286591)
    h2e[10, 7, 6, 10] = complex(0.000263232548, -0.000123925162)
    h2e[0, 7, 8, 10] = complex(0.004161893460, -0.002261291140)
    h2e[2, 7, 8, 10] = complex(0.000069377667, -0.000017202501)
    h2e[4, 7, 8, 10] = complex(0.000114876740, -0.000072188167)
    h2e[8, 7, 8, 10] = complex(-0.000003633908, 0.000003267097)
    h2e[10, 7, 8, 10] = complex(0.003733332378, -0.002106913145)
    h2e[0, 7, 10, 10] = complex(-0.000036809422, -0.000000440770)
    h2e[2, 7, 10, 10] = complex(0.000012009705, 0.000015766173)
    h2e[4, 7, 10, 10] = complex(0.000000867386, 0.000006283048)
    h2e[10, 7, 10, 10] = complex(0.000038695021, 0.000008751689)
    h2e[0, 9, 0, 10] = complex(-0.000001294653, 0.000001439127)
    h2e[2, 9, 0, 10] = complex(0.000007070626, -0.000003874564)
    h2e[4, 9, 0, 10] = complex(-0.000003074339, 0.000001850219)
    h2e[6, 9, 0, 10] = complex(0.000000007528, 0.000000005473)
    h2e[10, 9, 0, 10] = complex(-0.000002407980, 0.000001291743)
    h2e[0, 9, 2, 10] = complex(0.000004278111, -0.000002344321)
    h2e[2, 9, 2, 10] = complex(-0.000002329130, -0.000001061709)
    h2e[4, 9, 2, 10] = complex(0.000000401179, 0.000000572363)
    h2e[10, 9, 2, 10] = complex(0.000002923693, -0.000000877077)
    h2e[0, 9, 4, 10] = complex(0.000008958829, -0.000005391662)
    h2e[2, 9, 4, 10] = complex(-0.000002090630, -0.000002982668)
    h2e[4, 9, 4, 10] = complex(-0.000000096807, -0.000001454486)
    h2e[6, 9, 4, 10] = complex(-0.000000001386, -0.000000000879)
    h2e[10, 9, 4, 10] = complex(0.000011318920, -0.000003431063)
    h2e[0, 9, 6, 10] = complex(0.003832894681, 0.002786526875)
    h2e[2, 9, 6, 10] = complex(0.000045361829, 0.000055240220)
    h2e[4, 9, 6, 10] = complex(0.000114561279, 0.000072671434)
    h2e[6, 9, 6, 10] = complex(0.000000254385, -0.000000132384)
    h2e[10, 9, 6, 10] = complex(0.003507450636, 0.002464679224)
    h2e[0, 9, 8, 10] = complex(0.002402298165, -0.003596440671)
    h2e[2, 9, 8, 10] = complex(0.003340168209, -0.004765302065)
    h2e[4, 9, 8, 10] = complex(0.000413216421, -0.000663659262)
    h2e[6, 9, 8, 10] = complex(0.000004512161, 0.000001876063)
    h2e[10, 9, 8, 10] = complex(-0.000238436735, -0.000168521899)
    h2e[0, 11, 0, 10] = complex(0.009258825969, -0.000066514129)
    h2e[2, 11, 0, 10] = complex(0.001492860412, -0.000087542337)
    h2e[4, 11, 0, 10] = complex(-0.001188977837, 0.000121714556)
    h2e[6, 11, 0, 10] = complex(0.000002175260, 0.000006009823)
    h2e[8, 11, 0, 10] = complex(-0.000002368514, 0.000001362757)
    h2e[0, 11, 2, 10] = complex(-0.010045724518, 0.000337617531)
    h2e[2, 11, 2, 10] = complex(-0.026443097014, 0.002252701556)
    h2e[4, 11, 2, 10] = complex(-0.019292312434, 0.002491332513)
    h2e[6, 11, 2, 10] = complex(0.000018474738, 0.000059799748)
    h2e[8, 11, 2, 10] = complex(0.000002896332, -0.000000963605)
    h2e[0, 11, 4, 10] = complex(0.006635448482, -0.000527501892)
    h2e[2, 11, 4, 10] = complex(-0.015980519409, 0.002100963810)
    h2e[4, 11, 4, 10] = complex(-0.045381641944, 0.007984584523)
    h2e[6, 11, 4, 10] = complex(0.000049525510, 0.000130958657)
    h2e[8, 11, 4, 10] = complex(0.000011211930, -0.000003766034)
    h2e[0, 11, 6, 10] = complex(-0.000010580647, -0.000019592966)
    h2e[2, 11, 6, 10] = complex(0.000026157673, 0.000043715600)
    h2e[4, 11, 6, 10] = complex(0.000073840521, 0.000113914307)
    h2e[6, 11, 6, 10] = complex(0.000230449931, 0.000177599660)
    h2e[8, 11, 6, 10] = complex(0.003579170497, 0.002359320296)
    h2e[0, 11, 8, 10] = complex(-0.000002368515, 0.000001362757)
    h2e[2, 11, 8, 10] = complex(0.000002896331, -0.000000963605)
    h2e[4, 11, 8, 10] = complex(0.000011211926, -0.000003766035)
    h2e[6, 11, 8, 10] = complex(0.003579170444, 0.002359320345)
    h2e[8, 11, 8, 10] = complex(-0.000243341214, -0.000161359194)
    h2e[0, 11, 10, 10] = complex(0.008139708349, 0.000015369455)
    h2e[2, 11, 10, 10] = complex(0.010234604227, -0.000507044594)
    h2e[4, 11, 10, 10] = complex(-0.009457316943, 0.000881518542)
    h2e[6, 11, 10, 10] = complex(0.000009883137, 0.000038421612)
    h2e[2, 1, 2, 1] = complex(0.049760692428, 0.005759951206)
    h2e[4, 1, 2, 1] = complex(-0.020822915064, -0.001445068169)
    h2e[6, 1, 2, 1] = complex(0.000016725844, 0.000052208813)
    h2e[8, 1, 2, 1] = complex(-0.000000397642, 0.000000125694)
    h2e[10, 1, 2, 1] = complex(-0.020129419425, -0.003123815959)
    h2e[2, 1, 4, 1] = complex(-0.020822915064, -0.001445068169)
    h2e[4, 1, 4, 1] = complex(0.020930467936, 0.000488471980)
    h2e[6, 1, 4, 1] = complex(-0.000028362870, -0.000075623110)
    h2e[8, 1, 4, 1] = complex(-0.000019827698, 0.000007113296)
    h2e[10, 1, 4, 1] = complex(-0.002975456451, -0.000322620263)
    h2e[2, 1, 6, 1] = complex(0.000016725844, 0.000052208813)
    h2e[4, 1, 6, 1] = complex(-0.000028362870, -0.000075623110)
    h2e[6, 1, 6, 1] = complex(0.007995313794, -0.007468112725)
    h2e[8, 1, 6, 1] = complex(-0.006399143029, -0.006321267484)
    h2e[10, 1, 6, 1] = complex(-0.000000051820, 0.000000916194)
    h2e[2, 1, 8, 1] = complex(-0.000000397642, 0.000000125694)
    h2e[4, 1, 8, 1] = complex(-0.000019827698, 0.000007113296)
    h2e[6, 1, 8, 1] = complex(-0.006399143029, -0.006321267484)
    h2e[8, 1, 8, 1] = complex(-0.007468648544, 0.008065739703)
    h2e[10, 1, 8, 1] = complex(-0.000006894038, 0.000002165622)
    h2e[2, 1, 10, 1] = complex(-0.020129419425, -0.003123815959)
    h2e[4, 1, 10, 1] = complex(-0.002975456451, -0.000322620263)
    h2e[6, 1, 10, 1] = complex(-0.000000051820, 0.000000916194)
    h2e[8, 1, 10, 1] = complex(-0.000006894038, 0.000002165622)
    h2e[10, 1, 10, 1] = complex(0.018739102486, 0.003655945124)
    h2e[0, 3, 2, 1] = complex(0.050009012185, 0.002898663307)
    h2e[4, 3, 2, 1] = complex(0.000467340044, -0.000010564972)
    h2e[6, 3, 2, 1] = complex(0.000001127288, -0.000002079128)
    h2e[8, 3, 2, 1] = complex(0.000000263947, -0.000000184026)
    h2e[10, 3, 2, 1] = complex(-0.001063204699, -0.000048117801)
    h2e[0, 3, 4, 1] = complex(-0.020871508207, -0.000249316921)
    h2e[4, 3, 4, 1] = complex(0.000723406641, -0.000049671882)
    h2e[6, 3, 4, 1] = complex(-0.000003323776, -0.000005658958)
    h2e[8, 3, 4, 1] = complex(0.000011719058, -0.000008567413)
    h2e[10, 3, 4, 1] = complex(0.004375585710, -0.000003180309)
    h2e[0, 3, 6, 1] = complex(0.000019690478, 0.000051164432)
    h2e[4, 3, 6, 1] = complex(-0.000000446489, -0.000008263900)
    h2e[6, 3, 6, 1] = complex(0.001426392904, -0.001564855335)
    h2e[8, 3, 6, 1] = complex(0.004519434681, 0.004060711015)
    h2e[10, 3, 6, 1] = complex(-0.000004654757, -0.000012660344)
    h2e[0, 3, 8, 1] = complex(-0.000000389785, 0.000000148276)
    h2e[4, 3, 8, 1] = complex(0.000013009633, -0.000009510907)
    h2e[6, 3, 8, 1] = complex(0.004521433011, 0.004062506427)
    h2e[8, 3, 8, 1] = complex(-0.001314532309, 0.001670711130)
    h2e[10, 3, 8, 1] = complex(0.000000296829, -0.000000475283)
    h2e[0, 3, 10, 1] = complex(-0.020275362638, -0.001965050235)
    h2e[4, 3, 10, 1] = complex(-0.000995422909, -0.000016043351)
    h2e[6, 3, 10, 1] = complex(-0.000002339454, 0.000005359883)
    h2e[8, 3, 10, 1] = complex(0.000000490582, -0.000000785521)
    h2e[10, 3, 10, 1] = complex(-0.003072738021, -0.000258547980)
    h2e[0, 5, 2, 1] = complex(0.020838334307, 0.001202429685)
    h2e[2, 5, 2, 1] = complex(0.000467334826, 0.000010793309)
    h2e[6, 5, 2, 1] = complex(-0.000000489979, 0.000000233017)
    h2e[8, 5, 2, 1] = complex(0.000000134401, -0.000000089131)
    h2e[10, 5, 2, 1] = complex(0.001559861204, 0.000074118855)
    h2e[0, 5, 4, 1] = complex(-0.020934737673, -0.000244645639)
    h2e[2, 5, 4, 1] = complex(0.000724920476, -0.000016576119)
    h2e[6, 5, 4, 1] = complex(0.000000013908, -0.000001624242)
    h2e[8, 5, 4, 1] = complex(0.000005815373, -0.000004087664)
    h2e[10, 5, 4, 1] = complex(0.001307059596, 0.000001996369)
    h2e[0, 5, 6, 1] = complex(0.000029241785, 0.000075287616)
    h2e[2, 5, 6, 1] = complex(-0.000000068543, -0.000008275670)
    h2e[6, 5, 6, 1] = complex(0.000399405472, -0.000432412128)
    h2e[8, 5, 6, 1] = complex(0.002224874527, 0.001980797461)
    h2e[10, 5, 6, 1] = complex(-0.000000211311, 0.000001687600)
    h2e[0, 5, 8, 1] = complex(0.000019743499, -0.000007343761)
    h2e[2, 5, 8, 1] = complex(0.000013430494, -0.000008906723)
    h2e[6, 5, 8, 1] = complex(0.002225902655, 0.001981712760)
    h2e[8, 5, 8, 1] = complex(-0.000368501403, 0.000462038291)
    h2e[10, 5, 8, 1] = complex(-0.000001188773, 0.000001260923)
    h2e[0, 5, 10, 1] = complex(0.002979012409, 0.000287940955)
    h2e[2, 5, 10, 1] = complex(-0.000993651062, -0.000061495736)
    h2e[6, 5, 10, 1] = complex(-0.000001268407, 0.000001601602)
    h2e[8, 5, 10, 1] = complex(0.000000407943, -0.000000432702)
    h2e[10, 5, 10, 1] = complex(-0.002455374632, -0.000212176443)
    h2e[0, 7, 2, 1] = complex(-0.000054689397, -0.000003818881)
    h2e[2, 7, 2, 1] = complex(-0.000001406475, -0.000001901414)
    h2e[4, 7, 2, 1] = complex(-0.000000028478, -0.000000541817)
    h2e[10, 7, 2, 1] = complex(-0.000003625441, -0.000001089750)
    h2e[0, 7, 4, 1] = complex(0.000080749304, 0.000001690284)
    h2e[2, 7, 4, 1] = complex(-0.000006533915, 0.000000615828)
    h2e[4, 7, 4, 1] = complex(0.000001496106, 0.000000632472)
    h2e[8, 7, 4, 1] = complex(-0.000000016677, 0.000000008097)
    h2e[10, 7, 4, 1] = complex(0.000000327851, -0.000001947528)
    h2e[0, 7, 6, 1] = complex(0.003972306885, 0.010194043773)
    h2e[2, 7, 6, 1] = complex(-0.000813938176, -0.001954705504)
    h2e[4, 7, 6, 1] = complex(0.000247346666, 0.000534157850)
    h2e[8, 7, 6, 1] = complex(-0.000005093656, -0.000006188407)
    h2e[10, 7, 6, 1] = complex(0.000765785669, 0.001944608854)
    h2e[0, 7, 8, 1] = complex(0.008243006861, -0.003600040558)
    h2e[2, 7, 8, 1] = complex(0.005594526118, -0.002376676749)
    h2e[4, 7, 8, 1] = complex(-0.002680987283, 0.001301589514)
    h2e[8, 7, 8, 1] = complex(-0.000000178217, -0.000001992680)
    h2e[10, 7, 8, 1] = complex(-0.000730908643, 0.000200893723)
    h2e[0, 7, 10, 1] = complex(-0.000000831713, -0.000000387749)
    h2e[2, 7, 10, 1] = complex(0.000003865679, 0.000004388383)
    h2e[4, 7, 10, 1] = complex(-0.000000996612, -0.000001783465)
    h2e[8, 7, 10, 1] = complex(-0.000000001436, 0.000000000395)
    h2e[10, 7, 10, 1] = complex(0.000007404602, 0.000002139735)
    h2e[0, 9, 2, 1] = complex(0.000000388681, -0.000000151147)
    h2e[2, 9, 2, 1] = complex(0.000000262583, -0.000000185967)
    h2e[4, 9, 2, 1] = complex(-0.000000129484, 0.000000096135)
    h2e[10, 9, 2, 1] = complex(-0.000000016635, 0.000000027079)
    h2e[0, 9, 4, 1] = complex(0.000019326154, -0.000008380715)
    h2e[2, 9, 4, 1] = complex(0.000011655550, -0.000008653615)
    h2e[4, 9, 4, 1] = complex(-0.000005590356, 0.000004390385)
    h2e[6, 9, 4, 1] = complex(0.000000014481, 0.000000011576)
    h2e[10, 9, 4, 1] = complex(-0.000001215385, 0.000001434539)
    h2e[0, 9, 6, 1] = complex(0.006794559706, 0.005894184645)
    h2e[2, 9, 6, 1] = complex(0.004549262017, 0.004027266932)
    h2e[4, 9, 6, 1] = complex(-0.002326813360, -0.001859990550)
    h2e[6, 9, 6, 1] = complex(-0.000003396991, 0.000007259626)
    h2e[10, 9, 6, 1] = complex(-0.000495416382, -0.000573245604)
    h2e[0, 9, 8, 1] = complex(0.006931380489, -0.008531871577)
    h2e[2, 9, 8, 1] = complex(-0.001302174034, 0.001680361157)
    h2e[4, 9, 8, 1] = complex(0.000343473836, -0.000480934907)
    h2e[6, 9, 8, 1] = complex(-0.000001722442, 0.000001017707)
    h2e[10, 9, 8, 1] = complex(0.001317221292, -0.001633294011)
    h2e[0, 9, 10, 1] = complex(0.000006739549, -0.000002606944)
    h2e[2, 9, 10, 1] = complex(0.000000484774, -0.000000789118)
    h2e[4, 9, 10, 1] = complex(-0.000000384416, 0.000000453732)
    h2e[6, 9, 10, 1] = complex(0.000000000973, 0.000000001126)
    h2e[10, 9, 10, 1] = complex(0.000000583283, -0.000000057324)
    h2e[0, 11, 2, 1] = complex(-0.020334307069, -0.001211490232)
    h2e[2, 11, 2, 1] = complex(0.001064257911, 0.000008640240)
    h2e[4, 11, 2, 1] = complex(0.001560647090, -0.000055147467)
    h2e[6, 11, 2, 1] = complex(-0.000000685965, -0.000003723013)
    h2e[8, 11, 2, 1] = complex(-0.000000015823, 0.000000027561)
    h2e[0, 11, 4, 1] = complex(-0.002992620792, -0.000040567456)
    h2e[2, 11, 4, 1] = complex(-0.004372455455, 0.000165510463)
    h2e[4, 11, 4, 1] = complex(0.001302746537, -0.000106114235)
    h2e[6, 11, 4, 1] = complex(0.000001882341, -0.000000597617)
    h2e[8, 11, 4, 1] = complex(-0.000001172202, 0.000001470035)
    h2e[0, 11, 6, 1] = complex(0.000000034817, 0.000000916997)
    h2e[2, 11, 6, 1] = complex(0.000005121246, 0.000012478939)
    h2e[4, 11, 6, 1] = complex(-0.000000071010, 0.000001699295)
    h2e[6, 11, 6, 1] = complex(-0.001380360568, 0.001569246945)
    h2e[8, 11, 6, 1] = complex(-0.000512238867, -0.000558264507)
    h2e[0, 11, 8, 1] = complex(-0.000006659071, 0.000002806145)
    h2e[2, 11, 8, 1] = complex(-0.000000278991, 0.000000485968)
    h2e[4, 11, 8, 1] = complex(-0.000001080412, 0.000001354923)
    h2e[6, 11, 8, 1] = complex(-0.000512478782, -0.000558525948)
    h2e[8, 11, 8, 1] = complex(0.001268084505, -0.001671730528)
    h2e[0, 11, 10, 1] = complex(0.019000371943, 0.001872368224)
    h2e[2, 11, 10, 1] = complex(0.003080214687, 0.000144372733)
    h2e[4, 11, 10, 1] = complex(-0.002464510772, -0.000008371348)
    h2e[6, 11, 10, 1] = complex(0.000001477500, 0.000007564627)
    h2e[8, 11, 10, 1] = complex(0.000000581322, -0.000000074639)
    h2e[2, 1, 0, 3] = complex(0.050009012185, 0.002898663307)
    h2e[4, 1, 0, 3] = complex(-0.020871508207, -0.000249316921)
    h2e[6, 1, 0, 3] = complex(0.000019690478, 0.000051164432)
    h2e[8, 1, 0, 3] = complex(-0.000000389785, 0.000000148276)
    h2e[10, 1, 0, 3] = complex(-0.020275362638, -0.001965050235)
    h2e[2, 1, 4, 3] = complex(0.000467340044, -0.000010564972)
    h2e[4, 1, 4, 3] = complex(0.000723406641, -0.000049671882)
    h2e[6, 1, 4, 3] = complex(-0.000000446489, -0.000008263900)
    h2e[8, 1, 4, 3] = complex(0.000013009633, -0.000009510907)
    h2e[10, 1, 4, 3] = complex(-0.000995422909, -0.000016043351)
    h2e[2, 1, 6, 3] = complex(0.000001127288, -0.000002079128)
    h2e[4, 1, 6, 3] = complex(-0.000003323776, -0.000005658958)
    h2e[6, 1, 6, 3] = complex(0.001426392904, -0.001564855335)
    h2e[8, 1, 6, 3] = complex(0.004521433011, 0.004062506427)
    h2e[10, 1, 6, 3] = complex(-0.000002339454, 0.000005359883)
    h2e[2, 1, 8, 3] = complex(0.000000263947, -0.000000184026)
    h2e[4, 1, 8, 3] = complex(0.000011719058, -0.000008567413)
    h2e[6, 1, 8, 3] = complex(0.004519434681, 0.004060711015)
    h2e[8, 1, 8, 3] = complex(-0.001314532309, 0.001670711130)
    h2e[10, 1, 8, 3] = complex(0.000000490582, -0.000000785521)
    h2e[2, 1, 10, 3] = complex(-0.001063204699, -0.000048117801)
    h2e[4, 1, 10, 3] = complex(0.004375585710, -0.000003180309)
    h2e[6, 1, 10, 3] = complex(-0.000004654757, -0.000012660344)
    h2e[8, 1, 10, 3] = complex(0.000000296829, -0.000000475283)
    h2e[10, 1, 10, 3] = complex(-0.003072738021, -0.000258547980)
    h2e[0, 3, 0, 3] = complex(0.050092941350, 0.000027846866)
    h2e[4, 3, 0, 3] = complex(0.000465966433, -0.000037331199)
    h2e[6, 3, 0, 3] = complex(0.000001006278, -0.000002140316)
    h2e[8, 3, 0, 3] = complex(0.000000252967, -0.000000198850)
    h2e[10, 3, 0, 3] = complex(-0.001064214871, 0.000012894305)
    h2e[0, 3, 4, 3] = complex(0.000465966433, -0.000037331199)
    h2e[4, 3, 4, 3] = complex(0.000411125540, -0.000066556221)
    h2e[6, 3, 4, 3] = complex(-0.000076521500, -0.000143803229)
    h2e[8, 3, 4, 3] = complex(0.000135132740, -0.000075769389)
    h2e[10, 3, 4, 3] = complex(0.000052239105, -0.000004855941)
    h2e[0, 3, 6, 3] = complex(0.000001006278, -0.000002140316)
    h2e[4, 3, 6, 3] = complex(-0.000076521500, -0.000143803229)
    h2e[6, 3, 6, 3] = complex(0.039251243707, -0.048007016546)
    h2e[8, 3, 6, 3] = complex(0.047376396597, 0.035725092276)
    h2e[10, 3, 6, 3] = complex(-0.000010336441, -0.000019852458)
    h2e[0, 3, 8, 3] = complex(0.000000252967, -0.000000198850)
    h2e[4, 3, 8, 3] = complex(0.000135132740, -0.000075769389)
    h2e[6, 3, 8, 3] = complex(0.047376396597, 0.035725092276)
    h2e[8, 3, 8, 3] = complex(-0.035803319284, 0.050912546822)
    h2e[10, 3, 8, 3] = complex(0.000021935717, -0.000010865308)
    h2e[0, 3, 10, 3] = complex(-0.001064214871, 0.000012894305)
    h2e[4, 3, 10, 3] = complex(0.000052239105, -0.000004855941)
    h2e[6, 3, 10, 3] = complex(-0.000010336441, -0.000019852458)
    h2e[8, 3, 10, 3] = complex(0.000021935717, -0.000010865308)
    h2e[10, 3, 10, 3] = complex(0.008139163714, -0.000201789445)
    h2e[0, 5, 0, 3] = complex(0.020872996322, 0.000006193553)
    h2e[2, 5, 0, 3] = complex(0.000467185282, -0.000016007723)
    h2e[6, 5, 0, 3] = complex(-0.000000475820, 0.000000260715)
    h2e[8, 5, 0, 3] = complex(0.000000129072, -0.000000096687)
    h2e[10, 5, 0, 3] = complex(0.001561545206, -0.000015399727)
    h2e[0, 5, 4, 3] = complex(-0.000722779000, 0.000058094584)
    h2e[2, 5, 4, 3] = complex(0.000413736578, -0.000047707274)
    h2e[6, 5, 4, 3] = complex(-0.000029138109, -0.000051714034)
    h2e[8, 5, 4, 3] = complex(0.000049004710, -0.000027130265)
    h2e[10, 5, 4, 3] = complex(0.001929931147, -0.000174863006)
    h2e[0, 5, 6, 3] = complex(0.000003389465, 0.000005619860)
    h2e[2, 5, 6, 3] = complex(-0.000069872953, -0.000147148493)
    h2e[6, 5, 6, 3] = complex(0.014085822356, -0.017225184595)
    h2e[8, 5, 6, 3] = complex(0.016700086726, 0.012590486191)
    h2e[10, 5, 6, 3] = complex(0.000021929767, 0.000027158843)
    h2e[0, 5, 8, 3] = complex(-0.000011618473, 0.000008703332)
    h2e[2, 5, 8, 3] = complex(0.000138452701, -0.000069517680)
    h2e[6, 5, 8, 3] = complex(0.016700199957, 0.012590571550)
    h2e[8, 5, 8, 3] = complex(-0.012848404606, 0.018267473345)
    h2e[10, 5, 8, 3] = complex(-0.000037862960, 0.000018580122)
    h2e[0, 5, 10, 3] = complex(-0.004375251837, 0.000054145894)
    h2e[2, 5, 10, 3] = complex(0.000052406389, -0.000002464684)
    h2e[6, 5, 10, 3] = complex(0.000002425764, -0.000010042117)
    h2e[8, 5, 10, 3] = complex(0.000007265774, -0.000003565463)
    h2e[10, 5, 10, 3] = complex(-0.005966163293, 0.000134460219)
    h2e[0, 7, 0, 3] = complex(-0.000054818371, -0.000000678316)
    h2e[2, 7, 0, 3] = complex(-0.000001513135, -0.000001817683)
    h2e[4, 7, 0, 3] = complex(-0.000000059484, -0.000000539294)
    h2e[10, 7, 0, 3] = complex(-0.000003681936, -0.000000880183)
    h2e[0, 7, 4, 3] = complex(0.000007840669, 0.000002648642)
    h2e[2, 7, 4, 3] = complex(-0.000162675831, 0.000008454745)
    h2e[4, 7, 4, 3] = complex(0.000058918874, -0.000007206728)
    h2e[8, 7, 4, 3] = complex(-0.000000123978, 0.000000073207)
    h2e[10, 7, 4, 3] = complex(0.000042555943, -0.000000828664)
    h2e[0, 7, 6, 3] = complex(0.000924625946, 0.001904845354)
    h2e[2, 7, 6, 3] = complex(-0.026878451331, -0.055882757824)
    h2e[4, 7, 6, 3] = complex(0.010549105757, 0.019591675352)
    h2e[8, 7, 6, 3] = complex(-0.000044329611, -0.000031433484)
    h2e[10, 7, 6, 3] = complex(0.007573456544, 0.017320051648)
    h2e[0, 7, 8, 3] = complex(-0.005446713585, 0.002692206339)
    h2e[2, 7, 8, 3] = complex(0.052421165776, -0.027799758101)
    h2e[4, 7, 8, 3] = complex(-0.018009228615, 0.010634230346)
    h2e[8, 7, 8, 3] = complex(0.000031337095, -0.000044693796)
    h2e[10, 7, 8, 3] = complex(-0.017823056212, 0.008650585584)
    h2e[0, 7, 10, 3] = complex(0.000013483851, 0.000000369886)
    h2e[2, 7, 10, 3] = complex(-0.000022361542, 0.000000961021)
    h2e[4, 7, 10, 3] = complex(0.000008357323, 0.000006073188)
    h2e[8, 7, 10, 3] = complex(-0.000000019077, 0.000000009259)
    h2e[10, 7, 10, 3] = complex(0.000027494003, 0.000004428484)
    h2e[0, 9, 0, 3] = complex(0.000000379380, -0.000000173174)
    h2e[2, 9, 0, 3] = complex(0.000000251494, -0.000000200711)
    h2e[4, 9, 0, 3] = complex(-0.000000123761, 0.000000103398)
    h2e[10, 9, 0, 3] = complex(-0.000000015056, 0.000000027988)
    h2e[0, 9, 4, 3] = complex(-0.000012367302, 0.000010332364)
    h2e[2, 9, 4, 3] = complex(0.000134570219, -0.000076764016)
    h2e[4, 9, 4, 3] = complex(-0.000047496596, 0.000029691518)
    h2e[6, 9, 4, 3] = complex(0.000000119402, 0.000000080455)
    h2e[10, 9, 4, 3] = complex(-0.000044276876, 0.000024724013)
    h2e[0, 9, 6, 3] = complex(-0.004774700558, -0.003761588684)
    h2e[2, 9, 6, 3] = complex(0.047638602530, 0.035374690349)
    h2e[4, 9, 6, 3] = complex(-0.017344435981, -0.011686906310)
    h2e[6, 9, 6, 3] = complex(-0.000009318723, 0.000053538209)
    h2e[10, 9, 6, 3] = complex(-0.015473604261, -0.012371833716)
    h2e[0, 9, 8, 3] = complex(0.001203731071, -0.001752227822)
    h2e[2, 9, 8, 3] = complex(-0.035426833927, 0.051175233565)
    h2e[4, 9, 8, 3] = complex(0.011861319773, -0.018923297179)
    h2e[6, 9, 8, 3] = complex(-0.000053825564, -0.000009075109)
    h2e[10, 9, 8, 3] = complex(0.011355614155, -0.015200416645)
    h2e[0, 9, 10, 3] = complex(-0.000000265470, 0.000000493484)
    h2e[2, 9, 10, 3] = complex(0.000021854981, -0.000011026802)
    h2e[4, 9, 10, 3] = complex(-0.000007066417, 0.000003945855)
    h2e[6, 9, 10, 3] = complex(0.000000016562, 0.000000013242)
    h2e[10, 9, 10, 3] = complex(-0.000007187761, 0.000003479830)
    h2e[0, 11, 0, 3] = complex(-0.020370316775, -0.000044125368)
    h2e[2, 11, 0, 3] = complex(0.001063003865, -0.000052367341)
    h2e[4, 11, 0, 3] = complex(0.001554921454, -0.000144498624)
    h2e[6, 11, 0, 3] = complex(-0.000000898206, -0.000003677581)
    h2e[8, 11, 0, 3] = complex(-0.000000014217, 0.000000028423)
    h2e[0, 11, 4, 3] = complex(-0.000992499249, 0.000077906342)
    h2e[2, 11, 4, 3] = complex(-0.000052022989, 0.000006790646)
    h2e[4, 11, 4, 3] = complex(0.001908856428, -0.000333883878)
    h2e[6, 11, 4, 3] = complex(0.000020169380, 0.000037481877)
    h2e[8, 11, 4, 3] = complex(-0.000043522312, 0.000026029349)
    h2e[0, 11, 6, 3] = complex(-0.000001823537, 0.000005556626)
    h2e[2, 11, 6, 3] = complex(0.000011065842, 0.000019455313)
    h2e[4, 11, 6, 3] = complex(0.000024100875, 0.000025252034)
    h2e[6, 11, 6, 3] = complex(-0.011950697685, 0.014646578377)
    h2e[8, 11, 6, 3] = complex(-0.015834555454, -0.011906366048)
    h2e[0, 11, 8, 3] = complex(0.000000414313, -0.000000828287)
    h2e[2, 11, 8, 3] = complex(-0.000021517517, 0.000011671633)
    h2e[4, 11, 8, 3] = complex(-0.000036196519, 0.000021648019)
    h2e[6, 11, 8, 3] = complex(-0.015834540607, -0.011906354919)
    h2e[8, 11, 8, 3] = complex(0.010898716972, -0.015531278371)
    h2e[0, 11, 10, 3] = complex(-0.003083426121, 0.000032393861)
    h2e[2, 11, 10, 3] = complex(-0.008126074201, 0.000503609992)
    h2e[4, 11, 10, 3] = complex(-0.005934601483, 0.000627446598)
    h2e[6, 11, 10, 3] = complex(0.000008614638, 0.000026482441)
    h2e[8, 11, 10, 3] = complex(-0.000007081135, 0.000003691970)
    h2e[2, 1, 0, 5] = complex(0.020838334307, 0.001202429685)
    h2e[4, 1, 0, 5] = complex(-0.020934737673, -0.000244645639)
    h2e[6, 1, 0, 5] = complex(0.000029241785, 0.000075287616)
    h2e[8, 1, 0, 5] = complex(0.000019743499, -0.000007343761)
    h2e[10, 1, 0, 5] = complex(0.002979012409, 0.000287940955)
    h2e[2, 1, 2, 5] = complex(0.000467334826, 0.000010793309)
    h2e[4, 1, 2, 5] = complex(0.000724920476, -0.000016576119)
    h2e[6, 1, 2, 5] = complex(-0.000000068543, -0.000008275670)
    h2e[8, 1, 2, 5] = complex(0.000013430494, -0.000008906723)
    h2e[10, 1, 2, 5] = complex(-0.000993651062, -0.000061495736)
    h2e[2, 1, 6, 5] = complex(-0.000000489979, 0.000000233017)
    h2e[4, 1, 6, 5] = complex(0.000000013908, -0.000001624242)
    h2e[6, 1, 6, 5] = complex(0.000399405472, -0.000432412128)
    h2e[8, 1, 6, 5] = complex(0.002225902655, 0.001981712760)
    h2e[10, 1, 6, 5] = complex(-0.000001268407, 0.000001601602)
    h2e[2, 1, 8, 5] = complex(0.000000134401, -0.000000089131)
    h2e[4, 1, 8, 5] = complex(0.000005815373, -0.000004087664)
    h2e[6, 1, 8, 5] = complex(0.002224874527, 0.001980797461)
    h2e[8, 1, 8, 5] = complex(-0.000368501403, 0.000462038291)
    h2e[10, 1, 8, 5] = complex(0.000000407943, -0.000000432702)
    h2e[2, 1, 10, 5] = complex(0.001559861204, 0.000074118855)
    h2e[4, 1, 10, 5] = complex(0.001307059596, 0.000001996369)
    h2e[6, 1, 10, 5] = complex(-0.000000211311, 0.000001687600)
    h2e[8, 1, 10, 5] = complex(-0.000001188773, 0.000001260923)
    h2e[10, 1, 10, 5] = complex(-0.002455374632, -0.000212176443)
    h2e[0, 3, 0, 5] = complex(0.020872996322, 0.000006193553)
    h2e[4, 3, 0, 5] = complex(-0.000722779000, 0.000058094584)
    h2e[6, 3, 0, 5] = complex(0.000003389465, 0.000005619860)
    h2e[8, 3, 0, 5] = complex(-0.000011618473, 0.000008703332)
    h2e[10, 3, 0, 5] = complex(-0.004375251837, 0.000054145894)
    h2e[0, 3, 2, 5] = complex(0.000467185282, -0.000016007723)
    h2e[4, 3, 2, 5] = complex(0.000413736578, -0.000047707274)
    h2e[6, 3, 2, 5] = complex(-0.000069872953, -0.000147148493)
    h2e[8, 3, 2, 5] = complex(0.000138452701, -0.000069517680)
    h2e[10, 3, 2, 5] = complex(0.000052406389, -0.000002464684)
    h2e[0, 3, 6, 5] = complex(-0.000000475820, 0.000000260715)
    h2e[4, 3, 6, 5] = complex(-0.000029138109, -0.000051714034)
    h2e[6, 3, 6, 5] = complex(0.014085822356, -0.017225184595)
    h2e[8, 3, 6, 5] = complex(0.016700199957, 0.012590571550)
    h2e[10, 3, 6, 5] = complex(0.000002425764, -0.000010042117)
    h2e[0, 3, 8, 5] = complex(0.000000129072, -0.000000096687)
    h2e[4, 3, 8, 5] = complex(0.000049004710, -0.000027130265)
    h2e[6, 3, 8, 5] = complex(0.016700086726, 0.012590486191)
    h2e[8, 3, 8, 5] = complex(-0.012848404606, 0.018267473345)
    h2e[10, 3, 8, 5] = complex(0.000007265774, -0.000003565463)
    h2e[0, 3, 10, 5] = complex(0.001561545206, -0.000015399727)
    h2e[4, 3, 10, 5] = complex(0.001929931147, -0.000174863006)
    h2e[6, 3, 10, 5] = complex(0.000021929767, 0.000027158843)
    h2e[8, 3, 10, 5] = complex(-0.000037862960, 0.000018580122)
    h2e[10, 3, 10, 5] = complex(-0.005966163293, 0.000134460219)
    h2e[0, 5, 0, 5] = complex(0.020936167087, 0.000000786105)
    h2e[2, 5, 0, 5] = complex(-0.000724678224, 0.000025018699)
    h2e[6, 5, 0, 5] = complex(0.000000005012, 0.000001624294)
    h2e[8, 5, 0, 5] = complex(-0.000005767367, 0.000004155123)
    h2e[10, 5, 0, 5] = complex(-0.001306994181, 0.000013228091)
    h2e[0, 5, 2, 5] = complex(-0.000724678224, 0.000025018699)
    h2e[2, 5, 2, 5] = complex(0.000415483905, -0.000028758734)
    h2e[6, 5, 2, 5] = complex(-0.000026745490, -0.000052991032)
    h2e[8, 5, 2, 5] = complex(0.000050192821, -0.000024863499)
    h2e[10, 5, 2, 5] = complex(0.001935904125, -0.000086524698)
    h2e[0, 5, 6, 5] = complex(0.000000005012, 0.000001624294)
    h2e[2, 5, 6, 5] = complex(-0.000026745490, -0.000052991032)
    h2e[6, 5, 6, 5] = complex(0.014448989700, -0.017672279867)
    h2e[8, 5, 6, 5] = complex(0.016712577216, 0.012601565293)
    h2e[10, 5, 6, 5] = complex(-0.000010262893, -0.000009307274)
    h2e[0, 5, 8, 5] = complex(-0.000005767367, 0.000004155123)
    h2e[2, 5, 8, 5] = complex(0.000050192821, -0.000024863499)
    h2e[6, 5, 8, 5] = complex(0.016712577216, 0.012601565293)
    h2e[8, 5, 8, 5] = complex(-0.013180023609, 0.018742251655)
    h2e[10, 5, 8, 5] = complex(0.000012795369, -0.000006217734)
    h2e[0, 5, 10, 5] = complex(-0.001306994181, 0.000013228091)
    h2e[2, 5, 10, 5] = complex(0.001935904125, -0.000086524698)
    h2e[6, 5, 10, 5] = complex(-0.000010262893, -0.000009307274)
    h2e[8, 5, 10, 5] = complex(0.000012795369, -0.000006217734)
    h2e[10, 5, 10, 5] = complex(0.017057011657, -0.000345952903)
    h2e[0, 7, 0, 5] = complex(-0.000080763514, -0.000000749622)
    h2e[2, 7, 0, 5] = complex(0.000006526300, -0.000000691892)
    h2e[4, 7, 0, 5] = complex(-0.000001503372, -0.000000615003)
    h2e[8, 7, 0, 5] = complex(0.000000016582, -0.000000008290)
    h2e[10, 7, 0, 5] = complex(-0.000000305145, 0.000001951214)
    h2e[0, 7, 2, 5] = complex(0.000007711501, 0.000003004025)
    h2e[2, 7, 2, 5] = complex(-0.000162892228, 0.000001015179)
    h2e[4, 7, 2, 5] = complex(0.000059186565, -0.000004507897)
    h2e[8, 7, 2, 5] = complex(-0.000000127192, 0.000000067468)
    h2e[10, 7, 2, 5] = complex(0.000042549375, 0.000001116081)
    h2e[0, 7, 6, 5] = complex(0.000253551633, 0.000531240578)
    h2e[2, 7, 6, 5] = complex(-0.009643182132, -0.020053089883)
    h2e[4, 7, 6, 5] = complex(0.010823849282, 0.020097936844)
    h2e[8, 7, 6, 5] = complex(-0.000041708380, -0.000029216864)
    h2e[10, 7, 6, 5] = complex(-0.000840389464, -0.001928312084)
    h2e[0, 7, 8, 5] = complex(-0.002664413587, 0.001332113169)
    h2e[2, 7, 8, 5] = complex(0.018476057964, -0.009800434746)
    h2e[4, 7, 8, 5] = complex(-0.018024112655, 0.010641477712)
    h2e[8, 7, 8, 5] = complex(0.000091319927, -0.000128902496)
    h2e[10, 7, 8, 5] = complex(0.002017425217, -0.000981904583)
    h2e[0, 7, 10, 5] = complex(-0.000001489041, -0.000000821829)
    h2e[2, 7, 10, 5] = complex(0.000033888551, -0.000008371587)
    h2e[4, 7, 10, 5] = complex(0.000012518519, -0.000005936244)
    h2e[8, 7, 10, 5] = complex(-0.000000024406, 0.000000011878)
    h2e[10, 7, 10, 5] = complex(-0.000089668598, -0.000012916373)
    h2e[0, 9, 0, 5] = complex(-0.000019227226, 0.000008605252)
    h2e[2, 9, 0, 5] = complex(-0.000011553965, 0.000008788789)
    h2e[4, 9, 0, 5] = complex(0.000005538839, -0.000004455202)
    h2e[6, 9, 0, 5] = complex(-0.000000014615, -0.000000011406)
    h2e[10, 9, 0, 5] = complex(0.000001198593, -0.000001448598)
    h2e[0, 9, 2, 5] = complex(-0.000012826356, 0.000009756663)
    h2e[2, 9, 2, 5] = complex(0.000137936199, -0.000070536963)
    h2e[4, 9, 2, 5] = complex(-0.000048803275, 0.000027490966)
    h2e[6, 9, 2, 5] = complex(0.000000115602, 0.000000085825)
    h2e[10, 9, 2, 5] = complex(-0.000045360009, 0.000022675718)
    h2e[0, 9, 6, 5] = complex(-0.002349405398, -0.001833609104)
    h2e[2, 9, 6, 5] = complex(0.016792608934, 0.012467054792)
    h2e[4, 9, 6, 5] = complex(-0.017357496575, -0.011697307258)
    h2e[6, 9, 6, 5] = complex(-0.000008444537, 0.000050218561)
    h2e[10, 9, 6, 5] = complex(0.001754061203, 0.001399306776)
    h2e[0, 9, 8, 5] = complex(0.000337848718, -0.000484902985)
    h2e[2, 9, 8, 5] = complex(-0.012713321220, 0.018361741380)
    h2e[4, 9, 8, 5] = complex(0.012167287340, -0.019414997755)
    h2e[6, 9, 8, 5] = complex(-0.000155643761, -0.000027022259)
    h2e[10, 9, 8, 5] = complex(-0.001266337346, 0.001690826609)
    h2e[0, 9, 10, 5] = complex(0.000001104737, -0.000001335164)
    h2e[2, 9, 10, 5] = complex(-0.000037724888, 0.000018858880)
    h2e[4, 9, 10, 5] = complex(-0.000012447534, 0.000006887709)
    h2e[6, 9, 10, 5] = complex(0.000000021218, 0.000000016927)
    h2e[10, 9, 10, 5] = complex(0.000033280015, -0.000015988316)
    h2e[0, 11, 0, 5] = complex(0.002992890300, 0.000005707356)
    h2e[2, 11, 0, 5] = complex(0.004370231011, -0.000216428575)
    h2e[4, 11, 0, 5] = complex(-0.001301422168, 0.000121281124)
    h2e[6, 11, 0, 5] = complex(-0.000001875252, 0.000000619501)
    h2e[8, 11, 0, 5] = complex(0.000001155000, -0.000001483589)
    h2e[0, 11, 2, 5] = complex(-0.000995021906, 0.000032489441)
    h2e[2, 11, 2, 5] = complex(-0.000052278873, 0.000004407241)
    h2e[4, 11, 2, 5] = complex(0.001922115191, -0.000246342240)
    h2e[6, 11, 2, 5] = complex(0.000018436222, 0.000038364055)
    h2e[8, 11, 2, 5] = complex(-0.000044665857, 0.000024014159)
    h2e[0, 11, 6, 5] = complex(-0.000001111706, 0.000001714087)
    h2e[2, 11, 6, 5] = complex(-0.000002051535, 0.000010125199)
    h2e[4, 11, 6, 5] = complex(-0.000010997513, -0.000008426566)
    h2e[6, 11, 6, 5] = complex(0.001331795967, -0.001628177340)
    h2e[8, 11, 6, 5] = complex(0.001794884574, 0.001346543549)
    h2e[0, 11, 8, 5] = complex(0.000000365317, -0.000000469247)
    h2e[2, 11, 8, 5] = complex(-0.000007128495, 0.000003832566)
    h2e[4, 11, 8, 5] = complex(0.000012237276, -0.000007254706)
    h2e[6, 11, 8, 5] = complex(0.001794768876, 0.001346456756)
    h2e[8, 11, 8, 5] = complex(-0.001215512730, 0.001727725008)
    h2e[0, 11, 10, 5] = complex(-0.002464441093, 0.000020335266)
    h2e[2, 11, 10, 5] = complex(0.005957067615, -0.000355709739)
    h2e[4, 11, 10, 5] = complex(0.016969958962, -0.001755512150)
    h2e[6, 11, 10, 5] = complex(-0.000029453852, -0.000085672404)
    h2e[8, 11, 10, 5] = complex(0.000032790001, -0.000016970599)
    h2e[2, 1, 0, 7] = complex(-0.000054689397, -0.000003818881)
    h2e[4, 1, 0, 7] = complex(0.000080749304, 0.000001690284)
    h2e[6, 1, 0, 7] = complex(0.003972306885, 0.010194043773)
    h2e[8, 1, 0, 7] = complex(0.008243006861, -0.003600040558)
    h2e[10, 1, 0, 7] = complex(-0.000000831713, -0.000000387749)
    h2e[2, 1, 2, 7] = complex(-0.000001406475, -0.000001901414)
    h2e[4, 1, 2, 7] = complex(-0.000006533915, 0.000000615828)
    h2e[6, 1, 2, 7] = complex(-0.000813938176, -0.001954705504)
    h2e[8, 1, 2, 7] = complex(0.005594526118, -0.002376676749)
    h2e[10, 1, 2, 7] = complex(0.000003865679, 0.000004388383)
    h2e[2, 1, 4, 7] = complex(-0.000000028478, -0.000000541817)
    h2e[4, 1, 4, 7] = complex(0.000001496106, 0.000000632472)
    h2e[6, 1, 4, 7] = complex(0.000247346666, 0.000534157850)
    h2e[8, 1, 4, 7] = complex(-0.002680987283, 0.001301589514)
    h2e[10, 1, 4, 7] = complex(-0.000000996612, -0.000001783465)
    h2e[4, 1, 8, 7] = complex(-0.000000016677, 0.000000008097)
    h2e[6, 1, 8, 7] = complex(-0.000005093656, -0.000006188407)
    h2e[8, 1, 8, 7] = complex(-0.000000178217, -0.000001992680)
    h2e[10, 1, 8, 7] = complex(-0.000000001436, 0.000000000395)
    h2e[2, 1, 10, 7] = complex(-0.000003625441, -0.000001089750)
    h2e[4, 1, 10, 7] = complex(0.000000327851, -0.000001947528)
    h2e[6, 1, 10, 7] = complex(0.000765785669, 0.001944608854)
    h2e[8, 1, 10, 7] = complex(-0.000730908643, 0.000200893723)
    h2e[10, 1, 10, 7] = complex(0.000007404602, 0.000002139735)
    h2e[0, 3, 0, 7] = complex(-0.000054818371, -0.000000678316)
    h2e[4, 3, 0, 7] = complex(0.000007840669, 0.000002648642)
    h2e[6, 3, 0, 7] = complex(0.000924625946, 0.001904845354)
    h2e[8, 3, 0, 7] = complex(-0.005446713585, 0.002692206339)
    h2e[10, 3, 0, 7] = complex(0.000013483851, 0.000000369886)
    h2e[0, 3, 2, 7] = complex(-0.000001513135, -0.000001817683)
    h2e[4, 3, 2, 7] = complex(-0.000162675831, 0.000008454745)
    h2e[6, 3, 2, 7] = complex(-0.026878451331, -0.055882757824)
    h2e[8, 3, 2, 7] = complex(0.052421165776, -0.027799758101)
    h2e[10, 3, 2, 7] = complex(-0.000022361542, 0.000000961021)
    h2e[0, 3, 4, 7] = complex(-0.000000059484, -0.000000539294)
    h2e[4, 3, 4, 7] = complex(0.000058918874, -0.000007206728)
    h2e[6, 3, 4, 7] = complex(0.010549105757, 0.019591675352)
    h2e[8, 3, 4, 7] = complex(-0.018009228615, 0.010634230346)
    h2e[10, 3, 4, 7] = complex(0.000008357323, 0.000006073188)
    h2e[4, 3, 8, 7] = complex(-0.000000123978, 0.000000073207)
    h2e[6, 3, 8, 7] = complex(-0.000044329611, -0.000031433484)
    h2e[8, 3, 8, 7] = complex(0.000031337095, -0.000044693796)
    h2e[10, 3, 8, 7] = complex(-0.000000019077, 0.000000009259)
    h2e[0, 3, 10, 7] = complex(-0.000003681936, -0.000000880183)
    h2e[4, 3, 10, 7] = complex(0.000042555943, -0.000000828664)
    h2e[6, 3, 10, 7] = complex(0.007573456544, 0.017320051648)
    h2e[8, 3, 10, 7] = complex(-0.017823056212, 0.008650585584)
    h2e[10, 3, 10, 7] = complex(0.000027494003, 0.000004428484)
    h2e[0, 5, 0, 7] = complex(-0.000080763514, -0.000000749622)
    h2e[2, 5, 0, 7] = complex(0.000007711501, 0.000003004025)
    h2e[6, 5, 0, 7] = complex(0.000253551633, 0.000531240578)
    h2e[8, 5, 0, 7] = complex(-0.002664413587, 0.001332113169)
    h2e[10, 5, 0, 7] = complex(-0.000001489041, -0.000000821829)
    h2e[0, 5, 2, 7] = complex(0.000006526300, -0.000000691892)
    h2e[2, 5, 2, 7] = complex(-0.000162892228, 0.000001015179)
    h2e[6, 5, 2, 7] = complex(-0.009643182132, -0.020053089883)
    h2e[8, 5, 2, 7] = complex(0.018476057964, -0.009800434746)
    h2e[10, 5, 2, 7] = complex(0.000033888551, -0.000008371587)
    h2e[0, 5, 4, 7] = complex(-0.000001503372, -0.000000615003)
    h2e[2, 5, 4, 7] = complex(0.000059186565, -0.000004507897)
    h2e[6, 5, 4, 7] = complex(0.010823849282, 0.020097936844)
    h2e[8, 5, 4, 7] = complex(-0.018024112655, 0.010641477712)
    h2e[10, 5, 4, 7] = complex(0.000012518519, -0.000005936244)
    h2e[0, 5, 8, 7] = complex(0.000000016582, -0.000000008290)
    h2e[2, 5, 8, 7] = complex(-0.000000127192, 0.000000067468)
    h2e[6, 5, 8, 7] = complex(-0.000041708380, -0.000029216864)
    h2e[8, 5, 8, 7] = complex(0.000091319927, -0.000128902496)
    h2e[10, 5, 8, 7] = complex(-0.000000024406, 0.000000011878)
    h2e[0, 5, 10, 7] = complex(-0.000000305145, 0.000001951214)
    h2e[2, 5, 10, 7] = complex(0.000042549375, 0.000001116081)
    h2e[6, 5, 10, 7] = complex(-0.000840389464, -0.001928312084)
    h2e[8, 5, 10, 7] = complex(0.002017425217, -0.000981904583)
    h2e[10, 5, 10, 7] = complex(-0.000089668598, -0.000012916373)
    h2e[0, 7, 0, 7] = complex(-0.010940280704, -0.000089491047)
    h2e[2, 7, 0, 7] = complex(0.002117164400, -0.000031367074)
    h2e[4, 7, 0, 7] = complex(-0.000587791500, 0.000031719664)
    h2e[8, 7, 0, 7] = complex(0.000007635684, -0.000002436809)
    h2e[10, 7, 0, 7] = complex(-0.002089937535, -0.000009612277)
    h2e[0, 7, 2, 7] = complex(0.002117164400, -0.000031367074)
    h2e[2, 7, 2, 7] = complex(-0.062006848847, 0.000696032830)
    h2e[4, 7, 2, 7] = complex(0.022215298088, -0.001264083045)
    h2e[8, 7, 2, 7] = complex(-0.000047243304, 0.000026856073)
    h2e[10, 7, 2, 7] = complex(0.018897627408, 0.000470224783)
    h2e[0, 7, 4, 7] = complex(-0.000587791500, 0.000031719664)
    h2e[2, 7, 4, 7] = complex(0.022215298088, -0.001264083045)
    h2e[4, 7, 4, 7] = complex(-0.022707154540, 0.002338356469)
    h2e[8, 7, 4, 7] = complex(0.000042918314, -0.000027408622)
    h2e[10, 7, 4, 7] = complex(0.002103079293, -0.000041224194)
    h2e[0, 7, 8, 7] = complex(0.000007635684, -0.000002436809)
    h2e[2, 7, 8, 7] = complex(-0.000047243304, 0.000026856073)
    h2e[4, 7, 8, 7] = complex(0.000042918314, -0.000027408622)
    h2e[8, 7, 8, 7] = complex(0.023332339812, -0.032602705329)
    h2e[10, 7, 8, 7] = complex(-0.000002343958, 0.000001146401)
    h2e[0, 7, 10, 7] = complex(-0.002089937535, -0.000009612277)
    h2e[2, 7, 10, 7] = complex(0.018897627408, 0.000470224783)
    h2e[4, 7, 10, 7] = complex(0.002103079293, -0.000041224194)
    h2e[8, 7, 10, 7] = complex(-0.000002343958, 0.000001146401)
    h2e[10, 7, 10, 7] = complex(-0.014730929481, -0.000800842829)
    h2e[0, 9, 0, 7] = complex(-0.007992926276, 0.004125601022)
    h2e[2, 9, 0, 7] = complex(-0.005426708746, 0.002732306004)
    h2e[4, 9, 0, 7] = complex(0.002590000654, -0.001471571230)
    h2e[6, 9, 0, 7] = complex(-0.000005483213, -0.000005846032)
    h2e[10, 9, 0, 7] = complex(0.000716050824, -0.000247626999)
    h2e[0, 9, 2, 7] = complex(-0.005429108194, 0.002733514035)
    h2e[2, 9, 2, 7] = complex(0.052214699497, -0.028185640385)
    h2e[4, 9, 2, 7] = complex(-0.017930183167, 0.010766697272)
    h2e[6, 9, 2, 7] = complex(0.000044560246, 0.000031105672)
    h2e[10, 9, 2, 7] = complex(-0.017758784636, 0.008781814528)
    h2e[0, 9, 4, 7] = complex(0.002591197491, -0.001472251208)
    h2e[2, 9, 4, 7] = complex(-0.017930304735, 0.010766770264)
    h2e[4, 9, 4, 7] = complex(0.017434261115, -0.011582582772)
    h2e[6, 9, 4, 7] = complex(-0.000043199466, -0.000026963314)
    h2e[10, 9, 4, 7] = complex(-0.001962626440, 0.001087606368)
    h2e[0, 9, 8, 7] = complex(0.000000306716, 0.000001976983)
    h2e[2, 9, 8, 7] = complex(0.000031006598, -0.000044923711)
    h2e[4, 9, 8, 7] = complex(-0.000084353742, 0.000133565074)
    h2e[6, 9, 8, 7] = complex(-0.039467386357, -0.007046977365)
    h2e[10, 9, 8, 7] = complex(-0.000007207274, 0.000010222981)
    h2e[0, 9, 10, 7] = complex(0.000716386179, -0.000247742951)
    h2e[2, 9, 10, 7] = complex(-0.017758768000, 0.008781806332)
    h2e[4, 9, 10, 7] = complex(-0.001962499932, 0.001087536267)
    h2e[6, 9, 10, 7] = complex(0.000002042864, 0.000001623294)
    h2e[10, 9, 10, 7] = complex(0.012942097634, -0.005730900866)
    h2e[0, 11, 0, 7] = complex(-0.000000864575, -0.000000307582)
    h2e[2, 11, 0, 7] = complex(-0.000013488292, 0.000000130614)
    h2e[4, 11, 0, 7] = complex(-0.000001551911, -0.000000695858)
    h2e[6, 11, 0, 7] = complex(-0.000945768252, -0.001863720392)
    h2e[8, 11, 0, 7] = complex(0.000708372893, -0.000268804314)
    h2e[0, 11, 2, 7] = complex(0.000004262317, 0.000004004252)
    h2e[2, 11, 2, 7] = complex(0.000022310493, -0.000001789963)
    h2e[4, 11, 2, 7] = complex(0.000033080050, -0.000011145746)
    h2e[6, 11, 2, 7] = complex(0.008210809229, 0.017027156104)
    h2e[8, 11, 2, 7] = complex(-0.017489869738, 0.009305866711)
    h2e[0, 11, 4, 7] = complex(-0.000001160368, -0.000001681526)
    h2e[2, 11, 4, 7] = complex(-0.000008576882, -0.000005758953)
    h2e[4, 11, 4, 7] = complex(0.000011984656, -0.000006951282)
    h2e[6, 11, 4, 7] = complex(0.000996996238, 0.001852198814)
    h2e[8, 11, 4, 7] = complex(-0.001929426624, 0.001145470674)
    h2e[0, 11, 8, 7] = complex(-0.000000001392, 0.000000000528)
    h2e[2, 11, 8, 7] = complex(0.000000018720, -0.000000009960)
    h2e[4, 11, 8, 7] = complex(-0.000000023340, 0.000000013856)
    h2e[6, 11, 8, 7] = complex(-0.000002090218, -0.000001561846)
    h2e[8, 11, 8, 7] = complex(-0.000006900180, 0.000010432720)
    h2e[0, 11, 10, 7] = complex(0.000007573397, 0.000001431871)
    h2e[2, 11, 10, 7] = complex(-0.000027639370, -0.000003405420)
    h2e[4, 11, 10, 7] = complex(-0.000090429663, -0.000005455844)
    h2e[6, 11, 10, 7] = complex(-0.006014049206, -0.013471185722)
    h2e[8, 11, 10, 7] = complex(0.012766009221, -0.006113110890)
    h2e[2, 1, 0, 9] = complex(0.000000388681, -0.000000151147)
    h2e[4, 1, 0, 9] = complex(0.000019326154, -0.000008380715)
    h2e[6, 1, 0, 9] = complex(0.006794559706, 0.005894184645)
    h2e[8, 1, 0, 9] = complex(0.006931380489, -0.008531871577)
    h2e[10, 1, 0, 9] = complex(0.000006739549, -0.000002606944)
    h2e[2, 1, 2, 9] = complex(0.000000262583, -0.000000185967)
    h2e[4, 1, 2, 9] = complex(0.000011655550, -0.000008653615)
    h2e[6, 1, 2, 9] = complex(0.004549262017, 0.004027266932)
    h2e[8, 1, 2, 9] = complex(-0.001302174034, 0.001680361157)
    h2e[10, 1, 2, 9] = complex(0.000000484774, -0.000000789118)
    h2e[2, 1, 4, 9] = complex(-0.000000129484, 0.000000096135)
    h2e[4, 1, 4, 9] = complex(-0.000005590356, 0.000004390385)
    h2e[6, 1, 4, 9] = complex(-0.002326813360, -0.001859990550)
    h2e[8, 1, 4, 9] = complex(0.000343473836, -0.000480934907)
    h2e[10, 1, 4, 9] = complex(-0.000000384416, 0.000000453732)
    h2e[4, 1, 6, 9] = complex(0.000000014481, 0.000000011576)
    h2e[6, 1, 6, 9] = complex(-0.000003396991, 0.000007259626)
    h2e[8, 1, 6, 9] = complex(-0.000001722442, 0.000001017707)
    h2e[10, 1, 6, 9] = complex(0.000000000973, 0.000000001126)
    h2e[2, 1, 10, 9] = complex(-0.000000016635, 0.000000027079)
    h2e[4, 1, 10, 9] = complex(-0.000001215385, 0.000001434539)
    h2e[6, 1, 10, 9] = complex(-0.000495416382, -0.000573245604)
    h2e[8, 1, 10, 9] = complex(0.001317221292, -0.001633294011)
    h2e[10, 1, 10, 9] = complex(0.000000583283, -0.000000057324)
    h2e[0, 3, 0, 9] = complex(0.000000379380, -0.000000173174)
    h2e[4, 3, 0, 9] = complex(-0.000012367302, 0.000010332364)
    h2e[6, 3, 0, 9] = complex(-0.004774700558, -0.003761588684)
    h2e[8, 3, 0, 9] = complex(0.001203731071, -0.001752227822)
    h2e[10, 3, 0, 9] = complex(-0.000000265470, 0.000000493484)
    h2e[0, 3, 2, 9] = complex(0.000000251494, -0.000000200711)
    h2e[4, 3, 2, 9] = complex(0.000134570219, -0.000076764016)
    h2e[6, 3, 2, 9] = complex(0.047638602530, 0.035374690349)
    h2e[8, 3, 2, 9] = complex(-0.035426833927, 0.051175233565)
    h2e[10, 3, 2, 9] = complex(0.000021854981, -0.000011026802)
    h2e[0, 3, 4, 9] = complex(-0.000000123761, 0.000000103398)
    h2e[4, 3, 4, 9] = complex(-0.000047496596, 0.000029691518)
    h2e[6, 3, 4, 9] = complex(-0.017344435981, -0.011686906310)
    h2e[8, 3, 4, 9] = complex(0.011861319773, -0.018923297179)
    h2e[10, 3, 4, 9] = complex(-0.000007066417, 0.000003945855)
    h2e[4, 3, 6, 9] = complex(0.000000119402, 0.000000080455)
    h2e[6, 3, 6, 9] = complex(-0.000009318723, 0.000053538209)
    h2e[8, 3, 6, 9] = complex(-0.000053825564, -0.000009075109)
    h2e[10, 3, 6, 9] = complex(0.000000016562, 0.000000013242)
    h2e[0, 3, 10, 9] = complex(-0.000000015056, 0.000000027988)
    h2e[4, 3, 10, 9] = complex(-0.000044276876, 0.000024724013)
    h2e[6, 3, 10, 9] = complex(-0.015473604261, -0.012371833716)
    h2e[8, 3, 10, 9] = complex(0.011355614155, -0.015200416645)
    h2e[10, 3, 10, 9] = complex(-0.000007187761, 0.000003479830)
    h2e[0, 5, 0, 9] = complex(-0.000019227226, 0.000008605252)
    h2e[2, 5, 0, 9] = complex(-0.000012826356, 0.000009756663)
    h2e[6, 5, 0, 9] = complex(-0.002349405398, -0.001833609104)
    h2e[8, 5, 0, 9] = complex(0.000337848718, -0.000484902985)
    h2e[10, 5, 0, 9] = complex(0.000001104737, -0.000001335164)
    h2e[0, 5, 2, 9] = complex(-0.000011553965, 0.000008788789)
    h2e[2, 5, 2, 9] = complex(0.000137936199, -0.000070536963)
    h2e[6, 5, 2, 9] = complex(0.016792608934, 0.012467054792)
    h2e[8, 5, 2, 9] = complex(-0.012713321220, 0.018361741380)
    h2e[10, 5, 2, 9] = complex(-0.000037724888, 0.000018858880)
    h2e[0, 5, 4, 9] = complex(0.000005538839, -0.000004455202)
    h2e[2, 5, 4, 9] = complex(-0.000048803275, 0.000027490966)
    h2e[6, 5, 4, 9] = complex(-0.017357496575, -0.011697307258)
    h2e[8, 5, 4, 9] = complex(0.012167287340, -0.019414997755)
    h2e[10, 5, 4, 9] = complex(-0.000012447534, 0.000006887709)
    h2e[0, 5, 6, 9] = complex(-0.000000014615, -0.000000011406)
    h2e[2, 5, 6, 9] = complex(0.000000115602, 0.000000085825)
    h2e[6, 5, 6, 9] = complex(-0.000008444537, 0.000050218561)
    h2e[8, 5, 6, 9] = complex(-0.000155643761, -0.000027022259)
    h2e[10, 5, 6, 9] = complex(0.000000021218, 0.000000016927)
    h2e[0, 5, 10, 9] = complex(0.000001198593, -0.000001448598)
    h2e[2, 5, 10, 9] = complex(-0.000045360009, 0.000022675718)
    h2e[6, 5, 10, 9] = complex(0.001754061203, 0.001399306776)
    h2e[8, 5, 10, 9] = complex(-0.001266337346, 0.001690826609)
    h2e[10, 5, 10, 9] = complex(0.000033280015, -0.000015988316)
    h2e[0, 7, 0, 9] = complex(-0.007992926276, 0.004125601022)
    h2e[2, 7, 0, 9] = complex(-0.005429108194, 0.002733514035)
    h2e[4, 7, 0, 9] = complex(0.002591197491, -0.001472251208)
    h2e[8, 7, 0, 9] = complex(0.000000306716, 0.000001976983)
    h2e[10, 7, 0, 9] = complex(0.000716386179, -0.000247742951)
    h2e[0, 7, 2, 9] = complex(-0.005426708746, 0.002732306004)
    h2e[2, 7, 2, 9] = complex(0.052214699497, -0.028185640385)
    h2e[4, 7, 2, 9] = complex(-0.017930304735, 0.010766770264)
    h2e[8, 7, 2, 9] = complex(0.000031006598, -0.000044923711)
    h2e[10, 7, 2, 9] = complex(-0.017758768000, 0.008781806332)
    h2e[0, 7, 4, 9] = complex(0.002590000654, -0.001471571230)
    h2e[2, 7, 4, 9] = complex(-0.017930183167, 0.010766697272)
    h2e[4, 7, 4, 9] = complex(0.017434261115, -0.011582582772)
    h2e[8, 7, 4, 9] = complex(-0.000084353742, 0.000133565074)
    h2e[10, 7, 4, 9] = complex(-0.001962499932, 0.001087536267)
    h2e[0, 7, 6, 9] = complex(-0.000005483213, -0.000005846032)
    h2e[2, 7, 6, 9] = complex(0.000044560246, 0.000031105672)
    h2e[4, 7, 6, 9] = complex(-0.000043199466, -0.000026963314)
    h2e[8, 7, 6, 9] = complex(-0.039467386357, -0.007046977365)
    h2e[10, 7, 6, 9] = complex(0.000002042864, 0.000001623294)
    h2e[0, 7, 10, 9] = complex(0.000716050824, -0.000247626999)
    h2e[2, 7, 10, 9] = complex(-0.017758784636, 0.008781814528)
    h2e[4, 7, 10, 9] = complex(-0.001962626440, 0.001087606368)
    h2e[8, 7, 10, 9] = complex(-0.000007207274, 0.000010222981)
    h2e[10, 7, 10, 9] = complex(0.012942097634, -0.005730900866)
    h2e[0, 9, 0, 9] = complex(-0.006365091207, 0.008962281075)
    h2e[2, 9, 0, 9] = complex(0.001190774575, -0.001761058404)
    h2e[4, 9, 0, 9] = complex(-0.000311651451, 0.000502141443)
    h2e[6, 9, 0, 9] = complex(0.000001653018, -0.000001126972)
    h2e[10, 9, 0, 9] = complex(-0.001208834294, 0.001715062943)
    h2e[0, 9, 2, 9] = complex(0.001190774575, -0.001761058404)
    h2e[2, 9, 2, 9] = complex(-0.035048421334, 0.051435136350)
    h2e[4, 9, 2, 9] = complex(0.011721426130, -0.019010267015)
    h2e[6, 9, 2, 9] = complex(-0.000053891035, -0.000008677865)
    h2e[10, 9, 2, 9] = complex(0.011243192816, -0.015283757846)
    h2e[0, 9, 4, 9] = complex(-0.000311651451, 0.000502141443)
    h2e[2, 9, 4, 9] = complex(0.011721426130, -0.019010267015)
    h2e[4, 9, 4, 9] = complex(-0.011120291137, 0.020033076241)
    h2e[6, 9, 4, 9] = complex(0.000156858028, 0.000018728109)
    h2e[10, 9, 4, 9] = complex(0.001174864812, -0.001755618856)
    h2e[0, 9, 6, 9] = complex(0.000001653018, -0.000001126972)
    h2e[2, 9, 6, 9] = complex(-0.000053891035, -0.000008677865)
    h2e[4, 9, 6, 9] = complex(0.000156858028, 0.000018728109)
    h2e[6, 9, 6, 9] = complex(0.010607752147, 0.038662773701)
    h2e[10, 9, 6, 9] = complex(0.000012328675, 0.000002111376)
    h2e[0, 9, 10, 9] = complex(-0.001208834294, 0.001715062943)
    h2e[2, 9, 10, 9] = complex(0.011243192816, -0.015283757846)
    h2e[4, 9, 10, 9] = complex(0.001174864812, -0.001755618856)
    h2e[6, 9, 10, 9] = complex(0.000012328675, 0.000002111376)
    h2e[10, 9, 10, 9] = complex(-0.009122454828, 0.011665264023)
    h2e[0, 11, 0, 9] = complex(0.000006463649, -0.000003230930)
    h2e[2, 11, 0, 9] = complex(0.000000246979, -0.000000502994)
    h2e[4, 11, 0, 9] = complex(0.000000990524, -0.000001421960)
    h2e[6, 11, 0, 9] = complex(0.000547527271, 0.000524213334)
    h2e[8, 11, 0, 9] = complex(-0.001157314582, 0.001750241189)
    h2e[0, 11, 2, 9] = complex(0.000000408192, -0.000000831320)
    h2e[2, 11, 2, 9] = complex(-0.000021430846, 0.000011830021)
    h2e[4, 11, 2, 9] = complex(-0.000036035864, 0.000021914402)
    h2e[6, 11, 2, 9] = complex(-0.015921926619, -0.011789241540)
    h2e[8, 11, 2, 9] = complex(0.010783867752, -0.015611240673)
    h2e[0, 11, 4, 9] = complex(-0.000000339911, 0.000000487964)
    h2e[2, 11, 4, 9] = complex(0.000006915163, -0.000004205300)
    h2e[4, 11, 4, 9] = complex(-0.000011835221, 0.000007893617)
    h2e[6, 11, 4, 9] = complex(-0.001863664711, -0.001249357819)
    h2e[8, 11, 4, 9] = complex(0.001122154479, -0.001789769321)
    h2e[0, 11, 6, 9] = complex(0.000000001075, 0.000000001030)
    h2e[2, 11, 6, 9] = complex(-0.000000017042, -0.000000012618)
    h2e[4, 11, 6, 9] = complex(0.000000022545, 0.000000015114)
    h2e[6, 11, 6, 9] = complex(-0.000000511353, 0.000002558690)
    h2e[8, 11, 6, 9] = complex(0.000012385993, 0.000001743936)
    h2e[0, 11, 10, 9] = complex(0.000000575277, -0.000000112078)
    h2e[2, 11, 10, 9] = complex(0.000007053713, -0.000003744097)
    h2e[4, 11, 10, 9] = complex(0.000031843637, -0.000018686048)
    h2e[6, 11, 10, 9] = complex(0.011008244814, 0.008897171578)
    h2e[8, 11, 10, 9] = complex(-0.008771637720, 0.011931300800)
    h2e[2, 1, 0, 11] = complex(-0.020334307069, -0.001211490232)
    h2e[4, 1, 0, 11] = complex(-0.002992620792, -0.000040567456)
    h2e[6, 1, 0, 11] = complex(0.000000034817, 0.000000916997)
    h2e[8, 1, 0, 11] = complex(-0.000006659071, 0.000002806145)
    h2e[10, 1, 0, 11] = complex(0.019000371943, 0.001872368224)
    h2e[2, 1, 2, 11] = complex(0.001064257911, 0.000008640240)
    h2e[4, 1, 2, 11] = complex(-0.004372455455, 0.000165510463)
    h2e[6, 1, 2, 11] = complex(0.000005121246, 0.000012478939)
    h2e[8, 1, 2, 11] = complex(-0.000000278991, 0.000000485968)
    h2e[10, 1, 2, 11] = complex(0.003080214687, 0.000144372733)
    h2e[2, 1, 4, 11] = complex(0.001560647090, -0.000055147467)
    h2e[4, 1, 4, 11] = complex(0.001302746537, -0.000106114235)
    h2e[6, 1, 4, 11] = complex(-0.000000071010, 0.000001699295)
    h2e[8, 1, 4, 11] = complex(-0.000001080412, 0.000001354923)
    h2e[10, 1, 4, 11] = complex(-0.002464510772, -0.000008371348)
    h2e[2, 1, 6, 11] = complex(-0.000000685965, -0.000003723013)
    h2e[4, 1, 6, 11] = complex(0.000001882341, -0.000000597617)
    h2e[6, 1, 6, 11] = complex(-0.001380360568, 0.001569246945)
    h2e[8, 1, 6, 11] = complex(-0.000512478782, -0.000558525948)
    h2e[10, 1, 6, 11] = complex(0.000001477500, 0.000007564627)
    h2e[2, 1, 8, 11] = complex(-0.000000015823, 0.000000027561)
    h2e[4, 1, 8, 11] = complex(-0.000001172202, 0.000001470035)
    h2e[6, 1, 8, 11] = complex(-0.000512238867, -0.000558264507)
    h2e[8, 1, 8, 11] = complex(0.001268084505, -0.001671730528)
    h2e[10, 1, 8, 11] = complex(0.000000581322, -0.000000074639)
    h2e[0, 3, 0, 11] = complex(-0.020370316775, -0.000044125368)
    h2e[4, 3, 0, 11] = complex(-0.000992499249, 0.000077906342)
    h2e[6, 3, 0, 11] = complex(-0.000001823537, 0.000005556626)
    h2e[8, 3, 0, 11] = complex(0.000000414313, -0.000000828287)
    h2e[10, 3, 0, 11] = complex(-0.003083426121, 0.000032393861)
    h2e[0, 3, 2, 11] = complex(0.001063003865, -0.000052367341)
    h2e[4, 3, 2, 11] = complex(-0.000052022989, 0.000006790646)
    h2e[6, 3, 2, 11] = complex(0.000011065842, 0.000019455313)
    h2e[8, 3, 2, 11] = complex(-0.000021517517, 0.000011671633)
    h2e[10, 3, 2, 11] = complex(-0.008126074201, 0.000503609992)
    h2e[0, 3, 4, 11] = complex(0.001554921454, -0.000144498624)
    h2e[4, 3, 4, 11] = complex(0.001908856428, -0.000333883878)
    h2e[6, 3, 4, 11] = complex(0.000024100875, 0.000025252034)
    h2e[8, 3, 4, 11] = complex(-0.000036196519, 0.000021648019)
    h2e[10, 3, 4, 11] = complex(-0.005934601483, 0.000627446598)
    h2e[0, 3, 6, 11] = complex(-0.000000898206, -0.000003677581)
    h2e[4, 3, 6, 11] = complex(0.000020169380, 0.000037481877)
    h2e[6, 3, 6, 11] = complex(-0.011950697685, 0.014646578377)
    h2e[8, 3, 6, 11] = complex(-0.015834540607, -0.011906354919)
    h2e[10, 3, 6, 11] = complex(0.000008614638, 0.000026482441)
    h2e[0, 3, 8, 11] = complex(-0.000000014217, 0.000000028423)
    h2e[4, 3, 8, 11] = complex(-0.000043522312, 0.000026029349)
    h2e[6, 3, 8, 11] = complex(-0.015834555454, -0.011906366048)
    h2e[8, 3, 8, 11] = complex(0.010898716972, -0.015531278371)
    h2e[10, 3, 8, 11] = complex(-0.000007081135, 0.000003691970)
    h2e[0, 5, 0, 11] = complex(0.002992890300, 0.000005707356)
    h2e[2, 5, 0, 11] = complex(-0.000995021906, 0.000032489441)
    h2e[6, 5, 0, 11] = complex(-0.000001111706, 0.000001714087)
    h2e[8, 5, 0, 11] = complex(0.000000365317, -0.000000469247)
    h2e[10, 5, 0, 11] = complex(-0.002464441093, 0.000020335266)
    h2e[0, 5, 2, 11] = complex(0.004370231011, -0.000216428575)
    h2e[2, 5, 2, 11] = complex(-0.000052278873, 0.000004407241)
    h2e[6, 5, 2, 11] = complex(-0.000002051535, 0.000010125199)
    h2e[8, 5, 2, 11] = complex(-0.000007128495, 0.000003832566)
    h2e[10, 5, 2, 11] = complex(0.005957067615, -0.000355709739)
    h2e[0, 5, 4, 11] = complex(-0.001301422168, 0.000121281124)
    h2e[2, 5, 4, 11] = complex(0.001922115191, -0.000246342240)
    h2e[6, 5, 4, 11] = complex(-0.000010997513, -0.000008426566)
    h2e[8, 5, 4, 11] = complex(0.000012237276, -0.000007254706)
    h2e[10, 5, 4, 11] = complex(0.016969958962, -0.001755512150)
    h2e[0, 5, 6, 11] = complex(-0.000001875252, 0.000000619501)
    h2e[2, 5, 6, 11] = complex(0.000018436222, 0.000038364055)
    h2e[6, 5, 6, 11] = complex(0.001331795967, -0.001628177340)
    h2e[8, 5, 6, 11] = complex(0.001794768876, 0.001346456756)
    h2e[10, 5, 6, 11] = complex(-0.000029453852, -0.000085672404)
    h2e[0, 5, 8, 11] = complex(0.000001155000, -0.000001483589)
    h2e[2, 5, 8, 11] = complex(-0.000044665857, 0.000024014159)
    h2e[6, 5, 8, 11] = complex(0.001794884574, 0.001346543549)
    h2e[8, 5, 8, 11] = complex(-0.001215512730, 0.001727725008)
    h2e[10, 5, 8, 11] = complex(0.000032790001, -0.000016970599)
    h2e[0, 7, 0, 11] = complex(-0.000000864575, -0.000000307582)
    h2e[2, 7, 0, 11] = complex(0.000004262317, 0.000004004252)
    h2e[4, 7, 0, 11] = complex(-0.000001160368, -0.000001681526)
    h2e[8, 7, 0, 11] = complex(-0.000000001392, 0.000000000528)
    h2e[10, 7, 0, 11] = complex(0.000007573397, 0.000001431871)
    h2e[0, 7, 2, 11] = complex(-0.000013488292, 0.000000130614)
    h2e[2, 7, 2, 11] = complex(0.000022310493, -0.000001789963)
    h2e[4, 7, 2, 11] = complex(-0.000008576882, -0.000005758953)
    h2e[8, 7, 2, 11] = complex(0.000000018720, -0.000000009960)
    h2e[10, 7, 2, 11] = complex(-0.000027639370, -0.000003405420)
    h2e[0, 7, 4, 11] = complex(-0.000001551911, -0.000000695858)
    h2e[2, 7, 4, 11] = complex(0.000033080050, -0.000011145746)
    h2e[4, 7, 4, 11] = complex(0.000011984656, -0.000006951282)
    h2e[8, 7, 4, 11] = complex(-0.000000023340, 0.000000013856)
    h2e[10, 7, 4, 11] = complex(-0.000090429663, -0.000005455844)
    h2e[0, 7, 6, 11] = complex(-0.000945768252, -0.001863720392)
    h2e[2, 7, 6, 11] = complex(0.008210809229, 0.017027156104)
    h2e[4, 7, 6, 11] = complex(0.000996996238, 0.001852198814)
    h2e[8, 7, 6, 11] = complex(-0.000002090218, -0.000001561846)
    h2e[10, 7, 6, 11] = complex(-0.006014049206, -0.013471185722)
    h2e[0, 7, 8, 11] = complex(0.000708372893, -0.000268804314)
    h2e[2, 7, 8, 11] = complex(-0.017489869738, 0.009305866711)
    h2e[4, 7, 8, 11] = complex(-0.001929426624, 0.001145470674)
    h2e[8, 7, 8, 11] = complex(-0.000006900180, 0.000010432720)
    h2e[10, 7, 8, 11] = complex(0.012766009221, -0.006113110890)
    h2e[0, 9, 0, 11] = complex(0.000006463649, -0.000003230930)
    h2e[2, 9, 0, 11] = complex(0.000000408192, -0.000000831320)
    h2e[4, 9, 0, 11] = complex(-0.000000339911, 0.000000487964)
    h2e[6, 9, 0, 11] = complex(0.000000001075, 0.000000001030)
    h2e[10, 9, 0, 11] = complex(0.000000575277, -0.000000112078)
    h2e[0, 9, 2, 11] = complex(0.000000246979, -0.000000502994)
    h2e[2, 9, 2, 11] = complex(-0.000021430846, 0.000011830021)
    h2e[4, 9, 2, 11] = complex(0.000006915163, -0.000004205300)
    h2e[6, 9, 2, 11] = complex(-0.000000017042, -0.000000012618)
    h2e[10, 9, 2, 11] = complex(0.000007053713, -0.000003744097)
    h2e[0, 9, 4, 11] = complex(0.000000990524, -0.000001421960)
    h2e[2, 9, 4, 11] = complex(-0.000036035864, 0.000021914402)
    h2e[4, 9, 4, 11] = complex(-0.000011835221, 0.000007893617)
    h2e[6, 9, 4, 11] = complex(0.000000022545, 0.000000015114)
    h2e[10, 9, 4, 11] = complex(0.000031843637, -0.000018686048)
    h2e[0, 9, 6, 11] = complex(0.000547527271, 0.000524213334)
    h2e[2, 9, 6, 11] = complex(-0.015921926619, -0.011789241540)
    h2e[4, 9, 6, 11] = complex(-0.001863664711, -0.001249357819)
    h2e[6, 9, 6, 11] = complex(-0.000000511353, 0.000002558690)
    h2e[10, 9, 6, 11] = complex(0.011008244814, 0.008897171578)
    h2e[0, 9, 8, 11] = complex(-0.001157314582, 0.001750241189)
    h2e[2, 9, 8, 11] = complex(0.010783867752, -0.015611240673)
    h2e[4, 9, 8, 11] = complex(0.001122154479, -0.001789769321)
    h2e[6, 9, 8, 11] = complex(0.000012385993, 0.000001743936)
    h2e[10, 9, 8, 11] = complex(-0.008771637720, 0.011931300800)
    h2e[0, 11, 0, 11] = complex(0.019092268023, 0.000072100633)
    h2e[2, 11, 0, 11] = complex(0.003080101612, -0.000146765340)
    h2e[4, 11, 0, 11] = complex(-0.002454315685, 0.000224093607)
    h2e[6, 11, 0, 11] = complex(0.000002184333, 0.000007391568)
    h2e[8, 11, 0, 11] = complex(0.000000571692, -0.000000129130)
    h2e[0, 11, 2, 11] = complex(0.003080101612, -0.000146765340)
    h2e[2, 11, 2, 11] = complex(0.008101796286, -0.000804737143)
    h2e[4, 11, 2, 11] = complex(0.005907237951, -0.000847185804)
    h2e[6, 11, 2, 11] = complex(-0.000009591194, -0.000026144610)
    h2e[8, 11, 2, 11] = complex(0.000006939289, -0.000003952135)
    h2e[0, 11, 4, 11] = complex(-0.002454315685, 0.000224093607)
    h2e[2, 11, 4, 11] = complex(0.005907237951, -0.000847185804)
    h2e[4, 11, 4, 11] = complex(0.016766623257, -0.003153042126)
    h2e[6, 11, 4, 11] = complex(-0.000036438699, -0.000082942820)
    h2e[8, 11, 4, 11] = complex(0.000031274059, -0.000019624438)
    h2e[0, 11, 6, 11] = complex(0.000002184333, 0.000007391568)
    h2e[2, 11, 6, 11] = complex(-0.000009591194, -0.000026144610)
    h2e[4, 11, 6, 11] = complex(-0.000036438699, -0.000082942820)
    h2e[6, 11, 6, 11] = complex(0.009238586512, -0.011501745602)
    h2e[8, 11, 6, 11] = complex(0.011267874744, 0.008565985934)
    h2e[0, 11, 8, 11] = complex(0.000000571692, -0.000000129130)
    h2e[2, 11, 8, 11] = complex(0.000006939289, -0.000003952135)
    h2e[4, 11, 8, 11] = complex(0.000031274059, -0.000019624438)
    h2e[6, 11, 8, 11] = complex(0.011267874744, 0.008565985934)
    h2e[8, 11, 8, 11] = complex(-0.008413066919, 0.012186790898)
    h2e[0, 0, 3, 0] = complex(0.361674738938, -0.000100528206)
    h2e[2, 0, 3, 0] = complex(0.007780106527, 0.000126541824)
    h2e[4, 0, 3, 0] = complex(-0.002037061983, -0.000001203975)
    h2e[6, 0, 3, 0] = complex(0.000006182612, 0.000002600451)
    h2e[8, 0, 3, 0] = complex(0.000000211094, -0.000000140458)
    h2e[10, 0, 3, 0] = complex(-0.009878440701, -0.000086873052)
    h2e[0, 0, 5, 0] = complex(0.166808506949, -0.000003131608)
    h2e[2, 0, 5, 0] = complex(0.003241842402, 0.000053568339)
    h2e[4, 0, 5, 0] = complex(-0.002043232455, -0.000001736892)
    h2e[6, 0, 5, 0] = complex(0.000008015450, 0.000001487046)
    h2e[8, 0, 5, 0] = complex(-0.000012174054, 0.000007845151)
    h2e[10, 0, 5, 0] = complex(0.001451374975, 0.000013139851)
    h2e[0, 0, 7, 0] = complex(-0.000440773975, 0.000005277991)
    h2e[2, 0, 7, 0] = complex(-0.000008560341, -0.000000080253)
    h2e[4, 0, 7, 0] = complex(0.000005463064, -0.000002161545)
    h2e[6, 0, 7, 0] = complex(0.001683008730, -0.000806266293)
    h2e[8, 0, 7, 0] = complex(-0.004983894765, 0.004161459073)
    h2e[10, 0, 7, 0] = complex(-0.000001143108, -0.000000596849)
    h2e[2, 0, 9, 0] = complex(-0.000000210655, -0.000000142592)
    h2e[4, 0, 9, 0] = complex(-0.000012511655, -0.000007371429)
    h2e[6, 0, 9, 0] = complex(0.001697611273, -0.006304712198)
    h2e[8, 0, 9, 0] = complex(0.000003682266, 0.001612170894)
    h2e[10, 0, 9, 0] = complex(-0.000001294653, -0.000001439127)
    h2e[0, 0, 11, 0] = complex(-0.129906865096, 0.000245291061)
    h2e[2, 0, 11, 0] = complex(-0.003163869318, -0.000046363831)
    h2e[4, 0, 11, 0] = complex(-0.000292078610, 0.000000297515)
    h2e[6, 0, 11, 0] = complex(0.000001401526, 0.000003027226)
    h2e[8, 0, 11, 0] = complex(0.000001369385, -0.000001326249)
    h2e[10, 0, 11, 0] = complex(0.009258825969, 0.000066514129)
    h2e[0, 2, 3, 0] = complex(0.007780034980, -0.000130866796)
    h2e[2, 2, 3, 0] = complex(0.011585758965, -0.000003220285)
    h2e[4, 2, 3, 0] = complex(-0.008192841498, 0.000375323214)
    h2e[6, 2, 3, 0] = complex(0.000009067624, 0.000019303936)
    h2e[8, 2, 3, 0] = complex(-0.000000694011, 0.000000327763)
    h2e[10, 2, 3, 0] = complex(-0.003467055598, -0.000122110532)
    h2e[0, 2, 5, 0] = complex(0.003241840259, -0.000053690068)
    h2e[2, 2, 5, 0] = complex(0.013837409413, -0.000000259779)
    h2e[4, 2, 5, 0] = complex(0.012708967454, -0.000578911325)
    h2e[6, 2, 5, 0] = complex(0.000002164542, 0.000005949593)
    h2e[8, 2, 5, 0] = complex(0.000027018388, -0.000012629557)
    h2e[10, 2, 5, 0] = complex(-0.014253850930, -0.000505722958)
    h2e[0, 2, 7, 0] = complex(-0.000008619154, 0.000000283352)
    h2e[2, 2, 7, 0] = complex(-0.000035314923, 0.000000422874)
    h2e[4, 2, 7, 0] = complex(0.000004717776, 0.000000481057)
    h2e[6, 2, 7, 0] = complex(0.005529363181, 0.012678353699)
    h2e[8, 2, 7, 0] = complex(0.011610194466, -0.004891497604)
    h2e[10, 2, 7, 0] = complex(0.000040365870, 0.000001194221)
    h2e[0, 2, 9, 0] = complex(0.000000208582, 0.000000145096)
    h2e[4, 2, 9, 0] = complex(0.000030579213, 0.000012753930)
    h2e[6, 2, 9, 0] = complex(0.000438678793, 0.012616339533)
    h2e[8, 2, 9, 0] = complex(0.013841862086, -0.000213510467)
    h2e[10, 2, 9, 0] = complex(0.000004278111, 0.000002344321)
    h2e[0, 2, 11, 0] = complex(-0.003163671851, 0.000058311538)
    h2e[2, 2, 11, 0] = complex(0.003374071483, -0.000006370946)
    h2e[4, 2, 11, 0] = complex(0.017447092783, -0.000827426190)
    h2e[6, 2, 11, 0] = complex(-0.000020451083, -0.000043268079)
    h2e[8, 2, 11, 0] = complex(-0.000007228623, 0.000003558740)
    h2e[10, 2, 11, 0] = complex(-0.010045724518, -0.000337617531)
    h2e[0, 4, 3, 0] = complex(-0.002037061128, 0.000002336380)
    h2e[2, 4, 3, 0] = complex(-0.008193044554, -0.000370768526)
    h2e[4, 4, 3, 0] = complex(0.009792730157, -0.000002721909)
    h2e[6, 4, 3, 0] = complex(0.000002353262, 0.000005758619)
    h2e[8, 4, 3, 0] = complex(0.000000306248, -0.000000126447)
    h2e[10, 4, 3, 0] = complex(-0.004203943406, -0.000341016291)
    h2e[0, 4, 5, 0] = complex(-0.002043232384, 0.000001813533)
    h2e[2, 4, 5, 0] = complex(0.012708817113, 0.000578426234)
    h2e[4, 4, 5, 0] = complex(-0.005047658677, 0.000000094763)
    h2e[6, 4, 5, 0] = complex(0.000003150562, 0.000007403983)
    h2e[8, 4, 5, 0] = complex(-0.000011788778, 0.000004812209)
    h2e[10, 4, 5, 0] = complex(0.003518577179, 0.000286338593)
    h2e[0, 4, 7, 0] = complex(0.000005100788, 0.000001979003)
    h2e[2, 4, 7, 0] = complex(-0.000067622673, -0.000003050615)
    h2e[4, 4, 7, 0] = complex(0.000012314767, -0.000000147461)
    h2e[6, 4, 7, 0] = complex(-0.002244925076, -0.005702645660)
    h2e[8, 4, 7, 0] = complex(-0.005068846193, 0.001808996043)
    h2e[10, 4, 7, 0] = complex(0.000000891127, 0.000000550271)
    h2e[0, 4, 9, 0] = complex(0.000011632537, 0.000008685323)
    h2e[2, 4, 9, 0] = complex(-0.000029316161, -0.000015456162)
    h2e[6, 4, 9, 0] = complex(-0.000007623199, -0.005396559287)
    h2e[8, 4, 9, 0] = complex(-0.006126669315, -0.000238535909)
    h2e[10, 4, 9, 0] = complex(0.000008958829, 0.000005391662)
    h2e[0, 4, 11, 0] = complex(-0.000292089504, 0.000000804879)
    h2e[2, 4, 11, 0] = complex(0.017450135026, 0.000761534904)
    h2e[4, 4, 11, 0] = complex(-0.012132181965, 0.000022908072)
    h2e[6, 4, 11, 0] = complex(0.000007840523, 0.000018916040)
    h2e[8, 4, 11, 0] = complex(0.000003291355, -0.000001420550)
    h2e[10, 4, 11, 0] = complex(0.006635448482, 0.000527501892)
    h2e[0, 6, 3, 0] = complex(0.000006231299, -0.000002510875)
    h2e[2, 6, 3, 0] = complex(0.000009738061, -0.000020814120)
    h2e[4, 6, 3, 0] = complex(0.000002074940, -0.000005079298)
    h2e[6, 6, 3, 0] = complex(0.010353622182, -0.000002877810)
    h2e[10, 6, 3, 0] = complex(0.000004738147, -0.000008612487)
    h2e[0, 6, 5, 0] = complex(0.000004142028, -0.000003745865)
    h2e[2, 6, 5, 0] = complex(-0.000024524178, 0.000053766103)
    h2e[4, 6, 5, 0] = complex(0.000013873941, -0.000034298113)
    h2e[6, 6, 5, 0] = complex(0.004664046459, -0.000000087561)
    h2e[8, 6, 5, 0] = complex(0.000000001627, -0.000000033455)
    h2e[10, 6, 5, 0] = complex(-0.000001658919, 0.000001438151)
    h2e[0, 6, 7, 0] = complex(-0.000060833285, -0.000028518355)
    h2e[2, 6, 7, 0] = complex(-0.005662106571, 0.012403647372)
    h2e[4, 6, 7, 0] = complex(0.002255590279, -0.005604309968)
    h2e[6, 6, 7, 0] = complex(-0.000012054307, 0.000000144342)
    h2e[8, 6, 7, 0] = complex(0.000001333359, -0.000014236643)
    h2e[10, 6, 7, 0] = complex(0.001931475206, -0.003850594235)
    h2e[0, 6, 9, 0] = complex(0.004924894206, -0.003889236465)
    h2e[2, 6, 9, 0] = complex(-0.009840686696, 0.007581503603)
    h2e[4, 6, 9, 0] = complex(0.004054376547, -0.003419392345)
    h2e[8, 6, 9, 0] = complex(0.000006619618, -0.000014836404)
    h2e[10, 6, 9, 0] = complex(0.003832894681, -0.002786526875)
    h2e[0, 6, 11, 0] = complex(0.000000246037, 0.000002255877)
    h2e[2, 6, 11, 0] = complex(-0.000013418801, 0.000029094092)
    h2e[4, 6, 11, 0] = complex(0.000004987927, -0.000012528756)
    h2e[6, 6, 11, 0] = complex(-0.003309159175, 0.000006248378)
    h2e[8, 6, 11, 0] = complex(0.000000000056, 0.000000009437)
    h2e[10, 6, 11, 0] = complex(-0.000010580647, 0.000019592966)
    h2e[0, 8, 3, 0] = complex(-0.000000209647, -0.000000143553)
    h2e[2, 8, 3, 0] = complex(0.000000695550, 0.000000325727)
    h2e[4, 8, 3, 0] = complex(-0.000000306944, -0.000000125370)
    h2e[8, 8, 3, 0] = complex(0.010349680252, -0.000002876714)
    h2e[10, 8, 3, 0] = complex(-0.000000243606, -0.000000131164)
    h2e[0, 8, 5, 0] = complex(0.000012076871, 0.000008056049)
    h2e[2, 8, 5, 0] = complex(-0.000027109317, -0.000012502480)
    h2e[4, 8, 5, 0] = complex(0.000011829039, 0.000004746987)
    h2e[6, 8, 5, 0] = complex(-0.000000001828, -0.000000033520)
    h2e[8, 8, 5, 0] = complex(0.004662271901, -0.000000087528)
    h2e[10, 8, 5, 0] = complex(0.000010016570, 0.000005325899)
    h2e[0, 8, 7, 0] = complex(0.005628947125, 0.002774112016)
    h2e[2, 8, 7, 0] = complex(-0.011071253735, -0.005622212930)
    h2e[4, 8, 7, 0] = complex(0.004828219830, 0.002189184042)
    h2e[6, 8, 7, 0] = complex(-0.000000155781, -0.000013825626)
    h2e[8, 8, 7, 0] = complex(-0.000012049618, 0.000000144287)
    h2e[10, 8, 7, 0] = complex(0.004161893460, 0.002261291140)
    h2e[0, 8, 9, 0] = complex(0.000055115800, -0.000038954640)
    h2e[2, 8, 9, 0] = complex(-0.008016244554, -0.011096825323)
    h2e[4, 8, 9, 0] = complex(0.003772153635, 0.004749630471)
    h2e[6, 8, 9, 0] = complex(0.000007914318, -0.000013815883)
    h2e[10, 8, 9, 0] = complex(0.002402298165, 0.003596440671)
    h2e[0, 8, 11, 0] = complex(-0.000001401763, -0.000001250535)
    h2e[2, 8, 11, 0] = complex(0.000007185511, 0.000003627434)
    h2e[4, 8, 11, 0] = complex(-0.000003272610, -0.000001454598)
    h2e[6, 8, 11, 0] = complex(-0.000000000158, 0.000000009415)
    h2e[8, 8, 11, 0] = complex(-0.003307705496, 0.000006245633)
    h2e[10, 8, 11, 0] = complex(-0.000002368515, -0.000001362757)
    h2e[0, 10, 3, 0] = complex(-0.009878390700, 0.000092364506)
    h2e[2, 10, 3, 0] = complex(-0.003466986629, 0.000124037842)
    h2e[4, 10, 3, 0] = complex(-0.004203752102, 0.000343353136)
    h2e[6, 10, 3, 0] = complex(0.000004959529, 0.000009075366)
    h2e[8, 10, 3, 0] = complex(0.000000243352, -0.000000131238)
    h2e[10, 10, 3, 0] = complex(0.006861660835, -0.000001907212)
    h2e[0, 10, 5, 0] = complex(0.001451362603, -0.000013194487)
    h2e[2, 10, 5, 0] = complex(-0.014253852351, 0.000506258945)
    h2e[4, 10, 5, 0] = complex(0.003518521639, -0.000286466915)
    h2e[6, 10, 5, 0] = complex(-0.000010280022, -0.000020228888)
    h2e[8, 10, 5, 0] = complex(-0.000009998967, 0.000005336543)
    h2e[10, 10, 5, 0] = complex(0.014578033123, -0.000000273683)
    h2e[0, 10, 7, 0] = complex(-0.000006409636, 0.000000629199)
    h2e[2, 10, 7, 0] = complex(0.000031838500, -0.000001727955)
    h2e[4, 10, 7, 0] = complex(-0.000017935386, 0.000001249990)
    h2e[6, 10, 7, 0] = complex(-0.001680903553, -0.004037203251)
    h2e[8, 10, 7, 0] = complex(-0.004259539992, 0.002218318908)
    h2e[10, 10, 7, 0] = complex(-0.000036809422, 0.000000440770)
    h2e[0, 10, 9, 0] = complex(0.000001438320, 0.000001208311)
    h2e[2, 10, 9, 0] = complex(-0.000004410948, -0.000002064577)
    h2e[4, 10, 9, 0] = complex(-0.000009658400, -0.000003953417)
    h2e[6, 10, 9, 0] = complex(-0.000061981305, -0.004793954807)
    h2e[8, 10, 9, 0] = complex(-0.004369783444, 0.000445940704)
    h2e[0, 10, 11, 0] = complex(0.009258508768, -0.000101478558)
    h2e[2, 10, 11, 0] = complex(-0.010044372493, 0.000375551608)
    h2e[4, 10, 11, 0] = complex(0.006633421318, -0.000552557240)
    h2e[6, 10, 11, 0] = complex(-0.000008187017, -0.000014583491)
    h2e[8, 10, 11, 0] = complex(0.000002379390, -0.000001350179)
    h2e[10, 10, 11, 0] = complex(0.008139708349, -0.000015369455)
    h2e[0, 0, 1, 2] = complex(0.361074525506, -0.020828200324)
    h2e[2, 0, 1, 2] = complex(0.007774571271, -0.000319549618)
    h2e[4, 0, 1, 2] = complex(-0.002033782849, 0.000115543480)
    h2e[6, 0, 1, 2] = complex(0.000006321483, 0.000002241847)
    h2e[8, 0, 1, 2] = complex(0.000000202697, -0.000000152326)
    h2e[10, 0, 1, 2] = complex(-0.009867183157, 0.000479410218)
    h2e[0, 0, 5, 2] = complex(0.007245549338, 0.000250279087)
    h2e[2, 0, 5, 2] = complex(0.000072515520, 0.000003706704)
    h2e[4, 0, 5, 2] = complex(0.000070636738, 0.000002508364)
    h2e[6, 0, 5, 2] = complex(-0.000015835525, -0.000032739561)
    h2e[8, 0, 5, 2] = complex(0.000029993816, -0.000014020399)
    h2e[10, 0, 5, 2] = complex(-0.000482367733, -0.000021044704)
    h2e[0, 0, 7, 2] = complex(-0.000026863469, 0.000035265985)
    h2e[2, 0, 7, 2] = complex(-0.000001054471, 0.000000299611)
    h2e[4, 0, 7, 2] = complex(-0.000032804010, 0.000002253178)
    h2e[6, 0, 7, 2] = complex(-0.006187777320, -0.012381279668)
    h2e[8, 0, 7, 2] = complex(0.011615327987, -0.004893660305)
    h2e[10, 0, 7, 2] = complex(-0.000006634608, -0.000002029341)
    h2e[2, 0, 9, 2] = complex(0.000000693128, 0.000000330849)
    h2e[4, 0, 9, 2] = complex(0.000027545713, 0.000011488723)
    h2e[6, 0, 9, 2] = complex(0.000438484819, 0.012610763647)
    h2e[8, 0, 9, 2] = complex(-0.013828950504, -0.000409913680)
    h2e[10, 0, 9, 2] = complex(0.000007070626, 0.000003874564)
    h2e[0, 0, 11, 2] = complex(0.062106040555, 0.003076868577)
    h2e[2, 0, 11, 2] = complex(0.000164960679, 0.000010910350)
    h2e[4, 0, 11, 2] = complex(-0.000426476243, -0.000021501079)
    h2e[6, 0, 11, 2] = complex(0.000003197311, 0.000004347637)
    h2e[8, 0, 11, 2] = complex(-0.000004373707, 0.000002153230)
    h2e[10, 0, 11, 2] = complex(0.001492860412, 0.000087542337)
    h2e[0, 2, 1, 2] = complex(0.007759747570, -0.000576531057)
    h2e[2, 2, 1, 2] = complex(0.011566531943, -0.000667203104)
    h2e[4, 2, 1, 2] = complex(-0.008157865624, 0.000844243921)
    h2e[6, 2, 1, 2] = complex(0.000010159043, 0.000018752536)
    h2e[8, 2, 1, 2] = complex(-0.000000674086, 0.000000366998)
    h2e[10, 2, 1, 2] = complex(-0.003468355354, 0.000076789600)
    h2e[0, 2, 5, 2] = complex(0.000072602770, 0.000001306082)
    h2e[2, 2, 5, 2] = complex(-0.000785882374, -0.000027146309)
    h2e[4, 2, 5, 2] = complex(-0.007313864456, 0.000080256090)
    h2e[6, 2, 5, 2] = complex(0.000019064679, 0.000010854582)
    h2e[8, 2, 5, 2] = complex(0.000037220502, -0.000030250712)
    h2e[10, 2, 5, 2] = complex(0.000170810160, 0.000011977354)
    h2e[0, 2, 7, 2] = complex(0.000000606971, 0.000000303856)
    h2e[2, 2, 7, 2] = complex(-0.000000068991, 0.000000090570)
    h2e[4, 2, 7, 2] = complex(0.000020963959, -0.000042637196)
    h2e[6, 2, 7, 2] = complex(0.009625912141, -0.004383827250)
    h2e[8, 2, 7, 2] = complex(0.012519803049, -0.016644957932)
    h2e[10, 2, 7, 2] = complex(0.000010627292, -0.000004106371)
    h2e[0, 2, 9, 2] = complex(-0.000000685751, -0.000000345271)
    h2e[4, 2, 9, 2] = complex(0.000037529737, 0.000030113752)
    h2e[6, 2, 9, 2] = complex(-0.010512897409, 0.018118169559)
    h2e[8, 2, 9, 2] = complex(-0.000156272699, 0.009126971254)
    h2e[10, 2, 9, 2] = complex(-0.000002329130, 0.000001061709)
    h2e[0, 2, 11, 2] = complex(0.000165230741, 0.000005448047)
    h2e[2, 2, 11, 2] = complex(0.028314356754, 0.001402754930)
    h2e[4, 2, 11, 2] = complex(0.000921524102, 0.000003686281)
    h2e[6, 2, 11, 2] = complex(0.000004741240, 0.000016598516)
    h2e[8, 2, 11, 2] = complex(0.000002212679, 0.000001120050)
    h2e[10, 2, 11, 2] = complex(-0.026443097014, -0.002252701556)
    h2e[0, 4, 1, 2] = complex(-0.002033579095, 0.000119077967)
    h2e[2, 4, 1, 2] = complex(-0.008200827396, 0.000099390102)
    h2e[4, 4, 1, 2] = complex(0.009776478737, -0.000563945787)
    h2e[6, 4, 1, 2] = complex(0.000002679425, 0.000005614287)
    h2e[8, 4, 1, 2] = complex(0.000000298498, -0.000000143791)
    h2e[10, 4, 1, 2] = complex(-0.004216577651, -0.000099524797)
    h2e[0, 4, 5, 2] = complex(0.000070812958, 0.000002387214)
    h2e[2, 4, 5, 2] = complex(-0.007290894009, -0.000584739175)
    h2e[4, 4, 5, 2] = complex(0.002404481078, 0.000083056688)
    h2e[6, 4, 5, 2] = complex(-0.000000979118, 0.000011437634)
    h2e[8, 4, 5, 2] = complex(-0.000017210463, 0.000011658622)
    h2e[10, 4, 5, 2] = complex(-0.005198540503, -0.000604422276)
    h2e[0, 4, 7, 2] = complex(0.000032490191, 0.000001813276)
    h2e[2, 4, 7, 2] = complex(0.000020951066, -0.000013674378)
    h2e[4, 4, 7, 2] = complex(-0.000007450259, 0.000009780595)
    h2e[6, 4, 7, 2] = complex(-0.003072807661, 0.002619405949)
    h2e[8, 4, 7, 2] = complex(-0.005917245390, 0.006177573141)
    h2e[10, 4, 7, 2] = complex(0.000031493933, -0.000023409878)
    h2e[0, 4, 9, 2] = complex(-0.000026094419, -0.000014478519)
    h2e[2, 4, 9, 2] = complex(-0.000034411318, -0.000033795138)
    h2e[6, 4, 9, 2] = complex(0.004156614346, -0.007549603588)
    h2e[8, 4, 9, 2] = complex(0.001486988231, -0.003156425807)
    h2e[10, 4, 9, 2] = complex(-0.000002090630, 0.000002982668)
    h2e[0, 4, 11, 2] = complex(-0.000426533367, -0.000020760015)
    h2e[2, 4, 11, 2] = complex(0.000917332167, 0.000087412487)
    h2e[4, 4, 11, 2] = complex(0.004953999620, 0.000245431936)
    h2e[6, 4, 11, 2] = complex(0.000024506929, 0.000067849656)
    h2e[8, 4, 11, 2] = complex(-0.000000285671, -0.000000576641)
    h2e[10, 4, 11, 2] = complex(-0.015980519409, -0.002100963810)
    h2e[0, 6, 1, 2] = complex(0.000006077157, -0.000002863868)
    h2e[2, 6, 1, 2] = complex(0.000008529183, -0.000021338005)
    h2e[4, 6, 1, 2] = complex(0.000001780432, -0.000005189866)
    h2e[6, 6, 1, 2] = complex(0.010336439939, -0.000596246554)
    h2e[10, 6, 1, 2] = complex(0.000004236771, -0.000008869878)
    h2e[0, 6, 5, 2] = complex(0.000016112234, -0.000032264576)
    h2e[2, 6, 5, 2] = complex(-0.000003864741, -0.000024125834)
    h2e[4, 6, 5, 2] = complex(0.000006117566, -0.000000260159)
    h2e[6, 6, 5, 2] = complex(0.003852445386, 0.000133072935)
    h2e[8, 6, 5, 2] = complex(-0.000000023772, -0.000000053878)
    h2e[10, 6, 5, 2] = complex(0.000018178132, -0.000024890529)
    h2e[0, 6, 7, 2] = complex(0.005917294034, -0.012284027794)
    h2e[2, 6, 7, 2] = complex(-0.000112932074, -0.000052906332)
    h2e[4, 6, 7, 2] = complex(-0.000414984227, 0.001200497790)
    h2e[6, 6, 7, 2] = complex(-0.000014230234, 0.000018681252)
    h2e[8, 6, 7, 2] = complex(-0.000013846233, -0.000020874435)
    h2e[10, 6, 7, 2] = complex(0.002482535846, -0.005239352483)
    h2e[0, 6, 9, 2] = complex(-0.009997022268, 0.007366146088)
    h2e[2, 6, 9, 2] = complex(-0.014220865849, 0.011725738954)
    h2e[4, 6, 9, 2] = complex(0.005819368352, -0.005234500931)
    h2e[8, 6, 9, 2] = complex(0.000010243364, 0.000009456656)
    h2e[10, 6, 9, 2] = complex(0.000045361829, -0.000055240220)
    h2e[0, 6, 11, 2] = complex(-0.000000777535, 0.000003279843)
    h2e[2, 6, 11, 2] = complex(0.000001779900, 0.000001155742)
    h2e[4, 6, 11, 2] = complex(0.000032711955, -0.000071603461)
    h2e[6, 6, 11, 2] = complex(0.032020567492, 0.001586368686)
    h2e[8, 6, 11, 2] = complex(0.000000003553, -0.000000000004)
    h2e[10, 6, 11, 2] = complex(0.000026157673, -0.000043715600)
    h2e[0, 8, 1, 2] = complex(-0.000000217530, -0.000000131302)
    h2e[2, 8, 1, 2] = complex(0.000000713074, 0.000000285329)
    h2e[4, 8, 1, 2] = complex(-0.000000313624, -0.000000107573)
    h2e[8, 8, 1, 2] = complex(0.010332504552, -0.000596019546)
    h2e[10, 8, 1, 2] = complex(-0.000000250723, -0.000000116988)
    h2e[0, 8, 5, 2] = complex(-0.000029779900, -0.000014513743)
    h2e[2, 8, 5, 2] = complex(-0.000036155527, -0.000031922214)
    h2e[4, 8, 5, 2] = complex(0.000016827998, 0.000012343881)
    h2e[6, 8, 5, 2] = complex(0.000000025817, -0.000000053417)
    h2e[8, 8, 5, 2] = complex(0.003852426818, 0.000133072293)
    h2e[10, 8, 5, 2] = complex(-0.000002319970, 0.000003714620)
    h2e[0, 8, 7, 2] = complex(-0.010953777228, -0.005861033815)
    h2e[2, 8, 7, 2] = complex(-0.016701104632, -0.007797376712)
    h2e[4, 8, 7, 2] = complex(0.007228059643, 0.003003226777)
    h2e[6, 8, 7, 2] = complex(0.000004872514, -0.000020552013)
    h2e[8, 8, 7, 2] = complex(-0.000014230142, 0.000018681129)
    h2e[10, 8, 7, 2] = complex(0.000069377667, 0.000017202501)
    h2e[0, 8, 9, 2] = complex(0.007785173762, 0.011260141132)
    h2e[2, 8, 9, 2] = complex(0.000102281167, -0.000072290162)
    h2e[4, 8, 9, 2] = complex(-0.000841571628, -0.000957619179)
    h2e[6, 8, 9, 2] = complex(-0.000005714128, 0.000000771222)
    h2e[10, 8, 9, 2] = complex(0.003340168209, 0.004765302065)
    h2e[0, 8, 11, 2] = complex(0.000004302212, 0.000002279791)
    h2e[2, 8, 11, 2] = complex(-0.000002040185, 0.000000674270)
    h2e[4, 8, 11, 2] = complex(0.000000241028, -0.000000438569)
    h2e[6, 8, 11, 2] = complex(-0.000000003172, -0.000000000085)
    h2e[8, 8, 11, 2] = complex(0.032020110590, 0.001586346050)
    h2e[10, 8, 11, 2] = complex(0.000002896331, 0.000000963605)
    h2e[0, 10, 1, 2] = complex(-0.009856861006, 0.000658350314)
    h2e[2, 10, 1, 2] = complex(-0.003454179559, 0.000322529449)
    h2e[4, 10, 1, 2] = complex(-0.004177164962, 0.000583708829)
    h2e[6, 10, 1, 2] = complex(0.000005471493, 0.000008776216)
    h2e[8, 10, 1, 2] = complex(0.000000235431, -0.000000144969)
    h2e[10, 10, 1, 2] = complex(0.006850273639, -0.000395150756)
    h2e[0, 10, 5, 2] = complex(-0.000482628152, -0.000012289706)
    h2e[2, 10, 5, 2] = complex(0.000171185557, -0.000000163830)
    h2e[4, 10, 5, 2] = complex(-0.005227918852, 0.000244269141)
    h2e[6, 10, 5, 2] = complex(-0.000002289767, 0.000002808860)
    h2e[8, 10, 5, 2] = complex(0.000002082667, 0.000003452709)
    h2e[10, 10, 5, 2] = complex(-0.004344732228, -0.000150077732)
    h2e[0, 10, 7, 2] = complex(0.000009144097, -0.000001684037)
    h2e[2, 10, 7, 2] = complex(-0.000006925714, -0.000000496117)
    h2e[4, 10, 7, 2] = complex(0.000002559814, -0.000019572888)
    h2e[6, 10, 7, 2] = complex(-0.005308362030, -0.003918879878)
    h2e[8, 10, 7, 2] = complex(0.001519181147, 0.002951917063)
    h2e[10, 10, 7, 2] = complex(0.000012009705, -0.000015766173)
    h2e[0, 10, 9, 2] = complex(-0.000007219329, -0.000003554868)
    h2e[2, 10, 9, 2] = complex(0.000002019238, -0.000000734623)
    h2e[4, 10, 9, 2] = complex(0.000001187524, -0.000002321771)
    h2e[6, 10, 9, 2] = complex(0.002964928700, -0.000008690134)
    h2e[8, 10, 9, 2] = complex(-0.005934620211, -0.002898486377)
    h2e[0, 10, 11, 2] = complex(0.001494197547, 0.000060443137)
    h2e[2, 10, 11, 2] = complex(-0.026536270494, -0.000372011540)
    h2e[4, 10, 11, 2] = complex(-0.016109930494, 0.000511133619)
    h2e[6, 10, 11, 2] = complex(0.000022427279, 0.000044564751)
    h2e[8, 10, 11, 2] = complex(-0.000002992584, 0.000000758615)
    h2e[10, 10, 11, 2] = complex(0.010234604227, 0.000507044594)
    h2e[0, 0, 1, 4] = complex(-0.166797154588, 0.001946077945)
    h2e[2, 0, 1, 4] = complex(-0.003242246434, -0.000015804482)
    h2e[4, 0, 1, 4] = complex(0.002043114078, -0.000022062321)
    h2e[6, 0, 1, 4] = complex(-0.000008032227, -0.000001393582)
    h2e[8, 0, 1, 4] = complex(0.000012081850, -0.000007986419)
    h2e[10, 0, 1, 4] = complex(-0.001451429567, 0.000003766317)
    h2e[0, 0, 3, 4] = complex(0.007226554178, 0.000580981524)
    h2e[2, 0, 3, 4] = complex(0.000072270513, 0.000007015213)
    h2e[4, 0, 3, 4] = complex(0.000070448430, 0.000005732305)
    h2e[6, 0, 3, 4] = complex(-0.000014323512, -0.000033428727)
    h2e[8, 0, 3, 4] = complex(0.000030602936, -0.000012635700)
    h2e[10, 0, 3, 4] = complex(-0.000480902956, -0.000043056429)
    h2e[0, 0, 7, 4] = complex(-0.000006539033, 0.000047366508)
    h2e[2, 0, 7, 4] = complex(0.000000354523, 0.000000092819)
    h2e[4, 0, 7, 4] = complex(0.000014496638, -0.000000357313)
    h2e[6, 0, 7, 4] = complex(0.002431040079, 0.005627239121)
    h2e[8, 0, 7, 4] = complex(-0.005071188503, 0.001809831933)
    h2e[10, 0, 7, 4] = complex(0.000003377024, 0.000001062111)
    h2e[2, 0, 9, 4] = complex(-0.000000293371, -0.000000154672)
    h2e[4, 0, 9, 4] = complex(-0.000011560582, -0.000005367774)
    h2e[6, 0, 9, 4] = complex(-0.000007619635, -0.005394066708)
    h2e[8, 0, 9, 4] = complex(0.006116309246, 0.000411576476)
    h2e[10, 0, 9, 4] = complex(-0.000003074339, -0.000001850219)
    h2e[0, 0, 11, 4] = complex(0.078842848894, 0.007348958871)
    h2e[2, 0, 11, 4] = complex(0.000241120933, 0.000026504589)
    h2e[4, 0, 11, 4] = complex(0.000127020803, 0.000011948879)
    h2e[6, 0, 11, 4] = complex(0.000003609035, 0.000008434492)
    h2e[8, 0, 11, 4] = complex(-0.000009591226, 0.000004139577)
    h2e[10, 0, 11, 4] = complex(-0.001188977837, -0.000121714556)
    h2e[0, 2, 1, 4] = complex(-0.003240994971, 0.000091446624)
    h2e[2, 2, 1, 4] = complex(-0.013836467691, 0.000161434676)
    h2e[4, 2, 1, 4] = complex(-0.012701362286, 0.000726903139)
    h2e[6, 2, 1, 4] = complex(-0.000002233693, -0.000005923978)
    h2e[8, 2, 1, 4] = complex(-0.000026869450, 0.000012943403)
    h2e[10, 2, 1, 4] = complex(0.014258774527, 0.000339663122)
    h2e[0, 2, 3, 4] = complex(0.000072467329, 0.000004621082)
    h2e[2, 2, 3, 4] = complex(-0.000783822081, -0.000063015669)
    h2e[4, 2, 3, 4] = complex(-0.007309896243, -0.000253911870)
    h2e[6, 2, 3, 4] = complex(0.000018548965, 0.000011714095)
    h2e[8, 2, 3, 4] = complex(0.000038563453, -0.000028518974)
    h2e[10, 2, 3, 4] = complex(0.000170084765, 0.000019767153)
    h2e[0, 2, 7, 4] = complex(-0.000000375793, 0.000000057520)
    h2e[2, 2, 7, 4] = complex(-0.000002286798, 0.000016564776)
    h2e[4, 2, 7, 4] = complex(-0.000002953086, -0.000005058316)
    h2e[6, 2, 7, 4] = complex(-0.003971714216, 0.000208379597)
    h2e[8, 2, 7, 4] = complex(-0.005917285505, 0.006177615033)
    h2e[10, 2, 7, 4] = complex(0.000000356032, -0.000020775011)
    h2e[0, 2, 9, 4] = complex(0.000000289888, 0.000000160845)
    h2e[4, 2, 9, 4] = complex(-0.000016149530, -0.000013219140)
    h2e[6, 2, 9, 4] = complex(0.004156586155, -0.007549552405)
    h2e[8, 2, 9, 4] = complex(-0.001076281959, -0.003381540566)
    h2e[10, 2, 9, 4] = complex(0.000000401179, -0.000000572363)
    h2e[0, 2, 11, 4] = complex(0.000241864594, 0.000018514585)
    h2e[2, 2, 11, 4] = complex(0.021587498426, 0.002012175363)
    h2e[4, 2, 11, 4] = complex(-0.033958669360, -0.001612226859)
    h2e[6, 2, 11, 4] = complex(0.000033552169, 0.000103258250)
    h2e[8, 2, 11, 4] = complex(0.000001488674, 0.000003004961)
    h2e[10, 2, 11, 4] = complex(-0.019292312434, -0.002491332513)
    h2e[0, 4, 1, 4] = complex(0.002043072652, -0.000025612504)
    h2e[2, 4, 1, 4] = complex(-0.012714692352, -0.000430357660)
    h2e[4, 4, 1, 4] = complex(0.005047315152, -0.000058888707)
    h2e[6, 4, 1, 4] = complex(-0.000003236588, -0.000007366783)
    h2e[8, 4, 1, 4] = complex(0.000011731927, -0.000004949195)
    h2e[10, 4, 1, 4] = complex(-0.003521673693, -0.000245335603)
    h2e[0, 4, 3, 4] = complex(0.000070630000, 0.000005619331)
    h2e[2, 4, 3, 4] = complex(-0.007256573984, -0.000917163768)
    h2e[4, 4, 3, 4] = complex(0.002398177415, 0.000192802370)
    h2e[6, 4, 3, 4] = complex(-0.000001500548, 0.000011380970)
    h2e[8, 4, 3, 4] = complex(-0.000017725045, 0.000010860310)
    h2e[10, 4, 3, 4] = complex(-0.005165505374, -0.000841251375)
    h2e[0, 4, 7, 4] = complex(-0.000014372112, -0.000001625826)
    h2e[2, 4, 7, 4] = complex(0.000006090245, -0.000014292705)
    h2e[4, 4, 7, 4] = complex(0.000000609214, -0.000004412939)
    h2e[6, 4, 7, 4] = complex(0.003675893954, -0.001283596984)
    h2e[8, 4, 7, 4] = complex(0.007516668810, -0.006388179342)
    h2e[10, 4, 7, 4] = complex(0.000008231664, -0.000014411053)
    h2e[0, 4, 9, 4] = complex(0.000010890062, 0.000006620050)
    h2e[2, 4, 9, 4] = complex(0.000014792973, 0.000014772699)
    h2e[6, 4, 9, 4] = complex(-0.004733677729, 0.008747946606)
    h2e[8, 4, 9, 4] = complex(-0.000363927634, 0.003340596164)
    h2e[10, 4, 9, 4] = complex(-0.000000096807, 0.000001454486)
    h2e[0, 4, 11, 4] = complex(0.000126996575, 0.000011725623)
    h2e[2, 4, 11, 4] = complex(-0.033671701308, -0.004691617662)
    h2e[4, 4, 11, 4] = complex(0.025989597275, 0.002422495941)
    h2e[6, 4, 11, 4] = complex(0.000017851241, 0.000062523327)
    h2e[8, 4, 11, 4] = complex(-0.000000309857, 0.000001305096)
    h2e[10, 4, 11, 4] = complex(-0.045381641944, -0.007984584523)
    h2e[0, 6, 1, 4] = complex(-0.000004098117, 0.000003793856)
    h2e[2, 6, 1, 4] = complex(0.000023896260, -0.000054048107)
    h2e[4, 6, 1, 4] = complex(-0.000013473504, 0.000034457387)
    h2e[6, 6, 1, 4] = complex(-0.004663729042, 0.000054413280)
    h2e[8, 6, 1, 4] = complex(-0.000000001237, 0.000000033472)
    h2e[10, 6, 1, 4] = complex(0.000001642055, -0.000001457376)
    h2e[0, 6, 3, 4] = complex(0.000017569204, -0.000031494921)
    h2e[2, 6, 3, 4] = complex(-0.000002758683, -0.000024277182)
    h2e[4, 6, 3, 4] = complex(0.000006123064, 0.000000019550)
    h2e[6, 6, 3, 4] = complex(0.003842345694, 0.000308906818)
    h2e[8, 6, 3, 4] = complex(-0.000000021286, -0.000000054908)
    h2e[10, 6, 3, 4] = complex(0.000019296112, -0.000024034205)
    h2e[0, 6, 7, 4] = complex(-0.002867146241, 0.005317531402)
    h2e[2, 6, 7, 4] = complex(0.000657746201, -0.001086601816)
    h2e[4, 6, 7, 4] = complex(-0.000099880949, -0.000046838265)
    h2e[6, 6, 7, 4] = complex(-0.000004354999, 0.000031546113)
    h2e[8, 6, 7, 4] = complex(0.000011940821, 0.000023603746)
    h2e[10, 6, 7, 4] = complex(0.000371161035, -0.000684277159)
    h2e[0, 6, 9, 4] = complex(0.004407810520, -0.002945603065)
    h2e[2, 6, 9, 4] = complex(0.006306195253, -0.004632802531)
    h2e[4, 6, 9, 4] = complex(-0.007179661699, 0.005785936819)
    h2e[8, 6, 9, 4] = complex(-0.000016955847, -0.000008788791)
    h2e[10, 6, 9, 4] = complex(0.000114561279, -0.000072671434)
    h2e[0, 6, 11, 4] = complex(-0.000005247146, 0.000008215573)
    h2e[2, 6, 11, 4] = complex(0.000045300252, -0.000069917807)
    h2e[4, 6, 11, 4] = complex(0.000026496021, -0.000048132704)
    h2e[6, 6, 11, 4] = complex(0.041021844538, 0.003823654936)
    h2e[8, 6, 11, 4] = complex(-0.000000004468, -0.000000001769)
    h2e[10, 6, 11, 4] = complex(0.000073840521, -0.000113914307)
    h2e[0, 8, 1, 4] = complex(-0.000012169886, -0.000007914834)
    h2e[2, 8, 1, 4] = complex(0.000027253104, 0.000012185870)
    h2e[4, 8, 1, 4] = complex(-0.000011883528, -0.000004608883)
    h2e[6, 8, 1, 4] = complex(0.000000002218, 0.000000033497)
    h2e[8, 8, 1, 4] = complex(-0.004661954605, 0.000054392577)
    h2e[10, 8, 1, 4] = complex(-0.000010077925, -0.000005208867)
    h2e[0, 8, 3, 4] = complex(-0.000029085853, -0.000015858886)
    h2e[2, 8, 3, 4] = complex(-0.000034659643, -0.000033540414)
    h2e[4, 8, 3, 4] = complex(0.000016246588, 0.000013099669)
    h2e[6, 8, 3, 4] = complex(0.000000028231, -0.000000052182)
    h2e[8, 8, 3, 4] = complex(0.003842327175, 0.000308905329)
    h2e[10, 8, 3, 4] = complex(-0.000002487225, 0.000003604771)
    h2e[0, 8, 7, 4] = complex(0.004556767933, 0.002714261916)
    h2e[2, 8, 7, 4] = complex(0.006894242034, 0.003701515219)
    h2e[4, 8, 7, 4] = complex(-0.008310861168, -0.003994270100)
    h2e[6, 8, 7, 4] = complex(-0.000005808654, 0.000022403126)
    h2e[8, 8, 7, 4] = complex(-0.000004355048, 0.000031546467)
    h2e[10, 8, 7, 4] = complex(0.000114876740, 0.000072188167)
    h2e[0, 8, 9, 4] = complex(-0.003218358188, -0.005141041062)
    h2e[2, 8, 9, 4] = complex(0.000621840687, 0.001112920276)
    h2e[4, 8, 9, 4] = complex(0.000090505712, -0.000063967493)
    h2e[6, 8, 9, 4] = complex(0.000011586593, 0.000005994034)
    h2e[10, 8, 9, 4] = complex(0.000413216421, 0.000663659262)
    h2e[0, 8, 11, 4] = complex(0.000009007651, 0.000005268594)
    h2e[2, 8, 11, 4] = complex(-0.000001519499, 0.000002264087)
    h2e[4, 8, 11, 4] = complex(0.000000249659, 0.000001144915)
    h2e[6, 8, 11, 4] = complex(0.000000004240, -0.000000001259)
    h2e[8, 8, 11, 4] = complex(0.041020701069, 0.003823548353)
    h2e[10, 8, 11, 4] = complex(0.000011211926, 0.000003766035)
    h2e[0, 10, 1, 4] = complex(-0.001451110460, 0.000030098725)
    h2e[2, 10, 1, 4] = complex(0.014246988619, -0.000672250147)
    h2e[4, 10, 1, 4] = complex(-0.003514946251, 0.000327430401)
    h2e[6, 10, 1, 4] = complex(0.000010514945, 0.000020107777)
    h2e[8, 10, 1, 4] = complex(0.000009936130, -0.000005452646)
    h2e[10, 10, 1, 4] = complex(-0.014577040997, 0.000170075191)
    h2e[0, 10, 3, 4] = complex(-0.000481563016, -0.000034322465)
    h2e[2, 10, 3, 4] = complex(0.000171014358, 0.000007655790)
    h2e[4, 10, 3, 4] = complex(-0.005233619757, 0.000005212233)
    h2e[6, 10, 3, 4] = complex(-0.000002415681, 0.000002701335)
    h2e[8, 10, 3, 4] = complex(0.000001922779, 0.000003544238)
    h2e[10, 10, 3, 4] = complex(-0.004333341942, -0.000348380645)
    h2e[0, 10, 7, 4] = complex(-0.000003579607, 0.000000549741)
    h2e[2, 10, 7, 4] = complex(0.000005479010, -0.000021859628)
    h2e[4, 10, 7, 4] = complex(-0.000004215907, -0.000013061666)
    h2e[6, 10, 7, 4] = complex(-0.000621765855, -0.000587315146)
    h2e[8, 10, 7, 4] = complex(0.000038547234, 0.000395413628)
    h2e[10, 10, 7, 4] = complex(0.000000867386, -0.000006283048)
    h2e[0, 10, 9, 4] = complex(0.000003143475, 0.000001715296)
    h2e[2, 10, 9, 4] = complex(-0.000000278548, 0.000000442948)
    h2e[4, 10, 9, 4] = complex(-0.000000283587, -0.000001136987)
    h2e[6, 10, 9, 4] = complex(0.000347250761, -0.000114448941)
    h2e[8, 10, 9, 4] = complex(-0.000780955369, -0.000359643346)
    h2e[0, 10, 11, 4] = complex(-0.001191002621, -0.000100123665)
    h2e[2, 10, 11, 4] = complex(-0.019420403957, -0.001117087757)
    h2e[4, 10, 11, 4] = complex(-0.046075538543, -0.000540156351)
    h2e[6, 10, 11, 4] = complex(0.000056683202, 0.000122935741)
    h2e[8, 10, 11, 4] = complex(-0.000011829356, 0.000001910566)
    h2e[10, 10, 11, 4] = complex(-0.009457316943, -0.000881518542)
    h2e[0, 0, 1, 6] = complex(0.000158487300, -0.000411328741)
    h2e[2, 0, 1, 6] = complex(0.000003247744, -0.000007920735)
    h2e[4, 0, 1, 6] = complex(-0.000000017536, 0.000005875120)
    h2e[6, 0, 1, 6] = complex(0.000124956232, 0.001861980081)
    h2e[8, 0, 1, 6] = complex(-0.002017521274, -0.006171430679)
    h2e[10, 0, 1, 6] = complex(0.000000978064, -0.000000840426)
    h2e[0, 0, 3, 6] = complex(0.000020579060, 0.000039266244)
    h2e[2, 0, 3, 6] = complex(-0.000000174920, 0.000001082164)
    h2e[4, 0, 3, 6] = complex(-0.000011844776, 0.000030673786)
    h2e[6, 0, 3, 6] = complex(-0.013836598751, 0.000364978472)
    h2e[8, 0, 3, 6] = complex(0.000483242819, -0.012594849409)
    h2e[10, 0, 3, 6] = complex(-0.000004647024, 0.000005151836)
    h2e[0, 0, 5, 6] = complex(-0.000041290004, -0.000024113909)
    h2e[2, 0, 5, 6] = complex(-0.000000221043, 0.000000292305)
    h2e[4, 0, 5, 6] = complex(-0.000005199887, 0.000013536668)
    h2e[6, 0, 5, 6] = complex(-0.006129084111, 0.000100518331)
    h2e[8, 0, 5, 6] = complex(0.000261590016, -0.005378105159)
    h2e[10, 0, 5, 6] = complex(-0.000002270058, 0.000002716469)
    h2e[4, 0, 9, 6] = complex(0.000000025221, -0.000000021271)
    h2e[6, 0, 9, 6] = complex(0.000012549312, 0.000005804047)
    h2e[8, 0, 9, 6] = complex(-0.000006824778, 0.000014286609)
    h2e[10, 0, 9, 6] = complex(0.000000007528, -0.000000005473)
    h2e[0, 0, 11, 6] = complex(-0.000057977404, 0.000225392543)
    h2e[2, 0, 11, 6] = complex(-0.000000060196, 0.000000344464)
    h2e[4, 0, 11, 6] = complex(0.000003401070, -0.000009293237)
    h2e[6, 0, 11, 6] = complex(0.004381428755, -0.000364565915)
    h2e[8, 0, 11, 6] = complex(0.000028543230, 0.004804728290)
    h2e[10, 0, 11, 6] = complex(0.000002175260, -0.000006009823)
    h2e[0, 2, 1, 6] = complex(0.000002931845, -0.000008110141)
    h2e[2, 2, 1, 6] = complex(0.000012698043, -0.000032955764)
    h2e[4, 2, 1, 6] = complex(-0.000002195605, 0.000004203349)
    h2e[6, 2, 1, 6] = complex(-0.013824783714, 0.000435735086)
    h2e[8, 2, 1, 6] = complex(0.000239265458, 0.012596273915)
    h2e[10, 2, 1, 6] = complex(-0.000016072254, 0.000037047434)
    h2e[0, 2, 3, 6] = complex(0.000000532223, -0.000000421284)
    h2e[2, 2, 3, 6] = complex(0.000000052851, 0.000000100843)
    h2e[4, 2, 3, 6] = complex(-0.000029754577, -0.000037041642)
    h2e[6, 2, 3, 6] = complex(0.000103013795, -0.010576649266)
    h2e[8, 2, 3, 6] = complex(-0.009780409140, -0.018388683671)
    h2e[10, 2, 3, 6] = complex(0.000000778276, -0.000011366437)
    h2e[0, 2, 5, 6] = complex(0.000000090187, -0.000000369317)
    h2e[2, 2, 5, 6] = complex(-0.000014439732, -0.000008432995)
    h2e[4, 2, 5, 6] = complex(0.000005802335, -0.000000800119)
    h2e[6, 2, 5, 6] = complex(0.001322508372, -0.003750854155)
    h2e[8, 2, 5, 6] = complex(-0.003453119359, -0.007826439903)
    h2e[10, 2, 5, 6] = complex(0.000019068125, 0.000008254359)
    h2e[4, 2, 9, 6] = complex(0.000000040061, -0.000000036035)
    h2e[6, 2, 9, 6] = complex(0.000016460117, 0.000013235982)
    h2e[8, 2, 9, 6] = complex(0.000004134409, -0.000002411737)
    h2e[0, 2, 11, 6] = complex(-0.000000245232, 0.000000821503)
    h2e[2, 2, 11, 6] = complex(-0.000016577210, 0.000064445445)
    h2e[4, 2, 11, 6] = complex(0.000031957354, -0.000117332897)
    h2e[6, 2, 11, 6] = complex(0.005840714850, 0.003515343886)
    h2e[8, 2, 11, 6] = complex(0.003319893288, -0.000003630548)
    h2e[10, 2, 11, 6] = complex(0.000018474738, -0.000059799748)
    h2e[0, 4, 1, 6] = complex(-0.000003728812, 0.000004003805)
    h2e[2, 4, 1, 6] = complex(0.000027900143, -0.000061674258)
    h2e[4, 4, 1, 6] = complex(-0.000004427972, 0.000011492098)
    h2e[6, 4, 1, 6] = complex(0.006128541472, 0.000028906365)
    h2e[8, 4, 1, 6] = complex(0.000198837475, -0.005378301972)
    h2e[10, 4, 1, 6] = complex(-0.000000841398, 0.000000623663)
    h2e[0, 4, 3, 6] = complex(0.000015396088, -0.000028668117)
    h2e[2, 4, 3, 6] = complex(-0.000003520103, -0.000024769834)
    h2e[4, 4, 3, 6] = complex(0.000005707354, 0.000010890019)
    h2e[6, 4, 3, 6] = complex(0.001072410354, 0.003892732958)
    h2e[8, 4, 3, 6] = complex(0.003091996335, 0.007975948925)
    h2e[10, 4, 3, 6] = complex(-0.000007877480, -0.000038442626)
    h2e[0, 4, 5, 6] = complex(0.000006985550, -0.000012665030)
    h2e[2, 4, 5, 6] = complex(0.000010888542, 0.000011082063)
    h2e[4, 4, 5, 6] = complex(0.000003846817, 0.000002246592)
    h2e[6, 4, 5, 6] = complex(-0.000215752539, 0.003887578652)
    h2e[8, 4, 5, 6] = complex(0.003037627376, 0.009385199245)
    h2e[10, 4, 5, 6] = complex(0.000010181032, 0.000013106689)
    h2e[0, 4, 9, 6] = complex(-0.000000027432, 0.000000018332)
    h2e[2, 4, 9, 6] = complex(-0.000000043413, 0.000000031893)
    h2e[6, 4, 9, 6] = complex(-0.000017728854, -0.000014877101)
    h2e[8, 4, 9, 6] = complex(-0.000023787315, -0.000013280693)
    h2e[10, 4, 9, 6] = complex(-0.000000001386, 0.000000000879)
    h2e[0, 4, 11, 6] = complex(-0.000004693474, 0.000009740876)
    h2e[2, 4, 11, 6] = complex(0.000020676296, -0.000092720859)
    h2e[4, 4, 11, 6] = complex(-0.000017980723, 0.000069901733)
    h2e[6, 4, 11, 6] = complex(0.000766581984, 0.000431596296)
    h2e[8, 4, 11, 6] = complex(0.000369361039, 0.000146252850)
    h2e[10, 4, 11, 6] = complex(0.000049525510, -0.000130958657)
    h2e[0, 6, 1, 6] = complex(0.000049036736, -0.000045927962)
    h2e[2, 6, 1, 6] = complex(-0.009421113103, -0.009856599145)
    h2e[4, 6, 1, 6] = complex(0.004368927842, 0.004172343132)
    h2e[6, 6, 1, 6] = complex(0.000004334318, -0.000011249037)
    h2e[8, 6, 1, 6] = complex(0.000012728134, 0.000006515709)
    h2e[10, 6, 1, 6] = complex(0.002860296064, 0.003221238714)
    h2e[0, 6, 3, 6] = complex(-0.008624343707, -0.010560890270)
    h2e[2, 6, 3, 6] = complex(-0.000095737379, 0.000079919580)
    h2e[4, 6, 3, 6] = complex(0.000911970111, 0.000884147814)
    h2e[6, 6, 3, 6] = complex(0.000010901230, 0.000020800286)
    h2e[8, 6, 3, 6] = complex(-0.000024773155, 0.000003708238)
    h2e[10, 6, 3, 6] = complex(-0.003695912988, -0.004466992943)
    h2e[0, 6, 5, 6] = complex(-0.003821645082, -0.004678856344)
    h2e[2, 6, 5, 6] = complex(0.000753512709, 0.001022522471)
    h2e[4, 6, 5, 6] = complex(0.000081398862, -0.000074459859)
    h2e[6, 6, 5, 6] = complex(-0.000027499159, -0.000016059873)
    h2e[8, 6, 5, 6] = complex(-0.000026373949, 0.000002033463)
    h2e[10, 6, 5, 6] = complex(0.000490939589, 0.000604130834)
    h2e[0, 6, 9, 6] = complex(0.000002100087, 0.000013704487)
    h2e[2, 6, 9, 6] = complex(0.000009669094, 0.000019138767)
    h2e[4, 6, 9, 6] = complex(-0.000010827406, -0.000020765065)
    h2e[8, 6, 9, 6] = complex(-0.004543180579, 0.003732565414)
    h2e[10, 6, 9, 6] = complex(0.000000254385, 0.000000132384)
    h2e[0, 6, 11, 6] = complex(0.002723399463, 0.003337738136)
    h2e[2, 6, 11, 6] = complex(0.003563812624, 0.004573525494)
    h2e[4, 6, 11, 6] = complex(0.000511370400, 0.000587234961)
    h2e[6, 6, 11, 6] = complex(-0.000033242169, 0.000129232017)
    h2e[8, 6, 11, 6] = complex(-0.000000431534, 0.000000534737)
    h2e[10, 6, 11, 6] = complex(0.000230449931, -0.000177599660)
    h2e[0, 8, 1, 6] = complex(-0.004663056870, 0.004199600431)
    h2e[2, 8, 1, 6] = complex(0.009325646317, -0.008198430228)
    h2e[4, 8, 1, 6] = complex(-0.003822981125, 0.003672744043)
    h2e[6, 8, 1, 6] = complex(0.000012898403, 0.000004980300)
    h2e[8, 8, 1, 6] = complex(0.000004332632, -0.000011244662)
    h2e[10, 8, 1, 6] = complex(-0.003642952466, 0.003027159082)
    h2e[0, 8, 3, 6] = complex(-0.009946816535, 0.007442969418)
    h2e[2, 8, 3, 6] = complex(-0.014133994632, 0.011830307525)
    h2e[4, 8, 3, 6] = complex(0.005780563255, -0.005277244155)
    h2e[6, 8, 3, 6] = complex(-0.000016557291, -0.000013114220)
    h2e[8, 8, 3, 6] = complex(0.000010901158, 0.000020800151)
    h2e[10, 8, 3, 6] = complex(0.000044953250, -0.000055573291)
    h2e[0, 8, 5, 6] = complex(-0.004247317492, 0.003176735096)
    h2e[2, 8, 5, 6] = complex(-0.006051611583, 0.004960825085)
    h2e[4, 8, 5, 6] = complex(0.006862639407, -0.006158635200)
    h2e[6, 8, 5, 6] = complex(-0.000018493049, -0.000013915733)
    h2e[8, 8, 5, 6] = complex(-0.000027499467, -0.000016060053)
    h2e[10, 8, 5, 6] = complex(-0.000110552275, 0.000078651074)
    h2e[0, 8, 9, 6] = complex(0.000015665095, -0.000002849534)
    h2e[2, 8, 9, 6] = complex(-0.000002634072, 0.000005129106)
    h2e[4, 8, 9, 6] = complex(-0.000001783370, -0.000012922740)
    h2e[6, 8, 9, 6] = complex(0.005584438856, -0.003946960094)
    h2e[10, 8, 9, 6] = complex(0.000004512161, -0.000001876063)
    h2e[0, 8, 11, 6] = complex(0.003799529229, -0.002834334293)
    h2e[2, 8, 11, 6] = complex(-0.000218661557, -0.000398290125)
    h2e[4, 8, 11, 6] = complex(0.000068951129, -0.000128763844)
    h2e[6, 8, 11, 6] = complex(-0.000000080274, -0.000000227466)
    h2e[8, 8, 11, 6] = complex(-0.000033241520, 0.000129229497)
    h2e[10, 8, 11, 6] = complex(0.003579170444, -0.002359320345)
    h2e[0, 10, 1, 6] = complex(0.000001791597, -0.000006186235)
    h2e[2, 10, 1, 6] = complex(-0.000010197273, 0.000030210786)
    h2e[4, 10, 1, 6] = complex(0.000005487480, -0.000017120985)
    h2e[6, 10, 1, 6] = complex(0.004372673335, -0.000064612503)
    h2e[8, 10, 1, 6] = complex(-0.000481323798, -0.004778383318)
    h2e[10, 10, 1, 6] = complex(0.000013235414, -0.000034350425)
    h2e[0, 10, 3, 6] = complex(0.000002345033, -0.000008997295)
    h2e[2, 10, 3, 6] = complex(-0.000003381170, 0.000006064597)
    h2e[4, 10, 3, 6] = complex(-0.000016649196, -0.000010604473)
    h2e[6, 10, 3, 6] = complex(-0.005797513913, 0.003150422048)
    h2e[8, 10, 3, 6] = complex(0.003317476202, -0.000126794778)
    h2e[10, 10, 3, 6] = complex(-0.000009200169, -0.000017554547)
    h2e[0, 10, 5, 6] = complex(0.000000857381, -0.000003518622)
    h2e[2, 10, 5, 6] = complex(0.000018116406, 0.000013403683)
    h2e[4, 10, 5, 6] = complex(0.000013682189, 0.000001085676)
    h2e[6, 10, 5, 6] = complex(0.000780091920, -0.000350697092)
    h2e[8, 10, 5, 6] = complex(-0.000380216286, -0.000115210228)
    h2e[10, 10, 5, 6] = complex(0.000005477015, 0.000003198649)
    h2e[0, 10, 9, 6] = complex(-0.000000007294, 0.000000005786)
    h2e[4, 10, 9, 6] = complex(0.000000000787, -0.000000001582)
    h2e[6, 10, 9, 6] = complex(0.000000087001, 0.000000224979)
    h2e[8, 10, 9, 6] = complex(-0.000000161351, -0.000007408061)
    h2e[0, 10, 11, 6] = complex(-0.000000248416, -0.000000995428)
    h2e[2, 10, 11, 6] = complex(0.000013152577, -0.000062609678)
    h2e[4, 10, 11, 6] = complex(0.000021073858, -0.000140398799)
    h2e[6, 10, 11, 6] = complex(-0.000047430001, -0.002515859486)
    h2e[8, 10, 11, 6] = complex(-0.002283825306, 0.004483210566)
    h2e[10, 10, 11, 6] = complex(0.000009883137, -0.000038421612)
    h2e[2, 0, 1, 8] = complex(0.000000219436, 0.000000128670)
    h2e[4, 0, 1, 8] = complex(0.000012962192, 0.000006546836)
    h2e[6, 0, 1, 8] = complex(-0.001286314988, 0.006401302504)
    h2e[8, 0, 1, 8] = complex(-0.000107937915, -0.001608557724)
    h2e[10, 0, 1, 8] = complex(0.000001385015, 0.000001352385)
    h2e[2, 0, 3, 8] = complex(0.000000695550, 0.000000325727)
    h2e[4, 0, 3, 8] = complex(0.000027629700, 0.000011285244)
    h2e[6, 0, 3, 8] = complex(0.000531485056, 0.012607186541)
    h2e[8, 0, 3, 8] = complex(-0.013831597722, -0.000307905477)
    h2e[10, 0, 3, 8] = complex(0.000007099012, 0.000003822309)
    h2e[2, 0, 5, 8] = complex(0.000000301163, 0.000000138893)
    h2e[4, 0, 5, 8] = complex(0.000011829039, 0.000004746987)
    h2e[6, 0, 5, 8] = complex(0.000293736528, 0.005386068380)
    h2e[8, 0, 5, 8] = complex(-0.006129530300, -0.000086558138)
    h2e[10, 0, 5, 8] = complex(0.000003168156, 0.000001684536)
    h2e[4, 0, 7, 8] = complex(-0.000000030048, -0.000000013624)
    h2e[6, 0, 7, 8] = complex(-0.000000155781, -0.000013825626)
    h2e[8, 0, 7, 8] = complex(0.000015833017, 0.000000018779)
    h2e[10, 0, 7, 8] = complex(-0.000000008178, -0.000000004443)
    h2e[2, 0, 11, 8] = complex(-0.000000246574, -0.000000124477)
    h2e[4, 0, 11, 8] = complex(-0.000010346818, -0.000004598916)
    h2e[6, 0, 11, 8] = complex(0.000080523200, -0.004791434588)
    h2e[8, 0, 11, 8] = complex(0.004362014034, 0.000299329738)
    h2e[10, 0, 11, 8] = complex(-0.000002368514, -0.000001362757)
    h2e[0, 2, 1, 8] = complex(-0.000000217529, -0.000000131303)
    h2e[4, 2, 1, 8] = complex(-0.000031340027, -0.000010749592)
    h2e[6, 2, 1, 8] = complex(-0.001253692436, -0.012561557124)
    h2e[8, 2, 1, 8] = complex(-0.013799076320, 0.001108253273)
    h2e[10, 2, 1, 8] = complex(-0.000004420769, -0.000002062736)
    h2e[0, 2, 3, 8] = complex(-0.000000688279, -0.000000340204)
    h2e[4, 2, 3, 8] = complex(0.000037750831, 0.000029836127)
    h2e[6, 2, 3, 8] = complex(-0.010378978695, 0.018195215824)
    h2e[8, 2, 3, 8] = complex(-0.000088951434, 0.009127875534)
    h2e[10, 2, 3, 8] = complex(-0.000002321234, 0.000001078859)
    h2e[0, 2, 5, 8] = complex(-0.000000298012, -0.000000145241)
    h2e[4, 2, 5, 8] = complex(0.000016827998, 0.000012343879)
    h2e[6, 2, 5, 8] = complex(-0.003750269103, 0.007759409215)
    h2e[8, 2, 5, 8] = complex(0.001254140093, 0.003319688531)
    h2e[10, 2, 5, 8] = complex(-0.000000370260, 0.000000592839)
    h2e[4, 2, 7, 8] = complex(-0.000000049759, -0.000000020675)
    h2e[6, 2, 7, 8] = complex(0.000004872515, -0.000020552011)
    h2e[8, 2, 7, 8] = complex(-0.000003955109, -0.000002695722)
    h2e[0, 2, 11, 8] = complex(0.000000243999, 0.000000129298)
    h2e[4, 2, 11, 8] = complex(0.000001510235, -0.000002747994)
    h2e[6, 2, 11, 8] = complex(0.002963879368, 0.000079455251)
    h2e[8, 2, 11, 8] = complex(0.005905670463, -0.002491434814)
    h2e[10, 2, 11, 8] = complex(0.000002896332, 0.000000963605)
    h2e[0, 4, 1, 8] = complex(-0.000012169887, -0.000007914834)
    h2e[2, 4, 1, 8] = complex(0.000030254380, 0.000013527852)
    h2e[6, 4, 1, 8] = complex(0.000356616983, 0.005384768755)
    h2e[8, 4, 1, 8] = complex(0.006129270083, -0.000158191346)
    h2e[10, 4, 1, 8] = complex(-0.000009288767, -0.000004800983)
    h2e[0, 4, 3, 8] = complex(-0.000026200497, -0.000014285663)
    h2e[2, 4, 3, 8] = complex(-0.000034659636, -0.000033540415)
    h2e[6, 4, 3, 8] = complex(0.004100818271, -0.007580055827)
    h2e[8, 4, 3, 8] = complex(0.001463667207, -0.003167307382)
    h2e[10, 4, 3, 8] = complex(-0.000002068568, 0.000002998006)
    h2e[0, 4, 5, 8] = complex(-0.000011225890, -0.000006033068)
    h2e[2, 4, 5, 8] = complex(-0.000015555765, -0.000013967210)
    h2e[6, 4, 5, 8] = complex(0.004262979529, -0.008986727986)
    h2e[8, 4, 5, 8] = complex(0.000186213762, -0.003355197518)
    h2e[10, 4, 5, 8] = complex(0.000000019513, -0.000001457574)
    h2e[0, 4, 7, 8] = complex(0.000000028346, 0.000000016884)
    h2e[2, 4, 7, 8] = complex(0.000000047461, 0.000000025482)
    h2e[6, 4, 7, 8] = complex(-0.000005808656, 0.000022403122)
    h2e[8, 4, 7, 8] = complex(-0.000001762359, 0.000027186528)
    h2e[10, 4, 7, 8] = complex(0.000000001390, 0.000000000873)
    h2e[0, 4, 11, 8] = complex(0.000009772927, 0.000005716206)
    h2e[2, 4, 11, 8] = complex(-0.000001827030, 0.000002722314)
    h2e[6, 4, 11, 8] = complex(0.000350522217, -0.000104081988)
    h2e[8, 4, 11, 8] = complex(0.000804127668, -0.000235983446)
    h2e[10, 4, 11, 8] = complex(0.000011211930, 0.000003766034)
    h2e[0, 6, 1, 8] = complex(-0.004663056913, 0.004199600399)
    h2e[2, 6, 1, 8] = complex(0.009329769679, -0.008202055175)
    h2e[4, 6, 1, 8] = complex(-0.003824747709, 0.003674441199)
    h2e[8, 6, 1, 8] = complex(-0.000005646251, 0.000015233453)
    h2e[10, 6, 1, 8] = complex(-0.003644658590, 0.003028576796)
    h2e[0, 6, 3, 8] = complex(-0.009942420480, 0.007439679941)
    h2e[2, 6, 3, 8] = complex(-0.014133994404, 0.011830307721)
    h2e[4, 6, 3, 8] = complex(0.005780602362, -0.005277280001)
    h2e[8, 6, 3, 8] = complex(0.000010312834, 0.000009380847)
    h2e[10, 6, 3, 8] = complex(0.000044953141, -0.000055573302)
    h2e[0, 6, 5, 8] = complex(-0.004245355736, 0.003175267818)
    h2e[2, 6, 5, 8] = complex(-0.006051570472, 0.004960791521)
    h2e[4, 6, 5, 8] = complex(0.006862639320, -0.006158635268)
    h2e[8, 6, 5, 8] = complex(0.000017398176, 0.000007876997)
    h2e[10, 6, 5, 8] = complex(-0.000110545142, 0.000078646012)
    h2e[0, 6, 7, 8] = complex(0.000011469973, -0.000007788649)
    h2e[2, 6, 7, 8] = complex(0.000013121764, -0.000016958862)
    h2e[4, 6, 7, 8] = complex(-0.000014092004, 0.000018703903)
    h2e[8, 6, 7, 8] = complex(0.005323370353, 0.002496850502)
    h2e[10, 6, 7, 8] = complex(0.000000010143, -0.000000286591)
    h2e[0, 6, 11, 8] = complex(0.003797750623, -0.002833007494)
    h2e[2, 6, 11, 8] = complex(-0.000218661832, -0.000398290558)
    h2e[4, 6, 11, 8] = complex(0.000068955565, -0.000128772151)
    h2e[8, 6, 11, 8] = complex(-0.000003321035, 0.000005730411)
    h2e[10, 6, 11, 8] = complex(0.003579170497, -0.002359320296)
    h2e[0, 8, 1, 8] = complex(-0.000052481112, 0.000042437579)
    h2e[2, 8, 1, 8] = complex(0.008717123815, 0.010555162778)
    h2e[4, 8, 1, 8] = complex(-0.004071427904, -0.004495732138)
    h2e[6, 8, 1, 8] = complex(-0.000007004240, 0.000014298800)
    h2e[10, 8, 1, 8] = complex(-0.002629860349, -0.003433548673)
    h2e[0, 8, 3, 8] = complex(0.007868012505, 0.011202414389)
    h2e[2, 8, 3, 8] = complex(0.000101745162, -0.000073042509)
    h2e[4, 8, 3, 8] = complex(-0.000848611758, -0.000951386048)
    h2e[6, 8, 3, 8] = complex(-0.000005708285, 0.000000813347)
    h2e[10, 8, 3, 8] = complex(0.003375224416, 0.004740536624)
    h2e[0, 8, 5, 8] = complex(0.003486533065, 0.004963085717)
    h2e[2, 8, 5, 8] = complex(-0.000679999943, -0.001078367942)
    h2e[4, 8, 5, 8] = complex(-0.000086985141, 0.000068678278)
    h2e[6, 8, 5, 8] = complex(-0.000011888234, -0.000005370985)
    h2e[10, 8, 5, 8] = complex(-0.000447838393, -0.000640805898)
    h2e[0, 8, 7, 8] = complex(-0.000009308295, -0.000012917844)
    h2e[2, 8, 7, 8] = complex(0.000005763349, 0.000000172751)
    h2e[4, 8, 7, 8] = complex(-0.000010900359, 0.000007166572)
    h2e[6, 8, 7, 8] = complex(-0.005964650989, -0.003344755582)
    h2e[10, 8, 7, 8] = complex(-0.000003633908, -0.000003267097)
    h2e[0, 8, 11, 8] = complex(-0.002484325776, -0.003540275044)
    h2e[2, 8, 11, 8] = complex(-0.003234929300, -0.004837360819)
    h2e[4, 8, 11, 8] = complex(-0.000469317623, -0.000625245866)
    h2e[6, 8, 11, 8] = complex(0.000003380798, -0.000003528373)
    h2e[10, 8, 11, 8] = complex(-0.000243341214, 0.000161359194)
    h2e[0, 10, 1, 8] = complex(-0.000001513453, -0.000001112761)
    h2e[2, 10, 1, 8] = complex(0.000004535235, 0.000001774987)
    h2e[4, 10, 1, 8] = complex(0.000009893858, 0.000003320506)
    h2e[6, 10, 1, 8] = complex(0.000371889269, 0.004779910326)
    h2e[8, 10, 1, 8] = complex(0.004331795283, -0.000727612579)
    h2e[0, 10, 3, 8] = complex(-0.000007245352, -0.000003501524)
    h2e[2, 10, 3, 8] = complex(0.000002013766, -0.000000749496)
    h2e[4, 10, 3, 8] = complex(0.000001170373, -0.000002330468)
    h2e[6, 10, 3, 8] = complex(0.002964783936, -0.000030558066)
    h2e[8, 10, 3, 8] = complex(-0.005955836904, -0.002854636026)
    h2e[0, 10, 5, 8] = complex(-0.000003230037, -0.000001546136)
    h2e[2, 10, 5, 8] = complex(0.000000254653, -0.000000457098)
    h2e[4, 10, 5, 8] = complex(0.000000343495, 0.000001120344)
    h2e[6, 10, 5, 8] = complex(-0.000340690945, 0.000132707685)
    h2e[8, 10, 5, 8] = complex(0.000798933121, 0.000317711329)
    h2e[0, 10, 7, 8] = complex(0.000000008360, 0.000000004097)
    h2e[4, 10, 7, 8] = complex(-0.000000001767, -0.000000000031)
    h2e[6, 10, 7, 8] = complex(0.000000165712, -0.000000175284)
    h2e[8, 10, 7, 8] = complex(-0.000006618918, 0.000003330966)
    h2e[0, 10, 11, 8] = complex(0.000002431349, 0.000001236987)
    h2e[2, 10, 11, 8] = complex(-0.000002873946, -0.000000926312)
    h2e[4, 10, 11, 8] = complex(-0.000011289222, -0.000002793947)
    h2e[6, 10, 11, 8] = complex(-0.001885486742, -0.004358039856)
    h2e[8, 10, 11, 8] = complex(0.000040583182, 0.002171468589)
    h2e[0, 0, 1, 10] = complex(-0.129304722944, 0.012495694857)
    h2e[2, 0, 1, 10] = complex(-0.003154140180, 0.000252226861)
    h2e[4, 0, 1, 10] = complex(-0.000290748726, 0.000027842080)
    h2e[6, 0, 1, 10] = complex(0.000001680777, 0.000002881556)
    h2e[8, 0, 1, 10] = complex(0.000001238203, -0.000001449484)
    h2e[10, 0, 1, 10] = complex(0.009223831330, -0.000806980829)
    h2e[0, 0, 3, 10] = complex(-0.062177435643, -0.000770643054)
    h2e[2, 0, 3, 10] = complex(-0.000165251885, -0.000004782869)
    h2e[4, 0, 3, 10] = complex(0.000426980326, 0.000005664193)
    h2e[6, 0, 3, 10] = complex(-0.000003356406, -0.000004226025)
    h2e[8, 0, 3, 10] = complex(0.000004290813, -0.000002314010)
    h2e[10, 0, 3, 10] = complex(-0.001495080472, -0.000032097593)
    h2e[0, 0, 5, 10] = complex(0.079180536788, 0.000802877322)
    h2e[2, 0, 5, 10] = complex(0.000242486949, 0.000006471246)
    h2e[4, 0, 5, 10] = complex(0.000127573875, 0.000001402355)
    h2e[6, 0, 5, 10] = complex(0.000004294267, 0.000008107099)
    h2e[8, 0, 5, 10] = complex(-0.000009215991, 0.000004918661)
    h2e[10, 0, 5, 10] = complex(-0.001194970948, -0.000022960039)
    h2e[0, 0, 7, 10] = complex(-0.000226996437, 0.000051339998)
    h2e[2, 0, 7, 10] = complex(-0.000000333943, 0.000000103737)
    h2e[4, 0, 7, 10] = complex(0.000009820826, -0.000001217742)
    h2e[6, 0, 7, 10] = complex(0.002325013722, 0.003731506054)
    h2e[8, 0, 7, 10] = complex(-0.004261534894, 0.002219357795)
    h2e[10, 0, 7, 10] = complex(0.000006339972, -0.000000809003)
    h2e[2, 0, 9, 10] = complex(-0.000000250166, -0.000000117092)
    h2e[4, 0, 9, 10] = complex(-0.000010478962, -0.000004289293)
    h2e[6, 0, 9, 10] = complex(-0.000061952259, -0.004791710686)
    h2e[8, 0, 9, 10] = complex(0.004368984612, 0.000169523403)
    h2e[10, 0, 9, 10] = complex(-0.000002407980, -0.000001291743)
    h2e[0, 2, 1, 10] = complex(-0.003144071674, 0.000356417058)
    h2e[2, 2, 1, 10] = complex(0.003358432043, -0.000324550728)
    h2e[4, 2, 1, 10] = complex(0.017291294785, -0.002469170983)
    h2e[6, 2, 1, 10] = complex(-0.000024440536, -0.000041146490)
    h2e[8, 2, 1, 10] = complex(-0.000006860780, 0.000004224608)
    h2e[10, 2, 1, 10] = complex(-0.010032790309, 0.000611298048)
    h2e[0, 2, 3, 10] = complex(-0.000165319112, 0.000000685693)
    h2e[2, 2, 3, 10] = complex(-0.028346906019, -0.000351338810)
    h2e[4, 2, 3, 10] = complex(-0.000921026460, 0.000030504404)
    h2e[6, 2, 3, 10] = complex(-0.000005353773, -0.000016411191)
    h2e[8, 2, 3, 10] = complex(-0.000002252709, -0.000001037192)
    h2e[10, 2, 3, 10] = complex(0.026508467156, 0.001270123240)
    h2e[0, 2, 5, 10] = complex(0.000242567228, -0.000001552890)
    h2e[2, 2, 5, 10] = complex(0.021679958769, 0.000219831135)
    h2e[4, 2, 5, 10] = complex(-0.033975665522, 0.001201936969)
    h2e[6, 2, 5, 10] = complex(0.000041977458, 0.000100129453)
    h2e[8, 2, 5, 10] = complex(0.000001732108, 0.000002871539)
    h2e[10, 2, 5, 10] = complex(-0.019432266352, -0.000887175954)
    h2e[0, 2, 7, 10] = complex(-0.000000842837, 0.000000156947)
    h2e[2, 2, 7, 10] = complex(-0.000064904039, 0.000014679408)
    h2e[4, 2, 7, 10] = complex(0.000118978797, -0.000025146116)
    h2e[6, 2, 7, 10] = complex(-0.000460433892, 0.006801440550)
    h2e[8, 2, 7, 10] = complex(0.001519179704, 0.002951914263)
    h2e[10, 2, 7, 10] = complex(0.000061637415, -0.000010869910)
    h2e[0, 2, 9, 10] = complex(0.000000247735, 0.000000121987)
    h2e[4, 2, 9, 10] = complex(0.000001427866, -0.000002791673)
    h2e[6, 2, 9, 10] = complex(0.002964931518, -0.000008690137)
    h2e[8, 2, 9, 10] = complex(0.005828994871, -0.002665897618)
    h2e[10, 2, 9, 10] = complex(0.000002923693, 0.000000877077)
    h2e[0, 4, 1, 10] = complex(-0.000290711722, 0.000028348209)
    h2e[2, 4, 1, 10] = complex(0.017444178153, -0.000887578971)
    h2e[4, 4, 1, 10] = complex(-0.012075947076, 0.001166990241)
    h2e[6, 4, 1, 10] = complex(0.000009589546, 0.000018092291)
    h2e[8, 4, 1, 10] = complex(0.000003142713, -0.000001724626)
    h2e[10, 4, 1, 10] = complex(0.006655622204, -0.000100637398)
    h2e[0, 4, 3, 10] = complex(0.000427009918, 0.000004921519)
    h2e[2, 4, 3, 10] = complex(-0.000919943617, -0.000053319683)
    h2e[4, 4, 3, 10] = complex(-0.004959694578, -0.000061471724)
    h2e[6, 4, 3, 10] = complex(-0.000027007251, -0.000066893750)
    h2e[8, 4, 3, 10] = complex(0.000000306867, 0.000000565646)
    h2e[10, 4, 3, 10] = complex(0.016047462857, 0.001506647073)
    h2e[0, 4, 5, 10] = complex(0.000127531265, 0.000001181867)
    h2e[2, 4, 5, 10] = complex(-0.033944369693, -0.001890637840)
    h2e[4, 4, 5, 10] = complex(0.026100912030, 0.000264658857)
    h2e[6, 4, 5, 10] = complex(0.000022961234, 0.000060832680)
    h2e[8, 4, 5, 10] = complex(-0.000000200854, 0.000001326253)
    h2e[10, 4, 5, 10] = complex(-0.045886543791, -0.004203821416)
    h2e[0, 4, 7, 10] = complex(-0.000010809218, 0.000000272348)
    h2e[2, 4, 7, 10] = complex(0.000091931257, -0.000023943909)
    h2e[4, 4, 7, 10] = complex(-0.000070399153, 0.000015922242)
    h2e[6, 4, 7, 10] = complex(-0.000033932118, 0.000879074466)
    h2e[8, 4, 7, 10] = complex(0.000038544746, 0.000395388136)
    h2e[10, 4, 7, 10] = complex(0.000139123151, -0.000015738328)
    h2e[0, 4, 9, 10] = complex(0.000009938539, 0.000005423149)
    h2e[2, 4, 9, 10] = complex(-0.000001745303, 0.000002775427)
    h2e[6, 4, 9, 10] = complex(0.000347273151, -0.000114456318)
    h2e[8, 4, 9, 10] = complex(0.000796756942, -0.000259784278)
    h2e[10, 4, 9, 10] = complex(0.000011318920, 0.000003431063)
    h2e[0, 6, 1, 10] = complex(0.000000457692, 0.000002222619)
    h2e[2, 6, 1, 10] = complex(-0.000010615132, 0.000030229942)
    h2e[4, 6, 1, 10] = complex(0.000003784110, -0.000012943324)
    h2e[6, 6, 1, 10] = complex(-0.003293820615, 0.000318306837)
    h2e[8, 6, 1, 10] = complex(0.000000000946, 0.000000009389)
    h2e[10, 6, 1, 10] = complex(-0.000008685678, 0.000020503497)
    h2e[0, 6, 3, 10] = complex(0.000000655319, -0.000003306432)
    h2e[2, 6, 3, 10] = complex(-0.000001821552, -0.000001088911)
    h2e[4, 6, 3, 10] = complex(-0.000030032978, 0.000072767766)
    h2e[6, 6, 3, 10] = complex(-0.032057377297, -0.000397327341)
    h2e[8, 6, 3, 10] = complex(-0.000000003551, 0.000000000136)
    h2e[10, 6, 3, 10] = complex(-0.000024517836, 0.000044655943)
    h2e[0, 6, 5, 10] = complex(-0.000004549678, 0.000008621404)
    h2e[2, 6, 5, 10] = complex(0.000039362313, -0.000073424932)
    h2e[4, 6, 5, 10] = complex(0.000022424301, -0.000050159217)
    h2e[6, 6, 5, 10] = complex(0.041197543165, 0.000417736157)
    h2e[8, 6, 5, 10] = complex(-0.000000004599, -0.000000001394)
    h2e[10, 6, 5, 10] = complex(0.000064165953, -0.000119631194)
    h2e[0, 6, 7, 10] = complex(-0.001725872755, 0.003946994264)
    h2e[2, 6, 7, 10] = complex(-0.002441547261, 0.005258967863)
    h2e[4, 6, 7, 10] = complex(-0.000288933672, 0.000723091918)
    h2e[6, 6, 7, 10] = complex(-0.000130151633, 0.000029436517)
    h2e[8, 6, 7, 10] = complex(-0.000000672784, -0.000000139743)
    h2e[10, 6, 7, 10] = complex(0.000263232548, 0.000123925162)
    h2e[0, 6, 9, 10] = complex(0.003711852400, -0.002944654985)
    h2e[2, 6, 9, 10] = complex(-0.000230405534, -0.000391614091)
    h2e[4, 6, 9, 10] = complex(0.000065096953, -0.000130765144)
    h2e[8, 6, 9, 10] = complex(-0.000003149213, 0.000005826606)
    h2e[10, 6, 9, 10] = complex(0.003507450636, -0.002464679224)
    h2e[0, 8, 1, 10] = complex(-0.000001513453, -0.000001112761)
    h2e[2, 8, 1, 10] = complex(0.000007495587, 0.000002933601)
    h2e[4, 8, 1, 10] = complex(-0.000003395207, -0.000001139475)
    h2e[6, 8, 1, 10] = complex(0.000000000730, 0.000000009388)
    h2e[8, 8, 1, 10] = complex(-0.003292373674, 0.000318167008)
    h2e[10, 8, 1, 10] = complex(-0.000002486479, -0.000001133309)
    h2e[0, 8, 3, 10] = complex(-0.000004383830, -0.000002118611)
    h2e[2, 8, 3, 10] = complex(0.000002013764, -0.000000749495)
    h2e[4, 8, 3, 10] = complex(-0.000000224591, 0.000000447209)
    h2e[6, 8, 3, 10] = complex(0.000000003173, -0.000000000033)
    h2e[8, 8, 3, 10] = complex(-0.032056919869, -0.000397321671)
    h2e[10, 8, 3, 10] = complex(-0.000002930086, -0.000000855489)
    h2e[0, 8, 5, 10] = complex(0.000009412543, 0.000004505542)
    h2e[2, 8, 5, 10] = complex(-0.000001327038, 0.000002382005)
    h2e[4, 8, 5, 10] = complex(0.000000343497, 0.000001120344)
    h2e[6, 8, 5, 10] = complex(0.000000004121, -0.000000001605)
    h2e[8, 8, 5, 10] = complex(0.041196394799, 0.000417724513)
    h2e[10, 8, 5, 10] = complex(0.000011484993, 0.000002825820)
    h2e[0, 8, 7, 10] = complex(0.004256554244, 0.002086053504)
    h2e[2, 8, 7, 10] = complex(0.000254495724, -0.000376403835)
    h2e[4, 8, 7, 10] = complex(0.000146040759, 0.000002546046)
    h2e[6, 8, 7, 10] = complex(0.000000165712, -0.000000175283)
    h2e[8, 8, 7, 10] = complex(-0.000130149095, 0.000029435943)
    h2e[10, 8, 7, 10] = complex(0.003733332378, 0.002106913145)
    h2e[0, 8, 9, 10] = complex(-0.002588473129, -0.003464856244)
    h2e[2, 8, 9, 10] = complex(-0.003377304750, -0.004739054736)
    h2e[4, 8, 9, 10] = complex(-0.000487697523, -0.000611017633)
    h2e[6, 8, 9, 10] = complex(0.000003274412, -0.000003627318)
    h2e[10, 8, 9, 10] = complex(-0.000238436735, 0.000168521899)
    h2e[0, 10, 1, 10] = complex(0.009207672177, -0.000974194839)
    h2e[2, 10, 1, 10] = complex(-0.009964185435, 0.001321161007)
    h2e[4, 10, 1, 10] = complex(0.006551743859, -0.001175691410)
    h2e[6, 10, 1, 10] = complex(-0.000009525894, -0.000013746374)
    h2e[8, 10, 1, 10] = complex(0.000002241449, -0.000001568561)
    h2e[10, 10, 1, 10] = complex(0.008101979308, -0.000782955633)
    h2e[0, 10, 3, 10] = complex(-0.001495411317, -0.000004967442)
    h2e[2, 10, 3, 10] = complex(0.026531803705, -0.000612728757)
    h2e[4, 10, 3, 10] = complex(0.016079877163, -0.001108453217)
    h2e[6, 10, 3, 10] = complex(-0.000024065174, -0.000043702030)
    h2e[8, 10, 3, 10] = complex(0.000002962379, -0.000000869116)
    h2e[10, 10, 3, 10] = complex(-0.010246369595, -0.000126996128)
    h2e[0, 10, 5, 10] = complex(-0.001195203064, -0.000001275656)
    h2e[2, 10, 5, 10] = complex(-0.019446258526, 0.000492954586)
    h2e[4, 10, 5, 10] = complex(-0.045962352199, 0.003272491605)
    h2e[6, 10, 5, 10] = complex(0.000066656716, 0.000117826413)
    h2e[8, 10, 5, 10] = complex(-0.000011630809, 0.000002882399)
    h2e[10, 10, 5, 10] = complex(-0.009497823109, -0.000096306329)
    h2e[0, 10, 7, 10] = complex(0.000000772158, -0.000000675544)
    h2e[2, 10, 7, 10] = complex(0.000061707056, -0.000016887904)
    h2e[4, 10, 7, 10] = complex(0.000134529890, -0.000045361204)
    h2e[6, 10, 7, 10] = complex(0.002216598596, -0.001191003491)
    h2e[8, 10, 7, 10] = complex(-0.005031381550, 0.000015325562)
    h2e[10, 10, 7, 10] = complex(0.000038695021, -0.000008751689)
    h2e[0, 10, 9, 10] = complex(0.000002467047, 0.000001164161)
    h2e[2, 10, 9, 10] = complex(-0.000002900218, -0.000000840465)
    h2e[4, 10, 9, 10] = complex(-0.000011367302, -0.000002457103)
    h2e[6, 10, 9, 10] = complex(-0.002014209350, -0.004300061917)
    h2e[8, 10, 9, 10] = complex(0.000105118714, 0.002169302443)
    h2e[0, 0, 1, 1] = complex(4.133559527667, 0.000000000000)
    h2e[2, 0, 1, 1] = complex(0.056172681502, 0.000929254556)
    h2e[4, 0, 1, 1] = complex(-0.016279369195, -0.000014146503)
    h2e[6, 0, 1, 1] = complex(0.000049455655, 0.000020375643)
    h2e[10, 0, 1, 1] = complex(-0.062997221645, -0.000571522212)
    h2e[0, 0, 3, 1] = complex(-0.056133611779, -0.002291569232)
    h2e[2, 0, 3, 1] = complex(-0.001206687939, -0.000069270000)
    h2e[4, 0, 3, 1] = complex(0.000316149134, 0.000013181537)
    h2e[6, 0, 3, 1] = complex(-0.000001127515, -0.000000886526)
    h2e[8, 0, 3, 1] = complex(0.000000388738, -0.000000150024)
    h2e[10, 0, 3, 1] = complex(0.001532608220, 0.000076498815)
    h2e[0, 0, 5, 1] = complex(-0.016278429618, -0.000175472749)
    h2e[2, 0, 5, 1] = complex(-0.000316305729, -0.000008643702)
    h2e[4, 0, 5, 1] = complex(0.000199451008, 0.000002323316)
    h2e[6, 0, 5, 1] = complex(0.000008754555, 0.000023427494)
    h2e[8, 0, 5, 1] = complex(-0.000019664671, 0.000007480140)
    h2e[10, 0, 5, 1] = complex(-0.000141605671, -0.000002810174)
    h2e[0, 0, 7, 1] = complex(0.000037256617, 0.000038379333)
    h2e[2, 0, 7, 1] = complex(0.000001198102, 0.000000788525)
    h2e[4, 0, 7, 1] = complex(0.000025008419, -0.000000262138)
    h2e[6, 0, 7, 1] = complex(0.004118512800, 0.010318943854)
    h2e[8, 0, 7, 1] = complex(-0.008732482467, 0.002769967174)
    h2e[10, 0, 7, 1] = complex(0.000007239879, 0.000001196043)
    h2e[2, 0, 9, 1] = complex(-0.000000367579, -0.000000196239)
    h2e[4, 0, 9, 1] = complex(-0.000019036687, -0.000008958590)
    h2e[6, 0, 9, 1] = complex(-0.000072076478, -0.009160991918)
    h2e[8, 0, 9, 1] = complex(0.011077246925, 0.000717897807)
    h2e[10, 0, 9, 1] = complex(-0.000006183003, -0.000003755374)
    h2e[0, 0, 11, 1] = complex(0.062770336469, 0.005372283708)
    h2e[2, 0, 11, 1] = complex(0.001526553140, 0.000156126662)
    h2e[4, 0, 11, 1] = complex(0.000141106998, 0.000012201570)
    h2e[6, 0, 11, 1] = complex(-0.000003185317, -0.000006610606)
    h2e[8, 0, 11, 1] = complex(0.000006700061, -0.000002727918)
    h2e[10, 0, 11, 1] = complex(-0.004470272451, -0.000423478216)
    h2e[0, 2, 1, 1] = complex(0.056172681502, -0.000929254556)
    h2e[2, 2, 1, 1] = complex(0.881258649487, 0.000000000000)
    h2e[4, 2, 1, 1] = complex(-0.127065038995, 0.005785599605)
    h2e[6, 2, 1, 1] = complex(0.000175436119, 0.000374245009)
    h2e[10, 2, 1, 1] = complex(-0.202563653096, -0.007190713913)
    h2e[0, 2, 3, 1] = complex(-0.001208318830, -0.000029318974)
    h2e[2, 2, 3, 1] = complex(-0.001798164002, -0.000073407307)
    h2e[4, 2, 3, 1] = complex(0.001273946920, -0.000005988018)
    h2e[6, 2, 3, 1] = complex(-0.000001238050, -0.000003129368)
    h2e[8, 2, 3, 1] = complex(0.000000268604, -0.000000175966)
    h2e[10, 2, 3, 1] = complex(0.000537318235, 0.000041068727)
    h2e[0, 2, 5, 1] = complex(-0.000316420824, 0.000001823227)
    h2e[2, 2, 5, 1] = complex(-0.001350358560, -0.000014556142)
    h2e[4, 2, 5, 1] = complex(-0.001240851459, 0.000043101489)
    h2e[6, 2, 5, 1] = complex(-0.000003295759, -0.000001155177)
    h2e[8, 2, 5, 1] = complex(-0.000012325376, 0.000007594884)
    h2e[10, 2, 5, 1] = complex(0.001390460177, 0.000064372167)
    h2e[0, 2, 7, 1] = complex(0.000000254750, 0.000000698019)
    h2e[2, 2, 7, 1] = complex(0.000002985010, 0.000003074962)
    h2e[4, 2, 7, 1] = complex(-0.000003168696, 0.000005641581)
    h2e[6, 2, 7, 1] = complex(-0.002998161668, -0.001142293055)
    h2e[8, 2, 7, 1] = complex(-0.004863318535, 0.004264415350)
    h2e[10, 2, 7, 1] = complex(-0.000005383685, -0.000003065339)
    h2e[0, 2, 9, 1] = complex(0.000000363054, 0.000000204157)
    h2e[4, 2, 9, 1] = complex(-0.000012874977, -0.000009578795)
    h2e[6, 2, 9, 1] = complex(0.002611692426, -0.005899123995)
    h2e[8, 2, 9, 1] = complex(-0.001996127079, -0.002105538420)
    h2e[10, 2, 9, 1] = complex(-0.000000167352, -0.000000578002)
    h2e[0, 2, 11, 1] = complex(0.001530882569, 0.000105548093)
    h2e[2, 2, 11, 1] = complex(-0.001630334179, -0.000139534344)
    h2e[4, 2, 11, 1] = complex(-0.008463941399, -0.000337696876)
    h2e[6, 2, 11, 1] = complex(0.000006835084, 0.000016338840)
    h2e[8, 2, 11, 1] = complex(0.000000429224, -0.000000921737)
    h2e[10, 2, 11, 1] = complex(0.004838970257, 0.000587711667)
    h2e[0, 4, 1, 1] = complex(-0.016279369195, 0.000014146503)
    h2e[2, 4, 1, 1] = complex(-0.127065038995, -0.005785599605)
    h2e[4, 4, 1, 1] = complex(0.798772089105, -0.000000000000)
    h2e[6, 4, 1, 1] = complex(0.000206846959, 0.000506261149)
    h2e[10, 4, 1, 1] = complex(-0.213163158391, -0.017351050434)
    h2e[0, 4, 3, 1] = complex(0.000316173828, 0.000012632211)
    h2e[2, 4, 3, 1] = complex(0.001269219266, 0.000109808892)
    h2e[4, 4, 3, 1] = complex(-0.001519877541, -0.000062046686)
    h2e[6, 4, 3, 1] = complex(-0.000000344144, -0.000000856202)
    h2e[8, 4, 3, 1] = complex(-0.000000140636, 0.000000078031)
    h2e[10, 4, 3, 1] = complex(0.000650288986, 0.000079744251)
    h2e[0, 4, 5, 1] = complex(0.000199337429, 0.000001968899)
    h2e[2, 4, 5, 1] = complex(-0.001239607331, -0.000069838528)
    h2e[4, 4, 5, 1] = complex(0.000492588526, 0.000005309840)
    h2e[6, 4, 5, 1] = complex(0.000000805815, -0.000001207661)
    h2e[8, 4, 5, 1] = complex(0.000006270143, -0.000003301777)
    h2e[10, 4, 5, 1] = complex(-0.000343076080, -0.000031651942)
    h2e[0, 4, 7, 1] = complex(-0.000025738776, -0.000003491454)
    h2e[2, 4, 7, 1] = complex(0.000008751222, 0.000000292024)
    h2e[4, 4, 7, 1] = complex(-0.000001040911, -0.000001072279)
    h2e[6, 4, 7, 1] = complex(0.001199090274, 0.000227416760)
    h2e[8, 4, 7, 1] = complex(0.002524293436, -0.001854152675)
    h2e[10, 4, 7, 1] = complex(-0.000004107857, 0.000001076021)
    h2e[0, 4, 9, 1] = complex(0.000017917228, 0.000011022995)
    h2e[2, 4, 9, 1] = complex(0.000011897673, 0.000010793329)
    h2e[6, 4, 9, 1] = complex(-0.001297243789, 0.002849681200)
    h2e[8, 4, 9, 1] = complex(0.000489974340, 0.000921247325)
    h2e[10, 4, 9, 1] = complex(-0.000000783880, -0.000001617682)
    h2e[0, 4, 11, 1] = complex(0.000141159952, 0.000011958417)
    h2e[2, 4, 11, 1] = complex(-0.008398221640, -0.001105473586)
    h2e[4, 4, 11, 1] = complex(0.005862208617, 0.000501725012)
    h2e[6, 4, 11, 1] = complex(-0.000002490395, -0.000006849213)
    h2e[8, 4, 11, 1] = complex(-0.000000405751, 0.000000467686)
    h2e[10, 4, 11, 1] = complex(-0.003183391722, -0.000535305923)
    h2e[0, 6, 1, 1] = complex(0.000049455655, -0.000020375643)
    h2e[2, 6, 1, 1] = complex(0.000175436119, -0.000374245009)
    h2e[4, 6, 1, 1] = complex(0.000206846959, -0.000506261149)
    h2e[6, 6, 1, 1] = complex(0.966780087765, -0.000000000000)
    h2e[10, 6, 1, 1] = complex(0.000290573890, -0.000530037720)
    h2e[0, 6, 3, 1] = complex(-0.000000740233, -0.000000064675)
    h2e[2, 6, 3, 1] = complex(-0.000001682670, 0.000003085649)
    h2e[4, 6, 3, 1] = complex(-0.000000344667, 0.000000829941)
    h2e[6, 6, 3, 1] = complex(-0.001606930608, -0.000065600495)
    h2e[10, 6, 3, 1] = complex(-0.000000739325, 0.000001261328)
    h2e[0, 6, 5, 1] = complex(-0.000013046249, 0.000022460414)
    h2e[2, 6, 5, 1] = complex(0.000005871758, -0.000005221919)
    h2e[4, 6, 5, 1] = complex(-0.000002548014, 0.000002644959)
    h2e[6, 6, 5, 1] = complex(-0.000455152758, -0.000004906303)
    h2e[8, 6, 5, 1] = complex(0.000000004674, 0.000000018924)
    h2e[10, 6, 5, 1] = complex(-0.000002564717, 0.000002791100)
    h2e[0, 6, 7, 1] = complex(-0.005298716834, 0.009572071290)
    h2e[2, 6, 7, 1] = complex(0.000982607906, -0.001875591554)
    h2e[4, 6, 7, 1] = complex(-0.000252578389, 0.000531698793)
    h2e[6, 6, 7, 1] = complex(0.000001018896, 0.000001049600)
    h2e[8, 6, 7, 1] = complex(0.000003203498, 0.000008203479)
    h2e[10, 6, 7, 1] = complex(-0.001005627124, 0.001832104948)
    h2e[0, 6, 9, 1] = complex(0.007564729087, -0.004870031538)
    h2e[2, 6, 9, 1] = complex(0.004925924106, -0.003566427522)
    h2e[4, 6, 9, 1] = complex(-0.002335988522, 0.001853261800)
    h2e[8, 6, 9, 1] = complex(-0.000003892807, -0.000000496194)
    h2e[10, 6, 9, 1] = complex(-0.000624533828, 0.000420905719)
    h2e[0, 6, 11, 1] = complex(0.000003152606, -0.000005820907)
    h2e[2, 6, 11, 1] = complex(0.000009989142, -0.000018511143)
    h2e[4, 6, 11, 1] = complex(-0.000003939580, 0.000008292464)
    h2e[6, 6, 11, 1] = complex(0.001598968882, 0.000136849903)
    h2e[8, 6, 11, 1] = complex(-0.000000001544, -0.000000001555)
    h2e[10, 6, 11, 1] = complex(0.000005510646, -0.000007999027)
    h2e[8, 8, 1, 1] = complex(0.966731902319, -0.000000000000)
    h2e[0, 8, 3, 1] = complex(-0.000000364549, -0.000000201474)
    h2e[2, 8, 3, 1] = complex(-0.000000244206, -0.000000207524)
    h2e[4, 8, 3, 1] = complex(0.000000129545, 0.000000094904)
    h2e[8, 8, 3, 1] = complex(-0.001606318802, -0.000065575519)
    h2e[10, 8, 3, 1] = complex(0.000000009733, 0.000000032710)
    h2e[0, 8, 5, 1] = complex(0.000018476716, 0.000010057059)
    h2e[2, 8, 5, 1] = complex(0.000011218054, 0.000009140424)
    h2e[4, 8, 5, 1] = complex(-0.000005779679, -0.000004095471)
    h2e[6, 8, 5, 1] = complex(-0.000000007118, 0.000000018130)
    h2e[8, 8, 5, 1] = complex(-0.000454979583, -0.000004904436)
    h2e[10, 8, 5, 1] = complex(-0.000000942380, -0.000001707533)
    h2e[0, 8, 7, 1] = complex(0.007649515048, 0.004735742072)
    h2e[2, 8, 7, 1] = complex(0.005335585955, 0.002912554296)
    h2e[4, 8, 7, 1] = complex(-0.002676382358, -0.001311559176)
    h2e[6, 8, 7, 1] = complex(-0.000001741802, 0.000007760847)
    h2e[8, 8, 7, 1] = complex(0.000001018499, 0.000001049192)
    h2e[10, 8, 7, 1] = complex(-0.000648241799, -0.000382695423)
    h2e[0, 8, 9, 1] = complex(-0.005729356340, -0.009381436134)
    h2e[2, 8, 9, 1] = complex(0.001149418393, 0.001788325552)
    h2e[4, 8, 9, 1] = complex(-0.000338726386, -0.000484290313)
    h2e[6, 8, 9, 1] = complex(0.000000384496, 0.000001963338)
    h2e[10, 8, 9, 1] = complex(-0.001100027965, -0.001786801546)
    h2e[0, 8, 11, 1] = complex(-0.000006207988, -0.000003686806)
    h2e[2, 8, 11, 1] = complex(-0.000000399668, -0.000000794187)
    h2e[4, 8, 11, 1] = complex(0.000000378207, 0.000000438668)
    h2e[6, 8, 11, 1] = complex(0.000000001507, -0.000000001340)
    h2e[8, 8, 11, 1] = complex(0.001598266472, 0.000136789787)
    h2e[10, 8, 11, 1] = complex(-0.000000579053, -0.000000146715)
    h2e[0, 10, 1, 1] = complex(-0.062997221645, 0.000571522212)
    h2e[2, 10, 1, 1] = complex(-0.202563653096, 0.007190713913)
    h2e[4, 10, 1, 1] = complex(-0.213163158391, 0.017351050434)
    h2e[6, 10, 1, 1] = complex(0.000290573890, 0.000530037720)
    h2e[10, 10, 1, 1] = complex(0.764008571320, 0.000000000000)
    h2e[0, 10, 3, 1] = complex(0.001533744458, 0.000048680348)
    h2e[2, 10, 3, 1] = complex(0.000538877563, 0.000002865331)
    h2e[4, 10, 3, 1] = complex(0.000654624696, -0.000026473115)
    h2e[6, 10, 3, 1] = complex(-0.000000755286, -0.000001492138)
    h2e[8, 10, 3, 1] = complex(-0.000000013545, 0.000000032155)
    h2e[10, 10, 3, 1] = complex(-0.001064961868, -0.000043475447)
    h2e[0, 10, 5, 1] = complex(-0.000141665370, -0.000000242444)
    h2e[2, 10, 5, 1] = complex(0.001391536087, -0.000034383889)
    h2e[4, 10, 5, 1] = complex(-0.000343656913, 0.000024248172)
    h2e[6, 10, 5, 1] = complex(0.000003195954, 0.000005291317)
    h2e[8, 10, 5, 1] = complex(0.000001156147, -0.000001579690)
    h2e[10, 10, 5, 1] = complex(-0.001422634196, -0.000015335234)
    h2e[0, 10, 7, 1] = complex(-0.000006618183, -0.000000146765)
    h2e[2, 10, 7, 1] = complex(-0.000000744613, -0.000003289445)
    h2e[4, 10, 7, 1] = complex(0.000005437311, -0.000000104121)
    h2e[6, 10, 7, 1] = complex(0.001478509285, 0.001670983247)
    h2e[8, 10, 7, 1] = complex(0.000345265592, -0.001060673815)
    h2e[10, 10, 7, 1] = complex(0.000003111333, 0.000003205092)
    h2e[0, 10, 9, 1] = complex(0.000006314846, 0.000003500626)
    h2e[2, 10, 9, 1] = complex(0.000000255998, 0.000000473125)
    h2e[4, 10, 9, 1] = complex(0.000001139636, 0.000001244978)
    h2e[6, 10, 9, 1] = complex(-0.000746726841, 0.000704700025)
    h2e[8, 10, 9, 1] = complex(0.002092432270, 0.000751746184)
    h2e[0, 10, 11, 1] = complex(-0.004477209496, -0.000342304304)
    h2e[2, 10, 11, 1] = complex(0.004868462440, 0.000243111991)
    h2e[4, 10, 11, 1] = complex(-0.003228058658, -0.000013426742)
    h2e[6, 10, 11, 1] = complex(0.000003500747, 0.000008511267)
    h2e[8, 10, 11, 1] = complex(0.000000624641, 0.000000000890)
    h2e[10, 10, 11, 1] = complex(-0.003933065673, -0.000336616718)
    h2e[0, 0, 1, 3] = complex(-0.056133611779, 0.002291569232)
    h2e[2, 0, 1, 3] = complex(-0.001208318830, 0.000029318974)
    h2e[4, 0, 1, 3] = complex(0.000316173828, -0.000012632211)
    h2e[6, 0, 1, 3] = complex(-0.000000740233, 0.000000064675)
    h2e[8, 0, 1, 3] = complex(-0.000000364549, 0.000000201474)
    h2e[10, 0, 1, 3] = complex(0.001533744458, -0.000048680348)
    h2e[0, 0, 3, 3] = complex(0.881258649475, 0.000000000000)
    h2e[2, 0, 3, 3] = complex(0.001799415547, 0.000029767407)
    h2e[4, 0, 3, 3] = complex(-0.001350436501, -0.000001173507)
    h2e[6, 0, 3, 3] = complex(0.000003962400, 0.000001632502)
    h2e[10, 0, 3, 3] = complex(0.001636227069, 0.000014844148)
    h2e[0, 0, 5, 3] = complex(0.127196685084, -0.000024542078)
    h2e[2, 0, 5, 3] = complex(0.001273790752, 0.000020826248)
    h2e[4, 0, 5, 3] = complex(0.001241599524, 0.000000838553)
    h2e[6, 0, 5, 3] = complex(-0.000003830871, 0.000005214643)
    h2e[8, 0, 5, 3] = complex(0.000013054861, -0.000009332147)
    h2e[10, 0, 5, 3] = complex(-0.008470341591, -0.000075209843)
    h2e[0, 0, 7, 3] = complex(-0.000413324188, -0.000000522774)
    h2e[2, 0, 7, 3] = complex(-0.000003365354, 0.000000010168)
    h2e[4, 0, 7, 3] = complex(0.000002412440, 0.000002525193)
    h2e[6, 0, 7, 3] = complex(-0.001219610551, 0.002967550577)
    h2e[8, 0, 7, 3] = complex(0.004544632460, -0.004578964606)
    h2e[10, 0, 7, 3] = complex(0.000017685497, 0.000000948316)
    h2e[2, 0, 9, 3] = complex(0.000000256661, 0.000000192969)
    h2e[4, 0, 9, 3] = complex(0.000012178673, 0.000007827971)
    h2e[6, 0, 9, 3] = complex(-0.002202753595, 0.006081527914)
    h2e[8, 0, 9, 3] = complex(0.002142606082, -0.001956285889)
    h2e[10, 0, 9, 3] = complex(0.000000333306, 0.000000960593)
    h2e[0, 0, 11, 3] = complex(-0.202690975409, -0.000329260552)
    h2e[2, 0, 11, 3] = complex(-0.000538796536, -0.000009788723)
    h2e[4, 0, 11, 3] = complex(0.001391945125, 0.000003470909)
    h2e[6, 0, 11, 3] = complex(-0.000004695939, -0.000004040856)
    h2e[8, 0, 11, 3] = complex(-0.000000225239, 0.000000557997)
    h2e[10, 0, 11, 3] = complex(-0.004874250680, -0.000052138883)
    h2e[0, 2, 1, 3] = complex(-0.001206687939, 0.000069270000)
    h2e[2, 2, 1, 3] = complex(-0.001798164002, 0.000073407307)
    h2e[4, 2, 1, 3] = complex(0.001269219266, -0.000109808892)
    h2e[6, 2, 1, 3] = complex(-0.000001682670, -0.000003085649)
    h2e[8, 2, 1, 3] = complex(-0.000000244206, 0.000000207524)
    h2e[10, 2, 1, 3] = complex(0.000538877563, -0.000002865331)
    h2e[0, 2, 3, 3] = complex(0.001799415547, -0.000029767407)
    h2e[2, 2, 3, 3] = complex(0.652177317349, 0.000000000000)
    h2e[4, 2, 3, 3] = complex(0.013782001885, -0.000627530163)
    h2e[6, 2, 3, 3] = complex(0.000000450556, 0.000000961140)
    h2e[10, 2, 3, 3] = complex(-0.092349463720, -0.003278271119)
    h2e[0, 2, 5, 3] = complex(0.001273782199, -0.000021317787)
    h2e[2, 2, 5, 3] = complex(-0.013796280759, 0.000002661936)
    h2e[4, 2, 5, 3] = complex(-0.128193634926, 0.005861773427)
    h2e[6, 2, 5, 3] = complex(0.000073223194, 0.000154235539)
    h2e[8, 2, 5, 3] = complex(-0.000139566600, 0.000067056082)
    h2e[10, 2, 5, 3] = complex(0.003001853937, 0.000105981452)
    h2e[0, 2, 7, 3] = complex(-0.000003514587, -0.000000016909)
    h2e[2, 2, 7, 3] = complex(-0.000001061503, -0.000000001342)
    h2e[4, 2, 7, 3] = complex(0.000170600949, -0.000006749310)
    h2e[6, 2, 7, 3] = complex(-0.026638060936, -0.057012536852)
    h2e[8, 2, 7, 3] = complex(-0.054801280376, 0.024785980317)
    h2e[10, 2, 7, 3] = complex(0.000004471559, -0.000000487878)
    h2e[0, 2, 9, 3] = complex(-0.000000254266, -0.000000195068)
    h2e[4, 2, 9, 3] = complex(-0.000142033011, -0.000061660189)
    h2e[6, 2, 9, 3] = complex(-0.000298324396, -0.060145125816)
    h2e[8, 2, 9, 3] = complex(-0.062887052112, -0.000463842959)
    h2e[10, 2, 9, 3] = complex(-0.000021339296, -0.000012059918)
    h2e[0, 2, 11, 3] = complex(-0.000538825227, 0.000008038187)
    h2e[2, 2, 11, 3] = complex(-0.092407510400, -0.000150111014)
    h2e[4, 2, 11, 3] = complex(-0.003000833341, 0.000131751202)
    h2e[6, 2, 11, 3] = complex(-0.000001291867, -0.000004308590)
    h2e[8, 2, 11, 3] = complex(0.000021854480, -0.000011099050)
    h2e[10, 2, 11, 3] = complex(0.086447482008, 0.003209373726)
    h2e[0, 4, 1, 3] = complex(0.000316149134, -0.000013181537)
    h2e[2, 4, 1, 3] = complex(0.001273946920, 0.000005988018)
    h2e[4, 4, 1, 3] = complex(-0.001519877541, 0.000062046686)
    h2e[6, 4, 1, 3] = complex(-0.000000344667, -0.000000829941)
    h2e[8, 4, 1, 3] = complex(0.000000129545, -0.000000094904)
    h2e[10, 4, 1, 3] = complex(0.000654624696, 0.000026473115)
    h2e[0, 4, 3, 3] = complex(-0.001350436501, 0.000001173507)
    h2e[2, 4, 3, 3] = complex(0.013782001885, 0.000627530163)
    h2e[4, 4, 3, 3] = complex(0.587292582647, -0.000000000000)
    h2e[6, 4, 3, 3] = complex(0.000072337473, 0.000177047092)
    h2e[10, 4, 3, 3] = complex(-0.058364955229, -0.004750789439)
    h2e[0, 4, 5, 3] = complex(0.001241572396, -0.000001319040)
    h2e[2, 4, 5, 3] = complex(-0.128195051677, -0.005812266068)
    h2e[4, 4, 5, 3] = complex(0.042211019239, -0.000008144443)
    h2e[6, 4, 5, 3] = complex(0.000065506450, 0.000159499536)
    h2e[8, 4, 5, 3] = complex(0.000051588137, -0.000021704765)
    h2e[10, 4, 5, 3] = complex(-0.091520552405, -0.007431812909)
    h2e[0, 4, 7, 3] = complex(-0.000007252266, -0.000003025000)
    h2e[2, 4, 7, 3] = complex(0.000493437741, 0.000022356818)
    h2e[4, 4, 7, 3] = complex(-0.000114630482, -0.000000144988)
    h2e[6, 4, 7, 3] = complex(0.008819785101, 0.020793187294)
    h2e[8, 4, 7, 3] = complex(0.019773698445, -0.007661285660)
    h2e[10, 4, 7, 3] = complex(0.000217680171, 0.000017080851)
    h2e[0, 4, 9, 3] = complex(-0.000011257003, -0.000009092414)
    h2e[2, 4, 9, 3] = complex(0.000135905999, 0.000074266718)
    h2e[6, 4, 9, 3] = complex(-0.000642550653, 0.021207073933)
    h2e[8, 4, 9, 3] = complex(0.022519781316, 0.001378779832)
    h2e[10, 4, 9, 3] = complex(-0.000035884723, -0.000022267982)
    h2e[0, 4, 11, 3] = complex(0.001391960426, 0.000001052012)
    h2e[2, 4, 11, 3] = complex(-0.003000508097, -0.000141505421)
    h2e[4, 4, 11, 3] = complex(-0.016168008881, -0.000026264058)
    h2e[6, 4, 11, 3] = complex(-0.000095718585, -0.000234573869)
    h2e[8, 4, 11, 3] = complex(-0.000007399833, 0.000003300119)
    h2e[10, 4, 11, 3] = complex(0.052358730043, 0.004347523609)
    h2e[0, 6, 1, 3] = complex(-0.000001127515, 0.000000886526)
    h2e[2, 6, 1, 3] = complex(-0.000001238050, 0.000003129368)
    h2e[4, 6, 1, 3] = complex(-0.000000344144, 0.000000856202)
    h2e[6, 6, 1, 3] = complex(-0.001606930608, 0.000065600495)
    h2e[10, 6, 1, 3] = complex(-0.000000755286, 0.000001492138)
    h2e[0, 6, 3, 3] = complex(0.000003962400, -0.000001632502)
    h2e[2, 6, 3, 3] = complex(0.000000450556, -0.000000961140)
    h2e[4, 6, 3, 3] = complex(0.000072337473, -0.000177047092)
    h2e[6, 6, 3, 3] = complex(0.652882649491, 0.000000000000)
    h2e[10, 6, 3, 3] = complex(0.000083082446, -0.000151551228)
    h2e[0, 6, 5, 3] = complex(-0.000003145199, 0.000008171712)
    h2e[2, 6, 5, 3] = complex(0.000208902766, -0.000447593862)
    h2e[4, 6, 5, 3] = complex(0.000019966886, -0.000049727067)
    h2e[6, 6, 5, 3] = complex(0.067630245781, -0.000013048978)
    h2e[8, 6, 5, 3] = complex(-0.000000003176, 0.000000145951)
    h2e[10, 6, 5, 3] = complex(0.000114032153, -0.000202214437)
    h2e[0, 6, 7, 3] = complex(-0.000873501392, 0.001928822774)
    h2e[2, 6, 7, 3] = complex(0.025783908691, -0.056395167589)
    h2e[4, 6, 7, 3] = complex(-0.008319882669, 0.020637703624)
    h2e[6, 6, 7, 3] = complex(-0.000218947889, -0.000000276924)
    h2e[8, 6, 7, 3] = complex(-0.000002841044, 0.000055834571)
    h2e[10, 6, 7, 3] = complex(-0.008475884014, 0.016897639791)
    h2e[0, 6, 9, 3] = complex(-0.004711350170, 0.003841175549)
    h2e[2, 6, 9, 3] = complex(0.046987912799, -0.036239592714)
    h2e[4, 6, 9, 3] = complex(-0.015980900823, 0.013494837084)
    h2e[8, 6, 9, 3] = complex(-0.000027579131, 0.000056531769)
    h2e[10, 6, 9, 3] = complex(-0.016022645004, 0.011644946127)
    h2e[0, 6, 11, 3] = complex(-0.000003309242, -0.000000651010)
    h2e[2, 6, 11, 3] = complex(-0.000021963928, 0.000045276303)
    h2e[4, 6, 11, 3] = complex(-0.000090343959, 0.000220797671)
    h2e[6, 6, 11, 3] = complex(-0.104503201302, -0.000169759811)
    h2e[8, 6, 11, 3] = complex(-0.000000000674, -0.000000021493)
    h2e[10, 6, 11, 3] = complex(-0.000075381008, 0.000136465454)
    h2e[0, 8, 1, 3] = complex(0.000000388738, 0.000000150024)
    h2e[2, 8, 1, 3] = complex(0.000000268604, 0.000000175966)
    h2e[4, 8, 1, 3] = complex(-0.000000140636, -0.000000078031)
    h2e[8, 8, 1, 3] = complex(-0.001606318802, 0.000065575519)
    h2e[10, 8, 1, 3] = complex(-0.000000013545, -0.000000032155)
    h2e[8, 8, 3, 3] = complex(0.652877324639, 0.000000000000)
    h2e[0, 8, 5, 3] = complex(-0.000013014519, -0.000009416628)
    h2e[2, 8, 5, 3] = complex(0.000139654134, 0.000066953036)
    h2e[4, 8, 5, 3] = complex(-0.000051621944, -0.000021656910)
    h2e[6, 8, 5, 3] = complex(0.000000003327, 0.000000146021)
    h2e[8, 8, 5, 3] = complex(0.067629919819, -0.000013048915)
    h2e[10, 8, 5, 3] = complex(-0.000044506930, -0.000024448341)
    h2e[0, 8, 7, 3] = complex(-0.005496165966, -0.002603131427)
    h2e[2, 8, 7, 3] = complex(0.052922253023, 0.026840401652)
    h2e[4, 8, 7, 3] = complex(-0.019054961743, -0.008625677897)
    h2e[6, 8, 7, 3] = complex(-0.000000249538, 0.000054219757)
    h2e[8, 8, 7, 3] = complex(-0.000218946480, -0.000000276924)
    h2e[10, 8, 7, 3] = complex(-0.017402900486, -0.009458843070)
    h2e[0, 8, 9, 3] = complex(-0.001250019411, -0.001719512254)
    h2e[2, 8, 9, 3] = complex(0.036417420246, 0.050475108726)
    h2e[4, 8, 9, 3] = complex(-0.013879618965, -0.017496807164)
    h2e[6, 8, 9, 3] = complex(-0.000026518853, 0.000047710580)
    h2e[10, 8, 9, 3] = complex(-0.010538974889, -0.015777599569)
    h2e[0, 8, 11, 3] = complex(0.000000268963, 0.000000465877)
    h2e[2, 8, 11, 3] = complex(-0.000021738097, -0.000011241895)
    h2e[4, 8, 11, 3] = complex(0.000007359922, 0.000003358410)
    h2e[6, 8, 11, 3] = complex(0.000000000859, -0.000000021413)
    h2e[8, 8, 11, 3] = complex(-0.104501710142, -0.000169757389)
    h2e[10, 8, 11, 3] = complex(0.000006885786, 0.000004064690)
    h2e[0, 10, 1, 3] = complex(0.001532608220, -0.000076498815)
    h2e[2, 10, 1, 3] = complex(0.000537318235, -0.000041068727)
    h2e[4, 10, 1, 3] = complex(0.000650288986, -0.000079744251)
    h2e[6, 10, 1, 3] = complex(-0.000000739325, -0.000001261328)
    h2e[8, 10, 1, 3] = complex(0.000000009733, -0.000000032710)
    h2e[10, 10, 1, 3] = complex(-0.001064961868, 0.000043475447)
    h2e[0, 10, 3, 3] = complex(0.001636227069, -0.000014844148)
    h2e[2, 10, 3, 3] = complex(-0.092349463720, 0.003278271119)
    h2e[4, 10, 3, 3] = complex(-0.058364955229, 0.004750789439)
    h2e[6, 10, 3, 3] = complex(0.000083082446, 0.000151551228)
    h2e[10, 10, 3, 3] = complex(0.600972926146, -0.000000000000)
    h2e[0, 10, 5, 3] = complex(-0.008470303397, 0.000078478817)
    h2e[2, 10, 5, 3] = complex(0.003001931502, -0.000107144226)
    h2e[4, 10, 5, 3] = complex(-0.091517474803, 0.007467112621)
    h2e[6, 10, 5, 3] = complex(0.000155779802, 0.000289865932)
    h2e[8, 10, 5, 3] = complex(0.000044496914, -0.000024441930)
    h2e[10, 10, 5, 3] = complex(-0.076272413760, 0.000014716449)
    h2e[0, 10, 7, 3] = complex(0.000021020225, -0.000000771694)
    h2e[2, 10, 7, 3] = complex(0.000050309760, -0.000001133938)
    h2e[4, 10, 7, 3] = complex(0.000297904585, -0.000023043941)
    h2e[6, 10, 7, 3] = complex(0.007833867161, 0.017495780966)
    h2e[8, 10, 7, 3] = complex(0.017577256567, -0.009729039571)
    h2e[10, 10, 7, 3] = complex(0.000184782601, 0.000000233714)
    h2e[0, 10, 9, 3] = complex(-0.000000467220, -0.000000756421)
    h2e[2, 10, 9, 3] = complex(0.000022062689, 0.000010590697)
    h2e[4, 10, 9, 3] = complex(0.000038856908, 0.000016353219)
    h2e[6, 10, 9, 3] = complex(-0.000207146432, 0.020020800143)
    h2e[8, 10, 9, 3] = complex(0.019171671805, -0.001392397595)
    h2e[0, 10, 11, 3] = complex(-0.004874393509, 0.000036302647)
    h2e[2, 10, 11, 3] = complex(0.086457433181, -0.002928498383)
    h2e[4, 10, 11, 3] = complex(0.052372541294, -0.004177390426)
    h2e[6, 10, 11, 3] = complex(-0.000082624048, -0.000151882265)
    h2e[8, 10, 11, 3] = complex(-0.000006902351, 0.000004068874)
    h2e[10, 10, 11, 3] = complex(-0.033401934739, -0.000054259641)
    h2e[0, 0, 1, 5] = complex(-0.016278429618, 0.000175472749)
    h2e[2, 0, 1, 5] = complex(-0.000316420824, -0.000001823227)
    h2e[4, 0, 1, 5] = complex(0.000199337429, -0.000001968899)
    h2e[6, 0, 1, 5] = complex(-0.000013046249, -0.000022460414)
    h2e[8, 0, 1, 5] = complex(0.000018476716, -0.000010057059)
    h2e[10, 0, 1, 5] = complex(-0.000141665370, 0.000000242444)
    h2e[0, 0, 3, 5] = complex(0.127196685084, 0.000024542078)
    h2e[2, 0, 3, 5] = complex(0.001273782199, 0.000021317787)
    h2e[4, 0, 3, 5] = complex(0.001241572396, 0.000001319040)
    h2e[6, 0, 3, 5] = complex(-0.000003145199, -0.000008171712)
    h2e[8, 0, 3, 5] = complex(-0.000013014519, 0.000009416628)
    h2e[10, 0, 3, 5] = complex(-0.008470303397, -0.000078478817)
    h2e[0, 0, 5, 5] = complex(0.798772089110, -0.000000000000)
    h2e[2, 0, 5, 5] = complex(0.001520935396, 0.000025160560)
    h2e[4, 0, 5, 5] = complex(0.000492616958, 0.000000428076)
    h2e[6, 0, 5, 5] = complex(-0.000001381740, -0.000000569274)
    h2e[10, 0, 5, 5] = complex(-0.005883397739, -0.000053375251)
    h2e[0, 0, 7, 5] = complex(0.000546884185, -0.000001923925)
    h2e[2, 0, 7, 5] = complex(0.000000921709, 0.000000044392)
    h2e[4, 0, 7, 5] = complex(-0.000000822919, 0.000001196072)
    h2e[6, 0, 7, 5] = complex(-0.000701382928, 0.000998798157)
    h2e[8, 0, 7, 5] = complex(0.002282685927, -0.002143098064)
    h2e[10, 0, 7, 5] = complex(0.000007278147, 0.000000377309)
    h2e[2, 0, 9, 5] = complex(0.000000131182, 0.000000093052)
    h2e[4, 0, 9, 5] = complex(0.000006043483, 0.000003700372)
    h2e[6, 0, 9, 5] = complex(-0.000946047995, 0.002985788444)
    h2e[8, 0, 9, 5] = complex(0.000594840106, -0.000857284510)
    h2e[10, 0, 9, 5] = complex(0.000000332601, 0.000000522246)
    h2e[0, 0, 11, 5] = complex(0.213867894708, 0.000338610404)
    h2e[2, 0, 11, 5] = complex(0.000655052610, 0.000011873855)
    h2e[4, 0, 11, 5] = complex(0.000344532043, 0.000000844588)
    h2e[6, 0, 11, 5] = complex(0.000000173039, 0.000004242920)
    h2e[8, 0, 11, 5] = complex(0.000001013142, -0.000001484893)
    h2e[10, 0, 11, 5] = complex(-0.003227902146, -0.000034395080)
    h2e[0, 2, 1, 5] = complex(-0.000316305729, 0.000008643702)
    h2e[2, 2, 1, 5] = complex(-0.001350358560, 0.000014556142)
    h2e[4, 2, 1, 5] = complex(-0.001239607331, 0.000069838528)
    h2e[6, 2, 1, 5] = complex(0.000005871758, 0.000005221919)
    h2e[8, 2, 1, 5] = complex(0.000011218054, -0.000009140424)
    h2e[10, 2, 1, 5] = complex(0.001391536087, 0.000034383889)
    h2e[0, 2, 3, 5] = complex(0.001273790752, -0.000020826248)
    h2e[2, 2, 3, 5] = complex(-0.013796280759, -0.000002661936)
    h2e[4, 2, 3, 5] = complex(-0.128195051677, 0.005812266068)
    h2e[6, 2, 3, 5] = complex(0.000208902766, 0.000447593862)
    h2e[8, 2, 3, 5] = complex(0.000139654134, -0.000066953036)
    h2e[10, 2, 3, 5] = complex(0.003001931502, 0.000107144226)
    h2e[0, 2, 5, 5] = complex(0.001520935396, -0.000025160560)
    h2e[2, 2, 5, 5] = complex(0.587292582649, 0.000000000000)
    h2e[4, 2, 5, 5] = complex(-0.042167331664, 0.001919987585)
    h2e[6, 2, 5, 5] = complex(0.000048655092, 0.000103792343)
    h2e[10, 2, 5, 5] = complex(-0.016157852787, -0.000573580181)
    h2e[0, 2, 7, 5] = complex(0.000000897299, -0.000000049510)
    h2e[2, 2, 7, 5] = complex(0.000191253574, -0.000000672825)
    h2e[4, 2, 7, 5] = complex(-0.000172233746, 0.000008169084)
    h2e[6, 2, 7, 5] = complex(-0.009360614668, -0.020555391997)
    h2e[8, 2, 7, 5] = complex(-0.019421736214, 0.008541019722)
    h2e[10, 2, 7, 5] = complex(-0.000253212315, -0.000008394669)
    h2e[0, 2, 9, 5] = complex(-0.000000129950, -0.000000094349)
    h2e[4, 2, 9, 5] = complex(-0.000051426648, -0.000022084669)
    h2e[6, 2, 9, 5] = complex(-0.000304971792, -0.021203807234)
    h2e[8, 2, 9, 5] = complex(-0.022561944344, 0.000015872114)
    h2e[10, 2, 9, 5] = complex(-0.000007072568, -0.000003953108)
    h2e[0, 2, 11, 5] = complex(0.000655086473, -0.000009799555)
    h2e[2, 2, 11, 5] = complex(0.058557914955, 0.000092712931)
    h2e[4, 2, 11, 5] = complex(-0.091733264331, 0.004031323622)
    h2e[6, 2, 11, 5] = complex(0.000091538367, 0.000198235064)
    h2e[8, 2, 11, 5] = complex(-0.000037744270, 0.000018945877)
    h2e[10, 2, 11, 5] = complex(-0.052502825902, -0.001947009208)
    h2e[0, 4, 1, 5] = complex(0.000199451008, -0.000002323316)
    h2e[2, 4, 1, 5] = complex(-0.001240851459, -0.000043101489)
    h2e[4, 4, 1, 5] = complex(0.000492588526, -0.000005309840)
    h2e[6, 4, 1, 5] = complex(-0.000002548014, -0.000002644959)
    h2e[8, 4, 1, 5] = complex(-0.000005779679, 0.000004095471)
    h2e[10, 4, 1, 5] = complex(-0.000343656913, -0.000024248172)
    h2e[0, 4, 3, 5] = complex(0.001241599524, -0.000000838553)
    h2e[2, 4, 3, 5] = complex(-0.128193634926, -0.005861773427)
    h2e[4, 4, 3, 5] = complex(0.042211019239, 0.000008144443)
    h2e[6, 4, 3, 5] = complex(0.000019966886, 0.000049727067)
    h2e[8, 4, 3, 5] = complex(-0.000051621944, 0.000021656910)
    h2e[10, 4, 3, 5] = complex(-0.091517474803, -0.007467112621)
    h2e[0, 4, 5, 5] = complex(0.000492616958, -0.000000428076)
    h2e[2, 4, 5, 5] = complex(-0.042167331664, -0.001919987585)
    h2e[4, 4, 5, 5] = complex(0.632865022922, -0.000000000000)
    h2e[6, 4, 5, 5] = complex(-0.000019271066, -0.000047166239)
    h2e[10, 4, 5, 5] = complex(-0.070266672482, -0.005719565179)
    h2e[0, 4, 7, 5] = complex(-0.000003432406, -0.000001306436)
    h2e[2, 4, 7, 5] = complex(-0.000053551030, -0.000001935181)
    h2e[4, 4, 7, 5] = complex(-0.000050950917, 0.000000179240)
    h2e[6, 4, 7, 5] = complex(0.008841623396, 0.021424434020)
    h2e[8, 4, 7, 5] = complex(0.019889892794, -0.007458794010)
    h2e[10, 4, 7, 5] = complex(-0.000148115770, -0.000011074591)
    h2e[0, 4, 9, 5] = complex(-0.000005605129, -0.000004331294)
    h2e[2, 4, 9, 5] = complex(0.000049234936, 0.000026641473)
    h2e[6, 4, 9, 5] = complex(-0.000434319704, 0.021238003925)
    h2e[8, 4, 9, 5] = complex(0.023109613670, 0.001227574763)
    h2e[10, 4, 9, 5] = complex(0.000012136772, 0.000007452244)
    h2e[0, 4, 11, 5] = complex(0.000344511229, 0.000000245175)
    h2e[2, 4, 11, 5] = complex(-0.091719835742, -0.004321770013)
    h2e[4, 4, 11, 5] = complex(0.070498980334, 0.000111618849)
    h2e[6, 4, 11, 5] = complex(0.000055537164, 0.000137755404)
    h2e[8, 4, 11, 5] = complex(-0.000013034352, 0.000005739584)
    h2e[10, 4, 11, 5] = complex(-0.124026784988, -0.010293224024)
    h2e[0, 6, 1, 5] = complex(0.000008754555, -0.000023427494)
    h2e[2, 6, 1, 5] = complex(-0.000003295759, 0.000001155177)
    h2e[4, 6, 1, 5] = complex(0.000000805815, 0.000001207661)
    h2e[6, 6, 1, 5] = complex(-0.000455152758, 0.000004906303)
    h2e[8, 6, 1, 5] = complex(-0.000000007118, -0.000000018130)
    h2e[10, 6, 1, 5] = complex(0.000003195954, -0.000005291317)
    h2e[0, 6, 3, 5] = complex(-0.000003830871, -0.000005214643)
    h2e[2, 6, 3, 5] = complex(0.000073223194, -0.000154235539)
    h2e[4, 6, 3, 5] = complex(0.000065506450, -0.000159499536)
    h2e[6, 6, 3, 5] = complex(0.067630245781, 0.000013048978)
    h2e[8, 6, 3, 5] = complex(0.000000003327, -0.000000146021)
    h2e[10, 6, 3, 5] = complex(0.000155779802, -0.000289865932)
    h2e[0, 6, 5, 5] = complex(-0.000001381740, 0.000000569274)
    h2e[2, 6, 5, 5] = complex(0.000048655092, -0.000103792343)
    h2e[4, 6, 5, 5] = complex(-0.000019271066, 0.000047166239)
    h2e[6, 6, 5, 5] = complex(0.599470600128, -0.000000000000)
    h2e[10, 6, 5, 5] = complex(0.000090116638, -0.000164382346)
    h2e[0, 6, 7, 5] = complex(-0.000246368151, 0.000534604698)
    h2e[2, 6, 7, 5] = complex(0.009253891653, -0.020236124823)
    h2e[4, 6, 7, 5] = complex(-0.008532919827, 0.021171205316)
    h2e[6, 6, 7, 5] = complex(0.000364225082, -0.000001281333)
    h2e[8, 6, 7, 5] = complex(-0.000003526522, 0.000052368998)
    h2e[10, 6, 7, 5] = complex(0.000945661573, -0.001879574314)
    h2e[0, 6, 9, 5] = complex(-0.002313174786, 0.001879476631)
    h2e[2, 6, 9, 5] = complex(0.016580527558, -0.012750685968)
    h2e[4, 6, 9, 5] = complex(-0.016016214269, 0.013479987641)
    h2e[8, 6, 9, 5] = complex(0.000018986094, -0.000040633879)
    h2e[10, 6, 9, 5] = complex(0.001814989163, -0.001318400798)
    h2e[0, 6, 11, 5] = complex(-0.000002333126, 0.000004912405)
    h2e[2, 6, 11, 5] = complex(0.000127996054, -0.000269991065)
    h2e[4, 6, 11, 5] = complex(0.000066883765, -0.000161893592)
    h2e[6, 6, 11, 5] = complex(0.111275222184, 0.000176178608)
    h2e[8, 6, 11, 5] = complex(-0.000000000598, -0.000000027527)
    h2e[10, 6, 11, 5] = complex(0.000159088840, -0.000286504791)
    h2e[0, 8, 1, 5] = complex(-0.000019664671, -0.000007480140)
    h2e[2, 8, 1, 5] = complex(-0.000012325376, -0.000007594884)
    h2e[4, 8, 1, 5] = complex(0.000006270143, 0.000003301777)
    h2e[6, 8, 1, 5] = complex(0.000000004674, -0.000000018924)
    h2e[8, 8, 1, 5] = complex(-0.000454979583, 0.000004904436)
    h2e[10, 8, 1, 5] = complex(0.000001156147, 0.000001579690)
    h2e[0, 8, 3, 5] = complex(0.000013054861, 0.000009332147)
    h2e[2, 8, 3, 5] = complex(-0.000139566600, -0.000067056082)
    h2e[4, 8, 3, 5] = complex(0.000051588137, 0.000021704765)
    h2e[6, 8, 3, 5] = complex(-0.000000003176, -0.000000145951)
    h2e[8, 8, 3, 5] = complex(0.067629919819, 0.000013048915)
    h2e[10, 8, 3, 5] = complex(0.000044496914, 0.000024441930)
    h2e[8, 8, 5, 5] = complex(0.599463715832, -0.000000000000)
    h2e[0, 8, 7, 5] = complex(-0.002692721253, -0.001280887945)
    h2e[2, 8, 7, 5] = complex(0.018641193207, 0.009487135210)
    h2e[4, 8, 7, 5] = complex(-0.019056868210, -0.008664003684)
    h2e[6, 8, 7, 5] = complex(-0.000000021920, 0.000050805002)
    h2e[8, 8, 7, 5] = complex(0.000364229151, -0.000001281349)
    h2e[10, 8, 7, 5] = complex(0.001970834724, 0.001071832835)
    h2e[0, 8, 9, 5] = complex(-0.000344344308, -0.000480312054)
    h2e[2, 8, 9, 5] = complex(0.013065908786, 0.018112540165)
    h2e[4, 8, 9, 5] = complex(-0.014241011320, -0.017949334702)
    h2e[6, 8, 9, 5] = complex(-0.000077418414, 0.000137701024)
    h2e[10, 8, 9, 5] = complex(0.001171244140, 0.001758036425)
    h2e[0, 8, 11, 5] = complex(-0.000001116936, -0.000001265383)
    h2e[2, 8, 11, 5] = complex(0.000037514132, 0.000019234786)
    h2e[4, 8, 11, 5] = complex(0.000012953997, 0.000005859006)
    h2e[6, 8, 11, 5] = complex(0.000000000873, -0.000000027413)
    h2e[8, 8, 11, 5] = complex(0.111272120430, 0.000176173697)
    h2e[10, 8, 11, 5] = complex(-0.000031921556, -0.000018628196)
    h2e[0, 10, 1, 5] = complex(-0.000141605671, 0.000002810174)
    h2e[2, 10, 1, 5] = complex(0.001390460177, -0.000064372167)
    h2e[4, 10, 1, 5] = complex(-0.000343076080, 0.000031651942)
    h2e[6, 10, 1, 5] = complex(-0.000002564717, -0.000002791100)
    h2e[8, 10, 1, 5] = complex(-0.000000942380, 0.000001707533)
    h2e[10, 10, 1, 5] = complex(-0.001422634196, 0.000015335234)
    h2e[0, 10, 3, 5] = complex(-0.008470341591, 0.000075209843)
    h2e[2, 10, 3, 5] = complex(0.003001853937, -0.000105981452)
    h2e[4, 10, 3, 5] = complex(-0.091520552405, 0.007431812909)
    h2e[6, 10, 3, 5] = complex(0.000114032153, 0.000202214437)
    h2e[8, 10, 3, 5] = complex(-0.000044506930, 0.000024448341)
    h2e[10, 10, 3, 5] = complex(-0.076272413760, -0.000014716449)
    h2e[0, 10, 5, 5] = complex(-0.005883397739, 0.000053375251)
    h2e[2, 10, 5, 5] = complex(-0.016157852787, 0.000573580181)
    h2e[4, 10, 5, 5] = complex(-0.070266672482, 0.005719565179)
    h2e[6, 10, 5, 5] = complex(0.000090116638, 0.000164382346)
    h2e[10, 10, 5, 5] = complex(0.574398690825, 0.000000000000)
    h2e[0, 10, 7, 5] = complex(0.000009172475, -0.000000388538)
    h2e[2, 10, 7, 5] = complex(-0.000238373850, 0.000009568168)
    h2e[4, 10, 7, 5] = complex(-0.000174570916, 0.000014421103)
    h2e[6, 10, 7, 5] = complex(-0.000851462041, -0.001957072682)
    h2e[8, 10, 7, 5] = complex(-0.002001919097, 0.001083062668)
    h2e[10, 10, 7, 5] = complex(-0.000072542815, 0.000000255204)
    h2e[0, 10, 9, 5] = complex(-0.000000396031, -0.000000422646)
    h2e[2, 10, 9, 5] = complex(0.000007305383, 0.000003475453)
    h2e[4, 10, 9, 5] = complex(-0.000013122446, -0.000005471321)
    h2e[6, 10, 9, 5] = complex(0.000004772882, -0.002267197058)
    h2e[8, 10, 9, 5] = complex(-0.002133416760, 0.000174742342)
    h2e[0, 10, 11, 5] = complex(-0.003227996066, 0.000024173843)
    h2e[2, 10, 11, 5] = complex(-0.052508690839, 0.001780746492)
    h2e[4, 10, 11, 5] = complex(-0.124058550080, 0.009900421941)
    h2e[6, 10, 11, 5] = complex(0.000192811520, 0.000356085996)
    h2e[8, 10, 11, 5] = complex(0.000032013116, -0.000018634692)
    h2e[10, 10, 11, 5] = complex(-0.025653771936, -0.000040616821)
    h2e[0, 0, 1, 7] = complex(0.000037256617, -0.000038379333)
    h2e[2, 0, 1, 7] = complex(0.000000254750, -0.000000698019)
    h2e[4, 0, 1, 7] = complex(-0.000025738776, 0.000003491454)
    h2e[6, 0, 1, 7] = complex(-0.005298716834, -0.009572071290)
    h2e[8, 0, 1, 7] = complex(0.007649515048, -0.004735742072)
    h2e[10, 0, 1, 7] = complex(-0.000006618183, 0.000000146765)
    h2e[0, 0, 3, 7] = complex(-0.000413324188, 0.000000522774)
    h2e[2, 0, 3, 7] = complex(-0.000003514587, 0.000000016909)
    h2e[4, 0, 3, 7] = complex(-0.000007252266, 0.000003025000)
    h2e[6, 0, 3, 7] = complex(-0.000873501392, -0.001928822774)
    h2e[8, 0, 3, 7] = complex(-0.005496165966, 0.002603131427)
    h2e[10, 0, 3, 7] = complex(0.000021020225, 0.000000771694)
    h2e[0, 0, 5, 7] = complex(0.000546884185, 0.000001923925)
    h2e[2, 0, 5, 7] = complex(0.000000897299, 0.000000049510)
    h2e[4, 0, 5, 7] = complex(-0.000003432406, 0.000001306436)
    h2e[6, 0, 5, 7] = complex(-0.000246368151, -0.000534604698)
    h2e[8, 0, 5, 7] = complex(-0.002692721253, 0.001280887945)
    h2e[10, 0, 5, 7] = complex(0.000009172475, 0.000000388538)
    h2e[0, 0, 7, 7] = complex(0.966780087765, 0.000000000000)
    h2e[2, 0, 7, 7] = complex(0.001608049052, 0.000026601666)
    h2e[4, 0, 7, 7] = complex(-0.000455179029, -0.000000395543)
    h2e[6, 0, 7, 7] = complex(0.000001352515, 0.000000557234)
    h2e[10, 0, 7, 7] = complex(-0.001604748401, -0.000014558568)
    h2e[4, 0, 9, 7] = complex(-0.000000014931, -0.000000012531)
    h2e[6, 0, 9, 7] = complex(0.000003727333, -0.000007979126)
    h2e[8, 0, 9, 7] = complex(-0.000001464361, 0.000003640852)
    h2e[10, 0, 9, 7] = complex(-0.000000000542, -0.000000002124)
    h2e[0, 0, 11, 7] = complex(-0.000604236288, 0.000016482583)
    h2e[2, 0, 11, 7] = complex(-0.000001462035, -0.000000002002)
    h2e[4, 0, 11, 7] = complex(0.000003665727, -0.000000964602)
    h2e[6, 0, 11, 7] = complex(0.000828359392, 0.001918779604)
    h2e[8, 0, 11, 7] = complex(0.000681763608, -0.000320003919)
    h2e[10, 0, 11, 7] = complex(0.000009707665, -0.000000336000)
    h2e[0, 2, 1, 7] = complex(0.000001198102, -0.000000788525)
    h2e[2, 2, 1, 7] = complex(0.000002985010, -0.000003074962)
    h2e[4, 2, 1, 7] = complex(0.000008751222, -0.000000292024)
    h2e[6, 2, 1, 7] = complex(0.000982607906, 0.001875591554)
    h2e[8, 2, 1, 7] = complex(0.005335585955, -0.002912554296)
    h2e[10, 2, 1, 7] = complex(-0.000000744613, 0.000003289445)
    h2e[0, 2, 3, 7] = complex(-0.000003365354, -0.000000010168)
    h2e[2, 2, 3, 7] = complex(-0.000001061503, 0.000000001342)
    h2e[4, 2, 3, 7] = complex(0.000493437741, -0.000022356818)
    h2e[6, 2, 3, 7] = complex(0.025783908691, 0.056395167589)
    h2e[8, 2, 3, 7] = complex(0.052922253023, -0.026840401652)
    h2e[10, 2, 3, 7] = complex(0.000050309760, 0.000001133938)
    h2e[0, 2, 5, 7] = complex(0.000000921709, -0.000000044392)
    h2e[2, 2, 5, 7] = complex(0.000191253574, 0.000000672825)
    h2e[4, 2, 5, 7] = complex(-0.000053551030, 0.000001935181)
    h2e[6, 2, 5, 7] = complex(0.009253891653, 0.020236124823)
    h2e[8, 2, 5, 7] = complex(0.018641193207, -0.009487135210)
    h2e[10, 2, 5, 7] = complex(-0.000238373850, -0.000009568168)
    h2e[0, 2, 7, 7] = complex(0.001608049052, -0.000026601666)
    h2e[2, 2, 7, 7] = complex(0.652882649497, -0.000000000000)
    h2e[4, 2, 7, 7] = complex(-0.067560249795, 0.003076192772)
    h2e[6, 2, 7, 7] = complex(0.000092932787, 0.000198246696)
    h2e[10, 2, 7, 7] = complex(-0.104437556596, -0.003707380766)
    h2e[4, 2, 9, 7] = complex(0.000000135733, 0.000000053744)
    h2e[6, 2, 9, 7] = complex(0.000002429155, 0.000055854007)
    h2e[8, 2, 9, 7] = complex(0.000062900181, -0.000000128295)
    h2e[10, 2, 9, 7] = complex(0.000000018736, 0.000000010552)
    h2e[0, 2, 11, 7] = complex(-0.000001670167, 0.000000086458)
    h2e[2, 2, 11, 7] = complex(-0.000172766481, 0.000004712788)
    h2e[4, 2, 11, 7] = complex(0.000231313478, -0.000019699873)
    h2e[6, 2, 11, 7] = complex(-0.007843153846, -0.017200458660)
    h2e[8, 2, 11, 7] = complex(-0.017741822266, 0.008806683007)
    h2e[10, 2, 11, 7] = complex(0.000155897548, 0.000001034749)
    h2e[0, 4, 1, 7] = complex(0.000025008419, 0.000000262138)
    h2e[2, 4, 1, 7] = complex(-0.000003168696, -0.000005641581)
    h2e[4, 4, 1, 7] = complex(-0.000001040911, 0.000001072279)
    h2e[6, 4, 1, 7] = complex(-0.000252578389, -0.000531698793)
    h2e[8, 4, 1, 7] = complex(-0.002676382358, 0.001311559176)
    h2e[10, 4, 1, 7] = complex(0.000005437311, 0.000000104121)
    h2e[0, 4, 3, 7] = complex(0.000002412440, -0.000002525193)
    h2e[2, 4, 3, 7] = complex(0.000170600949, 0.000006749310)
    h2e[4, 4, 3, 7] = complex(-0.000114630482, 0.000000144988)
    h2e[6, 4, 3, 7] = complex(-0.008319882669, -0.020637703624)
    h2e[8, 4, 3, 7] = complex(-0.019054961743, 0.008625677897)
    h2e[10, 4, 3, 7] = complex(0.000297904585, 0.000023043941)
    h2e[0, 4, 5, 7] = complex(-0.000000822919, -0.000001196072)
    h2e[2, 4, 5, 7] = complex(-0.000172233746, -0.000008169084)
    h2e[4, 4, 5, 7] = complex(-0.000050950917, -0.000000179240)
    h2e[6, 4, 5, 7] = complex(-0.008532919827, -0.021171205316)
    h2e[8, 4, 5, 7] = complex(-0.019056868210, 0.008664003684)
    h2e[10, 4, 5, 7] = complex(-0.000174570916, -0.000014421103)
    h2e[0, 4, 7, 7] = complex(-0.000455179029, 0.000000395543)
    h2e[2, 4, 7, 7] = complex(-0.067560249795, -0.003076192772)
    h2e[4, 4, 7, 7] = complex(0.599470600126, -0.000000000000)
    h2e[6, 4, 7, 7] = complex(0.000137760154, 0.000337170125)
    h2e[10, 4, 7, 7] = complex(-0.110908548681, -0.009027731791)
    h2e[0, 4, 9, 7] = complex(0.000000013473, 0.000000014066)
    h2e[2, 4, 9, 7] = complex(-0.000000130394, -0.000000065807)
    h2e[6, 4, 9, 7] = complex(-0.000000743654, -0.000052482333)
    h2e[8, 4, 9, 7] = complex(0.000044768811, 0.000002708777)
    h2e[10, 4, 9, 7] = complex(-0.000000023487, -0.000000014367)
    h2e[0, 4, 11, 7] = complex(-0.000006161429, 0.000000498956)
    h2e[2, 4, 11, 7] = complex(0.000328956047, 0.000008804781)
    h2e[4, 4, 11, 7] = complex(-0.000187393792, 0.000005111798)
    h2e[6, 4, 11, 7] = complex(-0.000786966517, -0.001951348024)
    h2e[8, 4, 11, 7] = complex(-0.002052598771, 0.000905099224)
    h2e[10, 4, 11, 7] = complex(0.000327299146, 0.000016417140)
    h2e[0, 6, 1, 7] = complex(0.004118512800, -0.010318943854)
    h2e[2, 6, 1, 7] = complex(-0.002998161668, 0.001142293055)
    h2e[4, 6, 1, 7] = complex(0.001199090274, -0.000227416760)
    h2e[6, 6, 1, 7] = complex(0.000001018896, -0.000001049600)
    h2e[8, 6, 1, 7] = complex(-0.000001741802, -0.000007760847)
    h2e[10, 6, 1, 7] = complex(0.001478509285, -0.001670983247)
    h2e[0, 6, 3, 7] = complex(-0.001219610551, -0.002967550577)
    h2e[2, 6, 3, 7] = complex(-0.026638060936, 0.057012536852)
    h2e[4, 6, 3, 7] = complex(0.008819785101, -0.020793187294)
    h2e[6, 6, 3, 7] = complex(-0.000218947889, 0.000000276924)
    h2e[8, 6, 3, 7] = complex(-0.000000249538, -0.000054219757)
    h2e[10, 6, 3, 7] = complex(0.007833867161, -0.017495780966)
    h2e[0, 6, 5, 7] = complex(-0.000701382928, -0.000998798157)
    h2e[2, 6, 5, 7] = complex(-0.009360614668, 0.020555391997)
    h2e[4, 6, 5, 7] = complex(0.008841623396, -0.021424434020)
    h2e[6, 6, 5, 7] = complex(0.000364225082, 0.000001281333)
    h2e[8, 6, 5, 7] = complex(-0.000000021920, -0.000050805002)
    h2e[10, 6, 5, 7] = complex(-0.000851462041, 0.001957072682)
    h2e[0, 6, 7, 7] = complex(0.000001352515, -0.000000557234)
    h2e[2, 6, 7, 7] = complex(0.000092932787, -0.000198246696)
    h2e[4, 6, 7, 7] = complex(0.000137760154, -0.000337170125)
    h2e[6, 6, 7, 7] = complex(0.721692913237, 0.000000000000)
    h2e[10, 6, 7, 7] = complex(0.000166604669, -0.000303904658)
    h2e[0, 6, 9, 7] = complex(0.000006879495, -0.000003992138)
    h2e[2, 6, 9, 7] = complex(-0.000042001727, 0.000034288470)
    h2e[4, 6, 9, 7] = complex(0.000037705700, -0.000034050389)
    h2e[8, 6, 9, 7] = complex(0.017243359349, -0.036206627419)
    h2e[10, 6, 9, 7] = complex(-0.000002103690, 0.000001533761)
    h2e[0, 6, 11, 7] = complex(-0.000288322721, 0.002212474788)
    h2e[2, 6, 11, 7] = complex(0.009026806080, -0.016911197431)
    h2e[4, 6, 11, 7] = complex(0.000938368913, -0.001916920676)
    h2e[6, 6, 11, 7] = complex(-0.000346447461, 0.000009450523)
    h2e[8, 6, 11, 7] = complex(-0.000000057667, -0.000002602808)
    h2e[10, 6, 11, 7] = complex(-0.006812995103, 0.013273970165)
    h2e[0, 8, 1, 7] = complex(-0.008732482467, -0.002769967174)
    h2e[2, 8, 1, 7] = complex(-0.004863318535, -0.004264415350)
    h2e[4, 8, 1, 7] = complex(0.002524293436, 0.001854152675)
    h2e[6, 8, 1, 7] = complex(0.000003203498, -0.000008203479)
    h2e[8, 8, 1, 7] = complex(0.000001018499, -0.000001049192)
    h2e[10, 8, 1, 7] = complex(0.000345265592, 0.001060673815)
    h2e[0, 8, 3, 7] = complex(0.004544632460, 0.004578964606)
    h2e[2, 8, 3, 7] = complex(-0.054801280376, -0.024785980317)
    h2e[4, 8, 3, 7] = complex(0.019773698445, 0.007661285660)
    h2e[6, 8, 3, 7] = complex(-0.000002841044, -0.000055834571)
    h2e[8, 8, 3, 7] = complex(-0.000218946480, 0.000000276924)
    h2e[10, 8, 3, 7] = complex(0.017577256567, 0.009729039571)
    h2e[0, 8, 5, 7] = complex(0.002282685927, 0.002143098064)
    h2e[2, 8, 5, 7] = complex(-0.019421736214, -0.008541019722)
    h2e[4, 8, 5, 7] = complex(0.019889892794, 0.007458794010)
    h2e[6, 8, 5, 7] = complex(-0.000003526522, -0.000052368998)
    h2e[8, 8, 5, 7] = complex(0.000364229151, 0.000001281349)
    h2e[10, 8, 5, 7] = complex(-0.002001919097, -0.001083062668)
    h2e[8, 8, 7, 7] = complex(0.721688265776, -0.000000000000)
    h2e[0, 8, 9, 7] = complex(0.000001965994, 0.000000370681)
    h2e[2, 8, 9, 7] = complex(-0.000031999579, -0.000044221893)
    h2e[4, 8, 9, 7] = complex(0.000097754093, 0.000124093996)
    h2e[6, 8, 9, 7] = complex(-0.019815019120, 0.034852539264)
    h2e[10, 8, 9, 7] = complex(0.000007231424, 0.000010205913)
    h2e[0, 8, 11, 7] = complex(-0.000349143701, -0.000965557749)
    h2e[2, 8, 11, 7] = complex(0.017785396415, 0.009195380475)
    h2e[4, 8, 11, 7] = complex(0.002067156116, 0.000931166401)
    h2e[6, 8, 11, 7] = complex(0.000000077714, -0.000002664394)
    h2e[8, 8, 11, 7] = complex(-0.000346440707, 0.000009450339)
    h2e[10, 8, 11, 7] = complex(-0.012165576622, -0.007590678741)
    h2e[0, 10, 1, 7] = complex(0.000007239879, -0.000001196043)
    h2e[2, 10, 1, 7] = complex(-0.000005383685, 0.000003065339)
    h2e[4, 10, 1, 7] = complex(-0.000004107857, -0.000001076021)
    h2e[6, 10, 1, 7] = complex(-0.001005627124, -0.001832104948)
    h2e[8, 10, 1, 7] = complex(-0.000648241799, 0.000382695423)
    h2e[10, 10, 1, 7] = complex(0.000003111333, -0.000003205092)
    h2e[0, 10, 3, 7] = complex(0.000017685497, -0.000000948316)
    h2e[2, 10, 3, 7] = complex(0.000004471559, 0.000000487878)
    h2e[4, 10, 3, 7] = complex(0.000217680171, -0.000017080851)
    h2e[6, 10, 3, 7] = complex(-0.008475884014, -0.016897639791)
    h2e[8, 10, 3, 7] = complex(-0.017402900486, 0.009458843070)
    h2e[10, 10, 3, 7] = complex(0.000184782601, -0.000000233714)
    h2e[0, 10, 5, 7] = complex(0.000007278147, -0.000000377309)
    h2e[2, 10, 5, 7] = complex(-0.000253212315, 0.000008394669)
    h2e[4, 10, 5, 7] = complex(-0.000148115770, 0.000011074591)
    h2e[6, 10, 5, 7] = complex(0.000945661573, 0.001879574314)
    h2e[8, 10, 5, 7] = complex(0.001970834724, -0.001071832835)
    h2e[10, 10, 5, 7] = complex(-0.000072542815, -0.000000255204)
    h2e[0, 10, 7, 7] = complex(-0.001604748401, 0.000014558568)
    h2e[2, 10, 7, 7] = complex(-0.104437556596, 0.003707380766)
    h2e[4, 10, 7, 7] = complex(-0.110908548681, 0.009027731791)
    h2e[6, 10, 7, 7] = complex(0.000166604669, 0.000303904658)
    h2e[10, 10, 7, 7] = complex(0.551545232675, -0.000000000000)
    h2e[0, 10, 9, 7] = complex(0.000000000742, 0.000000001875)
    h2e[2, 10, 9, 7] = complex(-0.000000019321, -0.000000009272)
    h2e[4, 10, 9, 7] = complex(0.000000025331, 0.000000010516)
    h2e[6, 10, 9, 7] = complex(0.000000001527, 0.000002665527)
    h2e[8, 10, 9, 7] = complex(0.000017432232, -0.000000304948)
    h2e[0, 10, 11, 7] = complex(0.000009202588, -0.000000096328)
    h2e[2, 10, 11, 7] = complex(0.000172578575, -0.000010563674)
    h2e[4, 10, 11, 7] = complex(0.000402711477, -0.000042390858)
    h2e[6, 10, 11, 7] = complex(0.006512665486, 0.013236276959)
    h2e[8, 10, 11, 7] = complex(0.012442855594, -0.006731490137)
    h2e[10, 10, 11, 7] = complex(0.000103001333, -0.000002809709)
    h2e[2, 0, 1, 9] = complex(0.000000363054, -0.000000204157)
    h2e[4, 0, 1, 9] = complex(0.000017917228, -0.000011022995)
    h2e[6, 0, 1, 9] = complex(0.007564729087, 0.004870031538)
    h2e[8, 0, 1, 9] = complex(-0.005729356340, 0.009381436134)
    h2e[10, 0, 1, 9] = complex(0.000006314846, -0.000003500626)
    h2e[2, 0, 3, 9] = complex(-0.000000254266, 0.000000195068)
    h2e[4, 0, 3, 9] = complex(-0.000011257003, 0.000009092414)
    h2e[6, 0, 3, 9] = complex(-0.004711350170, -0.003841175549)
    h2e[8, 0, 3, 9] = complex(-0.001250019411, 0.001719512254)
    h2e[10, 0, 3, 9] = complex(-0.000000467220, 0.000000756421)
    h2e[2, 0, 5, 9] = complex(-0.000000129950, 0.000000094349)
    h2e[4, 0, 5, 9] = complex(-0.000005605129, 0.000004331294)
    h2e[6, 0, 5, 9] = complex(-0.002313174786, -0.001879476631)
    h2e[8, 0, 5, 9] = complex(-0.000344344308, 0.000480312054)
    h2e[10, 0, 5, 9] = complex(-0.000000396031, 0.000000422646)
    h2e[4, 0, 7, 9] = complex(0.000000013473, -0.000000014066)
    h2e[6, 0, 7, 9] = complex(0.000006879495, 0.000003992138)
    h2e[8, 0, 7, 9] = complex(0.000001965994, -0.000000370681)
    h2e[10, 0, 7, 9] = complex(0.000000000742, -0.000000001875)
    h2e[0, 0, 9, 9] = complex(0.966731902319, 0.000000000000)
    h2e[2, 0, 9, 9] = complex(0.001607436821, 0.000026591538)
    h2e[4, 0, 9, 9] = complex(-0.000455005844, -0.000000395393)
    h2e[6, 0, 9, 9] = complex(0.000001351989, 0.000000557017)
    h2e[10, 0, 9, 9] = complex(-0.001604043452, -0.000014552173)
    h2e[2, 0, 11, 9] = complex(0.000000012541, -0.000000031740)
    h2e[4, 0, 11, 9] = complex(0.000001012211, -0.000001667087)
    h2e[6, 0, 11, 9] = complex(0.000581782191, 0.000477705664)
    h2e[8, 0, 11, 9] = complex(0.001263638010, -0.001675094107)
    h2e[10, 0, 11, 9] = complex(-0.000000592766, 0.000000073861)
    h2e[0, 2, 1, 9] = complex(-0.000000367579, 0.000000196239)
    h2e[4, 2, 1, 9] = complex(0.000011897673, -0.000010793329)
    h2e[6, 2, 1, 9] = complex(0.004925924106, 0.003566427522)
    h2e[8, 2, 1, 9] = complex(0.001149418393, -0.001788325552)
    h2e[10, 2, 1, 9] = complex(0.000000255998, -0.000000473125)
    h2e[0, 2, 3, 9] = complex(0.000000256661, -0.000000192969)
    h2e[4, 2, 3, 9] = complex(0.000135905999, -0.000074266718)
    h2e[6, 2, 3, 9] = complex(0.046987912799, 0.036239592714)
    h2e[8, 2, 3, 9] = complex(0.036417420246, -0.050475108726)
    h2e[10, 2, 3, 9] = complex(0.000022062689, -0.000010590697)
    h2e[0, 2, 5, 9] = complex(0.000000131182, -0.000000093052)
    h2e[4, 2, 5, 9] = complex(0.000049234936, -0.000026641473)
    h2e[6, 2, 5, 9] = complex(0.016580527558, 0.012750685968)
    h2e[8, 2, 5, 9] = complex(0.013065908786, -0.018112540165)
    h2e[10, 2, 5, 9] = complex(0.000007305383, -0.000003475453)
    h2e[4, 2, 7, 9] = complex(-0.000000130394, 0.000000065807)
    h2e[6, 2, 7, 9] = complex(-0.000042001727, -0.000034288470)
    h2e[8, 2, 7, 9] = complex(-0.000031999579, 0.000044221893)
    h2e[10, 2, 7, 9] = complex(-0.000000019321, 0.000000009272)
    h2e[0, 2, 9, 9] = complex(0.001607436821, -0.000026591538)
    h2e[2, 2, 9, 9] = complex(0.652877324645, 0.000000000000)
    h2e[4, 2, 9, 9] = complex(-0.067559924170, 0.003076177945)
    h2e[6, 2, 9, 9] = complex(0.000092932186, 0.000198245421)
    h2e[10, 2, 9, 9] = complex(-0.104436066373, -0.003707327865)
    h2e[0, 2, 11, 9] = complex(-0.000000012653, 0.000000032516)
    h2e[4, 2, 11, 9] = complex(-0.000044111039, 0.000025155603)
    h2e[6, 2, 11, 9] = complex(-0.015579606707, -0.012231374118)
    h2e[8, 2, 11, 9] = complex(-0.011117061727, 0.015375746436)
    h2e[10, 2, 11, 9] = complex(-0.000007141894, 0.000003595706)
    h2e[0, 4, 1, 9] = complex(-0.000019036687, 0.000008958590)
    h2e[2, 4, 1, 9] = complex(-0.000012874977, 0.000009578795)
    h2e[6, 4, 1, 9] = complex(-0.002335988522, -0.001853261800)
    h2e[8, 4, 1, 9] = complex(-0.000338726386, 0.000484290313)
    h2e[10, 4, 1, 9] = complex(0.000001139636, -0.000001244978)
    h2e[0, 4, 3, 9] = complex(0.000012178673, -0.000007827971)
    h2e[2, 4, 3, 9] = complex(-0.000142033011, 0.000061660189)
    h2e[6, 4, 3, 9] = complex(-0.015980900823, -0.013494837084)
    h2e[8, 4, 3, 9] = complex(-0.013879618965, 0.017496807164)
    h2e[10, 4, 3, 9] = complex(0.000038856908, -0.000016353219)
    h2e[0, 4, 5, 9] = complex(0.000006043483, -0.000003700372)
    h2e[2, 4, 5, 9] = complex(-0.000051426648, 0.000022084669)
    h2e[6, 4, 5, 9] = complex(-0.016016214269, -0.013479987641)
    h2e[8, 4, 5, 9] = complex(-0.014241011320, 0.017949334702)
    h2e[10, 4, 5, 9] = complex(-0.000013122446, 0.000005471321)
    h2e[0, 4, 7, 9] = complex(-0.000000014931, 0.000000012531)
    h2e[2, 4, 7, 9] = complex(0.000000135733, -0.000000053744)
    h2e[6, 4, 7, 9] = complex(0.000037705700, 0.000034050389)
    h2e[8, 4, 7, 9] = complex(0.000097754093, -0.000124093996)
    h2e[10, 4, 7, 9] = complex(0.000000025331, -0.000000010516)
    h2e[0, 4, 9, 9] = complex(-0.000455005844, 0.000000395393)
    h2e[2, 4, 9, 9] = complex(-0.067559924170, -0.003076177945)
    h2e[4, 4, 9, 9] = complex(0.599463715830, -0.000000000000)
    h2e[6, 4, 9, 9] = complex(0.000137761695, 0.000337173891)
    h2e[10, 4, 9, 9] = complex(-0.110905457147, -0.009027480147)
    h2e[0, 4, 11, 9] = complex(-0.000001184524, 0.000001558524)
    h2e[2, 4, 11, 9] = complex(0.000046212223, -0.000021019370)
    h2e[6, 4, 11, 9] = complex(-0.001699838550, -0.001464091542)
    h2e[8, 4, 11, 9] = complex(-0.001312634267, 0.001655142347)
    h2e[10, 4, 11, 9] = complex(-0.000033811537, 0.000014925662)
    h2e[0, 6, 1, 9] = complex(-0.000072076478, 0.009160991918)
    h2e[2, 6, 1, 9] = complex(0.002611692426, 0.005899123995)
    h2e[4, 6, 1, 9] = complex(-0.001297243789, -0.002849681200)
    h2e[8, 6, 1, 9] = complex(0.000000384496, -0.000001963338)
    h2e[10, 6, 1, 9] = complex(-0.000746726841, -0.000704700025)
    h2e[0, 6, 3, 9] = complex(-0.002202753595, -0.006081527914)
    h2e[2, 6, 3, 9] = complex(-0.000298324396, 0.060145125816)
    h2e[4, 6, 3, 9] = complex(-0.000642550653, -0.021207073933)
    h2e[8, 6, 3, 9] = complex(-0.000026518853, -0.000047710580)
    h2e[10, 6, 3, 9] = complex(-0.000207146432, -0.020020800143)
    h2e[0, 6, 5, 9] = complex(-0.000946047995, -0.002985788444)
    h2e[2, 6, 5, 9] = complex(-0.000304971792, 0.021203807234)
    h2e[4, 6, 5, 9] = complex(-0.000434319704, -0.021238003925)
    h2e[8, 6, 5, 9] = complex(-0.000077418414, -0.000137701024)
    h2e[10, 6, 5, 9] = complex(0.000004772882, 0.002267197058)
    h2e[0, 6, 7, 9] = complex(0.000003727333, 0.000007979126)
    h2e[2, 6, 7, 9] = complex(0.000002429155, -0.000055854007)
    h2e[4, 6, 7, 9] = complex(-0.000000743654, 0.000052482333)
    h2e[8, 6, 7, 9] = complex(-0.019815019120, -0.034852539264)
    h2e[10, 6, 7, 9] = complex(0.000000001527, -0.000002665527)
    h2e[0, 6, 9, 9] = complex(0.000001351989, -0.000000557017)
    h2e[2, 6, 9, 9] = complex(0.000092932186, -0.000198245421)
    h2e[4, 6, 9, 9] = complex(0.000137761695, -0.000337173891)
    h2e[6, 6, 9, 9] = complex(0.721688265776, 0.000000000000)
    h2e[10, 6, 9, 9] = complex(0.000166601421, -0.000303898733)
    h2e[0, 6, 11, 9] = complex(0.000835523386, 0.000739011426)
    h2e[2, 6, 11, 9] = complex(-0.000777379079, -0.020075105020)
    h2e[4, 6, 11, 9] = complex(-0.000170065985, -0.002269753814)
    h2e[8, 6, 11, 9] = complex(0.000005777723, 0.000011093785)
    h2e[10, 6, 11, 9] = complex(0.000772671832, 0.014318611547)
    h2e[0, 8, 1, 9] = complex(0.011077246925, -0.000717897807)
    h2e[2, 8, 1, 9] = complex(-0.001996127079, 0.002105538420)
    h2e[4, 8, 1, 9] = complex(0.000489974340, -0.000921247325)
    h2e[6, 8, 1, 9] = complex(-0.000003892807, 0.000000496194)
    h2e[10, 8, 1, 9] = complex(0.002092432270, -0.000751746184)
    h2e[0, 8, 3, 9] = complex(0.002142606082, 0.001956285889)
    h2e[2, 8, 3, 9] = complex(-0.062887052112, 0.000463842959)
    h2e[4, 8, 3, 9] = complex(0.022519781316, -0.001378779832)
    h2e[6, 8, 3, 9] = complex(-0.000027579131, -0.000056531769)
    h2e[10, 8, 3, 9] = complex(0.019171671805, 0.001392397595)
    h2e[0, 8, 5, 9] = complex(0.000594840106, 0.000857284510)
    h2e[2, 8, 5, 9] = complex(-0.022561944344, -0.000015872114)
    h2e[4, 8, 5, 9] = complex(0.023109613670, -0.001227574763)
    h2e[6, 8, 5, 9] = complex(0.000018986094, 0.000040633879)
    h2e[10, 8, 5, 9] = complex(-0.002133416760, -0.000174742342)
    h2e[0, 8, 7, 9] = complex(-0.000001464361, -0.000003640852)
    h2e[2, 8, 7, 9] = complex(0.000062900181, 0.000000128295)
    h2e[4, 8, 7, 9] = complex(0.000044768811, -0.000002708777)
    h2e[6, 8, 7, 9] = complex(0.017243359349, 0.036206627419)
    h2e[10, 8, 7, 9] = complex(0.000017432232, 0.000000304948)
    h2e[8, 8, 9, 9] = complex(0.721683619311, -0.000000000000)
    h2e[0, 8, 11, 9] = complex(-0.002117446638, -0.000678096487)
    h2e[2, 8, 11, 9] = complex(0.019198007640, -0.000963469427)
    h2e[4, 8, 11, 9] = complex(0.002128758164, -0.000224478579)
    h2e[6, 8, 11, 9] = complex(-0.000007303357, -0.000015831509)
    h2e[10, 8, 11, 9] = complex(-0.015006221799, -0.000446302612)
    h2e[0, 10, 1, 9] = complex(-0.000006183003, 0.000003755374)
    h2e[2, 10, 1, 9] = complex(-0.000000167352, 0.000000578002)
    h2e[4, 10, 1, 9] = complex(-0.000000783880, 0.000001617682)
    h2e[6, 10, 1, 9] = complex(-0.000624533828, -0.000420905719)
    h2e[8, 10, 1, 9] = complex(-0.001100027965, 0.001786801546)
    h2e[0, 10, 3, 9] = complex(0.000000333306, -0.000000960593)
    h2e[2, 10, 3, 9] = complex(-0.000021339296, 0.000012059918)
    h2e[4, 10, 3, 9] = complex(-0.000035884723, 0.000022267982)
    h2e[6, 10, 3, 9] = complex(-0.016022645004, -0.011644946127)
    h2e[8, 10, 3, 9] = complex(-0.010538974889, 0.015777599569)
    h2e[0, 10, 5, 9] = complex(0.000000332601, -0.000000522246)
    h2e[2, 10, 5, 9] = complex(-0.000007072568, 0.000003953108)
    h2e[4, 10, 5, 9] = complex(0.000012136772, -0.000007452244)
    h2e[6, 10, 5, 9] = complex(0.001814989163, 0.001318400798)
    h2e[8, 10, 5, 9] = complex(0.001171244140, -0.001758036425)
    h2e[0, 10, 7, 9] = complex(-0.000000000542, 0.000000002124)
    h2e[2, 10, 7, 9] = complex(0.000000018736, -0.000000010552)
    h2e[4, 10, 7, 9] = complex(-0.000000023487, 0.000000014367)
    h2e[6, 10, 7, 9] = complex(-0.000002103690, -0.000001533761)
    h2e[8, 10, 7, 9] = complex(0.000007231424, -0.000010205913)
    h2e[0, 10, 9, 9] = complex(-0.001604043452, 0.000014552173)
    h2e[2, 10, 9, 9] = complex(-0.104436066373, 0.003707327865)
    h2e[4, 10, 9, 9] = complex(-0.110905457147, 0.009027480147)
    h2e[6, 10, 9, 9] = complex(0.000166601421, 0.000303898733)
    h2e[10, 10, 9, 9] = complex(0.551538006028, 0.000000000000)
    h2e[0, 10, 11, 9] = complex(0.000000623391, -0.000000039509)
    h2e[2, 10, 11, 9] = complex(0.000006872153, -0.000004119673)
    h2e[4, 10, 11, 9] = complex(0.000030979570, -0.000020306591)
    h2e[6, 10, 11, 9] = complex(0.011427593971, 0.008339527028)
    h2e[8, 10, 11, 9] = complex(0.008319693189, -0.012250725405)
    h2e[0, 0, 1, 11] = complex(0.062770336469, -0.005372283708)
    h2e[2, 0, 1, 11] = complex(0.001530882569, -0.000105548093)
    h2e[4, 0, 1, 11] = complex(0.000141159952, -0.000011958417)
    h2e[6, 0, 1, 11] = complex(0.000003152606, 0.000005820907)
    h2e[8, 0, 1, 11] = complex(-0.000006207988, 0.000003686806)
    h2e[10, 0, 1, 11] = complex(-0.004477209496, 0.000342304304)
    h2e[0, 0, 3, 11] = complex(-0.202690975409, 0.000329260552)
    h2e[2, 0, 3, 11] = complex(-0.000538825227, -0.000008038187)
    h2e[4, 0, 3, 11] = complex(0.001391960426, -0.000001052012)
    h2e[6, 0, 3, 11] = complex(-0.000003309242, 0.000000651010)
    h2e[8, 0, 3, 11] = complex(0.000000268963, -0.000000465877)
    h2e[10, 0, 3, 11] = complex(-0.004874393509, -0.000036302647)
    h2e[0, 0, 5, 11] = complex(0.213867894708, -0.000338610404)
    h2e[2, 0, 5, 11] = complex(0.000655086473, 0.000009799555)
    h2e[4, 0, 5, 11] = complex(0.000344511229, -0.000000245175)
    h2e[6, 0, 5, 11] = complex(-0.000002333126, -0.000004912405)
    h2e[8, 0, 5, 11] = complex(-0.000001116936, 0.000001265383)
    h2e[10, 0, 5, 11] = complex(-0.003227996066, -0.000024173843)
    h2e[0, 0, 7, 11] = complex(-0.000604236288, -0.000016482583)
    h2e[2, 0, 7, 11] = complex(-0.000001670167, -0.000000086458)
    h2e[4, 0, 7, 11] = complex(-0.000006161429, -0.000000498956)
    h2e[6, 0, 7, 11] = complex(-0.000288322721, -0.002212474788)
    h2e[8, 0, 7, 11] = complex(-0.000349143701, 0.000965557749)
    h2e[10, 0, 7, 11] = complex(0.000009202588, 0.000000096328)
    h2e[2, 0, 9, 11] = complex(-0.000000012653, -0.000000032516)
    h2e[4, 0, 9, 11] = complex(-0.000001184524, -0.000001558524)
    h2e[6, 0, 9, 11] = complex(0.000835523386, -0.000739011426)
    h2e[8, 0, 9, 11] = complex(-0.002117446638, 0.000678096487)
    h2e[10, 0, 9, 11] = complex(0.000000623391, 0.000000039509)
    h2e[0, 0, 11, 11] = complex(0.764008571323, 0.000000000000)
    h2e[2, 0, 11, 11] = complex(0.001065703095, 0.000017629734)
    h2e[4, 0, 11, 11] = complex(-0.001422716309, -0.000001236317)
    h2e[6, 0, 11, 11] = complex(0.000004130085, 0.000001701588)
    h2e[10, 0, 11, 11] = complex(0.003947281852, 0.000035810456)
    h2e[0, 2, 1, 11] = complex(0.001526553140, -0.000156126662)
    h2e[2, 2, 1, 11] = complex(-0.001630334179, 0.000139534344)
    h2e[4, 2, 1, 11] = complex(-0.008398221640, 0.001105473586)
    h2e[6, 2, 1, 11] = complex(0.000009989142, 0.000018511143)
    h2e[8, 2, 1, 11] = complex(-0.000000399668, 0.000000794187)
    h2e[10, 2, 1, 11] = complex(0.004868462440, -0.000243111991)
    h2e[0, 2, 3, 11] = complex(-0.000538796536, 0.000009788723)
    h2e[2, 2, 3, 11] = complex(-0.092407510400, 0.000150111014)
    h2e[4, 2, 3, 11] = complex(-0.003000508097, 0.000141505421)
    h2e[6, 2, 3, 11] = complex(-0.000021963928, -0.000045276303)
    h2e[8, 2, 3, 11] = complex(-0.000021738097, 0.000011241895)
    h2e[10, 2, 3, 11] = complex(0.086457433181, 0.002928498383)
    h2e[0, 2, 5, 11] = complex(0.000655052610, -0.000011873855)
    h2e[2, 2, 5, 11] = complex(0.058557914955, -0.000092712931)
    h2e[4, 2, 5, 11] = complex(-0.091719835742, 0.004321770013)
    h2e[6, 2, 5, 11] = complex(0.000127996054, 0.000269991065)
    h2e[8, 2, 5, 11] = complex(0.000037514132, -0.000019234786)
    h2e[10, 2, 5, 11] = complex(-0.052508690839, -0.001780746492)
    h2e[0, 2, 7, 11] = complex(-0.000001462035, 0.000000002002)
    h2e[2, 2, 7, 11] = complex(-0.000172766481, -0.000004712788)
    h2e[4, 2, 7, 11] = complex(0.000328956047, -0.000008804781)
    h2e[6, 2, 7, 11] = complex(0.009026806080, 0.016911197431)
    h2e[8, 2, 7, 11] = complex(0.017785396415, -0.009195380475)
    h2e[10, 2, 7, 11] = complex(0.000172578575, 0.000010563674)
    h2e[0, 2, 9, 11] = complex(0.000000012541, 0.000000031740)
    h2e[4, 2, 9, 11] = complex(0.000046212223, 0.000021019370)
    h2e[6, 2, 9, 11] = complex(-0.000777379079, 0.020075105020)
    h2e[8, 2, 9, 11] = complex(0.019198007640, 0.000963469427)
    h2e[10, 2, 9, 11] = complex(0.000006872153, 0.000004119673)
    h2e[0, 2, 11, 11] = complex(0.001065703095, -0.000017629734)
    h2e[2, 2, 11, 11] = complex(0.600972926145, 0.000000000000)
    h2e[4, 2, 11, 11] = complex(0.076193473302, -0.003469285749)
    h2e[6, 2, 11, 11] = complex(-0.000078431273, -0.000167311684)
    h2e[10, 2, 11, 11] = complex(-0.033380952992, -0.001184975090)
    h2e[0, 4, 1, 11] = complex(0.000141106998, -0.000012201570)
    h2e[2, 4, 1, 11] = complex(-0.008463941399, 0.000337696876)
    h2e[4, 4, 1, 11] = complex(0.005862208617, -0.000501725012)
    h2e[6, 4, 1, 11] = complex(-0.000003939580, -0.000008292464)
    h2e[8, 4, 1, 11] = complex(0.000000378207, -0.000000438668)
    h2e[10, 4, 1, 11] = complex(-0.003228058658, 0.000013426742)
    h2e[0, 4, 3, 11] = complex(0.001391945125, -0.000003470909)
    h2e[2, 4, 3, 11] = complex(-0.003000833341, -0.000131751202)
    h2e[4, 4, 3, 11] = complex(-0.016168008881, 0.000026264058)
    h2e[6, 4, 3, 11] = complex(-0.000090343959, -0.000220797671)
    h2e[8, 4, 3, 11] = complex(0.000007359922, -0.000003358410)
    h2e[10, 4, 3, 11] = complex(0.052372541294, 0.004177390426)
    h2e[0, 4, 5, 11] = complex(0.000344532043, -0.000000844588)
    h2e[2, 4, 5, 11] = complex(-0.091733264331, -0.004031323622)
    h2e[4, 4, 5, 11] = complex(0.070498980334, -0.000111618849)
    h2e[6, 4, 5, 11] = complex(0.000066883765, 0.000161893592)
    h2e[8, 4, 5, 11] = complex(0.000012953997, -0.000005859006)
    h2e[10, 4, 5, 11] = complex(-0.124058550080, -0.009900421941)
    h2e[0, 4, 7, 11] = complex(0.000003665727, 0.000000964602)
    h2e[2, 4, 7, 11] = complex(0.000231313478, 0.000019699873)
    h2e[4, 4, 7, 11] = complex(-0.000187393792, -0.000005111798)
    h2e[6, 4, 7, 11] = complex(0.000938368913, 0.001916920676)
    h2e[8, 4, 7, 11] = complex(0.002067156116, -0.000931166401)
    h2e[10, 4, 7, 11] = complex(0.000402711477, 0.000042390858)
    h2e[0, 4, 9, 11] = complex(0.000001012211, 0.000001667087)
    h2e[2, 4, 9, 11] = complex(-0.000044111039, -0.000025155603)
    h2e[6, 4, 9, 11] = complex(-0.000170065985, 0.002269753814)
    h2e[8, 4, 9, 11] = complex(0.002128758164, 0.000224478579)
    h2e[10, 4, 9, 11] = complex(0.000030979570, 0.000020306591)
    h2e[0, 4, 11, 11] = complex(-0.001422716309, 0.000001236317)
    h2e[2, 4, 11, 11] = complex(0.076193473302, 0.003469285749)
    h2e[4, 4, 11, 11] = complex(0.574398690828, -0.000000000000)
    h2e[6, 4, 11, 11] = complex(-0.000027437730, -0.000067154271)
    h2e[10, 4, 11, 11] = complex(0.025569237766, 0.002081284296)
    h2e[0, 6, 1, 11] = complex(-0.000003185317, 0.000006610606)
    h2e[2, 6, 1, 11] = complex(0.000006835084, -0.000016338840)
    h2e[4, 6, 1, 11] = complex(-0.000002490395, 0.000006849213)
    h2e[6, 6, 1, 11] = complex(0.001598968882, -0.000136849903)
    h2e[8, 6, 1, 11] = complex(0.000000001507, 0.000000001340)
    h2e[10, 6, 1, 11] = complex(0.000003500747, -0.000008511267)
    h2e[0, 6, 3, 11] = complex(-0.000004695939, 0.000004040856)
    h2e[2, 6, 3, 11] = complex(-0.000001291867, 0.000004308590)
    h2e[4, 6, 3, 11] = complex(-0.000095718585, 0.000234573869)
    h2e[6, 6, 3, 11] = complex(-0.104503201302, 0.000169759811)
    h2e[8, 6, 3, 11] = complex(0.000000000859, 0.000000021413)
    h2e[10, 6, 3, 11] = complex(-0.000082624048, 0.000151882265)
    h2e[0, 6, 5, 11] = complex(0.000000173039, -0.000004242920)
    h2e[2, 6, 5, 11] = complex(0.000091538367, -0.000198235064)
    h2e[4, 6, 5, 11] = complex(0.000055537164, -0.000137755404)
    h2e[6, 6, 5, 11] = complex(0.111275222184, -0.000176178608)
    h2e[8, 6, 5, 11] = complex(0.000000000873, 0.000000027413)
    h2e[10, 6, 5, 11] = complex(0.000192811520, -0.000356085996)
    h2e[0, 6, 7, 11] = complex(0.000828359392, -0.001918779604)
    h2e[2, 6, 7, 11] = complex(-0.007843153846, 0.017200458660)
    h2e[4, 6, 7, 11] = complex(-0.000786966517, 0.001951348024)
    h2e[6, 6, 7, 11] = complex(-0.000346447461, -0.000009450523)
    h2e[8, 6, 7, 11] = complex(0.000000077714, 0.000002664394)
    h2e[10, 6, 7, 11] = complex(0.006512665486, -0.013236276959)
    h2e[0, 6, 9, 11] = complex(0.000581782191, -0.000477705664)
    h2e[2, 6, 9, 11] = complex(-0.015579606707, 0.012231374118)
    h2e[4, 6, 9, 11] = complex(-0.001699838550, 0.001464091542)
    h2e[8, 6, 9, 11] = complex(-0.000007303357, 0.000015831509)
    h2e[10, 6, 9, 11] = complex(0.011427593971, -0.008339527028)
    h2e[0, 6, 11, 11] = complex(0.000004130085, -0.000001701588)
    h2e[2, 6, 11, 11] = complex(-0.000078431273, 0.000167311684)
    h2e[4, 6, 11, 11] = complex(-0.000027437730, 0.000067154271)
    h2e[6, 6, 11, 11] = complex(0.551545232677, -0.000000000000)
    h2e[10, 6, 11, 11] = complex(-0.000049532772, 0.000090353051)
    h2e[0, 8, 1, 11] = complex(0.000006700061, 0.000002727918)
    h2e[2, 8, 1, 11] = complex(0.000000429224, 0.000000921737)
    h2e[4, 8, 1, 11] = complex(-0.000000405751, -0.000000467686)
    h2e[6, 8, 1, 11] = complex(-0.000000001544, 0.000000001555)
    h2e[8, 8, 1, 11] = complex(0.001598266472, -0.000136789787)
    h2e[10, 8, 1, 11] = complex(0.000000624641, -0.000000000890)
    h2e[0, 8, 3, 11] = complex(-0.000000225239, -0.000000557997)
    h2e[2, 8, 3, 11] = complex(0.000021854480, 0.000011099050)
    h2e[4, 8, 3, 11] = complex(-0.000007399833, -0.000003300119)
    h2e[6, 8, 3, 11] = complex(-0.000000000674, 0.000000021493)
    h2e[8, 8, 3, 11] = complex(-0.104501710142, 0.000169757389)
    h2e[10, 8, 3, 11] = complex(-0.000006902351, -0.000004068874)
    h2e[0, 8, 5, 11] = complex(0.000001013142, 0.000001484893)
    h2e[2, 8, 5, 11] = complex(-0.000037744270, -0.000018945877)
    h2e[4, 8, 5, 11] = complex(-0.000013034352, -0.000005739584)
    h2e[6, 8, 5, 11] = complex(-0.000000000598, 0.000000027527)
    h2e[8, 8, 5, 11] = complex(0.111272120430, -0.000176173697)
    h2e[10, 8, 5, 11] = complex(0.000032013116, 0.000018634692)
    h2e[0, 8, 7, 11] = complex(0.000681763608, 0.000320003919)
    h2e[2, 8, 7, 11] = complex(-0.017741822266, -0.008806683007)
    h2e[4, 8, 7, 11] = complex(-0.002052598771, -0.000905099224)
    h2e[6, 8, 7, 11] = complex(-0.000000057667, 0.000002602808)
    h2e[8, 8, 7, 11] = complex(-0.000346440707, -0.000009450339)
    h2e[10, 8, 7, 11] = complex(0.012442855594, 0.006731490137)
    h2e[0, 8, 9, 11] = complex(0.001263638010, 0.001675094107)
    h2e[2, 8, 9, 11] = complex(-0.011117061727, -0.015375746436)
    h2e[4, 8, 9, 11] = complex(-0.001312634267, -0.001655142347)
    h2e[6, 8, 9, 11] = complex(0.000005777723, -0.000011093785)
    h2e[10, 8, 9, 11] = complex(0.008319693189, 0.012250725405)
    h2e[8, 8, 11, 11] = complex(0.551538006029, 0.000000000000)
    h2e[0, 10, 1, 11] = complex(-0.004470272451, 0.000423478216)
    h2e[2, 10, 1, 11] = complex(0.004838970257, -0.000587711667)
    h2e[4, 10, 1, 11] = complex(-0.003183391722, 0.000535305923)
    h2e[6, 10, 1, 11] = complex(0.000005510646, 0.000007999027)
    h2e[8, 10, 1, 11] = complex(-0.000000579053, 0.000000146715)
    h2e[10, 10, 1, 11] = complex(-0.003933065673, 0.000336616718)
    h2e[0, 10, 3, 11] = complex(-0.004874250680, 0.000052138883)
    h2e[2, 10, 3, 11] = complex(0.086447482008, -0.003209373726)
    h2e[4, 10, 3, 11] = complex(0.052358730043, -0.004347523609)
    h2e[6, 10, 3, 11] = complex(-0.000075381008, -0.000136465454)
    h2e[8, 10, 3, 11] = complex(0.000006885786, -0.000004064690)
    h2e[10, 10, 3, 11] = complex(-0.033401934739, 0.000054259641)
    h2e[0, 10, 5, 11] = complex(-0.003227902146, 0.000034395080)
    h2e[2, 10, 5, 11] = complex(-0.052502825902, 0.001947009208)
    h2e[4, 10, 5, 11] = complex(-0.124026784988, 0.010293224024)
    h2e[6, 10, 5, 11] = complex(0.000159088840, 0.000286504791)
    h2e[8, 10, 5, 11] = complex(-0.000031921556, 0.000018628196)
    h2e[10, 10, 5, 11] = complex(-0.025653771936, 0.000040616821)
    h2e[0, 10, 7, 11] = complex(0.000009707665, 0.000000336000)
    h2e[2, 10, 7, 11] = complex(0.000155897548, -0.000001034749)
    h2e[4, 10, 7, 11] = complex(0.000327299146, -0.000016417140)
    h2e[6, 10, 7, 11] = complex(-0.006812995103, -0.013273970165)
    h2e[8, 10, 7, 11] = complex(-0.012165576622, 0.007590678741)
    h2e[10, 10, 7, 11] = complex(0.000103001333, 0.000002809709)
    h2e[0, 10, 9, 11] = complex(-0.000000592766, -0.000000073861)
    h2e[2, 10, 9, 11] = complex(-0.000007141894, -0.000003595706)
    h2e[4, 10, 9, 11] = complex(-0.000033811537, -0.000014925662)
    h2e[6, 10, 9, 11] = complex(0.000772671832, -0.014318611547)
    h2e[8, 10, 9, 11] = complex(-0.015006221799, 0.000446302612)
    h2e[0, 10, 11, 11] = complex(0.003947281852, -0.000035810456)
    h2e[2, 10, 11, 11] = complex(-0.033380952992, 0.001184975090)
    h2e[4, 10, 11, 11] = complex(0.025569237766, -0.002081284296)
    h2e[6, 10, 11, 11] = complex(-0.000049532772, -0.000090353051)
    h2e[10, 10, 11, 11] = complex(0.666720377765, -0.000000000000)
    h2e[3, 0, 2, 1] = complex(0.050010615885, 0.002870862657)
    h2e[5, 0, 2, 1] = complex(0.020838377173, 0.001201647131)
    h2e[7, 0, 2, 1] = complex(-0.000055734013, -0.000002551918)
    h2e[9, 0, 2, 1] = complex(-0.000000367579, -0.000000196239)
    h2e[11, 0, 2, 1] = complex(-0.020338736555, -0.001134691069)
    h2e[3, 0, 4, 1] = complex(-0.020871641308, -0.000237714304)
    h2e[5, 0, 4, 1] = complex(-0.020934864599, -0.000243860959)
    h2e[7, 0, 4, 1] = complex(0.000029866992, -0.000000222635)
    h2e[9, 0, 4, 1] = complex(-0.000019036687, -0.000008958589)
    h2e[11, 0, 4, 1] = complex(-0.002992720574, -0.000029265455)
    h2e[3, 0, 6, 1] = complex(0.000020079763, 0.000052053776)
    h2e[5, 0, 6, 1] = complex(0.000010539738, 0.000027946390)
    h2e[7, 0, 6, 1] = complex(-0.004110071628, -0.010297794385)
    h2e[9, 0, 6, 1] = complex(-0.000072076556, -0.009160991930)
    h2e[11, 0, 6, 1] = complex(0.000005568707, 0.000013695955)
    h2e[3, 0, 8, 1] = complex(0.000000388739, -0.000000150023)
    h2e[5, 0, 8, 1] = complex(-0.000019664670, 0.000007480141)
    h2e[7, 0, 8, 1] = complex(-0.008732482431, 0.002769967244)
    h2e[9, 0, 8, 1] = complex(-0.011097002379, -0.000719178031)
    h2e[11, 0, 8, 1] = complex(0.000006700061, -0.000002727918)
    h2e[3, 0, 10, 1] = complex(-0.020276451295, -0.001953778724)
    h2e[5, 0, 10, 1] = complex(0.002978991275, 0.000287826136)
    h2e[7, 0, 10, 1] = complex(-0.000014709612, -0.000001488962)
    h2e[9, 0, 10, 1] = complex(-0.000006183003, -0.000003755374)
    h2e[11, 0, 10, 1] = complex(0.019007317529, 0.001800602762)
    h2e[1, 2, 2, 1] = complex(0.050092949141, 0.000000000000)
    h2e[5, 2, 2, 1] = complex(0.000465476579, 0.000043014915)
    h2e[7, 2, 2, 1] = complex(-0.000001476359, 0.000001874396)
    h2e[9, 2, 2, 1] = complex(-0.000000242668, -0.000000209320)
    h2e[11, 2, 2, 1] = complex(0.001058192131, 0.000113791027)
    h2e[1, 2, 4, 1] = complex(-0.020850960053, 0.000958845061)
    h2e[5, 2, 4, 1] = complex(0.000724363149, 0.000033485065)
    h2e[7, 2, 4, 1] = complex(0.000003038839, 0.000004869523)
    h2e[9, 2, 4, 1] = complex(-0.000011597762, -0.000008628565)
    h2e[11, 2, 4, 1] = complex(-0.004367414976, -0.000267481783)
    h2e[1, 2, 6, 1] = complex(0.000023029999, 0.000050817434)
    h2e[5, 2, 6, 1] = complex(-0.000001120373, 0.000004821740)
    h2e[7, 2, 6, 1] = complex(-0.001339486164, 0.002821780072)
    h2e[9, 2, 6, 1] = complex(0.002610538186, -0.005896516836)
    h2e[11, 2, 6, 1] = complex(0.000002974688, 0.000008134523)
    h2e[1, 2, 8, 1] = complex(0.000000379502, -0.000000172056)
    h2e[5, 2, 8, 1] = complex(-0.000013682721, 0.000008431279)
    h2e[7, 2, 8, 1] = complex(-0.004865468869, 0.004266300857)
    h2e[9, 2, 8, 1] = complex(0.002297210563, -0.001898540259)
    h2e[11, 2, 8, 1] = complex(0.000000259704, -0.000000557700)
    h2e[1, 2, 10, 1] = complex(-0.020355097177, -0.000788509584)
    h2e[5, 2, 10, 1] = complex(-0.000987047810, -0.000129914428)
    h2e[7, 2, 10, 1] = complex(0.000001182528, -0.000002589910)
    h2e[9, 2, 10, 1] = complex(-0.000000276590, -0.000000955289)
    h2e[11, 2, 10, 1] = complex(0.003050860497, 0.000448119445)
    h2e[1, 4, 2, 1] = complex(-0.020850960053, -0.000958845061)
    h2e[3, 4, 2, 1] = complex(0.000463025873, 0.000064232150)
    h2e[7, 4, 2, 1] = complex(-0.000000107900, 0.000000472322)
    h2e[9, 4, 2, 1] = complex(0.000000119062, 0.000000108011)
    h2e[11, 4, 2, 1] = complex(0.001543954031, 0.000234233048)
    h2e[1, 4, 4, 1] = complex(0.020936284865, 0.000000000000)
    h2e[3, 4, 4, 1] = complex(0.000722077525, 0.000066537721)
    h2e[7, 4, 4, 1] = complex(-0.000000935569, -0.000003137359)
    h2e[9, 4, 4, 1] = complex(0.000005554298, 0.000004396287)
    h2e[11, 4, 4, 1] = complex(0.001299894389, 0.000136478478)
    h2e[1, 4, 6, 1] = complex(-0.000010864537, -0.000027821729)
    h2e[3, 4, 6, 1] = complex(-0.000001339453, 0.000004765529)
    h2e[7, 4, 6, 1] = complex(0.000754713623, -0.000883165856)
    h2e[9, 4, 6, 1] = complex(-0.001296644619, 0.002848364983)
    h2e[11, 4, 6, 1] = complex(-0.000001509495, -0.000007746293)
    h2e[1, 4, 8, 1] = complex(0.000019576210, -0.000007708682)
    h2e[3, 4, 8, 1] = complex(-0.000014053565, 0.000007797476)
    h2e[7, 4, 8, 1] = complex(0.002525459902, -0.001855009466)
    h2e[9, 4, 8, 1] = complex(-0.000704102343, 0.000844903154)
    h2e[11, 4, 8, 1] = complex(0.000001182385, -0.000001362868)
    h2e[1, 4, 10, 1] = complex(-0.002982141720, -0.000253108016)
    h2e[3, 4, 10, 1] = complex(-0.000980083278, -0.000174865395)
    h2e[7, 4, 10, 1] = complex(0.000000638872, 0.000001269617)
    h2e[9, 4, 10, 1] = complex(0.000000268999, 0.000000555129)
    h2e[11, 4, 10, 1] = complex(-0.002420509592, -0.000463705336)
    h2e[1, 6, 2, 1] = complex(0.000023029999, -0.000050817434)
    h2e[3, 6, 2, 1] = complex(0.000001073227, 0.000002131004)
    h2e[5, 6, 2, 1] = complex(-0.000000395442, -0.000000279922)
    h2e[11, 6, 2, 1] = complex(-0.000001253340, 0.000003779418)
    h2e[1, 6, 4, 1] = complex(-0.000010864537, 0.000027821729)
    h2e[3, 6, 4, 1] = complex(0.000005698082, -0.000000691851)
    h2e[5, 6, 4, 1] = complex(0.000003257003, 0.000000332022)
    h2e[9, 6, 4, 1] = complex(-0.000000014531, 0.000000011528)
    h2e[11, 6, 4, 1] = complex(-0.000004244218, 0.000008603443)
    h2e[1, 6, 6, 1] = complex(0.011087707520, -0.000000000000)
    h2e[3, 6, 6, 1] = complex(0.001989483589, 0.002408032552)
    h2e[5, 6, 6, 1] = complex(0.000528470091, 0.001034550095)
    h2e[9, 6, 6, 1] = complex(-0.000006257871, -0.000004909550)
    h2e[11, 6, 6, 1] = complex(-0.002061734105, -0.000913825122)
    h2e[1, 6, 8, 1] = complex(0.000664391211, -0.009137152312)
    h2e[3, 6, 8, 1] = complex(0.001805631754, 0.006214000657)
    h2e[5, 6, 8, 1] = complex(0.000751315672, 0.003042126324)
    h2e[9, 6, 8, 1] = complex(-0.000000205667, -0.000001743039)
    h2e[11, 6, 8, 1] = complex(-0.000786348540, -0.000791870523)
    h2e[1, 6, 10, 1] = complex(0.000006835550, -0.000013109727)
    h2e[3, 6, 10, 1] = complex(-0.000001845854, -0.000002167679)
    h2e[5, 6, 10, 1] = complex(-0.000001417321, 0.000000106225)
    h2e[9, 6, 10, 1] = complex(-0.000000001227, 0.000000000827)
    h2e[11, 6, 10, 1] = complex(0.000002191009, -0.000006985381)
    h2e[1, 8, 2, 1] = complex(0.000000379502, 0.000000172056)
    h2e[3, 8, 2, 1] = complex(-0.000000244206, -0.000000207524)
    h2e[5, 8, 2, 1] = complex(-0.000000124624, -0.000000101543)
    h2e[11, 8, 2, 1] = complex(0.000000013715, 0.000000027253)
    h2e[1, 8, 4, 1] = complex(0.000019576210, 0.000007708682)
    h2e[3, 8, 4, 1] = complex(-0.000011661087, -0.000008542790)
    h2e[5, 8, 4, 1] = complex(-0.000005779680, -0.000004095470)
    h2e[7, 8, 4, 1] = complex(0.000000016656, 0.000000008162)
    h2e[11, 8, 4, 1] = complex(0.000001195756, 0.000001386910)
    h2e[1, 8, 6, 1] = complex(0.000664391211, 0.009137152312)
    h2e[3, 8, 6, 1] = complex(0.002566976711, -0.005915610776)
    h2e[5, 8, 6, 1] = complex(0.001143727928, -0.002913135210)
    h2e[7, 8, 6, 1] = complex(-0.000001741802, 0.000007760847)
    h2e[11, 8, 6, 1] = complex(-0.000766986937, 0.000681870509)
    h2e[1, 8, 8, 1] = complex(0.011120282315, -0.000000000000)
    h2e[3, 8, 8, 1] = complex(0.002283145179, -0.001915431949)
    h2e[5, 8, 8, 1] = complex(0.000658293275, -0.000881062660)
    h2e[7, 8, 8, 1] = complex(-0.000001485254, 0.000000935151)
    h2e[11, 8, 8, 1] = complex(-0.002155473061, 0.000452046933)
    h2e[1, 8, 10, 1] = complex(0.000006412929, 0.000003347641)
    h2e[3, 8, 10, 1] = complex(-0.000000283628, -0.000000953224)
    h2e[5, 8, 10, 1] = complex(-0.000000298066, -0.000000540078)
    h2e[7, 8, 10, 1] = complex(0.000000001274, 0.000000000752)
    h2e[11, 8, 10, 1] = complex(-0.000000579052, -0.000000146715)
    h2e[1, 10, 2, 1] = complex(-0.020355097177, 0.000788509584)
    h2e[3, 10, 2, 1] = complex(-0.001061685242, -0.000074454218)
    h2e[5, 10, 2, 1] = complex(0.001558037077, 0.000105733797)
    h2e[7, 10, 2, 1] = complex(-0.000003934700, 0.000000610735)
    h2e[9, 10, 2, 1] = complex(0.000000014519, 0.000000026833)
    h2e[1, 10, 4, 1] = complex(-0.002982141720, 0.000253108016)
    h2e[3, 10, 4, 1] = complex(0.004374331793, 0.000105268429)
    h2e[5, 10, 4, 1] = complex(0.001306728573, 0.000028499735)
    h2e[7, 10, 4, 1] = complex(-0.000009592149, 0.000000152650)
    h2e[9, 10, 4, 1] = complex(0.000001236458, 0.000001350749)
    h2e[1, 10, 6, 1] = complex(0.000006835550, 0.000013109727)
    h2e[3, 10, 6, 1] = complex(-0.000003274428, -0.000008018563)
    h2e[5, 10, 6, 1] = complex(-0.000002145001, -0.000007594907)
    h2e[7, 10, 6, 1] = complex(-0.000128448982, -0.002251516101)
    h2e[9, 10, 6, 1] = complex(-0.000746377302, 0.000704370143)
    h2e[1, 10, 8, 1] = complex(0.000006412929, -0.000003347641)
    h2e[3, 10, 8, 1] = complex(-0.000000238835, 0.000000566952)
    h2e[5, 10, 8, 1] = complex(0.000001065614, -0.000001455991)
    h2e[7, 10, 8, 1] = complex(0.000345427298, -0.001061170551)
    h2e[9, 10, 8, 1] = complex(-0.002141081934, 0.000515925102)
    h2e[1, 10, 10, 1] = complex(0.019092414461, 0.000000000000)
    h2e[3, 10, 10, 1] = complex(-0.003065385244, -0.000334625339)
    h2e[5, 10, 10, 1] = complex(-0.002450568536, -0.000261922072)
    h2e[7, 10, 10, 1] = complex(0.000007215077, -0.000001240456)
    h2e[9, 10, 10, 1] = complex(-0.000000583159, -0.000000129436)
    h2e[3, 0, 0, 3] = complex(0.050092949139, 0.000000000000)
    h2e[5, 0, 0, 3] = complex(0.020872994269, 0.000005409828)
    h2e[7, 0, 0, 3] = complex(-0.000055788660, 0.000000646433)
    h2e[9, 0, 0, 3] = complex(-0.000000378222, -0.000000174850)
    h2e[11, 0, 0, 3] = complex(-0.020370337565, 0.000032801424)
    h2e[3, 0, 4, 3] = complex(0.000465946030, -0.000037590234)
    h2e[5, 0, 4, 3] = complex(-0.000722803557, 0.000058122616)
    h2e[7, 0, 4, 3] = complex(-0.000003929504, 0.000003010548)
    h2e[9, 0, 4, 3] = complex(0.000013519861, 0.000008690034)
    h2e[11, 0, 4, 3] = complex(-0.000992206472, 0.000081654493)
    h2e[3, 0, 6, 3] = complex(0.000001193592, -0.000002065995)
    h2e[5, 0, 6, 3] = complex(-0.000005689637, -0.000000758174)
    h2e[7, 0, 6, 3] = complex(-0.002973955037, -0.000955121421)
    h2e[9, 0, 6, 3] = complex(-0.002203727562, 0.006084216872)
    h2e[11, 0, 6, 3] = complex(-0.000002042060, 0.000001983935)
    h2e[3, 0, 8, 3] = complex(-0.000000255698, 0.000000193188)
    h2e[5, 0, 8, 3] = complex(0.000011759801, -0.000008406385)
    h2e[7, 0, 8, 3] = complex(0.004542623937, -0.004576940889)
    h2e[9, 0, 8, 3] = complex(-0.002154489438, -0.002059079087)
    h2e[11, 0, 8, 3] = complex(-0.000000372262, 0.000000922226)
    h2e[3, 0, 10, 3] = complex(-0.001064207271, 0.000013485906)
    h2e[5, 0, 10, 3] = complex(-0.004375261191, 0.000054310092)
    h2e[7, 0, 10, 3] = complex(0.000008661091, 0.000000068771)
    h2e[9, 0, 10, 3] = complex(0.000000201668, 0.000000581211)
    h2e[11, 0, 10, 3] = complex(-0.003083280960, 0.000044037852)
    h2e[1, 2, 0, 3] = complex(0.050010615885, -0.002870862657)
    h2e[5, 2, 0, 3] = complex(0.000467176733, 0.000016267420)
    h2e[7, 2, 0, 3] = complex(-0.000001366510, 0.000001955926)
    h2e[9, 2, 0, 3] = complex(-0.000000254266, -0.000000195068)
    h2e[11, 2, 0, 3] = complex(0.001062974321, 0.000052958253)
    h2e[1, 2, 4, 3] = complex(0.000463025873, -0.000064232150)
    h2e[5, 2, 4, 3] = complex(0.000416878504, -0.000019062158)
    h2e[7, 2, 4, 3] = complex(0.000160240944, -0.000006239068)
    h2e[9, 2, 4, 3] = complex(-0.000142033007, -0.000061660191)
    h2e[11, 2, 4, 3] = complex(-0.000052558116, 0.000001615904)
    h2e[1, 2, 6, 3] = complex(0.000001073227, -0.000002131004)
    h2e[5, 2, 6, 3] = complex(0.000068865522, 0.000144822739)
    h2e[7, 2, 6, 3] = complex(0.026619674558, 0.056973185904)
    h2e[9, 2, 6, 3] = complex(-0.000298323954, -0.060145125770)
    h2e[11, 2, 6, 3] = complex(-0.000009808242, -0.000021310936)
    h2e[1, 2, 8, 3] = complex(-0.000000244206, 0.000000207524)
    h2e[5, 2, 8, 3] = complex(-0.000139566604, 0.000067056079)
    h2e[7, 2, 8, 3] = complex(-0.054801280602, 0.024785979934)
    h2e[9, 2, 8, 3] = complex(0.062923789158, 0.000464114434)
    h2e[11, 2, 8, 3] = complex(0.000021854479, -0.000011099049)
    h2e[1, 2, 10, 3] = complex(-0.001061685242, 0.000074454218)
    h2e[5, 2, 10, 3] = complex(0.000052570052, 0.000001164585)
    h2e[7, 2, 10, 3] = complex(0.000023448170, 0.000000735521)
    h2e[9, 2, 10, 3] = complex(-0.000021339296, -0.000012059919)
    h2e[11, 2, 10, 3] = complex(-0.008136079260, -0.000302052974)
    h2e[1, 4, 0, 3] = complex(-0.020871641308, 0.000237714304)
    h2e[3, 4, 0, 3] = complex(0.000465946030, 0.000037590234)
    h2e[7, 4, 0, 3] = complex(-0.000000080654, 0.000000477730)
    h2e[9, 4, 0, 3] = complex(0.000000125056, 0.000000101009)
    h2e[11, 4, 0, 3] = complex(0.001554840436, 0.000145362954)
    h2e[1, 4, 4, 3] = complex(0.000722077525, -0.000066537721)
    h2e[3, 4, 4, 3] = complex(0.000417314094, 0.000000000000)
    h2e[7, 4, 4, 3] = complex(-0.000059412872, 0.000000505579)
    h2e[9, 4, 4, 3] = complex(0.000050400480, 0.000024364699)
    h2e[11, 4, 4, 3] = complex(0.001937476626, 0.000024644761)
    h2e[1, 4, 6, 3] = complex(0.000005698082, 0.000000691851)
    h2e[3, 4, 6, 3] = complex(0.000062178397, 0.000147817229)
    h2e[7, 4, 6, 3] = complex(-0.008410196145, -0.020934524511)
    h2e[9, 4, 6, 3] = complex(-0.000642546455, 0.021206930127)
    h2e[11, 4, 6, 3] = complex(-0.000010511395, -0.000045503778)
    h2e[1, 4, 8, 3] = complex(-0.000011661087, 0.000008542790)
    h2e[3, 4, 8, 3] = complex(-0.000142483926, 0.000060610933)
    h2e[7, 4, 8, 3] = complex(0.019773832584, -0.007661337462)
    h2e[9, 4, 8, 3] = complex(-0.022561985156, -0.001007225552)
    h2e[11, 4, 8, 3] = complex(0.000038561544, -0.000017197386)
    h2e[1, 4, 10, 3] = complex(0.004374331793, -0.000105268429)
    h2e[3, 4, 10, 3] = complex(0.000052461984, 0.000003564675)
    h2e[7, 4, 10, 3] = complex(-0.000006530959, -0.000007393876)
    h2e[9, 4, 10, 3] = complex(0.000006886156, 0.000004273151)
    h2e[11, 4, 10, 3] = complex(-0.005948366578, -0.000480168282)
    h2e[1, 6, 0, 3] = complex(0.000020079763, -0.000052053776)
    h2e[3, 6, 0, 3] = complex(0.000001193592, 0.000002065995)
    h2e[5, 6, 0, 3] = complex(-0.000000410835, -0.000000256799)
    h2e[11, 6, 0, 3] = complex(-0.000001034679, 0.000003845036)
    h2e[1, 6, 4, 3] = complex(-0.000001339453, -0.000004765529)
    h2e[3, 6, 4, 3] = complex(0.000062178397, -0.000147817229)
    h2e[5, 6, 4, 3] = complex(0.000022197479, -0.000055112766)
    h2e[9, 6, 4, 3] = complex(-0.000000110014, 0.000000092900)
    h2e[11, 6, 4, 3] = complex(-0.000018379495, 0.000051491967)
    h2e[1, 6, 6, 3] = complex(0.001989483589, -0.002408032552)
    h2e[3, 6, 6, 3] = complex(0.062885220709, 0.000000000000)
    h2e[5, 6, 6, 3] = complex(0.022559716517, 0.000211910654)
    h2e[9, 6, 6, 3] = complex(-0.000048844477, -0.000023538508)
    h2e[11, 6, 6, 3] = complex(-0.019208845010, 0.000957261480)
    h2e[1, 6, 8, 3] = complex(0.002566976711, 0.005915610776)
    h2e[3, 6, 8, 3] = complex(-0.000741923269, 0.060141289509)
    h2e[5, 6, 8, 3] = complex(-0.000461357632, 0.021201124866)
    h2e[9, 6, 8, 3] = complex(0.000026074116, -0.000055760200)
    h2e[11, 6, 8, 3] = complex(-0.000629291181, -0.020080273813)
    h2e[1, 6, 10, 3] = complex(-0.000003274428, 0.000008018563)
    h2e[3, 6, 10, 3] = complex(0.000010592117, -0.000020932385)
    h2e[5, 6, 10, 3] = complex(0.000009326160, -0.000003216453)
    h2e[9, 6, 10, 3] = complex(-0.000000017150, 0.000000012464)
    h2e[11, 6, 10, 3] = complex(0.000000691776, -0.000011289204)
    h2e[1, 8, 0, 3] = complex(0.000000388739, 0.000000150023)
    h2e[3, 8, 0, 3] = complex(-0.000000255698, -0.000000193188)
    h2e[5, 8, 0, 3] = complex(-0.000000130238, -0.000000094234)
    h2e[11, 8, 0, 3] = complex(0.000000015254, 0.000000026422)
    h2e[1, 8, 4, 3] = complex(-0.000014053565, -0.000007797476)
    h2e[3, 8, 4, 3] = complex(-0.000142483926, -0.000060610933)
    h2e[5, 8, 4, 3] = complex(-0.000051621945, -0.000021656910)
    h2e[7, 8, 4, 3] = complex(0.000000131178, 0.000000059381)
    h2e[11, 8, 4, 3] = complex(0.000046115945, 0.000021043176)
    h2e[1, 8, 6, 3] = complex(0.001805631754, -0.006214000657)
    h2e[3, 8, 6, 3] = complex(-0.000741923269, -0.060141289509)
    h2e[5, 8, 6, 3] = complex(-0.000483277229, -0.021211157322)
    h2e[7, 8, 6, 3] = complex(-0.000000249537, 0.000054219757)
    h2e[11, 8, 6, 3] = complex(-0.000802234531, 0.020005812113)
    h2e[1, 8, 8, 3] = complex(0.002283145179, 0.001915431949)
    h2e[3, 8, 8, 3] = complex(0.062925500762, 0.000000000000)
    h2e[5, 8, 8, 3] = complex(0.022583648965, -0.000190990289)
    h2e[7, 8, 8, 3] = complex(-0.000061553800, 0.000000434812)
    h2e[11, 8, 8, 3] = complex(-0.019147930448, -0.000884147808)
    h2e[1, 8, 10, 3] = complex(-0.000000238835, -0.000000566952)
    h2e[3, 8, 10, 3] = complex(-0.000021427665, -0.000011902200)
    h2e[5, 8, 10, 3] = complex(-0.000007103132, -0.000003901859)
    h2e[7, 8, 10, 3] = complex(0.000000018627, 0.000000010124)
    h2e[11, 8, 10, 3] = complex(0.000006885788, 0.000004064689)
    h2e[1, 10, 0, 3] = complex(-0.020276451295, 0.001953778724)
    h2e[3, 10, 0, 3] = complex(-0.001064207271, -0.000013485906)
    h2e[5, 10, 0, 3] = complex(0.001561535952, 0.000016267795)
    h2e[7, 10, 0, 3] = complex(-0.000003893231, 0.000000835232)
    h2e[9, 10, 0, 3] = complex(0.000000016033, 0.000000025957)
    h2e[1, 10, 4, 3] = complex(-0.000980083278, 0.000174865395)
    h2e[3, 10, 4, 3] = complex(0.000052461984, -0.000003564675)
    h2e[5, 10, 4, 3] = complex(0.001932876864, -0.000135683721)
    h2e[7, 10, 4, 3] = complex(-0.000054202834, 0.000007161094)
    h2e[9, 10, 4, 3] = complex(0.000046721135, 0.000019662939)
    h2e[1, 10, 6, 3] = complex(-0.000001845854, 0.000002167679)
    h2e[3, 10, 6, 3] = complex(0.000010592117, 0.000020932385)
    h2e[5, 10, 6, 3] = complex(-0.000014238891, -0.000044478503)
    h2e[7, 10, 6, 3] = complex(-0.009622894907, -0.016652206153)
    h2e[9, 10, 6, 3] = complex(-0.000207146761, 0.020020818880)
    h2e[1, 10, 8, 3] = complex(-0.000000283628, 0.000000953224)
    h2e[3, 10, 8, 3] = complex(-0.000021427665, 0.000011902200)
    h2e[5, 10, 8, 3] = complex(0.000037007071, -0.000020327799)
    h2e[7, 10, 8, 3] = complex(0.017577240182, -0.009729030348)
    h2e[9, 10, 8, 3] = complex(-0.019165751498, -0.000314526978)
    h2e[1, 10, 10, 3] = complex(-0.003065385244, 0.000334625339)
    h2e[3, 10, 10, 3] = complex(0.008141684207, 0.000000000000)
    h2e[5, 10, 10, 3] = complex(-0.005967700191, 0.000013451978)
    h2e[7, 10, 10, 3] = complex(0.000010359422, -0.000004539500)
    h2e[9, 10, 10, 3] = complex(0.000007003579, 0.000003858191)
    h2e[3, 0, 0, 5] = complex(0.020872994269, -0.000005409828)
    h2e[5, 0, 0, 5] = complex(0.020936284865, 0.000000000000)
    h2e[7, 0, 0, 5] = complex(-0.000029862373, 0.000000570505)
    h2e[9, 0, 0, 5] = complex(0.000019139743, 0.000008736247)
    h2e[11, 0, 0, 5] = complex(0.002992858432, -0.000005595041)
    h2e[3, 0, 2, 5] = complex(0.000467176733, -0.000016267420)
    h2e[5, 0, 2, 5] = complex(-0.000724704036, 0.000025045580)
    h2e[7, 0, 2, 5] = complex(-0.000004062920, 0.000002827912)
    h2e[9, 0, 2, 5] = complex(0.000013108804, 0.000009298526)
    h2e[11, 0, 2, 5] = complex(-0.000994900643, 0.000036247054)
    h2e[3, 0, 6, 5] = complex(-0.000000410835, 0.000000256799)
    h2e[5, 0, 6, 5] = complex(-0.000003260650, 0.000000294062)
    h2e[7, 0, 6, 5] = complex(-0.001156743523, -0.000107326196)
    h2e[9, 0, 6, 5] = complex(-0.000946485164, 0.002987168162)
    h2e[11, 0, 6, 5] = complex(-0.000001400986, -0.000000239419)
    h2e[3, 0, 8, 5] = complex(-0.000000130238, 0.000000094234)
    h2e[5, 0, 8, 5] = complex(0.000005826991, -0.000004027873)
    h2e[7, 0, 8, 5] = complex(0.002281631598, -0.002142108202)
    h2e[9, 0, 8, 5] = complex(-0.000599934507, -0.000921791750)
    h2e[11, 0, 8, 5] = complex(-0.000000347673, 0.000000509561)
    h2e[3, 0, 10, 5] = complex(0.001561535952, -0.000016267795)
    h2e[5, 0, 10, 5] = complex(-0.001306971886, 0.000013277332)
    h2e[7, 0, 10, 5] = complex(0.000007848953, -0.000000823148)
    h2e[9, 0, 10, 5] = complex(-0.000000969220, -0.000001521859)
    h2e[11, 0, 10, 5] = complex(-0.002464347922, 0.000029641904)
    h2e[1, 2, 0, 5] = complex(0.020838377173, -0.001201647131)
    h2e[5, 2, 0, 5] = complex(-0.000724704036, -0.000025045580)
    h2e[7, 2, 0, 5] = complex(-0.000003095352, -0.000004833797)
    h2e[9, 2, 0, 5] = complex(0.000011697478, 0.000008492892)
    h2e[11, 2, 0, 5] = complex(0.004370234267, 0.000216593007)
    h2e[1, 2, 2, 5] = complex(0.000465476579, -0.000043014915)
    h2e[5, 2, 2, 5] = complex(0.000417314094, -0.000000000000)
    h2e[7, 2, 2, 5] = complex(0.000160358674, 0.000001086964)
    h2e[9, 2, 2, 5] = complex(-0.000139068227, -0.000068083645)
    h2e[11, 2, 2, 5] = complex(-0.000052577067, -0.000000786543)
    h2e[1, 2, 6, 5] = complex(-0.000000395442, 0.000000279922)
    h2e[5, 2, 6, 5] = complex(0.000024691762, 0.000054041298)
    h2e[7, 2, 6, 5] = complex(0.009741645655, 0.020349104541)
    h2e[9, 2, 6, 5] = complex(-0.000304973701, -0.021203950979)
    h2e[11, 2, 6, 5] = complex(-0.000009200411, -0.000003560235)
    h2e[1, 2, 8, 5] = complex(-0.000000124624, 0.000000101543)
    h2e[5, 2, 8, 5] = complex(-0.000050578813, 0.000023992303)
    h2e[7, 2, 8, 5] = complex(-0.019421604617, 0.008540961677)
    h2e[9, 2, 8, 5] = complex(0.022581626008, 0.000357553456)
    h2e[11, 2, 8, 5] = complex(0.000007242999, -0.000003635650)
    h2e[1, 2, 10, 5] = complex(0.001558037077, -0.000105733797)
    h2e[5, 2, 10, 5] = complex(0.001937057127, 0.000047251753)
    h2e[7, 2, 10, 5] = complex(-0.000046324345, 0.000005927757)
    h2e[9, 2, 10, 5] = complex(0.000036856137, 0.000020600196)
    h2e[11, 2, 10, 5] = complex(0.005963092809, 0.000234841822)
    h2e[1, 4, 0, 5] = complex(-0.020934864599, 0.000243860959)
    h2e[3, 4, 0, 5] = complex(-0.000722803557, -0.000058122616)
    h2e[7, 4, 0, 5] = complex(0.000000972049, 0.000003126249)
    h2e[9, 4, 0, 5] = complex(-0.000005605128, -0.000004331294)
    h2e[11, 4, 0, 5] = complex(-0.001301395877, -0.000121328353)
    h2e[1, 4, 2, 5] = complex(0.000724363149, -0.000033485065)
    h2e[3, 4, 2, 5] = complex(0.000416878504, 0.000019062158)
    h2e[7, 4, 2, 5] = complex(-0.000059373951, -0.000002208822)
    h2e[9, 4, 2, 5] = complex(0.000049234936, 0.000026641472)
    h2e[11, 4, 2, 5] = complex(0.001934328572, 0.000113119488)
    h2e[1, 4, 6, 5] = complex(0.000003257003, -0.000000332022)
    h2e[3, 4, 6, 5] = complex(0.000022197479, 0.000055112766)
    h2e[7, 4, 6, 5] = complex(-0.008826824871, -0.021388575494)
    h2e[9, 4, 6, 5] = complex(-0.000434319865, 0.021238003901)
    h2e[11, 4, 6, 5] = complex(0.000000645795, 0.000014397479)
    h2e[1, 4, 8, 5] = complex(-0.000005779680, 0.000004095470)
    h2e[3, 4, 8, 5] = complex(-0.000051621945, 0.000021656910)
    h2e[7, 4, 8, 5] = complex(0.019889892871, -0.007458793866)
    h2e[9, 4, 8, 5] = complex(-0.023142076376, -0.001229299363)
    h2e[11, 4, 8, 5] = complex(-0.000013034353, 0.000005739583)
    h2e[1, 4, 10, 5] = complex(0.001306728573, -0.000028499735)
    h2e[3, 4, 10, 5] = complex(0.001932876864, 0.000135683721)
    h2e[7, 4, 10, 5] = complex(-0.000013913502, 0.000003757514)
    h2e[9, 4, 10, 5] = complex(0.000012136774, 0.000007452244)
    h2e[11, 4, 10, 5] = complex(0.017002274415, 0.001411051810)
    h2e[1, 6, 0, 5] = complex(0.000010539738, -0.000027946390)
    h2e[3, 6, 0, 5] = complex(-0.000005689637, 0.000000758174)
    h2e[5, 6, 0, 5] = complex(-0.000003260650, -0.000000294062)
    h2e[9, 6, 0, 5] = complex(0.000000014396, -0.000000011697)
    h2e[11, 6, 0, 5] = complex(0.000004143720, -0.000008652295)
    h2e[1, 6, 2, 5] = complex(-0.000001120373, -0.000004821740)
    h2e[3, 6, 2, 5] = complex(0.000068865522, -0.000144822739)
    h2e[5, 6, 2, 5] = complex(0.000024691762, -0.000054041298)
    h2e[9, 6, 2, 5] = complex(-0.000000114143, 0.000000087778)
    h2e[11, 6, 2, 5] = complex(-0.000020712372, 0.000050598678)
    h2e[1, 6, 6, 5] = complex(0.000528470091, -0.001034550095)
    h2e[3, 6, 6, 5] = complex(0.022559716517, -0.000211910654)
    h2e[5, 6, 6, 5] = complex(0.023138366379, 0.000000000000)
    h2e[9, 6, 6, 5] = complex(-0.000045859370, -0.000021864742)
    h2e[11, 6, 6, 5] = complex(0.002136986642, -0.000129384058)
    h2e[1, 6, 8, 5] = complex(0.001143727928, 0.002913135210)
    h2e[3, 6, 8, 5] = complex(-0.000483277229, 0.021211157322)
    h2e[5, 6, 8, 5] = complex(-0.000692858966, 0.021231141994)
    h2e[9, 6, 8, 5] = complex(-0.000020924422, 0.000043933036)
    h2e[11, 6, 8, 5] = complex(0.000049424564, 0.002275432744)
    h2e[1, 6, 10, 5] = complex(-0.000002145001, 0.000007594907)
    h2e[3, 6, 10, 5] = complex(-0.000014238891, 0.000044478503)
    h2e[5, 6, 10, 5] = complex(0.000001834364, -0.000014294739)
    h2e[9, 6, 10, 5] = complex(-0.000000021957, 0.000000015949)
    h2e[11, 6, 10, 5] = complex(0.000005072832, 0.000016185931)
    h2e[1, 8, 0, 5] = complex(-0.000019664670, -0.000007480141)
    h2e[3, 8, 0, 5] = complex(0.000011759801, 0.000008406385)
    h2e[5, 8, 0, 5] = complex(0.000005826991, 0.000004027873)
    h2e[7, 8, 0, 5] = complex(-0.000000016750, -0.000000007968)
    h2e[11, 8, 0, 5] = complex(-0.000001211829, -0.000001372888)
    h2e[1, 8, 2, 5] = complex(-0.000013682721, -0.000008431279)
    h2e[3, 8, 2, 5] = complex(-0.000139566604, -0.000067056079)
    h2e[5, 8, 2, 5] = complex(-0.000050578813, -0.000023992303)
    h2e[7, 8, 2, 5] = complex(0.000000128328, 0.000000065311)
    h2e[11, 8, 2, 5] = complex(0.000045106594, 0.000023127705)
    h2e[1, 8, 6, 5] = complex(0.000751315672, -0.003042126324)
    h2e[3, 8, 6, 5] = complex(-0.000461357632, -0.021201124866)
    h2e[5, 8, 6, 5] = complex(-0.000692858966, -0.021231141994)
    h2e[7, 8, 6, 5] = complex(-0.000000021918, 0.000050805003)
    h2e[11, 8, 6, 5] = complex(0.000072174722, -0.002266199198)
    h2e[1, 8, 8, 5] = complex(0.000658293275, 0.000881062660)
    h2e[3, 8, 8, 5] = complex(0.022583648965, 0.000190990289)
    h2e[5, 8, 8, 5] = complex(0.023174703369, 0.000000000000)
    h2e[7, 8, 8, 5] = complex(0.000048661516, 0.000000001236)
    h2e[11, 8, 8, 5] = complex(0.002132065345, 0.000118002975)
    h2e[1, 8, 10, 5] = complex(0.000001065614, 0.000001455991)
    h2e[3, 8, 10, 5] = complex(0.000037007071, 0.000020327799)
    h2e[5, 8, 10, 5] = complex(-0.000012514988, -0.000006797959)
    h2e[7, 8, 10, 5] = complex(0.000000023840, 0.000000012966)
    h2e[11, 8, 10, 5] = complex(-0.000031921560, -0.000018628194)
    h2e[1, 10, 0, 5] = complex(0.002978991275, -0.000287826136)
    h2e[3, 10, 0, 5] = complex(-0.004375261191, -0.000054310092)
    h2e[5, 10, 0, 5] = complex(-0.001306971886, -0.000013277332)
    h2e[7, 10, 0, 5] = complex(0.000009589720, -0.000000264367)
    h2e[9, 10, 0, 5] = complex(-0.000001252107, -0.000001336256)
    h2e[1, 10, 2, 5] = complex(-0.000987047810, 0.000129914428)
    h2e[3, 10, 2, 5] = complex(0.000052570052, -0.000001164585)
    h2e[5, 10, 2, 5] = complex(0.001937057127, -0.000047251753)
    h2e[7, 10, 2, 5] = complex(-0.000054473364, 0.000004677731)
    h2e[9, 10, 2, 5] = complex(0.000045774200, 0.000021776553)
    h2e[1, 10, 6, 5] = complex(-0.000001417321, -0.000000106225)
    h2e[3, 10, 6, 5] = complex(0.000009326160, 0.000003216453)
    h2e[5, 10, 6, 5] = complex(0.000001834364, 0.000014294739)
    h2e[7, 10, 6, 5] = complex(0.001090911410, 0.001842108694)
    h2e[9, 10, 6, 5] = complex(0.000004773204, -0.002267343205)
    h2e[1, 10, 8, 5] = complex(-0.000000298066, 0.000000540078)
    h2e[3, 10, 8, 5] = complex(-0.000007103132, 0.000003901859)
    h2e[5, 10, 8, 5] = complex(-0.000012514988, 0.000006797959)
    h2e[7, 10, 8, 5] = complex(-0.002001790065, 0.001082992843)
    h2e[9, 10, 8, 5] = complex(0.002134631020, 0.000054568740)
    h2e[1, 10, 10, 5] = complex(-0.002450568536, 0.000261922072)
    h2e[3, 10, 10, 5] = complex(-0.005967700191, -0.000013451978)
    h2e[5, 10, 10, 5] = complex(0.017060726904, -0.000000000000)
    h2e[7, 10, 10, 5] = complex(-0.000012083568, 0.000011904006)
    h2e[9, 10, 10, 5] = complex(-0.000032461227, -0.000017670997)
    h2e[3, 0, 0, 7] = complex(-0.000055788660, -0.000000646433)
    h2e[5, 0, 0, 7] = complex(-0.000029862373, -0.000000570505)
    h2e[7, 0, 0, 7] = complex(0.011087707514, -0.000000000000)
    h2e[9, 0, 0, 7] = complex(0.008535060179, 0.003328921117)
    h2e[11, 0, 0, 7] = complex(-0.000014784473, 0.000000095065)
    h2e[3, 0, 2, 7] = complex(-0.000001366510, -0.000001955926)
    h2e[5, 0, 2, 7] = complex(-0.000003095352, 0.000004833797)
    h2e[7, 0, 2, 7] = complex(-0.002124219719, 0.002290055962)
    h2e[9, 0, 2, 7] = complex(0.004579370219, 0.004572032221)
    h2e[11, 0, 2, 7] = complex(0.000000933003, 0.000002689891)
    h2e[3, 0, 4, 7] = complex(-0.000000080654, -0.000000477730)
    h2e[5, 0, 4, 7] = complex(0.000000972049, -0.000003126249)
    h2e[7, 0, 4, 7] = complex(0.000540484439, -0.001028324417)
    h2e[9, 0, 4, 7] = complex(-0.002400204570, -0.002014454228)
    h2e[11, 0, 4, 7] = complex(0.000000755762, -0.000001203706)
    h2e[5, 0, 8, 7] = complex(-0.000000016750, 0.000000007968)
    h2e[7, 0, 8, 7] = complex(-0.000006562283, 0.000004494559)
    h2e[9, 0, 8, 7] = complex(0.000001421666, 0.000001029248)
    h2e[11, 0, 8, 7] = complex(0.000000001339, -0.000000000628)
    h2e[3, 0, 10, 7] = complex(-0.000003893231, -0.000000835232)
    h2e[5, 0, 10, 7] = complex(0.000009589720, 0.000000264367)
    h2e[7, 0, 10, 7] = complex(0.002138727447, -0.000715310270)
    h2e[9, 0, 10, 7] = complex(-0.000276075452, -0.001081288721)
    h2e[11, 0, 10, 7] = complex(0.000007065931, 0.000001915380)
    h2e[1, 2, 0, 7] = complex(-0.000055734013, 0.000002551918)
    h2e[5, 2, 0, 7] = complex(-0.000004062920, -0.000002827912)
    h2e[7, 2, 0, 7] = complex(-0.002124219719, -0.002290055962)
    h2e[9, 2, 0, 7] = complex(0.004508742609, 0.004610321068)
    h2e[11, 2, 0, 7] = complex(-0.000008657680, -0.000000252599)
    h2e[1, 2, 2, 7] = complex(-0.000001476359, -0.000001874396)
    h2e[5, 2, 2, 7] = complex(0.000160358674, -0.000001086964)
    h2e[7, 2, 2, 7] = complex(0.062885220741, 0.000000000000)
    h2e[9, 2, 2, 7] = complex(-0.054616978071, -0.025189499012)
    h2e[11, 2, 2, 7] = complex(-0.000023459314, -0.000000134902)
    h2e[1, 2, 4, 7] = complex(-0.000000107900, -0.000000472322)
    h2e[5, 2, 4, 7] = complex(-0.000059373951, 0.000002208822)
    h2e[7, 2, 4, 7] = complex(-0.022526489135, 0.001242176785)
    h2e[9, 2, 4, 7] = complex(0.019716787631, 0.007806973288)
    h2e[11, 2, 4, 7] = complex(0.000006800772, -0.000007146490)
    h2e[5, 2, 8, 7] = complex(0.000000128328, -0.000000065311)
    h2e[7, 2, 8, 7] = complex(0.000049016759, -0.000023177611)
    h2e[9, 2, 8, 7] = complex(-0.000061548919, -0.000000888798)
    h2e[11, 2, 8, 7] = complex(-0.000000018990, 0.000000009426)
    h2e[1, 2, 10, 7] = complex(-0.000003934700, -0.000000610735)
    h2e[5, 2, 10, 7] = complex(-0.000054473364, -0.000004677731)
    h2e[7, 2, 10, 7] = complex(-0.019160107163, -0.001669242344)
    h2e[9, 2, 10, 7] = complex(0.017505004465, 0.009858408716)
    h2e[11, 2, 10, 7] = complex(-0.000010183877, -0.000004920705)
    h2e[1, 4, 0, 7] = complex(0.000029866992, 0.000000222635)
    h2e[3, 4, 0, 7] = complex(-0.000003929504, -0.000003010548)
    h2e[7, 4, 0, 7] = complex(0.000540484439, 0.001028324417)
    h2e[9, 4, 0, 7] = complex(-0.002164791483, -0.002260121269)
    h2e[11, 4, 0, 7] = complex(0.000007753981, 0.000001469496)
    h2e[1, 4, 2, 7] = complex(0.000003038839, -0.000004869523)
    h2e[3, 4, 2, 7] = complex(0.000160240944, 0.000006239068)
    h2e[7, 4, 2, 7] = complex(-0.022526489135, -0.001242176785)
    h2e[9, 4, 2, 7] = complex(0.018941207213, 0.009559153787)
    h2e[11, 4, 2, 7] = complex(-0.000045675361, -0.000009738824)
    h2e[1, 4, 4, 7] = complex(-0.000000935569, 0.000003137359)
    h2e[3, 4, 4, 7] = complex(-0.000059412872, -0.000000505579)
    h2e[7, 4, 4, 7] = complex(0.023138366390, -0.000000000000)
    h2e[9, 4, 4, 7] = complex(-0.019466239639, -0.008503349822)
    h2e[11, 4, 4, 7] = complex(-0.000013555057, -0.000004895393)
    h2e[1, 4, 8, 7] = complex(0.000000016656, -0.000000008162)
    h2e[3, 4, 8, 7] = complex(0.000000131178, -0.000000059381)
    h2e[7, 4, 8, 7] = complex(-0.000046954618, 0.000019401356)
    h2e[9, 4, 8, 7] = complex(-0.000048593073, -0.000002580012)
    h2e[11, 4, 8, 7] = complex(0.000000024831, -0.000000010949)
    h2e[1, 4, 10, 7] = complex(-0.000009592149, -0.000000152650)
    h2e[3, 4, 10, 7] = complex(-0.000054202834, -0.000007161094)
    h2e[7, 4, 10, 7] = complex(-0.002118963977, -0.000305685811)
    h2e[9, 4, 10, 7] = complex(0.001941524578, 0.001187652843)
    h2e[11, 4, 10, 7] = complex(-0.000011057616, -0.000012862623)
    h2e[1, 6, 0, 7] = complex(-0.004110071628, 0.010297794385)
    h2e[3, 6, 0, 7] = complex(-0.002973955037, 0.000955121421)
    h2e[5, 6, 0, 7] = complex(-0.001156743523, 0.000107326196)
    h2e[9, 6, 0, 7] = complex(0.000006879495, -0.000003992139)
    h2e[11, 6, 0, 7] = complex(0.001612980670, -0.001576108249)
    h2e[1, 6, 2, 7] = complex(-0.001339486164, -0.002821780072)
    h2e[3, 6, 2, 7] = complex(0.026619674558, -0.056973185904)
    h2e[5, 6, 2, 7] = complex(0.009741645655, -0.020349104541)
    h2e[9, 6, 2, 7] = complex(-0.000042001727, 0.000034288471)
    h2e[11, 6, 2, 7] = complex(-0.007263947879, 0.017808176148)
    h2e[1, 6, 4, 7] = complex(0.000754713623, 0.000883165856)
    h2e[3, 6, 4, 7] = complex(-0.008410196145, 0.020934524511)
    h2e[5, 6, 4, 7] = complex(-0.008826824871, 0.021388575494)
    h2e[9, 6, 4, 7] = complex(0.000037705701, -0.000034050387)
    h2e[11, 6, 4, 7] = complex(-0.000695618084, 0.002024738904)
    h2e[1, 6, 8, 7] = complex(-0.000001741802, -0.000007760847)
    h2e[3, 6, 8, 7] = complex(-0.000000249537, -0.000054219757)
    h2e[5, 6, 8, 7] = complex(-0.000000021918, -0.000050805003)
    h2e[9, 6, 8, 7] = complex(-0.018105831434, 0.038017597358)
    h2e[11, 6, 8, 7] = complex(-0.000000057667, -0.000002602809)
    h2e[1, 6, 10, 7] = complex(-0.000128448982, 0.002251516101)
    h2e[3, 6, 10, 7] = complex(-0.009622894907, 0.016652206153)
    h2e[5, 6, 10, 7] = complex(0.001090911410, -0.001842108694)
    h2e[9, 6, 10, 7] = complex(-0.000002103690, 0.000001533762)
    h2e[11, 6, 10, 7] = complex(0.006857880362, -0.013361421777)
    h2e[1, 8, 0, 7] = complex(-0.008732482431, -0.002769967244)
    h2e[3, 8, 0, 7] = complex(0.004542623937, 0.004576940889)
    h2e[5, 8, 0, 7] = complex(0.002281631598, 0.002142108202)
    h2e[7, 8, 0, 7] = complex(-0.000006562283, -0.000004494559)
    h2e[11, 8, 0, 7] = complex(-0.000348980270, -0.000965105745)
    h2e[1, 8, 2, 7] = complex(-0.004865468869, -0.004266300857)
    h2e[3, 8, 2, 7] = complex(-0.054801280602, -0.024785979934)
    h2e[5, 8, 2, 7] = complex(-0.019421604617, -0.008540961677)
    h2e[7, 8, 2, 7] = complex(0.000049016759, 0.000023177611)
    h2e[11, 8, 2, 7] = complex(0.017785413137, 0.009195388968)
    h2e[1, 8, 4, 7] = complex(0.002525459902, 0.001855009466)
    h2e[3, 8, 4, 7] = complex(0.019773832584, 0.007661337462)
    h2e[5, 8, 4, 7] = complex(0.019889892871, 0.007458793866)
    h2e[7, 8, 4, 7] = complex(-0.000046954618, -0.000019401356)
    h2e[11, 8, 4, 7] = complex(0.002067289377, 0.000931226412)
    h2e[1, 8, 8, 7] = complex(-0.000001485254, -0.000000935151)
    h2e[3, 8, 8, 7] = complex(-0.000061553800, -0.000000434812)
    h2e[5, 8, 8, 7] = complex(0.000048661516, -0.000000001236)
    h2e[7, 8, 8, 7] = complex(0.042108892657, 0.000000000000)
    h2e[11, 8, 8, 7] = complex(-0.000017792337, 0.000001174318)
    h2e[1, 8, 10, 7] = complex(0.000345427298, 0.001061170551)
    h2e[3, 8, 10, 7] = complex(0.017577240182, 0.009729030348)
    h2e[5, 8, 10, 7] = complex(-0.002001790065, -0.001082992843)
    h2e[7, 8, 10, 7] = complex(0.000002289279, 0.000001239814)
    h2e[11, 8, 10, 7] = complex(-0.012165576679, -0.007590678652)
    h2e[1, 10, 0, 7] = complex(-0.000014709612, 0.000001488962)
    h2e[3, 10, 0, 7] = complex(0.000008661091, -0.000000068771)
    h2e[5, 10, 0, 7] = complex(0.000007848953, 0.000000823148)
    h2e[7, 10, 0, 7] = complex(0.002138727447, 0.000715310270)
    h2e[9, 10, 0, 7] = complex(-0.000377516707, -0.000954304714)
    h2e[1, 10, 2, 7] = complex(0.000001182528, 0.000002589910)
    h2e[3, 10, 2, 7] = complex(0.000023448170, -0.000000735521)
    h2e[5, 10, 2, 7] = complex(-0.000046324345, -0.000005927757)
    h2e[7, 10, 2, 7] = complex(-0.019160107163, 0.001669242344)
    h2e[9, 10, 2, 7] = complex(0.018050913136, 0.008662599697)
    h2e[1, 10, 4, 7] = complex(0.000000638872, -0.000001269617)
    h2e[3, 10, 4, 7] = complex(-0.000006530959, 0.000007393876)
    h2e[5, 10, 4, 7] = complex(-0.000013913502, -0.000003757514)
    h2e[7, 10, 4, 7] = complex(-0.002118963977, 0.000305685811)
    h2e[9, 10, 4, 7] = complex(0.002094059204, 0.000869358411)
    h2e[1, 10, 8, 7] = complex(0.000000001274, -0.000000000752)
    h2e[3, 10, 8, 7] = complex(0.000000018627, -0.000000010124)
    h2e[5, 10, 8, 7] = complex(0.000000023840, -0.000000012966)
    h2e[7, 10, 8, 7] = complex(0.000002289279, -0.000001239814)
    h2e[9, 10, 8, 7] = complex(-0.000017749564, 0.000001702730)
    h2e[1, 10, 10, 7] = complex(0.000007215077, 0.000001240456)
    h2e[3, 10, 10, 7] = complex(0.000010359422, 0.000004539500)
    h2e[5, 10, 10, 7] = complex(-0.000012083568, -0.000011904006)
    h2e[7, 10, 10, 7] = complex(0.015018592312, -0.000000000000)
    h2e[9, 10, 10, 7] = complex(-0.012385855642, -0.007225665253)
    h2e[3, 0, 0, 9] = complex(-0.000000378222, 0.000000174850)
    h2e[5, 0, 0, 9] = complex(0.000019139743, -0.000008736247)
    h2e[7, 0, 0, 9] = complex(0.008535060179, -0.003328921117)
    h2e[9, 0, 0, 9] = complex(0.011120282321, 0.000000000000)
    h2e[11, 0, 0, 9] = complex(-0.000006509613, 0.000003155518)
    h2e[3, 0, 2, 9] = complex(-0.000000254266, 0.000000195068)
    h2e[5, 0, 2, 9] = complex(0.000011697478, -0.000008492892)
    h2e[7, 0, 2, 9] = complex(0.004508742609, -0.004610321068)
    h2e[9, 0, 2, 9] = complex(-0.002169617807, -0.002043132405)
    h2e[11, 0, 2, 9] = complex(-0.000000365451, 0.000000924947)
    h2e[3, 0, 4, 9] = complex(0.000000125056, -0.000000101009)
    h2e[5, 0, 4, 9] = complex(-0.000005605128, 0.000004331294)
    h2e[7, 0, 4, 9] = complex(-0.002164791483, 0.002260121269)
    h2e[9, 0, 4, 9] = complex(0.000647986206, 0.000888670537)
    h2e[11, 0, 4, 9] = complex(0.000000320154, -0.000000527285)
    h2e[5, 0, 6, 9] = complex(0.000000014396, 0.000000011697)
    h2e[7, 0, 6, 9] = complex(0.000006879495, 0.000003992139)
    h2e[9, 0, 6, 9] = complex(0.000000317964, -0.000001726089)
    h2e[11, 0, 6, 9] = complex(-0.000000001143, -0.000000000939)
    h2e[3, 0, 10, 9] = complex(0.000000016033, -0.000000025957)
    h2e[5, 0, 10, 9] = complex(-0.000001252107, 0.000001336256)
    h2e[7, 0, 10, 9] = complex(-0.000377516707, 0.000954304714)
    h2e[9, 0, 10, 9] = complex(0.002103233408, 0.000653314455)
    h2e[11, 0, 10, 9] = complex(-0.000000592767, 0.000000073861)
    h2e[1, 2, 0, 9] = complex(-0.000000367579, 0.000000196239)
    h2e[5, 2, 0, 9] = complex(0.000013108804, -0.000009298526)
    h2e[7, 2, 0, 9] = complex(0.004579370219, -0.004572032221)
    h2e[9, 2, 0, 9] = complex(-0.002169617807, 0.002043132405)
    h2e[11, 2, 0, 9] = complex(-0.000000223092, 0.000000573329)
    h2e[1, 2, 2, 9] = complex(-0.000000242668, 0.000000209320)
    h2e[5, 2, 2, 9] = complex(-0.000139068227, 0.000068083645)
    h2e[7, 2, 2, 9] = complex(-0.054616978071, 0.025189499012)
    h2e[9, 2, 2, 9] = complex(0.062925500732, 0.000000000000)
    h2e[11, 2, 2, 9] = complex(0.000021772023, -0.000011259938)
    h2e[1, 2, 4, 9] = complex(0.000000119062, -0.000000108011)
    h2e[5, 2, 4, 9] = complex(0.000049234936, -0.000026641472)
    h2e[7, 2, 4, 9] = complex(0.018941207213, -0.009559153787)
    h2e[9, 2, 4, 9] = complex(-0.022568800371, 0.000840789578)
    h2e[11, 2, 4, 9] = complex(-0.000007039947, 0.000004014735)
    h2e[5, 2, 6, 9] = complex(-0.000000114143, -0.000000087778)
    h2e[7, 2, 6, 9] = complex(-0.000042001727, -0.000034288471)
    h2e[9, 2, 6, 9] = complex(0.000025662141, 0.000055950996)
    h2e[11, 2, 6, 9] = complex(0.000000016675, 0.000000013092)
    h2e[1, 2, 10, 9] = complex(0.000000014519, -0.000000026833)
    h2e[5, 2, 10, 9] = complex(0.000045774200, -0.000021776553)
    h2e[7, 2, 10, 9] = complex(0.018050913136, -0.008662599697)
    h2e[9, 2, 10, 9] = complex(-0.019167550008, 0.000173159174)
    h2e[11, 2, 10, 9] = complex(-0.000007141894, 0.000003595706)
    h2e[1, 4, 0, 9] = complex(-0.000019036687, 0.000008958589)
    h2e[3, 4, 0, 9] = complex(0.000013519861, -0.000008690034)
    h2e[7, 4, 0, 9] = complex(-0.002400204570, 0.002014454228)
    h2e[9, 4, 0, 9] = complex(0.000647986206, -0.000888670537)
    h2e[11, 4, 0, 9] = complex(-0.000001091769, 0.000001436483)
    h2e[1, 4, 2, 9] = complex(-0.000011597762, 0.000008628565)
    h2e[3, 4, 2, 9] = complex(-0.000142033007, 0.000061660191)
    h2e[7, 4, 2, 9] = complex(0.019716787631, -0.007806973288)
    h2e[9, 4, 2, 9] = complex(-0.022568800371, -0.000840789578)
    h2e[11, 4, 2, 9] = complex(0.000038433656, -0.000017481333)
    h2e[1, 4, 4, 9] = complex(0.000005554298, -0.000004396287)
    h2e[3, 4, 4, 9] = complex(0.000050400480, -0.000024364699)
    h2e[7, 4, 4, 9] = complex(-0.019466239639, 0.008503349822)
    h2e[9, 4, 4, 9] = complex(0.023174703356, 0.000000000000)
    h2e[11, 4, 4, 9] = complex(0.000012711548, -0.000006422908)
    h2e[1, 4, 6, 9] = complex(-0.000000014531, -0.000000011528)
    h2e[3, 4, 6, 9] = complex(-0.000000110014, -0.000000092900)
    h2e[7, 4, 6, 9] = complex(0.000037705701, 0.000034050387)
    h2e[9, 4, 6, 9] = complex(0.000018564539, 0.000044981119)
    h2e[11, 4, 6, 9] = complex(-0.000000020562, -0.000000017711)
    h2e[1, 4, 10, 9] = complex(0.000001236458, -0.000001350749)
    h2e[3, 4, 10, 9] = complex(0.000046721135, -0.000019662939)
    h2e[7, 4, 10, 9] = complex(0.002094059204, -0.000869358411)
    h2e[9, 4, 10, 9] = complex(-0.002134520327, -0.000058739332)
    h2e[11, 4, 10, 9] = complex(-0.000033811536, 0.000014925663)
    h2e[1, 6, 0, 9] = complex(-0.000072076556, 0.009160991930)
    h2e[3, 6, 0, 9] = complex(-0.002203727562, -0.006084216872)
    h2e[5, 6, 0, 9] = complex(-0.000946485164, -0.002987168162)
    h2e[9, 6, 0, 9] = complex(0.000000317964, 0.000001726089)
    h2e[11, 6, 0, 9] = complex(0.000835914705, 0.000739357529)
    h2e[1, 6, 2, 9] = complex(0.002610538186, 0.005896516836)
    h2e[3, 6, 2, 9] = complex(-0.000298323954, 0.060145125770)
    h2e[5, 6, 2, 9] = complex(-0.000304973701, 0.021203950979)
    h2e[9, 6, 2, 9] = complex(0.000025662141, -0.000055950996)
    h2e[11, 6, 2, 9] = complex(-0.000777378485, -0.020075086210)
    h2e[1, 6, 4, 9] = complex(-0.001296644619, -0.002848364983)
    h2e[3, 6, 4, 9] = complex(-0.000642546455, -0.021206930127)
    h2e[5, 6, 4, 9] = complex(-0.000434319865, -0.021238003901)
    h2e[9, 6, 4, 9] = complex(0.000018564539, -0.000044981119)
    h2e[11, 6, 4, 9] = complex(-0.000170055038, -0.002269607508)
    h2e[1, 6, 6, 9] = complex(-0.000006257871, 0.000004909550)
    h2e[3, 6, 6, 9] = complex(-0.000048844477, 0.000023538508)
    h2e[5, 6, 6, 9] = complex(-0.000045859370, 0.000021864742)
    h2e[9, 6, 6, 9] = complex(0.042108892657, 0.000000000000)
    h2e[11, 6, 6, 9] = complex(-0.000002325124, 0.000001171211)
    h2e[1, 6, 10, 9] = complex(-0.000746377302, -0.000704370143)
    h2e[3, 6, 10, 9] = complex(-0.000207146761, -0.020020818880)
    h2e[5, 6, 10, 9] = complex(0.000004773204, 0.002267343205)
    h2e[9, 6, 10, 9] = complex(0.000009169187, -0.000015292884)
    h2e[11, 6, 10, 9] = complex(0.000772671937, 0.014318611540)
    h2e[1, 8, 0, 9] = complex(-0.011097002379, 0.000719178031)
    h2e[3, 8, 0, 9] = complex(-0.002154489438, 0.002059079087)
    h2e[5, 8, 0, 9] = complex(-0.000599934507, 0.000921791750)
    h2e[7, 8, 0, 9] = complex(0.000001421666, -0.000001029248)
    h2e[11, 8, 0, 9] = complex(0.002121725578, -0.000590500725)
    h2e[1, 8, 2, 9] = complex(0.002297210563, 0.001898540259)
    h2e[3, 8, 2, 9] = complex(0.062923789158, -0.000464114434)
    h2e[5, 8, 2, 9] = complex(0.022581626008, -0.000357553456)
    h2e[7, 8, 2, 9] = complex(-0.000061548919, 0.000000888798)
    h2e[11, 8, 2, 9] = complex(-0.019153930748, -0.000742895952)
    h2e[1, 8, 4, 9] = complex(-0.000704102343, -0.000844903154)
    h2e[3, 8, 4, 9] = complex(-0.022561985156, 0.001007225552)
    h2e[5, 8, 4, 9] = complex(-0.023142076376, 0.001229299363)
    h2e[7, 8, 4, 9] = complex(-0.000048593073, 0.000002580012)
    h2e[11, 8, 4, 9] = complex(-0.002135323126, -0.000004741692)
    h2e[1, 8, 6, 9] = complex(-0.000000205667, 0.000001743039)
    h2e[3, 8, 6, 9] = complex(0.000026074116, 0.000055760200)
    h2e[5, 8, 6, 9] = complex(-0.000020924422, -0.000043933036)
    h2e[7, 8, 6, 9] = complex(-0.018105831434, -0.038017597358)
    h2e[11, 8, 6, 9] = complex(0.000008710507, 0.000015558707)
    h2e[1, 8, 10, 9] = complex(-0.002141081934, -0.000515925102)
    h2e[3, 8, 10, 9] = complex(-0.019165751498, 0.000314526978)
    h2e[5, 8, 10, 9] = complex(0.002134631020, -0.000054568740)
    h2e[7, 8, 10, 9] = complex(-0.000017749564, -0.000001702730)
    h2e[11, 8, 10, 9] = complex(0.014920616209, 0.000443756521)
    h2e[1, 10, 0, 9] = complex(-0.000006183003, 0.000003755374)
    h2e[3, 10, 0, 9] = complex(0.000000201668, -0.000000581211)
    h2e[5, 10, 0, 9] = complex(-0.000000969220, 0.000001521859)
    h2e[7, 10, 0, 9] = complex(-0.000276075452, 0.001081288721)
    h2e[9, 10, 0, 9] = complex(0.002103233408, -0.000653314455)
    h2e[1, 10, 2, 9] = complex(-0.000000276590, 0.000000955289)
    h2e[3, 10, 2, 9] = complex(-0.000021339296, 0.000012059919)
    h2e[5, 10, 2, 9] = complex(0.000036856137, -0.000020600196)
    h2e[7, 10, 2, 9] = complex(0.017505004465, -0.009858408716)
    h2e[9, 10, 2, 9] = complex(-0.019167550008, -0.000173159174)
    h2e[1, 10, 4, 9] = complex(0.000000268999, -0.000000555129)
    h2e[3, 10, 4, 9] = complex(0.000006886156, -0.000004273151)
    h2e[5, 10, 4, 9] = complex(0.000012136774, -0.000007452244)
    h2e[7, 10, 4, 9] = complex(0.001941524578, -0.001187652843)
    h2e[9, 10, 4, 9] = complex(-0.002134520327, 0.000058739332)
    h2e[1, 10, 6, 9] = complex(-0.000000001227, -0.000000000827)
    h2e[3, 10, 6, 9] = complex(-0.000000017150, -0.000000012464)
    h2e[5, 10, 6, 9] = complex(-0.000000021957, -0.000000015949)
    h2e[7, 10, 6, 9] = complex(-0.000002103690, -0.000001533762)
    h2e[9, 10, 6, 9] = complex(0.000009169187, 0.000015292884)
    h2e[1, 10, 10, 9] = complex(-0.000000583159, 0.000000129436)
    h2e[3, 10, 10, 9] = complex(0.000007003579, -0.000003858191)
    h2e[5, 10, 10, 9] = complex(-0.000032461227, 0.000017670997)
    h2e[7, 10, 10, 9] = complex(-0.012385855642, 0.007225665253)
    h2e[9, 10, 10, 9] = complex(0.014927213666, 0.000000000000)
    h2e[3, 0, 0, 11] = complex(-0.020370337565, -0.000032801424)
    h2e[5, 0, 0, 11] = complex(0.002992858432, 0.000005595041)
    h2e[7, 0, 0, 11] = complex(-0.000014784473, -0.000000095065)
    h2e[9, 0, 0, 11] = complex(-0.000006509613, -0.000003155518)
    h2e[11, 0, 0, 11] = complex(0.019092414462, 0.000000000000)
    h2e[3, 0, 2, 11] = complex(0.001062974321, -0.000052958253)
    h2e[5, 0, 2, 11] = complex(0.004370234267, -0.000216593007)
    h2e[7, 0, 2, 11] = complex(-0.000008657680, 0.000000252599)
    h2e[9, 0, 2, 11] = complex(-0.000000223092, -0.000000573329)
    h2e[11, 0, 2, 11] = complex(0.003079524564, -0.000158395930)
    h2e[3, 0, 4, 11] = complex(0.001554840436, -0.000145362954)
    h2e[5, 0, 4, 11] = complex(-0.001301395877, 0.000121328353)
    h2e[7, 0, 4, 11] = complex(0.000007753981, -0.000001469496)
    h2e[9, 0, 4, 11] = complex(-0.000001091769, -0.000001436483)
    h2e[11, 0, 4, 11] = complex(-0.002453453103, 0.000233360653)
    h2e[3, 0, 6, 11] = complex(-0.000001034679, -0.000003845036)
    h2e[5, 0, 6, 11] = complex(0.000004143720, 0.000008652295)
    h2e[7, 0, 6, 11] = complex(0.001612980670, 0.001576108249)
    h2e[9, 0, 6, 11] = complex(0.000835914705, -0.000739357529)
    h2e[11, 0, 6, 11] = complex(0.000001522453, 0.000007160880)
    h2e[3, 0, 8, 11] = complex(0.000000015254, -0.000000026422)
    h2e[5, 0, 8, 11] = complex(-0.000001211829, 0.000001372888)
    h2e[7, 0, 8, 11] = complex(-0.000348980270, 0.000965105745)
    h2e[9, 0, 8, 11] = complex(0.002121725578, 0.000590500725)
    h2e[11, 0, 8, 11] = complex(-0.000000590308, 0.000000091451)
    h2e[1, 2, 0, 11] = complex(-0.020338736555, 0.001134691069)
    h2e[5, 2, 0, 11] = complex(-0.000994900643, -0.000036247054)
    h2e[7, 2, 0, 11] = complex(0.000000933003, -0.000002689891)
    h2e[9, 2, 0, 11] = complex(-0.000000365451, -0.000000924947)
    h2e[11, 2, 0, 11] = complex(0.003079524564, 0.000158395930)
    h2e[1, 2, 2, 11] = complex(0.001058192131, -0.000113791027)
    h2e[5, 2, 2, 11] = complex(-0.000052577067, 0.000000786543)
    h2e[7, 2, 2, 11] = complex(-0.000023459314, 0.000000134902)
    h2e[9, 2, 2, 11] = complex(0.000021772023, 0.000011259938)
    h2e[11, 2, 2, 11] = complex(0.008141684206, 0.000000000000)
    h2e[1, 2, 4, 11] = complex(0.001543954031, -0.000234233048)
    h2e[5, 2, 4, 11] = complex(0.001934328572, -0.000113119488)
    h2e[7, 2, 4, 11] = complex(-0.000045675361, 0.000009738824)
    h2e[9, 2, 4, 11] = complex(0.000038433656, 0.000017481333)
    h2e[11, 2, 4, 11] = complex(0.005962085604, -0.000259155887)
    h2e[1, 2, 6, 11] = complex(-0.000001253340, -0.000003779418)
    h2e[5, 2, 6, 11] = complex(-0.000020712372, -0.000050598678)
    h2e[7, 2, 6, 11] = complex(-0.007263947879, -0.017808176148)
    h2e[9, 2, 6, 11] = complex(-0.000777378485, 0.020075086210)
    h2e[11, 2, 6, 11] = complex(-0.000000272475, -0.000011307097)
    h2e[1, 2, 8, 11] = complex(0.000000013715, -0.000000027253)
    h2e[5, 2, 8, 11] = complex(0.000045106594, -0.000023127705)
    h2e[7, 2, 8, 11] = complex(0.017785413137, -0.009195388968)
    h2e[9, 2, 8, 11] = complex(-0.019153930748, 0.000742895952)
    h2e[11, 2, 8, 11] = complex(-0.000007031846, 0.000003806431)
    h2e[1, 4, 0, 11] = complex(-0.002992720574, 0.000029265455)
    h2e[3, 4, 0, 11] = complex(-0.000992206472, -0.000081654493)
    h2e[7, 4, 0, 11] = complex(0.000000755762, 0.000001203706)
    h2e[9, 4, 0, 11] = complex(0.000000320154, 0.000000527285)
    h2e[11, 4, 0, 11] = complex(-0.002453453103, -0.000233360653)
    h2e[1, 4, 2, 11] = complex(-0.004367414976, 0.000267481783)
    h2e[3, 4, 2, 11] = complex(-0.000052558116, -0.000001615904)
    h2e[7, 4, 2, 11] = complex(0.000006800772, 0.000007146490)
    h2e[9, 4, 2, 11] = complex(-0.000007039947, -0.000004014735)
    h2e[11, 4, 2, 11] = complex(0.005962085604, 0.000259155887)
    h2e[1, 4, 4, 11] = complex(0.001299894389, -0.000136478478)
    h2e[3, 4, 4, 11] = complex(0.001937476626, -0.000024644761)
    h2e[7, 4, 4, 11] = complex(-0.000013555057, 0.000004895393)
    h2e[9, 4, 4, 11] = complex(0.000012711548, 0.000006422908)
    h2e[11, 4, 4, 11] = complex(0.017060726904, 0.000000000000)
    h2e[1, 4, 6, 11] = complex(-0.000004244218, -0.000008603443)
    h2e[3, 4, 6, 11] = complex(-0.000018379495, -0.000051491967)
    h2e[7, 4, 6, 11] = complex(-0.000695618084, -0.002024738904)
    h2e[9, 4, 6, 11] = complex(-0.000170055038, 0.002269607508)
    h2e[11, 4, 6, 11] = complex(0.000006394150, -0.000015710914)
    h2e[1, 4, 8, 11] = complex(0.000001195756, -0.000001386910)
    h2e[3, 4, 8, 11] = complex(0.000046115945, -0.000021043176)
    h2e[7, 4, 8, 11] = complex(0.002067289377, -0.000931226412)
    h2e[9, 4, 8, 11] = complex(-0.002135323126, 0.000004741692)
    h2e[11, 4, 8, 11] = complex(-0.000033352886, 0.000015924215)
    h2e[1, 6, 0, 11] = complex(0.000005568707, -0.000013695955)
    h2e[3, 6, 0, 11] = complex(-0.000002042060, -0.000001983935)
    h2e[5, 6, 0, 11] = complex(-0.000001400986, 0.000000239419)
    h2e[9, 6, 0, 11] = complex(-0.000000001143, 0.000000000939)
    h2e[11, 6, 0, 11] = complex(0.000001522453, -0.000007160880)
    h2e[1, 6, 2, 11] = complex(0.000002974688, -0.000008134523)
    h2e[3, 6, 2, 11] = complex(-0.000009808242, 0.000021310936)
    h2e[5, 6, 2, 11] = complex(-0.000009200411, 0.000003560235)
    h2e[9, 6, 2, 11] = complex(0.000000016675, -0.000000013092)
    h2e[11, 6, 2, 11] = complex(-0.000000272475, 0.000011307097)
    h2e[1, 6, 4, 11] = complex(-0.000001509495, 0.000007746293)
    h2e[3, 6, 4, 11] = complex(-0.000010511395, 0.000045503778)
    h2e[5, 6, 4, 11] = complex(0.000000645795, -0.000014397479)
    h2e[9, 6, 4, 11] = complex(-0.000000020562, 0.000000017711)
    h2e[11, 6, 4, 11] = complex(0.000006394150, 0.000015710914)
    h2e[1, 6, 6, 11] = complex(-0.002061734105, 0.000913825122)
    h2e[3, 6, 6, 11] = complex(-0.019208845010, -0.000957261480)
    h2e[5, 6, 6, 11] = complex(0.002136986642, 0.000129384058)
    h2e[9, 6, 6, 11] = complex(-0.000002325124, -0.000001171211)
    h2e[11, 6, 6, 11] = complex(0.015018592307, 0.000000000000)
    h2e[1, 6, 8, 11] = complex(-0.000766986937, -0.000681870509)
    h2e[3, 6, 8, 11] = complex(-0.000802234531, -0.020005812113)
    h2e[5, 6, 8, 11] = complex(0.000072174722, 0.002266199198)
    h2e[9, 6, 8, 11] = complex(0.000008710507, -0.000015558707)
    h2e[11, 6, 8, 11] = complex(0.001197994406, 0.014289313061)
    h2e[1, 8, 0, 11] = complex(0.000006700061, 0.000002727918)
    h2e[3, 8, 0, 11] = complex(-0.000000372262, -0.000000922226)
    h2e[5, 8, 0, 11] = complex(-0.000000347673, -0.000000509561)
    h2e[7, 8, 0, 11] = complex(0.000000001339, 0.000000000628)
    h2e[11, 8, 0, 11] = complex(-0.000000590308, -0.000000091451)
    h2e[1, 8, 2, 11] = complex(0.000000259704, 0.000000557700)
    h2e[3, 8, 2, 11] = complex(0.000021854479, 0.000011099049)
    h2e[5, 8, 2, 11] = complex(0.000007242999, 0.000003635650)
    h2e[7, 8, 2, 11] = complex(-0.000000018990, -0.000000009426)
    h2e[11, 8, 2, 11] = complex(-0.000007031846, -0.000003806431)
    h2e[1, 8, 4, 11] = complex(0.000001182385, 0.000001362868)
    h2e[3, 8, 4, 11] = complex(0.000038561544, 0.000017197386)
    h2e[5, 8, 4, 11] = complex(-0.000013034353, -0.000005739583)
    h2e[7, 8, 4, 11] = complex(0.000000024831, 0.000000010949)
    h2e[11, 8, 4, 11] = complex(-0.000033352886, -0.000015924215)
    h2e[1, 8, 6, 11] = complex(-0.000786348540, 0.000791870523)
    h2e[3, 8, 6, 11] = complex(-0.000629291181, 0.020080273813)
    h2e[5, 8, 6, 11] = complex(0.000049424564, -0.002275432744)
    h2e[7, 8, 6, 11] = complex(-0.000000057667, 0.000002602809)
    h2e[11, 8, 6, 11] = complex(0.001197994406, -0.014289313061)
    h2e[1, 8, 8, 11] = complex(-0.002155473061, -0.000452046933)
    h2e[3, 8, 8, 11] = complex(-0.019147930448, 0.000884147808)
    h2e[5, 8, 8, 11] = complex(0.002132065345, -0.000118002975)
    h2e[7, 8, 8, 11] = complex(-0.000017792337, -0.000001174318)
    h2e[11, 8, 8, 11] = complex(0.014927213672, 0.000000000000)
    h2e[1, 10, 0, 11] = complex(0.019007317529, -0.001800602762)
    h2e[3, 10, 0, 11] = complex(-0.003083280960, -0.000044037852)
    h2e[5, 10, 0, 11] = complex(-0.002464347922, -0.000029641904)
    h2e[7, 10, 0, 11] = complex(0.000007065931, -0.000001915380)
    h2e[9, 10, 0, 11] = complex(-0.000000592767, -0.000000073861)
    h2e[1, 10, 2, 11] = complex(0.003050860497, -0.000448119445)
    h2e[3, 10, 2, 11] = complex(-0.008136079260, 0.000302052974)
    h2e[5, 10, 2, 11] = complex(0.005963092809, -0.000234841822)
    h2e[7, 10, 2, 11] = complex(-0.000010183877, 0.000004920705)
    h2e[9, 10, 2, 11] = complex(-0.000007141894, -0.000003595706)
    h2e[1, 10, 4, 11] = complex(-0.002420509592, 0.000463705336)
    h2e[3, 10, 4, 11] = complex(-0.005948366578, 0.000480168282)
    h2e[5, 10, 4, 11] = complex(0.017002274415, -0.001411051810)
    h2e[7, 10, 4, 11] = complex(-0.000011057616, 0.000012862623)
    h2e[9, 10, 4, 11] = complex(-0.000033811536, -0.000014925663)
    h2e[1, 10, 6, 11] = complex(0.000002191009, 0.000006985381)
    h2e[3, 10, 6, 11] = complex(0.000000691776, 0.000011289204)
    h2e[5, 10, 6, 11] = complex(0.000005072832, -0.000016185931)
    h2e[7, 10, 6, 11] = complex(0.006857880362, 0.013361421777)
    h2e[9, 10, 6, 11] = complex(0.000772671937, -0.014318611540)
    h2e[1, 10, 8, 11] = complex(-0.000000579052, 0.000000146715)
    h2e[3, 10, 8, 11] = complex(0.000006885788, -0.000004064689)
    h2e[5, 10, 8, 11] = complex(-0.000031921560, 0.000018628194)
    h2e[7, 10, 8, 11] = complex(-0.012165576679, 0.007590678652)
    h2e[9, 10, 8, 11] = complex(0.014920616209, -0.000443756521)
    h2e[1, 1, 2, 1] = complex(0.361074525506, 0.020828200324)
    h2e[3, 1, 2, 1] = complex(-0.007743479294, -0.000764590630)
    h2e[5, 1, 2, 1] = complex(-0.002032299059, -0.000139224669)
    h2e[7, 1, 2, 1] = complex(0.000004425426, 0.000005040103)
    h2e[9, 1, 2, 1] = complex(0.000000192424, 0.000000165115)
    h2e[11, 1, 2, 1] = complex(0.009777990960, 0.001407846009)
    h2e[1, 1, 4, 1] = complex(-0.166797154588, -0.001946077945)
    h2e[3, 1, 4, 1] = complex(0.003237823213, 0.000170036951)
    h2e[5, 1, 4, 1] = complex(0.002042718501, 0.000045858540)
    h2e[7, 1, 4, 1] = complex(-0.000004271744, -0.000006943410)
    h2e[9, 1, 4, 1] = complex(0.000011540053, 0.000008751065)
    h2e[11, 1, 4, 1] = complex(0.001444605190, 0.000140633636)
    h2e[1, 1, 6, 1] = complex(0.000158487300, 0.000411328741)
    h2e[3, 1, 6, 1] = complex(-0.000002788464, -0.000008093847)
    h2e[5, 1, 6, 1] = complex(0.000000050897, -0.000005874926)
    h2e[7, 1, 6, 1] = complex(0.001775648169, -0.000574158188)
    h2e[9, 1, 6, 1] = complex(-0.002412420434, 0.006028032550)
    h2e[11, 1, 6, 1] = complex(-0.000000894444, -0.000000928921)
    h2e[3, 1, 8, 1] = complex(-0.000000226450, 0.000000115882)
    h2e[5, 1, 8, 1] = complex(0.000013037569, -0.000006395411)
    h2e[7, 1, 8, 1] = complex(0.005468438820, -0.003567556159)
    h2e[9, 1, 8, 1] = complex(-0.000211741633, 0.001598209630)
    h2e[11, 1, 8, 1] = complex(-0.000001506385, 0.000001215737)
    h2e[1, 1, 10, 1] = complex(-0.129304722944, -0.012495694857)
    h2e[3, 1, 10, 1] = complex(0.003134500704, 0.000432578323)
    h2e[5, 1, 10, 1] = complex(-0.000290404705, -0.000031226764)
    h2e[7, 1, 10, 1] = complex(0.000003299310, 0.000000492878)
    h2e[9, 1, 10, 1] = complex(0.000001141869, 0.000001526527)
    h2e[11, 1, 10, 1] = complex(-0.009106613486, -0.001673282187)
    h2e[1, 3, 2, 1] = complex(-0.007780034980, -0.000130866795)
    h2e[3, 3, 2, 1] = complex(0.011566531943, 0.000667203104)
    h2e[5, 3, 2, 1] = complex(0.008187914039, 0.000470726058)
    h2e[7, 3, 2, 1] = complex(-0.000021289933, -0.000001265904)
    h2e[9, 3, 2, 1] = complex(0.000000671361, 0.000000371960)
    h2e[11, 3, 2, 1] = complex(-0.003463118787, -0.000205411225)
    h2e[1, 3, 4, 1] = complex(0.003240908911, -0.000094447413)
    h2e[3, 3, 4, 1] = complex(-0.013836467691, -0.000161434676)
    h2e[5, 3, 4, 1] = complex(0.012721308310, 0.000145968991)
    h2e[7, 3, 4, 1] = complex(0.000006312581, -0.000000483958)
    h2e[9, 3, 4, 1] = complex(0.000026773254, 0.000013141229)
    h2e[11, 3, 4, 1] = complex(0.014261559772, 0.000189565098)
    h2e[1, 3, 6, 1] = complex(-0.000003391824, -0.000007928785)
    h2e[3, 3, 6, 1] = complex(0.000012698043, 0.000032955764)
    h2e[5, 3, 6, 1] = complex(0.000002385316, 0.000004098670)
    h2e[7, 3, 6, 1] = complex(0.005457340009, 0.012709522012)
    h2e[9, 3, 6, 1] = complex(-0.000332164156, 0.012594166571)
    h2e[11, 3, 6, 1] = complex(-0.000014686746, -0.000037618203)
    h2e[1, 3, 8, 1] = complex(0.000000209647, -0.000000143554)
    h2e[5, 3, 8, 1] = complex(0.000030816291, -0.000012169928)
    h2e[7, 3, 8, 1] = complex(0.011911301305, -0.004181550329)
    h2e[9, 3, 8, 1] = complex(0.013790526941, 0.001209999725)
    h2e[11, 3, 8, 1] = complex(-0.000004494252, 0.000001897308)
    h2e[1, 3, 10, 1] = complex(0.003159330564, 0.000175642257)
    h2e[3, 3, 10, 1] = complex(0.003358432044, 0.000324550728)
    h2e[5, 3, 10, 1] = complex(-0.017386033531, -0.001676758396)
    h2e[7, 3, 10, 1] = complex(0.000047624000, 0.000004725261)
    h2e[9, 3, 10, 1] = complex(0.000006829434, 0.000004275096)
    h2e[11, 3, 10, 1] = complex(-0.010003204582, -0.000983089409)
    h2e[1, 5, 2, 1] = complex(-0.002034828135, -0.000095383234)
    h2e[3, 5, 2, 1] = complex(0.008187727461, 0.000473885422)
    h2e[5, 5, 2, 1] = complex(0.009776478738, 0.000563945787)
    h2e[7, 5, 2, 1] = complex(0.000006211865, 0.000000335060)
    h2e[9, 5, 2, 1] = complex(0.000000290451, 0.000000159422)
    h2e[11, 5, 2, 1] = complex(0.004210362510, 0.000249559215)
    h2e[1, 5, 4, 1] = complex(0.002043232384, 0.000001813533)
    h2e[3, 5, 4, 1] = complex(0.012721078799, 0.000150875850)
    h2e[5, 5, 4, 1] = complex(0.005047315153, 0.000058888707)
    h2e[7, 5, 4, 1] = complex(-0.000008044379, -0.000000181548)
    h2e[9, 5, 4, 1] = complex(0.000011452880, 0.000005564546)
    h2e[11, 5, 4, 1] = complex(0.003529899055, 0.000046774138)
    h2e[1, 5, 6, 1] = complex(-0.000003775194, -0.000003960101)
    h2e[3, 5, 6, 1] = complex(-0.000025053850, -0.000062884312)
    h2e[5, 5, 6, 1] = complex(-0.000004427970, -0.000011492098)
    h2e[7, 5, 6, 1] = complex(0.002364636634, 0.005654056042)
    h2e[9, 5, 6, 1] = complex(-0.000086733804, 0.005381277333)
    h2e[11, 5, 6, 1] = complex(0.000000786933, 0.000000691116)
    h2e[1, 5, 8, 1] = complex(-0.000012076871, 0.000008056049)
    h2e[3, 5, 8, 1] = complex(-0.000030840729, 0.000012131764)
    h2e[7, 5, 8, 1] = complex(0.005113599050, -0.001724533253)
    h2e[9, 5, 8, 1] = complex(0.006112249628, 0.000483094979)
    h2e[11, 5, 8, 1] = complex(0.000009654020, -0.000004016282)
    h2e[1, 5, 10, 1] = complex(-0.000291022194, -0.000024960143)
    h2e[3, 5, 10, 1] = complex(-0.017385427013, -0.001683471241)
    h2e[5, 5, 10, 1] = complex(-0.012075947077, -0.001166990241)
    h2e[7, 5, 10, 1] = complex(0.000020382319, 0.000001962509)
    h2e[9, 5, 10, 1] = complex(0.000003046806, 0.000001888902)
    h2e[11, 5, 10, 1] = complex(-0.006624495613, -0.000650763152)
    h2e[1, 7, 2, 1] = complex(0.000004912564, -0.000004582607)
    h2e[3, 7, 2, 1] = complex(-0.000022942405, -0.000001305171)
    h2e[5, 7, 2, 1] = complex(0.000005476592, 0.000000334040)
    h2e[7, 7, 2, 1] = complex(0.010336439939, 0.000596246554)
    h2e[11, 7, 2, 1] = complex(-0.000009825784, -0.000000280936)
    h2e[1, 7, 4, 1] = complex(-0.000005042693, 0.000002399823)
    h2e[3, 7, 4, 1] = complex(-0.000059082301, -0.000001229175)
    h2e[5, 7, 4, 1] = complex(-0.000036991491, -0.000000690206)
    h2e[7, 7, 4, 1] = complex(-0.004663729042, -0.000054413280)
    h2e[9, 7, 4, 1] = complex(-0.000000030752, -0.000000013275)
    h2e[11, 7, 4, 1] = complex(-0.000002046373, 0.000000795393)
    h2e[1, 7, 6, 1] = complex(0.000060833285, -0.000028518355)
    h2e[3, 7, 6, 1] = complex(-0.004941938397, -0.012707759984)
    h2e[5, 7, 6, 1] = complex(-0.002190159571, -0.005630202375)
    h2e[7, 7, 6, 1] = complex(0.000004334317, 0.000011249037)
    h2e[9, 7, 6, 1] = complex(-0.000000409846, -0.000014293071)
    h2e[11, 7, 6, 1] = complex(0.001559717446, 0.004015588864)
    h2e[1, 7, 8, 1] = complex(-0.005628947125, 0.002774112016)
    h2e[3, 7, 8, 1] = complex(-0.011380299549, 0.004980671997)
    h2e[5, 7, 8, 1] = complex(-0.004855634130, 0.002133783111)
    h2e[9, 7, 8, 1] = complex(-0.000016181127, -0.000001452364)
    h2e[11, 7, 8, 1] = complex(0.004358645831, -0.001859575265)
    h2e[1, 7, 10, 1] = complex(-0.000001894614, -0.000001248981)
    h2e[3, 7, 10, 1] = complex(0.000031881378, 0.000003179336)
    h2e[5, 7, 10, 1] = complex(0.000013408075, 0.000001439675)
    h2e[7, 7, 10, 1] = complex(-0.003293820615, -0.000318306837)
    h2e[9, 7, 10, 1] = complex(-0.000000008070, -0.000000004891)
    h2e[11, 7, 10, 1] = complex(0.000022207222, 0.000001635141)
    h2e[1, 9, 2, 1] = complex(-0.000000208581, 0.000000145096)
    h2e[3, 9, 2, 1] = complex(-0.000000710950, 0.000000290581)
    h2e[5, 9, 2, 1] = complex(-0.000000307477, 0.000000124058)
    h2e[9, 9, 2, 1] = complex(0.010332504552, 0.000596019546)
    h2e[11, 9, 2, 1] = complex(0.000000254090, -0.000000109482)
    h2e[1, 9, 4, 1] = complex(-0.000011632537, 0.000008685323)
    h2e[3, 9, 4, 1] = complex(-0.000027162484, 0.000012386547)
    h2e[5, 9, 4, 1] = complex(-0.000011622320, 0.000005232755)
    h2e[7, 9, 4, 1] = complex(0.000000031196, -0.000000012400)
    h2e[9, 9, 4, 1] = complex(-0.004661954605, -0.000054392577)
    h2e[11, 9, 4, 1] = complex(0.000010228320, -0.000004906968)
    h2e[1, 9, 6, 1] = complex(-0.004924894206, -0.003889236465)
    h2e[3, 9, 6, 1] = complex(-0.009385861089, -0.008129424904)
    h2e[5, 9, 6, 1] = complex(-0.004012419105, -0.003464783753)
    h2e[7, 9, 6, 1] = complex(0.000010042423, 0.000009503785)
    h2e[9, 9, 6, 1] = complex(0.000004332632, 0.000011244662)
    h2e[11, 9, 6, 1] = complex(0.003551350910, 0.003134118940)
    h2e[1, 9, 8, 1] = complex(-0.000055115800, -0.000038954640)
    h2e[3, 9, 8, 1] = complex(-0.008639035954, 0.010619169778)
    h2e[5, 9, 8, 1] = complex(-0.003827220328, 0.004705371103)
    h2e[7, 9, 8, 1] = complex(0.000009897872, -0.000012471855)
    h2e[11, 9, 8, 1] = complex(0.002730770649, -0.003353850569)
    h2e[1, 9, 10, 1] = complex(-0.000001438320, 0.000001208311)
    h2e[3, 9, 10, 1] = complex(-0.000007473746, 0.000002988806)
    h2e[5, 9, 10, 1] = complex(-0.000003329984, 0.000001317969)
    h2e[7, 9, 10, 1] = complex(0.000000008790, -0.000000003377)
    h2e[9, 9, 10, 1] = complex(-0.003292373674, -0.000318167008)
    h2e[11, 9, 10, 1] = complex(0.000002519071, -0.000001058890)
    h2e[1, 11, 2, 1] = complex(0.009875016842, -0.000274183116)
    h2e[3, 11, 2, 1] = complex(-0.003463767316, -0.000194158839)
    h2e[5, 11, 2, 1] = complex(0.004211130555, 0.000236225663)
    h2e[7, 11, 2, 1] = complex(-0.000010306263, -0.000000860313)
    h2e[9, 11, 2, 1] = complex(-0.000000239637, -0.000000137907)
    h2e[11, 11, 2, 1] = complex(0.006850273639, 0.000395150756)
    h2e[1, 11, 4, 1] = complex(0.001447481312, -0.000106889440)
    h2e[3, 11, 4, 1] = complex(0.014262120812, 0.000143230217)
    h2e[5, 11, 4, 1] = complex(0.003529984526, 0.000035595802)
    h2e[7, 11, 4, 1] = complex(-0.000022690457, -0.000000172979)
    h2e[9, 11, 4, 1] = complex(-0.000010093835, -0.000005154855)
    h2e[11, 11, 4, 1] = complex(-0.014577040997, -0.000170075191)
    h2e[1, 11, 6, 1] = complex(-0.000002367035, -0.000005989697)
    h2e[3, 11, 6, 1] = complex(-0.000011311060, -0.000029811673)
    h2e[5, 11, 6, 1] = complex(-0.000006884715, -0.000016608469)
    h2e[7, 11, 6, 1] = complex(-0.001939193469, -0.003919690748)
    h2e[9, 11, 6, 1] = complex(0.000339059162, -0.004790580198)
    h2e[11, 11, 6, 1] = complex(0.000013235414, 0.000034350425)
    h2e[1, 11, 8, 1] = complex(0.000001401763, -0.000001250535)
    h2e[3, 11, 8, 1] = complex(0.000004466262, -0.000001942021)
    h2e[5, 11, 8, 1] = complex(-0.000009585329, 0.000004127427)
    h2e[7, 11, 8, 1] = complex(-0.004422303264, 0.001851777034)
    h2e[9, 11, 8, 1] = complex(-0.004351511223, -0.000598515261)
    h2e[1, 11, 10, 1] = complex(-0.009258508768, -0.000101478558)
    h2e[3, 11, 10, 1] = complex(-0.010006340335, -0.000950584502)
    h2e[5, 11, 10, 1] = complex(-0.006626535265, -0.000629784299)
    h2e[7, 11, 10, 1] = complex(0.000016579353, 0.000002197843)
    h2e[9, 11, 10, 1] = complex(-0.000002287089, -0.000001501233)
    h2e[11, 11, 10, 1] = complex(0.008101979308, 0.000782955633)
    h2e[1, 1, 0, 3] = complex(0.361674738938, 0.000100528206)
    h2e[3, 1, 0, 3] = complex(-0.007774571271, -0.000319549618)
    h2e[5, 1, 0, 3] = complex(-0.002036937817, -0.000022523329)
    h2e[7, 1, 0, 3] = complex(0.000004707004, 0.000004778195)
    h2e[9, 1, 0, 3] = complex(0.000000201571, 0.000000153816)
    h2e[11, 1, 0, 3] = complex(0.009842604419, 0.000845148421)
    h2e[1, 1, 4, 3] = complex(0.007226554178, -0.000580981524)
    h2e[3, 1, 4, 3] = complex(-0.000072553775, 0.000002861808)
    h2e[5, 1, 4, 3] = complex(0.000070510419, -0.000004911349)
    h2e[7, 1, 4, 3] = complex(-0.000036356732, -0.000000911471)
    h2e[9, 1, 4, 3] = complex(0.000029721685, 0.000014588421)
    h2e[11, 1, 4, 3] = complex(0.000482820165, 0.000002489364)
    h2e[1, 1, 6, 3] = complex(0.000020579060, -0.000039266244)
    h2e[3, 1, 6, 3] = complex(0.000000112613, 0.000001090410)
    h2e[5, 1, 6, 3] = complex(-0.000011486691, -0.000030809670)
    h2e[7, 1, 6, 3] = complex(-0.004790073882, -0.012986141329)
    h2e[9, 1, 6, 3] = complex(-0.000332311120, 0.012599735093)
    h2e[11, 1, 6, 3] = complex(0.000004140443, 0.000005567133)
    h2e[3, 1, 8, 3] = complex(-0.000000713074, 0.000000285330)
    h2e[5, 1, 8, 3] = complex(0.000027759274, -0.000010962655)
    h2e[7, 1, 8, 3] = complex(0.011906037070, -0.004179702178)
    h2e[9, 1, 8, 3] = complex(-0.013822554785, -0.000587265189)
    h2e[11, 1, 8, 3] = complex(-0.000007427852, 0.000003135766)
    h2e[1, 1, 10, 3] = complex(-0.062177435643, 0.000770643054)
    h2e[3, 1, 10, 3] = complex(0.000165254385, 0.000004695696)
    h2e[5, 1, 10, 3] = complex(0.000427017336, -0.000000690441)
    h2e[7, 1, 10, 3] = complex(-0.000005169130, -0.000001550754)
    h2e[9, 1, 10, 3] = complex(0.000004132177, 0.000002586664)
    h2e[11, 1, 10, 3] = complex(0.001491443857, 0.000109046286)
    h2e[1, 3, 0, 3] = complex(-0.007774747708, 0.000315227654)
    h2e[3, 3, 0, 3] = complex(0.011585758965, 0.000003220285)
    h2e[5, 3, 0, 3] = complex(0.008201433951, 0.000000697173)
    h2e[7, 3, 0, 3] = complex(-0.000021327491, -0.000000043682)
    h2e[9, 3, 0, 3] = complex(0.000000691575, 0.000000332872)
    h2e[11, 3, 0, 3] = complex(-0.003469199036, -0.000006599800)
    h2e[1, 3, 4, 3] = complex(-0.000072083383, 0.000008766641)
    h2e[3, 3, 4, 3] = complex(-0.000783822081, 0.000063015669)
    h2e[5, 3, 4, 3] = complex(0.007290667980, -0.000587549767)
    h2e[7, 3, 4, 3] = complex(-0.000018464699, -0.000011846476)
    h2e[9, 3, 4, 3] = complex(-0.000038352059, -0.000028802627)
    h2e[11, 3, 4, 3] = complex(0.000170701027, -0.000013443474)
    h2e[1, 3, 6, 3] = complex(-0.000000555493, -0.000000390089)
    h2e[3, 3, 6, 3] = complex(0.000000052851, -0.000000100844)
    h2e[5, 3, 6, 3] = complex(0.000028031526, -0.000038362112)
    h2e[7, 3, 6, 3] = complex(0.009538699105, -0.004570485372)
    h2e[9, 3, 6, 3] = complex(0.009915770793, -0.018316046988)
    h2e[11, 3, 6, 3] = complex(0.000000356049, 0.000011387485)
    h2e[1, 3, 8, 3] = complex(0.000000667651, -0.000000379090)
    h2e[5, 3, 8, 3] = complex(-0.000036348566, 0.000031529378)
    h2e[7, 3, 8, 3] = complex(-0.012091145919, 0.017105357789)
    h2e[9, 3, 8, 3] = complex(0.000021625332, 0.009128283254)
    h2e[11, 3, 8, 3] = complex(-0.000002279611, -0.000001164234)
    h2e[1, 3, 10, 3] = complex(0.000165086689, -0.000008789990)
    h2e[3, 3, 10, 3] = complex(-0.028346906019, 0.000351338810)
    h2e[5, 3, 10, 3] = complex(0.000921458484, -0.000011598271)
    h2e[7, 3, 10, 3] = complex(0.000017134607, -0.000002096503)
    h2e[9, 3, 10, 3] = complex(0.000002260297, -0.000001020548)
    h2e[11, 3, 10, 3] = complex(0.026537339064, -0.000285796152)
    h2e[1, 5, 0, 3] = complex(-0.002036950153, 0.000021390991)
    h2e[3, 5, 0, 3] = complex(0.008201428745, 0.000003862036)
    h2e[5, 5, 0, 3] = complex(0.009792730158, 0.000002721909)
    h2e[7, 5, 0, 3] = complex(0.000006220857, -0.000000021497)
    h2e[9, 5, 0, 3] = complex(0.000000299110, 0.000000142514)
    h2e[11, 5, 0, 3] = complex(0.004217744734, 0.000007850158)
    h2e[1, 5, 4, 3] = complex(0.000070559756, -0.000006441632)
    h2e[3, 5, 4, 3] = complex(0.007290894009, -0.000584739175)
    h2e[5, 5, 4, 3] = complex(0.002398177415, -0.000192802370)
    h2e[7, 5, 4, 3] = complex(0.000009947879, -0.000005728684)
    h2e[9, 5, 4, 3] = complex(-0.000017124007, -0.000011785243)
    h2e[11, 5, 4, 3] = complex(0.005217385498, -0.000411142565)
    h2e[1, 5, 6, 3] = complex(0.000015728963, 0.000028486842)
    h2e[3, 5, 6, 3] = complex(0.000004647870, -0.000024583191)
    h2e[5, 5, 6, 3] = complex(0.000005707354, -0.000010890020)
    h2e[7, 5, 6, 3] = complex(0.004007456186, -0.000493688341)
    h2e[9, 5, 6, 3] = complex(0.003510726381, -0.007800705264)
    h2e[11, 5, 6, 3] = complex(0.000011029988, -0.000037659388)
    h2e[1, 5, 8, 3] = complex(-0.000026032324, 0.000014589871)
    h2e[3, 5, 8, 3] = complex(0.000036155528, -0.000031922214)
    h2e[7, 5, 8, 3] = complex(-0.005442449556, 0.006682342349)
    h2e[9, 5, 8, 3] = complex(0.001293597126, 0.003240488249)
    h2e[11, 5, 8, 3] = complex(0.000001813522, 0.000003158820)
    h2e[1, 5, 10, 3] = complex(0.000426923626, -0.000009894897)
    h2e[3, 5, 10, 3] = complex(0.000921418932, -0.000011242656)
    h2e[5, 5, 10, 3] = complex(-0.004959694578, 0.000061471724)
    h2e[7, 5, 10, 3] = complex(-0.000072137776, 0.000000553745)
    h2e[9, 5, 10, 3] = complex(0.000000336441, -0.000000548573)
    h2e[11, 5, 10, 3] = complex(-0.016117093121, 0.000174237914)
    h2e[1, 7, 0, 3] = complex(0.000004641857, -0.000004856618)
    h2e[3, 7, 0, 3] = complex(-0.000022979497, 0.000000011820)
    h2e[5, 7, 0, 3] = complex(0.000005486735, 0.000000019624)
    h2e[7, 7, 0, 3] = complex(0.010353622182, 0.000002877810)
    h2e[11, 7, 0, 3] = complex(-0.000009825735, 0.000000282648)
    h2e[1, 7, 4, 3] = complex(0.000035763832, -0.000004642770)
    h2e[3, 7, 4, 3] = complex(-0.000020827043, -0.000012776000)
    h2e[5, 7, 4, 3] = complex(0.000002317755, -0.000005667478)
    h2e[7, 7, 4, 3] = complex(0.003842345694, -0.000308906818)
    h2e[9, 7, 4, 3] = complex(0.000000040421, 0.000000042827)
    h2e[11, 7, 4, 3] = complex(-0.000030193348, 0.000006192311)
    h2e[1, 7, 6, 3] = complex(0.006611574710, 0.011924713304)
    h2e[3, 7, 6, 3] = complex(0.000112932074, -0.000052906332)
    h2e[5, 7, 6, 3] = complex(-0.000469387652, -0.001180288984)
    h2e[7, 7, 6, 3] = complex(0.000010901230, -0.000020800286)
    h2e[9, 7, 6, 3] = complex(-0.000013999820, 0.000020771741)
    h2e[11, 7, 6, 3] = complex(-0.002286449086, -0.005327846586)
    h2e[1, 7, 8, 3] = complex(-0.010595188779, 0.006476305839)
    h2e[3, 7, 8, 3] = complex(0.016701104631, -0.007797376712)
    h2e[5, 7, 8, 3] = complex(0.007083381060, -0.003330279385)
    h2e[9, 7, 8, 3] = complex(-0.000004035128, -0.000013344384)
    h2e[11, 7, 8, 3] = complex(-0.000069968046, 0.000014616763)
    h2e[1, 7, 10, 3] = complex(0.000003313792, 0.000000617020)
    h2e[3, 7, 10, 3] = complex(-0.000000215466, -0.000002111245)
    h2e[5, 7, 10, 3] = complex(-0.000078721836, 0.000000002348)
    h2e[7, 7, 10, 3] = complex(-0.032057377297, 0.000397327341)
    h2e[9, 7, 10, 3] = complex(-0.000000001649, 0.000000003147)
    h2e[11, 7, 10, 3] = complex(0.000050924031, -0.000001421441)
    h2e[1, 9, 0, 3] = complex(-0.000000199922, 0.000000156812)
    h2e[3, 9, 0, 3] = complex(-0.000000693128, 0.000000330849)
    h2e[5, 9, 0, 3] = complex(-0.000000299862, 0.000000141475)
    h2e[9, 9, 0, 3] = complex(0.010349680252, 0.000002876714)
    h2e[11, 9, 0, 3] = complex(0.000000247398, -0.000000123865)
    h2e[1, 9, 4, 3] = complex(-0.000027999327, 0.000017706745)
    h2e[3, 9, 4, 3] = complex(0.000034411319, -0.000033795138)
    h2e[5, 9, 4, 3] = complex(0.000015528845, -0.000013943025)
    h2e[7, 9, 4, 3] = complex(-0.000000034974, 0.000000047925)
    h2e[9, 9, 4, 3] = complex(0.003842327175, -0.000308905329)
    h2e[11, 9, 4, 3] = complex(0.000002378962, 0.000003677118)
    h2e[1, 9, 6, 3] = complex(-0.010407349752, -0.006784100818)
    h2e[3, 9, 6, 3] = complex(0.014220865848, 0.011725738954)
    h2e[5, 9, 6, 3] = complex(0.006052355695, 0.004963185249)
    h2e[7, 9, 6, 3] = complex(-0.000018959287, -0.000009309779)
    h2e[9, 9, 6, 3] = complex(0.000010901161, -0.000020800153)
    h2e[11, 9, 6, 3] = complex(-0.000043281253, -0.000056885149)
    h2e[1, 9, 8, 3] = complex(0.007127051253, -0.011687807718)
    h2e[3, 9, 8, 3] = complex(-0.000102281167, -0.000072290162)
    h2e[5, 9, 8, 3] = complex(-0.000796950877, 0.000995061101)
    h2e[7, 9, 8, 3] = complex(-0.000001720108, -0.000005503388)
    h2e[11, 9, 8, 3] = complex(-0.003514659402, 0.004638102707)
    h2e[1, 9, 10, 3] = complex(-0.000004237636, 0.000002397690)
    h2e[3, 9, 10, 3] = complex(-0.000002019237, -0.000000734622)
    h2e[5, 9, 10, 3] = complex(-0.000000247996, -0.000000434666)
    h2e[7, 9, 10, 3] = complex(0.000000001335, 0.000000002879)
    h2e[9, 9, 10, 3] = complex(-0.032056919869, 0.000397321671)
    h2e[11, 9, 10, 3] = complex(0.000002954222, -0.000000768005)
    h2e[1, 11, 0, 3] = complex(0.009843072539, -0.000839676727)
    h2e[3, 11, 0, 3] = complex(-0.003469201616, 0.000004671258)
    h2e[5, 11, 0, 3] = complex(0.004217747361, -0.000005505497)
    h2e[7, 11, 0, 3] = complex(-0.000010338629, -0.000000268239)
    h2e[9, 11, 0, 3] = complex(-0.000000247146, -0.000000123946)
    h2e[11, 11, 0, 3] = complex(0.006861660835, 0.000001907212)
    h2e[1, 11, 4, 3] = complex(0.000476179691, -0.000079585622)
    h2e[3, 11, 4, 3] = complex(0.000170612601, -0.000013995078)
    h2e[5, 11, 4, 3] = complex(0.005216119719, -0.000427665765)
    h2e[7, 11, 4, 3] = complex(-0.000001300203, 0.000003382631)
    h2e[9, 11, 4, 3] = complex(-0.000001816566, 0.000003599832)
    h2e[11, 11, 4, 3] = complex(-0.004333341942, 0.000348380645)
    h2e[1, 11, 6, 3] = complex(-0.000003183115, -0.000008736033)
    h2e[3, 11, 6, 3] = complex(-0.000003603837, -0.000005934981)
    h2e[5, 11, 6, 3] = complex(0.000015715083, -0.000011945156)
    h2e[7, 11, 6, 3] = complex(-0.000155504580, 0.006596373603)
    h2e[9, 11, 6, 3] = complex(-0.003319779253, -0.000028116721)
    h2e[11, 11, 6, 3] = complex(-0.000009200169, 0.000017554547)
    h2e[1, 11, 8, 3] = complex(0.000006882830, -0.000004169225)
    h2e[3, 11, 8, 3] = complex(0.000002040184, 0.000000674270)
    h2e[5, 11, 8, 3] = complex(-0.000001359111, -0.000002225686)
    h2e[7, 11, 8, 3] = complex(-0.001326611305, -0.002651599495)
    h2e[9, 11, 8, 3] = complex(0.005868341883, -0.003030429562)
    h2e[1, 11, 10, 3] = complex(0.001488277630, -0.000145977320)
    h2e[3, 11, 10, 3] = complex(0.026536270496, -0.000372011540)
    h2e[5, 11, 10, 3] = complex(-0.016116462712, 0.000225272583)
    h2e[7, 11, 10, 3] = complex(0.000049868677, 0.000001454308)
    h2e[9, 11, 10, 3] = complex(-0.000002986907, -0.000000780666)
    h2e[11, 11, 10, 3] = complex(-0.010246369596, 0.000126996128)
    h2e[1, 1, 0, 5] = complex(0.166808506949, 0.000003131608)
    h2e[3, 1, 0, 5] = complex(-0.003239584118, -0.000132312007)
    h2e[5, 1, 0, 5] = complex(-0.002043114078, -0.000022062321)
    h2e[7, 1, 0, 5] = complex(0.000004352330, 0.000006893183)
    h2e[9, 1, 0, 5] = complex(-0.000011641200, -0.000008616056)
    h2e[11, 1, 0, 5] = complex(-0.001446145259, -0.000123797672)
    h2e[1, 1, 2, 5] = complex(0.007245549338, -0.000250279087)
    h2e[3, 1, 2, 5] = complex(-0.000072608766, -0.000000455305)
    h2e[5, 1, 2, 5] = complex(0.000070661163, -0.000001685433)
    h2e[7, 1, 2, 5] = complex(-0.000036277149, -0.000002571230)
    h2e[9, 1, 2, 5] = complex(0.000029024289, 0.000015930827)
    h2e[11, 1, 2, 5] = complex(0.000482202491, 0.000024541124)
    h2e[1, 1, 6, 5] = complex(-0.000041290004, 0.000024113909)
    h2e[3, 1, 6, 5] = complex(0.000000203927, 0.000000304493)
    h2e[5, 1, 6, 5] = complex(-0.000005041862, -0.000013596316)
    h2e[7, 1, 6, 5] = complex(-0.002178616036, -0.005729695294)
    h2e[9, 1, 6, 5] = complex(-0.000086773926, 0.005383763988)
    h2e[11, 1, 6, 5] = complex(0.000002003751, 0.000002918450)
    h2e[3, 1, 8, 5] = complex(-0.000000308628, 0.000000121404)
    h2e[5, 1, 8, 5] = complex(0.000011883528, -0.000004608883)
    h2e[7, 1, 8, 5] = complex(0.005111237191, -0.001723736684)
    h2e[9, 1, 8, 5] = complex(-0.006122296272, -0.000310036035)
    h2e[11, 1, 8, 5] = complex(-0.000003312903, 0.000001378240)
    h2e[1, 1, 10, 5] = complex(0.079180536788, -0.000802877322)
    h2e[3, 1, 10, 5] = complex(-0.000242459267, -0.000007436490)
    h2e[5, 1, 10, 5] = complex(0.000127581555, 0.000000083691)
    h2e[7, 1, 10, 5] = complex(0.000009121361, 0.000000983136)
    h2e[9, 1, 10, 5] = complex(-0.000008878595, -0.000005504387)
    h2e[11, 1, 10, 5] = complex(0.001191810192, 0.000089839828)
    h2e[1, 3, 0, 5] = complex(-0.003239588955, 0.000132190356)
    h2e[3, 3, 0, 5] = complex(0.013837409413, 0.000000259779)
    h2e[5, 3, 0, 5] = complex(-0.012722145541, 0.000002215741)
    h2e[7, 3, 0, 5] = complex(-0.000006306516, 0.000000557451)
    h2e[9, 3, 0, 5] = complex(-0.000026924503, -0.000012828490)
    h2e[11, 3, 0, 5] = complex(-0.014262800313, -0.000023436919)
    h2e[1, 3, 2, 5] = complex(-0.000072408587, 0.000005464851)
    h2e[3, 3, 2, 5] = complex(-0.000785882375, 0.000027146309)
    h2e[5, 3, 2, 5] = complex(0.007309896243, -0.000253911870)
    h2e[7, 3, 2, 5] = complex(-0.000017904297, -0.000012677543)
    h2e[9, 3, 2, 5] = complex(-0.000036996372, -0.000030524413)
    h2e[11, 3, 2, 5] = complex(0.000171136924, -0.000005632125)
    h2e[1, 3, 6, 5] = complex(-0.000000111205, -0.000000363541)
    h2e[3, 3, 6, 5] = complex(-0.000014439732, 0.000008432995)
    h2e[5, 3, 6, 5] = complex(-0.000005832826, -0.000000534243)
    h2e[7, 3, 6, 5] = complex(0.002838399257, -0.002785933302)
    h2e[9, 3, 6, 5] = complex(0.003510750174, -0.007800758153)
    h2e[11, 3, 6, 5] = complex(0.000019361231, -0.000007541258)
    h2e[1, 3, 8, 5] = complex(0.000000289198, -0.000000162082)
    h2e[5, 3, 8, 5] = complex(-0.000016246587, 0.000013099669)
    h2e[7, 3, 8, 5] = complex(-0.005442412652, 0.006682297051)
    h2e[9, 3, 8, 5] = complex(-0.001278590720, 0.003310348162)
    h2e[11, 3, 8, 5] = complex(-0.000000348011, -0.000000606168)
    h2e[1, 3, 10, 5] = complex(-0.000242257540, 0.000012351364)
    h2e[3, 3, 10, 5] = complex(0.021679958767, -0.000219831135)
    h2e[5, 3, 10, 5] = complex(0.033995104252, -0.000351264969)
    h2e[7, 3, 10, 5] = complex(-0.000108485271, 0.000004354343)
    h2e[9, 3, 10, 5] = complex(-0.000001753239, 0.000002858685)
    h2e[11, 3, 10, 5] = complex(-0.019451802522, 0.000165636496)
    h2e[1, 5, 0, 5] = complex(-0.002043114900, 0.000021985684)
    h2e[3, 5, 0, 5] = complex(-0.012721973198, -0.000002693458)
    h2e[5, 5, 0, 5] = complex(-0.005047658677, -0.000000094763)
    h2e[7, 5, 0, 5] = complex(0.000008045948, 0.000000087836)
    h2e[9, 5, 0, 5] = complex(-0.000011516918, -0.000005430769)
    h2e[11, 5, 0, 5] = complex(-0.003530204409, -0.000005655525)
    h2e[1, 5, 2, 5] = complex(0.000070780348, -0.000003211865)
    h2e[3, 5, 2, 5] = complex(0.007309993654, -0.000251093887)
    h2e[5, 5, 2, 5] = complex(0.002404481079, -0.000083056688)
    h2e[7, 5, 2, 5] = complex(0.000010199173, -0.000005268303)
    h2e[9, 5, 2, 5] = complex(-0.000016567803, -0.000012555134)
    h2e[11, 5, 2, 5] = complex(0.005230719877, -0.000172392620)
    h2e[1, 5, 6, 5] = complex(0.000007132596, 0.000012582805)
    h2e[3, 5, 6, 5] = complex(-0.000011383386, 0.000010573126)
    h2e[5, 5, 6, 5] = complex(0.000003846817, -0.000002246593)
    h2e[7, 5, 6, 5] = complex(0.003511283228, -0.001682470322)
    h2e[9, 5, 6, 5] = complex(0.003531187468, -0.009210855537)
    h2e[11, 5, 6, 5] = complex(-0.000011230173, 0.000012219735)
    h2e[1, 5, 8, 5] = complex(-0.000011154857, 0.000006163415)
    h2e[3, 5, 8, 5] = complex(0.000016177526, -0.000013242070)
    h2e[7, 5, 8, 5] = complex(-0.006680883769, 0.007368857852)
    h2e[9, 5, 8, 5] = complex(0.000007975560, 0.003360351505)
    h2e[11, 5, 8, 5] = complex(0.000000101107, -0.000001454194)
    h2e[1, 5, 10, 5] = complex(0.000127508847, -0.000002667242)
    h2e[3, 5, 10, 5] = complex(0.033995299708, -0.000338146577)
    h2e[5, 5, 10, 5] = complex(0.026100912032, -0.000264658857)
    h2e[7, 5, 10, 5] = complex(0.000064991587, -0.000001981614)
    h2e[9, 5, 10, 5] = complex(-0.000000130221, -0.000001335039)
    h2e[11, 5, 10, 5] = complex(0.046077017920, -0.000394252523)
    h2e[1, 7, 0, 5] = complex(0.000005014398, -0.000002458397)
    h2e[3, 7, 0, 5] = complex(0.000059092610, 0.000000540916)
    h2e[5, 7, 0, 5] = complex(0.000036997021, 0.000000259292)
    h2e[7, 7, 0, 5] = complex(0.004664046459, 0.000000087561)
    h2e[9, 7, 0, 5] = complex(0.000000030904, 0.000000012916)
    h2e[11, 7, 0, 5] = complex(0.000002036969, -0.000000819175)
    h2e[1, 7, 2, 5] = complex(0.000035938575, -0.000003004296)
    h2e[3, 7, 2, 5] = complex(-0.000020221722, -0.000013714008)
    h2e[5, 7, 2, 5] = complex(0.000002574214, -0.000005555692)
    h2e[7, 7, 2, 5] = complex(0.003852445386, -0.000133072935)
    h2e[9, 7, 2, 5] = complex(0.000000038422, 0.000000044628)
    h2e[11, 7, 2, 5] = complex(-0.000030444685, 0.000004806670)
    h2e[1, 7, 6, 5] = complex(0.002928889106, 0.005283774824)
    h2e[3, 7, 6, 5] = complex(0.000607425631, 0.001115512292)
    h2e[5, 7, 6, 5] = complex(0.000099880949, -0.000046838265)
    h2e[7, 7, 6, 5] = complex(-0.000027499158, 0.000016059873)
    h2e[9, 7, 6, 5] = complex(-0.000013176069, 0.000022937116)
    h2e[11, 7, 6, 5] = complex(0.000313294462, 0.000712630566)
    h2e[1, 7, 8, 5] = complex(-0.004522753781, 0.002765875859)
    h2e[3, 7, 8, 5] = complex(0.007056076592, -0.003382712075)
    h2e[5, 7, 8, 5] = complex(0.008310861168, -0.003994270101)
    h2e[9, 7, 8, 5] = complex(0.000000369138, -0.000019094695)
    h2e[11, 7, 8, 5] = complex(0.000120445902, -0.000062435635)
    h2e[1, 7, 10, 5] = complex(-0.000009693703, 0.000001029704)
    h2e[3, 7, 10, 5] = complex(-0.000083184319, 0.000004580547)
    h2e[5, 7, 10, 5] = complex(0.000054920454, -0.000001593771)
    h2e[7, 7, 10, 5] = complex(0.041197543165, -0.000417736157)
    h2e[9, 7, 10, 5] = complex(-0.000000000719, 0.000000004752)
    h2e[11, 7, 10, 5] = complex(-0.000135730781, 0.000002459084)
    h2e[1, 9, 0, 5] = complex(0.000011530584, -0.000008820226)
    h2e[3, 9, 0, 5] = complex(0.000027016366, -0.000012702088)
    h2e[5, 9, 0, 5] = complex(0.000011560582, -0.000005367773)
    h2e[7, 9, 0, 5] = complex(-0.000000031049, 0.000000012762)
    h2e[9, 9, 0, 5] = complex(0.004662271901, 0.000000087528)
    h2e[11, 9, 0, 5] = complex(-0.000010170471, 0.000005025772)
    h2e[1, 9, 2, 5] = complex(-0.000028778914, 0.000016409304)
    h2e[3, 9, 2, 5] = complex(0.000035919098, -0.000032188015)
    h2e[5, 9, 2, 5] = complex(0.000016149527, -0.000013219142)
    h2e[7, 9, 2, 5] = complex(-0.000000037126, 0.000000046277)
    h2e[9, 9, 2, 5] = complex(0.003852426818, -0.000133072293)
    h2e[11, 9, 2, 5] = complex(0.000002208516, 0.000003781946)
    h2e[1, 9, 6, 5] = complex(-0.004443873747, -0.002895399427)
    h2e[3, 9, 6, 5] = complex(0.006088036064, 0.004916055840)
    h2e[5, 9, 6, 5] = complex(0.007179661699, 0.005785936819)
    h2e[7, 9, 6, 5] = complex(-0.000020515255, -0.000010712828)
    h2e[9, 9, 6, 5] = complex(-0.000027499465, 0.000016060052)
    h2e[11, 9, 6, 5] = complex(0.000108165267, 0.000081902819)
    h2e[1, 9, 8, 5] = complex(0.003158258216, -0.005178178991)
    h2e[3, 9, 8, 5] = complex(0.000672027812, -0.001083354051)
    h2e[5, 9, 8, 5] = complex(-0.000090505712, -0.000063967493)
    h2e[7, 9, 8, 5] = complex(-0.000009960803, -0.000008423777)
    h2e[11, 9, 8, 5] = complex(0.000466690349, -0.000627209331)
    h2e[1, 9, 10, 5] = complex(0.000009101453, -0.000005104844)
    h2e[3, 9, 10, 5] = complex(0.000001344571, 0.000002372153)
    h2e[5, 9, 10, 5] = complex(0.000000283584, -0.000001136988)
    h2e[7, 9, 10, 5] = complex(0.000000000323, 0.000000004411)
    h2e[9, 9, 10, 5] = complex(0.041196394799, -0.000417724513)
    h2e[11, 9, 10, 5] = complex(-0.000011563923, 0.000002483146)
    h2e[1, 11, 0, 5] = complex(-0.001446138095, 0.000123742113)
    h2e[3, 11, 0, 5] = complex(-0.014262821617, 0.000022901353)
    h2e[5, 11, 0, 5] = complex(-0.003530159672, 0.000005523048)
    h2e[7, 11, 0, 5] = complex(0.000022690932, -0.000000091326)
    h2e[9, 11, 0, 5] = complex(0.000010153192, 0.000005036935)
    h2e[11, 11, 0, 5] = complex(0.014578033123, 0.000000273683)
    h2e[1, 11, 2, 5] = complex(0.000479317986, -0.000057751518)
    h2e[3, 11, 2, 5] = complex(0.000171073786, -0.000006187193)
    h2e[5, 11, 2, 5] = complex(0.005230210169, -0.000188956392)
    h2e[7, 11, 2, 5] = complex(-0.000001453359, 0.000003319709)
    h2e[9, 11, 2, 5] = complex(-0.000001979104, 0.000003513096)
    h2e[11, 11, 2, 5] = complex(-0.004344732228, 0.000150077732)
    h2e[1, 11, 6, 5] = complex(-0.000001185400, -0.000003422079)
    h2e[3, 11, 6, 5] = complex(0.000017606664, -0.000014066566)
    h2e[5, 11, 6, 5] = complex(-0.000013545518, 0.000002213578)
    h2e[7, 11, 6, 5] = complex(-0.000044209565, -0.000854153010)
    h2e[9, 11, 6, 5] = complex(0.000376623260, -0.000126462387)
    h2e[11, 11, 6, 5] = complex(0.000005477015, -0.000003198649)
    h2e[1, 11, 8, 5] = complex(0.000003069825, -0.000001843869)
    h2e[3, 11, 8, 5] = complex(0.000000271435, 0.000000447336)
    h2e[5, 11, 8, 5] = complex(-0.000000249657, 0.000001144916)
    h2e[7, 11, 8, 5] = complex(0.000037503807, 0.000363696456)
    h2e[9, 11, 8, 5] = complex(-0.000789135083, 0.000341321607)
    h2e[1, 11, 10, 5] = complex(0.001189755610, -0.000113989394)
    h2e[3, 11, 10, 5] = complex(-0.019451159621, 0.000228832583)
    h2e[5, 11, 10, 5] = complex(0.046075538542, -0.000540156351)
    h2e[7, 11, 10, 5] = complex(-0.000135262489, -0.000005499123)
    h2e[9, 11, 10, 5] = complex(0.000011711356, 0.000002535364)
    h2e[11, 11, 10, 5] = complex(-0.009497823108, 0.000096306329)
    h2e[1, 1, 0, 7] = complex(-0.000440773975, -0.000005277991)
    h2e[3, 1, 0, 7] = complex(0.000008550871, 0.000000410478)
    h2e[5, 1, 0, 7] = complex(0.000005437517, 0.000002225031)
    h2e[7, 1, 0, 7] = complex(-0.000124956230, 0.001861980081)
    h2e[9, 1, 0, 7] = complex(-0.004704328564, -0.004475068877)
    h2e[11, 1, 0, 7] = complex(0.000001194301, -0.000000486383)
    h2e[1, 1, 2, 7] = complex(-0.000026863469, -0.000035265985)
    h2e[3, 1, 2, 7] = complex(0.000001035567, 0.000000359551)
    h2e[5, 1, 2, 7] = complex(-0.000032775540, -0.000002635118)
    h2e[7, 1, 2, 7] = complex(-0.013792939614, -0.001157363937)
    h2e[9, 1, 2, 7] = complex(0.011274525695, 0.005634609625)
    h2e[11, 1, 2, 7] = complex(0.000006796423, -0.000001394587)
    h2e[1, 1, 4, 7] = complex(-0.000006539033, -0.000047366508)
    h2e[3, 1, 4, 7] = complex(-0.000000359260, 0.000000072348)
    h2e[5, 1, 4, 7] = complex(0.000014491493, 0.000000526142)
    h2e[7, 1, 4, 7] = complex(0.006127497518, 0.000171901653)
    h2e[9, 1, 4, 7] = complex(-0.004943525507, -0.002134010307)
    h2e[11, 1, 4, 7] = complex(-0.000003462139, 0.000000738891)
    h2e[5, 1, 8, 7] = complex(-0.000000030205, 0.000000013273)
    h2e[7, 1, 8, 7] = complex(-0.000012898403, 0.000004980300)
    h2e[9, 1, 8, 7] = complex(0.000015801085, 0.000001005224)
    h2e[11, 1, 8, 7] = complex(0.000000008561, -0.000000003652)
    h2e[1, 1, 10, 7] = complex(-0.000226996437, -0.000051339998)
    h2e[3, 1, 10, 7] = complex(0.000000327449, 0.000000122705)
    h2e[5, 1, 10, 7] = complex(0.000009805976, 0.000001332050)
    h2e[7, 1, 10, 7] = complex(0.004327518103, 0.000776152899)
    h2e[9, 1, 10, 7] = complex(-0.004109081759, -0.002490316396)
    h2e[11, 1, 10, 7] = complex(-0.000006235417, -0.000001403319)
    h2e[1, 3, 0, 7] = complex(0.000008621227, -0.000000211084)
    h2e[3, 3, 0, 7] = complex(-0.000035314923, -0.000000422874)
    h2e[5, 3, 0, 7] = complex(-0.000004690878, 0.000000696055)
    h2e[7, 3, 0, 7] = complex(-0.013827033448, 0.000357289311)
    h2e[9, 3, 0, 7] = complex(-0.011573800892, -0.004976996824)
    h2e[11, 3, 0, 7] = complex(0.000040382387, 0.000000304158)
    h2e[1, 3, 2, 7] = complex(-0.000000588559, 0.000000338142)
    h2e[3, 3, 2, 7] = complex(-0.000000068991, -0.000000090571)
    h2e[5, 3, 2, 7] = complex(-0.000022889666, -0.000041635097)
    h2e[7, 3, 2, 7] = complex(-0.000103013796, -0.010576649266)
    h2e[9, 3, 2, 7] = complex(-0.012396695801, -0.016736846291)
    h2e[11, 3, 2, 7] = complex(0.000010467630, 0.000004497813)
    h2e[1, 3, 4, 7] = complex(0.000000378471, 0.000000035888)
    h2e[3, 3, 4, 7] = complex(-0.000002286798, -0.000016564776)
    h2e[5, 3, 4, 7] = complex(0.000002718948, -0.000005187928)
    h2e[7, 3, 4, 7] = complex(0.001492460225, 0.003686529230)
    h2e[9, 3, 4, 7] = complex(0.005871560878, 0.006221090562)
    h2e[11, 3, 4, 7] = complex(-0.000000414957, 0.000020773917)
    h2e[5, 3, 8, 7] = complex(0.000000048763, -0.000000022926)
    h2e[7, 3, 8, 7] = complex(0.000016557290, -0.000013114219)
    h2e[9, 3, 8, 7] = complex(0.000003974884, -0.000002666477)
    h2e[1, 3, 10, 7] = complex(0.000000850446, 0.000000108385)
    h2e[3, 3, 10, 7] = complex(-0.000064904039, -0.000014679407)
    h2e[5, 3, 10, 7] = complex(-0.000120003238, -0.000019685130)
    h2e[7, 3, 10, 7] = complex(-0.005967111690, 0.003296235829)
    h2e[9, 3, 10, 7] = complex(-0.001540910548, 0.002940629068)
    h2e[11, 3, 10, 7] = complex(0.000061191714, 0.000013149148)
    h2e[1, 5, 0, 7] = complex(0.000005077390, -0.000002038282)
    h2e[3, 5, 0, 7] = complex(0.000067691435, 0.000000041453)
    h2e[5, 5, 0, 7] = complex(0.000012314767, 0.000000147462)
    h2e[7, 5, 0, 7] = complex(-0.006127789029, 0.000100288224)
    h2e[9, 5, 0, 7] = complex(-0.004965751954, -0.002075325512)
    h2e[11, 5, 0, 7] = complex(-0.000000933586, 0.000000474682)
    h2e[1, 5, 2, 7] = complex(0.000032466866, -0.000002191591)
    h2e[3, 5, 2, 7] = complex(-0.000020304579, -0.000014617114)
    h2e[5, 5, 2, 7] = complex(-0.000007450260, -0.000009780596)
    h2e[7, 5, 2, 7] = complex(0.001249104027, -0.003839683970)
    h2e[9, 5, 2, 7] = complex(-0.005581226097, -0.006482755426)
    h2e[11, 5, 2, 7] = complex(-0.000029449855, -0.000025934459)
    h2e[1, 5, 4, 7] = complex(-0.000014352200, 0.000001793119)
    h2e[3, 5, 4, 7] = complex(-0.000005431022, -0.000014555978)
    h2e[5, 5, 4, 7] = complex(0.000000609215, 0.000004412940)
    h2e[7, 5, 4, 7] = complex(0.000215752538, 0.003887578652)
    h2e[9, 5, 4, 7] = complex(0.007167226157, 0.006777906331)
    h2e[11, 5, 4, 7] = complex(-0.000007011557, -0.000015042500)
    h2e[1, 5, 8, 7] = complex(0.000000028147, -0.000000017213)
    h2e[3, 5, 8, 7] = complex(-0.000000048575, 0.000000023287)
    h2e[7, 5, 8, 7] = complex(0.000018493049, -0.000013915731)
    h2e[9, 5, 8, 7] = complex(-0.000000317772, -0.000027241737)
    h2e[11, 5, 8, 7] = complex(-0.000000001457, 0.000000000755)
    h2e[1, 5, 10, 7] = complex(-0.000010811657, -0.000000146426)
    h2e[3, 5, 10, 7] = complex(-0.000090741584, -0.000028118171)
    h2e[5, 5, 10, 7] = complex(-0.000070399153, -0.000015922243)
    h2e[7, 5, 10, 7] = complex(0.000799651859, -0.000366715428)
    h2e[9, 5, 10, 7] = complex(0.000059463794, -0.000392786877)
    h2e[11, 5, 10, 7] = complex(-0.000137344816, -0.000027190949)
    h2e[1, 7, 0, 7] = complex(0.000003936520, 0.000067070819)
    h2e[3, 7, 0, 7] = complex(0.013634344162, 0.000120740775)
    h2e[5, 7, 0, 7] = complex(0.006040958335, 0.000052916452)
    h2e[7, 7, 0, 7] = complex(-0.000012054307, -0.000000144343)
    h2e[9, 7, 0, 7] = complex(0.000013426726, 0.000004917611)
    h2e[11, 7, 0, 7] = complex(-0.004307676661, -0.000039927857)
    h2e[1, 7, 2, 7] = complex(0.013602351472, -0.000942200515)
    h2e[3, 7, 2, 7] = complex(-0.000000127677, -0.000124710326)
    h2e[5, 7, 2, 7] = complex(-0.001268020847, -0.000074363960)
    h2e[7, 7, 2, 7] = complex(-0.000014230234, -0.000018681252)
    h2e[9, 7, 2, 7] = complex(0.000012892721, 0.000021476450)
    h2e[11, 7, 2, 7] = complex(-0.005794826188, -0.000183815167)
    h2e[1, 7, 4, 7] = complex(-0.006001513052, 0.000691743333)
    h2e[3, 7, 4, 7] = complex(-0.001262874739, 0.000135944578)
    h2e[5, 7, 4, 7] = complex(0.000005193636, 0.000110195440)
    h2e[7, 7, 4, 7] = complex(-0.000004354999, -0.000031546113)
    h2e[9, 7, 4, 7] = complex(-0.000016176136, -0.000020929706)
    h2e[11, 7, 4, 7] = complex(-0.000778254942, 0.000017747876)
    h2e[1, 7, 8, 7] = complex(0.000011485541, -0.000007765674)
    h2e[3, 7, 8, 7] = complex(-0.000020919025, 0.000004709362)
    h2e[5, 7, 8, 7] = complex(-0.000022665276, 0.000005891158)
    h2e[9, 7, 8, 7] = complex(0.000034667006, -0.005879739156)
    h2e[11, 7, 8, 7] = complex(-0.000000259600, -0.000000121841)
    h2e[1, 7, 10, 7] = complex(-0.004305560542, 0.000139817349)
    h2e[3, 7, 10, 7] = complex(0.005798076938, 0.000014141400)
    h2e[5, 7, 10, 7] = complex(-0.000778632023, -0.000008761465)
    h2e[7, 7, 10, 7] = complex(-0.000130151633, -0.000029436517)
    h2e[9, 7, 10, 7] = complex(-0.000000163115, 0.000000667502)
    h2e[11, 7, 10, 7] = complex(-0.000009947744, 0.000290774609)
    h2e[1, 9, 0, 7] = complex(0.005437753939, -0.003132343432)
    h2e[3, 9, 0, 7] = complex(0.011029485352, -0.005703717259)
    h2e[5, 9, 0, 7] = complex(0.004705297339, -0.002442214260)
    h2e[7, 9, 0, 7] = complex(-0.000012549312, 0.000005804047)
    h2e[9, 9, 0, 7] = complex(-0.000012049618, -0.000000144286)
    h2e[11, 9, 0, 7] = complex(-0.004227277731, 0.002136566830)
    h2e[1, 9, 2, 7] = complex(-0.010551797261, 0.006557173730)
    h2e[3, 9, 2, 7] = complex(0.016643139962, -0.007920345372)
    h2e[5, 9, 2, 7] = complex(0.007058577692, -0.003382410102)
    h2e[7, 9, 2, 7] = complex(-0.000016460113, 0.000013235982)
    h2e[9, 9, 2, 7] = complex(-0.000014230142, -0.000018681133)
    h2e[11, 9, 2, 7] = complex(-0.000069858425, 0.000015132375)
    h2e[1, 9, 4, 7] = complex(0.004371689976, -0.003003277954)
    h2e[3, 9, 4, 7] = complex(-0.006866753583, 0.003752263748)
    h2e[5, 9, 4, 7] = complex(-0.008087285007, 0.004429495234)
    h2e[7, 9, 4, 7] = complex(0.000017728855, -0.000014877102)
    h2e[9, 9, 4, 7] = complex(-0.000004355047, -0.000031546465)
    h2e[11, 9, 4, 7] = complex(-0.000116971982, 0.000068741196)
    h2e[1, 9, 8, 7] = complex(-0.000008453377, 0.000013492793)
    h2e[3, 9, 8, 7] = complex(-0.000005761918, 0.000000215255)
    h2e[5, 9, 8, 7] = complex(-0.000011265163, -0.000006578274)
    h2e[7, 9, 8, 7] = complex(-0.005584438856, -0.003946960094)
    h2e[11, 9, 8, 7] = complex(0.000003729426, -0.000003157624)
    h2e[1, 9, 10, 7] = complex(0.004112732678, -0.002356969061)
    h2e[3, 9, 10, 7] = complex(-0.000257265010, -0.000374516562)
    h2e[5, 9, 10, 7] = complex(0.000145700097, -0.000010289173)
    h2e[7, 9, 10, 7] = complex(-0.000000087000, 0.000000224979)
    h2e[9, 9, 10, 7] = complex(-0.000130149095, -0.000029435943)
    h2e[11, 9, 10, 7] = complex(-0.003794316693, 0.001994997383)
    h2e[1, 11, 0, 7] = complex(0.000006440407, 0.000000021903)
    h2e[3, 11, 0, 7] = complex(0.000031880688, 0.000000545571)
    h2e[5, 11, 0, 7] = complex(0.000017977321, -0.000000237685)
    h2e[7, 11, 0, 7] = complex(0.004359277456, -0.000348061652)
    h2e[9, 11, 0, 7] = complex(0.004323603623, 0.002090710751)
    h2e[11, 11, 0, 7] = complex(-0.000036809422, -0.000000440770)
    h2e[1, 11, 2, 7] = complex(-0.000009262162, -0.000000814153)
    h2e[3, 11, 2, 7] = complex(-0.000006902539, 0.000000752718)
    h2e[5, 11, 2, 7] = complex(-0.000004169870, -0.000019294112)
    h2e[7, 11, 2, 7] = complex(0.005910402056, 0.002933167949)
    h2e[9, 11, 2, 7] = complex(-0.001430755014, 0.002995774585)
    h2e[11, 11, 2, 7] = complex(0.000012009705, 0.000015766172)
    h2e[1, 11, 4, 7] = complex(0.000003615498, 0.000000209698)
    h2e[3, 11, 4, 7] = complex(0.000006286221, 0.000021641310)
    h2e[5, 11, 4, 7] = complex(0.000003121163, -0.000013365602)
    h2e[7, 11, 4, 7] = complex(0.000806424530, 0.000284976021)
    h2e[9, 11, 4, 7] = complex(-0.000026775328, 0.000396384791)
    h2e[11, 11, 4, 7] = complex(0.000000867386, 0.000006283048)
    h2e[1, 11, 8, 7] = complex(-0.000000007936, 0.000000004867)
    h2e[5, 11, 8, 7] = complex(0.000000001758, -0.000000000177)
    h2e[7, 11, 8, 7] = complex(0.000000080274, -0.000000227466)
    h2e[9, 11, 8, 7] = complex(0.000006715016, 0.000003132726)
    h2e[1, 11, 10, 7] = complex(-0.000000832427, -0.000000599711)
    h2e[3, 11, 10, 7] = complex(0.000062291109, 0.000014586972)
    h2e[5, 11, 10, 7] = complex(-0.000137820688, -0.000034079146)
    h2e[7, 11, 10, 7] = complex(0.000047429998, -0.002515859486)
    h2e[9, 11, 10, 7] = complex(0.005029613384, -0.000134254212)
    h2e[11, 11, 10, 7] = complex(0.000038695021, 0.000008751689)
    h2e[3, 1, 0, 9] = complex(0.000000218481, -0.000000130285)
    h2e[5, 1, 0, 9] = complex(-0.000012596667, 0.000007225196)
    h2e[7, 1, 0, 9] = complex(-0.005226267541, 0.003913745982)
    h2e[9, 1, 0, 9] = complex(0.000107937913, -0.001608557724)
    h2e[11, 1, 0, 9] = complex(0.000001424606, -0.000001310614)
    h2e[3, 1, 2, 9] = complex(-0.000000710950, 0.000000290581)
    h2e[5, 1, 2, 9] = complex(0.000027677662, -0.000011167098)
    h2e[7, 1, 2, 9] = complex(0.011874885335, -0.004267402857)
    h2e[9, 1, 2, 9] = complex(-0.013826510250, -0.000485299334)
    h2e[11, 1, 2, 9] = complex(-0.000007404521, 0.000003190465)
    h2e[3, 1, 4, 9] = complex(0.000000301754, -0.000000137605)
    h2e[5, 1, 4, 9] = complex(-0.000011622320, 0.000005232755)
    h2e[7, 1, 4, 9] = complex(-0.005012605822, 0.001992434846)
    h2e[9, 1, 4, 9] = complex(0.006130122693, -0.000015156928)
    h2e[11, 1, 4, 9] = complex(0.000003235130, -0.000001552032)
    h2e[5, 1, 6, 9] = complex(0.000000024971, 0.000000021563)
    h2e[7, 1, 6, 9] = complex(0.000010042423, 0.000009503784)
    h2e[9, 1, 6, 9] = complex(-0.000005886537, -0.000014698076)
    h2e[11, 1, 6, 9] = complex(-0.000000006978, -0.000000006158)
    h2e[3, 1, 10, 9] = complex(0.000000256465, -0.000000102562)
    h2e[5, 1, 10, 9] = complex(-0.000010528211, 0.000004166945)
    h2e[7, 1, 10, 9] = complex(-0.004473303397, 0.001718687321)
    h2e[9, 1, 10, 9] = complex(0.004370801811, 0.000113385300)
    h2e[11, 1, 10, 9] = complex(0.000002519071, -0.000001058890)
    h2e[1, 3, 0, 9] = complex(-0.000000199924, 0.000000156812)
    h2e[5, 3, 0, 9] = complex(-0.000029964717, 0.000014137422)
    h2e[7, 3, 0, 9] = complex(-0.011615933496, 0.004943131714)
    h2e[9, 3, 0, 9] = complex(-0.013839910817, -0.000315596827)
    h2e[11, 3, 0, 9] = complex(0.000004362139, -0.000002183991)
    h2e[1, 3, 2, 9] = complex(0.000000664836, -0.000000384004)
    h2e[5, 3, 2, 9] = complex(-0.000036115022, 0.000031796614)
    h2e[7, 3, 2, 9] = complex(-0.011964654454, 0.017194072263)
    h2e[9, 3, 2, 9] = complex(0.000088951435, 0.009127875534)
    h2e[11, 3, 2, 9] = complex(-0.000002288137, -0.000001147389)
    h2e[1, 3, 4, 9] = complex(-0.000000280194, 0.000000177194)
    h2e[5, 3, 4, 9] = complex(0.000015528846, -0.000013943025)
    h2e[7, 3, 4, 9] = complex(0.005080288795, -0.006961581385)
    h2e[9, 3, 4, 9] = complex(0.001101193622, -0.003373510327)
    h2e[11, 3, 4, 9] = complex(0.000000379668, 0.000000586853)
    h2e[5, 3, 6, 9] = complex(-0.000000041665, -0.000000034167)
    h2e[7, 3, 6, 9] = complex(-0.000018959288, -0.000009309784)
    h2e[9, 3, 6, 9] = complex(-0.000004116508, -0.000002442165)
    h2e[1, 3, 10, 9] = complex(-0.000000240337, 0.000000135984)
    h2e[5, 3, 10, 9] = complex(-0.000001553893, -0.000002723537)
    h2e[7, 3, 10, 9] = complex(-0.001247199341, -0.002689867624)
    h2e[9, 3, 10, 9] = complex(-0.005809173692, -0.002708817473)
    h2e[11, 3, 10, 9] = complex(0.000002954219, -0.000000768005)
    h2e[1, 5, 0, 9] = complex(0.000011530583, -0.000008820227)
    h2e[3, 5, 0, 9] = complex(0.000029991571, -0.000014100918)
    h2e[7, 5, 0, 9] = complex(-0.004991363783, 0.002051632959)
    h2e[9, 5, 0, 9] = complex(-0.006130696868, -0.000086788307)
    h2e[11, 5, 0, 9] = complex(-0.000009374066, 0.000004632225)
    h2e[1, 5, 2, 9] = complex(-0.000025924006, 0.000014781479)
    h2e[3, 5, 2, 9] = complex(0.000035919105, -0.000032188014)
    h2e[7, 5, 2, 9] = complex(-0.005393015116, 0.006722302041)
    h2e[9, 5, 2, 9] = complex(0.001317462529, 0.003230859055)
    h2e[11, 5, 2, 9] = complex(0.000001836777, 0.000003145359)
    h2e[1, 5, 4, 9] = complex(0.000010812215, -0.000006746446)
    h2e[3, 5, 4, 9] = complex(-0.000015452324, 0.000014081562)
    h2e[7, 5, 4, 9] = complex(0.006280597769, -0.007712870149)
    h2e[9, 5, 4, 9] = complex(-0.000186213760, -0.003355197518)
    h2e[11, 5, 4, 9] = complex(-0.000000023822, 0.000001457510)
    h2e[1, 5, 6, 9] = complex(-0.000000027644, -0.000000018011)
    h2e[3, 5, 6, 9] = complex(0.000000041911, 0.000000033843)
    h2e[7, 5, 6, 9] = complex(-0.000020515256, -0.000010712832)
    h2e[9, 5, 6, 9] = complex(-0.000024458298, 0.000012000200)
    h2e[11, 5, 6, 9] = complex(0.000000001308, 0.000000000991)
    h2e[1, 5, 10, 9] = complex(0.000009874697, -0.000005538543)
    h2e[3, 5, 10, 9] = complex(0.000001616704, 0.000002852252)
    h2e[7, 5, 10, 9] = complex(0.000026676975, 0.000364674133)
    h2e[9, 5, 10, 9] = complex(0.000781854987, 0.000301682404)
    h2e[11, 5, 10, 9] = complex(-0.000011563914, 0.000002483147)
    h2e[1, 7, 0, 9] = complex(0.005437753956, -0.003132343382)
    h2e[3, 7, 0, 9] = complex(0.011034362065, -0.005706239160)
    h2e[5, 7, 0, 9] = complex(0.004707471635, -0.002443342793)
    h2e[9, 7, 0, 9] = complex(0.000016241181, 0.000000402847)
    h2e[11, 7, 0, 9] = complex(-0.004229257509, 0.002137567445)
    h2e[1, 7, 2, 9] = complex(-0.010547133827, 0.006554275733)
    h2e[3, 7, 2, 9] = complex(0.016643139879, -0.007920345661)
    h2e[5, 7, 2, 9] = complex(0.007058625519, -0.003382433139)
    h2e[9, 7, 2, 9] = complex(-0.000004133441, -0.000013314260)
    h2e[11, 7, 2, 9] = complex(-0.000069858335, 0.000015132449)
    h2e[1, 7, 4, 9] = complex(0.004369670772, -0.003001890792)
    h2e[3, 7, 4, 9] = complex(-0.006866706993, 0.003752238411)
    h2e[5, 7, 4, 9] = complex(-0.008087284972, 0.004429495339)
    h2e[9, 7, 4, 9] = complex(0.000000644258, 0.000019087393)
    h2e[11, 7, 4, 9] = complex(-0.000116964439, 0.000068736775)
    h2e[1, 7, 6, 9] = complex(-0.000011949674, -0.000007030551)
    h2e[3, 7, 6, 9] = complex(0.000013246489, 0.000016861623)
    h2e[5, 7, 6, 9] = complex(0.000015064308, 0.000017930064)
    h2e[9, 7, 6, 9] = complex(-0.005323370353, 0.002496850502)
    h2e[11, 7, 6, 9] = complex(0.000000001619, 0.000000286766)
    h2e[1, 7, 10, 9] = complex(0.004110807453, -0.002355865721)
    h2e[3, 7, 10, 9] = complex(-0.000257265228, -0.000374516823)
    h2e[5, 7, 10, 9] = complex(0.000145709487, -0.000010289846)
    h2e[9, 7, 10, 9] = complex(-0.000006614582, 0.000000337933)
    h2e[11, 7, 10, 9] = complex(-0.003794316710, 0.001994997314)
    h2e[1, 9, 0, 9] = complex(0.000057519722, 0.000035308599)
    h2e[3, 9, 0, 9] = complex(0.007934180666, -0.011155648179)
    h2e[5, 9, 0, 9] = complex(0.003514899394, -0.004943037015)
    h2e[7, 9, 0, 9] = complex(-0.000009070564, 0.000013085867)
    h2e[11, 9, 0, 9] = complex(-0.002508151498, 0.003523435547)
    h2e[1, 9, 2, 9] = complex(0.007040652589, -0.011740056210)
    h2e[3, 9, 2, 9] = complex(-0.000102811609, -0.000071533883)
    h2e[5, 9, 2, 9] = complex(-0.000789590023, 0.001000912014)
    h2e[7, 9, 2, 9] = complex(-0.000001760653, -0.000005490551)
    h2e[11, 9, 2, 9] = complex(-0.003480354917, 0.004663899354)
    h2e[1, 9, 4, 9] = complex(-0.002879135911, 0.005338418212)
    h2e[3, 9, 4, 9] = complex(-0.000613615292, 0.001117476484)
    h2e[5, 9, 4, 9] = complex(0.000093771446, 0.000059076592)
    h2e[7, 9, 4, 9] = complex(0.000010393618, 0.000007883547)
    h2e[11, 9, 4, 9] = complex(-0.000432763065, 0.000651081837)
    h2e[1, 9, 6, 9] = complex(0.000015816588, 0.000001830465)
    h2e[3, 9, 6, 9] = complex(0.000002671831, 0.000005109539)
    h2e[5, 9, 6, 9] = complex(-0.000001095374, 0.000012999145)
    h2e[7, 9, 6, 9] = complex(-0.001162296797, 0.006738955221)
    h2e[11, 9, 6, 9] = complex(-0.000004454395, -0.000002009372)
    h2e[1, 9, 10, 9] = complex(-0.002358972810, 0.003625006096)
    h2e[3, 9, 10, 9] = complex(0.003342259483, -0.004763835493)
    h2e[5, 9, 10, 9] = complex(-0.000454599557, 0.000636027251)
    h2e[7, 9, 10, 9] = complex(-0.000001866967, 0.000004515932)
    h2e[11, 9, 10, 9] = complex(0.000233321492, 0.000175535637)
    h2e[1, 11, 0, 9] = complex(-0.000001317953, 0.000001338573)
    h2e[3, 11, 0, 9] = complex(-0.000004331317, 0.000002226800)
    h2e[5, 11, 0, 9] = complex(0.000009298331, -0.000004738695)
    h2e[7, 11, 0, 9] = complex(0.004293286009, -0.002133902435)
    h2e[9, 11, 0, 9] = complex(0.004381109045, 0.000315838564)
    h2e[1, 11, 2, 9] = complex(0.000006851893, -0.000004219877)
    h2e[3, 11, 2, 9] = complex(0.000002045100, 0.000000659204)
    h2e[5, 11, 2, 9] = complex(-0.000001375483, -0.000002215600)
    h2e[7, 11, 2, 9] = complex(-0.001346132405, -0.002641742819)
    h2e[9, 11, 2, 9] = complex(0.005845830983, -0.003073629802)
    h2e[1, 11, 4, 9] = complex(-0.000002967695, 0.000002004111)
    h2e[3, 11, 4, 9] = complex(-0.000000294788, -0.000000432309)
    h2e[5, 11, 4, 9] = complex(0.000000188579, -0.000001156547)
    h2e[7, 11, 4, 9] = complex(-0.000056743241, -0.000361195036)
    h2e[9, 11, 4, 9] = complex(0.000769918720, -0.000382700648)
    h2e[1, 11, 6, 9] = complex(0.000000007807, 0.000000005072)
    h2e[5, 11, 6, 9] = complex(-0.000000000916, -0.000000001511)
    h2e[7, 11, 6, 9] = complex(-0.000000239881, 0.000000025331)
    h2e[9, 11, 6, 9] = complex(-0.000000058948, -0.000007409584)
    h2e[1, 11, 10, 9] = complex(-0.000002346259, 0.000001391640)
    h2e[3, 11, 10, 9] = complex(-0.000002867040, 0.000000947484)
    h2e[5, 11, 10, 9] = complex(0.000011125134, -0.000003388846)
    h2e[7, 11, 10, 9] = complex(0.004745328056, -0.000171561370)
    h2e[9, 11, 10, 9] = complex(-0.000040583178, 0.002171468589)
    h2e[1, 1, 0, 11] = complex(-0.129906865096, -0.000245291061)
    h2e[3, 1, 0, 11] = complex(0.003161326296, 0.000135035981)
    h2e[5, 1, 0, 11] = complex(-0.000292055331, -0.000003699559)
    h2e[7, 1, 0, 11] = complex(0.000003331088, 0.000000179524)
    h2e[9, 1, 0, 11] = complex(0.000001280746, 0.000001412034)
    h2e[11, 1, 0, 11] = complex(-0.009223831330, -0.000806980829)
    h2e[1, 1, 2, 11] = complex(0.062106040555, -0.003076868577)
    h2e[3, 1, 2, 11] = complex(-0.000165314828, 0.000001438403)
    h2e[5, 1, 2, 11] = complex(-0.000426697751, 0.000016532125)
    h2e[7, 1, 2, 11] = complex(0.000005223104, 0.000001357914)
    h2e[9, 1, 2, 11] = complex(-0.000004225296, -0.000002431582)
    h2e[11, 1, 2, 11] = complex(-0.001494462679, -0.000053639291)
    h2e[1, 1, 4, 11] = complex(0.078842848894, -0.007348958871)
    h2e[3, 1, 4, 11] = complex(-0.000242243621, 0.000012642213)
    h2e[5, 1, 4, 11] = complex(0.000127151364, -0.000010468560)
    h2e[7, 1, 4, 11] = complex(0.000009171423, 0.000000225361)
    h2e[9, 1, 4, 11] = complex(-0.000009303430, -0.000004751201)
    h2e[11, 1, 4, 11] = complex(0.001195157317, -0.000009039739)
    h2e[1, 1, 6, 11] = complex(-0.000057977404, -0.000225392543)
    h2e[3, 1, 6, 11] = complex(0.000000040356, 0.000000347348)
    h2e[5, 1, 6, 11] = complex(0.000003292594, 0.000009332221)
    h2e[7, 1, 6, 11] = complex(0.001285546263, 0.004204425891)
    h2e[9, 1, 6, 11] = complex(0.000339217985, -0.004792823782)
    h2e[11, 1, 6, 11] = complex(-0.000001598779, -0.000006188185)
    h2e[3, 1, 8, 11] = complex(0.000000253303, -0.000000110141)
    h2e[5, 1, 8, 11] = complex(-0.000010399683, 0.000004478087)
    h2e[7, 1, 8, 11] = complex(-0.004420233135, 0.001850910164)
    h2e[9, 1, 8, 11] = complex(0.004372240746, -0.000016600094)
    h2e[11, 1, 8, 11] = complex(0.000002486479, -0.000001133309)
    h2e[1, 3, 0, 11] = complex(0.003161813885, -0.000123096594)
    h2e[3, 3, 0, 11] = complex(0.003374071484, 0.000006370946)
    h2e[5, 3, 0, 11] = complex(-0.017466676956, -0.000029610673)
    h2e[7, 3, 0, 11] = complex(0.000047857373, 0.000000212788)
    h2e[9, 3, 0, 11] = complex(0.000007202178, 0.000003611959)
    h2e[11, 3, 0, 11] = complex(-0.010051334245, -0.000035306942)
    h2e[1, 3, 2, 11] = complex(-0.000164646934, 0.000014908584)
    h2e[3, 3, 2, 11] = complex(0.028314356754, -0.001402754930)
    h2e[5, 3, 2, 11] = complex(-0.000920393837, 0.000045775999)
    h2e[7, 3, 2, 11] = complex(-0.000017045032, 0.000002730745)
    h2e[9, 3, 2, 11] = complex(-0.000002220880, 0.000001103700)
    h2e[11, 3, 2, 11] = complex(-0.026508467156, 0.001270123240)
    h2e[1, 3, 4, 11] = complex(-0.000240405979, 0.000032345586)
    h2e[3, 3, 4, 11] = complex(0.021587498424, -0.002012175362)
    h2e[5, 3, 4, 11] = complex(0.033849579882, -0.003161715036)
    h2e[7, 3, 4, 11] = complex(-0.000107753446, 0.000013311982)
    h2e[9, 3, 4, 11] = complex(-0.000001510796, 0.000002993899)
    h2e[11, 3, 4, 11] = complex(-0.019371458469, 0.001773880942)
    h2e[1, 3, 6, 11] = complex(0.000000291910, 0.000000806098)
    h2e[3, 3, 6, 11] = complex(-0.000016577211, -0.000064445445)
    h2e[5, 3, 6, 11] = complex(-0.000037283554, -0.000115750672)
    h2e[7, 3, 6, 11] = complex(-0.005657263552, -0.003803545893)
    h2e[9, 3, 6, 11] = complex(-0.003319776186, -0.000028116697)
    h2e[11, 3, 6, 11] = complex(0.000016243475, 0.000060443986)
    h2e[1, 3, 8, 11] = complex(-0.000000236188, 0.000000143069)
    h2e[5, 3, 8, 11] = complex(-0.000001634182, -0.000002676141)
    h2e[7, 3, 8, 11] = complex(-0.001326612524, -0.002651601943)
    h2e[9, 3, 8, 11] = complex(-0.005887133968, -0.002534924944)
    h2e[11, 3, 8, 11] = complex(0.000002930087, -0.000000855488)
    h2e[1, 5, 0, 11] = complex(-0.000292079065, 0.000002597366)
    h2e[3, 5, 0, 11] = complex(-0.017466706228, -0.000036350800)
    h2e[5, 5, 0, 11] = complex(-0.012132181965, -0.000022908072)
    h2e[7, 5, 0, 11] = complex(0.000020476557, 0.000000031509)
    h2e[9, 5, 0, 11] = complex(0.000003211368, 0.000001593140)
    h2e[11, 5, 0, 11] = complex(-0.006656342904, -0.000023107437)
    h2e[1, 5, 2, 11] = complex(-0.000426262624, 0.000025726768)
    h2e[3, 5, 2, 11] = complex(-0.000920367506, 0.000045419161)
    h2e[5, 5, 2, 11] = complex(0.004953999620, -0.000245431936)
    h2e[7, 5, 2, 11] = complex(0.000072067570, -0.000003229644)
    h2e[9, 5, 2, 11] = complex(-0.000000315857, 0.000000560676)
    h2e[11, 5, 2, 11] = complex(0.016099533544, -0.000772055169)
    h2e[1, 5, 4, 11] = complex(0.000126851383, -0.000013204054)
    h2e[3, 5, 4, 11] = complex(0.033850859659, -0.003148657755)
    h2e[5, 5, 4, 11] = complex(0.025989597277, -0.002422495941)
    h2e[7, 5, 4, 11] = complex(0.000064605022, -0.000007350123)
    h2e[9, 5, 4, 11] = complex(-0.000000240193, -0.000001319695)
    h2e[11, 5, 4, 11] = complex(0.045886543790, -0.004203821416)
    h2e[1, 5, 6, 11] = complex(-0.000004806615, -0.000009685547)
    h2e[3, 5, 6, 11] = complex(-0.000016419393, -0.000093568532)
    h2e[5, 5, 6, 11] = complex(-0.000017980723, -0.000069901733)
    h2e[7, 5, 6, 11] = complex(0.000691393442, 0.000543965443)
    h2e[9, 5, 6, 11] = complex(0.000376598989, -0.000126454235)
    h2e[11, 5, 6, 11] = complex(-0.000038524552, -0.000134606111)
    h2e[1, 5, 8, 11] = complex(0.000009705683, -0.000005829651)
    h2e[3, 5, 8, 11] = complex(0.000001700771, 0.000002802928)
    h2e[7, 5, 8, 11] = complex(0.000037506222, 0.000363719896)
    h2e[9, 5, 8, 11] = complex(0.000790477848, 0.000278306059)
    h2e[11, 5, 8, 11] = complex(-0.000011484995, 0.000002825819)
    h2e[1, 7, 0, 11] = complex(-0.000002003961, -0.000001064734)
    h2e[3, 7, 0, 11] = complex(0.000032039121, 0.000000158437)
    h2e[5, 7, 0, 11] = complex(0.000013484089, 0.000000168744)
    h2e[7, 7, 0, 11] = complex(-0.003309159175, -0.000006248378)
    h2e[9, 7, 0, 11] = complex(-0.000000008496, -0.000000004108)
    h2e[11, 7, 0, 11] = complex(0.000022262452, -0.000000466507)
    h2e[1, 7, 2, 11] = complex(-0.000003334402, -0.000000493655)
    h2e[3, 7, 2, 11] = complex(0.000000293645, 0.000002101799)
    h2e[5, 7, 2, 11] = complex(0.000078667555, -0.000002922892)
    h2e[7, 7, 2, 11] = complex(0.032020567492, -0.001586368686)
    h2e[9, 7, 2, 11] = complex(0.000000001531, -0.000000003206)
    h2e[11, 7, 2, 11] = complex(-0.000050836240, 0.000003309722)
    h2e[1, 7, 4, 11] = complex(-0.000009575327, 0.000001827919)
    h2e[3, 7, 4, 11] = complex(-0.000082520473, 0.000011444828)
    h2e[5, 7, 4, 11] = complex(0.000054600471, -0.000006130649)
    h2e[7, 7, 4, 11] = complex(0.041021844538, -0.003823654936)
    h2e[9, 7, 4, 11] = complex(-0.000000000324, 0.000000004795)
    h2e[11, 7, 4, 11] = complex(-0.000135062362, 0.000013676627)
    h2e[1, 7, 6, 11] = complex(-0.002090420797, -0.003766635287)
    h2e[3, 7, 6, 11] = complex(0.002634971877, 0.005164767102)
    h2e[5, 7, 6, 11] = complex(-0.000347748942, -0.000696717490)
    h2e[7, 7, 6, 11] = complex(-0.000033242168, -0.000129232017)
    h2e[9, 7, 6, 11] = complex(-0.000000668331, 0.000000159682)
    h2e[11, 7, 6, 11] = complex(-0.000263232548, 0.000123925162)
    h2e[1, 7, 8, 11] = complex(0.004038955354, -0.002477030660)
    h2e[3, 7, 8, 11] = complex(-0.000268285194, -0.000366703370)
    h2e[5, 7, 8, 11] = complex(0.000145339193, -0.000014616946)
    h2e[9, 7, 8, 11] = complex(-0.000006601612, 0.000000534422)
    h2e[11, 7, 8, 11] = complex(-0.003733332377, 0.002106913145)
    h2e[1, 9, 0, 11] = complex(-0.000001317954, 0.000001338573)
    h2e[3, 9, 0, 11] = complex(-0.000007158561, 0.000003680332)
    h2e[5, 9, 0, 11] = complex(-0.000003190844, 0.000001626145)
    h2e[7, 9, 0, 11] = complex(0.000000008432, -0.000000004191)
    h2e[9, 9, 0, 11] = complex(-0.003307705496, -0.000006245633)
    h2e[11, 9, 0, 11] = complex(0.000002407980, -0.000001291743)
    h2e[1, 9, 2, 11] = complex(0.000004145766, -0.000002553254)
    h2e[3, 9, 2, 11] = complex(0.000002045103, 0.000000659204)
    h2e[5, 9, 2, 11] = complex(0.000000263952, 0.000000425166)
    h2e[7, 9, 2, 11] = complex(-0.000000001441, -0.000000002828)
    h2e[9, 9, 2, 11] = complex(0.032020110590, -0.001586346050)
    h2e[11, 9, 2, 11] = complex(-0.000002923697, 0.000000877077)
    h2e[1, 9, 4, 11] = complex(0.000008648060, -0.000005840113)
    h2e[3, 9, 4, 11] = complex(0.000001536158, 0.000002252819)
    h2e[5, 9, 4, 11] = complex(0.000000188575, -0.000001156547)
    h2e[7, 9, 4, 11] = complex(0.000000000686, 0.000000004370)
    h2e[9, 9, 4, 11] = complex(0.041020701069, -0.003823548353)
    h2e[11, 9, 4, 11] = complex(-0.000011318928, 0.000003431063)
    h2e[1, 9, 6, 11] = complex(0.003974878948, 0.002582675083)
    h2e[3, 9, 6, 11] = complex(0.000215718001, -0.000399892066)
    h2e[5, 9, 6, 11] = complex(0.000075684314, 0.000124925058)
    h2e[7, 9, 6, 11] = complex(-0.000000239882, 0.000000025330)
    h2e[9, 9, 6, 11] = complex(-0.000033241521, -0.000129229497)
    h2e[11, 9, 6, 11] = complex(-0.003507450636, -0.002464679224)
    h2e[1, 9, 8, 11] = complex(-0.002250165952, 0.003693531524)
    h2e[3, 9, 8, 11] = complex(0.003199162838, -0.004861088797)
    h2e[5, 9, 8, 11] = complex(-0.000435490798, 0.000649260492)
    h2e[7, 9, 8, 11] = complex(-0.000001731893, 0.000004569437)
    h2e[11, 9, 8, 11] = complex(0.000238436735, 0.000168521899)
    h2e[1, 11, 0, 11] = complex(-0.009226813032, 0.000772142325)
    h2e[3, 11, 0, 11] = complex(-0.010051390489, -0.000002651180)
    h2e[5, 11, 0, 11] = complex(-0.006656394953, -0.000002029730)
    h2e[7, 11, 0, 11] = complex(0.000016712735, 0.000000624450)
    h2e[9, 11, 0, 11] = complex(-0.000002418476, -0.000001278847)
    h2e[11, 11, 0, 11] = complex(0.008139708349, 0.000015369455)
    h2e[1, 11, 2, 11] = complex(-0.001481837365, 0.000201091283)
    h2e[3, 11, 2, 11] = complex(-0.026504200769, 0.001356239631)
    h2e[5, 11, 2, 11] = complex(0.016097010204, -0.000823031317)
    h2e[7, 11, 2, 11] = complex(-0.000049888300, 0.000000396800)
    h2e[9, 11, 2, 11] = complex(0.000003013813, 0.000000669316)
    h2e[11, 11, 2, 11] = complex(0.010234604227, -0.000507044594)
    h2e[1, 11, 4, 11] = complex(0.001176251547, -0.000212000683)
    h2e[3, 11, 4, 11] = complex(-0.019365590974, 0.001836807338)
    h2e[5, 11, 4, 11] = complex(0.045873002125, -0.004349103000)
    h2e[7, 11, 4, 11] = complex(-0.000135253881, 0.000005706953)
    h2e[9, 11, 4, 11] = complex(0.000011880925, 0.000001558058)
    h2e[11, 11, 4, 11] = complex(-0.009457316943, 0.000881518542)
    h2e[1, 11, 6, 11] = complex(0.000000153431, -0.000001014420)
    h2e[3, 11, 6, 11] = complex(0.000015466315, 0.000062078620)
    h2e[5, 11, 6, 11] = complex(-0.000032613704, -0.000138174804)
    h2e[7, 11, 6, 11] = complex(0.002259914109, -0.001106610448)
    h2e[9, 11, 6, 11] = complex(0.002416092867, 0.004413335482)
    h2e[11, 11, 6, 11] = complex(0.000009883137, 0.000038421612)
    h2e[1, 11, 8, 11] = complex(-0.000002303852, 0.000001460774)
    h2e[3, 11, 8, 11] = complex(-0.000002837602, 0.000001032297)
    h2e[5, 11, 8, 11] = complex(0.000011019462, -0.000003718079)
    h2e[7, 11, 8, 11] = complex(0.004738130539, -0.000312554798)
    h2e[9, 11, 8, 11] = complex(0.000023988225, 0.002171715263)
    h2e[3, 0, 3, 0] = complex(0.050092941350, -0.000027846866)
    h2e[5, 0, 3, 0] = complex(0.020872996322, -0.000006193553)
    h2e[7, 0, 3, 0] = complex(-0.000054818371, 0.000000678316)
    h2e[9, 0, 3, 0] = complex(0.000000379380, 0.000000173174)
    h2e[11, 0, 3, 0] = complex(-0.020370316775, 0.000044125368)
    h2e[3, 0, 5, 0] = complex(0.020872996322, -0.000006193553)
    h2e[5, 0, 5, 0] = complex(0.020936167087, -0.000000786105)
    h2e[7, 0, 5, 0] = complex(-0.000080763514, 0.000000749622)
    h2e[9, 0, 5, 0] = complex(-0.000019227226, -0.000008605252)
    h2e[11, 0, 5, 0] = complex(0.002992890300, -0.000005707356)
    h2e[3, 0, 7, 0] = complex(-0.000054818371, 0.000000678316)
    h2e[5, 0, 7, 0] = complex(-0.000080763514, 0.000000749622)
    h2e[7, 0, 7, 0] = complex(-0.010940280704, 0.000089491047)
    h2e[9, 0, 7, 0] = complex(-0.007992926276, -0.004125601022)
    h2e[11, 0, 7, 0] = complex(-0.000000864575, 0.000000307582)
    h2e[3, 0, 9, 0] = complex(0.000000379380, 0.000000173174)
    h2e[5, 0, 9, 0] = complex(-0.000019227226, -0.000008605252)
    h2e[7, 0, 9, 0] = complex(-0.007992926276, -0.004125601022)
    h2e[9, 0, 9, 0] = complex(-0.006365091207, -0.008962281075)
    h2e[11, 0, 9, 0] = complex(0.000006463649, 0.000003230930)
    h2e[3, 0, 11, 0] = complex(-0.020370316775, 0.000044125368)
    h2e[5, 0, 11, 0] = complex(0.002992890300, -0.000005707356)
    h2e[7, 0, 11, 0] = complex(-0.000000864575, 0.000000307582)
    h2e[9, 0, 11, 0] = complex(0.000006463649, 0.000003230930)
    h2e[11, 0, 11, 0] = complex(0.019092268023, -0.000072100633)
    h2e[1, 2, 3, 0] = complex(0.050009012185, -0.002898663307)
    h2e[5, 2, 3, 0] = complex(0.000467185282, 0.000016007723)
    h2e[7, 2, 3, 0] = complex(-0.000001513135, 0.000001817683)
    h2e[9, 2, 3, 0] = complex(0.000000251494, 0.000000200711)
    h2e[11, 2, 3, 0] = complex(0.001063003865, 0.000052367341)
    h2e[1, 2, 5, 0] = complex(0.020838334307, -0.001202429685)
    h2e[5, 2, 5, 0] = complex(-0.000724678224, -0.000025018699)
    h2e[7, 2, 5, 0] = complex(0.000006526300, 0.000000691892)
    h2e[9, 2, 5, 0] = complex(-0.000011553965, -0.000008788789)
    h2e[11, 2, 5, 0] = complex(0.004370231011, 0.000216428575)
    h2e[1, 2, 7, 0] = complex(-0.000054689397, 0.000003818881)
    h2e[5, 2, 7, 0] = complex(0.000007711501, -0.000003004025)
    h2e[7, 2, 7, 0] = complex(0.002117164400, 0.000031367074)
    h2e[9, 2, 7, 0] = complex(-0.005426708746, -0.002732306004)
    h2e[11, 2, 7, 0] = complex(-0.000013488292, -0.000000130614)
    h2e[1, 2, 9, 0] = complex(0.000000388681, 0.000000151147)
    h2e[5, 2, 9, 0] = complex(-0.000012826356, -0.000009756663)
    h2e[7, 2, 9, 0] = complex(-0.005429108194, -0.002733514035)
    h2e[9, 2, 9, 0] = complex(0.001190774575, 0.001761058404)
    h2e[11, 2, 9, 0] = complex(0.000000246979, 0.000000502994)
    h2e[1, 2, 11, 0] = complex(-0.020334307069, 0.001211490232)
    h2e[5, 2, 11, 0] = complex(-0.000995021906, -0.000032489441)
    h2e[7, 2, 11, 0] = complex(0.000004262317, -0.000004004252)
    h2e[9, 2, 11, 0] = complex(0.000000408192, 0.000000831320)
    h2e[11, 2, 11, 0] = complex(0.003080101612, 0.000146765340)
    h2e[1, 4, 3, 0] = complex(-0.020871508207, 0.000249316921)
    h2e[3, 4, 3, 0] = complex(0.000465966433, 0.000037331199)
    h2e[7, 4, 3, 0] = complex(-0.000000059484, 0.000000539294)
    h2e[9, 4, 3, 0] = complex(-0.000000123761, -0.000000103398)
    h2e[11, 4, 3, 0] = complex(0.001554921454, 0.000144498624)
    h2e[1, 4, 5, 0] = complex(-0.020934737673, 0.000244645639)
    h2e[3, 4, 5, 0] = complex(-0.000722779000, -0.000058094584)
    h2e[7, 4, 5, 0] = complex(-0.000001503372, 0.000000615003)
    h2e[9, 4, 5, 0] = complex(0.000005538839, 0.000004455202)
    h2e[11, 4, 5, 0] = complex(-0.001301422168, -0.000121281124)
    h2e[1, 4, 7, 0] = complex(0.000080749304, -0.000001690284)
    h2e[3, 4, 7, 0] = complex(0.000007840669, -0.000002648642)
    h2e[7, 4, 7, 0] = complex(-0.000587791500, -0.000031719664)
    h2e[9, 4, 7, 0] = complex(0.002590000654, 0.001471571230)
    h2e[11, 4, 7, 0] = complex(-0.000001551911, 0.000000695858)
    h2e[1, 4, 9, 0] = complex(0.000019326154, 0.000008380715)
    h2e[3, 4, 9, 0] = complex(-0.000012367302, -0.000010332364)
    h2e[7, 4, 9, 0] = complex(0.002591197491, 0.001472251208)
    h2e[9, 4, 9, 0] = complex(-0.000311651451, -0.000502141443)
    h2e[11, 4, 9, 0] = complex(0.000000990524, 0.000001421960)
    h2e[1, 4, 11, 0] = complex(-0.002992620792, 0.000040567456)
    h2e[3, 4, 11, 0] = complex(-0.000992499249, -0.000077906342)
    h2e[7, 4, 11, 0] = complex(-0.000001160368, 0.000001681526)
    h2e[9, 4, 11, 0] = complex(-0.000000339911, -0.000000487964)
    h2e[11, 4, 11, 0] = complex(-0.002454315685, -0.000224093607)
    h2e[1, 6, 3, 0] = complex(0.000019690478, -0.000051164432)
    h2e[3, 6, 3, 0] = complex(0.000001006278, 0.000002140316)
    h2e[5, 6, 3, 0] = complex(-0.000000475820, -0.000000260715)
    h2e[11, 6, 3, 0] = complex(-0.000000898206, 0.000003677581)
    h2e[1, 6, 5, 0] = complex(0.000029241785, -0.000075287616)
    h2e[3, 6, 5, 0] = complex(0.000003389465, -0.000005619860)
    h2e[5, 6, 5, 0] = complex(0.000000005012, -0.000001624294)
    h2e[9, 6, 5, 0] = complex(-0.000000014615, 0.000000011406)
    h2e[11, 6, 5, 0] = complex(-0.000001875252, -0.000000619501)
    h2e[1, 6, 7, 0] = complex(0.003972306885, -0.010194043773)
    h2e[3, 6, 7, 0] = complex(0.000924625946, -0.001904845354)
    h2e[5, 6, 7, 0] = complex(0.000253551633, -0.000531240578)
    h2e[9, 6, 7, 0] = complex(-0.000005483213, 0.000005846032)
    h2e[11, 6, 7, 0] = complex(-0.000945768252, 0.001863720392)
    h2e[1, 6, 9, 0] = complex(0.006794559706, -0.005894184645)
    h2e[3, 6, 9, 0] = complex(-0.004774700558, 0.003761588684)
    h2e[5, 6, 9, 0] = complex(-0.002349405398, 0.001833609104)
    h2e[9, 6, 9, 0] = complex(0.000001653018, 0.000001126972)
    h2e[11, 6, 9, 0] = complex(0.000547527271, -0.000524213334)
    h2e[1, 6, 11, 0] = complex(0.000000034817, -0.000000916997)
    h2e[3, 6, 11, 0] = complex(-0.000001823537, -0.000005556626)
    h2e[5, 6, 11, 0] = complex(-0.000001111706, -0.000001714087)
    h2e[9, 6, 11, 0] = complex(0.000000001075, -0.000000001030)
    h2e[11, 6, 11, 0] = complex(0.000002184333, -0.000007391568)
    h2e[1, 8, 3, 0] = complex(-0.000000389785, -0.000000148276)
    h2e[3, 8, 3, 0] = complex(0.000000252967, 0.000000198850)
    h2e[5, 8, 3, 0] = complex(0.000000129072, 0.000000096687)
    h2e[11, 8, 3, 0] = complex(-0.000000014217, -0.000000028423)
    h2e[1, 8, 5, 0] = complex(0.000019743499, 0.000007343761)
    h2e[3, 8, 5, 0] = complex(-0.000011618473, -0.000008703332)
    h2e[5, 8, 5, 0] = complex(-0.000005767367, -0.000004155123)
    h2e[7, 8, 5, 0] = complex(0.000000016582, 0.000000008290)
    h2e[11, 8, 5, 0] = complex(0.000001155000, 0.000001483589)
    h2e[1, 8, 7, 0] = complex(0.008243006861, 0.003600040558)
    h2e[3, 8, 7, 0] = complex(-0.005446713585, -0.002692206339)
    h2e[5, 8, 7, 0] = complex(-0.002664413587, -0.001332113169)
    h2e[7, 8, 7, 0] = complex(0.000007635684, 0.000002436809)
    h2e[11, 8, 7, 0] = complex(0.000708372893, 0.000268804314)
    h2e[1, 8, 9, 0] = complex(0.006931380489, 0.008531871577)
    h2e[3, 8, 9, 0] = complex(0.001203731071, 0.001752227822)
    h2e[5, 8, 9, 0] = complex(0.000337848718, 0.000484902985)
    h2e[7, 8, 9, 0] = complex(0.000000306716, -0.000001976983)
    h2e[11, 8, 9, 0] = complex(-0.001157314582, -0.001750241189)
    h2e[1, 8, 11, 0] = complex(-0.000006659071, -0.000002806145)
    h2e[3, 8, 11, 0] = complex(0.000000414313, 0.000000828287)
    h2e[5, 8, 11, 0] = complex(0.000000365317, 0.000000469247)
    h2e[7, 8, 11, 0] = complex(-0.000000001392, -0.000000000528)
    h2e[11, 8, 11, 0] = complex(0.000000571692, 0.000000129130)
    h2e[1, 10, 3, 0] = complex(-0.020275362638, 0.001965050235)
    h2e[3, 10, 3, 0] = complex(-0.001064214871, -0.000012894305)
    h2e[5, 10, 3, 0] = complex(0.001561545206, 0.000015399727)
    h2e[7, 10, 3, 0] = complex(-0.000003681936, 0.000000880183)
    h2e[9, 10, 3, 0] = complex(-0.000000015056, -0.000000027988)
    h2e[1, 10, 5, 0] = complex(0.002979012409, -0.000287940955)
    h2e[3, 10, 5, 0] = complex(-0.004375251837, -0.000054145894)
    h2e[5, 10, 5, 0] = complex(-0.001306994181, -0.000013228091)
    h2e[7, 10, 5, 0] = complex(-0.000000305145, -0.000001951214)
    h2e[9, 10, 5, 0] = complex(0.000001198593, 0.000001448598)
    h2e[1, 10, 7, 0] = complex(-0.000000831713, 0.000000387749)
    h2e[3, 10, 7, 0] = complex(0.000013483851, -0.000000369886)
    h2e[5, 10, 7, 0] = complex(-0.000001489041, 0.000000821829)
    h2e[7, 10, 7, 0] = complex(-0.002089937535, 0.000009612277)
    h2e[9, 10, 7, 0] = complex(0.000716050824, 0.000247626999)
    h2e[1, 10, 9, 0] = complex(0.000006739549, 0.000002606944)
    h2e[3, 10, 9, 0] = complex(-0.000000265470, -0.000000493484)
    h2e[5, 10, 9, 0] = complex(0.000001104737, 0.000001335164)
    h2e[7, 10, 9, 0] = complex(0.000716386179, 0.000247742951)
    h2e[9, 10, 9, 0] = complex(-0.001208834294, -0.001715062943)
    h2e[1, 10, 11, 0] = complex(0.019000371943, -0.001872368224)
    h2e[3, 10, 11, 0] = complex(-0.003083426121, -0.000032393861)
    h2e[5, 10, 11, 0] = complex(-0.002464441093, -0.000020335266)
    h2e[7, 10, 11, 0] = complex(0.000007573397, -0.000001431871)
    h2e[9, 10, 11, 0] = complex(0.000000575277, 0.000000112078)
    h2e[3, 0, 1, 2] = complex(0.050009012185, -0.002898663307)
    h2e[5, 0, 1, 2] = complex(0.020838334307, -0.001202429685)
    h2e[7, 0, 1, 2] = complex(-0.000054689397, 0.000003818881)
    h2e[9, 0, 1, 2] = complex(0.000000388681, 0.000000151147)
    h2e[11, 0, 1, 2] = complex(-0.020334307069, 0.001211490232)
    h2e[3, 0, 5, 2] = complex(0.000467185282, 0.000016007723)
    h2e[5, 0, 5, 2] = complex(-0.000724678224, -0.000025018699)
    h2e[7, 0, 5, 2] = complex(0.000007711501, -0.000003004025)
    h2e[9, 0, 5, 2] = complex(-0.000012826356, -0.000009756663)
    h2e[11, 0, 5, 2] = complex(-0.000995021906, -0.000032489441)
    h2e[3, 0, 7, 2] = complex(-0.000001513135, 0.000001817683)
    h2e[5, 0, 7, 2] = complex(0.000006526300, 0.000000691892)
    h2e[7, 0, 7, 2] = complex(0.002117164400, 0.000031367074)
    h2e[9, 0, 7, 2] = complex(-0.005429108194, -0.002733514035)
    h2e[11, 0, 7, 2] = complex(0.000004262317, -0.000004004252)
    h2e[3, 0, 9, 2] = complex(0.000000251494, 0.000000200711)
    h2e[5, 0, 9, 2] = complex(-0.000011553965, -0.000008788789)
    h2e[7, 0, 9, 2] = complex(-0.005426708746, -0.002732306004)
    h2e[9, 0, 9, 2] = complex(0.001190774575, 0.001761058404)
    h2e[11, 0, 9, 2] = complex(0.000000408192, 0.000000831320)
    h2e[3, 0, 11, 2] = complex(0.001063003865, 0.000052367341)
    h2e[5, 0, 11, 2] = complex(0.004370231011, 0.000216428575)
    h2e[7, 0, 11, 2] = complex(-0.000013488292, -0.000000130614)
    h2e[9, 0, 11, 2] = complex(0.000000246979, 0.000000502994)
    h2e[11, 0, 11, 2] = complex(0.003080101612, 0.000146765340)
    h2e[1, 2, 1, 2] = complex(0.049760692428, -0.005759951206)
    h2e[5, 2, 1, 2] = complex(0.000467334826, -0.000010793309)
    h2e[7, 2, 1, 2] = complex(-0.000001406475, 0.000001901414)
    h2e[9, 2, 1, 2] = complex(0.000000262583, 0.000000185967)
    h2e[11, 2, 1, 2] = complex(0.001064257911, -0.000008640240)
    h2e[1, 2, 5, 2] = complex(0.000467334826, -0.000010793309)
    h2e[5, 2, 5, 2] = complex(0.000415483905, 0.000028758734)
    h2e[7, 2, 5, 2] = complex(-0.000162892228, -0.000001015179)
    h2e[9, 2, 5, 2] = complex(0.000137936199, 0.000070536963)
    h2e[11, 2, 5, 2] = complex(-0.000052278873, -0.000004407241)
    h2e[1, 2, 7, 2] = complex(-0.000001406475, 0.000001901414)
    h2e[5, 2, 7, 2] = complex(-0.000162892228, -0.000001015179)
    h2e[7, 2, 7, 2] = complex(-0.062006848847, -0.000696032830)
    h2e[9, 2, 7, 2] = complex(0.052214699497, 0.028185640385)
    h2e[11, 2, 7, 2] = complex(0.000022310493, 0.000001789963)
    h2e[1, 2, 9, 2] = complex(0.000000262583, 0.000000185967)
    h2e[5, 2, 9, 2] = complex(0.000137936199, 0.000070536963)
    h2e[7, 2, 9, 2] = complex(0.052214699497, 0.028185640385)
    h2e[9, 2, 9, 2] = complex(-0.035048421334, -0.051435136350)
    h2e[11, 2, 9, 2] = complex(-0.000021430846, -0.000011830021)
    h2e[1, 2, 11, 2] = complex(0.001064257911, -0.000008640240)
    h2e[5, 2, 11, 2] = complex(-0.000052278873, -0.000004407241)
    h2e[7, 2, 11, 2] = complex(0.000022310493, 0.000001789963)
    h2e[9, 2, 11, 2] = complex(-0.000021430846, -0.000011830021)
    h2e[11, 2, 11, 2] = complex(0.008101796286, 0.000804737143)
    h2e[1, 4, 1, 2] = complex(-0.020822915064, 0.001445068169)
    h2e[3, 4, 1, 2] = complex(0.000467340044, 0.000010564972)
    h2e[7, 4, 1, 2] = complex(-0.000000028478, 0.000000541817)
    h2e[9, 4, 1, 2] = complex(-0.000000129484, -0.000000096135)
    h2e[11, 4, 1, 2] = complex(0.001560647090, 0.000055147467)
    h2e[1, 4, 5, 2] = complex(0.000724920476, 0.000016576119)
    h2e[3, 4, 5, 2] = complex(0.000413736578, 0.000047707274)
    h2e[7, 4, 5, 2] = complex(0.000059186565, 0.000004507897)
    h2e[9, 4, 5, 2] = complex(-0.000048803275, -0.000027490966)
    h2e[11, 4, 5, 2] = complex(0.001922115191, 0.000246342240)
    h2e[1, 4, 7, 2] = complex(-0.000006533915, -0.000000615828)
    h2e[3, 4, 7, 2] = complex(-0.000162675831, -0.000008454745)
    h2e[7, 4, 7, 2] = complex(0.022215298088, 0.001264083045)
    h2e[9, 4, 7, 2] = complex(-0.017930183167, -0.010766697272)
    h2e[11, 4, 7, 2] = complex(0.000033080050, 0.000011145746)
    h2e[1, 4, 9, 2] = complex(0.000011655550, 0.000008653615)
    h2e[3, 4, 9, 2] = complex(0.000134570219, 0.000076764016)
    h2e[7, 4, 9, 2] = complex(-0.017930304735, -0.010766770264)
    h2e[9, 4, 9, 2] = complex(0.011721426130, 0.019010267015)
    h2e[11, 4, 9, 2] = complex(-0.000036035864, -0.000021914402)
    h2e[1, 4, 11, 2] = complex(-0.004372455455, -0.000165510463)
    h2e[3, 4, 11, 2] = complex(-0.000052022989, -0.000006790646)
    h2e[7, 4, 11, 2] = complex(-0.000008576882, 0.000005758953)
    h2e[9, 4, 11, 2] = complex(0.000006915163, 0.000004205300)
    h2e[11, 4, 11, 2] = complex(0.005907237951, 0.000847185804)
    h2e[1, 6, 1, 2] = complex(0.000016725844, -0.000052208813)
    h2e[3, 6, 1, 2] = complex(0.000001127288, 0.000002079128)
    h2e[5, 6, 1, 2] = complex(-0.000000489979, -0.000000233017)
    h2e[11, 6, 1, 2] = complex(-0.000000685965, 0.000003723013)
    h2e[1, 6, 5, 2] = complex(-0.000000068543, 0.000008275670)
    h2e[3, 6, 5, 2] = complex(-0.000069872953, 0.000147148493)
    h2e[5, 6, 5, 2] = complex(-0.000026745490, 0.000052991032)
    h2e[9, 6, 5, 2] = complex(0.000000115602, -0.000000085825)
    h2e[11, 6, 5, 2] = complex(0.000018436222, -0.000038364055)
    h2e[1, 6, 7, 2] = complex(-0.000813938176, 0.001954705504)
    h2e[3, 6, 7, 2] = complex(-0.026878451331, 0.055882757824)
    h2e[5, 6, 7, 2] = complex(-0.009643182132, 0.020053089883)
    h2e[9, 6, 7, 2] = complex(0.000044560246, -0.000031105672)
    h2e[11, 6, 7, 2] = complex(0.008210809229, -0.017027156104)
    h2e[1, 6, 9, 2] = complex(0.004549262017, -0.004027266932)
    h2e[3, 6, 9, 2] = complex(0.047638602530, -0.035374690349)
    h2e[5, 6, 9, 2] = complex(0.016792608934, -0.012467054792)
    h2e[9, 6, 9, 2] = complex(-0.000053891035, 0.000008677865)
    h2e[11, 6, 9, 2] = complex(-0.015921926619, 0.011789241540)
    h2e[1, 6, 11, 2] = complex(0.000005121246, -0.000012478939)
    h2e[3, 6, 11, 2] = complex(0.000011065842, -0.000019455313)
    h2e[5, 6, 11, 2] = complex(-0.000002051535, -0.000010125199)
    h2e[9, 6, 11, 2] = complex(-0.000000017042, 0.000000012618)
    h2e[11, 6, 11, 2] = complex(-0.000009591194, 0.000026144610)
    h2e[1, 8, 1, 2] = complex(-0.000000397642, -0.000000125694)
    h2e[3, 8, 1, 2] = complex(0.000000263947, 0.000000184026)
    h2e[5, 8, 1, 2] = complex(0.000000134401, 0.000000089131)
    h2e[11, 8, 1, 2] = complex(-0.000000015823, -0.000000027561)
    h2e[1, 8, 5, 2] = complex(0.000013430494, 0.000008906723)
    h2e[3, 8, 5, 2] = complex(0.000138452701, 0.000069517680)
    h2e[5, 8, 5, 2] = complex(0.000050192821, 0.000024863499)
    h2e[7, 8, 5, 2] = complex(-0.000000127192, -0.000000067468)
    h2e[11, 8, 5, 2] = complex(-0.000044665857, -0.000024014159)
    h2e[1, 8, 7, 2] = complex(0.005594526118, 0.002376676749)
    h2e[3, 8, 7, 2] = complex(0.052421165776, 0.027799758101)
    h2e[5, 8, 7, 2] = complex(0.018476057964, 0.009800434746)
    h2e[7, 8, 7, 2] = complex(-0.000047243304, -0.000026856073)
    h2e[11, 8, 7, 2] = complex(-0.017489869738, -0.009305866711)
    h2e[1, 8, 9, 2] = complex(-0.001302174034, -0.001680361157)
    h2e[3, 8, 9, 2] = complex(-0.035426833927, -0.051175233565)
    h2e[5, 8, 9, 2] = complex(-0.012713321220, -0.018361741380)
    h2e[7, 8, 9, 2] = complex(0.000031006598, 0.000044923711)
    h2e[11, 8, 9, 2] = complex(0.010783867752, 0.015611240673)
    h2e[1, 8, 11, 2] = complex(-0.000000278991, -0.000000485968)
    h2e[3, 8, 11, 2] = complex(-0.000021517517, -0.000011671633)
    h2e[5, 8, 11, 2] = complex(-0.000007128495, -0.000003832566)
    h2e[7, 8, 11, 2] = complex(0.000000018720, 0.000000009960)
    h2e[11, 8, 11, 2] = complex(0.000006939289, 0.000003952135)
    h2e[1, 10, 1, 2] = complex(-0.020129419425, 0.003123815959)
    h2e[3, 10, 1, 2] = complex(-0.001063204699, 0.000048117801)
    h2e[5, 10, 1, 2] = complex(0.001559861204, -0.000074118855)
    h2e[7, 10, 1, 2] = complex(-0.000003625441, 0.000001089750)
    h2e[9, 10, 1, 2] = complex(-0.000000016635, -0.000000027079)
    h2e[1, 10, 5, 2] = complex(-0.000993651062, 0.000061495736)
    h2e[3, 10, 5, 2] = complex(0.000052406389, 0.000002464684)
    h2e[5, 10, 5, 2] = complex(0.001935904125, 0.000086524698)
    h2e[7, 10, 5, 2] = complex(0.000042549375, -0.000001116081)
    h2e[9, 10, 5, 2] = complex(-0.000045360009, -0.000022675718)
    h2e[1, 10, 7, 2] = complex(0.000003865679, -0.000004388383)
    h2e[3, 10, 7, 2] = complex(-0.000022361542, -0.000000961021)
    h2e[5, 10, 7, 2] = complex(0.000033888551, 0.000008371587)
    h2e[7, 10, 7, 2] = complex(0.018897627408, -0.000470224783)
    h2e[9, 10, 7, 2] = complex(-0.017758784636, -0.008781814528)
    h2e[1, 10, 9, 2] = complex(0.000000484774, 0.000000789118)
    h2e[3, 10, 9, 2] = complex(0.000021854981, 0.000011026802)
    h2e[5, 10, 9, 2] = complex(-0.000037724888, -0.000018858880)
    h2e[7, 10, 9, 2] = complex(-0.017758768000, -0.008781806332)
    h2e[9, 10, 9, 2] = complex(0.011243192816, 0.015283757846)
    h2e[1, 10, 11, 2] = complex(0.003080214687, -0.000144372733)
    h2e[3, 10, 11, 2] = complex(-0.008126074201, -0.000503609992)
    h2e[5, 10, 11, 2] = complex(0.005957067615, 0.000355709739)
    h2e[7, 10, 11, 2] = complex(-0.000027639370, 0.000003405420)
    h2e[9, 10, 11, 2] = complex(0.000007053713, 0.000003744097)
    h2e[3, 0, 1, 4] = complex(-0.020871508207, 0.000249316921)
    h2e[5, 0, 1, 4] = complex(-0.020934737673, 0.000244645639)
    h2e[7, 0, 1, 4] = complex(0.000080749304, -0.000001690284)
    h2e[9, 0, 1, 4] = complex(0.000019326154, 0.000008380715)
    h2e[11, 0, 1, 4] = complex(-0.002992620792, 0.000040567456)
    h2e[3, 0, 3, 4] = complex(0.000465966433, 0.000037331199)
    h2e[5, 0, 3, 4] = complex(-0.000722779000, -0.000058094584)
    h2e[7, 0, 3, 4] = complex(0.000007840669, -0.000002648642)
    h2e[9, 0, 3, 4] = complex(-0.000012367302, -0.000010332364)
    h2e[11, 0, 3, 4] = complex(-0.000992499249, -0.000077906342)
    h2e[3, 0, 7, 4] = complex(-0.000000059484, 0.000000539294)
    h2e[5, 0, 7, 4] = complex(-0.000001503372, 0.000000615003)
    h2e[7, 0, 7, 4] = complex(-0.000587791500, -0.000031719664)
    h2e[9, 0, 7, 4] = complex(0.002591197491, 0.001472251208)
    h2e[11, 0, 7, 4] = complex(-0.000001160368, 0.000001681526)
    h2e[3, 0, 9, 4] = complex(-0.000000123761, -0.000000103398)
    h2e[5, 0, 9, 4] = complex(0.000005538839, 0.000004455202)
    h2e[7, 0, 9, 4] = complex(0.002590000654, 0.001471571230)
    h2e[9, 0, 9, 4] = complex(-0.000311651451, -0.000502141443)
    h2e[11, 0, 9, 4] = complex(-0.000000339911, -0.000000487964)
    h2e[3, 0, 11, 4] = complex(0.001554921454, 0.000144498624)
    h2e[5, 0, 11, 4] = complex(-0.001301422168, -0.000121281124)
    h2e[7, 0, 11, 4] = complex(-0.000001551911, 0.000000695858)
    h2e[9, 0, 11, 4] = complex(0.000000990524, 0.000001421960)
    h2e[11, 0, 11, 4] = complex(-0.002454315685, -0.000224093607)
    h2e[1, 2, 1, 4] = complex(-0.020822915064, 0.001445068169)
    h2e[5, 2, 1, 4] = complex(0.000724920476, 0.000016576119)
    h2e[7, 2, 1, 4] = complex(-0.000006533915, -0.000000615828)
    h2e[9, 2, 1, 4] = complex(0.000011655550, 0.000008653615)
    h2e[11, 2, 1, 4] = complex(-0.004372455455, -0.000165510463)
    h2e[1, 2, 3, 4] = complex(0.000467340044, 0.000010564972)
    h2e[5, 2, 3, 4] = complex(0.000413736578, 0.000047707274)
    h2e[7, 2, 3, 4] = complex(-0.000162675831, -0.000008454745)
    h2e[9, 2, 3, 4] = complex(0.000134570219, 0.000076764016)
    h2e[11, 2, 3, 4] = complex(-0.000052022989, -0.000006790646)
    h2e[1, 2, 7, 4] = complex(-0.000000028478, 0.000000541817)
    h2e[5, 2, 7, 4] = complex(0.000059186565, 0.000004507897)
    h2e[7, 2, 7, 4] = complex(0.022215298088, 0.001264083045)
    h2e[9, 2, 7, 4] = complex(-0.017930304735, -0.010766770264)
    h2e[11, 2, 7, 4] = complex(-0.000008576882, 0.000005758953)
    h2e[1, 2, 9, 4] = complex(-0.000000129484, -0.000000096135)
    h2e[5, 2, 9, 4] = complex(-0.000048803275, -0.000027490966)
    h2e[7, 2, 9, 4] = complex(-0.017930183167, -0.010766697272)
    h2e[9, 2, 9, 4] = complex(0.011721426130, 0.019010267015)
    h2e[11, 2, 9, 4] = complex(0.000006915163, 0.000004205300)
    h2e[1, 2, 11, 4] = complex(0.001560647090, 0.000055147467)
    h2e[5, 2, 11, 4] = complex(0.001922115191, 0.000246342240)
    h2e[7, 2, 11, 4] = complex(0.000033080050, 0.000011145746)
    h2e[9, 2, 11, 4] = complex(-0.000036035864, -0.000021914402)
    h2e[11, 2, 11, 4] = complex(0.005907237951, 0.000847185804)
    h2e[1, 4, 1, 4] = complex(0.020930467936, -0.000488471980)
    h2e[3, 4, 1, 4] = complex(0.000723406641, 0.000049671882)
    h2e[7, 4, 1, 4] = complex(0.000001496106, -0.000000632472)
    h2e[9, 4, 1, 4] = complex(-0.000005590356, -0.000004390385)
    h2e[11, 4, 1, 4] = complex(0.001302746537, 0.000106114235)
    h2e[1, 4, 3, 4] = complex(0.000723406641, 0.000049671882)
    h2e[3, 4, 3, 4] = complex(0.000411125540, 0.000066556221)
    h2e[7, 4, 3, 4] = complex(0.000058918874, 0.000007206728)
    h2e[9, 4, 3, 4] = complex(-0.000047496596, -0.000029691518)
    h2e[11, 4, 3, 4] = complex(0.001908856428, 0.000333883878)
    h2e[1, 4, 7, 4] = complex(0.000001496106, -0.000000632472)
    h2e[3, 4, 7, 4] = complex(0.000058918874, 0.000007206728)
    h2e[7, 4, 7, 4] = complex(-0.022707154540, -0.002338356469)
    h2e[9, 4, 7, 4] = complex(0.017434261115, 0.011582582772)
    h2e[11, 4, 7, 4] = complex(0.000011984656, 0.000006951282)
    h2e[1, 4, 9, 4] = complex(-0.000005590356, -0.000004390385)
    h2e[3, 4, 9, 4] = complex(-0.000047496596, -0.000029691518)
    h2e[7, 4, 9, 4] = complex(0.017434261115, 0.011582582772)
    h2e[9, 4, 9, 4] = complex(-0.011120291137, -0.020033076241)
    h2e[11, 4, 9, 4] = complex(-0.000011835221, -0.000007893617)
    h2e[1, 4, 11, 4] = complex(0.001302746537, 0.000106114235)
    h2e[3, 4, 11, 4] = complex(0.001908856428, 0.000333883878)
    h2e[7, 4, 11, 4] = complex(0.000011984656, 0.000006951282)
    h2e[9, 4, 11, 4] = complex(-0.000011835221, -0.000007893617)
    h2e[11, 4, 11, 4] = complex(0.016766623257, 0.003153042126)
    h2e[1, 6, 1, 4] = complex(-0.000028362870, 0.000075623110)
    h2e[3, 6, 1, 4] = complex(-0.000003323776, 0.000005658958)
    h2e[5, 6, 1, 4] = complex(0.000000013908, 0.000001624242)
    h2e[9, 6, 1, 4] = complex(0.000000014481, -0.000000011576)
    h2e[11, 6, 1, 4] = complex(0.000001882341, 0.000000597617)
    h2e[1, 6, 3, 4] = complex(-0.000000446489, 0.000008263900)
    h2e[3, 6, 3, 4] = complex(-0.000076521500, 0.000143803229)
    h2e[5, 6, 3, 4] = complex(-0.000029138109, 0.000051714034)
    h2e[9, 6, 3, 4] = complex(0.000000119402, -0.000000080455)
    h2e[11, 6, 3, 4] = complex(0.000020169380, -0.000037481877)
    h2e[1, 6, 7, 4] = complex(0.000247346666, -0.000534157850)
    h2e[3, 6, 7, 4] = complex(0.010549105757, -0.019591675352)
    h2e[5, 6, 7, 4] = complex(0.010823849282, -0.020097936844)
    h2e[9, 6, 7, 4] = complex(-0.000043199466, 0.000026963314)
    h2e[11, 6, 7, 4] = complex(0.000996996238, -0.001852198814)
    h2e[1, 6, 9, 4] = complex(-0.002326813360, 0.001859990550)
    h2e[3, 6, 9, 4] = complex(-0.017344435981, 0.011686906310)
    h2e[5, 6, 9, 4] = complex(-0.017357496575, 0.011697307258)
    h2e[9, 6, 9, 4] = complex(0.000156858028, -0.000018728109)
    h2e[11, 6, 9, 4] = complex(-0.001863664711, 0.001249357819)
    h2e[1, 6, 11, 4] = complex(-0.000000071010, -0.000001699295)
    h2e[3, 6, 11, 4] = complex(0.000024100875, -0.000025252034)
    h2e[5, 6, 11, 4] = complex(-0.000010997513, 0.000008426566)
    h2e[9, 6, 11, 4] = complex(0.000000022545, -0.000000015114)
    h2e[11, 6, 11, 4] = complex(-0.000036438699, 0.000082942820)
    h2e[1, 8, 1, 4] = complex(-0.000019827698, -0.000007113296)
    h2e[3, 8, 1, 4] = complex(0.000011719058, 0.000008567413)
    h2e[5, 8, 1, 4] = complex(0.000005815373, 0.000004087664)
    h2e[7, 8, 1, 4] = complex(-0.000000016677, -0.000000008097)
    h2e[11, 8, 1, 4] = complex(-0.000001172202, -0.000001470035)
    h2e[1, 8, 3, 4] = complex(0.000013009633, 0.000009510907)
    h2e[3, 8, 3, 4] = complex(0.000135132740, 0.000075769389)
    h2e[5, 8, 3, 4] = complex(0.000049004710, 0.000027130265)
    h2e[7, 8, 3, 4] = complex(-0.000000123978, -0.000000073207)
    h2e[11, 8, 3, 4] = complex(-0.000043522312, -0.000026029349)
    h2e[1, 8, 7, 4] = complex(-0.002680987283, -0.001301589514)
    h2e[3, 8, 7, 4] = complex(-0.018009228615, -0.010634230346)
    h2e[5, 8, 7, 4] = complex(-0.018024112655, -0.010641477712)
    h2e[7, 8, 7, 4] = complex(0.000042918314, 0.000027408622)
    h2e[11, 8, 7, 4] = complex(-0.001929426624, -0.001145470674)
    h2e[1, 8, 9, 4] = complex(0.000343473836, 0.000480934907)
    h2e[3, 8, 9, 4] = complex(0.011861319773, 0.018923297179)
    h2e[5, 8, 9, 4] = complex(0.012167287340, 0.019414997755)
    h2e[7, 8, 9, 4] = complex(-0.000084353742, -0.000133565074)
    h2e[11, 8, 9, 4] = complex(0.001122154479, 0.001789769321)
    h2e[1, 8, 11, 4] = complex(-0.000001080412, -0.000001354923)
    h2e[3, 8, 11, 4] = complex(-0.000036196519, -0.000021648019)
    h2e[5, 8, 11, 4] = complex(0.000012237276, 0.000007254706)
    h2e[7, 8, 11, 4] = complex(-0.000000023340, -0.000000013856)
    h2e[11, 8, 11, 4] = complex(0.000031274059, 0.000019624438)
    h2e[1, 10, 1, 4] = complex(-0.002975456451, 0.000322620263)
    h2e[3, 10, 1, 4] = complex(0.004375585710, 0.000003180309)
    h2e[5, 10, 1, 4] = complex(0.001307059596, -0.000001996369)
    h2e[7, 10, 1, 4] = complex(0.000000327851, 0.000001947528)
    h2e[9, 10, 1, 4] = complex(-0.000001215385, -0.000001434539)
    h2e[1, 10, 3, 4] = complex(-0.000995422909, 0.000016043351)
    h2e[3, 10, 3, 4] = complex(0.000052239105, 0.000004855941)
    h2e[5, 10, 3, 4] = complex(0.001929931147, 0.000174863006)
    h2e[7, 10, 3, 4] = complex(0.000042555943, 0.000000828664)
    h2e[9, 10, 3, 4] = complex(-0.000044276876, -0.000024724013)
    h2e[1, 10, 7, 4] = complex(-0.000000996612, 0.000001783465)
    h2e[3, 10, 7, 4] = complex(0.000008357323, -0.000006073188)
    h2e[5, 10, 7, 4] = complex(0.000012518519, 0.000005936244)
    h2e[7, 10, 7, 4] = complex(0.002103079293, 0.000041224194)
    h2e[9, 10, 7, 4] = complex(-0.001962626440, -0.001087606368)
    h2e[1, 10, 9, 4] = complex(-0.000000384416, -0.000000453732)
    h2e[3, 10, 9, 4] = complex(-0.000007066417, -0.000003945855)
    h2e[5, 10, 9, 4] = complex(-0.000012447534, -0.000006887709)
    h2e[7, 10, 9, 4] = complex(-0.001962499932, -0.001087536267)
    h2e[9, 10, 9, 4] = complex(0.001174864812, 0.001755618856)
    h2e[1, 10, 11, 4] = complex(-0.002464510772, 0.000008371348)
    h2e[3, 10, 11, 4] = complex(-0.005934601483, -0.000627446598)
    h2e[5, 10, 11, 4] = complex(0.016969958962, 0.001755512150)
    h2e[7, 10, 11, 4] = complex(-0.000090429663, 0.000005455844)
    h2e[9, 10, 11, 4] = complex(0.000031843637, 0.000018686048)
    h2e[3, 0, 1, 6] = complex(0.000019690478, -0.000051164432)
    h2e[5, 0, 1, 6] = complex(0.000029241785, -0.000075287616)
    h2e[7, 0, 1, 6] = complex(0.003972306885, -0.010194043773)
    h2e[9, 0, 1, 6] = complex(0.006794559706, -0.005894184645)
    h2e[11, 0, 1, 6] = complex(0.000000034817, -0.000000916997)
    h2e[3, 0, 3, 6] = complex(0.000001006278, 0.000002140316)
    h2e[5, 0, 3, 6] = complex(0.000003389465, -0.000005619860)
    h2e[7, 0, 3, 6] = complex(0.000924625946, -0.001904845354)
    h2e[9, 0, 3, 6] = complex(-0.004774700558, 0.003761588684)
    h2e[11, 0, 3, 6] = complex(-0.000001823537, -0.000005556626)
    h2e[3, 0, 5, 6] = complex(-0.000000475820, -0.000000260715)
    h2e[5, 0, 5, 6] = complex(0.000000005012, -0.000001624294)
    h2e[7, 0, 5, 6] = complex(0.000253551633, -0.000531240578)
    h2e[9, 0, 5, 6] = complex(-0.002349405398, 0.001833609104)
    h2e[11, 0, 5, 6] = complex(-0.000001111706, -0.000001714087)
    h2e[5, 0, 9, 6] = complex(-0.000000014615, 0.000000011406)
    h2e[7, 0, 9, 6] = complex(-0.000005483213, 0.000005846032)
    h2e[9, 0, 9, 6] = complex(0.000001653018, 0.000001126972)
    h2e[11, 0, 9, 6] = complex(0.000000001075, -0.000000001030)
    h2e[3, 0, 11, 6] = complex(-0.000000898206, 0.000003677581)
    h2e[5, 0, 11, 6] = complex(-0.000001875252, -0.000000619501)
    h2e[7, 0, 11, 6] = complex(-0.000945768252, 0.001863720392)
    h2e[9, 0, 11, 6] = complex(0.000547527271, -0.000524213334)
    h2e[11, 0, 11, 6] = complex(0.000002184333, -0.000007391568)
    h2e[1, 2, 1, 6] = complex(0.000016725844, -0.000052208813)
    h2e[5, 2, 1, 6] = complex(-0.000000068543, 0.000008275670)
    h2e[7, 2, 1, 6] = complex(-0.000813938176, 0.001954705504)
    h2e[9, 2, 1, 6] = complex(0.004549262017, -0.004027266932)
    h2e[11, 2, 1, 6] = complex(0.000005121246, -0.000012478939)
    h2e[1, 2, 3, 6] = complex(0.000001127288, 0.000002079128)
    h2e[5, 2, 3, 6] = complex(-0.000069872953, 0.000147148493)
    h2e[7, 2, 3, 6] = complex(-0.026878451331, 0.055882757824)
    h2e[9, 2, 3, 6] = complex(0.047638602530, -0.035374690349)
    h2e[11, 2, 3, 6] = complex(0.000011065842, -0.000019455313)
    h2e[1, 2, 5, 6] = complex(-0.000000489979, -0.000000233017)
    h2e[5, 2, 5, 6] = complex(-0.000026745490, 0.000052991032)
    h2e[7, 2, 5, 6] = complex(-0.009643182132, 0.020053089883)
    h2e[9, 2, 5, 6] = complex(0.016792608934, -0.012467054792)
    h2e[11, 2, 5, 6] = complex(-0.000002051535, -0.000010125199)
    h2e[5, 2, 9, 6] = complex(0.000000115602, -0.000000085825)
    h2e[7, 2, 9, 6] = complex(0.000044560246, -0.000031105672)
    h2e[9, 2, 9, 6] = complex(-0.000053891035, 0.000008677865)
    h2e[11, 2, 9, 6] = complex(-0.000000017042, 0.000000012618)
    h2e[1, 2, 11, 6] = complex(-0.000000685965, 0.000003723013)
    h2e[5, 2, 11, 6] = complex(0.000018436222, -0.000038364055)
    h2e[7, 2, 11, 6] = complex(0.008210809229, -0.017027156104)
    h2e[9, 2, 11, 6] = complex(-0.015921926619, 0.011789241540)
    h2e[11, 2, 11, 6] = complex(-0.000009591194, 0.000026144610)
    h2e[1, 4, 1, 6] = complex(-0.000028362870, 0.000075623110)
    h2e[3, 4, 1, 6] = complex(-0.000000446489, 0.000008263900)
    h2e[7, 4, 1, 6] = complex(0.000247346666, -0.000534157850)
    h2e[9, 4, 1, 6] = complex(-0.002326813360, 0.001859990550)
    h2e[11, 4, 1, 6] = complex(-0.000000071010, -0.000001699295)
    h2e[1, 4, 3, 6] = complex(-0.000003323776, 0.000005658958)
    h2e[3, 4, 3, 6] = complex(-0.000076521500, 0.000143803229)
    h2e[7, 4, 3, 6] = complex(0.010549105757, -0.019591675352)
    h2e[9, 4, 3, 6] = complex(-0.017344435981, 0.011686906310)
    h2e[11, 4, 3, 6] = complex(0.000024100875, -0.000025252034)
    h2e[1, 4, 5, 6] = complex(0.000000013908, 0.000001624242)
    h2e[3, 4, 5, 6] = complex(-0.000029138109, 0.000051714034)
    h2e[7, 4, 5, 6] = complex(0.010823849282, -0.020097936844)
    h2e[9, 4, 5, 6] = complex(-0.017357496575, 0.011697307258)
    h2e[11, 4, 5, 6] = complex(-0.000010997513, 0.000008426566)
    h2e[1, 4, 9, 6] = complex(0.000000014481, -0.000000011576)
    h2e[3, 4, 9, 6] = complex(0.000000119402, -0.000000080455)
    h2e[7, 4, 9, 6] = complex(-0.000043199466, 0.000026963314)
    h2e[9, 4, 9, 6] = complex(0.000156858028, -0.000018728109)
    h2e[11, 4, 9, 6] = complex(0.000000022545, -0.000000015114)
    h2e[1, 4, 11, 6] = complex(0.000001882341, 0.000000597617)
    h2e[3, 4, 11, 6] = complex(0.000020169380, -0.000037481877)
    h2e[7, 4, 11, 6] = complex(0.000996996238, -0.001852198814)
    h2e[9, 4, 11, 6] = complex(-0.001863664711, 0.001249357819)
    h2e[11, 4, 11, 6] = complex(-0.000036438699, 0.000082942820)
    h2e[1, 6, 1, 6] = complex(0.007995313794, 0.007468112725)
    h2e[3, 6, 1, 6] = complex(0.001426392904, 0.001564855335)
    h2e[5, 6, 1, 6] = complex(0.000399405472, 0.000432412128)
    h2e[9, 6, 1, 6] = complex(-0.000003396991, -0.000007259626)
    h2e[11, 6, 1, 6] = complex(-0.001380360568, -0.001569246945)
    h2e[1, 6, 3, 6] = complex(0.001426392904, 0.001564855335)
    h2e[3, 6, 3, 6] = complex(0.039251243707, 0.048007016546)
    h2e[5, 6, 3, 6] = complex(0.014085822356, 0.017225184595)
    h2e[9, 6, 3, 6] = complex(-0.000009318723, -0.000053538209)
    h2e[11, 6, 3, 6] = complex(-0.011950697685, -0.014646578377)
    h2e[1, 6, 5, 6] = complex(0.000399405472, 0.000432412128)
    h2e[3, 6, 5, 6] = complex(0.014085822356, 0.017225184595)
    h2e[5, 6, 5, 6] = complex(0.014448989700, 0.017672279867)
    h2e[9, 6, 5, 6] = complex(-0.000008444537, -0.000050218561)
    h2e[11, 6, 5, 6] = complex(0.001331795967, 0.001628177340)
    h2e[1, 6, 9, 6] = complex(-0.000003396991, -0.000007259626)
    h2e[3, 6, 9, 6] = complex(-0.000009318723, -0.000053538209)
    h2e[5, 6, 9, 6] = complex(-0.000008444537, -0.000050218561)
    h2e[9, 6, 9, 6] = complex(0.010607752147, -0.038662773701)
    h2e[11, 6, 9, 6] = complex(-0.000000511353, -0.000002558690)
    h2e[1, 6, 11, 6] = complex(-0.001380360568, -0.001569246945)
    h2e[3, 6, 11, 6] = complex(-0.011950697685, -0.014646578377)
    h2e[5, 6, 11, 6] = complex(0.001331795967, 0.001628177340)
    h2e[9, 6, 11, 6] = complex(-0.000000511353, -0.000002558690)
    h2e[11, 6, 11, 6] = complex(0.009238586512, 0.011501745602)
    h2e[1, 8, 1, 6] = complex(-0.006399143029, 0.006321267484)
    h2e[3, 8, 1, 6] = complex(0.004519434681, -0.004060711015)
    h2e[5, 8, 1, 6] = complex(0.002224874527, -0.001980797461)
    h2e[7, 8, 1, 6] = complex(-0.000005093656, 0.000006188407)
    h2e[11, 8, 1, 6] = complex(-0.000512238867, 0.000558264507)
    h2e[1, 8, 3, 6] = complex(0.004521433011, -0.004062506427)
    h2e[3, 8, 3, 6] = complex(0.047376396597, -0.035725092276)
    h2e[5, 8, 3, 6] = complex(0.016700086726, -0.012590486191)
    h2e[7, 8, 3, 6] = complex(-0.000044329611, 0.000031433484)
    h2e[11, 8, 3, 6] = complex(-0.015834555454, 0.011906366048)
    h2e[1, 8, 5, 6] = complex(0.002225902655, -0.001981712760)
    h2e[3, 8, 5, 6] = complex(0.016700199957, -0.012590571550)
    h2e[5, 8, 5, 6] = complex(0.016712577216, -0.012601565293)
    h2e[7, 8, 5, 6] = complex(-0.000041708380, 0.000029216864)
    h2e[11, 8, 5, 6] = complex(0.001794884574, -0.001346543549)
    h2e[1, 8, 9, 6] = complex(-0.000001722442, -0.000001017707)
    h2e[3, 8, 9, 6] = complex(-0.000053825564, 0.000009075109)
    h2e[5, 8, 9, 6] = complex(-0.000155643761, 0.000027022259)
    h2e[7, 8, 9, 6] = complex(-0.039467386357, 0.007046977365)
    h2e[11, 8, 9, 6] = complex(0.000012385993, -0.000001743936)
    h2e[1, 8, 11, 6] = complex(-0.000512478782, 0.000558525948)
    h2e[3, 8, 11, 6] = complex(-0.015834540607, 0.011906354919)
    h2e[5, 8, 11, 6] = complex(0.001794768876, -0.001346456756)
    h2e[7, 8, 11, 6] = complex(-0.000002090218, 0.000001561846)
    h2e[11, 8, 11, 6] = complex(0.011267874744, -0.008565985934)
    h2e[1, 10, 1, 6] = complex(-0.000000051820, -0.000000916194)
    h2e[3, 10, 1, 6] = complex(-0.000004654757, 0.000012660344)
    h2e[5, 10, 1, 6] = complex(-0.000000211311, -0.000001687600)
    h2e[7, 10, 1, 6] = complex(0.000765785669, -0.001944608854)
    h2e[9, 10, 1, 6] = complex(-0.000495416382, 0.000573245604)
    h2e[1, 10, 3, 6] = complex(-0.000002339454, -0.000005359883)
    h2e[3, 10, 3, 6] = complex(-0.000010336441, 0.000019852458)
    h2e[5, 10, 3, 6] = complex(0.000021929767, -0.000027158843)
    h2e[7, 10, 3, 6] = complex(0.007573456544, -0.017320051648)
    h2e[9, 10, 3, 6] = complex(-0.015473604261, 0.012371833716)
    h2e[1, 10, 5, 6] = complex(-0.000001268407, -0.000001601602)
    h2e[3, 10, 5, 6] = complex(0.000002425764, 0.000010042117)
    h2e[5, 10, 5, 6] = complex(-0.000010262893, 0.000009307274)
    h2e[7, 10, 5, 6] = complex(-0.000840389464, 0.001928312084)
    h2e[9, 10, 5, 6] = complex(0.001754061203, -0.001399306776)
    h2e[1, 10, 9, 6] = complex(0.000000000973, -0.000000001126)
    h2e[3, 10, 9, 6] = complex(0.000000016562, -0.000000013242)
    h2e[5, 10, 9, 6] = complex(0.000000021218, -0.000000016927)
    h2e[7, 10, 9, 6] = complex(0.000002042864, -0.000001623294)
    h2e[9, 10, 9, 6] = complex(0.000012328675, -0.000002111376)
    h2e[1, 10, 11, 6] = complex(0.000001477500, -0.000007564627)
    h2e[3, 10, 11, 6] = complex(0.000008614638, -0.000026482441)
    h2e[5, 10, 11, 6] = complex(-0.000029453852, 0.000085672404)
    h2e[7, 10, 11, 6] = complex(-0.006014049206, 0.013471185722)
    h2e[9, 10, 11, 6] = complex(0.011008244814, -0.008897171578)
    h2e[3, 0, 1, 8] = complex(-0.000000389785, -0.000000148276)
    h2e[5, 0, 1, 8] = complex(0.000019743499, 0.000007343761)
    h2e[7, 0, 1, 8] = complex(0.008243006861, 0.003600040558)
    h2e[9, 0, 1, 8] = complex(0.006931380489, 0.008531871577)
    h2e[11, 0, 1, 8] = complex(-0.000006659071, -0.000002806145)
    h2e[3, 0, 3, 8] = complex(0.000000252967, 0.000000198850)
    h2e[5, 0, 3, 8] = complex(-0.000011618473, -0.000008703332)
    h2e[7, 0, 3, 8] = complex(-0.005446713585, -0.002692206339)
    h2e[9, 0, 3, 8] = complex(0.001203731071, 0.001752227822)
    h2e[11, 0, 3, 8] = complex(0.000000414313, 0.000000828287)
    h2e[3, 0, 5, 8] = complex(0.000000129072, 0.000000096687)
    h2e[5, 0, 5, 8] = complex(-0.000005767367, -0.000004155123)
    h2e[7, 0, 5, 8] = complex(-0.002664413587, -0.001332113169)
    h2e[9, 0, 5, 8] = complex(0.000337848718, 0.000484902985)
    h2e[11, 0, 5, 8] = complex(0.000000365317, 0.000000469247)
    h2e[5, 0, 7, 8] = complex(0.000000016582, 0.000000008290)
    h2e[7, 0, 7, 8] = complex(0.000007635684, 0.000002436809)
    h2e[9, 0, 7, 8] = complex(0.000000306716, -0.000001976983)
    h2e[11, 0, 7, 8] = complex(-0.000000001392, -0.000000000528)
    h2e[3, 0, 11, 8] = complex(-0.000000014217, -0.000000028423)
    h2e[5, 0, 11, 8] = complex(0.000001155000, 0.000001483589)
    h2e[7, 0, 11, 8] = complex(0.000708372893, 0.000268804314)
    h2e[9, 0, 11, 8] = complex(-0.001157314582, -0.001750241189)
    h2e[11, 0, 11, 8] = complex(0.000000571692, 0.000000129130)
    h2e[1, 2, 1, 8] = complex(-0.000000397642, -0.000000125694)
    h2e[5, 2, 1, 8] = complex(0.000013430494, 0.000008906723)
    h2e[7, 2, 1, 8] = complex(0.005594526118, 0.002376676749)
    h2e[9, 2, 1, 8] = complex(-0.001302174034, -0.001680361157)
    h2e[11, 2, 1, 8] = complex(-0.000000278991, -0.000000485968)
    h2e[1, 2, 3, 8] = complex(0.000000263947, 0.000000184026)
    h2e[5, 2, 3, 8] = complex(0.000138452701, 0.000069517680)
    h2e[7, 2, 3, 8] = complex(0.052421165776, 0.027799758101)
    h2e[9, 2, 3, 8] = complex(-0.035426833927, -0.051175233565)
    h2e[11, 2, 3, 8] = complex(-0.000021517517, -0.000011671633)
    h2e[1, 2, 5, 8] = complex(0.000000134401, 0.000000089131)
    h2e[5, 2, 5, 8] = complex(0.000050192821, 0.000024863499)
    h2e[7, 2, 5, 8] = complex(0.018476057964, 0.009800434746)
    h2e[9, 2, 5, 8] = complex(-0.012713321220, -0.018361741380)
    h2e[11, 2, 5, 8] = complex(-0.000007128495, -0.000003832566)
    h2e[5, 2, 7, 8] = complex(-0.000000127192, -0.000000067468)
    h2e[7, 2, 7, 8] = complex(-0.000047243304, -0.000026856073)
    h2e[9, 2, 7, 8] = complex(0.000031006598, 0.000044923711)
    h2e[11, 2, 7, 8] = complex(0.000000018720, 0.000000009960)
    h2e[1, 2, 11, 8] = complex(-0.000000015823, -0.000000027561)
    h2e[5, 2, 11, 8] = complex(-0.000044665857, -0.000024014159)
    h2e[7, 2, 11, 8] = complex(-0.017489869738, -0.009305866711)
    h2e[9, 2, 11, 8] = complex(0.010783867752, 0.015611240673)
    h2e[11, 2, 11, 8] = complex(0.000006939289, 0.000003952135)
    h2e[1, 4, 1, 8] = complex(-0.000019827698, -0.000007113296)
    h2e[3, 4, 1, 8] = complex(0.000013009633, 0.000009510907)
    h2e[7, 4, 1, 8] = complex(-0.002680987283, -0.001301589514)
    h2e[9, 4, 1, 8] = complex(0.000343473836, 0.000480934907)
    h2e[11, 4, 1, 8] = complex(-0.000001080412, -0.000001354923)
    h2e[1, 4, 3, 8] = complex(0.000011719058, 0.000008567413)
    h2e[3, 4, 3, 8] = complex(0.000135132740, 0.000075769389)
    h2e[7, 4, 3, 8] = complex(-0.018009228615, -0.010634230346)
    h2e[9, 4, 3, 8] = complex(0.011861319773, 0.018923297179)
    h2e[11, 4, 3, 8] = complex(-0.000036196519, -0.000021648019)
    h2e[1, 4, 5, 8] = complex(0.000005815373, 0.000004087664)
    h2e[3, 4, 5, 8] = complex(0.000049004710, 0.000027130265)
    h2e[7, 4, 5, 8] = complex(-0.018024112655, -0.010641477712)
    h2e[9, 4, 5, 8] = complex(0.012167287340, 0.019414997755)
    h2e[11, 4, 5, 8] = complex(0.000012237276, 0.000007254706)
    h2e[1, 4, 7, 8] = complex(-0.000000016677, -0.000000008097)
    h2e[3, 4, 7, 8] = complex(-0.000000123978, -0.000000073207)
    h2e[7, 4, 7, 8] = complex(0.000042918314, 0.000027408622)
    h2e[9, 4, 7, 8] = complex(-0.000084353742, -0.000133565074)
    h2e[11, 4, 7, 8] = complex(-0.000000023340, -0.000000013856)
    h2e[1, 4, 11, 8] = complex(-0.000001172202, -0.000001470035)
    h2e[3, 4, 11, 8] = complex(-0.000043522312, -0.000026029349)
    h2e[7, 4, 11, 8] = complex(-0.001929426624, -0.001145470674)
    h2e[9, 4, 11, 8] = complex(0.001122154479, 0.001789769321)
    h2e[11, 4, 11, 8] = complex(0.000031274059, 0.000019624438)
    h2e[1, 6, 1, 8] = complex(-0.006399143029, 0.006321267484)
    h2e[3, 6, 1, 8] = complex(0.004521433011, -0.004062506427)
    h2e[5, 6, 1, 8] = complex(0.002225902655, -0.001981712760)
    h2e[9, 6, 1, 8] = complex(-0.000001722442, -0.000001017707)
    h2e[11, 6, 1, 8] = complex(-0.000512478782, 0.000558525948)
    h2e[1, 6, 3, 8] = complex(0.004519434681, -0.004060711015)
    h2e[3, 6, 3, 8] = complex(0.047376396597, -0.035725092276)
    h2e[5, 6, 3, 8] = complex(0.016700199957, -0.012590571550)
    h2e[9, 6, 3, 8] = complex(-0.000053825564, 0.000009075109)
    h2e[11, 6, 3, 8] = complex(-0.015834540607, 0.011906354919)
    h2e[1, 6, 5, 8] = complex(0.002224874527, -0.001980797461)
    h2e[3, 6, 5, 8] = complex(0.016700086726, -0.012590486191)
    h2e[5, 6, 5, 8] = complex(0.016712577216, -0.012601565293)
    h2e[9, 6, 5, 8] = complex(-0.000155643761, 0.000027022259)
    h2e[11, 6, 5, 8] = complex(0.001794768876, -0.001346456756)
    h2e[1, 6, 7, 8] = complex(-0.000005093656, 0.000006188407)
    h2e[3, 6, 7, 8] = complex(-0.000044329611, 0.000031433484)
    h2e[5, 6, 7, 8] = complex(-0.000041708380, 0.000029216864)
    h2e[9, 6, 7, 8] = complex(-0.039467386357, 0.007046977365)
    h2e[11, 6, 7, 8] = complex(-0.000002090218, 0.000001561846)
    h2e[1, 6, 11, 8] = complex(-0.000512238867, 0.000558264507)
    h2e[3, 6, 11, 8] = complex(-0.015834555454, 0.011906366048)
    h2e[5, 6, 11, 8] = complex(0.001794884574, -0.001346543549)
    h2e[9, 6, 11, 8] = complex(0.000012385993, -0.000001743936)
    h2e[11, 6, 11, 8] = complex(0.011267874744, -0.008565985934)
    h2e[1, 8, 1, 8] = complex(-0.007468648544, -0.008065739703)
    h2e[3, 8, 1, 8] = complex(-0.001314532309, -0.001670711130)
    h2e[5, 8, 1, 8] = complex(-0.000368501403, -0.000462038291)
    h2e[7, 8, 1, 8] = complex(-0.000000178217, 0.000001992680)
    h2e[11, 8, 1, 8] = complex(0.001268084505, 0.001671730528)
    h2e[1, 8, 3, 8] = complex(-0.001314532309, -0.001670711130)
    h2e[3, 8, 3, 8] = complex(-0.035803319284, -0.050912546822)
    h2e[5, 8, 3, 8] = complex(-0.012848404606, -0.018267473345)
    h2e[7, 8, 3, 8] = complex(0.000031337095, 0.000044693796)
    h2e[11, 8, 3, 8] = complex(0.010898716972, 0.015531278371)
    h2e[1, 8, 5, 8] = complex(-0.000368501403, -0.000462038291)
    h2e[3, 8, 5, 8] = complex(-0.012848404606, -0.018267473345)
    h2e[5, 8, 5, 8] = complex(-0.013180023609, -0.018742251655)
    h2e[7, 8, 5, 8] = complex(0.000091319927, 0.000128902496)
    h2e[11, 8, 5, 8] = complex(-0.001215512730, -0.001727725008)
    h2e[1, 8, 7, 8] = complex(-0.000000178217, 0.000001992680)
    h2e[3, 8, 7, 8] = complex(0.000031337095, 0.000044693796)
    h2e[5, 8, 7, 8] = complex(0.000091319927, 0.000128902496)
    h2e[7, 8, 7, 8] = complex(0.023332339812, 0.032602705329)
    h2e[11, 8, 7, 8] = complex(-0.000006900180, -0.000010432720)
    h2e[1, 8, 11, 8] = complex(0.001268084505, 0.001671730528)
    h2e[3, 8, 11, 8] = complex(0.010898716972, 0.015531278371)
    h2e[5, 8, 11, 8] = complex(-0.001215512730, -0.001727725008)
    h2e[7, 8, 11, 8] = complex(-0.000006900180, -0.000010432720)
    h2e[11, 8, 11, 8] = complex(-0.008413066919, -0.012186790898)
    h2e[1, 10, 1, 8] = complex(-0.000006894038, -0.000002165622)
    h2e[3, 10, 1, 8] = complex(0.000000296829, 0.000000475283)
    h2e[5, 10, 1, 8] = complex(-0.000001188773, -0.000001260923)
    h2e[7, 10, 1, 8] = complex(-0.000730908643, -0.000200893723)
    h2e[9, 10, 1, 8] = complex(0.001317221292, 0.001633294011)
    h2e[1, 10, 3, 8] = complex(0.000000490582, 0.000000785521)
    h2e[3, 10, 3, 8] = complex(0.000021935717, 0.000010865308)
    h2e[5, 10, 3, 8] = complex(-0.000037862960, -0.000018580122)
    h2e[7, 10, 3, 8] = complex(-0.017823056212, -0.008650585584)
    h2e[9, 10, 3, 8] = complex(0.011355614155, 0.015200416645)
    h2e[1, 10, 5, 8] = complex(0.000000407943, 0.000000432702)
    h2e[3, 10, 5, 8] = complex(0.000007265774, 0.000003565463)
    h2e[5, 10, 5, 8] = complex(0.000012795369, 0.000006217734)
    h2e[7, 10, 5, 8] = complex(0.002017425217, 0.000981904583)
    h2e[9, 10, 5, 8] = complex(-0.001266337346, -0.001690826609)
    h2e[1, 10, 7, 8] = complex(-0.000000001436, -0.000000000395)
    h2e[3, 10, 7, 8] = complex(-0.000000019077, -0.000000009259)
    h2e[5, 10, 7, 8] = complex(-0.000000024406, -0.000000011878)
    h2e[7, 10, 7, 8] = complex(-0.000002343958, -0.000001146401)
    h2e[9, 10, 7, 8] = complex(-0.000007207274, -0.000010222981)
    h2e[1, 10, 11, 8] = complex(0.000000581322, 0.000000074639)
    h2e[3, 10, 11, 8] = complex(-0.000007081135, -0.000003691970)
    h2e[5, 10, 11, 8] = complex(0.000032790001, 0.000016970599)
    h2e[7, 10, 11, 8] = complex(0.012766009221, 0.006113110890)
    h2e[9, 10, 11, 8] = complex(-0.008771637720, -0.011931300800)
    h2e[3, 0, 1, 10] = complex(-0.020275362638, 0.001965050235)
    h2e[5, 0, 1, 10] = complex(0.002979012409, -0.000287940955)
    h2e[7, 0, 1, 10] = complex(-0.000000831713, 0.000000387749)
    h2e[9, 0, 1, 10] = complex(0.000006739549, 0.000002606944)
    h2e[11, 0, 1, 10] = complex(0.019000371943, -0.001872368224)
    h2e[3, 0, 3, 10] = complex(-0.001064214871, -0.000012894305)
    h2e[5, 0, 3, 10] = complex(-0.004375251837, -0.000054145894)
    h2e[7, 0, 3, 10] = complex(0.000013483851, -0.000000369886)
    h2e[9, 0, 3, 10] = complex(-0.000000265470, -0.000000493484)
    h2e[11, 0, 3, 10] = complex(-0.003083426121, -0.000032393861)
    h2e[3, 0, 5, 10] = complex(0.001561545206, 0.000015399727)
    h2e[5, 0, 5, 10] = complex(-0.001306994181, -0.000013228091)
    h2e[7, 0, 5, 10] = complex(-0.000001489041, 0.000000821829)
    h2e[9, 0, 5, 10] = complex(0.000001104737, 0.000001335164)
    h2e[11, 0, 5, 10] = complex(-0.002464441093, -0.000020335266)
    h2e[3, 0, 7, 10] = complex(-0.000003681936, 0.000000880183)
    h2e[5, 0, 7, 10] = complex(-0.000000305145, -0.000001951214)
    h2e[7, 0, 7, 10] = complex(-0.002089937535, 0.000009612277)
    h2e[9, 0, 7, 10] = complex(0.000716386179, 0.000247742951)
    h2e[11, 0, 7, 10] = complex(0.000007573397, -0.000001431871)
    h2e[3, 0, 9, 10] = complex(-0.000000015056, -0.000000027988)
    h2e[5, 0, 9, 10] = complex(0.000001198593, 0.000001448598)
    h2e[7, 0, 9, 10] = complex(0.000716050824, 0.000247626999)
    h2e[9, 0, 9, 10] = complex(-0.001208834294, -0.001715062943)
    h2e[11, 0, 9, 10] = complex(0.000000575277, 0.000000112078)
    h2e[1, 2, 1, 10] = complex(-0.020129419425, 0.003123815959)
    h2e[5, 2, 1, 10] = complex(-0.000993651062, 0.000061495736)
    h2e[7, 2, 1, 10] = complex(0.000003865679, -0.000004388383)
    h2e[9, 2, 1, 10] = complex(0.000000484774, 0.000000789118)
    h2e[11, 2, 1, 10] = complex(0.003080214687, -0.000144372733)
    h2e[1, 2, 3, 10] = complex(-0.001063204699, 0.000048117801)
    h2e[5, 2, 3, 10] = complex(0.000052406389, 0.000002464684)
    h2e[7, 2, 3, 10] = complex(-0.000022361542, -0.000000961021)
    h2e[9, 2, 3, 10] = complex(0.000021854981, 0.000011026802)
    h2e[11, 2, 3, 10] = complex(-0.008126074201, -0.000503609992)
    h2e[1, 2, 5, 10] = complex(0.001559861204, -0.000074118855)
    h2e[5, 2, 5, 10] = complex(0.001935904125, 0.000086524698)
    h2e[7, 2, 5, 10] = complex(0.000033888551, 0.000008371587)
    h2e[9, 2, 5, 10] = complex(-0.000037724888, -0.000018858880)
    h2e[11, 2, 5, 10] = complex(0.005957067615, 0.000355709739)
    h2e[1, 2, 7, 10] = complex(-0.000003625441, 0.000001089750)
    h2e[5, 2, 7, 10] = complex(0.000042549375, -0.000001116081)
    h2e[7, 2, 7, 10] = complex(0.018897627408, -0.000470224783)
    h2e[9, 2, 7, 10] = complex(-0.017758768000, -0.008781806332)
    h2e[11, 2, 7, 10] = complex(-0.000027639370, 0.000003405420)
    h2e[1, 2, 9, 10] = complex(-0.000000016635, -0.000000027079)
    h2e[5, 2, 9, 10] = complex(-0.000045360009, -0.000022675718)
    h2e[7, 2, 9, 10] = complex(-0.017758784636, -0.008781814528)
    h2e[9, 2, 9, 10] = complex(0.011243192816, 0.015283757846)
    h2e[11, 2, 9, 10] = complex(0.000007053713, 0.000003744097)
    h2e[1, 4, 1, 10] = complex(-0.002975456451, 0.000322620263)
    h2e[3, 4, 1, 10] = complex(-0.000995422909, 0.000016043351)
    h2e[7, 4, 1, 10] = complex(-0.000000996612, 0.000001783465)
    h2e[9, 4, 1, 10] = complex(-0.000000384416, -0.000000453732)
    h2e[11, 4, 1, 10] = complex(-0.002464510772, 0.000008371348)
    h2e[1, 4, 3, 10] = complex(0.004375585710, 0.000003180309)
    h2e[3, 4, 3, 10] = complex(0.000052239105, 0.000004855941)
    h2e[7, 4, 3, 10] = complex(0.000008357323, -0.000006073188)
    h2e[9, 4, 3, 10] = complex(-0.000007066417, -0.000003945855)
    h2e[11, 4, 3, 10] = complex(-0.005934601483, -0.000627446598)
    h2e[1, 4, 5, 10] = complex(0.001307059596, -0.000001996369)
    h2e[3, 4, 5, 10] = complex(0.001929931147, 0.000174863006)
    h2e[7, 4, 5, 10] = complex(0.000012518519, 0.000005936244)
    h2e[9, 4, 5, 10] = complex(-0.000012447534, -0.000006887709)
    h2e[11, 4, 5, 10] = complex(0.016969958962, 0.001755512150)
    h2e[1, 4, 7, 10] = complex(0.000000327851, 0.000001947528)
    h2e[3, 4, 7, 10] = complex(0.000042555943, 0.000000828664)
    h2e[7, 4, 7, 10] = complex(0.002103079293, 0.000041224194)
    h2e[9, 4, 7, 10] = complex(-0.001962499932, -0.001087536267)
    h2e[11, 4, 7, 10] = complex(-0.000090429663, 0.000005455844)
    h2e[1, 4, 9, 10] = complex(-0.000001215385, -0.000001434539)
    h2e[3, 4, 9, 10] = complex(-0.000044276876, -0.000024724013)
    h2e[7, 4, 9, 10] = complex(-0.001962626440, -0.001087606368)
    h2e[9, 4, 9, 10] = complex(0.001174864812, 0.001755618856)
    h2e[11, 4, 9, 10] = complex(0.000031843637, 0.000018686048)
    h2e[1, 6, 1, 10] = complex(-0.000000051820, -0.000000916194)
    h2e[3, 6, 1, 10] = complex(-0.000002339454, -0.000005359883)
    h2e[5, 6, 1, 10] = complex(-0.000001268407, -0.000001601602)
    h2e[9, 6, 1, 10] = complex(0.000000000973, -0.000000001126)
    h2e[11, 6, 1, 10] = complex(0.000001477500, -0.000007564627)
    h2e[1, 6, 3, 10] = complex(-0.000004654757, 0.000012660344)
    h2e[3, 6, 3, 10] = complex(-0.000010336441, 0.000019852458)
    h2e[5, 6, 3, 10] = complex(0.000002425764, 0.000010042117)
    h2e[9, 6, 3, 10] = complex(0.000000016562, -0.000000013242)
    h2e[11, 6, 3, 10] = complex(0.000008614638, -0.000026482441)
    h2e[1, 6, 5, 10] = complex(-0.000000211311, -0.000001687600)
    h2e[3, 6, 5, 10] = complex(0.000021929767, -0.000027158843)
    h2e[5, 6, 5, 10] = complex(-0.000010262893, 0.000009307274)
    h2e[9, 6, 5, 10] = complex(0.000000021218, -0.000000016927)
    h2e[11, 6, 5, 10] = complex(-0.000029453852, 0.000085672404)
    h2e[1, 6, 7, 10] = complex(0.000765785669, -0.001944608854)
    h2e[3, 6, 7, 10] = complex(0.007573456544, -0.017320051648)
    h2e[5, 6, 7, 10] = complex(-0.000840389464, 0.001928312084)
    h2e[9, 6, 7, 10] = complex(0.000002042864, -0.000001623294)
    h2e[11, 6, 7, 10] = complex(-0.006014049206, 0.013471185722)
    h2e[1, 6, 9, 10] = complex(-0.000495416382, 0.000573245604)
    h2e[3, 6, 9, 10] = complex(-0.015473604261, 0.012371833716)
    h2e[5, 6, 9, 10] = complex(0.001754061203, -0.001399306776)
    h2e[9, 6, 9, 10] = complex(0.000012328675, -0.000002111376)
    h2e[11, 6, 9, 10] = complex(0.011008244814, -0.008897171578)
    h2e[1, 8, 1, 10] = complex(-0.000006894038, -0.000002165622)
    h2e[3, 8, 1, 10] = complex(0.000000490582, 0.000000785521)
    h2e[5, 8, 1, 10] = complex(0.000000407943, 0.000000432702)
    h2e[7, 8, 1, 10] = complex(-0.000000001436, -0.000000000395)
    h2e[11, 8, 1, 10] = complex(0.000000581322, 0.000000074639)
    h2e[1, 8, 3, 10] = complex(0.000000296829, 0.000000475283)
    h2e[3, 8, 3, 10] = complex(0.000021935717, 0.000010865308)
    h2e[5, 8, 3, 10] = complex(0.000007265774, 0.000003565463)
    h2e[7, 8, 3, 10] = complex(-0.000000019077, -0.000000009259)
    h2e[11, 8, 3, 10] = complex(-0.000007081135, -0.000003691970)
    h2e[1, 8, 5, 10] = complex(-0.000001188773, -0.000001260923)
    h2e[3, 8, 5, 10] = complex(-0.000037862960, -0.000018580122)
    h2e[5, 8, 5, 10] = complex(0.000012795369, 0.000006217734)
    h2e[7, 8, 5, 10] = complex(-0.000000024406, -0.000000011878)
    h2e[11, 8, 5, 10] = complex(0.000032790001, 0.000016970599)
    h2e[1, 8, 7, 10] = complex(-0.000730908643, -0.000200893723)
    h2e[3, 8, 7, 10] = complex(-0.017823056212, -0.008650585584)
    h2e[5, 8, 7, 10] = complex(0.002017425217, 0.000981904583)
    h2e[7, 8, 7, 10] = complex(-0.000002343958, -0.000001146401)
    h2e[11, 8, 7, 10] = complex(0.012766009221, 0.006113110890)
    h2e[1, 8, 9, 10] = complex(0.001317221292, 0.001633294011)
    h2e[3, 8, 9, 10] = complex(0.011355614155, 0.015200416645)
    h2e[5, 8, 9, 10] = complex(-0.001266337346, -0.001690826609)
    h2e[7, 8, 9, 10] = complex(-0.000007207274, -0.000010222981)
    h2e[11, 8, 9, 10] = complex(-0.008771637720, -0.011931300800)
    h2e[1, 10, 1, 10] = complex(0.018739102486, -0.003655945124)
    h2e[3, 10, 1, 10] = complex(-0.003072738021, 0.000258547980)
    h2e[5, 10, 1, 10] = complex(-0.002455374632, 0.000212176443)
    h2e[7, 10, 1, 10] = complex(0.000007404602, -0.000002139735)
    h2e[9, 10, 1, 10] = complex(0.000000583283, 0.000000057324)
    h2e[1, 10, 3, 10] = complex(-0.003072738021, 0.000258547980)
    h2e[3, 10, 3, 10] = complex(0.008139163714, 0.000201789445)
    h2e[5, 10, 3, 10] = complex(-0.005966163293, -0.000134460219)
    h2e[7, 10, 3, 10] = complex(0.000027494003, -0.000004428484)
    h2e[9, 10, 3, 10] = complex(-0.000007187761, -0.000003479830)
    h2e[1, 10, 5, 10] = complex(-0.002455374632, 0.000212176443)
    h2e[3, 10, 5, 10] = complex(-0.005966163293, -0.000134460219)
    h2e[5, 10, 5, 10] = complex(0.017057011657, 0.000345952903)
    h2e[7, 10, 5, 10] = complex(-0.000089668598, 0.000012916373)
    h2e[9, 10, 5, 10] = complex(0.000033280015, 0.000015988316)
    h2e[1, 10, 7, 10] = complex(0.000007404602, -0.000002139735)
    h2e[3, 10, 7, 10] = complex(0.000027494003, -0.000004428484)
    h2e[5, 10, 7, 10] = complex(-0.000089668598, 0.000012916373)
    h2e[7, 10, 7, 10] = complex(-0.014730929481, 0.000800842829)
    h2e[9, 10, 7, 10] = complex(0.012942097634, 0.005730900866)
    h2e[1, 10, 9, 10] = complex(0.000000583283, 0.000000057324)
    h2e[3, 10, 9, 10] = complex(-0.000007187761, -0.000003479830)
    h2e[5, 10, 9, 10] = complex(0.000033280015, 0.000015988316)
    h2e[7, 10, 9, 10] = complex(0.012942097634, 0.005730900866)
    h2e[9, 10, 9, 10] = complex(-0.009122454828, -0.011665264023)
    h2e[3, 0, 1, 1] = complex(0.361674738938, -0.000100528206)
    h2e[5, 0, 1, 1] = complex(0.166808506949, -0.000003131608)
    h2e[7, 0, 1, 1] = complex(-0.000440773975, 0.000005277991)
    h2e[11, 0, 1, 1] = complex(-0.129906865096, 0.000245291061)
    h2e[3, 0, 3, 1] = complex(-0.007774747708, -0.000315227654)
    h2e[5, 0, 3, 1] = complex(-0.003239588955, -0.000132190356)
    h2e[7, 0, 3, 1] = complex(0.000008621227, 0.000000211084)
    h2e[9, 0, 3, 1] = complex(-0.000000199924, -0.000000156812)
    h2e[11, 0, 3, 1] = complex(0.003161813885, 0.000123096594)
    h2e[3, 0, 5, 1] = complex(-0.002036950153, -0.000021390991)
    h2e[5, 0, 5, 1] = complex(-0.002043114900, -0.000021985684)
    h2e[7, 0, 5, 1] = complex(0.000005077390, 0.000002038282)
    h2e[9, 0, 5, 1] = complex(0.000011530583, 0.000008820227)
    h2e[11, 0, 5, 1] = complex(-0.000292079065, -0.000002597366)
    h2e[3, 0, 7, 1] = complex(0.000004641857, 0.000004856618)
    h2e[5, 0, 7, 1] = complex(0.000005014398, 0.000002458397)
    h2e[7, 0, 7, 1] = complex(0.000003936520, -0.000067070819)
    h2e[9, 0, 7, 1] = complex(0.005437753956, 0.003132343382)
    h2e[11, 0, 7, 1] = complex(-0.000002003961, 0.000001064734)
    h2e[3, 0, 9, 1] = complex(-0.000000199922, -0.000000156812)
    h2e[5, 0, 9, 1] = complex(0.000011530584, 0.000008820226)
    h2e[7, 0, 9, 1] = complex(0.005437753939, 0.003132343432)
    h2e[9, 0, 9, 1] = complex(0.000057519722, -0.000035308599)
    h2e[11, 0, 9, 1] = complex(-0.000001317954, -0.000001338573)
    h2e[3, 0, 11, 1] = complex(0.009843072539, 0.000839676727)
    h2e[5, 0, 11, 1] = complex(-0.001446138095, -0.000123742113)
    h2e[7, 0, 11, 1] = complex(0.000006440407, -0.000000021903)
    h2e[9, 0, 11, 1] = complex(-0.000001317953, -0.000001338573)
    h2e[11, 0, 11, 1] = complex(-0.009226813032, -0.000772142325)
    h2e[1, 2, 1, 1] = complex(0.361074525506, -0.020828200324)
    h2e[5, 2, 1, 1] = complex(0.007245549338, 0.000250279087)
    h2e[7, 2, 1, 1] = complex(-0.000026863469, 0.000035265985)
    h2e[11, 2, 1, 1] = complex(0.062106040555, 0.003076868577)
    h2e[1, 2, 3, 1] = complex(-0.007780034980, 0.000130866795)
    h2e[5, 2, 3, 1] = complex(-0.000072408587, -0.000005464851)
    h2e[7, 2, 3, 1] = complex(-0.000000588559, -0.000000338142)
    h2e[9, 2, 3, 1] = complex(0.000000664836, 0.000000384004)
    h2e[11, 2, 3, 1] = complex(-0.000164646934, -0.000014908584)
    h2e[1, 2, 5, 1] = complex(-0.002034828135, 0.000095383234)
    h2e[5, 2, 5, 1] = complex(0.000070780348, 0.000003211865)
    h2e[7, 2, 5, 1] = complex(0.000032466866, 0.000002191591)
    h2e[9, 2, 5, 1] = complex(-0.000025924006, -0.000014781479)
    h2e[11, 2, 5, 1] = complex(-0.000426262624, -0.000025726768)
    h2e[1, 2, 7, 1] = complex(0.000004912564, 0.000004582607)
    h2e[5, 2, 7, 1] = complex(0.000035938575, 0.000003004296)
    h2e[7, 2, 7, 1] = complex(0.013602351472, 0.000942200515)
    h2e[9, 2, 7, 1] = complex(-0.010547133827, -0.006554275733)
    h2e[11, 2, 7, 1] = complex(-0.000003334402, 0.000000493655)
    h2e[1, 2, 9, 1] = complex(-0.000000208581, -0.000000145096)
    h2e[5, 2, 9, 1] = complex(-0.000028778914, -0.000016409304)
    h2e[7, 2, 9, 1] = complex(-0.010551797261, -0.006557173730)
    h2e[9, 2, 9, 1] = complex(0.007040652589, 0.011740056210)
    h2e[11, 2, 9, 1] = complex(0.000004145766, 0.000002553254)
    h2e[1, 2, 11, 1] = complex(0.009875016842, 0.000274183116)
    h2e[5, 2, 11, 1] = complex(0.000479317986, 0.000057751518)
    h2e[7, 2, 11, 1] = complex(-0.000009262162, 0.000000814153)
    h2e[9, 2, 11, 1] = complex(0.000006851893, 0.000004219877)
    h2e[11, 2, 11, 1] = complex(-0.001481837365, -0.000201091283)
    h2e[1, 4, 1, 1] = complex(-0.166797154588, 0.001946077945)
    h2e[3, 4, 1, 1] = complex(0.007226554178, 0.000580981524)
    h2e[7, 4, 1, 1] = complex(-0.000006539033, 0.000047366508)
    h2e[11, 4, 1, 1] = complex(0.078842848894, 0.007348958871)
    h2e[1, 4, 3, 1] = complex(0.003240908911, 0.000094447413)
    h2e[3, 4, 3, 1] = complex(-0.000072083383, -0.000008766641)
    h2e[7, 4, 3, 1] = complex(0.000000378471, -0.000000035888)
    h2e[9, 4, 3, 1] = complex(-0.000000280194, -0.000000177194)
    h2e[11, 4, 3, 1] = complex(-0.000240405979, -0.000032345586)
    h2e[1, 4, 5, 1] = complex(0.002043232384, -0.000001813533)
    h2e[3, 4, 5, 1] = complex(0.000070559756, 0.000006441632)
    h2e[7, 4, 5, 1] = complex(-0.000014352200, -0.000001793119)
    h2e[9, 4, 5, 1] = complex(0.000010812215, 0.000006746446)
    h2e[11, 4, 5, 1] = complex(0.000126851383, 0.000013204054)
    h2e[1, 4, 7, 1] = complex(-0.000005042693, -0.000002399823)
    h2e[3, 4, 7, 1] = complex(0.000035763832, 0.000004642770)
    h2e[7, 4, 7, 1] = complex(-0.006001513052, -0.000691743333)
    h2e[9, 4, 7, 1] = complex(0.004369670772, 0.003001890792)
    h2e[11, 4, 7, 1] = complex(-0.000009575327, -0.000001827919)
    h2e[1, 4, 9, 1] = complex(-0.000011632537, -0.000008685323)
    h2e[3, 4, 9, 1] = complex(-0.000027999327, -0.000017706745)
    h2e[7, 4, 9, 1] = complex(0.004371689976, 0.003003277954)
    h2e[9, 4, 9, 1] = complex(-0.002879135911, -0.005338418212)
    h2e[11, 4, 9, 1] = complex(0.000008648060, 0.000005840113)
    h2e[1, 4, 11, 1] = complex(0.001447481312, 0.000106889440)
    h2e[3, 4, 11, 1] = complex(0.000476179691, 0.000079585622)
    h2e[7, 4, 11, 1] = complex(0.000003615498, -0.000000209698)
    h2e[9, 4, 11, 1] = complex(-0.000002967695, -0.000002004111)
    h2e[11, 4, 11, 1] = complex(0.001176251547, 0.000212000683)
    h2e[1, 6, 1, 1] = complex(0.000158487300, -0.000411328741)
    h2e[3, 6, 1, 1] = complex(0.000020579060, 0.000039266244)
    h2e[5, 6, 1, 1] = complex(-0.000041290004, -0.000024113909)
    h2e[11, 6, 1, 1] = complex(-0.000057977404, 0.000225392543)
    h2e[1, 6, 3, 1] = complex(-0.000003391824, 0.000007928785)
    h2e[3, 6, 3, 1] = complex(-0.000000555493, 0.000000390089)
    h2e[5, 6, 3, 1] = complex(-0.000000111205, 0.000000363541)
    h2e[11, 6, 3, 1] = complex(0.000000291910, -0.000000806098)
    h2e[1, 6, 5, 1] = complex(-0.000003775194, 0.000003960101)
    h2e[3, 6, 5, 1] = complex(0.000015728963, -0.000028486842)
    h2e[5, 6, 5, 1] = complex(0.000007132596, -0.000012582805)
    h2e[9, 6, 5, 1] = complex(-0.000000027644, 0.000000018011)
    h2e[11, 6, 5, 1] = complex(-0.000004806615, 0.000009685547)
    h2e[1, 6, 7, 1] = complex(0.000060833285, 0.000028518355)
    h2e[3, 6, 7, 1] = complex(0.006611574710, -0.011924713304)
    h2e[5, 6, 7, 1] = complex(0.002928889106, -0.005283774824)
    h2e[9, 6, 7, 1] = complex(-0.000011949674, 0.000007030551)
    h2e[11, 6, 7, 1] = complex(-0.002090420797, 0.003766635287)
    h2e[1, 6, 9, 1] = complex(-0.004924894206, 0.003889236465)
    h2e[3, 6, 9, 1] = complex(-0.010407349752, 0.006784100818)
    h2e[5, 6, 9, 1] = complex(-0.004443873747, 0.002895399427)
    h2e[9, 6, 9, 1] = complex(0.000015816588, -0.000001830465)
    h2e[11, 6, 9, 1] = complex(0.003974878948, -0.002582675083)
    h2e[1, 6, 11, 1] = complex(-0.000002367035, 0.000005989697)
    h2e[3, 6, 11, 1] = complex(-0.000003183115, 0.000008736033)
    h2e[5, 6, 11, 1] = complex(-0.000001185400, 0.000003422079)
    h2e[9, 6, 11, 1] = complex(0.000000007807, -0.000000005072)
    h2e[11, 6, 11, 1] = complex(0.000000153431, 0.000001014420)
    h2e[1, 8, 3, 1] = complex(0.000000209647, 0.000000143554)
    h2e[3, 8, 3, 1] = complex(0.000000667651, 0.000000379090)
    h2e[5, 8, 3, 1] = complex(0.000000289198, 0.000000162082)
    h2e[11, 8, 3, 1] = complex(-0.000000236188, -0.000000143069)
    h2e[1, 8, 5, 1] = complex(-0.000012076871, -0.000008056049)
    h2e[3, 8, 5, 1] = complex(-0.000026032324, -0.000014589871)
    h2e[5, 8, 5, 1] = complex(-0.000011154857, -0.000006163415)
    h2e[7, 8, 5, 1] = complex(0.000000028147, 0.000000017213)
    h2e[11, 8, 5, 1] = complex(0.000009705683, 0.000005829651)
    h2e[1, 8, 7, 1] = complex(-0.005628947125, -0.002774112016)
    h2e[3, 8, 7, 1] = complex(-0.010595188779, -0.006476305839)
    h2e[5, 8, 7, 1] = complex(-0.004522753781, -0.002765875859)
    h2e[7, 8, 7, 1] = complex(0.000011485541, 0.000007765674)
    h2e[11, 8, 7, 1] = complex(0.004038955354, 0.002477030660)
    h2e[1, 8, 9, 1] = complex(-0.000055115800, 0.000038954640)
    h2e[3, 8, 9, 1] = complex(0.007127051253, 0.011687807718)
    h2e[5, 8, 9, 1] = complex(0.003158258216, 0.005178178991)
    h2e[7, 8, 9, 1] = complex(-0.000008453377, -0.000013492793)
    h2e[11, 8, 9, 1] = complex(-0.002250165952, -0.003693531524)
    h2e[1, 8, 11, 1] = complex(0.000001401763, 0.000001250535)
    h2e[3, 8, 11, 1] = complex(0.000006882830, 0.000004169225)
    h2e[5, 8, 11, 1] = complex(0.000003069825, 0.000001843869)
    h2e[7, 8, 11, 1] = complex(-0.000000007936, -0.000000004867)
    h2e[11, 8, 11, 1] = complex(-0.000002303852, -0.000001460774)
    h2e[1, 10, 1, 1] = complex(-0.129304722944, 0.012495694857)
    h2e[3, 10, 1, 1] = complex(-0.062177435643, -0.000770643054)
    h2e[5, 10, 1, 1] = complex(0.079180536788, 0.000802877322)
    h2e[7, 10, 1, 1] = complex(-0.000226996437, 0.000051339998)
    h2e[1, 10, 3, 1] = complex(0.003159330564, -0.000175642257)
    h2e[3, 10, 3, 1] = complex(0.000165086689, 0.000008789990)
    h2e[5, 10, 3, 1] = complex(-0.000242257540, -0.000012351364)
    h2e[7, 10, 3, 1] = complex(0.000000850446, -0.000000108385)
    h2e[9, 10, 3, 1] = complex(-0.000000240337, -0.000000135984)
    h2e[1, 10, 5, 1] = complex(-0.000291022194, 0.000024960143)
    h2e[3, 10, 5, 1] = complex(0.000426923626, 0.000009894897)
    h2e[5, 10, 5, 1] = complex(0.000127508847, 0.000002667242)
    h2e[7, 10, 5, 1] = complex(-0.000010811657, 0.000000146426)
    h2e[9, 10, 5, 1] = complex(0.000009874697, 0.000005538543)
    h2e[1, 10, 7, 1] = complex(-0.000001894614, 0.000001248981)
    h2e[3, 10, 7, 1] = complex(0.000003313792, -0.000000617020)
    h2e[5, 10, 7, 1] = complex(-0.000009693703, -0.000001029704)
    h2e[7, 10, 7, 1] = complex(-0.004305560542, -0.000139817349)
    h2e[9, 10, 7, 1] = complex(0.004110807453, 0.002355865721)
    h2e[1, 10, 9, 1] = complex(-0.000001438320, -0.000001208311)
    h2e[3, 10, 9, 1] = complex(-0.000004237636, -0.000002397690)
    h2e[5, 10, 9, 1] = complex(0.000009101453, 0.000005104844)
    h2e[7, 10, 9, 1] = complex(0.004112732678, 0.002356969061)
    h2e[9, 10, 9, 1] = complex(-0.002358972810, -0.003625006096)
    h2e[1, 10, 11, 1] = complex(-0.009258508768, 0.000101478558)
    h2e[3, 10, 11, 1] = complex(0.001488277630, 0.000145977320)
    h2e[5, 10, 11, 1] = complex(0.001189755610, 0.000113989394)
    h2e[7, 10, 11, 1] = complex(-0.000000832427, 0.000000599711)
    h2e[9, 10, 11, 1] = complex(-0.000002346259, -0.000001391640)
    h2e[3, 0, 1, 3] = complex(-0.007774571271, 0.000319549618)
    h2e[5, 0, 1, 3] = complex(-0.003239584118, 0.000132312007)
    h2e[7, 0, 1, 3] = complex(0.000008550871, -0.000000410478)
    h2e[9, 0, 1, 3] = complex(0.000000218481, 0.000000130285)
    h2e[11, 0, 1, 3] = complex(0.003161326296, -0.000135035981)
    h2e[3, 0, 3, 3] = complex(0.011585758965, -0.000003220285)
    h2e[5, 0, 3, 3] = complex(0.013837409413, -0.000000259779)
    h2e[7, 0, 3, 3] = complex(-0.000035314923, 0.000000422874)
    h2e[11, 0, 3, 3] = complex(0.003374071484, -0.000006370946)
    h2e[3, 0, 5, 3] = complex(0.008201428745, -0.000003862036)
    h2e[5, 0, 5, 3] = complex(-0.012721973198, 0.000002693458)
    h2e[7, 0, 5, 3] = complex(0.000067691435, -0.000000041453)
    h2e[9, 0, 5, 3] = complex(0.000029991571, 0.000014100918)
    h2e[11, 0, 5, 3] = complex(-0.017466706228, 0.000036350800)
    h2e[3, 0, 7, 3] = complex(-0.000022979497, -0.000000011820)
    h2e[5, 0, 7, 3] = complex(0.000059092610, -0.000000540916)
    h2e[7, 0, 7, 3] = complex(0.013634344162, -0.000120740775)
    h2e[9, 0, 7, 3] = complex(0.011034362065, 0.005706239160)
    h2e[11, 0, 7, 3] = complex(0.000032039121, -0.000000158437)
    h2e[3, 0, 9, 3] = complex(-0.000000693128, -0.000000330849)
    h2e[5, 0, 9, 3] = complex(0.000027016366, 0.000012702088)
    h2e[7, 0, 9, 3] = complex(0.011029485352, 0.005703717259)
    h2e[9, 0, 9, 3] = complex(0.007934180666, 0.011155648179)
    h2e[11, 0, 9, 3] = complex(-0.000007158561, -0.000003680332)
    h2e[3, 0, 11, 3] = complex(-0.003469201616, -0.000004671258)
    h2e[5, 0, 11, 3] = complex(-0.014262821617, -0.000022901353)
    h2e[7, 0, 11, 3] = complex(0.000031880688, -0.000000545571)
    h2e[9, 0, 11, 3] = complex(-0.000004331317, -0.000002226800)
    h2e[11, 0, 11, 3] = complex(-0.010051390489, 0.000002651180)
    h2e[1, 2, 1, 3] = complex(-0.007743479294, 0.000764590630)
    h2e[5, 2, 1, 3] = complex(-0.000072608766, 0.000000455305)
    h2e[7, 2, 1, 3] = complex(0.000001035567, -0.000000359551)
    h2e[9, 2, 1, 3] = complex(-0.000000710950, -0.000000290581)
    h2e[11, 2, 1, 3] = complex(-0.000165314828, -0.000001438403)
    h2e[1, 2, 3, 3] = complex(0.011566531943, -0.000667203104)
    h2e[5, 2, 3, 3] = complex(-0.000785882375, -0.000027146309)
    h2e[7, 2, 3, 3] = complex(-0.000000068991, 0.000000090571)
    h2e[11, 2, 3, 3] = complex(0.028314356754, 0.001402754930)
    h2e[1, 2, 5, 3] = complex(0.008187727461, -0.000473885422)
    h2e[5, 2, 5, 3] = complex(0.007309993654, 0.000251093887)
    h2e[7, 2, 5, 3] = complex(-0.000020304579, 0.000014617114)
    h2e[9, 2, 5, 3] = complex(0.000035919105, 0.000032188014)
    h2e[11, 2, 5, 3] = complex(-0.000920367506, -0.000045419161)
    h2e[1, 2, 7, 3] = complex(-0.000022942405, 0.000001305171)
    h2e[5, 2, 7, 3] = complex(-0.000020221722, 0.000013714008)
    h2e[7, 2, 7, 3] = complex(-0.000000127677, 0.000124710326)
    h2e[9, 2, 7, 3] = complex(0.016643139879, 0.007920345661)
    h2e[11, 2, 7, 3] = complex(0.000000293645, -0.000002101799)
    h2e[1, 2, 9, 3] = complex(-0.000000710950, -0.000000290581)
    h2e[5, 2, 9, 3] = complex(0.000035919098, 0.000032188015)
    h2e[7, 2, 9, 3] = complex(0.016643139962, 0.007920345372)
    h2e[9, 2, 9, 3] = complex(-0.000102811609, 0.000071533883)
    h2e[11, 2, 9, 3] = complex(0.000002045103, -0.000000659204)
    h2e[1, 2, 11, 3] = complex(-0.003463767316, 0.000194158839)
    h2e[5, 2, 11, 3] = complex(0.000171073786, 0.000006187193)
    h2e[7, 2, 11, 3] = complex(-0.000006902539, -0.000000752718)
    h2e[9, 2, 11, 3] = complex(0.000002045100, -0.000000659204)
    h2e[11, 2, 11, 3] = complex(-0.026504200769, -0.001356239631)
    h2e[1, 4, 1, 3] = complex(0.003237823213, -0.000170036951)
    h2e[3, 4, 1, 3] = complex(-0.000072553775, -0.000002861808)
    h2e[7, 4, 1, 3] = complex(-0.000000359260, -0.000000072348)
    h2e[9, 4, 1, 3] = complex(0.000000301754, 0.000000137605)
    h2e[11, 4, 1, 3] = complex(-0.000242243621, -0.000012642213)
    h2e[1, 4, 3, 3] = complex(-0.013836467691, 0.000161434676)
    h2e[3, 4, 3, 3] = complex(-0.000783822081, -0.000063015669)
    h2e[7, 4, 3, 3] = complex(-0.000002286798, 0.000016564776)
    h2e[11, 4, 3, 3] = complex(0.021587498424, 0.002012175362)
    h2e[1, 4, 5, 3] = complex(0.012721078799, -0.000150875850)
    h2e[3, 4, 5, 3] = complex(0.007290894009, 0.000584739175)
    h2e[7, 4, 5, 3] = complex(-0.000005431022, 0.000014555978)
    h2e[9, 4, 5, 3] = complex(-0.000015452324, -0.000014081562)
    h2e[11, 4, 5, 3] = complex(0.033850859659, 0.003148657755)
    h2e[1, 4, 7, 3] = complex(-0.000059082301, 0.000001229175)
    h2e[3, 4, 7, 3] = complex(-0.000020827043, 0.000012776000)
    h2e[7, 4, 7, 3] = complex(-0.001262874739, -0.000135944578)
    h2e[9, 4, 7, 3] = complex(-0.006866706993, -0.003752238411)
    h2e[11, 4, 7, 3] = complex(-0.000082520473, -0.000011444828)
    h2e[1, 4, 9, 3] = complex(-0.000027162484, -0.000012386547)
    h2e[3, 4, 9, 3] = complex(0.000034411319, 0.000033795138)
    h2e[7, 4, 9, 3] = complex(-0.006866753583, -0.003752263748)
    h2e[9, 4, 9, 3] = complex(-0.000613615292, -0.001117476484)
    h2e[11, 4, 9, 3] = complex(0.000001536158, -0.000002252819)
    h2e[1, 4, 11, 3] = complex(0.014262120812, -0.000143230217)
    h2e[3, 4, 11, 3] = complex(0.000170612601, 0.000013995078)
    h2e[7, 4, 11, 3] = complex(0.000006286221, -0.000021641310)
    h2e[9, 4, 11, 3] = complex(-0.000000294788, 0.000000432309)
    h2e[11, 4, 11, 3] = complex(-0.019365590974, -0.001836807338)
    h2e[1, 6, 1, 3] = complex(-0.000002788464, 0.000008093847)
    h2e[3, 6, 1, 3] = complex(0.000000112613, -0.000001090410)
    h2e[5, 6, 1, 3] = complex(0.000000203927, -0.000000304493)
    h2e[11, 6, 1, 3] = complex(0.000000040356, -0.000000347348)
    h2e[1, 6, 3, 3] = complex(0.000012698043, -0.000032955764)
    h2e[3, 6, 3, 3] = complex(0.000000052851, 0.000000100844)
    h2e[5, 6, 3, 3] = complex(-0.000014439732, -0.000008432995)
    h2e[11, 6, 3, 3] = complex(-0.000016577211, 0.000064445445)
    h2e[1, 6, 5, 3] = complex(-0.000025053850, 0.000062884312)
    h2e[3, 6, 5, 3] = complex(0.000004647870, 0.000024583191)
    h2e[5, 6, 5, 3] = complex(-0.000011383386, -0.000010573126)
    h2e[9, 6, 5, 3] = complex(0.000000041911, -0.000000033843)
    h2e[11, 6, 5, 3] = complex(-0.000016419393, 0.000093568532)
    h2e[1, 6, 7, 3] = complex(-0.004941938397, 0.012707759984)
    h2e[3, 6, 7, 3] = complex(0.000112932074, 0.000052906332)
    h2e[5, 6, 7, 3] = complex(0.000607425631, -0.001115512292)
    h2e[9, 6, 7, 3] = complex(0.000013246489, -0.000016861623)
    h2e[11, 6, 7, 3] = complex(0.002634971877, -0.005164767102)
    h2e[1, 6, 9, 3] = complex(-0.009385861089, 0.008129424904)
    h2e[3, 6, 9, 3] = complex(0.014220865848, -0.011725738954)
    h2e[5, 6, 9, 3] = complex(0.006088036064, -0.004916055840)
    h2e[9, 6, 9, 3] = complex(0.000002671831, -0.000005109539)
    h2e[11, 6, 9, 3] = complex(0.000215718001, 0.000399892066)
    h2e[1, 6, 11, 3] = complex(-0.000011311060, 0.000029811673)
    h2e[3, 6, 11, 3] = complex(-0.000003603837, 0.000005934981)
    h2e[5, 6, 11, 3] = complex(0.000017606664, 0.000014066566)
    h2e[11, 6, 11, 3] = complex(0.000015466315, -0.000062078620)
    h2e[1, 8, 1, 3] = complex(-0.000000226450, -0.000000115882)
    h2e[3, 8, 1, 3] = complex(-0.000000713074, -0.000000285330)
    h2e[5, 8, 1, 3] = complex(-0.000000308628, -0.000000121404)
    h2e[11, 8, 1, 3] = complex(0.000000253303, 0.000000110141)
    h2e[1, 8, 5, 3] = complex(-0.000030840729, -0.000012131764)
    h2e[3, 8, 5, 3] = complex(0.000036155528, 0.000031922214)
    h2e[5, 8, 5, 3] = complex(0.000016177526, 0.000013242070)
    h2e[7, 8, 5, 3] = complex(-0.000000048575, -0.000000023287)
    h2e[11, 8, 5, 3] = complex(0.000001700771, -0.000002802928)
    h2e[1, 8, 7, 3] = complex(-0.011380299549, -0.004980671997)
    h2e[3, 8, 7, 3] = complex(0.016701104631, 0.007797376712)
    h2e[5, 8, 7, 3] = complex(0.007056076592, 0.003382712075)
    h2e[7, 8, 7, 3] = complex(-0.000020919025, -0.000004709362)
    h2e[11, 8, 7, 3] = complex(-0.000268285194, 0.000366703370)
    h2e[1, 8, 9, 3] = complex(-0.008639035954, -0.010619169778)
    h2e[3, 8, 9, 3] = complex(-0.000102281167, 0.000072290162)
    h2e[5, 8, 9, 3] = complex(0.000672027812, 0.001083354051)
    h2e[7, 8, 9, 3] = complex(-0.000005761918, -0.000000215255)
    h2e[11, 8, 9, 3] = complex(0.003199162838, 0.004861088797)
    h2e[1, 8, 11, 3] = complex(0.000004466262, 0.000001942021)
    h2e[3, 8, 11, 3] = complex(0.000002040184, -0.000000674270)
    h2e[5, 8, 11, 3] = complex(0.000000271435, -0.000000447336)
    h2e[11, 8, 11, 3] = complex(-0.000002837602, -0.000001032297)
    h2e[1, 10, 1, 3] = complex(0.003134500704, -0.000432578323)
    h2e[3, 10, 1, 3] = complex(0.000165254385, -0.000004695696)
    h2e[5, 10, 1, 3] = complex(-0.000242459267, 0.000007436490)
    h2e[7, 10, 1, 3] = complex(0.000000327449, -0.000000122705)
    h2e[9, 10, 1, 3] = complex(0.000000256465, 0.000000102562)
    h2e[1, 10, 3, 3] = complex(0.003358432044, -0.000324550728)
    h2e[3, 10, 3, 3] = complex(-0.028346906019, -0.000351338810)
    h2e[5, 10, 3, 3] = complex(0.021679958767, 0.000219831135)
    h2e[7, 10, 3, 3] = complex(-0.000064904039, 0.000014679407)
    h2e[1, 10, 5, 3] = complex(-0.017385427013, 0.001683471241)
    h2e[3, 10, 5, 3] = complex(0.000921418932, 0.000011242656)
    h2e[5, 10, 5, 3] = complex(0.033995299708, 0.000338146577)
    h2e[7, 10, 5, 3] = complex(-0.000090741584, 0.000028118171)
    h2e[9, 10, 5, 3] = complex(0.000001616704, -0.000002852252)
    h2e[1, 10, 7, 3] = complex(0.000031881378, -0.000003179336)
    h2e[3, 10, 7, 3] = complex(-0.000000215466, 0.000002111245)
    h2e[5, 10, 7, 3] = complex(-0.000083184319, -0.000004580547)
    h2e[7, 10, 7, 3] = complex(0.005798076938, -0.000014141400)
    h2e[9, 10, 7, 3] = complex(-0.000257265228, 0.000374516823)
    h2e[1, 10, 9, 3] = complex(-0.000007473746, -0.000002988806)
    h2e[3, 10, 9, 3] = complex(-0.000002019237, 0.000000734622)
    h2e[5, 10, 9, 3] = complex(0.000001344571, -0.000002372153)
    h2e[7, 10, 9, 3] = complex(-0.000257265010, 0.000374516562)
    h2e[9, 10, 9, 3] = complex(0.003342259483, 0.004763835493)
    h2e[1, 10, 11, 3] = complex(-0.010006340335, 0.000950584502)
    h2e[3, 10, 11, 3] = complex(0.026536270496, 0.000372011540)
    h2e[5, 10, 11, 3] = complex(-0.019451159621, -0.000228832583)
    h2e[7, 10, 11, 3] = complex(0.000062291109, -0.000014586972)
    h2e[9, 10, 11, 3] = complex(-0.000002867040, -0.000000947484)
    h2e[3, 0, 1, 5] = complex(-0.002036937817, 0.000022523329)
    h2e[5, 0, 1, 5] = complex(-0.002043114078, 0.000022062321)
    h2e[7, 0, 1, 5] = complex(0.000005437517, -0.000002225031)
    h2e[9, 0, 1, 5] = complex(-0.000012596667, -0.000007225196)
    h2e[11, 0, 1, 5] = complex(-0.000292055331, 0.000003699559)
    h2e[3, 0, 3, 5] = complex(0.008201433951, -0.000000697173)
    h2e[5, 0, 3, 5] = complex(-0.012722145541, -0.000002215741)
    h2e[7, 0, 3, 5] = complex(-0.000004690878, -0.000000696055)
    h2e[9, 0, 3, 5] = complex(-0.000029964717, -0.000014137422)
    h2e[11, 0, 3, 5] = complex(-0.017466676956, 0.000029610673)
    h2e[3, 0, 5, 5] = complex(0.009792730158, -0.000002721909)
    h2e[5, 0, 5, 5] = complex(-0.005047658677, 0.000000094763)
    h2e[7, 0, 5, 5] = complex(0.000012314767, -0.000000147462)
    h2e[11, 0, 5, 5] = complex(-0.012132181965, 0.000022908072)
    h2e[3, 0, 7, 5] = complex(0.000005486735, -0.000000019624)
    h2e[5, 0, 7, 5] = complex(0.000036997021, -0.000000259292)
    h2e[7, 0, 7, 5] = complex(0.006040958335, -0.000052916452)
    h2e[9, 0, 7, 5] = complex(0.004707471635, 0.002443342793)
    h2e[11, 0, 7, 5] = complex(0.000013484089, -0.000000168744)
    h2e[3, 0, 9, 5] = complex(-0.000000299862, -0.000000141475)
    h2e[5, 0, 9, 5] = complex(0.000011560582, 0.000005367773)
    h2e[7, 0, 9, 5] = complex(0.004705297339, 0.002442214260)
    h2e[9, 0, 9, 5] = complex(0.003514899394, 0.004943037015)
    h2e[11, 0, 9, 5] = complex(-0.000003190844, -0.000001626145)
    h2e[3, 0, 11, 5] = complex(0.004217747361, 0.000005505497)
    h2e[5, 0, 11, 5] = complex(-0.003530159672, -0.000005523048)
    h2e[7, 0, 11, 5] = complex(0.000017977321, 0.000000237685)
    h2e[9, 0, 11, 5] = complex(0.000009298331, 0.000004738695)
    h2e[11, 0, 11, 5] = complex(-0.006656394953, 0.000002029730)
    h2e[1, 2, 1, 5] = complex(-0.002032299059, 0.000139224669)
    h2e[5, 2, 1, 5] = complex(0.000070661163, 0.000001685433)
    h2e[7, 2, 1, 5] = complex(-0.000032775540, 0.000002635118)
    h2e[9, 2, 1, 5] = complex(0.000027677662, 0.000011167098)
    h2e[11, 2, 1, 5] = complex(-0.000426697751, -0.000016532125)
    h2e[1, 2, 3, 5] = complex(0.008187914039, -0.000470726058)
    h2e[5, 2, 3, 5] = complex(0.007309896243, 0.000253911870)
    h2e[7, 2, 3, 5] = complex(-0.000022889666, 0.000041635097)
    h2e[9, 2, 3, 5] = complex(-0.000036115022, -0.000031796614)
    h2e[11, 2, 3, 5] = complex(-0.000920393837, -0.000045775999)
    h2e[1, 2, 5, 5] = complex(0.009776478738, -0.000563945787)
    h2e[5, 2, 5, 5] = complex(0.002404481079, 0.000083056688)
    h2e[7, 2, 5, 5] = complex(-0.000007450260, 0.000009780596)
    h2e[11, 2, 5, 5] = complex(0.004953999620, 0.000245431936)
    h2e[1, 2, 7, 5] = complex(0.000005476592, -0.000000334040)
    h2e[5, 2, 7, 5] = complex(0.000002574214, 0.000005555692)
    h2e[7, 2, 7, 5] = complex(-0.001268020847, 0.000074363960)
    h2e[9, 2, 7, 5] = complex(0.007058625519, 0.003382433139)
    h2e[11, 2, 7, 5] = complex(0.000078667555, 0.000002922892)
    h2e[1, 2, 9, 5] = complex(-0.000000307477, -0.000000124058)
    h2e[5, 2, 9, 5] = complex(0.000016149527, 0.000013219142)
    h2e[7, 2, 9, 5] = complex(0.007058577692, 0.003382410102)
    h2e[9, 2, 9, 5] = complex(-0.000789590023, -0.001000912014)
    h2e[11, 2, 9, 5] = complex(0.000000263952, -0.000000425166)
    h2e[1, 2, 11, 5] = complex(0.004211130555, -0.000236225663)
    h2e[5, 2, 11, 5] = complex(0.005230210169, 0.000188956392)
    h2e[7, 2, 11, 5] = complex(-0.000004169870, 0.000019294112)
    h2e[9, 2, 11, 5] = complex(-0.000001375483, 0.000002215600)
    h2e[11, 2, 11, 5] = complex(0.016097010204, 0.000823031317)
    h2e[1, 4, 1, 5] = complex(0.002042718501, -0.000045858540)
    h2e[3, 4, 1, 5] = complex(0.000070510419, 0.000004911349)
    h2e[7, 4, 1, 5] = complex(0.000014491493, -0.000000526142)
    h2e[9, 4, 1, 5] = complex(-0.000011622320, -0.000005232755)
    h2e[11, 4, 1, 5] = complex(0.000127151364, 0.000010468560)
    h2e[1, 4, 3, 5] = complex(0.012721308310, -0.000145968991)
    h2e[3, 4, 3, 5] = complex(0.007290667980, 0.000587549767)
    h2e[7, 4, 3, 5] = complex(0.000002718948, 0.000005187928)
    h2e[9, 4, 3, 5] = complex(0.000015528846, 0.000013943025)
    h2e[11, 4, 3, 5] = complex(0.033849579882, 0.003161715036)
    h2e[1, 4, 5, 5] = complex(0.005047315153, -0.000058888707)
    h2e[3, 4, 5, 5] = complex(0.002398177415, 0.000192802370)
    h2e[7, 4, 5, 5] = complex(0.000000609215, -0.000004412940)
    h2e[11, 4, 5, 5] = complex(0.025989597277, 0.002422495941)
    h2e[1, 4, 7, 5] = complex(-0.000036991491, 0.000000690206)
    h2e[3, 4, 7, 5] = complex(0.000002317755, 0.000005667478)
    h2e[7, 4, 7, 5] = complex(0.000005193636, -0.000110195440)
    h2e[9, 4, 7, 5] = complex(-0.008087284972, -0.004429495339)
    h2e[11, 4, 7, 5] = complex(0.000054600471, 0.000006130649)
    h2e[1, 4, 9, 5] = complex(-0.000011622320, -0.000005232755)
    h2e[3, 4, 9, 5] = complex(0.000015528845, 0.000013943025)
    h2e[7, 4, 9, 5] = complex(-0.008087285007, -0.004429495234)
    h2e[9, 4, 9, 5] = complex(0.000093771446, -0.000059076592)
    h2e[11, 4, 9, 5] = complex(0.000000188575, 0.000001156547)
    h2e[1, 4, 11, 5] = complex(0.003529984526, -0.000035595802)
    h2e[3, 4, 11, 5] = complex(0.005216119719, 0.000427665765)
    h2e[7, 4, 11, 5] = complex(0.000003121163, 0.000013365602)
    h2e[9, 4, 11, 5] = complex(0.000000188579, 0.000001156547)
    h2e[11, 4, 11, 5] = complex(0.045873002125, 0.004349103000)
    h2e[1, 6, 1, 5] = complex(0.000000050897, 0.000005874926)
    h2e[3, 6, 1, 5] = complex(-0.000011486691, 0.000030809670)
    h2e[5, 6, 1, 5] = complex(-0.000005041862, 0.000013596316)
    h2e[9, 6, 1, 5] = complex(0.000000024971, -0.000000021563)
    h2e[11, 6, 1, 5] = complex(0.000003292594, -0.000009332221)
    h2e[1, 6, 3, 5] = complex(0.000002385316, -0.000004098670)
    h2e[3, 6, 3, 5] = complex(0.000028031526, 0.000038362112)
    h2e[5, 6, 3, 5] = complex(-0.000005832826, 0.000000534243)
    h2e[9, 6, 3, 5] = complex(-0.000000041665, 0.000000034167)
    h2e[11, 6, 3, 5] = complex(-0.000037283554, 0.000115750672)
    h2e[1, 6, 5, 5] = complex(-0.000004427970, 0.000011492098)
    h2e[3, 6, 5, 5] = complex(0.000005707354, 0.000010890020)
    h2e[5, 6, 5, 5] = complex(0.000003846817, 0.000002246593)
    h2e[11, 6, 5, 5] = complex(-0.000017980723, 0.000069901733)
    h2e[1, 6, 7, 5] = complex(-0.002190159571, 0.005630202375)
    h2e[3, 6, 7, 5] = complex(-0.000469387652, 0.001180288984)
    h2e[5, 6, 7, 5] = complex(0.000099880949, 0.000046838265)
    h2e[9, 6, 7, 5] = complex(0.000015064308, -0.000017930064)
    h2e[11, 6, 7, 5] = complex(-0.000347748942, 0.000696717490)
    h2e[1, 6, 9, 5] = complex(-0.004012419105, 0.003464783753)
    h2e[3, 6, 9, 5] = complex(0.006052355695, -0.004963185249)
    h2e[5, 6, 9, 5] = complex(0.007179661699, -0.005785936819)
    h2e[9, 6, 9, 5] = complex(-0.000001095374, -0.000012999145)
    h2e[11, 6, 9, 5] = complex(0.000075684314, -0.000124925058)
    h2e[1, 6, 11, 5] = complex(-0.000006884715, 0.000016608469)
    h2e[3, 6, 11, 5] = complex(0.000015715083, 0.000011945156)
    h2e[5, 6, 11, 5] = complex(-0.000013545518, -0.000002213578)
    h2e[9, 6, 11, 5] = complex(-0.000000000916, 0.000000001511)
    h2e[11, 6, 11, 5] = complex(-0.000032613704, 0.000138174804)
    h2e[1, 8, 1, 5] = complex(0.000013037569, 0.000006395411)
    h2e[3, 8, 1, 5] = complex(0.000027759274, 0.000010962655)
    h2e[5, 8, 1, 5] = complex(0.000011883528, 0.000004608883)
    h2e[7, 8, 1, 5] = complex(-0.000000030205, -0.000000013273)
    h2e[11, 8, 1, 5] = complex(-0.000010399683, -0.000004478087)
    h2e[1, 8, 3, 5] = complex(0.000030816291, 0.000012169928)
    h2e[3, 8, 3, 5] = complex(-0.000036348566, -0.000031529378)
    h2e[5, 8, 3, 5] = complex(-0.000016246587, -0.000013099669)
    h2e[7, 8, 3, 5] = complex(0.000000048763, 0.000000022926)
    h2e[11, 8, 3, 5] = complex(-0.000001634182, 0.000002676141)
    h2e[1, 8, 7, 5] = complex(-0.004855634130, -0.002133783111)
    h2e[3, 8, 7, 5] = complex(0.007083381060, 0.003330279385)
    h2e[5, 8, 7, 5] = complex(0.008310861168, 0.003994270101)
    h2e[7, 8, 7, 5] = complex(-0.000022665276, -0.000005891158)
    h2e[11, 8, 7, 5] = complex(0.000145339193, 0.000014616946)
    h2e[1, 8, 9, 5] = complex(-0.003827220328, -0.004705371103)
    h2e[3, 8, 9, 5] = complex(-0.000796950877, -0.000995061101)
    h2e[5, 8, 9, 5] = complex(-0.000090505712, 0.000063967493)
    h2e[7, 8, 9, 5] = complex(-0.000011265163, 0.000006578274)
    h2e[11, 8, 9, 5] = complex(-0.000435490798, -0.000649260492)
    h2e[1, 8, 11, 5] = complex(-0.000009585329, -0.000004127427)
    h2e[3, 8, 11, 5] = complex(-0.000001359111, 0.000002225686)
    h2e[5, 8, 11, 5] = complex(-0.000000249657, -0.000001144916)
    h2e[7, 8, 11, 5] = complex(0.000000001758, 0.000000000177)
    h2e[11, 8, 11, 5] = complex(0.000011019462, 0.000003718079)
    h2e[1, 10, 1, 5] = complex(-0.000290404705, 0.000031226764)
    h2e[3, 10, 1, 5] = complex(0.000427017336, 0.000000690441)
    h2e[5, 10, 1, 5] = complex(0.000127581555, -0.000000083691)
    h2e[7, 10, 1, 5] = complex(0.000009805976, -0.000001332050)
    h2e[9, 10, 1, 5] = complex(-0.000010528211, -0.000004166945)
    h2e[1, 10, 3, 5] = complex(-0.017386033531, 0.001676758396)
    h2e[3, 10, 3, 5] = complex(0.000921458484, 0.000011598271)
    h2e[5, 10, 3, 5] = complex(0.033995104252, 0.000351264969)
    h2e[7, 10, 3, 5] = complex(-0.000120003238, 0.000019685130)
    h2e[9, 10, 3, 5] = complex(-0.000001553893, 0.000002723537)
    h2e[1, 10, 5, 5] = complex(-0.012075947077, 0.001166990241)
    h2e[3, 10, 5, 5] = complex(-0.004959694578, -0.000061471724)
    h2e[5, 10, 5, 5] = complex(0.026100912032, 0.000264658857)
    h2e[7, 10, 5, 5] = complex(-0.000070399153, 0.000015922243)
    h2e[1, 10, 7, 5] = complex(0.000013408075, -0.000001439675)
    h2e[3, 10, 7, 5] = complex(-0.000078721836, -0.000000002348)
    h2e[5, 10, 7, 5] = complex(0.000054920454, 0.000001593771)
    h2e[7, 10, 7, 5] = complex(-0.000778632023, 0.000008761465)
    h2e[9, 10, 7, 5] = complex(0.000145709487, 0.000010289846)
    h2e[1, 10, 9, 5] = complex(-0.000003329984, -0.000001317969)
    h2e[3, 10, 9, 5] = complex(-0.000000247996, 0.000000434666)
    h2e[5, 10, 9, 5] = complex(0.000000283584, 0.000001136988)
    h2e[7, 10, 9, 5] = complex(0.000145700097, 0.000010289173)
    h2e[9, 10, 9, 5] = complex(-0.000454599557, -0.000636027251)
    h2e[1, 10, 11, 5] = complex(-0.006626535265, 0.000629784299)
    h2e[3, 10, 11, 5] = complex(-0.016116462712, -0.000225272583)
    h2e[5, 10, 11, 5] = complex(0.046075538542, 0.000540156351)
    h2e[7, 10, 11, 5] = complex(-0.000137820688, 0.000034079146)
    h2e[9, 10, 11, 5] = complex(0.000011125134, 0.000003388846)
    h2e[3, 0, 1, 7] = complex(0.000004707004, -0.000004778195)
    h2e[5, 0, 1, 7] = complex(0.000004352330, -0.000006893183)
    h2e[7, 0, 1, 7] = complex(-0.000124956230, -0.001861980081)
    h2e[9, 0, 1, 7] = complex(-0.005226267541, -0.003913745982)
    h2e[11, 0, 1, 7] = complex(0.000003331088, -0.000000179524)
    h2e[3, 0, 3, 7] = complex(-0.000021327491, 0.000000043682)
    h2e[5, 0, 3, 7] = complex(-0.000006306516, -0.000000557451)
    h2e[7, 0, 3, 7] = complex(-0.013827033448, -0.000357289311)
    h2e[9, 0, 3, 7] = complex(-0.011615933496, -0.004943131714)
    h2e[11, 0, 3, 7] = complex(0.000047857373, -0.000000212788)
    h2e[3, 0, 5, 7] = complex(0.000006220857, 0.000000021497)
    h2e[5, 0, 5, 7] = complex(0.000008045948, -0.000000087836)
    h2e[7, 0, 5, 7] = complex(-0.006127789029, -0.000100288224)
    h2e[9, 0, 5, 7] = complex(-0.004991363783, -0.002051632959)
    h2e[11, 0, 5, 7] = complex(0.000020476557, -0.000000031509)
    h2e[3, 0, 7, 7] = complex(0.010353622182, -0.000002877810)
    h2e[5, 0, 7, 7] = complex(0.004664046459, -0.000000087561)
    h2e[7, 0, 7, 7] = complex(-0.000012054307, 0.000000144343)
    h2e[11, 0, 7, 7] = complex(-0.003309159175, 0.000006248378)
    h2e[5, 0, 9, 7] = complex(-0.000000031049, -0.000000012762)
    h2e[7, 0, 9, 7] = complex(-0.000012549312, -0.000005804047)
    h2e[9, 0, 9, 7] = complex(-0.000009070564, -0.000013085867)
    h2e[11, 0, 9, 7] = complex(0.000000008432, 0.000000004191)
    h2e[3, 0, 11, 7] = complex(-0.000010338629, 0.000000268239)
    h2e[5, 0, 11, 7] = complex(0.000022690932, 0.000000091326)
    h2e[7, 0, 11, 7] = complex(0.004359277456, 0.000348061652)
    h2e[9, 0, 11, 7] = complex(0.004293286009, 0.002133902435)
    h2e[11, 0, 11, 7] = complex(0.000016712735, -0.000000624450)
    h2e[1, 2, 1, 7] = complex(0.000004425426, -0.000005040103)
    h2e[5, 2, 1, 7] = complex(-0.000036277149, 0.000002571230)
    h2e[7, 2, 1, 7] = complex(-0.013792939614, 0.001157363937)
    h2e[9, 2, 1, 7] = complex(0.011874885335, 0.004267402857)
    h2e[11, 2, 1, 7] = complex(0.000005223104, -0.000001357914)
    h2e[1, 2, 3, 7] = complex(-0.000021289933, 0.000001265904)
    h2e[5, 2, 3, 7] = complex(-0.000017904297, 0.000012677543)
    h2e[7, 2, 3, 7] = complex(-0.000103013796, 0.010576649266)
    h2e[9, 2, 3, 7] = complex(-0.011964654454, -0.017194072263)
    h2e[11, 2, 3, 7] = complex(-0.000017045032, -0.000002730745)
    h2e[1, 2, 5, 7] = complex(0.000006211865, -0.000000335060)
    h2e[5, 2, 5, 7] = complex(0.000010199173, 0.000005268303)
    h2e[7, 2, 5, 7] = complex(0.001249104027, 0.003839683970)
    h2e[9, 2, 5, 7] = complex(-0.005393015116, -0.006722302041)
    h2e[11, 2, 5, 7] = complex(0.000072067570, 0.000003229644)
    h2e[1, 2, 7, 7] = complex(0.010336439939, -0.000596246554)
    h2e[5, 2, 7, 7] = complex(0.003852445386, 0.000133072935)
    h2e[7, 2, 7, 7] = complex(-0.000014230234, 0.000018681252)
    h2e[11, 2, 7, 7] = complex(0.032020567492, 0.001586368686)
    h2e[5, 2, 9, 7] = complex(-0.000000037126, -0.000000046277)
    h2e[7, 2, 9, 7] = complex(-0.000016460113, -0.000013235982)
    h2e[9, 2, 9, 7] = complex(-0.000001760653, 0.000005490551)
    h2e[11, 2, 9, 7] = complex(-0.000000001441, 0.000000002828)
    h2e[1, 2, 11, 7] = complex(-0.000010306263, 0.000000860313)
    h2e[5, 2, 11, 7] = complex(-0.000001453359, -0.000003319709)
    h2e[7, 2, 11, 7] = complex(0.005910402056, -0.002933167949)
    h2e[9, 2, 11, 7] = complex(-0.001346132405, 0.002641742819)
    h2e[11, 2, 11, 7] = complex(-0.000049888300, -0.000000396800)
    h2e[1, 4, 1, 7] = complex(-0.000004271744, 0.000006943410)
    h2e[3, 4, 1, 7] = complex(-0.000036356732, 0.000000911471)
    h2e[7, 4, 1, 7] = complex(0.006127497518, -0.000171901653)
    h2e[9, 4, 1, 7] = complex(-0.005012605822, -0.001992434846)
    h2e[11, 4, 1, 7] = complex(0.000009171423, -0.000000225361)
    h2e[1, 4, 3, 7] = complex(0.000006312581, 0.000000483958)
    h2e[3, 4, 3, 7] = complex(-0.000018464699, 0.000011846476)
    h2e[7, 4, 3, 7] = complex(0.001492460225, -0.003686529230)
    h2e[9, 4, 3, 7] = complex(0.005080288795, 0.006961581385)
    h2e[11, 4, 3, 7] = complex(-0.000107753446, -0.000013311982)
    h2e[1, 4, 5, 7] = complex(-0.000008044379, 0.000000181548)
    h2e[3, 4, 5, 7] = complex(0.000009947879, 0.000005728684)
    h2e[7, 4, 5, 7] = complex(0.000215752538, -0.003887578652)
    h2e[9, 4, 5, 7] = complex(0.006280597769, 0.007712870149)
    h2e[11, 4, 5, 7] = complex(0.000064605022, 0.000007350123)
    h2e[1, 4, 7, 7] = complex(-0.004663729042, 0.000054413280)
    h2e[3, 4, 7, 7] = complex(0.003842345694, 0.000308906818)
    h2e[7, 4, 7, 7] = complex(-0.000004354999, 0.000031546113)
    h2e[11, 4, 7, 7] = complex(0.041021844538, 0.003823654936)
    h2e[1, 4, 9, 7] = complex(0.000000031196, 0.000000012400)
    h2e[3, 4, 9, 7] = complex(-0.000000034974, -0.000000047925)
    h2e[7, 4, 9, 7] = complex(0.000017728855, 0.000014877102)
    h2e[9, 4, 9, 7] = complex(0.000010393618, -0.000007883547)
    h2e[11, 4, 9, 7] = complex(0.000000000686, -0.000000004370)
    h2e[1, 4, 11, 7] = complex(-0.000022690457, 0.000000172979)
    h2e[3, 4, 11, 7] = complex(-0.000001300203, -0.000003382631)
    h2e[7, 4, 11, 7] = complex(0.000806424530, -0.000284976021)
    h2e[9, 4, 11, 7] = complex(-0.000056743241, 0.000361195036)
    h2e[11, 4, 11, 7] = complex(-0.000135253881, -0.000005706953)
    h2e[1, 6, 1, 7] = complex(0.001775648169, 0.000574158188)
    h2e[3, 6, 1, 7] = complex(-0.004790073882, 0.012986141329)
    h2e[5, 6, 1, 7] = complex(-0.002178616036, 0.005729695294)
    h2e[9, 6, 1, 7] = complex(0.000010042423, -0.000009503784)
    h2e[11, 6, 1, 7] = complex(0.001285546263, -0.004204425891)
    h2e[1, 6, 3, 7] = complex(0.005457340009, -0.012709522012)
    h2e[3, 6, 3, 7] = complex(0.009538699105, 0.004570485372)
    h2e[5, 6, 3, 7] = complex(0.002838399257, 0.002785933302)
    h2e[9, 6, 3, 7] = complex(-0.000018959288, 0.000009309784)
    h2e[11, 6, 3, 7] = complex(-0.005657263552, 0.003803545893)
    h2e[1, 6, 5, 7] = complex(0.002364636634, -0.005654056042)
    h2e[3, 6, 5, 7] = complex(0.004007456186, 0.000493688341)
    h2e[5, 6, 5, 7] = complex(0.003511283228, 0.001682470322)
    h2e[9, 6, 5, 7] = complex(-0.000020515256, 0.000010712832)
    h2e[11, 6, 5, 7] = complex(0.000691393442, -0.000543965443)
    h2e[1, 6, 7, 7] = complex(0.000004334317, -0.000011249037)
    h2e[3, 6, 7, 7] = complex(0.000010901230, 0.000020800286)
    h2e[5, 6, 7, 7] = complex(-0.000027499158, -0.000016059873)
    h2e[11, 6, 7, 7] = complex(-0.000033242168, 0.000129232017)
    h2e[1, 6, 9, 7] = complex(0.000010042423, -0.000009503785)
    h2e[3, 6, 9, 7] = complex(-0.000018959287, 0.000009309779)
    h2e[5, 6, 9, 7] = complex(-0.000020515255, 0.000010712828)
    h2e[9, 6, 9, 7] = complex(-0.001162296797, -0.006738955221)
    h2e[11, 6, 9, 7] = complex(-0.000000239882, -0.000000025330)
    h2e[1, 6, 11, 7] = complex(-0.001939193469, 0.003919690748)
    h2e[3, 6, 11, 7] = complex(-0.000155504580, -0.006596373603)
    h2e[5, 6, 11, 7] = complex(-0.000044209565, 0.000854153010)
    h2e[9, 6, 11, 7] = complex(-0.000000239881, -0.000000025331)
    h2e[11, 6, 11, 7] = complex(0.002259914109, 0.001106610448)
    h2e[1, 8, 1, 7] = complex(0.005468438820, 0.003567556159)
    h2e[3, 8, 1, 7] = complex(0.011906037070, 0.004179702178)
    h2e[5, 8, 1, 7] = complex(0.005111237191, 0.001723736684)
    h2e[7, 8, 1, 7] = complex(-0.000012898403, -0.000004980300)
    h2e[11, 8, 1, 7] = complex(-0.004420233135, -0.001850910164)
    h2e[1, 8, 3, 7] = complex(0.011911301305, 0.004181550329)
    h2e[3, 8, 3, 7] = complex(-0.012091145919, -0.017105357789)
    h2e[5, 8, 3, 7] = complex(-0.005442412652, -0.006682297051)
    h2e[7, 8, 3, 7] = complex(0.000016557290, 0.000013114219)
    h2e[11, 8, 3, 7] = complex(-0.001326612524, 0.002651601943)
    h2e[1, 8, 5, 7] = complex(0.005113599050, 0.001724533253)
    h2e[3, 8, 5, 7] = complex(-0.005442449556, -0.006682342349)
    h2e[5, 8, 5, 7] = complex(-0.006680883769, -0.007368857852)
    h2e[7, 8, 5, 7] = complex(0.000018493049, 0.000013915731)
    h2e[11, 8, 5, 7] = complex(0.000037506222, -0.000363719896)
    h2e[1, 8, 9, 7] = complex(0.000009897872, 0.000012471855)
    h2e[3, 8, 9, 7] = complex(-0.000001720108, 0.000005503388)
    h2e[5, 8, 9, 7] = complex(-0.000009960803, 0.000008423777)
    h2e[7, 8, 9, 7] = complex(-0.005584438856, 0.003946960094)
    h2e[11, 8, 9, 7] = complex(-0.000001731893, -0.000004569437)
    h2e[1, 8, 11, 7] = complex(-0.004422303264, -0.001851777034)
    h2e[3, 8, 11, 7] = complex(-0.001326611305, 0.002651599495)
    h2e[5, 8, 11, 7] = complex(0.000037503807, -0.000363696456)
    h2e[7, 8, 11, 7] = complex(0.000000080274, 0.000000227466)
    h2e[11, 8, 11, 7] = complex(0.004738130539, 0.000312554798)
    h2e[1, 10, 1, 7] = complex(0.000003299310, -0.000000492878)
    h2e[3, 10, 1, 7] = complex(-0.000005169130, 0.000001550754)
    h2e[5, 10, 1, 7] = complex(0.000009121361, -0.000000983136)
    h2e[7, 10, 1, 7] = complex(0.004327518103, -0.000776152899)
    h2e[9, 10, 1, 7] = complex(-0.004473303397, -0.001718687321)
    h2e[1, 10, 3, 7] = complex(0.000047624000, -0.000004725261)
    h2e[3, 10, 3, 7] = complex(0.000017134607, 0.000002096503)
    h2e[5, 10, 3, 7] = complex(-0.000108485271, -0.000004354343)
    h2e[7, 10, 3, 7] = complex(-0.005967111690, -0.003296235829)
    h2e[9, 10, 3, 7] = complex(-0.001247199341, 0.002689867624)
    h2e[1, 10, 5, 7] = complex(0.000020382319, -0.000001962509)
    h2e[3, 10, 5, 7] = complex(-0.000072137776, -0.000000553745)
    h2e[5, 10, 5, 7] = complex(0.000064991587, 0.000001981614)
    h2e[7, 10, 5, 7] = complex(0.000799651859, 0.000366715428)
    h2e[9, 10, 5, 7] = complex(0.000026676975, -0.000364674133)
    h2e[1, 10, 7, 7] = complex(-0.003293820615, 0.000318306837)
    h2e[3, 10, 7, 7] = complex(-0.032057377297, -0.000397327341)
    h2e[5, 10, 7, 7] = complex(0.041197543165, 0.000417736157)
    h2e[7, 10, 7, 7] = complex(-0.000130151633, 0.000029436517)
    h2e[1, 10, 9, 7] = complex(0.000000008790, 0.000000003377)
    h2e[3, 10, 9, 7] = complex(0.000000001335, -0.000000002879)
    h2e[5, 10, 9, 7] = complex(0.000000000323, -0.000000004411)
    h2e[7, 10, 9, 7] = complex(-0.000000087000, -0.000000224979)
    h2e[9, 10, 9, 7] = complex(-0.000001866967, -0.000004515932)
    h2e[1, 10, 11, 7] = complex(0.000016579353, -0.000002197843)
    h2e[3, 10, 11, 7] = complex(0.000049868677, -0.000001454308)
    h2e[5, 10, 11, 7] = complex(-0.000135262489, 0.000005499123)
    h2e[7, 10, 11, 7] = complex(0.000047429998, 0.002515859486)
    h2e[9, 10, 11, 7] = complex(0.004745328056, 0.000171561370)
    h2e[3, 0, 1, 9] = complex(0.000000201571, -0.000000153816)
    h2e[5, 0, 1, 9] = complex(-0.000011641200, 0.000008616056)
    h2e[7, 0, 1, 9] = complex(-0.004704328564, 0.004475068877)
    h2e[9, 0, 1, 9] = complex(0.000107937913, 0.001608557724)
    h2e[11, 0, 1, 9] = complex(0.000001280746, -0.000001412034)
    h2e[3, 0, 3, 9] = complex(0.000000691575, -0.000000332872)
    h2e[5, 0, 3, 9] = complex(-0.000026924503, 0.000012828490)
    h2e[7, 0, 3, 9] = complex(-0.011573800892, 0.004976996824)
    h2e[9, 0, 3, 9] = complex(-0.013839910817, 0.000315596827)
    h2e[11, 0, 3, 9] = complex(0.000007202178, -0.000003611959)
    h2e[3, 0, 5, 9] = complex(0.000000299110, -0.000000142514)
    h2e[5, 0, 5, 9] = complex(-0.000011516918, 0.000005430769)
    h2e[7, 0, 5, 9] = complex(-0.004965751954, 0.002075325512)
    h2e[9, 0, 5, 9] = complex(-0.006130696868, 0.000086788307)
    h2e[11, 0, 5, 9] = complex(0.000003211368, -0.000001593140)
    h2e[5, 0, 7, 9] = complex(0.000000030904, -0.000000012916)
    h2e[7, 0, 7, 9] = complex(0.000013426726, -0.000004917611)
    h2e[9, 0, 7, 9] = complex(0.000016241181, -0.000000402847)
    h2e[11, 0, 7, 9] = complex(-0.000000008496, 0.000000004108)
    h2e[3, 0, 9, 9] = complex(0.010349680252, -0.000002876714)
    h2e[5, 0, 9, 9] = complex(0.004662271901, -0.000000087528)
    h2e[7, 0, 9, 9] = complex(-0.000012049618, 0.000000144286)
    h2e[11, 0, 9, 9] = complex(-0.003307705496, 0.000006245633)
    h2e[3, 0, 11, 9] = complex(-0.000000247146, 0.000000123946)
    h2e[5, 0, 11, 9] = complex(0.000010153192, -0.000005036935)
    h2e[7, 0, 11, 9] = complex(0.004323603623, -0.002090710751)
    h2e[9, 0, 11, 9] = complex(0.004381109045, -0.000315838564)
    h2e[11, 0, 11, 9] = complex(-0.000002418476, 0.000001278847)
    h2e[1, 2, 1, 9] = complex(0.000000192424, -0.000000165115)
    h2e[5, 2, 1, 9] = complex(0.000029024289, -0.000015930827)
    h2e[7, 2, 1, 9] = complex(0.011274525695, -0.005634609625)
    h2e[9, 2, 1, 9] = complex(-0.013826510250, 0.000485299334)
    h2e[11, 2, 1, 9] = complex(-0.000004225296, 0.000002431582)
    h2e[1, 2, 3, 9] = complex(0.000000671361, -0.000000371960)
    h2e[5, 2, 3, 9] = complex(-0.000036996372, 0.000030524413)
    h2e[7, 2, 3, 9] = complex(-0.012396695801, 0.016736846291)
    h2e[9, 2, 3, 9] = complex(0.000088951435, -0.009127875534)
    h2e[11, 2, 3, 9] = complex(-0.000002220880, -0.000001103700)
    h2e[1, 2, 5, 9] = complex(0.000000290451, -0.000000159422)
    h2e[5, 2, 5, 9] = complex(-0.000016567803, 0.000012555134)
    h2e[7, 2, 5, 9] = complex(-0.005581226097, 0.006482755426)
    h2e[9, 2, 5, 9] = complex(0.001317462529, -0.003230859055)
    h2e[11, 2, 5, 9] = complex(-0.000000315857, -0.000000560676)
    h2e[5, 2, 7, 9] = complex(0.000000038422, -0.000000044628)
    h2e[7, 2, 7, 9] = complex(0.000012892721, -0.000021476450)
    h2e[9, 2, 7, 9] = complex(-0.000004133441, 0.000013314260)
    h2e[11, 2, 7, 9] = complex(0.000000001531, 0.000000003206)
    h2e[1, 2, 9, 9] = complex(0.010332504552, -0.000596019546)
    h2e[5, 2, 9, 9] = complex(0.003852426818, 0.000133072293)
    h2e[7, 2, 9, 9] = complex(-0.000014230142, 0.000018681133)
    h2e[11, 2, 9, 9] = complex(0.032020110590, 0.001586346050)
    h2e[1, 2, 11, 9] = complex(-0.000000239637, 0.000000137907)
    h2e[5, 2, 11, 9] = complex(-0.000001979104, -0.000003513096)
    h2e[7, 2, 11, 9] = complex(-0.001430755014, -0.002995774585)
    h2e[9, 2, 11, 9] = complex(0.005845830983, 0.003073629802)
    h2e[11, 2, 11, 9] = complex(0.000003013813, -0.000000669316)
    h2e[1, 4, 1, 9] = complex(0.000011540053, -0.000008751065)
    h2e[3, 4, 1, 9] = complex(0.000029721685, -0.000014588421)
    h2e[7, 4, 1, 9] = complex(-0.004943525507, 0.002134010307)
    h2e[9, 4, 1, 9] = complex(0.006130122693, 0.000015156928)
    h2e[11, 4, 1, 9] = complex(-0.000009303430, 0.000004751201)
    h2e[1, 4, 3, 9] = complex(0.000026773254, -0.000013141229)
    h2e[3, 4, 3, 9] = complex(-0.000038352059, 0.000028802627)
    h2e[7, 4, 3, 9] = complex(0.005871560878, -0.006221090562)
    h2e[9, 4, 3, 9] = complex(0.001101193622, 0.003373510327)
    h2e[11, 4, 3, 9] = complex(-0.000001510796, -0.000002993899)
    h2e[1, 4, 5, 9] = complex(0.000011452880, -0.000005564546)
    h2e[3, 4, 5, 9] = complex(-0.000017124007, 0.000011785243)
    h2e[7, 4, 5, 9] = complex(0.007167226157, -0.006777906331)
    h2e[9, 4, 5, 9] = complex(-0.000186213760, 0.003355197518)
    h2e[11, 4, 5, 9] = complex(-0.000000240193, 0.000001319695)
    h2e[1, 4, 7, 9] = complex(-0.000000030752, 0.000000013275)
    h2e[3, 4, 7, 9] = complex(0.000000040421, -0.000000042827)
    h2e[7, 4, 7, 9] = complex(-0.000016176136, 0.000020929706)
    h2e[9, 4, 7, 9] = complex(0.000000644258, -0.000019087393)
    h2e[11, 4, 7, 9] = complex(-0.000000000324, -0.000000004795)
    h2e[1, 4, 9, 9] = complex(-0.004661954605, 0.000054392577)
    h2e[3, 4, 9, 9] = complex(0.003842327175, 0.000308905329)
    h2e[7, 4, 9, 9] = complex(-0.000004355047, 0.000031546465)
    h2e[11, 4, 9, 9] = complex(0.041020701069, 0.003823548353)
    h2e[1, 4, 11, 9] = complex(-0.000010093835, 0.000005154855)
    h2e[3, 4, 11, 9] = complex(-0.000001816566, -0.000003599832)
    h2e[7, 4, 11, 9] = complex(-0.000026775328, -0.000396384791)
    h2e[9, 4, 11, 9] = complex(0.000769918720, 0.000382700648)
    h2e[11, 4, 11, 9] = complex(0.000011880925, -0.000001558058)
    h2e[1, 6, 1, 9] = complex(-0.002412420434, -0.006028032550)
    h2e[3, 6, 1, 9] = complex(-0.000332311120, -0.012599735093)
    h2e[5, 6, 1, 9] = complex(-0.000086773926, -0.005383763988)
    h2e[9, 6, 1, 9] = complex(-0.000005886537, 0.000014698076)
    h2e[11, 6, 1, 9] = complex(0.000339217985, 0.004792823782)
    h2e[1, 6, 3, 9] = complex(-0.000332164156, -0.012594166571)
    h2e[3, 6, 3, 9] = complex(0.009915770793, 0.018316046988)
    h2e[5, 6, 3, 9] = complex(0.003510750174, 0.007800758153)
    h2e[9, 6, 3, 9] = complex(-0.000004116508, 0.000002442165)
    h2e[11, 6, 3, 9] = complex(-0.003319776186, 0.000028116697)
    h2e[1, 6, 5, 9] = complex(-0.000086733804, -0.005381277333)
    h2e[3, 6, 5, 9] = complex(0.003510726381, 0.007800705264)
    h2e[5, 6, 5, 9] = complex(0.003531187468, 0.009210855537)
    h2e[9, 6, 5, 9] = complex(-0.000024458298, -0.000012000200)
    h2e[11, 6, 5, 9] = complex(0.000376598989, 0.000126454235)
    h2e[1, 6, 7, 9] = complex(-0.000000409846, 0.000014293071)
    h2e[3, 6, 7, 9] = complex(-0.000013999820, -0.000020771741)
    h2e[5, 6, 7, 9] = complex(-0.000013176069, -0.000022937116)
    h2e[9, 6, 7, 9] = complex(-0.005323370353, -0.002496850502)
    h2e[11, 6, 7, 9] = complex(-0.000000668331, -0.000000159682)
    h2e[1, 6, 9, 9] = complex(0.000004332632, -0.000011244662)
    h2e[3, 6, 9, 9] = complex(0.000010901161, 0.000020800153)
    h2e[5, 6, 9, 9] = complex(-0.000027499465, -0.000016060052)
    h2e[11, 6, 9, 9] = complex(-0.000033241521, 0.000129229497)
    h2e[1, 6, 11, 9] = complex(0.000339059162, 0.004790580198)
    h2e[3, 6, 11, 9] = complex(-0.003319779253, 0.000028116721)
    h2e[5, 6, 11, 9] = complex(0.000376623260, 0.000126462387)
    h2e[9, 6, 11, 9] = complex(-0.000000058948, 0.000007409584)
    h2e[11, 6, 11, 9] = complex(0.002416092867, -0.004413335482)
    h2e[1, 8, 1, 9] = complex(-0.000211741633, -0.001598209630)
    h2e[3, 8, 1, 9] = complex(-0.013822554785, 0.000587265189)
    h2e[5, 8, 1, 9] = complex(-0.006122296272, 0.000310036035)
    h2e[7, 8, 1, 9] = complex(0.000015801085, -0.000001005224)
    h2e[11, 8, 1, 9] = complex(0.004372240746, 0.000016600094)
    h2e[1, 8, 3, 9] = complex(0.013790526941, -0.001209999725)
    h2e[3, 8, 3, 9] = complex(0.000021625332, -0.009128283254)
    h2e[5, 8, 3, 9] = complex(-0.001278590720, -0.003310348162)
    h2e[7, 8, 3, 9] = complex(0.000003974884, 0.000002666477)
    h2e[11, 8, 3, 9] = complex(-0.005887133968, 0.002534924944)
    h2e[1, 8, 5, 9] = complex(0.006112249628, -0.000483094979)
    h2e[3, 8, 5, 9] = complex(0.001293597126, -0.003240488249)
    h2e[5, 8, 5, 9] = complex(0.000007975560, -0.003360351505)
    h2e[7, 8, 5, 9] = complex(-0.000000317772, 0.000027241737)
    h2e[11, 8, 5, 9] = complex(0.000790477848, -0.000278306059)
    h2e[1, 8, 7, 9] = complex(-0.000016181127, 0.000001452364)
    h2e[3, 8, 7, 9] = complex(-0.000004035128, 0.000013344384)
    h2e[5, 8, 7, 9] = complex(0.000000369138, 0.000019094695)
    h2e[7, 8, 7, 9] = complex(0.000034667006, 0.005879739156)
    h2e[11, 8, 7, 9] = complex(-0.000006601612, -0.000000534422)
    h2e[1, 8, 11, 9] = complex(-0.004351511223, 0.000598515261)
    h2e[3, 8, 11, 9] = complex(0.005868341883, 0.003030429562)
    h2e[5, 8, 11, 9] = complex(-0.000789135083, -0.000341321607)
    h2e[7, 8, 11, 9] = complex(0.000006715016, -0.000003132726)
    h2e[11, 8, 11, 9] = complex(0.000023988225, -0.002171715263)
    h2e[1, 10, 1, 9] = complex(0.000001141869, -0.000001526527)
    h2e[3, 10, 1, 9] = complex(0.000004132177, -0.000002586664)
    h2e[5, 10, 1, 9] = complex(-0.000008878595, 0.000005504387)
    h2e[7, 10, 1, 9] = complex(-0.004109081759, 0.002490316396)
    h2e[9, 10, 1, 9] = complex(0.004370801811, -0.000113385300)
    h2e[1, 10, 3, 9] = complex(0.000006829434, -0.000004275096)
    h2e[3, 10, 3, 9] = complex(0.000002260297, 0.000001020548)
    h2e[5, 10, 3, 9] = complex(-0.000001753239, -0.000002858685)
    h2e[7, 10, 3, 9] = complex(-0.001540910548, -0.002940629068)
    h2e[9, 10, 3, 9] = complex(-0.005809173692, 0.002708817473)
    h2e[1, 10, 5, 9] = complex(0.000003046806, -0.000001888902)
    h2e[3, 10, 5, 9] = complex(0.000000336441, 0.000000548573)
    h2e[5, 10, 5, 9] = complex(-0.000000130221, 0.000001335039)
    h2e[7, 10, 5, 9] = complex(0.000059463794, 0.000392786877)
    h2e[9, 10, 5, 9] = complex(0.000781854987, -0.000301682404)
    h2e[1, 10, 7, 9] = complex(-0.000000008070, 0.000000004891)
    h2e[3, 10, 7, 9] = complex(-0.000000001649, -0.000000003147)
    h2e[5, 10, 7, 9] = complex(-0.000000000719, -0.000000004752)
    h2e[7, 10, 7, 9] = complex(-0.000000163115, -0.000000667502)
    h2e[9, 10, 7, 9] = complex(-0.000006614582, -0.000000337933)
    h2e[1, 10, 9, 9] = complex(-0.003292373674, 0.000318167008)
    h2e[3, 10, 9, 9] = complex(-0.032056919869, -0.000397321671)
    h2e[5, 10, 9, 9] = complex(0.041196394799, 0.000417724513)
    h2e[7, 10, 9, 9] = complex(-0.000130149095, 0.000029435943)
    h2e[1, 10, 11, 9] = complex(-0.000002287089, 0.000001501233)
    h2e[3, 10, 11, 9] = complex(-0.000002986907, 0.000000780666)
    h2e[5, 10, 11, 9] = complex(0.000011711356, -0.000002535364)
    h2e[7, 10, 11, 9] = complex(0.005029613384, 0.000134254212)
    h2e[9, 10, 11, 9] = complex(-0.000040583178, -0.002171468589)
    h2e[3, 0, 1, 11] = complex(0.009842604419, -0.000845148421)
    h2e[5, 0, 1, 11] = complex(-0.001446145259, 0.000123797672)
    h2e[7, 0, 1, 11] = complex(0.000001194301, 0.000000486383)
    h2e[9, 0, 1, 11] = complex(0.000001424606, 0.000001310614)
    h2e[11, 0, 1, 11] = complex(-0.009223831330, 0.000806980829)
    h2e[3, 0, 3, 11] = complex(-0.003469199036, 0.000006599800)
    h2e[5, 0, 3, 11] = complex(-0.014262800313, 0.000023436919)
    h2e[7, 0, 3, 11] = complex(0.000040382387, -0.000000304158)
    h2e[9, 0, 3, 11] = complex(0.000004362139, 0.000002183991)
    h2e[11, 0, 3, 11] = complex(-0.010051334245, 0.000035306942)
    h2e[3, 0, 5, 11] = complex(0.004217744734, -0.000007850158)
    h2e[5, 0, 5, 11] = complex(-0.003530204409, 0.000005655525)
    h2e[7, 0, 5, 11] = complex(-0.000000933586, -0.000000474682)
    h2e[9, 0, 5, 11] = complex(-0.000009374066, -0.000004632225)
    h2e[11, 0, 5, 11] = complex(-0.006656342904, 0.000023107437)
    h2e[3, 0, 7, 11] = complex(-0.000009825735, -0.000000282648)
    h2e[5, 0, 7, 11] = complex(0.000002036969, 0.000000819175)
    h2e[7, 0, 7, 11] = complex(-0.004307676661, 0.000039927857)
    h2e[9, 0, 7, 11] = complex(-0.004229257509, -0.002137567445)
    h2e[11, 0, 7, 11] = complex(0.000022262452, 0.000000466507)
    h2e[3, 0, 9, 11] = complex(0.000000247398, 0.000000123865)
    h2e[5, 0, 9, 11] = complex(-0.000010170471, -0.000005025772)
    h2e[7, 0, 9, 11] = complex(-0.004227277731, -0.002136566830)
    h2e[9, 0, 9, 11] = complex(-0.002508151498, -0.003523435547)
    h2e[11, 0, 9, 11] = complex(0.000002407980, 0.000001291743)
    h2e[3, 0, 11, 11] = complex(0.006861660835, -0.000001907212)
    h2e[5, 0, 11, 11] = complex(0.014578033123, -0.000000273683)
    h2e[7, 0, 11, 11] = complex(-0.000036809422, 0.000000440770)
    h2e[11, 0, 11, 11] = complex(0.008139708349, -0.000015369455)
    h2e[1, 2, 1, 11] = complex(0.009777990960, -0.001407846009)
    h2e[5, 2, 1, 11] = complex(0.000482202491, -0.000024541124)
    h2e[7, 2, 1, 11] = complex(0.000006796423, 0.000001394587)
    h2e[9, 2, 1, 11] = complex(-0.000007404521, -0.000003190465)
    h2e[11, 2, 1, 11] = complex(-0.001494462679, 0.000053639291)
    h2e[1, 2, 3, 11] = complex(-0.003463118787, 0.000205411225)
    h2e[5, 2, 3, 11] = complex(0.000171136924, 0.000005632125)
    h2e[7, 2, 3, 11] = complex(0.000010467630, -0.000004497813)
    h2e[9, 2, 3, 11] = complex(-0.000002288137, 0.000001147389)
    h2e[11, 2, 3, 11] = complex(-0.026508467156, -0.001270123240)
    h2e[1, 2, 5, 11] = complex(0.004210362510, -0.000249559215)
    h2e[5, 2, 5, 11] = complex(0.005230719877, 0.000172392620)
    h2e[7, 2, 5, 11] = complex(-0.000029449855, 0.000025934459)
    h2e[9, 2, 5, 11] = complex(0.000001836777, -0.000003145359)
    h2e[11, 2, 5, 11] = complex(0.016099533544, 0.000772055169)
    h2e[1, 2, 7, 11] = complex(-0.000009825784, 0.000000280936)
    h2e[5, 2, 7, 11] = complex(-0.000030444685, -0.000004806670)
    h2e[7, 2, 7, 11] = complex(-0.005794826188, 0.000183815167)
    h2e[9, 2, 7, 11] = complex(-0.000069858335, -0.000015132449)
    h2e[11, 2, 7, 11] = complex(-0.000050836240, -0.000003309722)
    h2e[1, 2, 9, 11] = complex(0.000000254090, 0.000000109482)
    h2e[5, 2, 9, 11] = complex(0.000002208516, -0.000003781946)
    h2e[7, 2, 9, 11] = complex(-0.000069858425, -0.000015132375)
    h2e[9, 2, 9, 11] = complex(-0.003480354917, -0.004663899354)
    h2e[11, 2, 9, 11] = complex(-0.000002923697, -0.000000877077)
    h2e[1, 2, 11, 11] = complex(0.006850273639, -0.000395150756)
    h2e[5, 2, 11, 11] = complex(-0.004344732228, -0.000150077732)
    h2e[7, 2, 11, 11] = complex(0.000012009705, -0.000015766172)
    h2e[11, 2, 11, 11] = complex(0.010234604227, 0.000507044594)
    h2e[1, 4, 1, 11] = complex(0.001444605190, -0.000140633636)
    h2e[3, 4, 1, 11] = complex(0.000482820165, -0.000002489364)
    h2e[7, 4, 1, 11] = complex(-0.000003462139, -0.000000738891)
    h2e[9, 4, 1, 11] = complex(0.000003235130, 0.000001552032)
    h2e[11, 4, 1, 11] = complex(0.001195157317, 0.000009039739)
    h2e[1, 4, 3, 11] = complex(0.014261559772, -0.000189565098)
    h2e[3, 4, 3, 11] = complex(0.000170701027, 0.000013443474)
    h2e[7, 4, 3, 11] = complex(-0.000000414957, -0.000020773917)
    h2e[9, 4, 3, 11] = complex(0.000000379668, -0.000000586853)
    h2e[11, 4, 3, 11] = complex(-0.019371458469, -0.001773880942)
    h2e[1, 4, 5, 11] = complex(0.003529899055, -0.000046774138)
    h2e[3, 4, 5, 11] = complex(0.005217385498, 0.000411142565)
    h2e[7, 4, 5, 11] = complex(-0.000007011557, 0.000015042500)
    h2e[9, 4, 5, 11] = complex(-0.000000023822, -0.000001457510)
    h2e[11, 4, 5, 11] = complex(0.045886543790, 0.004203821416)
    h2e[1, 4, 7, 11] = complex(-0.000002046373, -0.000000795393)
    h2e[3, 4, 7, 11] = complex(-0.000030193348, -0.000006192311)
    h2e[7, 4, 7, 11] = complex(-0.000778254942, -0.000017747876)
    h2e[9, 4, 7, 11] = complex(-0.000116964439, -0.000068736775)
    h2e[11, 4, 7, 11] = complex(-0.000135062362, -0.000013676627)
    h2e[1, 4, 9, 11] = complex(0.000010228320, 0.000004906968)
    h2e[3, 4, 9, 11] = complex(0.000002378962, -0.000003677118)
    h2e[7, 4, 9, 11] = complex(-0.000116971982, -0.000068741196)
    h2e[9, 4, 9, 11] = complex(-0.000432763065, -0.000651081837)
    h2e[11, 4, 9, 11] = complex(-0.000011318928, -0.000003431063)
    h2e[1, 4, 11, 11] = complex(-0.014577040997, 0.000170075191)
    h2e[3, 4, 11, 11] = complex(-0.004333341942, -0.000348380645)
    h2e[7, 4, 11, 11] = complex(0.000000867386, -0.000006283048)
    h2e[11, 4, 11, 11] = complex(-0.009457316943, -0.000881518542)
    h2e[1, 6, 1, 11] = complex(-0.000000894444, 0.000000928921)
    h2e[3, 6, 1, 11] = complex(0.000004140443, -0.000005567133)
    h2e[5, 6, 1, 11] = complex(0.000002003751, -0.000002918450)
    h2e[9, 6, 1, 11] = complex(-0.000000006978, 0.000000006158)
    h2e[11, 6, 1, 11] = complex(-0.000001598779, 0.000006188185)
    h2e[1, 6, 3, 11] = complex(-0.000014686746, 0.000037618203)
    h2e[3, 6, 3, 11] = complex(0.000000356049, -0.000011387485)
    h2e[5, 6, 3, 11] = complex(0.000019361231, 0.000007541258)
    h2e[11, 6, 3, 11] = complex(0.000016243475, -0.000060443986)
    h2e[1, 6, 5, 11] = complex(0.000000786933, -0.000000691116)
    h2e[3, 6, 5, 11] = complex(0.000011029988, 0.000037659388)
    h2e[5, 6, 5, 11] = complex(-0.000011230173, -0.000012219735)
    h2e[9, 6, 5, 11] = complex(0.000000001308, -0.000000000991)
    h2e[11, 6, 5, 11] = complex(-0.000038524552, 0.000134606111)
    h2e[1, 6, 7, 11] = complex(0.001559717446, -0.004015588864)
    h2e[3, 6, 7, 11] = complex(-0.002286449086, 0.005327846586)
    h2e[5, 6, 7, 11] = complex(0.000313294462, -0.000712630566)
    h2e[9, 6, 7, 11] = complex(0.000000001619, -0.000000286766)
    h2e[11, 6, 7, 11] = complex(-0.000263232548, -0.000123925162)
    h2e[1, 6, 9, 11] = complex(0.003551350910, -0.003134118940)
    h2e[3, 6, 9, 11] = complex(-0.000043281253, 0.000056885149)
    h2e[5, 6, 9, 11] = complex(0.000108165267, -0.000081902819)
    h2e[9, 6, 9, 11] = complex(-0.000004454395, 0.000002009372)
    h2e[11, 6, 9, 11] = complex(-0.003507450636, 0.002464679224)
    h2e[1, 6, 11, 11] = complex(0.000013235414, -0.000034350425)
    h2e[3, 6, 11, 11] = complex(-0.000009200169, -0.000017554547)
    h2e[5, 6, 11, 11] = complex(0.000005477015, 0.000003198649)
    h2e[11, 6, 11, 11] = complex(0.000009883137, -0.000038421612)
    h2e[1, 8, 1, 11] = complex(-0.000001506385, -0.000001215737)
    h2e[3, 8, 1, 11] = complex(-0.000007427852, -0.000003135766)
    h2e[5, 8, 1, 11] = complex(-0.000003312903, -0.000001378240)
    h2e[7, 8, 1, 11] = complex(0.000000008561, 0.000000003652)
    h2e[11, 8, 1, 11] = complex(0.000002486479, 0.000001133309)
    h2e[1, 8, 3, 11] = complex(-0.000004494252, -0.000001897308)
    h2e[3, 8, 3, 11] = complex(-0.000002279611, 0.000001164234)
    h2e[5, 8, 3, 11] = complex(-0.000000348011, 0.000000606168)
    h2e[11, 8, 3, 11] = complex(0.000002930087, 0.000000855488)
    h2e[1, 8, 5, 11] = complex(0.000009654020, 0.000004016282)
    h2e[3, 8, 5, 11] = complex(0.000001813522, -0.000003158820)
    h2e[5, 8, 5, 11] = complex(0.000000101107, 0.000001454194)
    h2e[7, 8, 5, 11] = complex(-0.000000001457, -0.000000000755)
    h2e[11, 8, 5, 11] = complex(-0.000011484995, -0.000002825819)
    h2e[1, 8, 7, 11] = complex(0.004358645831, 0.001859575265)
    h2e[3, 8, 7, 11] = complex(-0.000069968046, -0.000014616763)
    h2e[5, 8, 7, 11] = complex(0.000120445902, 0.000062435635)
    h2e[7, 8, 7, 11] = complex(-0.000000259600, 0.000000121841)
    h2e[11, 8, 7, 11] = complex(-0.003733332377, -0.002106913145)
    h2e[1, 8, 9, 11] = complex(0.002730770649, 0.003353850569)
    h2e[3, 8, 9, 11] = complex(-0.003514659402, -0.004638102707)
    h2e[5, 8, 9, 11] = complex(0.000466690349, 0.000627209331)
    h2e[7, 8, 9, 11] = complex(0.000003729426, 0.000003157624)
    h2e[11, 8, 9, 11] = complex(0.000238436735, -0.000168521899)
    h2e[1, 10, 1, 11] = complex(-0.009106613486, 0.001673282187)
    h2e[3, 10, 1, 11] = complex(0.001491443857, -0.000109046286)
    h2e[5, 10, 1, 11] = complex(0.001191810192, -0.000089839828)
    h2e[7, 10, 1, 11] = complex(-0.000006235417, 0.000001403319)
    h2e[9, 10, 1, 11] = complex(0.000002519071, 0.000001058890)
    h2e[1, 10, 3, 11] = complex(-0.010003204582, 0.000983089409)
    h2e[3, 10, 3, 11] = complex(0.026537339064, 0.000285796152)
    h2e[5, 10, 3, 11] = complex(-0.019451802522, -0.000165636496)
    h2e[7, 10, 3, 11] = complex(0.000061191714, -0.000013149148)
    h2e[9, 10, 3, 11] = complex(0.000002954219, 0.000000768005)
    h2e[1, 10, 5, 11] = complex(-0.006624495613, 0.000650763152)
    h2e[3, 10, 5, 11] = complex(-0.016117093121, -0.000174237914)
    h2e[5, 10, 5, 11] = complex(0.046077017920, 0.000394252523)
    h2e[7, 10, 5, 11] = complex(-0.000137344816, 0.000027190949)
    h2e[9, 10, 5, 11] = complex(-0.000011563914, -0.000002483147)
    h2e[1, 10, 7, 11] = complex(0.000022207222, -0.000001635141)
    h2e[3, 10, 7, 11] = complex(0.000050924031, 0.000001421441)
    h2e[5, 10, 7, 11] = complex(-0.000135730781, -0.000002459084)
    h2e[7, 10, 7, 11] = complex(-0.000009947744, -0.000290774609)
    h2e[9, 10, 7, 11] = complex(-0.003794316710, -0.001994997314)
    h2e[1, 10, 9, 11] = complex(0.000002519071, 0.000001058890)
    h2e[3, 10, 9, 11] = complex(0.000002954222, 0.000000768005)
    h2e[5, 10, 9, 11] = complex(-0.000011563923, -0.000002483146)
    h2e[7, 10, 9, 11] = complex(-0.003794316693, -0.001994997383)
    h2e[9, 10, 9, 11] = complex(0.000233321492, -0.000175535637)
    h2e[1, 10, 11, 11] = complex(0.008101979308, -0.000782955633)
    h2e[3, 10, 11, 11] = complex(-0.010246369596, -0.000126996128)
    h2e[5, 10, 11, 11] = complex(-0.009497823108, -0.000096306329)
    h2e[7, 10, 11, 11] = complex(0.000038695021, -0.000008751689)
    h2e[1, 1, 1, 1] = complex(4.133559527667, 0.000000000000)
    h2e[3, 1, 1, 1] = complex(-0.056133611779, -0.002291569232)
    h2e[5, 1, 1, 1] = complex(-0.016278429618, -0.000175472749)
    h2e[7, 1, 1, 1] = complex(0.000037256617, 0.000038379333)
    h2e[11, 1, 1, 1] = complex(0.062770336469, 0.005372283708)
    h2e[1, 1, 3, 1] = complex(-0.056133611779, -0.002291569232)
    h2e[3, 1, 3, 1] = complex(0.001204652534, 0.000098520400)
    h2e[5, 1, 3, 1] = complex(0.000316005242, 0.000016314073)
    h2e[7, 1, 3, 1] = complex(-0.000000214327, -0.000000711471)
    h2e[9, 1, 3, 1] = complex(-0.000000350757, -0.000000224628)
    h2e[11, 1, 3, 1] = complex(-0.001522317359, -0.000193110586)
    h2e[1, 1, 5, 1] = complex(-0.016278429618, -0.000175472749)
    h2e[3, 1, 5, 1] = complex(0.000316005242, 0.000016314073)
    h2e[5, 1, 5, 1] = complex(0.000199300973, 0.000004290601)
    h2e[7, 1, 5, 1] = complex(-0.000025696362, -0.000003791017)
    h2e[9, 1, 5, 1] = complex(0.000017787619, 0.000011230943)
    h2e[11, 1, 5, 1] = complex(0.000141011087, 0.000013601804)
    h2e[1, 1, 7, 1] = complex(0.000037256617, 0.000038379333)
    h2e[3, 1, 7, 1] = complex(-0.000000214327, -0.000000711471)
    h2e[5, 1, 7, 1] = complex(-0.000025696362, -0.000003791017)
    h2e[7, 1, 7, 1] = complex(-0.010854302156, -0.001372979778)
    h2e[9, 1, 7, 1] = complex(0.007327228045, 0.005220542358)
    h2e[11, 1, 7, 1] = complex(0.000006574844, 0.000000770271)
    h2e[3, 1, 9, 1] = complex(-0.000000350757, -0.000000224628)
    h2e[5, 1, 9, 1] = complex(0.000017787619, 0.000011230943)
    h2e[7, 1, 9, 1] = complex(0.007327228045, 0.005220542358)
    h2e[9, 1, 9, 1] = complex(-0.005110639785, -0.009732329061)
    h2e[11, 1, 9, 1] = complex(-0.000005956556, -0.000004080575)
    h2e[1, 1, 11, 1] = complex(0.062770336469, 0.005372283708)
    h2e[3, 1, 11, 1] = complex(-0.001522317359, -0.000193110586)
    h2e[5, 1, 11, 1] = complex(0.000141011087, 0.000013601804)
    h2e[7, 1, 11, 1] = complex(0.000006574844, 0.000000770271)
    h2e[9, 1, 11, 1] = complex(-0.000005956556, -0.000004080575)
    h2e[11, 1, 11, 1] = complex(0.004424971426, 0.000763023577)
    h2e[1, 3, 1, 1] = complex(-0.056133611779, 0.002291569232)
    h2e[3, 3, 1, 1] = complex(0.881258649475, -0.000000000000)
    h2e[5, 3, 1, 1] = complex(0.127196685084, -0.000024542078)
    h2e[7, 3, 1, 1] = complex(-0.000413324188, -0.000000522774)
    h2e[11, 3, 1, 1] = complex(-0.202690975409, -0.000329260552)
    h2e[1, 3, 3, 1] = complex(0.001208674528, -0.000000000000)
    h2e[3, 3, 3, 1] = complex(-0.001798164002, -0.000073407307)
    h2e[5, 3, 3, 1] = complex(-0.001272910336, -0.000051718618)
    h2e[7, 3, 3, 1] = complex(0.000003507841, 0.000000218304)
    h2e[9, 3, 3, 1] = complex(0.000000242669, 0.000000209320)
    h2e[11, 3, 3, 1] = complex(0.000538400283, 0.000022855483)
    h2e[1, 3, 5, 1] = complex(0.000316281223, -0.000009498212)
    h2e[3, 3, 5, 1] = complex(-0.001350358560, -0.000014556142)
    h2e[5, 3, 5, 1] = complex(0.001241503535, 0.000013142595)
    h2e[7, 3, 5, 1] = complex(-0.000007216539, -0.000003109267)
    h2e[9, 3, 5, 1] = complex(-0.000011150333, -0.000009222915)
    h2e[11, 3, 5, 1] = complex(0.001391853745, 0.000017265171)
    h2e[1, 3, 7, 1] = complex(-0.000001241324, -0.000000718564)
    h2e[3, 3, 7, 1] = complex(0.000002985010, 0.000003074962)
    h2e[5, 3, 7, 1] = complex(-0.000008755426, 0.000000108021)
    h2e[7, 3, 7, 1] = complex(-0.002115204929, -0.000096281168)
    h2e[9, 3, 7, 1] = complex(-0.005313958966, -0.002951828258)
    h2e[11, 3, 7, 1] = complex(-0.000000622063, -0.000003314805)
    h2e[1, 3, 9, 1] = complex(0.000000378222, 0.000000174850)
    h2e[5, 3, 9, 1] = complex(-0.000012378275, -0.000010238598)
    h2e[7, 3, 9, 1] = complex(-0.005316308523, -0.002953133477)
    h2e[9, 3, 9, 1] = complex(-0.001136197129, -0.001796754586)
    h2e[11, 3, 9, 1] = complex(0.000000238270, 0.000000482297)
    h2e[1, 3, 11, 1] = complex(-0.001532991813, -0.000068382201)
    h2e[3, 3, 11, 1] = complex(-0.001630334179, -0.000139534344)
    h2e[5, 3, 11, 1] = complex(0.008439951675, 0.000720704022)
    h2e[7, 3, 11, 1] = complex(-0.000020999314, -0.000001214160)
    h2e[9, 3, 11, 1] = complex(0.000000393799, 0.000000797113)
    h2e[11, 3, 11, 1] = complex(0.004856091513, 0.000423562483)
    h2e[1, 5, 1, 1] = complex(-0.016278429618, 0.000175472749)
    h2e[3, 5, 1, 1] = complex(0.127196685084, 0.000024542078)
    h2e[5, 5, 1, 1] = complex(0.798772089110, -0.000000000000)
    h2e[7, 5, 1, 1] = complex(0.000546884185, -0.000001923925)
    h2e[11, 5, 1, 1] = complex(0.213867894708, 0.000338610404)
    h2e[1, 5, 3, 1] = complex(0.000316281223, 0.000009498212)
    h2e[3, 5, 3, 1] = complex(-0.001272890704, -0.000052209839)
    h2e[5, 5, 3, 1] = complex(-0.001519877541, -0.000062046686)
    h2e[7, 5, 3, 1] = complex(-0.000000898662, -0.000000001997)
    h2e[9, 5, 3, 1] = complex(0.000000124329, 0.000000101642)
    h2e[11, 5, 3, 1] = complex(-0.000654571386, -0.000027760025)
    h2e[1, 5, 5, 1] = complex(0.000199464539, -0.000000000000)
    h2e[3, 5, 5, 1] = complex(0.001241525064, 0.000013623365)
    h2e[5, 5, 5, 1] = complex(0.000492588526, 0.000005309840)
    h2e[7, 5, 5, 1] = complex(-0.000003416956, -0.000001346327)
    h2e[9, 5, 5, 1] = complex(-0.000005554299, -0.000004396287)
    h2e[11, 5, 5, 1] = complex(0.000344485003, 0.000004257945)
    h2e[1, 5, 7, 1] = complex(0.000025003669, -0.000000553412)
    h2e[3, 5, 7, 1] = complex(0.000003423085, -0.000005490953)
    h2e[5, 5, 7, 1] = complex(-0.000001040911, -0.000001072279)
    h2e[7, 5, 7, 1] = complex(-0.000587843788, -0.000030645173)
    h2e[9, 5, 7, 1] = complex(-0.002603042870, -0.001451681026)
    h2e[11, 5, 7, 1] = complex(-0.000005427294, -0.000000345943)
    h2e[1, 5, 9, 1] = complex(-0.000019139743, -0.000008736247)
    h2e[3, 5, 9, 1] = complex(0.000012423996, 0.000010156903)
    h2e[7, 5, 9, 1] = complex(-0.002604245715, -0.001452351868)
    h2e[9, 5, 9, 1] = complex(-0.000312560384, -0.000501576199)
    h2e[11, 5, 9, 1] = complex(-0.000001032762, -0.000001334969)
    h2e[1, 5, 11, 1] = complex(0.000141239546, 0.000010557161)
    h2e[3, 5, 11, 1] = complex(0.008439681402, 0.000723962028)
    h2e[5, 5, 11, 1] = complex(0.005862208618, 0.000501725012)
    h2e[7, 5, 11, 1] = complex(-0.000009168235, -0.000000478248)
    h2e[9, 5, 11, 1] = complex(0.000000354406, 0.000000458112)
    h2e[11, 5, 11, 1] = complex(0.003215888374, 0.000280365730)
    h2e[1, 7, 1, 1] = complex(0.000037256617, -0.000038379333)
    h2e[3, 7, 1, 1] = complex(-0.000413324188, 0.000000522774)
    h2e[5, 7, 1, 1] = complex(0.000546884185, 0.000001923925)
    h2e[7, 7, 1, 1] = complex(0.966780087765, 0.000000000000)
    h2e[11, 7, 1, 1] = complex(-0.000604236288, 0.000016482583)
    h2e[1, 7, 3, 1] = complex(-0.000001241324, 0.000000718564)
    h2e[3, 7, 3, 1] = complex(0.000003359240, 0.000000203022)
    h2e[5, 7, 3, 1] = complex(-0.000000922738, -0.000000008505)
    h2e[7, 7, 3, 1] = complex(-0.001606930608, -0.000065600495)
    h2e[11, 7, 3, 1] = complex(0.000001672377, 0.000000009402)
    h2e[1, 7, 5, 1] = complex(0.000025003669, 0.000000553412)
    h2e[3, 7, 5, 1] = complex(0.000002441689, -0.000002496922)
    h2e[5, 7, 5, 1] = complex(-0.000000808932, -0.000001205576)
    h2e[7, 7, 5, 1] = complex(-0.000455152758, -0.000004906303)
    h2e[9, 7, 5, 1] = complex(0.000000013308, 0.000000014222)
    h2e[11, 7, 5, 1] = complex(-0.000006166822, 0.000000427156)
    h2e[1, 7, 7, 1] = complex(0.011110479287, 0.000000000000)
    h2e[3, 7, 7, 1] = complex(0.002304041568, -0.002232755924)
    h2e[5, 7, 7, 1] = complex(0.000667647843, -0.001021656585)
    h2e[7, 7, 7, 1] = complex(0.000001018896, 0.000001049599)
    h2e[9, 7, 7, 1] = complex(0.000006257870, 0.000004909550)
    h2e[11, 7, 7, 1] = complex(-0.002161730679, 0.000552354206)
    h2e[1, 7, 9, 1] = complex(-0.008535060179, -0.003328921117)
    h2e[3, 7, 9, 1] = complex(0.004238984654, 0.004863292120)
    h2e[5, 7, 9, 1] = complex(0.002139307371, 0.002286238907)
    h2e[9, 7, 9, 1] = complex(0.000001937905, 0.000000497051)
    h2e[11, 7, 9, 1] = complex(-0.000285967605, -0.000986116435)
    h2e[1, 7, 11, 1] = complex(-0.000007320408, 0.000000507920)
    h2e[3, 7, 11, 1] = complex(-0.000017696106, -0.000000723828)
    h2e[5, 7, 11, 1] = complex(-0.000007281292, -0.000000310774)
    h2e[7, 7, 11, 1] = complex(0.001598968882, 0.000136849903)
    h2e[9, 7, 11, 1] = complex(-0.000000000562, -0.000000001937)
    h2e[11, 7, 11, 1] = complex(-0.000009170656, -0.000000771996)
    h2e[9, 9, 1, 1] = complex(0.966731902319, 0.000000000000)
    h2e[1, 9, 3, 1] = complex(0.000000378222, -0.000000174850)
    h2e[3, 9, 3, 1] = complex(-0.000000267299, 0.000000177942)
    h2e[5, 9, 3, 1] = complex(-0.000000136299, 0.000000085381)
    h2e[9, 9, 3, 1] = complex(-0.001606318802, -0.000065575519)
    h2e[11, 9, 3, 1] = complex(0.000000014495, -0.000000031738)
    h2e[1, 9, 5, 1] = complex(-0.000019139743, 0.000008736247)
    h2e[3, 9, 5, 1] = complex(0.000012269024, -0.000007685585)
    h2e[5, 9, 5, 1] = complex(0.000006086173, -0.000003629728)
    h2e[7, 9, 5, 1] = complex(-0.000000015076, 0.000000012356)
    h2e[9, 9, 5, 1] = complex(-0.000454979583, -0.000004904436)
    h2e[11, 9, 5, 1] = complex(-0.000001202597, 0.000001544621)
    h2e[1, 9, 7, 1] = complex(-0.008535060179, 0.003328921117)
    h2e[3, 9, 7, 1] = complex(0.004831733589, -0.004300169281)
    h2e[5, 9, 7, 1] = complex(0.002422386266, -0.001985443086)
    h2e[7, 9, 7, 1] = complex(-0.000006029001, 0.000006419549)
    h2e[9, 9, 7, 1] = complex(0.000001018499, 0.000001049191)
    h2e[11, 9, 7, 1] = complex(-0.000376644737, 0.001049940944)
    h2e[1, 9, 9, 1] = complex(0.011100485424, 0.000000000000)
    h2e[3, 9, 9, 1] = complex(0.002011602423, 0.002090758480)
    h2e[5, 9, 9, 1] = complex(0.000538151970, 0.000893959698)
    h2e[7, 9, 9, 1] = complex(-0.000001225832, -0.000003727934)
    h2e[11, 9, 9, 1] = complex(-0.002069159539, -0.000813617799)
    h2e[1, 9, 11, 1] = complex(0.000006509613, -0.000003155518)
    h2e[3, 9, 11, 1] = complex(-0.000000422414, 0.000000924878)
    h2e[5, 9, 11, 1] = complex(-0.000000380371, 0.000000488551)
    h2e[7, 9, 11, 1] = complex(0.000000000740, -0.000000002063)
    h2e[9, 9, 11, 1] = complex(0.001598266472, 0.000136789787)
    h2e[11, 9, 11, 1] = complex(-0.000000624339, -0.000000019459)
    h2e[1, 11, 1, 1] = complex(0.062770336469, -0.005372283708)
    h2e[3, 11, 1, 1] = complex(-0.202690975409, 0.000329260552)
    h2e[5, 11, 1, 1] = complex(0.213867894708, -0.000338610404)
    h2e[7, 11, 1, 1] = complex(-0.000604236288, -0.000016482583)
    h2e[11, 11, 1, 1] = complex(0.764008571323, -0.000000000000)
    h2e[1, 11, 3, 1] = complex(-0.001532991813, 0.000068382201)
    h2e[3, 11, 3, 1] = complex(0.000538471964, 0.000021106179)
    h2e[5, 11, 3, 1] = complex(-0.000654656458, -0.000025687193)
    h2e[7, 11, 3, 1] = complex(0.000001459747, 0.000000081791)
    h2e[9, 11, 3, 1] = complex(-0.000000010701, -0.000000032407)
    h2e[11, 11, 3, 1] = complex(-0.001064961868, -0.000043475447)
    h2e[1, 11, 5, 1] = complex(0.000141239546, -0.000010557161)
    h2e[3, 11, 5, 1] = complex(0.001391891127, 0.000012742378)
    h2e[5, 11, 5, 1] = complex(0.000344518509, 0.000003168498)
    h2e[7, 11, 5, 1] = complex(0.000003654242, 0.000001007234)
    h2e[9, 11, 5, 1] = complex(0.000000992725, 0.000001678764)
    h2e[11, 11, 5, 1] = complex(-0.001422634196, -0.000015335234)
    h2e[1, 11, 7, 1] = complex(-0.000007320408, -0.000000507920)
    h2e[3, 11, 7, 1] = complex(-0.000005493702, -0.000002863496)
    h2e[5, 11, 7, 1] = complex(0.000004004788, -0.000001412085)
    h2e[7, 11, 7, 1] = complex(0.002089143695, 0.000058078098)
    h2e[9, 11, 7, 1] = complex(0.000659332079, 0.000363255317)
    h2e[11, 11, 7, 1] = complex(0.000003111333, 0.000003205092)
    h2e[1, 11, 9, 1] = complex(0.000006509613, 0.000003155518)
    h2e[3, 11, 9, 1] = complex(-0.000000188681, -0.000000571395)
    h2e[5, 11, 9, 1] = complex(0.000000914989, 0.000001547307)
    h2e[7, 11, 9, 1] = complex(0.000659640860, 0.000363425462)
    h2e[9, 11, 9, 1] = complex(0.001152659852, 0.001753310173)
    h2e[1, 11, 11, 1] = complex(0.004490286136, 0.000000000000)
    h2e[3, 11, 11, 1] = complex(0.004857442834, 0.000407783361)
    h2e[5, 11, 11, 1] = complex(0.003216758836, 0.000270181193)
    h2e[7, 11, 11, 1] = complex(-0.000009632709, -0.000001250031)
    h2e[9, 11, 11, 1] = complex(0.000000583158, 0.000000129436)
    h2e[11, 11, 11, 1] = complex(-0.003933065673, -0.000336616718)
    h2e[1, 1, 1, 3] = complex(-0.056133611779, 0.002291569232)
    h2e[3, 1, 1, 3] = complex(0.001208674528, -0.000000000000)
    h2e[5, 1, 1, 3] = complex(0.000316281223, -0.000009498212)
    h2e[7, 1, 1, 3] = complex(-0.000001241324, -0.000000718564)
    h2e[9, 1, 1, 3] = complex(0.000000378222, 0.000000174850)
    h2e[11, 1, 1, 3] = complex(-0.001532991813, -0.000068382201)
    h2e[1, 1, 3, 3] = complex(0.881258649475, -0.000000000000)
    h2e[3, 1, 3, 3] = complex(-0.001798164002, -0.000073407307)
    h2e[5, 1, 3, 3] = complex(-0.001350358560, -0.000014556142)
    h2e[7, 1, 3, 3] = complex(0.000002985010, 0.000003074962)
    h2e[11, 1, 3, 3] = complex(-0.001630334179, -0.000139534344)
    h2e[1, 1, 5, 3] = complex(0.127196685084, -0.000024542078)
    h2e[3, 1, 5, 3] = complex(-0.001272910336, -0.000051718618)
    h2e[5, 1, 5, 3] = complex(0.001241503535, 0.000013142595)
    h2e[7, 1, 5, 3] = complex(-0.000008755426, 0.000000108021)
    h2e[9, 1, 5, 3] = complex(-0.000012378275, -0.000010238598)
    h2e[11, 1, 5, 3] = complex(0.008439951675, 0.000720704022)
    h2e[1, 1, 7, 3] = complex(-0.000413324188, -0.000000522774)
    h2e[3, 1, 7, 3] = complex(0.000003507841, 0.000000218304)
    h2e[5, 1, 7, 3] = complex(-0.000007216539, -0.000003109267)
    h2e[7, 1, 7, 3] = complex(-0.002115204929, -0.000096281168)
    h2e[9, 1, 7, 3] = complex(-0.005316308523, -0.002953133477)
    h2e[11, 1, 7, 3] = complex(-0.000020999314, -0.000001214160)
    h2e[3, 1, 9, 3] = complex(0.000000242669, 0.000000209320)
    h2e[5, 1, 9, 3] = complex(-0.000011150333, -0.000009222915)
    h2e[7, 1, 9, 3] = complex(-0.005313958966, -0.002951828258)
    h2e[9, 1, 9, 3] = complex(-0.001136197129, -0.001796754586)
    h2e[11, 1, 9, 3] = complex(0.000000393799, 0.000000797113)
    h2e[1, 1, 11, 3] = complex(-0.202690975409, -0.000329260552)
    h2e[3, 1, 11, 3] = complex(0.000538400283, 0.000022855483)
    h2e[5, 1, 11, 3] = complex(0.001391853745, 0.000017265171)
    h2e[7, 1, 11, 3] = complex(-0.000000622063, -0.000003314805)
    h2e[9, 1, 11, 3] = complex(0.000000238270, 0.000000482297)
    h2e[11, 1, 11, 3] = complex(0.004856091513, 0.000423562483)
    h2e[1, 3, 1, 3] = complex(0.001204652534, -0.000098520400)
    h2e[3, 3, 1, 3] = complex(-0.001798164002, 0.000073407307)
    h2e[5, 3, 1, 3] = complex(-0.001272890704, 0.000052209839)
    h2e[7, 3, 1, 3] = complex(0.000003359240, -0.000000203022)
    h2e[9, 3, 1, 3] = complex(-0.000000267299, -0.000000177942)
    h2e[11, 3, 1, 3] = complex(0.000538471964, -0.000021106179)
    h2e[1, 3, 3, 3] = complex(-0.001798164002, 0.000073407307)
    h2e[3, 3, 3, 3] = complex(0.652177317347, 0.000000000000)
    h2e[5, 3, 3, 3] = complex(-0.013796280764, 0.000002661936)
    h2e[7, 3, 3, 3] = complex(-0.000001061503, -0.000000001342)
    h2e[11, 3, 3, 3] = complex(-0.092407510398, -0.000150111014)
    h2e[1, 3, 5, 3] = complex(-0.001272890704, 0.000052209839)
    h2e[3, 3, 5, 3] = complex(-0.013796280764, 0.000002661936)
    h2e[5, 3, 5, 3] = complex(0.128326736337, -0.000049520399)
    h2e[7, 3, 5, 3] = complex(-0.000493943912, 0.000000205874)
    h2e[9, 3, 5, 3] = complex(-0.000139156513, -0.000067981251)
    h2e[11, 3, 5, 3] = complex(0.003003839896, 0.000004299899)
    h2e[1, 3, 7, 3] = complex(0.000003359240, -0.000000203022)
    h2e[3, 3, 7, 3] = complex(-0.000001061503, -0.000000001342)
    h2e[5, 3, 7, 3] = complex(-0.000493943912, 0.000000205874)
    h2e[7, 3, 7, 3] = complex(-0.062007759238, 0.000512514791)
    h2e[9, 3, 7, 3] = complex(-0.052722849229, -0.027230005494)
    h2e[11, 3, 7, 3] = complex(0.000050317194, 0.000000733312)
    h2e[1, 3, 9, 3] = complex(-0.000000267299, -0.000000177942)
    h2e[5, 3, 9, 3] = complex(-0.000139156513, -0.000067981251)
    h2e[7, 3, 9, 3] = complex(-0.052722849229, -0.027230005494)
    h2e[9, 3, 9, 3] = complex(-0.036044145010, -0.050742336484)
    h2e[11, 3, 9, 3] = complex(0.000021654590, 0.000011401921)
    h2e[1, 3, 11, 3] = complex(0.000538471964, -0.000021106179)
    h2e[3, 3, 11, 3] = complex(-0.092407510398, -0.000150111014)
    h2e[5, 3, 11, 3] = complex(0.003003839896, 0.000004299899)
    h2e[7, 3, 11, 3] = complex(0.000050317194, 0.000000733312)
    h2e[9, 3, 11, 3] = complex(0.000021654590, 0.000011401921)
    h2e[11, 3, 11, 3] = complex(0.086506559668, 0.000281051165)
    h2e[1, 5, 1, 3] = complex(0.000316005242, -0.000016314073)
    h2e[3, 5, 1, 3] = complex(-0.001272910336, 0.000051718618)
    h2e[5, 5, 1, 3] = complex(-0.001519877541, 0.000062046686)
    h2e[7, 5, 1, 3] = complex(-0.000000922738, 0.000000008505)
    h2e[9, 5, 1, 3] = complex(-0.000000136299, -0.000000085381)
    h2e[11, 5, 1, 3] = complex(-0.000654656458, 0.000025687193)
    h2e[1, 5, 3, 3] = complex(-0.001350358560, 0.000014556142)
    h2e[3, 5, 3, 3] = complex(-0.013796280764, -0.000002661936)
    h2e[5, 5, 3, 3] = complex(0.587292582647, 0.000000000000)
    h2e[7, 5, 3, 3] = complex(0.000191253574, -0.000000672825)
    h2e[11, 5, 3, 3] = complex(0.058557914949, 0.000092712931)
    h2e[1, 5, 5, 3] = complex(0.001241525064, -0.000013623365)
    h2e[3, 5, 5, 3] = complex(0.128327582473, -0.000000000000)
    h2e[5, 5, 5, 3] = complex(0.042211019244, -0.000008144443)
    h2e[7, 5, 5, 3] = complex(0.000053583529, -0.000000512951)
    h2e[9, 5, 5, 3] = complex(-0.000050400480, -0.000024364699)
    h2e[11, 5, 5, 3] = complex(0.091821509829, 0.000127661653)
    h2e[1, 5, 7, 3] = complex(0.000002441689, 0.000002496922)
    h2e[3, 5, 7, 3] = complex(-0.000170731174, -0.000001050474)
    h2e[5, 5, 7, 3] = complex(-0.000114630482, -0.000000144984)
    h2e[7, 5, 7, 3] = complex(-0.022250889318, 0.000182163230)
    h2e[9, 5, 7, 3] = complex(-0.018570586861, -0.009624302076)
    h2e[11, 5, 7, 3] = complex(-0.000298789830, -0.000001673986)
    h2e[1, 5, 9, 3] = complex(0.000012269024, 0.000007685585)
    h2e[3, 5, 9, 3] = complex(0.000139068227, 0.000068083645)
    h2e[7, 5, 9, 3] = complex(-0.018570712767, -0.009624367334)
    h2e[9, 5, 9, 3] = complex(-0.012931962374, -0.018208416547)
    h2e[11, 5, 9, 3] = complex(-0.000037371241, -0.000019510954)
    h2e[1, 5, 11, 3] = complex(0.001391891127, -0.000012742378)
    h2e[3, 5, 11, 3] = complex(0.003003719245, 0.000005458995)
    h2e[5, 5, 11, 3] = complex(-0.016168008881, -0.000026264058)
    h2e[7, 5, 11, 3] = complex(-0.000238564722, 0.000000718014)
    h2e[9, 5, 11, 3] = complex(0.000007171416, 0.000003744086)
    h2e[11, 5, 11, 3] = complex(-0.052538607424, -0.000168529211)
    h2e[1, 7, 1, 3] = complex(-0.000000214327, 0.000000711471)
    h2e[3, 7, 1, 3] = complex(0.000003507841, -0.000000218304)
    h2e[5, 7, 1, 3] = complex(-0.000000898662, 0.000000001997)
    h2e[7, 7, 1, 3] = complex(-0.001606930608, 0.000065600495)
    h2e[11, 7, 1, 3] = complex(0.000001459747, -0.000000081791)
    h2e[1, 7, 3, 3] = complex(0.000002985010, -0.000003074962)
    h2e[3, 7, 3, 3] = complex(-0.000001061503, 0.000000001342)
    h2e[5, 7, 3, 3] = complex(0.000191253574, 0.000000672825)
    h2e[7, 7, 3, 3] = complex(0.652882649491, -0.000000000000)
    h2e[11, 7, 3, 3] = complex(-0.000172766481, 0.000004712788)
    h2e[1, 7, 5, 3] = complex(0.000003423085, 0.000005490953)
    h2e[3, 7, 5, 3] = complex(-0.000170731174, 0.000001050474)
    h2e[5, 7, 5, 3] = complex(0.000172427118, 0.000000293227)
    h2e[7, 7, 5, 3] = complex(0.067630245781, -0.000013048978)
    h2e[9, 7, 5, 3] = complex(0.000000133264, 0.000000059782)
    h2e[11, 7, 5, 3] = complex(-0.000329014870, 0.000006230532)
    h2e[1, 7, 7, 3] = complex(0.002304041568, 0.002232755924)
    h2e[3, 7, 7, 3] = complex(0.062928655211, 0.000000000000)
    h2e[5, 7, 7, 3] = complex(0.022585317646, -0.000220621203)
    h2e[7, 7, 7, 3] = complex(-0.000218947889, -0.000000276928)
    h2e[9, 7, 7, 3] = complex(0.000048844477, 0.000023538508)
    h2e[11, 7, 7, 3] = complex(-0.019142422040, -0.001019561044)
    h2e[1, 7, 9, 3] = complex(0.004831733589, 0.004300169281)
    h2e[3, 7, 9, 3] = complex(0.054616978070, 0.025189499012)
    h2e[5, 7, 9, 3] = complex(0.019358212716, 0.008684034560)
    h2e[9, 7, 9, 3] = complex(0.000031672545, 0.000044456707)
    h2e[11, 7, 9, 3] = complex(-0.017717091117, -0.009326308501)
    h2e[1, 7, 11, 3] = complex(-0.000005493702, 0.000002863496)
    h2e[3, 7, 11, 3] = complex(0.000004450380, 0.000000653435)
    h2e[5, 7, 11, 3] = complex(-0.000253349435, -0.000001005177)
    h2e[7, 7, 11, 3] = complex(-0.104503201302, -0.000169759811)
    h2e[9, 7, 11, 3] = complex(-0.000000018963, -0.000000009982)
    h2e[11, 7, 11, 3] = complex(0.000172851675, -0.000004153811)
    h2e[1, 9, 1, 3] = complex(-0.000000350757, 0.000000224628)
    h2e[3, 9, 1, 3] = complex(0.000000242669, -0.000000209320)
    h2e[5, 9, 1, 3] = complex(0.000000124329, -0.000000101642)
    h2e[9, 9, 1, 3] = complex(-0.001606318802, 0.000065575519)
    h2e[11, 9, 1, 3] = complex(-0.000000010701, 0.000000032407)
    h2e[9, 9, 3, 3] = complex(0.652877324639, 0.000000000000)
    h2e[1, 9, 5, 3] = complex(0.000012423996, -0.000010156903)
    h2e[3, 9, 5, 3] = complex(0.000139068227, -0.000068083645)
    h2e[5, 9, 5, 3] = complex(0.000050364180, -0.000024410695)
    h2e[7, 9, 5, 3] = complex(-0.000000133136, 0.000000059888)
    h2e[9, 9, 5, 3] = complex(0.067629919819, -0.000013048915)
    h2e[11, 9, 5, 3] = complex(-0.000045203859, 0.000023108323)
    h2e[1, 9, 7, 3] = complex(0.004238984654, -0.004863292120)
    h2e[3, 9, 7, 3] = complex(0.054616978070, -0.025189499012)
    h2e[5, 9, 7, 3] = complex(0.019339467734, -0.008699392874)
    h2e[7, 9, 7, 3] = complex(-0.000051631273, 0.000021442539)
    h2e[9, 9, 7, 3] = complex(-0.000218946480, -0.000000276923)
    h2e[11, 9, 7, 3] = complex(-0.017858713000, 0.009202202430)
    h2e[1, 9, 9, 3] = complex(0.002011602423, -0.002090758480)
    h2e[3, 9, 9, 3] = complex(0.062888762713, 0.000000000000)
    h2e[5, 9, 9, 3] = complex(0.022561213593, 0.000182279773)
    h2e[7, 9, 9, 3] = complex(-0.000062897524, -0.000000592219)
    h2e[11, 9, 9, 3] = complex(-0.019204591633, 0.000821846205)
    h2e[1, 9, 11, 3] = complex(-0.000000188681, 0.000000571395)
    h2e[3, 9, 11, 3] = complex(-0.000021772023, 0.000011259938)
    h2e[5, 9, 11, 3] = complex(-0.000007214358, 0.000003687998)
    h2e[7, 9, 11, 3] = complex(0.000000019115, -0.000000009849)
    h2e[9, 9, 11, 3] = complex(-0.104501710142, -0.000169757389)
    h2e[11, 9, 11, 3] = complex(0.000007020260, -0.000003861883)
    h2e[1, 11, 1, 3] = complex(-0.001522317359, 0.000193110586)
    h2e[3, 11, 1, 3] = complex(0.000538400283, -0.000022855483)
    h2e[5, 11, 1, 3] = complex(-0.000654571386, 0.000027760025)
    h2e[7, 11, 1, 3] = complex(0.000001672377, -0.000000009402)
    h2e[9, 11, 1, 3] = complex(0.000000014495, 0.000000031738)
    h2e[11, 11, 1, 3] = complex(-0.001064961868, 0.000043475447)
    h2e[1, 11, 3, 3] = complex(-0.001630334179, 0.000139534344)
    h2e[3, 11, 3, 3] = complex(-0.092407510398, 0.000150111014)
    h2e[5, 11, 3, 3] = complex(0.058557914949, -0.000092712931)
    h2e[7, 11, 3, 3] = complex(-0.000172766481, -0.000004712788)
    h2e[11, 11, 3, 3] = complex(0.600972926148, -0.000000000000)
    h2e[1, 11, 5, 3] = complex(0.008439681402, -0.000723962028)
    h2e[3, 11, 5, 3] = complex(0.003003719245, -0.000005458995)
    h2e[5, 11, 5, 3] = complex(0.091821657332, -0.000163094965)
    h2e[7, 11, 5, 3] = complex(-0.000231971889, -0.000009113328)
    h2e[9, 11, 5, 3] = complex(0.000045214059, 0.000023114431)
    h2e[11, 11, 5, 3] = complex(-0.076272413760, 0.000014716449)
    h2e[1, 11, 7, 3] = complex(-0.000017696106, 0.000000723828)
    h2e[3, 11, 7, 3] = complex(0.000004450380, -0.000000653435)
    h2e[5, 11, 7, 3] = complex(-0.000218347085, 0.000000981474)
    h2e[7, 11, 7, 3] = complex(0.018903442147, -0.000175258307)
    h2e[9, 11, 7, 3] = complex(0.017676401582, 0.008937308615)
    h2e[11, 11, 7, 3] = complex(0.000184782601, 0.000000233714)
    h2e[1, 11, 9, 3] = complex(-0.000000422414, -0.000000924878)
    h2e[3, 11, 9, 3] = complex(-0.000021772023, -0.000011259938)
    h2e[5, 11, 9, 3] = complex(0.000037603508, 0.000019223747)
    h2e[7, 11, 9, 3] = complex(0.017676385038, 0.008937300220)
    h2e[9, 11, 9, 3] = complex(0.011003353841, 0.015457323332)
    h2e[1, 11, 11, 3] = complex(0.004857442834, -0.000407783361)
    h2e[3, 11, 11, 3] = complex(0.086507035699, -0.000000000000)
    h2e[5, 11, 11, 3] = complex(-0.052538914800, -0.000002163367)
    h2e[7, 11, 11, 3] = complex(0.000155828613, 0.000004749695)
    h2e[9, 11, 11, 3] = complex(-0.000007003579, -0.000003858191)
    h2e[11, 11, 11, 3] = complex(-0.033401934740, -0.000054259641)
    h2e[1, 1, 1, 5] = complex(-0.016278429618, 0.000175472749)
    h2e[3, 1, 1, 5] = complex(0.000316281223, 0.000009498212)
    h2e[5, 1, 1, 5] = complex(0.000199464539, -0.000000000000)
    h2e[7, 1, 1, 5] = complex(0.000025003669, -0.000000553412)
    h2e[9, 1, 1, 5] = complex(-0.000019139743, -0.000008736247)
    h2e[11, 1, 1, 5] = complex(0.000141239546, 0.000010557161)
    h2e[1, 1, 3, 5] = complex(0.127196685084, 0.000024542078)
    h2e[3, 1, 3, 5] = complex(-0.001272890704, -0.000052209839)
    h2e[5, 1, 3, 5] = complex(0.001241525064, 0.000013623365)
    h2e[7, 1, 3, 5] = complex(0.000003423085, -0.000005490953)
    h2e[9, 1, 3, 5] = complex(0.000012423996, 0.000010156903)
    h2e[11, 1, 3, 5] = complex(0.008439681402, 0.000723962028)
    h2e[1, 1, 5, 5] = complex(0.798772089110, -0.000000000000)
    h2e[3, 1, 5, 5] = complex(-0.001519877541, -0.000062046686)
    h2e[5, 1, 5, 5] = complex(0.000492588526, 0.000005309840)
    h2e[7, 1, 5, 5] = complex(-0.000001040911, -0.000001072279)
    h2e[11, 1, 5, 5] = complex(0.005862208618, 0.000501725012)
    h2e[1, 1, 7, 5] = complex(0.000546884185, -0.000001923925)
    h2e[3, 1, 7, 5] = complex(-0.000000898662, -0.000000001997)
    h2e[5, 1, 7, 5] = complex(-0.000003416956, -0.000001346327)
    h2e[7, 1, 7, 5] = complex(-0.000587843788, -0.000030645173)
    h2e[9, 1, 7, 5] = complex(-0.002604245715, -0.001452351868)
    h2e[11, 1, 7, 5] = complex(-0.000009168235, -0.000000478248)
    h2e[3, 1, 9, 5] = complex(0.000000124329, 0.000000101642)
    h2e[5, 1, 9, 5] = complex(-0.000005554299, -0.000004396287)
    h2e[7, 1, 9, 5] = complex(-0.002603042870, -0.001451681026)
    h2e[9, 1, 9, 5] = complex(-0.000312560384, -0.000501576199)
    h2e[11, 1, 9, 5] = complex(0.000000354406, 0.000000458112)
    h2e[1, 1, 11, 5] = complex(0.213867894708, 0.000338610404)
    h2e[3, 1, 11, 5] = complex(-0.000654571386, -0.000027760025)
    h2e[5, 1, 11, 5] = complex(0.000344485003, 0.000004257945)
    h2e[7, 1, 11, 5] = complex(-0.000005427294, -0.000000345943)
    h2e[9, 1, 11, 5] = complex(-0.000001032762, -0.000001334969)
    h2e[11, 1, 11, 5] = complex(0.003215888374, 0.000280365730)
    h2e[1, 3, 1, 5] = complex(0.000316005242, -0.000016314073)
    h2e[3, 3, 1, 5] = complex(-0.001350358560, 0.000014556142)
    h2e[5, 3, 1, 5] = complex(0.001241525064, -0.000013623365)
    h2e[7, 3, 1, 5] = complex(0.000002441689, 0.000002496922)
    h2e[9, 3, 1, 5] = complex(0.000012269024, 0.000007685585)
    h2e[11, 3, 1, 5] = complex(0.001391891127, -0.000012742378)
    h2e[1, 3, 3, 5] = complex(-0.001272910336, 0.000051718618)
    h2e[3, 3, 3, 5] = complex(-0.013796280764, -0.000002661936)
    h2e[5, 3, 3, 5] = complex(0.128327582473, -0.000000000000)
    h2e[7, 3, 3, 5] = complex(-0.000170731174, -0.000001050474)
    h2e[9, 3, 3, 5] = complex(0.000139068227, 0.000068083645)
    h2e[11, 3, 3, 5] = complex(0.003003719245, 0.000005458995)
    h2e[1, 3, 5, 5] = complex(-0.001519877541, 0.000062046686)
    h2e[3, 3, 5, 5] = complex(0.587292582647, 0.000000000000)
    h2e[5, 3, 5, 5] = complex(0.042211019244, -0.000008144443)
    h2e[7, 3, 5, 5] = complex(-0.000114630482, -0.000000144984)
    h2e[11, 3, 5, 5] = complex(-0.016168008881, -0.000026264058)
    h2e[1, 3, 7, 5] = complex(-0.000000922738, 0.000000008505)
    h2e[3, 3, 7, 5] = complex(0.000191253574, -0.000000672825)
    h2e[5, 3, 7, 5] = complex(0.000053583529, -0.000000512951)
    h2e[7, 3, 7, 5] = complex(-0.022250889318, 0.000182163230)
    h2e[9, 3, 7, 5] = complex(-0.018570712767, -0.009624367334)
    h2e[11, 3, 7, 5] = complex(-0.000238564722, 0.000000718014)
    h2e[1, 3, 9, 5] = complex(-0.000000136299, -0.000000085381)
    h2e[5, 3, 9, 5] = complex(-0.000050400480, -0.000024364699)
    h2e[7, 3, 9, 5] = complex(-0.018570586861, -0.009624302076)
    h2e[9, 3, 9, 5] = complex(-0.012931962374, -0.018208416547)
    h2e[11, 3, 9, 5] = complex(0.000007171416, 0.000003744086)
    h2e[1, 3, 11, 5] = complex(-0.000654656458, 0.000025687193)
    h2e[3, 3, 11, 5] = complex(0.058557914949, 0.000092712931)
    h2e[5, 3, 11, 5] = complex(0.091821509829, 0.000127661653)
    h2e[7, 3, 11, 5] = complex(-0.000298789830, -0.000001673986)
    h2e[9, 3, 11, 5] = complex(-0.000037371241, -0.000019510954)
    h2e[11, 3, 11, 5] = complex(-0.052538607424, -0.000168529211)
    h2e[1, 5, 1, 5] = complex(0.000199300973, -0.000004290601)
    h2e[3, 5, 1, 5] = complex(0.001241503535, -0.000013142595)
    h2e[5, 5, 1, 5] = complex(0.000492588526, -0.000005309840)
    h2e[7, 5, 1, 5] = complex(-0.000000808932, 0.000001205576)
    h2e[9, 5, 1, 5] = complex(0.000006086173, 0.000003629728)
    h2e[11, 5, 1, 5] = complex(0.000344518509, -0.000003168498)
    h2e[1, 5, 3, 5] = complex(0.001241503535, -0.000013142595)
    h2e[3, 5, 3, 5] = complex(0.128326736337, 0.000049520399)
    h2e[5, 5, 3, 5] = complex(0.042211019244, 0.000008144443)
    h2e[7, 5, 3, 5] = complex(0.000172427118, -0.000000293227)
    h2e[9, 5, 3, 5] = complex(0.000050364180, 0.000024410695)
    h2e[11, 5, 3, 5] = complex(0.091821657332, 0.000163094965)
    h2e[1, 5, 5, 5] = complex(0.000492588526, -0.000005309840)
    h2e[3, 5, 5, 5] = complex(0.042211019244, 0.000008144443)
    h2e[5, 5, 5, 5] = complex(0.632865022924, -0.000000000000)
    h2e[7, 5, 5, 5] = complex(-0.000050950917, 0.000000179245)
    h2e[11, 5, 5, 5] = complex(0.070498980338, 0.000111618849)
    h2e[1, 5, 7, 5] = complex(-0.000000808932, 0.000001205576)
    h2e[3, 5, 7, 5] = complex(0.000172427118, -0.000000293227)
    h2e[5, 5, 7, 5] = complex(-0.000050950917, 0.000000179245)
    h2e[7, 5, 7, 5] = complex(-0.022825315477, 0.000188756808)
    h2e[9, 5, 7, 5] = complex(-0.018570457657, -0.009662675034)
    h2e[11, 5, 7, 5] = complex(0.000175165546, 0.000000066648)
    h2e[1, 5, 9, 5] = complex(0.000006086173, 0.000003629728)
    h2e[3, 5, 9, 5] = complex(0.000050364180, 0.000024410695)
    h2e[7, 5, 9, 5] = complex(-0.018570457657, -0.009662675034)
    h2e[9, 5, 9, 5] = complex(-0.013268841670, -0.018679476994)
    h2e[11, 5, 9, 5] = complex(0.000012624967, 0.000006537902)
    h2e[1, 5, 11, 5] = complex(0.000344518509, -0.000003168498)
    h2e[3, 5, 11, 5] = complex(0.091821657332, 0.000163094965)
    h2e[5, 5, 11, 5] = complex(0.070498980338, 0.000111618849)
    h2e[7, 5, 11, 5] = complex(0.000175165546, 0.000000066648)
    h2e[9, 5, 11, 5] = complex(0.000012624967, 0.000006537902)
    h2e[11, 5, 11, 5] = complex(0.124452347910, 0.000394083502)
    h2e[1, 7, 1, 5] = complex(-0.000025696362, 0.000003791017)
    h2e[3, 7, 1, 5] = complex(-0.000007216539, 0.000003109267)
    h2e[5, 7, 1, 5] = complex(-0.000003416956, 0.000001346327)
    h2e[7, 7, 1, 5] = complex(-0.000455152758, 0.000004906303)
    h2e[9, 7, 1, 5] = complex(-0.000000015076, -0.000000012356)
    h2e[11, 7, 1, 5] = complex(0.000003654242, -0.000001007234)
    h2e[1, 7, 3, 5] = complex(-0.000008755426, -0.000000108021)
    h2e[3, 7, 3, 5] = complex(-0.000493943912, -0.000000205874)
    h2e[5, 7, 3, 5] = complex(0.000053583529, 0.000000512951)
    h2e[7, 7, 3, 5] = complex(0.067630245781, 0.000013048978)
    h2e[9, 7, 3, 5] = complex(-0.000000133136, -0.000000059888)
    h2e[11, 7, 3, 5] = complex(-0.000231971889, 0.000009113328)
    h2e[1, 7, 5, 5] = complex(-0.000001040911, 0.000001072279)
    h2e[3, 7, 5, 5] = complex(-0.000114630482, 0.000000144984)
    h2e[5, 7, 5, 5] = complex(-0.000050950917, -0.000000179245)
    h2e[7, 7, 5, 5] = complex(0.599470600128, -0.000000000000)
    h2e[11, 7, 5, 5] = complex(-0.000187393792, 0.000005111798)
    h2e[1, 7, 7, 5] = complex(0.000667647843, 0.001021656585)
    h2e[3, 7, 7, 5] = complex(0.022585317646, 0.000220621203)
    h2e[5, 7, 7, 5] = complex(0.023177158522, 0.000000000000)
    h2e[7, 7, 7, 5] = complex(0.000364225082, -0.000001281336)
    h2e[9, 7, 7, 5] = complex(0.000045859370, 0.000021864742)
    h2e[11, 7, 7, 5] = complex(0.002129926539, 0.000136139730)
    h2e[1, 7, 9, 5] = complex(0.002422386266, 0.001985443086)
    h2e[3, 7, 9, 5] = complex(0.019339467734, 0.008699392874)
    h2e[5, 7, 9, 5] = complex(0.019466239640, 0.008503349822)
    h2e[9, 7, 9, 5] = complex(0.000091033916, 0.000129104643)
    h2e[11, 7, 9, 5] = complex(0.002014852226, 0.001039507471)
    h2e[1, 7, 11, 5] = complex(0.000004004788, 0.000001412085)
    h2e[3, 7, 11, 5] = complex(-0.000218347085, -0.000000981474)
    h2e[5, 7, 11, 5] = complex(0.000148524257, 0.000001213653)
    h2e[7, 7, 11, 5] = complex(0.111275222184, 0.000176178608)
    h2e[9, 7, 11, 5] = complex(-0.000000024374, -0.000000012575)
    h2e[11, 7, 11, 5] = complex(-0.000404837776, 0.000008938319)
    h2e[1, 9, 1, 5] = complex(0.000017787619, -0.000011230943)
    h2e[3, 9, 1, 5] = complex(-0.000011150333, 0.000009222915)
    h2e[5, 9, 1, 5] = complex(-0.000005554299, 0.000004396287)
    h2e[7, 9, 1, 5] = complex(0.000000013308, -0.000000014222)
    h2e[9, 9, 1, 5] = complex(-0.000454979583, 0.000004904436)
    h2e[11, 9, 1, 5] = complex(0.000000992725, -0.000001678764)
    h2e[1, 9, 3, 5] = complex(-0.000012378275, 0.000010238598)
    h2e[3, 9, 3, 5] = complex(-0.000139156513, 0.000067981251)
    h2e[5, 9, 3, 5] = complex(-0.000050400480, 0.000024364699)
    h2e[7, 9, 3, 5] = complex(0.000000133264, -0.000000059782)
    h2e[9, 9, 3, 5] = complex(0.067629919819, 0.000013048915)
    h2e[11, 9, 3, 5] = complex(0.000045214059, -0.000023114431)
    h2e[9, 9, 5, 5] = complex(0.599463715832, -0.000000000000)
    h2e[1, 9, 7, 5] = complex(0.002139307371, -0.002286238907)
    h2e[3, 9, 7, 5] = complex(0.019358212716, -0.008684034560)
    h2e[5, 9, 7, 5] = complex(0.019466239640, -0.008503349822)
    h2e[7, 9, 7, 5] = complex(-0.000048797154, 0.000019333548)
    h2e[9, 9, 7, 5] = complex(0.000364229152, -0.000001281349)
    h2e[11, 9, 7, 5] = complex(0.002033231613, -0.001023070877)
    h2e[1, 9, 9, 5] = complex(0.000538151970, -0.000893959698)
    h2e[3, 9, 9, 5] = complex(0.022561213593, -0.000182279773)
    h2e[5, 9, 9, 5] = complex(0.023142194885, 0.000000000000)
    h2e[7, 9, 9, 5] = complex(0.000044849469, -0.000000330205)
    h2e[11, 9, 9, 5] = complex(0.002137668587, -0.000111242838)
    h2e[1, 9, 11, 5] = complex(0.000000914989, -0.000001547307)
    h2e[3, 9, 11, 5] = complex(0.000037603508, -0.000019223747)
    h2e[5, 9, 11, 5] = complex(-0.000012711547, 0.000006422908)
    h2e[7, 9, 11, 5] = complex(0.000000024595, -0.000000012376)
    h2e[9, 9, 11, 5] = complex(0.111272120430, 0.000176173697)
    h2e[11, 9, 11, 5] = complex(-0.000032552940, 0.000017674771)
    h2e[1, 11, 1, 5] = complex(0.000141011087, -0.000013601804)
    h2e[3, 11, 1, 5] = complex(0.001391853745, -0.000017265171)
    h2e[5, 11, 1, 5] = complex(0.000344485003, -0.000004257945)
    h2e[7, 11, 1, 5] = complex(-0.000006166822, -0.000000427156)
    h2e[9, 11, 1, 5] = complex(-0.000001202597, -0.000001544621)
    h2e[11, 11, 1, 5] = complex(-0.001422634196, 0.000015335234)
    h2e[1, 11, 3, 5] = complex(0.008439951675, -0.000720704022)
    h2e[3, 11, 3, 5] = complex(0.003003839896, -0.000004299899)
    h2e[5, 11, 3, 5] = complex(0.091821509829, -0.000127661653)
    h2e[7, 11, 3, 5] = complex(-0.000329014870, -0.000006230532)
    h2e[9, 11, 3, 5] = complex(-0.000045203859, -0.000023108323)
    h2e[11, 11, 3, 5] = complex(-0.076272413760, -0.000014716449)
    h2e[1, 11, 5, 5] = complex(0.005862208618, -0.000501725012)
    h2e[3, 11, 5, 5] = complex(-0.016168008881, 0.000026264058)
    h2e[5, 11, 5, 5] = complex(0.070498980338, -0.000111618849)
    h2e[7, 11, 5, 5] = complex(-0.000187393792, -0.000005111798)
    h2e[11, 11, 5, 5] = complex(0.574398690825, 0.000000000000)
    h2e[1, 11, 7, 5] = complex(-0.000007281292, 0.000000310774)
    h2e[3, 11, 7, 5] = complex(-0.000253349435, 0.000001005177)
    h2e[5, 11, 7, 5] = complex(0.000148524257, -0.000001213653)
    h2e[7, 11, 7, 5] = complex(-0.002103993400, 0.000016946521)
    h2e[9, 11, 7, 5] = complex(-0.002001827140, -0.001012770085)
    h2e[11, 11, 7, 5] = complex(-0.000072542815, 0.000000255204)
    h2e[1, 11, 9, 5] = complex(-0.000000380371, -0.000000488551)
    h2e[3, 11, 9, 5] = complex(-0.000007214358, -0.000003687998)
    h2e[5, 11, 9, 5] = complex(-0.000012711547, -0.000006422908)
    h2e[7, 11, 9, 5] = complex(-0.002001698107, -0.001012704801)
    h2e[9, 11, 9, 5] = complex(-0.001222989435, -0.001722440638)
    h2e[1, 11, 11, 5] = complex(0.003216758836, -0.000270181193)
    h2e[3, 11, 11, 5] = complex(-0.052538914800, 0.000002163367)
    h2e[5, 11, 11, 5] = complex(0.124453179368, -0.000000000000)
    h2e[7, 11, 11, 5] = complex(-0.000327535595, -0.000010709234)
    h2e[9, 11, 11, 5] = complex(0.000032461227, 0.000017670997)
    h2e[11, 11, 11, 5] = complex(-0.025653771935, -0.000040616821)
    h2e[1, 1, 1, 7] = complex(0.000037256617, -0.000038379333)
    h2e[3, 1, 1, 7] = complex(-0.000001241324, 0.000000718564)
    h2e[5, 1, 1, 7] = complex(0.000025003669, 0.000000553412)
    h2e[7, 1, 1, 7] = complex(0.011110479287, 0.000000000000)
    h2e[9, 1, 1, 7] = complex(-0.008535060179, -0.003328921117)
    h2e[11, 1, 1, 7] = complex(-0.000007320408, 0.000000507920)
    h2e[1, 1, 3, 7] = complex(-0.000413324188, 0.000000522774)
    h2e[3, 1, 3, 7] = complex(0.000003359240, 0.000000203022)
    h2e[5, 1, 3, 7] = complex(0.000002441689, -0.000002496922)
    h2e[7, 1, 3, 7] = complex(0.002304041568, -0.002232755924)
    h2e[9, 1, 3, 7] = complex(0.004238984654, 0.004863292120)
    h2e[11, 1, 3, 7] = complex(-0.000017696106, -0.000000723828)
    h2e[1, 1, 5, 7] = complex(0.000546884185, 0.000001923925)
    h2e[3, 1, 5, 7] = complex(-0.000000922738, -0.000000008505)
    h2e[5, 1, 5, 7] = complex(-0.000000808932, -0.000001205576)
    h2e[7, 1, 5, 7] = complex(0.000667647843, -0.001021656585)
    h2e[9, 1, 5, 7] = complex(0.002139307371, 0.002286238907)
    h2e[11, 1, 5, 7] = complex(-0.000007281292, -0.000000310774)
    h2e[1, 1, 7, 7] = complex(0.966780087765, 0.000000000000)
    h2e[3, 1, 7, 7] = complex(-0.001606930608, -0.000065600495)
    h2e[5, 1, 7, 7] = complex(-0.000455152758, -0.000004906303)
    h2e[7, 1, 7, 7] = complex(0.000001018896, 0.000001049599)
    h2e[11, 1, 7, 7] = complex(0.001598968882, 0.000136849903)
    h2e[5, 1, 9, 7] = complex(0.000000013308, 0.000000014222)
    h2e[7, 1, 9, 7] = complex(0.000006257870, 0.000004909550)
    h2e[9, 1, 9, 7] = complex(0.000001937905, 0.000000497051)
    h2e[11, 1, 9, 7] = complex(-0.000000000562, -0.000000001937)
    h2e[1, 1, 11, 7] = complex(-0.000604236288, 0.000016482583)
    h2e[3, 1, 11, 7] = complex(0.000001672377, 0.000000009402)
    h2e[5, 1, 11, 7] = complex(-0.000006166822, 0.000000427156)
    h2e[7, 1, 11, 7] = complex(-0.002161730679, 0.000552354206)
    h2e[9, 1, 11, 7] = complex(-0.000285967605, -0.000986116435)
    h2e[11, 1, 11, 7] = complex(-0.000009170656, -0.000000771996)
    h2e[1, 3, 1, 7] = complex(-0.000000214327, 0.000000711471)
    h2e[3, 3, 1, 7] = complex(0.000002985010, -0.000003074962)
    h2e[5, 3, 1, 7] = complex(0.000003423085, 0.000005490953)
    h2e[7, 3, 1, 7] = complex(0.002304041568, 0.002232755924)
    h2e[9, 3, 1, 7] = complex(0.004831733589, 0.004300169281)
    h2e[11, 3, 1, 7] = complex(-0.000005493702, 0.000002863496)
    h2e[1, 3, 3, 7] = complex(0.000003507841, -0.000000218304)
    h2e[3, 3, 3, 7] = complex(-0.000001061503, 0.000000001342)
    h2e[5, 3, 3, 7] = complex(-0.000170731174, 0.000001050474)
    h2e[7, 3, 3, 7] = complex(0.062928655211, 0.000000000000)
    h2e[9, 3, 3, 7] = complex(0.054616978070, 0.025189499012)
    h2e[11, 3, 3, 7] = complex(0.000004450380, 0.000000653435)
    h2e[1, 3, 5, 7] = complex(-0.000000898662, 0.000000001997)
    h2e[3, 3, 5, 7] = complex(0.000191253574, 0.000000672825)
    h2e[5, 3, 5, 7] = complex(0.000172427118, 0.000000293227)
    h2e[7, 3, 5, 7] = complex(0.022585317646, -0.000220621203)
    h2e[9, 3, 5, 7] = complex(0.019358212716, 0.008684034560)
    h2e[11, 3, 5, 7] = complex(-0.000253349435, -0.000001005177)
    h2e[1, 3, 7, 7] = complex(-0.001606930608, 0.000065600495)
    h2e[3, 3, 7, 7] = complex(0.652882649491, -0.000000000000)
    h2e[5, 3, 7, 7] = complex(0.067630245781, -0.000013048978)
    h2e[7, 3, 7, 7] = complex(-0.000218947889, -0.000000276928)
    h2e[11, 3, 7, 7] = complex(-0.104503201302, -0.000169759811)
    h2e[5, 3, 9, 7] = complex(0.000000133264, 0.000000059782)
    h2e[7, 3, 9, 7] = complex(0.000048844477, 0.000023538508)
    h2e[9, 3, 9, 7] = complex(0.000031672545, 0.000044456707)
    h2e[11, 3, 9, 7] = complex(-0.000000018963, -0.000000009982)
    h2e[1, 3, 11, 7] = complex(0.000001459747, -0.000000081791)
    h2e[3, 3, 11, 7] = complex(-0.000172766481, 0.000004712788)
    h2e[5, 3, 11, 7] = complex(-0.000329014870, 0.000006230532)
    h2e[7, 3, 11, 7] = complex(-0.019142422040, -0.001019561044)
    h2e[9, 3, 11, 7] = complex(-0.017717091117, -0.009326308501)
    h2e[11, 3, 11, 7] = complex(0.000172851675, -0.000004153811)
    h2e[1, 5, 1, 7] = complex(-0.000025696362, 0.000003791017)
    h2e[3, 5, 1, 7] = complex(-0.000008755426, -0.000000108021)
    h2e[5, 5, 1, 7] = complex(-0.000001040911, 0.000001072279)
    h2e[7, 5, 1, 7] = complex(0.000667647843, 0.001021656585)
    h2e[9, 5, 1, 7] = complex(0.002422386266, 0.001985443086)
    h2e[11, 5, 1, 7] = complex(0.000004004788, 0.000001412085)
    h2e[1, 5, 3, 7] = complex(-0.000007216539, 0.000003109267)
    h2e[3, 5, 3, 7] = complex(-0.000493943912, -0.000000205874)
    h2e[5, 5, 3, 7] = complex(-0.000114630482, 0.000000144984)
    h2e[7, 5, 3, 7] = complex(0.022585317646, 0.000220621203)
    h2e[9, 5, 3, 7] = complex(0.019339467734, 0.008699392874)
    h2e[11, 5, 3, 7] = complex(-0.000218347085, -0.000000981474)
    h2e[1, 5, 5, 7] = complex(-0.000003416956, 0.000001346327)
    h2e[3, 5, 5, 7] = complex(0.000053583529, 0.000000512951)
    h2e[5, 5, 5, 7] = complex(-0.000050950917, -0.000000179245)
    h2e[7, 5, 5, 7] = complex(0.023177158522, 0.000000000000)
    h2e[9, 5, 5, 7] = complex(0.019466239640, 0.008503349822)
    h2e[11, 5, 5, 7] = complex(0.000148524257, 0.000001213653)
    h2e[1, 5, 7, 7] = complex(-0.000455152758, 0.000004906303)
    h2e[3, 5, 7, 7] = complex(0.067630245781, 0.000013048978)
    h2e[5, 5, 7, 7] = complex(0.599470600128, -0.000000000000)
    h2e[7, 5, 7, 7] = complex(0.000364225082, -0.000001281336)
    h2e[11, 5, 7, 7] = complex(0.111275222184, 0.000176178608)
    h2e[1, 5, 9, 7] = complex(-0.000000015076, -0.000000012356)
    h2e[3, 5, 9, 7] = complex(-0.000000133136, -0.000000059888)
    h2e[7, 5, 9, 7] = complex(0.000045859370, 0.000021864742)
    h2e[9, 5, 9, 7] = complex(0.000091033916, 0.000129104643)
    h2e[11, 5, 9, 7] = complex(-0.000000024374, -0.000000012575)
    h2e[1, 5, 11, 7] = complex(0.000003654242, -0.000001007234)
    h2e[3, 5, 11, 7] = complex(-0.000231971889, 0.000009113328)
    h2e[5, 5, 11, 7] = complex(-0.000187393792, 0.000005111798)
    h2e[7, 5, 11, 7] = complex(0.002129926539, 0.000136139730)
    h2e[9, 5, 11, 7] = complex(0.002014852226, 0.001039507471)
    h2e[11, 5, 11, 7] = complex(-0.000404837776, 0.000008938319)
    h2e[1, 7, 1, 7] = complex(-0.010854302156, 0.001372979778)
    h2e[3, 7, 1, 7] = complex(-0.002115204929, 0.000096281168)
    h2e[5, 7, 1, 7] = complex(-0.000587843788, 0.000030645173)
    h2e[7, 7, 1, 7] = complex(0.000001018896, -0.000001049599)
    h2e[9, 7, 1, 7] = complex(-0.000006029001, -0.000006419549)
    h2e[11, 7, 1, 7] = complex(0.002089143695, -0.000058078098)
    h2e[1, 7, 3, 7] = complex(-0.002115204929, 0.000096281168)
    h2e[3, 7, 3, 7] = complex(-0.062007759238, -0.000512514791)
    h2e[5, 7, 3, 7] = complex(-0.022250889318, -0.000182163230)
    h2e[7, 7, 3, 7] = complex(-0.000218947889, 0.000000276928)
    h2e[9, 7, 3, 7] = complex(-0.000051631273, -0.000021442539)
    h2e[11, 7, 3, 7] = complex(0.018903442147, 0.000175258307)
    h2e[1, 7, 5, 7] = complex(-0.000587843788, 0.000030645173)
    h2e[3, 7, 5, 7] = complex(-0.022250889318, -0.000182163230)
    h2e[5, 7, 5, 7] = complex(-0.022825315477, -0.000188756808)
    h2e[7, 7, 5, 7] = complex(0.000364225082, 0.000001281336)
    h2e[9, 7, 5, 7] = complex(-0.000048797154, -0.000019333548)
    h2e[11, 7, 5, 7] = complex(-0.002103993400, -0.000016946521)
    h2e[1, 7, 7, 7] = complex(0.000001018896, -0.000001049599)
    h2e[3, 7, 7, 7] = complex(-0.000218947889, 0.000000276928)
    h2e[5, 7, 7, 7] = complex(0.000364225082, 0.000001281336)
    h2e[7, 7, 7, 7] = complex(0.721692913237, 0.000000000000)
    h2e[11, 7, 7, 7] = complex(-0.000346447461, 0.000009450523)
    h2e[1, 7, 9, 7] = complex(-0.000006029001, -0.000006419549)
    h2e[3, 7, 9, 7] = complex(-0.000051631273, -0.000021442539)
    h2e[5, 7, 9, 7] = complex(-0.000048797154, -0.000019333548)
    h2e[9, 7, 9, 7] = complex(0.022946279221, 0.032875564569)
    h2e[11, 7, 9, 7] = complex(-0.000002372107, -0.000001215790)
    h2e[1, 7, 11, 7] = complex(0.002089143695, -0.000058078098)
    h2e[3, 7, 11, 7] = complex(0.018903442147, 0.000175258307)
    h2e[5, 7, 11, 7] = complex(-0.002103993400, -0.000016946521)
    h2e[7, 7, 11, 7] = complex(-0.000346447461, 0.000009450523)
    h2e[9, 7, 11, 7] = complex(-0.000002372107, -0.000001215790)
    h2e[11, 7, 11, 7] = complex(-0.014749622025, -0.000249979167)
    h2e[1, 9, 1, 7] = complex(0.007327228045, -0.005220542358)
    h2e[3, 9, 1, 7] = complex(-0.005313958966, 0.002951828258)
    h2e[5, 9, 1, 7] = complex(-0.002603042870, 0.001451681026)
    h2e[7, 9, 1, 7] = complex(0.000006257870, -0.000004909550)
    h2e[9, 9, 1, 7] = complex(0.000001018499, -0.000001049191)
    h2e[11, 9, 1, 7] = complex(0.000659332079, -0.000363255317)
    h2e[1, 9, 3, 7] = complex(-0.005316308523, 0.002953133477)
    h2e[3, 9, 3, 7] = complex(-0.052722849229, 0.027230005494)
    h2e[5, 9, 3, 7] = complex(-0.018570586861, 0.009624302076)
    h2e[7, 9, 3, 7] = complex(0.000048844477, -0.000023538508)
    h2e[9, 9, 3, 7] = complex(-0.000218946480, 0.000000276923)
    h2e[11, 9, 3, 7] = complex(0.017676401582, -0.008937308615)
    h2e[1, 9, 5, 7] = complex(-0.002604245715, 0.001452351868)
    h2e[3, 9, 5, 7] = complex(-0.018570712767, 0.009624367334)
    h2e[5, 9, 5, 7] = complex(-0.018570457657, 0.009662675034)
    h2e[7, 9, 5, 7] = complex(0.000045859370, -0.000021864742)
    h2e[9, 9, 5, 7] = complex(0.000364229152, 0.000001281349)
    h2e[11, 9, 5, 7] = complex(-0.002001827140, 0.001012770085)
    h2e[9, 9, 7, 7] = complex(0.721688265776, 0.000000000000)
    h2e[1, 9, 9, 7] = complex(-0.000001225832, 0.000003727934)
    h2e[3, 9, 9, 7] = complex(-0.000062897524, 0.000000592219)
    h2e[5, 9, 9, 7] = complex(0.000044849469, 0.000000330205)
    h2e[7, 9, 9, 7] = complex(0.040103033684, 0.000000000000)
    h2e[11, 9, 9, 7] = complex(-0.000017433593, -0.000000213412)
    h2e[1, 9, 11, 7] = complex(0.000659640860, -0.000363425462)
    h2e[3, 9, 11, 7] = complex(0.017676385038, -0.008937300220)
    h2e[5, 9, 11, 7] = complex(-0.002001698107, 0.001012704801)
    h2e[7, 9, 11, 7] = complex(0.000002325124, -0.000001171211)
    h2e[9, 9, 11, 7] = complex(-0.000346440707, 0.000009450339)
    h2e[11, 9, 11, 7] = complex(-0.012637470089, 0.006358613435)
    h2e[1, 11, 1, 7] = complex(0.000006574844, -0.000000770271)
    h2e[3, 11, 1, 7] = complex(-0.000000622063, 0.000003314805)
    h2e[5, 11, 1, 7] = complex(-0.000005427294, 0.000000345943)
    h2e[7, 11, 1, 7] = complex(-0.002161730679, -0.000552354206)
    h2e[9, 11, 1, 7] = complex(-0.000376644737, -0.001049940944)
    h2e[11, 11, 1, 7] = complex(0.000003111333, -0.000003205092)
    h2e[1, 11, 3, 7] = complex(-0.000020999314, 0.000001214160)
    h2e[3, 11, 3, 7] = complex(0.000050317194, -0.000000733312)
    h2e[5, 11, 3, 7] = complex(-0.000298789830, 0.000001673986)
    h2e[7, 11, 3, 7] = complex(-0.019142422040, 0.001019561044)
    h2e[9, 11, 3, 7] = complex(-0.017858713000, -0.009202202430)
    h2e[11, 11, 3, 7] = complex(0.000184782601, -0.000000233714)
    h2e[1, 11, 5, 7] = complex(-0.000009168235, 0.000000478248)
    h2e[3, 11, 5, 7] = complex(-0.000238564722, -0.000000718014)
    h2e[5, 11, 5, 7] = complex(0.000175165546, -0.000000066648)
    h2e[7, 11, 5, 7] = complex(0.002129926539, -0.000136139730)
    h2e[9, 11, 5, 7] = complex(0.002033231613, 0.001023070877)
    h2e[11, 11, 5, 7] = complex(-0.000072542815, -0.000000255204)
    h2e[1, 11, 7, 7] = complex(0.001598968882, -0.000136849903)
    h2e[3, 11, 7, 7] = complex(-0.104503201302, 0.000169759811)
    h2e[5, 11, 7, 7] = complex(0.111275222184, -0.000176178608)
    h2e[7, 11, 7, 7] = complex(-0.000346447461, -0.000009450523)
    h2e[11, 11, 7, 7] = complex(0.551545232677, -0.000000000000)
    h2e[1, 11, 9, 7] = complex(0.000000000740, 0.000000002063)
    h2e[3, 11, 9, 7] = complex(0.000000019115, 0.000000009849)
    h2e[5, 11, 9, 7] = complex(0.000000024595, 0.000000012376)
    h2e[7, 11, 9, 7] = complex(0.000002325124, 0.000001171211)
    h2e[9, 11, 9, 7] = complex(-0.000007531629, -0.000009986426)
    h2e[1, 11, 11, 7] = complex(-0.000009632709, 0.000001250031)
    h2e[3, 11, 11, 7] = complex(0.000155828613, -0.000004749695)
    h2e[5, 11, 11, 7] = complex(-0.000327535595, 0.000010709234)
    h2e[7, 11, 11, 7] = complex(0.014920294439, 0.000000000000)
    h2e[9, 11, 11, 7] = complex(0.012385855642, 0.007225665254)
    h2e[11, 11, 11, 7] = complex(0.000103001333, -0.000002809709)
    h2e[3, 1, 1, 9] = complex(0.000000378222, -0.000000174850)
    h2e[5, 1, 1, 9] = complex(-0.000019139743, 0.000008736247)
    h2e[7, 1, 1, 9] = complex(-0.008535060179, 0.003328921117)
    h2e[9, 1, 1, 9] = complex(0.011100485424, 0.000000000000)
    h2e[11, 1, 1, 9] = complex(0.000006509613, -0.000003155518)
    h2e[3, 1, 3, 9] = complex(-0.000000267299, 0.000000177942)
    h2e[5, 1, 3, 9] = complex(0.000012269024, -0.000007685585)
    h2e[7, 1, 3, 9] = complex(0.004831733589, -0.004300169281)
    h2e[9, 1, 3, 9] = complex(0.002011602423, 0.002090758480)
    h2e[11, 1, 3, 9] = complex(-0.000000422414, 0.000000924878)
    h2e[3, 1, 5, 9] = complex(-0.000000136299, 0.000000085381)
    h2e[5, 1, 5, 9] = complex(0.000006086173, -0.000003629728)
    h2e[7, 1, 5, 9] = complex(0.002422386266, -0.001985443086)
    h2e[9, 1, 5, 9] = complex(0.000538151970, 0.000893959698)
    h2e[11, 1, 5, 9] = complex(-0.000000380371, 0.000000488551)
    h2e[5, 1, 7, 9] = complex(-0.000000015076, 0.000000012356)
    h2e[7, 1, 7, 9] = complex(-0.000006029001, 0.000006419549)
    h2e[9, 1, 7, 9] = complex(-0.000001225832, -0.000003727934)
    h2e[11, 1, 7, 9] = complex(0.000000000740, -0.000000002063)
    h2e[1, 1, 9, 9] = complex(0.966731902319, 0.000000000000)
    h2e[3, 1, 9, 9] = complex(-0.001606318802, -0.000065575519)
    h2e[5, 1, 9, 9] = complex(-0.000454979583, -0.000004904436)
    h2e[7, 1, 9, 9] = complex(0.000001018499, 0.000001049191)
    h2e[11, 1, 9, 9] = complex(0.001598266472, 0.000136789787)
    h2e[3, 1, 11, 9] = complex(0.000000014495, -0.000000031738)
    h2e[5, 1, 11, 9] = complex(-0.000001202597, 0.000001544621)
    h2e[7, 1, 11, 9] = complex(-0.000376644737, 0.001049940944)
    h2e[9, 1, 11, 9] = complex(-0.002069159539, -0.000813617799)
    h2e[11, 1, 11, 9] = complex(-0.000000624339, -0.000000019459)
    h2e[1, 3, 1, 9] = complex(-0.000000350757, 0.000000224628)
    h2e[5, 3, 1, 9] = complex(0.000012423996, -0.000010156903)
    h2e[7, 3, 1, 9] = complex(0.004238984654, -0.004863292120)
    h2e[9, 3, 1, 9] = complex(0.002011602423, -0.002090758480)
    h2e[11, 3, 1, 9] = complex(-0.000000188681, 0.000000571395)
    h2e[1, 3, 3, 9] = complex(0.000000242669, -0.000000209320)
    h2e[5, 3, 3, 9] = complex(0.000139068227, -0.000068083645)
    h2e[7, 3, 3, 9] = complex(0.054616978070, -0.025189499012)
    h2e[9, 3, 3, 9] = complex(0.062888762713, 0.000000000000)
    h2e[11, 3, 3, 9] = complex(-0.000021772023, 0.000011259938)
    h2e[1, 3, 5, 9] = complex(0.000000124329, -0.000000101642)
    h2e[5, 3, 5, 9] = complex(0.000050364180, -0.000024410695)
    h2e[7, 3, 5, 9] = complex(0.019339467734, -0.008699392874)
    h2e[9, 3, 5, 9] = complex(0.022561213593, 0.000182279773)
    h2e[11, 3, 5, 9] = complex(-0.000007214358, 0.000003687998)
    h2e[5, 3, 7, 9] = complex(-0.000000133136, 0.000000059888)
    h2e[7, 3, 7, 9] = complex(-0.000051631273, 0.000021442539)
    h2e[9, 3, 7, 9] = complex(-0.000062897524, -0.000000592219)
    h2e[11, 3, 7, 9] = complex(0.000000019115, -0.000000009849)
    h2e[1, 3, 9, 9] = complex(-0.001606318802, 0.000065575519)
    h2e[3, 3, 9, 9] = complex(0.652877324639, 0.000000000000)
    h2e[5, 3, 9, 9] = complex(0.067629919819, -0.000013048915)
    h2e[7, 3, 9, 9] = complex(-0.000218946480, -0.000000276923)
    h2e[11, 3, 9, 9] = complex(-0.104501710142, -0.000169757389)
    h2e[1, 3, 11, 9] = complex(-0.000000010701, 0.000000032407)
    h2e[5, 3, 11, 9] = complex(-0.000045203859, 0.000023108323)
    h2e[7, 3, 11, 9] = complex(-0.017858713000, 0.009202202430)
    h2e[9, 3, 11, 9] = complex(-0.019204591633, 0.000821846205)
    h2e[11, 3, 11, 9] = complex(0.000007020260, -0.000003861883)
    h2e[1, 5, 1, 9] = complex(0.000017787619, -0.000011230943)
    h2e[3, 5, 1, 9] = complex(-0.000012378275, 0.000010238598)
    h2e[7, 5, 1, 9] = complex(0.002139307371, -0.002286238907)
    h2e[9, 5, 1, 9] = complex(0.000538151970, -0.000893959698)
    h2e[11, 5, 1, 9] = complex(0.000000914989, -0.000001547307)
    h2e[1, 5, 3, 9] = complex(-0.000011150333, 0.000009222915)
    h2e[3, 5, 3, 9] = complex(-0.000139156513, 0.000067981251)
    h2e[7, 5, 3, 9] = complex(0.019358212716, -0.008684034560)
    h2e[9, 5, 3, 9] = complex(0.022561213593, -0.000182279773)
    h2e[11, 5, 3, 9] = complex(0.000037603508, -0.000019223747)
    h2e[1, 5, 5, 9] = complex(-0.000005554299, 0.000004396287)
    h2e[3, 5, 5, 9] = complex(-0.000050400480, 0.000024364699)
    h2e[7, 5, 5, 9] = complex(0.019466239640, -0.008503349822)
    h2e[9, 5, 5, 9] = complex(0.023142194885, 0.000000000000)
    h2e[11, 5, 5, 9] = complex(-0.000012711547, 0.000006422908)
    h2e[1, 5, 7, 9] = complex(0.000000013308, -0.000000014222)
    h2e[3, 5, 7, 9] = complex(0.000000133264, -0.000000059782)
    h2e[7, 5, 7, 9] = complex(-0.000048797154, 0.000019333548)
    h2e[9, 5, 7, 9] = complex(0.000044849469, -0.000000330205)
    h2e[11, 5, 7, 9] = complex(0.000000024595, -0.000000012376)
    h2e[1, 5, 9, 9] = complex(-0.000454979583, 0.000004904436)
    h2e[3, 5, 9, 9] = complex(0.067629919819, 0.000013048915)
    h2e[5, 5, 9, 9] = complex(0.599463715832, -0.000000000000)
    h2e[7, 5, 9, 9] = complex(0.000364229152, -0.000001281349)
    h2e[11, 5, 9, 9] = complex(0.111272120430, 0.000176173697)
    h2e[1, 5, 11, 9] = complex(0.000000992725, -0.000001678764)
    h2e[3, 5, 11, 9] = complex(0.000045214059, -0.000023114431)
    h2e[7, 5, 11, 9] = complex(0.002033231613, -0.001023070877)
    h2e[9, 5, 11, 9] = complex(0.002137668587, -0.000111242838)
    h2e[11, 5, 11, 9] = complex(-0.000032552940, 0.000017674771)
    h2e[1, 7, 1, 9] = complex(0.007327228045, -0.005220542358)
    h2e[3, 7, 1, 9] = complex(-0.005316308523, 0.002953133477)
    h2e[5, 7, 1, 9] = complex(-0.002604245715, 0.001452351868)
    h2e[9, 7, 1, 9] = complex(-0.000001225832, 0.000003727934)
    h2e[11, 7, 1, 9] = complex(0.000659640860, -0.000363425462)
    h2e[1, 7, 3, 9] = complex(-0.005313958966, 0.002951828258)
    h2e[3, 7, 3, 9] = complex(-0.052722849229, 0.027230005494)
    h2e[5, 7, 3, 9] = complex(-0.018570712767, 0.009624367334)
    h2e[9, 7, 3, 9] = complex(-0.000062897524, 0.000000592219)
    h2e[11, 7, 3, 9] = complex(0.017676385038, -0.008937300220)
    h2e[1, 7, 5, 9] = complex(-0.002603042870, 0.001451681026)
    h2e[3, 7, 5, 9] = complex(-0.018570586861, 0.009624302076)
    h2e[5, 7, 5, 9] = complex(-0.018570457657, 0.009662675034)
    h2e[9, 7, 5, 9] = complex(0.000044849469, 0.000000330205)
    h2e[11, 7, 5, 9] = complex(-0.002001698107, 0.001012704801)
    h2e[1, 7, 7, 9] = complex(0.000006257870, -0.000004909550)
    h2e[3, 7, 7, 9] = complex(0.000048844477, -0.000023538508)
    h2e[5, 7, 7, 9] = complex(0.000045859370, -0.000021864742)
    h2e[9, 7, 7, 9] = complex(0.040103033684, 0.000000000000)
    h2e[11, 7, 7, 9] = complex(0.000002325124, -0.000001171211)
    h2e[1, 7, 9, 9] = complex(0.000001018499, -0.000001049191)
    h2e[3, 7, 9, 9] = complex(-0.000218946480, 0.000000276923)
    h2e[5, 7, 9, 9] = complex(0.000364229152, 0.000001281349)
    h2e[7, 7, 9, 9] = complex(0.721688265776, 0.000000000000)
    h2e[11, 7, 9, 9] = complex(-0.000346440707, 0.000009450339)
    h2e[1, 7, 11, 9] = complex(0.000659332079, -0.000363255317)
    h2e[3, 7, 11, 9] = complex(0.017676401582, -0.008937308615)
    h2e[5, 7, 11, 9] = complex(-0.002001827140, 0.001012770085)
    h2e[9, 7, 11, 9] = complex(-0.000017433593, -0.000000213412)
    h2e[11, 7, 11, 9] = complex(-0.012637470089, 0.006358613435)
    h2e[1, 9, 1, 9] = complex(-0.005110639785, 0.009732329061)
    h2e[3, 9, 1, 9] = complex(-0.001136197129, 0.001796754586)
    h2e[5, 9, 1, 9] = complex(-0.000312560384, 0.000501576199)
    h2e[7, 9, 1, 9] = complex(0.000001937905, -0.000000497051)
    h2e[11, 9, 1, 9] = complex(0.001152659852, -0.001753310173)
    h2e[1, 9, 3, 9] = complex(-0.001136197129, 0.001796754586)
    h2e[3, 9, 3, 9] = complex(-0.036044145010, 0.050742336484)
    h2e[5, 9, 3, 9] = complex(-0.012931962374, 0.018208416547)
    h2e[7, 9, 3, 9] = complex(0.000031672545, -0.000044456707)
    h2e[11, 9, 3, 9] = complex(0.011003353841, -0.015457323332)
    h2e[1, 9, 5, 9] = complex(-0.000312560384, 0.000501576199)
    h2e[3, 9, 5, 9] = complex(-0.012931962374, 0.018208416547)
    h2e[5, 9, 5, 9] = complex(-0.013268841670, 0.018679476994)
    h2e[7, 9, 5, 9] = complex(0.000091033916, -0.000129104643)
    h2e[11, 9, 5, 9] = complex(-0.001222989435, 0.001722440638)
    h2e[1, 9, 7, 9] = complex(0.000001937905, -0.000000497051)
    h2e[3, 9, 7, 9] = complex(0.000031672545, -0.000044456707)
    h2e[5, 9, 7, 9] = complex(0.000091033916, -0.000129104643)
    h2e[7, 9, 7, 9] = complex(0.022946279221, -0.032875564569)
    h2e[11, 9, 7, 9] = complex(-0.000007531629, 0.000009986426)
    h2e[9, 9, 9, 9] = complex(0.721683619311, 0.000000000000)
    h2e[1, 9, 11, 9] = complex(0.001152659852, -0.001753310173)
    h2e[3, 9, 11, 9] = complex(0.011003353841, -0.015457323332)
    h2e[5, 9, 11, 9] = complex(-0.001222989435, 0.001722440638)
    h2e[7, 9, 11, 9] = complex(-0.000007531629, 0.000009986426)
    h2e[11, 9, 11, 9] = complex(-0.008680205984, 0.011997982836)
    h2e[1, 11, 1, 9] = complex(-0.000005956556, 0.000004080575)
    h2e[3, 11, 1, 9] = complex(0.000000238270, -0.000000482297)
    h2e[5, 11, 1, 9] = complex(-0.000001032762, 0.000001334969)
    h2e[7, 11, 1, 9] = complex(-0.000285967605, 0.000986116435)
    h2e[9, 11, 1, 9] = complex(-0.002069159539, 0.000813617799)
    h2e[1, 11, 3, 9] = complex(0.000000393799, -0.000000797113)
    h2e[3, 11, 3, 9] = complex(0.000021654590, -0.000011401921)
    h2e[5, 11, 3, 9] = complex(-0.000037371241, 0.000019510954)
    h2e[7, 11, 3, 9] = complex(-0.017717091117, 0.009326308501)
    h2e[9, 11, 3, 9] = complex(-0.019204591633, -0.000821846205)
    h2e[1, 11, 5, 9] = complex(0.000000354406, -0.000000458112)
    h2e[3, 11, 5, 9] = complex(0.000007171416, -0.000003744086)
    h2e[5, 11, 5, 9] = complex(0.000012624967, -0.000006537902)
    h2e[7, 11, 5, 9] = complex(0.002014852226, -0.001039507471)
    h2e[9, 11, 5, 9] = complex(0.002137668587, 0.000111242838)
    h2e[1, 11, 7, 9] = complex(-0.000000000562, 0.000000001937)
    h2e[3, 11, 7, 9] = complex(-0.000000018963, 0.000000009982)
    h2e[5, 11, 7, 9] = complex(-0.000000024374, 0.000000012575)
    h2e[7, 11, 7, 9] = complex(-0.000002372107, 0.000001215790)
    h2e[9, 11, 7, 9] = complex(-0.000017433593, 0.000000213412)
    h2e[1, 11, 9, 9] = complex(0.001598266472, -0.000136789787)
    h2e[3, 11, 9, 9] = complex(-0.104501710142, 0.000169757389)
    h2e[5, 11, 9, 9] = complex(0.111272120430, -0.000176173697)
    h2e[7, 11, 9, 9] = complex(-0.000346440707, -0.000009450339)
    h2e[11, 11, 9, 9] = complex(0.551538006029, -0.000000000000)
    h2e[1, 11, 11, 9] = complex(0.000000583158, -0.000000129436)
    h2e[3, 11, 11, 9] = complex(-0.000007003579, 0.000003858191)
    h2e[5, 11, 11, 9] = complex(0.000032461227, -0.000017670997)
    h2e[7, 11, 11, 9] = complex(0.012385855642, -0.007225665254)
    h2e[9, 11, 11, 9] = complex(0.015012857116, -0.000000000000)
    h2e[1, 1, 1, 11] = complex(0.062770336469, -0.005372283708)
    h2e[3, 1, 1, 11] = complex(-0.001532991813, 0.000068382201)
    h2e[5, 1, 1, 11] = complex(0.000141239546, -0.000010557161)
    h2e[7, 1, 1, 11] = complex(-0.000007320408, -0.000000507920)
    h2e[9, 1, 1, 11] = complex(0.000006509613, 0.000003155518)
    h2e[11, 1, 1, 11] = complex(0.004490286136, 0.000000000000)
    h2e[1, 1, 3, 11] = complex(-0.202690975409, 0.000329260552)
    h2e[3, 1, 3, 11] = complex(0.000538471964, 0.000021106179)
    h2e[5, 1, 3, 11] = complex(0.001391891127, 0.000012742378)
    h2e[7, 1, 3, 11] = complex(-0.000005493702, -0.000002863496)
    h2e[9, 1, 3, 11] = complex(-0.000000188681, -0.000000571395)
    h2e[11, 1, 3, 11] = complex(0.004857442834, 0.000407783361)
    h2e[1, 1, 5, 11] = complex(0.213867894708, -0.000338610404)
    h2e[3, 1, 5, 11] = complex(-0.000654656458, -0.000025687193)
    h2e[5, 1, 5, 11] = complex(0.000344518509, 0.000003168498)
    h2e[7, 1, 5, 11] = complex(0.000004004788, -0.000001412085)
    h2e[9, 1, 5, 11] = complex(0.000000914989, 0.000001547307)
    h2e[11, 1, 5, 11] = complex(0.003216758836, 0.000270181193)
    h2e[1, 1, 7, 11] = complex(-0.000604236288, -0.000016482583)
    h2e[3, 1, 7, 11] = complex(0.000001459747, 0.000000081791)
    h2e[5, 1, 7, 11] = complex(0.000003654242, 0.000001007234)
    h2e[7, 1, 7, 11] = complex(0.002089143695, 0.000058078098)
    h2e[9, 1, 7, 11] = complex(0.000659640860, 0.000363425462)
    h2e[11, 1, 7, 11] = complex(-0.000009632709, -0.000001250031)
    h2e[3, 1, 9, 11] = complex(-0.000000010701, -0.000000032407)
    h2e[5, 1, 9, 11] = complex(0.000000992725, 0.000001678764)
    h2e[7, 1, 9, 11] = complex(0.000659332079, 0.000363255317)
    h2e[9, 1, 9, 11] = complex(0.001152659852, 0.001753310173)
    h2e[11, 1, 9, 11] = complex(0.000000583158, 0.000000129436)
    h2e[1, 1, 11, 11] = complex(0.764008571323, -0.000000000000)
    h2e[3, 1, 11, 11] = complex(-0.001064961868, -0.000043475447)
    h2e[5, 1, 11, 11] = complex(-0.001422634196, -0.000015335234)
    h2e[7, 1, 11, 11] = complex(0.000003111333, 0.000003205092)
    h2e[11, 1, 11, 11] = complex(-0.003933065673, -0.000336616718)
    h2e[1, 3, 1, 11] = complex(-0.001522317359, 0.000193110586)
    h2e[3, 3, 1, 11] = complex(-0.001630334179, 0.000139534344)
    h2e[5, 3, 1, 11] = complex(0.008439681402, -0.000723962028)
    h2e[7, 3, 1, 11] = complex(-0.000017696106, 0.000000723828)
    h2e[9, 3, 1, 11] = complex(-0.000000422414, -0.000000924878)
    h2e[11, 3, 1, 11] = complex(0.004857442834, -0.000407783361)
    h2e[1, 3, 3, 11] = complex(0.000538400283, -0.000022855483)
    h2e[3, 3, 3, 11] = complex(-0.092407510398, 0.000150111014)
    h2e[5, 3, 3, 11] = complex(0.003003719245, -0.000005458995)
    h2e[7, 3, 3, 11] = complex(0.000004450380, -0.000000653435)
    h2e[9, 3, 3, 11] = complex(-0.000021772023, -0.000011259938)
    h2e[11, 3, 3, 11] = complex(0.086507035699, -0.000000000000)
    h2e[1, 3, 5, 11] = complex(-0.000654571386, 0.000027760025)
    h2e[3, 3, 5, 11] = complex(0.058557914949, -0.000092712931)
    h2e[5, 3, 5, 11] = complex(0.091821657332, -0.000163094965)
    h2e[7, 3, 5, 11] = complex(-0.000218347085, 0.000000981474)
    h2e[9, 3, 5, 11] = complex(0.000037603508, 0.000019223747)
    h2e[11, 3, 5, 11] = complex(-0.052538914800, -0.000002163367)
    h2e[1, 3, 7, 11] = complex(0.000001672377, -0.000000009402)
    h2e[3, 3, 7, 11] = complex(-0.000172766481, -0.000004712788)
    h2e[5, 3, 7, 11] = complex(-0.000231971889, -0.000009113328)
    h2e[7, 3, 7, 11] = complex(0.018903442147, -0.000175258307)
    h2e[9, 3, 7, 11] = complex(0.017676385038, 0.008937300220)
    h2e[11, 3, 7, 11] = complex(0.000155828613, 0.000004749695)
    h2e[1, 3, 9, 11] = complex(0.000000014495, 0.000000031738)
    h2e[5, 3, 9, 11] = complex(0.000045214059, 0.000023114431)
    h2e[7, 3, 9, 11] = complex(0.017676401582, 0.008937308615)
    h2e[9, 3, 9, 11] = complex(0.011003353841, 0.015457323332)
    h2e[11, 3, 9, 11] = complex(-0.000007003579, -0.000003858191)
    h2e[1, 3, 11, 11] = complex(-0.001064961868, 0.000043475447)
    h2e[3, 3, 11, 11] = complex(0.600972926148, -0.000000000000)
    h2e[5, 3, 11, 11] = complex(-0.076272413760, 0.000014716449)
    h2e[7, 3, 11, 11] = complex(0.000184782601, 0.000000233714)
    h2e[11, 3, 11, 11] = complex(-0.033401934740, -0.000054259641)
    h2e[1, 5, 1, 11] = complex(0.000141011087, -0.000013601804)
    h2e[3, 5, 1, 11] = complex(0.008439951675, -0.000720704022)
    h2e[5, 5, 1, 11] = complex(0.005862208618, -0.000501725012)
    h2e[7, 5, 1, 11] = complex(-0.000007281292, 0.000000310774)
    h2e[9, 5, 1, 11] = complex(-0.000000380371, -0.000000488551)
    h2e[11, 5, 1, 11] = complex(0.003216758836, -0.000270181193)
    h2e[1, 5, 3, 11] = complex(0.001391853745, -0.000017265171)
    h2e[3, 5, 3, 11] = complex(0.003003839896, -0.000004299899)
    h2e[5, 5, 3, 11] = complex(-0.016168008881, 0.000026264058)
    h2e[7, 5, 3, 11] = complex(-0.000253349435, 0.000001005177)
    h2e[9, 5, 3, 11] = complex(-0.000007214358, -0.000003687998)
    h2e[11, 5, 3, 11] = complex(-0.052538914800, 0.000002163367)
    h2e[1, 5, 5, 11] = complex(0.000344485003, -0.000004257945)
    h2e[3, 5, 5, 11] = complex(0.091821509829, -0.000127661653)
    h2e[5, 5, 5, 11] = complex(0.070498980338, -0.000111618849)
    h2e[7, 5, 5, 11] = complex(0.000148524257, -0.000001213653)
    h2e[9, 5, 5, 11] = complex(-0.000012711547, -0.000006422908)
    h2e[11, 5, 5, 11] = complex(0.124453179368, -0.000000000000)
    h2e[1, 5, 7, 11] = complex(-0.000006166822, -0.000000427156)
    h2e[3, 5, 7, 11] = complex(-0.000329014870, -0.000006230532)
    h2e[5, 5, 7, 11] = complex(-0.000187393792, -0.000005111798)
    h2e[7, 5, 7, 11] = complex(-0.002103993400, 0.000016946521)
    h2e[9, 5, 7, 11] = complex(-0.002001698107, -0.001012704801)
    h2e[11, 5, 7, 11] = complex(-0.000327535595, -0.000010709234)
    h2e[1, 5, 9, 11] = complex(-0.000001202597, -0.000001544621)
    h2e[3, 5, 9, 11] = complex(-0.000045203859, -0.000023108323)
    h2e[7, 5, 9, 11] = complex(-0.002001827140, -0.001012770085)
    h2e[9, 5, 9, 11] = complex(-0.001222989435, -0.001722440638)
    h2e[11, 5, 9, 11] = complex(0.000032461227, 0.000017670997)
    h2e[1, 5, 11, 11] = complex(-0.001422634196, 0.000015335234)
    h2e[3, 5, 11, 11] = complex(-0.076272413760, -0.000014716449)
    h2e[5, 5, 11, 11] = complex(0.574398690825, 0.000000000000)
    h2e[7, 5, 11, 11] = complex(-0.000072542815, 0.000000255204)
    h2e[11, 5, 11, 11] = complex(-0.025653771935, -0.000040616821)
    h2e[1, 7, 1, 11] = complex(0.000006574844, -0.000000770271)
    h2e[3, 7, 1, 11] = complex(-0.000020999314, 0.000001214160)
    h2e[5, 7, 1, 11] = complex(-0.000009168235, 0.000000478248)
    h2e[7, 7, 1, 11] = complex(0.001598968882, -0.000136849903)
    h2e[9, 7, 1, 11] = complex(0.000000000740, 0.000000002063)
    h2e[11, 7, 1, 11] = complex(-0.000009632709, 0.000001250031)
    h2e[1, 7, 3, 11] = complex(-0.000000622063, 0.000003314805)
    h2e[3, 7, 3, 11] = complex(0.000050317194, -0.000000733312)
    h2e[5, 7, 3, 11] = complex(-0.000238564722, -0.000000718014)
    h2e[7, 7, 3, 11] = complex(-0.104503201302, 0.000169759811)
    h2e[9, 7, 3, 11] = complex(0.000000019115, 0.000000009849)
    h2e[11, 7, 3, 11] = complex(0.000155828613, -0.000004749695)
    h2e[1, 7, 5, 11] = complex(-0.000005427294, 0.000000345943)
    h2e[3, 7, 5, 11] = complex(-0.000298789830, 0.000001673986)
    h2e[5, 7, 5, 11] = complex(0.000175165546, -0.000000066648)
    h2e[7, 7, 5, 11] = complex(0.111275222184, -0.000176178608)
    h2e[9, 7, 5, 11] = complex(0.000000024595, 0.000000012376)
    h2e[11, 7, 5, 11] = complex(-0.000327535595, 0.000010709234)
    h2e[1, 7, 7, 11] = complex(-0.002161730679, -0.000552354206)
    h2e[3, 7, 7, 11] = complex(-0.019142422040, 0.001019561044)
    h2e[5, 7, 7, 11] = complex(0.002129926539, -0.000136139730)
    h2e[7, 7, 7, 11] = complex(-0.000346447461, -0.000009450523)
    h2e[9, 7, 7, 11] = complex(0.000002325124, 0.000001171211)
    h2e[11, 7, 7, 11] = complex(0.014920294439, 0.000000000000)
    h2e[1, 7, 9, 11] = complex(-0.000376644737, -0.001049940944)
    h2e[3, 7, 9, 11] = complex(-0.017858713000, -0.009202202430)
    h2e[5, 7, 9, 11] = complex(0.002033231613, 0.001023070877)
    h2e[9, 7, 9, 11] = complex(-0.000007531629, -0.000009986426)
    h2e[11, 7, 9, 11] = complex(0.012385855642, 0.007225665254)
    h2e[1, 7, 11, 11] = complex(0.000003111333, -0.000003205092)
    h2e[3, 7, 11, 11] = complex(0.000184782601, -0.000000233714)
    h2e[5, 7, 11, 11] = complex(-0.000072542815, -0.000000255204)
    h2e[7, 7, 11, 11] = complex(0.551545232677, -0.000000000000)
    h2e[11, 7, 11, 11] = complex(0.000103001333, -0.000002809709)
    h2e[1, 9, 1, 11] = complex(-0.000005956556, 0.000004080575)
    h2e[3, 9, 1, 11] = complex(0.000000393799, -0.000000797113)
    h2e[5, 9, 1, 11] = complex(0.000000354406, -0.000000458112)
    h2e[7, 9, 1, 11] = complex(-0.000000000562, 0.000000001937)
    h2e[9, 9, 1, 11] = complex(0.001598266472, -0.000136789787)
    h2e[11, 9, 1, 11] = complex(0.000000583158, -0.000000129436)
    h2e[1, 9, 3, 11] = complex(0.000000238270, -0.000000482297)
    h2e[3, 9, 3, 11] = complex(0.000021654590, -0.000011401921)
    h2e[5, 9, 3, 11] = complex(0.000007171416, -0.000003744086)
    h2e[7, 9, 3, 11] = complex(-0.000000018963, 0.000000009982)
    h2e[9, 9, 3, 11] = complex(-0.104501710142, 0.000169757389)
    h2e[11, 9, 3, 11] = complex(-0.000007003579, 0.000003858191)
    h2e[1, 9, 5, 11] = complex(-0.000001032762, 0.000001334969)
    h2e[3, 9, 5, 11] = complex(-0.000037371241, 0.000019510954)
    h2e[5, 9, 5, 11] = complex(0.000012624967, -0.000006537902)
    h2e[7, 9, 5, 11] = complex(-0.000000024374, 0.000000012575)
    h2e[9, 9, 5, 11] = complex(0.111272120430, -0.000176173697)
    h2e[11, 9, 5, 11] = complex(0.000032461227, -0.000017670997)
    h2e[1, 9, 7, 11] = complex(-0.000285967605, 0.000986116435)
    h2e[3, 9, 7, 11] = complex(-0.017717091117, 0.009326308501)
    h2e[5, 9, 7, 11] = complex(0.002014852226, -0.001039507471)
    h2e[7, 9, 7, 11] = complex(-0.000002372107, 0.000001215790)
    h2e[9, 9, 7, 11] = complex(-0.000346440707, -0.000009450339)
    h2e[11, 9, 7, 11] = complex(0.012385855642, -0.007225665254)
    h2e[1, 9, 9, 11] = complex(-0.002069159539, 0.000813617799)
    h2e[3, 9, 9, 11] = complex(-0.019204591633, -0.000821846205)
    h2e[5, 9, 9, 11] = complex(0.002137668587, 0.000111242838)
    h2e[7, 9, 9, 11] = complex(-0.000017433593, 0.000000213412)
    h2e[11, 9, 9, 11] = complex(0.015012857116, -0.000000000000)
    h2e[9, 9, 11, 11] = complex(0.551538006029, -0.000000000000)
    h2e[1, 11, 1, 11] = complex(0.004424971426, -0.000763023577)
    h2e[3, 11, 1, 11] = complex(0.004856091513, -0.000423562483)
    h2e[5, 11, 1, 11] = complex(0.003215888374, -0.000280365730)
    h2e[7, 11, 1, 11] = complex(-0.000009170656, 0.000000771996)
    h2e[9, 11, 1, 11] = complex(-0.000000624339, 0.000000019459)
    h2e[11, 11, 1, 11] = complex(-0.003933065673, 0.000336616718)
    h2e[1, 11, 3, 11] = complex(0.004856091513, -0.000423562483)
    h2e[3, 11, 3, 11] = complex(0.086506559668, -0.000281051165)
    h2e[5, 11, 3, 11] = complex(-0.052538607424, 0.000168529211)
    h2e[7, 11, 3, 11] = complex(0.000172851675, 0.000004153811)
    h2e[9, 11, 3, 11] = complex(0.000007020260, 0.000003861883)
    h2e[11, 11, 3, 11] = complex(-0.033401934740, 0.000054259641)
    h2e[1, 11, 5, 11] = complex(0.003215888374, -0.000280365730)
    h2e[3, 11, 5, 11] = complex(-0.052538607424, 0.000168529211)
    h2e[5, 11, 5, 11] = complex(0.124452347910, -0.000394083502)
    h2e[7, 11, 5, 11] = complex(-0.000404837776, -0.000008938319)
    h2e[9, 11, 5, 11] = complex(-0.000032552940, -0.000017674771)
    h2e[11, 11, 5, 11] = complex(-0.025653771935, 0.000040616821)
    h2e[1, 11, 7, 11] = complex(-0.000009170656, 0.000000771996)
    h2e[3, 11, 7, 11] = complex(0.000172851675, 0.000004153811)
    h2e[5, 11, 7, 11] = complex(-0.000404837776, -0.000008938319)
    h2e[7, 11, 7, 11] = complex(-0.014749622025, 0.000249979167)
    h2e[9, 11, 7, 11] = complex(-0.012637470089, -0.006358613435)
    h2e[11, 11, 7, 11] = complex(0.000103001333, 0.000002809709)
    h2e[1, 11, 9, 11] = complex(-0.000000624339, 0.000000019459)
    h2e[3, 11, 9, 11] = complex(0.000007020260, 0.000003861883)
    h2e[5, 11, 9, 11] = complex(-0.000032552940, -0.000017674771)
    h2e[7, 11, 9, 11] = complex(-0.012637470089, -0.006358613435)
    h2e[9, 11, 9, 11] = complex(-0.008680205984, -0.011997982836)
    h2e[1, 11, 11, 11] = complex(-0.003933065673, 0.000336616718)
    h2e[3, 11, 11, 11] = complex(-0.033401934740, 0.000054259641)
    h2e[5, 11, 11, 11] = complex(-0.025653771935, 0.000040616821)
    h2e[7, 11, 11, 11] = complex(0.000103001333, 0.000002809709)
    h2e[11, 11, 11, 11] = complex(0.666720377766, 0.000000000000)

    # Rearrange h1e in spin sectors:
    h1e_rel = np.zeros((norb_rel, norb_rel), dtype=np.complex128)
    for a in range(2):
        for b in range(2):
            i1 = a * norb
            for i in range(a, norb_rel, 2):
                j1 = b * norb
                for j in range(b, norb_rel, 2):
                    h1e_rel[i1, j1] = h1e[i, j]
                    j1 += 1
                i1 += 1

    # Fill out missing two-e integrals using symmetries:
    val_thresh = 1e-9
    for i in range(norb_rel):
        for j in range(norb_rel):
            for k in range(norb_rel):
                for l in range(norb_rel):
                    val = h2e[i, j, k, l]
                    if abs(val) > val_thresh:
                        h2e[j, i, l, k] = val.conj()
                        h2e[k, l, i, j] = val
                        h2e[l, k, j, i] = val.conj()

    # Rearrange h2e in spin sectors:
    h2e_rel = np.zeros((norb_rel, norb_rel, norb_rel, norb_rel),
                       dtype=np.complex128)
    for a in range(2):
        for b in range(2):
            for c in range(2):
                for d in range(2):
                    i1 = a * norb
                    for i in range(a, norb_rel, 2):
                        j1 = b * norb
                        for j in range(b, norb_rel, 2):
                            k1 = c * norb
                            for k in range(c, norb_rel, 2):
                                l1 = d * norb
                                for l in range(d, norb_rel, 2):
                                    h2e_rel[i1, j1, k1, l1] = (-0.5 *
                                                               h2e[i, k, j, l])
                                    l1 += 1
                                k1 += 1
                            j1 += 1
                        i1 += 1
    return nele, h1e_rel, h2e_rel
