#   Copyright 2020 Google LLC

#   Licensed under the Apache License, Version 2.0 (the "License");
#   you may not use this file except in compliance with the License.
#   You may obtain a copy of the License at
#
#       http://www.apache.org/licenses/LICENSE-2.0
#
#   Unless required by applicable law or agreed to in writing, software
#   distributed under the License is distributed on an "AS IS" BASIS,
#   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#   See the License for the specific language governing permissions and
#   limitations under the License.
"""Defines function to get LiH data for unit tests."""

# pylint: disable=inconsistent-return-statements
# pylint: disable=line-too-long

from typing import Tuple

import numpy as np


def build_lih_data(target: str) -> Tuple[np.ndarray, ...]:
    """Returns LiH data for unit tests.

    Args:
        target: Either "energy" or "dipole".
    """
    wfn = np.asarray(
        [
            [
                -0.9870890035778126 + 0.0000000000000000j,
                -0.0384854879340124 + 0.0000000000000000j,
                -0.0000000000000001 + 0.0000000000000000j,
                -0.0000000000000011 + 0.0000000000000000j,
                -0.0036477466809967 + 0.0000000000000000j,
                0.0002822455404040 + 0.0000000000000000j,
                0.0000000000000000 + 0.0000000000000000j,
                0.0000000000000000 + 0.0000000000000000j,
                -0.0005021201748408 + 0.0000000000000000j,
                0.0000000000000000 + 0.0000000000000000j,
                -0.0000000000000000 + 0.0000000000000000j,
                -0.0007278508383405 + 0.0000000000000000j,
                0.0000000000000000 + 0.0000000000000000j,
                0.0000000000000000 + 0.0000000000000000j,
                -0.0000000000000000 + 0.0000000000000000j,
            ],
            [
                -0.0384854879340073 + 0.0000000000000000j,
                0.0344508540105218 + 0.0000000000000000j,
                0.0000000000000000 + 0.0000000000000000j,
                0.0000000000000001 + 0.0000000000000000j,
                -0.0592953695921639 + 0.0000000000000000j,
                -0.0002094698208570 + 0.0000000000000000j,
                0.0000000000000000 + 0.0000000000000000j,
                0.0000000000000000 + 0.0000000000000000j,
                -0.0010777697106179 + 0.0000000000000000j,
                -0.0000000000000000 + 0.0000000000000000j,
                0.0000000000000000 + 0.0000000000000000j,
                0.0004382780014953 + 0.0000000000000000j,
                -0.0000000000000000 + 0.0000000000000000j,
                -0.0000000000000000 + 0.0000000000000000j,
                0.0000000000000000 + 0.0000000000000000j,
            ],
            [
                0.0000000000000000 + 0.0000000000000000j,
                0.0000000000000000 + 0.0000000000000000j,
                0.0271656962509733 + 0.0000000000000000j,
                -0.0000000000000000 + 0.0000000000000000j,
                -0.0000000000000000 + 0.0000000000000000j,
                -0.0000000000000000 + 0.0000000000000000j,
                -0.0031209939957822 + 0.0000000000000000j,
                -0.0000000000000000 + 0.0000000000000000j,
                0.0000000000000000 + 0.0000000000000000j,
                0.0001591561968439 + 0.0000000000000000j,
                -0.0000000000000000 + 0.0000000000000000j,
                0.0000000000000000 + 0.0000000000000000j,
                0.0000000000000000 + 0.0000000000000000j,
                0.0008392278108057 + 0.0000000000000000j,
                -0.0000000000000000 + 0.0000000000000000j,
            ],
            [
                0.0000000000000001 + 0.0000000000000000j,
                0.0000000000000000 + 0.0000000000000000j,
                0.0000000000000000 + 0.0000000000000000j,
                0.0271656962509733 + 0.0000000000000000j,
                -0.0000000000000000 + 0.0000000000000000j,
                0.0000000000000000 + 0.0000000000000000j,
                0.0000000000000000 + 0.0000000000000000j,
                -0.0031209939957822 + 0.0000000000000000j,
                0.0000000000000000 + 0.0000000000000000j,
                0.0000000000000000 + 0.0000000000000000j,
                0.0001591561968439 + 0.0000000000000000j,
                0.0000000000000000 + 0.0000000000000000j,
                0.0000000000000000 + 0.0000000000000000j,
                0.0000000000000000 + 0.0000000000000000j,
                0.0008392278108057 + 0.0000000000000000j,
            ],
            [
                -0.0036477466809970 + 0.0000000000000000j,
                -0.0592953695921649 + 0.0000000000000000j,
                -0.0000000000000000 + 0.0000000000000000j,
                -0.0000000000000002 + 0.0000000000000000j,
                0.1135892009408387 + 0.0000000000000000j,
                -0.0003499188722774 + 0.0000000000000000j,
                -0.0000000000000000 + 0.0000000000000000j,
                0.0000000000000000 + 0.0000000000000000j,
                -0.0002542419764508 + 0.0000000000000000j,
                0.0000000000000000 + 0.0000000000000000j,
                -0.0000000000000000 + 0.0000000000000000j,
                -0.0002834114264023 + 0.0000000000000000j,
                0.0000000000000000 + 0.0000000000000000j,
                0.0000000000000000 + 0.0000000000000000j,
                -0.0000000000000000 + 0.0000000000000000j,
            ],
            [
                0.0002822455404040 + 0.0000000000000000j,
                -0.0002094698208570 + 0.0000000000000000j,
                -0.0000000000000000 + 0.0000000000000000j,
                -0.0000000000000000 + 0.0000000000000000j,
                -0.0003499188722775 + 0.0000000000000000j,
                0.0037623492033852 + 0.0000000000000000j,
                0.0000000000000000 + 0.0000000000000000j,
                -0.0000000000000000 + 0.0000000000000000j,
                -0.0001692921185483 + 0.0000000000000000j,
                -0.0000000000000000 + 0.0000000000000000j,
                -0.0000000000000000 + 0.0000000000000000j,
                0.0000367377780160 + 0.0000000000000000j,
                0.0000000000000000 + 0.0000000000000000j,
                -0.0000000000000000 + 0.0000000000000000j,
                -0.0000000000000000 + 0.0000000000000000j,
            ],
            [
                -0.0000000000000000 + 0.0000000000000000j,
                -0.0000000000000000 + 0.0000000000000000j,
                -0.0031209939957822 + 0.0000000000000000j,
                0.0000000000000000 + 0.0000000000000000j,
                0.0000000000000000 + 0.0000000000000000j,
                0.0000000000000000 + 0.0000000000000000j,
                0.0017942021496060 + 0.0000000000000000j,
                0.0000000000000000 + 0.0000000000000000j,
                -0.0000000000000000 + 0.0000000000000000j,
                0.0001059284859048 + 0.0000000000000000j,
                0.0000000000000000 + 0.0000000000000000j,
                -0.0000000000000000 + 0.0000000000000000j,
                -0.0000000000000000 + 0.0000000000000000j,
                -0.0000280922311557 + 0.0000000000000000j,
                0.0000000000000000 + 0.0000000000000000j,
            ],
            [
                -0.0000000000000000 + 0.0000000000000000j,
                -0.0000000000000000 + 0.0000000000000000j,
                -0.0000000000000000 + 0.0000000000000000j,
                -0.0031209939957822 + 0.0000000000000000j,
                0.0000000000000000 + 0.0000000000000000j,
                0.0000000000000000 + 0.0000000000000000j,
                -0.0000000000000000 + 0.0000000000000000j,
                0.0017942021496060 + 0.0000000000000000j,
                -0.0000000000000000 + 0.0000000000000000j,
                -0.0000000000000000 + 0.0000000000000000j,
                0.0001059284859048 + 0.0000000000000000j,
                -0.0000000000000000 + 0.0000000000000000j,
                0.0000000000000000 + 0.0000000000000000j,
                -0.0000000000000000 + 0.0000000000000000j,
                -0.0000280922311557 + 0.0000000000000000j,
            ],
            [
                -0.0005021201748408 + 0.0000000000000000j,
                -0.0010777697106180 + 0.0000000000000000j,
                -0.0000000000000000 + 0.0000000000000000j,
                -0.0000000000000000 + 0.0000000000000000j,
                -0.0002542419764508 + 0.0000000000000000j,
                -0.0001692921185483 + 0.0000000000000000j,
                -0.0000000000000000 + 0.0000000000000000j,
                0.0000000000000000 + 0.0000000000000000j,
                0.0010515758855392 + 0.0000000000000000j,
                0.0000000000000000 + 0.0000000000000000j,
                0.0000000000000000 + 0.0000000000000000j,
                -0.0000587867132034 + 0.0000000000000000j,
                -0.0000000000000000 + 0.0000000000000000j,
                0.0000000000000000 + 0.0000000000000000j,
                0.0000000000000000 + 0.0000000000000000j,
            ],
            [
                0.0000000000000000 + 0.0000000000000000j,
                0.0000000000000000 + 0.0000000000000000j,
                0.0001591561968439 + 0.0000000000000000j,
                0.0000000000000000 + 0.0000000000000000j,
                -0.0000000000000000 + 0.0000000000000000j,
                0.0000000000000000 + 0.0000000000000000j,
                0.0001059284859048 + 0.0000000000000000j,
                0.0000000000000000 + 0.0000000000000000j,
                -0.0000000000000000 + 0.0000000000000000j,
                -0.0001801902517586 + 0.0000000000000000j,
                0.0000000000000000 + 0.0000000000000000j,
                -0.0000000000000000 + 0.0000000000000000j,
                0.0000000000000000 + 0.0000000000000000j,
                -0.0001419505027303 + 0.0000000000000000j,
                0.0000000000000000 + 0.0000000000000000j,
            ],
            [
                0.0000000000000000 + 0.0000000000000000j,
                0.0000000000000000 + 0.0000000000000000j,
                -0.0000000000000000 + 0.0000000000000000j,
                0.0001591561968439 + 0.0000000000000000j,
                -0.0000000000000000 + 0.0000000000000000j,
                0.0000000000000000 + 0.0000000000000000j,
                -0.0000000000000000 + 0.0000000000000000j,
                0.0001059284859048 + 0.0000000000000000j,
                -0.0000000000000000 + 0.0000000000000000j,
                -0.0000000000000000 + 0.0000000000000000j,
                -0.0001801902517586 + 0.0000000000000000j,
                0.0000000000000000 + 0.0000000000000000j,
                -0.0000000000000000 + 0.0000000000000000j,
                -0.0000000000000000 + 0.0000000000000000j,
                -0.0001419505027303 + 0.0000000000000000j,
            ],
            [
                -0.0007278508383405 + 0.0000000000000000j,
                0.0004382780014953 + 0.0000000000000000j,
                0.0000000000000000 + 0.0000000000000000j,
                0.0000000000000000 + 0.0000000000000000j,
                -0.0002834114264022 + 0.0000000000000000j,
                0.0000367377780160 + 0.0000000000000000j,
                0.0000000000000000 + 0.0000000000000000j,
                0.0000000000000000 + 0.0000000000000000j,
                -0.0000587867132034 + 0.0000000000000000j,
                0.0000000000000000 + 0.0000000000000000j,
                0.0000000000000000 + 0.0000000000000000j,
                -0.0004460978647067 + 0.0000000000000000j,
                -0.0000000000000000 + 0.0000000000000000j,
                -0.0000000000000000 + 0.0000000000000000j,
                -0.0000000000000000 + 0.0000000000000000j,
            ],
            [
                0.0000000000000000 + 0.0000000000000000j,
                0.0000000000000000 + 0.0000000000000000j,
                -0.0000000000000000 + 0.0000000000000000j,
                0.0000000000000000 + 0.0000000000000000j,
                -0.0000000000000000 + 0.0000000000000000j,
                -0.0000000000000000 + 0.0000000000000000j,
                0.0000000000000000 + 0.0000000000000000j,
                -0.0000000000000000 + 0.0000000000000000j,
                0.0000000000000000 + 0.0000000000000000j,
                0.0000000000000000 + 0.0000000000000000j,
                -0.0000000000000000 + 0.0000000000000000j,
                -0.0000000000000000 + 0.0000000000000000j,
                -0.0000868403757736 + 0.0000000000000000j,
                0.0000000000000000 + 0.0000000000000000j,
                -0.0000000000000000 + 0.0000000000000000j,
            ],
            [
                0.0000000000000000 + 0.0000000000000000j,
                0.0000000000000000 + 0.0000000000000000j,
                0.0008392278108057 + 0.0000000000000000j,
                -0.0000000000000000 + 0.0000000000000000j,
                -0.0000000000000000 + 0.0000000000000000j,
                0.0000000000000000 + 0.0000000000000000j,
                -0.0000280922311557 + 0.0000000000000000j,
                0.0000000000000000 + 0.0000000000000000j,
                -0.0000000000000000 + 0.0000000000000000j,
                -0.0001419505027303 + 0.0000000000000000j,
                -0.0000000000000000 + 0.0000000000000000j,
                -0.0000000000000000 + 0.0000000000000000j,
                0.0000000000000000 + 0.0000000000000000j,
                -0.0002461527306570 + 0.0000000000000000j,
                0.0000000000000000 + 0.0000000000000000j,
            ],
            [
                0.0000000000000000 + 0.0000000000000000j,
                0.0000000000000000 + 0.0000000000000000j,
                0.0000000000000000 + 0.0000000000000000j,
                0.0008392278108057 + 0.0000000000000000j,
                -0.0000000000000000 + 0.0000000000000000j,
                0.0000000000000000 + 0.0000000000000000j,
                -0.0000000000000000 + 0.0000000000000000j,
                -0.0000280922311557 + 0.0000000000000000j,
                -0.0000000000000000 + 0.0000000000000000j,
                0.0000000000000000 + 0.0000000000000000j,
                -0.0001419505027303 + 0.0000000000000000j,
                -0.0000000000000000 + 0.0000000000000000j,
                -0.0000000000000000 + 0.0000000000000000j,
                -0.0000000000000000 + 0.0000000000000000j,
                -0.0002461527306570 + 0.0000000000000000j,
            ],
        ],
        dtype=np.complex128,
    )

    if target == "energy":
        h1e = np.array([
            [
                -4.728421350659, 0.105682791253, 0.167020108405, 0.000000000000,
                0.000000000000, -0.034287134735
            ],
            [
                0.105682791253, -1.494577437461, 0.033033101717, 0.000000000000,
                -0.000000000000, -0.054102410019
            ],
            [
                0.167020108405, 0.033033101717, -1.125883390339,
                -0.000000000000, 0.000000000000, 0.030539955919
            ],
            [
                0.000000000000, 0.000000000000, -0.000000000000,
                -1.136267633478, 0.000000000000, -0.000000000000
            ],
            [
                0.000000000000, -0.000000000000, 0.000000000000, 0.000000000000,
                -1.136267633478, -0.000000000000
            ],
            [
                -0.034287134735, -0.054102410019, 0.030539955919,
                -0.000000000000, -0.000000000000, -0.950104029034
            ],
        ])

        h2e = np.array([
            [
                [
                    [
                        -0.829275756609, 0.055970566624, 0.069265962562,
                        0.000000000000, -0.000000000000, -0.026319075365
                    ],
                    [
                        0.055970566624, -0.006698417029, -0.005615181780,
                        -0.000000000000, 0.000000000000, 0.004439188661
                    ],
                    [
                        0.069265962562, -0.005615181780, -0.010827827448,
                        -0.000000000000, 0.000000000000, 0.001154334853
                    ],
                    [
                        0.000000000000, -0.000000000000, -0.000000000000,
                        -0.004908970497, 0.000000000000, 0.000000000000
                    ],
                    [
                        -0.000000000000, 0.000000000000, 0.000000000000,
                        0.000000000000, -0.004908970497, -0.000000000000
                    ],
                    [
                        -0.026319075365, 0.004439188661, 0.001154334853,
                        0.000000000000, -0.000000000000, -0.004245864867
                    ],
                ],
                [
                    [
                        0.055970566624, -0.183655050614, -0.006673055345,
                        -0.000000000000, 0.000000000000, 0.020457061704
                    ],
                    [
                        -0.006698417029, -0.003129171114, 0.001681601391,
                        0.000000000000, -0.000000000000, -0.002370625927
                    ],
                    [
                        -0.005615181780, 0.007962846504, -0.000089614366,
                        0.000000000000, -0.000000000000, -0.000250791503
                    ],
                    [
                        -0.000000000000, 0.000000000000, 0.000000000000,
                        -0.003746261036, 0.000000000000, -0.000000000000
                    ],
                    [
                        0.000000000000, -0.000000000000, -0.000000000000,
                        0.000000000000, -0.003746261036, 0.000000000000
                    ],
                    [
                        0.004439188661, 0.003402441045, -0.000834936153,
                        -0.000000000000, 0.000000000000, -0.000063787238
                    ],
                ],
                [
                    [
                        0.069265962562, -0.006673055345, -0.197826957050,
                        0.000000000000, -0.000000000000, -0.008822983622
                    ],
                    [
                        -0.005615181780, 0.001681601391, 0.005532352522,
                        0.000000000000, -0.000000000000, 0.001846503447
                    ],
                    [
                        -0.010827827448, -0.000089614366, -0.000916622790,
                        0.000000000000, -0.000000000000, -0.002200444185
                    ],
                    [
                        -0.000000000000, 0.000000000000, 0.000000000000,
                        -0.005128439082, 0.000000000000, -0.000000000000
                    ],
                    [
                        0.000000000000, -0.000000000000, -0.000000000000,
                        0.000000000000, -0.005128439082, 0.000000000000
                    ],
                    [
                        0.001154334853, -0.000834936153, -0.005204043582,
                        -0.000000000000, 0.000000000000, -0.002151104101
                    ],
                ],
                [
                    [
                        0.000000000000, -0.000000000000, 0.000000000000,
                        -0.198159464579, 0.000000000000, -0.000000000000
                    ],
                    [
                        -0.000000000000, 0.000000000000, 0.000000000000,
                        0.002183433231, -0.000000000000, 0.000000000000
                    ],
                    [
                        -0.000000000000, 0.000000000000, 0.000000000000,
                        0.002486872003, -0.000000000000, -0.000000000000
                    ],
                    [
                        -0.004908970497, -0.003746261036, -0.005128439082,
                        -0.000000000000, 0.000000000000, 0.003054099377
                    ],
                    [
                        0.000000000000, 0.000000000000, 0.000000000000,
                        -0.000000000000, -0.000000000000, -0.000000000000
                    ],
                    [
                        0.000000000000, -0.000000000000, -0.000000000000,
                        -0.000286532578, 0.000000000000, -0.000000000000
                    ],
                ],
                [
                    [
                        -0.000000000000, 0.000000000000, -0.000000000000,
                        0.000000000000, -0.198159464579, 0.000000000000
                    ],
                    [
                        0.000000000000, -0.000000000000, -0.000000000000,
                        -0.000000000000, 0.002183433231, -0.000000000000
                    ],
                    [
                        0.000000000000, -0.000000000000, -0.000000000000,
                        -0.000000000000, 0.002486872003, 0.000000000000
                    ],
                    [
                        0.000000000000, 0.000000000000, 0.000000000000,
                        0.000000000000, 0.000000000000, -0.000000000000
                    ],
                    [
                        -0.004908970497, -0.003746261036, -0.005128439082,
                        -0.000000000000, 0.000000000000, 0.003054099377
                    ],
                    [
                        -0.000000000000, 0.000000000000, 0.000000000000,
                        0.000000000000, -0.000286532578, 0.000000000000
                    ],
                ],
                [
                    [
                        -0.026319075365, 0.020457061704, -0.008822983622,
                        -0.000000000000, 0.000000000000, -0.180871408859
                    ],
                    [
                        0.004439188661, -0.002370625927, 0.001846503447,
                        0.000000000000, -0.000000000000, -0.001658393584
                    ],
                    [
                        0.001154334853, -0.000250791503, -0.002200444185,
                        -0.000000000000, 0.000000000000, 0.005668698026
                    ],
                    [
                        0.000000000000, -0.000000000000, -0.000000000000,
                        0.003054099377, -0.000000000000, 0.000000000000
                    ],
                    [
                        -0.000000000000, 0.000000000000, 0.000000000000,
                        -0.000000000000, 0.003054099377, -0.000000000000
                    ],
                    [
                        -0.004245864867, -0.000063787238, -0.002151104101,
                        -0.000000000000, 0.000000000000, 0.001514022306
                    ],
                ],
            ],
            [
                [
                    [
                        0.055970566624, -0.006698417029, -0.005615181780,
                        -0.000000000000, 0.000000000000, 0.004439188661
                    ],
                    [
                        -0.183655050614, -0.003129171114, 0.007962846504,
                        0.000000000000, -0.000000000000, 0.003402441045
                    ],
                    [
                        -0.006673055345, 0.001681601391, -0.000089614366,
                        0.000000000000, -0.000000000000, -0.000834936153
                    ],
                    [
                        -0.000000000000, 0.000000000000, 0.000000000000,
                        -0.003746261036, 0.000000000000, -0.000000000000
                    ],
                    [
                        0.000000000000, -0.000000000000, -0.000000000000,
                        0.000000000000, -0.003746261036, 0.000000000000
                    ],
                    [
                        0.020457061704, -0.002370625927, -0.000250791503,
                        -0.000000000000, 0.000000000000, -0.000063787238
                    ],
                ],
                [
                    [
                        -0.006698417029, -0.003129171114, 0.001681601391,
                        0.000000000000, -0.000000000000, -0.002370625927
                    ],
                    [
                        -0.003129171114, -0.243828914002, 0.024247474654,
                        0.000000000000, 0.000000000000, -0.063526140121
                    ],
                    [
                        0.001681601391, 0.024247474654, -0.006506983943,
                        -0.000000000000, -0.000000000000, 0.017270499333
                    ],
                    [
                        0.000000000000, 0.000000000000, -0.000000000000,
                        -0.011725058662, 0.000000000000, 0.000000000000
                    ],
                    [
                        -0.000000000000, 0.000000000000, -0.000000000000,
                        0.000000000000, -0.011725058662, -0.000000000000
                    ],
                    [
                        -0.002370625927, -0.063526140121, 0.017270499333,
                        0.000000000000, -0.000000000000, -0.061936163163
                    ],
                ],
                [
                    [
                        -0.005615181780, 0.001681601391, 0.005532352522,
                        0.000000000000, -0.000000000000, 0.001846503447
                    ],
                    [
                        0.007962846504, 0.024247474654, -0.111876537883,
                        0.000000000000, -0.000000000000, 0.025670390781
                    ],
                    [
                        -0.000089614366, -0.006506983943, -0.003709099851,
                        0.000000000000, -0.000000000000, -0.004678725871
                    ],
                    [
                        0.000000000000, -0.000000000000, -0.000000000000,
                        -0.009636306297, 0.000000000000, -0.000000000000
                    ],
                    [
                        -0.000000000000, -0.000000000000, 0.000000000000,
                        0.000000000000, -0.009636306297, 0.000000000000
                    ],
                    [
                        -0.000250791503, 0.017270499333, 0.006142086782,
                        -0.000000000000, 0.000000000000, 0.015928515323
                    ],
                ],
                [
                    [
                        -0.000000000000, 0.000000000000, 0.000000000000,
                        0.002183433231, -0.000000000000, 0.000000000000
                    ],
                    [
                        0.000000000000, 0.000000000000, 0.000000000000,
                        -0.135209080764, 0.000000000000, 0.000000000000
                    ],
                    [
                        0.000000000000, -0.000000000000, 0.000000000000,
                        -0.002856451874, 0.000000000000, -0.000000000000
                    ],
                    [
                        -0.003746261036, -0.011725058662, -0.009636306297,
                        -0.000000000000, 0.000000000000, 0.009787397833
                    ],
                    [
                        0.000000000000, 0.000000000000, 0.000000000000,
                        0.000000000000, -0.000000000000, -0.000000000000
                    ],
                    [
                        -0.000000000000, 0.000000000000, -0.000000000000,
                        0.008018450351, -0.000000000000, 0.000000000000
                    ],
                ],
                [
                    [
                        0.000000000000, -0.000000000000, -0.000000000000,
                        -0.000000000000, 0.002183433231, -0.000000000000
                    ],
                    [
                        -0.000000000000, 0.000000000000, -0.000000000000,
                        0.000000000000, -0.135209080764, -0.000000000000
                    ],
                    [
                        -0.000000000000, -0.000000000000, -0.000000000000,
                        0.000000000000, -0.002856451874, 0.000000000000
                    ],
                    [
                        0.000000000000, 0.000000000000, 0.000000000000,
                        0.000000000000, -0.000000000000, -0.000000000000
                    ],
                    [
                        -0.003746261036, -0.011725058662, -0.009636306297,
                        -0.000000000000, 0.000000000000, 0.009787397833
                    ],
                    [
                        0.000000000000, -0.000000000000, 0.000000000000,
                        -0.000000000000, 0.008018450351, -0.000000000000
                    ],
                ],
                [
                    [
                        0.004439188661, -0.002370625927, 0.001846503447,
                        0.000000000000, -0.000000000000, -0.001658393584
                    ],
                    [
                        0.003402441045, -0.063526140121, 0.025670390781,
                        0.000000000000, -0.000000000000, -0.227020979292
                    ],
                    [
                        -0.000834936153, 0.017270499333, -0.004678725871,
                        -0.000000000000, 0.000000000000, 0.021647052157
                    ],
                    [
                        -0.000000000000, 0.000000000000, -0.000000000000,
                        0.009787397833, -0.000000000000, 0.000000000000
                    ],
                    [
                        0.000000000000, -0.000000000000, 0.000000000000,
                        -0.000000000000, 0.009787397833, 0.000000000000
                    ],
                    [
                        -0.000063787238, -0.061936163163, 0.015928515323,
                        0.000000000000, -0.000000000000, -0.067264366160
                    ],
                ],
            ],
            [
                [
                    [
                        0.069265962562, -0.005615181780, -0.010827827448,
                        -0.000000000000, 0.000000000000, 0.001154334853
                    ],
                    [
                        -0.006673055345, 0.001681601391, -0.000089614366,
                        0.000000000000, -0.000000000000, -0.000834936153
                    ],
                    [
                        -0.197826957050, 0.005532352522, -0.000916622790,
                        0.000000000000, -0.000000000000, -0.005204043582
                    ],
                    [
                        0.000000000000, 0.000000000000, 0.000000000000,
                        -0.005128439082, 0.000000000000, -0.000000000000
                    ],
                    [
                        -0.000000000000, -0.000000000000, -0.000000000000,
                        0.000000000000, -0.005128439082, 0.000000000000
                    ],
                    [
                        -0.008822983622, 0.001846503447, -0.002200444185,
                        -0.000000000000, 0.000000000000, -0.002151104101
                    ],
                ],
                [
                    [
                        -0.005615181780, 0.007962846504, -0.000089614366,
                        0.000000000000, -0.000000000000, -0.000250791503
                    ],
                    [
                        0.001681601391, 0.024247474654, -0.006506983943,
                        -0.000000000000, -0.000000000000, 0.017270499333
                    ],
                    [
                        0.005532352522, -0.111876537883, -0.003709099851,
                        -0.000000000000, 0.000000000000, 0.006142086782
                    ],
                    [
                        0.000000000000, 0.000000000000, 0.000000000000,
                        -0.009636306297, 0.000000000000, -0.000000000000
                    ],
                    [
                        -0.000000000000, -0.000000000000, -0.000000000000,
                        0.000000000000, -0.009636306297, 0.000000000000
                    ],
                    [
                        0.001846503447, 0.025670390781, -0.004678725871,
                        -0.000000000000, 0.000000000000, 0.015928515323
                    ],
                ],
                [
                    [
                        -0.010827827448, -0.000089614366, -0.000916622790,
                        0.000000000000, -0.000000000000, -0.002200444185
                    ],
                    [
                        -0.000089614366, -0.006506983943, -0.003709099851,
                        0.000000000000, -0.000000000000, -0.004678725871
                    ],
                    [
                        -0.000916622790, -0.003709099851, -0.168967499188,
                        0.000000000000, -0.000000000000, -0.017990952215
                    ],
                    [
                        0.000000000000, 0.000000000000, 0.000000000000,
                        -0.020638897124, 0.000000000000, -0.000000000000
                    ],
                    [
                        -0.000000000000, -0.000000000000, -0.000000000000,
                        0.000000000000, -0.020638897124, 0.000000000000
                    ],
                    [
                        -0.002200444185, -0.004678725871, -0.017990952215,
                        -0.000000000000, 0.000000000000, -0.013218346032
                    ],
                ],
                [
                    [
                        -0.000000000000, 0.000000000000, 0.000000000000,
                        0.002486872003, -0.000000000000, -0.000000000000
                    ],
                    [
                        0.000000000000, -0.000000000000, 0.000000000000,
                        -0.002856451874, 0.000000000000, -0.000000000000
                    ],
                    [
                        0.000000000000, -0.000000000000, 0.000000000000,
                        -0.141001886816, 0.000000000000, -0.000000000000
                    ],
                    [
                        -0.005128439082, -0.009636306297, -0.020638897124,
                        -0.000000000000, 0.000000000000, 0.006866059415
                    ],
                    [
                        0.000000000000, 0.000000000000, 0.000000000000,
                        -0.000000000000, -0.000000000000, -0.000000000000
                    ],
                    [
                        -0.000000000000, -0.000000000000, -0.000000000000,
                        -0.001097270199, 0.000000000000, -0.000000000000
                    ],
                ],
                [
                    [
                        0.000000000000, -0.000000000000, -0.000000000000,
                        -0.000000000000, 0.002486872003, 0.000000000000
                    ],
                    [
                        -0.000000000000, -0.000000000000, -0.000000000000,
                        0.000000000000, -0.002856451874, 0.000000000000
                    ],
                    [
                        -0.000000000000, 0.000000000000, -0.000000000000,
                        0.000000000000, -0.141001886816, 0.000000000000
                    ],
                    [
                        0.000000000000, 0.000000000000, 0.000000000000,
                        0.000000000000, 0.000000000000, -0.000000000000
                    ],
                    [
                        -0.005128439082, -0.009636306297, -0.020638897124,
                        -0.000000000000, -0.000000000000, 0.006866059415
                    ],
                    [
                        0.000000000000, 0.000000000000, 0.000000000000,
                        0.000000000000, -0.001097270199, -0.000000000000
                    ],
                ],
                [
                    [
                        0.001154334853, -0.000250791503, -0.002200444185,
                        -0.000000000000, 0.000000000000, 0.005668698026
                    ],
                    [
                        -0.000834936153, 0.017270499333, -0.004678725871,
                        -0.000000000000, 0.000000000000, 0.021647052157
                    ],
                    [
                        -0.005204043582, 0.006142086782, -0.017990952215,
                        -0.000000000000, 0.000000000000, -0.120733914243
                    ],
                    [
                        -0.000000000000, -0.000000000000, -0.000000000000,
                        0.006866059415, -0.000000000000, 0.000000000000
                    ],
                    [
                        0.000000000000, 0.000000000000, 0.000000000000,
                        -0.000000000000, 0.006866059415, -0.000000000000
                    ],
                    [
                        -0.002151104101, 0.015928515323, -0.013218346032,
                        -0.000000000000, -0.000000000000, 0.022026122252
                    ],
                ],
            ],
            [
                [
                    [
                        0.000000000000, -0.000000000000, -0.000000000000,
                        -0.004908970497, 0.000000000000, 0.000000000000
                    ],
                    [
                        -0.000000000000, 0.000000000000, 0.000000000000,
                        -0.003746261036, 0.000000000000, -0.000000000000
                    ],
                    [
                        0.000000000000, 0.000000000000, 0.000000000000,
                        -0.005128439082, 0.000000000000, -0.000000000000
                    ],
                    [
                        -0.198159464579, 0.002183433231, 0.002486872003,
                        -0.000000000000, -0.000000000000, -0.000286532578
                    ],
                    [
                        0.000000000000, 0.000000000000, 0.000000000000,
                        0.000000000000, -0.000000000000, -0.000000000000
                    ],
                    [
                        -0.000000000000, 0.000000000000, -0.000000000000,
                        0.003054099377, -0.000000000000, -0.000000000000
                    ],
                ],
                [
                    [
                        -0.000000000000, 0.000000000000, 0.000000000000,
                        -0.003746261036, 0.000000000000, -0.000000000000
                    ],
                    [
                        0.000000000000, 0.000000000000, -0.000000000000,
                        -0.011725058662, 0.000000000000, 0.000000000000
                    ],
                    [
                        0.000000000000, 0.000000000000, 0.000000000000,
                        -0.009636306297, 0.000000000000, -0.000000000000
                    ],
                    [
                        0.002183433231, -0.135209080764, -0.002856451874,
                        -0.000000000000, 0.000000000000, 0.008018450351
                    ],
                    [
                        0.000000000000, 0.000000000000, 0.000000000000,
                        0.000000000000, -0.000000000000, -0.000000000000
                    ],
                    [
                        0.000000000000, 0.000000000000, -0.000000000000,
                        0.009787397833, -0.000000000000, 0.000000000000
                    ],
                ],
                [
                    [
                        -0.000000000000, 0.000000000000, 0.000000000000,
                        -0.005128439082, 0.000000000000, -0.000000000000
                    ],
                    [
                        0.000000000000, -0.000000000000, -0.000000000000,
                        -0.009636306297, 0.000000000000, -0.000000000000
                    ],
                    [
                        0.000000000000, 0.000000000000, 0.000000000000,
                        -0.020638897124, 0.000000000000, -0.000000000000
                    ],
                    [
                        0.002486872003, -0.002856451874, -0.141001886816,
                        -0.000000000000, -0.000000000000, -0.001097270199
                    ],
                    [
                        0.000000000000, 0.000000000000, 0.000000000000,
                        0.000000000000, -0.000000000000, -0.000000000000
                    ],
                    [
                        -0.000000000000, -0.000000000000, -0.000000000000,
                        0.006866059415, -0.000000000000, -0.000000000000
                    ],
                ],
                [
                    [
                        -0.004908970497, -0.003746261036, -0.005128439082,
                        -0.000000000000, 0.000000000000, 0.003054099377
                    ],
                    [
                        -0.003746261036, -0.011725058662, -0.009636306297,
                        -0.000000000000, 0.000000000000, 0.009787397833
                    ],
                    [
                        -0.005128439082, -0.009636306297, -0.020638897124,
                        -0.000000000000, 0.000000000000, 0.006866059415
                    ],
                    [
                        -0.000000000000, -0.000000000000, -0.000000000000,
                        -0.156472755580, 0.000000000000, -0.000000000000
                    ],
                    [
                        0.000000000000, 0.000000000000, 0.000000000000,
                        0.000000000000, -0.008434569757, -0.000000000000
                    ],
                    [
                        0.003054099377, 0.009787397833, 0.006866059415,
                        -0.000000000000, -0.000000000000, -0.009856730019
                    ],
                ],
                [
                    [
                        0.000000000000, 0.000000000000, 0.000000000000,
                        0.000000000000, 0.000000000000, -0.000000000000
                    ],
                    [
                        0.000000000000, 0.000000000000, 0.000000000000,
                        0.000000000000, -0.000000000000, -0.000000000000
                    ],
                    [
                        0.000000000000, 0.000000000000, 0.000000000000,
                        0.000000000000, 0.000000000000, -0.000000000000
                    ],
                    [
                        -0.000000000000, 0.000000000000, -0.000000000000,
                        0.000000000000, -0.139603616066, -0.000000000000
                    ],
                    [
                        -0.000000000000, -0.000000000000, -0.000000000000,
                        -0.008434569757, 0.000000000000, 0.000000000000
                    ],
                    [
                        -0.000000000000, -0.000000000000, -0.000000000000,
                        -0.000000000000, -0.000000000000, 0.000000000000
                    ],
                ],
                [
                    [
                        0.000000000000, -0.000000000000, -0.000000000000,
                        0.003054099377, -0.000000000000, 0.000000000000
                    ],
                    [
                        -0.000000000000, 0.000000000000, -0.000000000000,
                        0.009787397833, -0.000000000000, 0.000000000000
                    ],
                    [
                        -0.000000000000, -0.000000000000, -0.000000000000,
                        0.006866059415, -0.000000000000, 0.000000000000
                    ],
                    [
                        -0.000286532578, 0.008018450351, -0.001097270199,
                        -0.000000000000, -0.000000000000, -0.134097123893
                    ],
                    [
                        -0.000000000000, -0.000000000000, -0.000000000000,
                        -0.000000000000, 0.000000000000, 0.000000000000
                    ],
                    [
                        -0.000000000000, 0.000000000000, -0.000000000000,
                        -0.009856730019, 0.000000000000, 0.000000000000
                    ],
                ],
            ],
            [
                [
                    [
                        -0.000000000000, 0.000000000000, 0.000000000000,
                        0.000000000000, -0.004908970497, -0.000000000000
                    ],
                    [
                        0.000000000000, -0.000000000000, -0.000000000000,
                        0.000000000000, -0.003746261036, 0.000000000000
                    ],
                    [
                        -0.000000000000, -0.000000000000, -0.000000000000,
                        0.000000000000, -0.005128439082, 0.000000000000
                    ],
                    [
                        0.000000000000, -0.000000000000, -0.000000000000,
                        0.000000000000, -0.000000000000, -0.000000000000
                    ],
                    [
                        -0.198159464579, 0.002183433231, 0.002486872003,
                        0.000000000000, 0.000000000000, -0.000286532578
                    ],
                    [
                        0.000000000000, -0.000000000000, 0.000000000000,
                        -0.000000000000, 0.003054099377, 0.000000000000
                    ],
                ],
                [
                    [
                        0.000000000000, -0.000000000000, -0.000000000000,
                        0.000000000000, -0.003746261036, 0.000000000000
                    ],
                    [
                        -0.000000000000, 0.000000000000, -0.000000000000,
                        0.000000000000, -0.011725058662, -0.000000000000
                    ],
                    [
                        -0.000000000000, -0.000000000000, -0.000000000000,
                        0.000000000000, -0.009636306297, 0.000000000000
                    ],
                    [
                        -0.000000000000, 0.000000000000, 0.000000000000,
                        0.000000000000, -0.000000000000, -0.000000000000
                    ],
                    [
                        0.002183433231, -0.135209080764, -0.002856451874,
                        -0.000000000000, 0.000000000000, 0.008018450351
                    ],
                    [
                        -0.000000000000, -0.000000000000, 0.000000000000,
                        -0.000000000000, 0.009787397833, -0.000000000000
                    ],
                ],
                [
                    [
                        0.000000000000, -0.000000000000, -0.000000000000,
                        0.000000000000, -0.005128439082, 0.000000000000
                    ],
                    [
                        -0.000000000000, -0.000000000000, 0.000000000000,
                        0.000000000000, -0.009636306297, 0.000000000000
                    ],
                    [
                        -0.000000000000, -0.000000000000, -0.000000000000,
                        0.000000000000, -0.020638897124, 0.000000000000
                    ],
                    [
                        -0.000000000000, 0.000000000000, 0.000000000000,
                        0.000000000000, -0.000000000000, 0.000000000000
                    ],
                    [
                        0.002486872003, -0.002856451874, -0.141001886816,
                        0.000000000000, -0.000000000000, -0.001097270199
                    ],
                    [
                        0.000000000000, 0.000000000000, 0.000000000000,
                        -0.000000000000, 0.006866059415, -0.000000000000
                    ],
                ],
                [
                    [
                        0.000000000000, 0.000000000000, 0.000000000000,
                        -0.000000000000, -0.000000000000, -0.000000000000
                    ],
                    [
                        0.000000000000, 0.000000000000, 0.000000000000,
                        0.000000000000, -0.000000000000, -0.000000000000
                    ],
                    [
                        0.000000000000, 0.000000000000, 0.000000000000,
                        -0.000000000000, -0.000000000000, -0.000000000000
                    ],
                    [
                        0.000000000000, 0.000000000000, 0.000000000000,
                        0.000000000000, -0.008434569757, -0.000000000000
                    ],
                    [
                        0.000000000000, -0.000000000000, 0.000000000000,
                        -0.139603616066, 0.000000000000, -0.000000000000
                    ],
                    [
                        -0.000000000000, -0.000000000000, -0.000000000000,
                        -0.000000000000, 0.000000000000, 0.000000000000
                    ],
                ],
                [
                    [
                        -0.004908970497, -0.003746261036, -0.005128439082,
                        -0.000000000000, 0.000000000000, 0.003054099377
                    ],
                    [
                        -0.003746261036, -0.011725058662, -0.009636306297,
                        -0.000000000000, 0.000000000000, 0.009787397833
                    ],
                    [
                        -0.005128439082, -0.009636306297, -0.020638897124,
                        -0.000000000000, -0.000000000000, 0.006866059415
                    ],
                    [
                        -0.000000000000, -0.000000000000, -0.000000000000,
                        -0.008434569757, 0.000000000000, 0.000000000000
                    ],
                    [
                        0.000000000000, 0.000000000000, -0.000000000000,
                        0.000000000000, -0.156472755580, -0.000000000000
                    ],
                    [
                        0.003054099377, 0.009787397833, 0.006866059415,
                        0.000000000000, -0.000000000000, -0.009856730019
                    ],
                ],
                [
                    [
                        -0.000000000000, 0.000000000000, 0.000000000000,
                        -0.000000000000, 0.003054099377, -0.000000000000
                    ],
                    [
                        0.000000000000, -0.000000000000, 0.000000000000,
                        -0.000000000000, 0.009787397833, 0.000000000000
                    ],
                    [
                        0.000000000000, 0.000000000000, 0.000000000000,
                        -0.000000000000, 0.006866059415, -0.000000000000
                    ],
                    [
                        -0.000000000000, -0.000000000000, 0.000000000000,
                        -0.000000000000, 0.000000000000, 0.000000000000
                    ],
                    [
                        -0.000286532578, 0.008018450351, -0.001097270199,
                        -0.000000000000, -0.000000000000, -0.134097123893
                    ],
                    [
                        0.000000000000, -0.000000000000, -0.000000000000,
                        0.000000000000, -0.009856730019, -0.000000000000
                    ],
                ],
            ],
            [
                [
                    [
                        -0.026319075365, 0.004439188661, 0.001154334853,
                        0.000000000000, -0.000000000000, -0.004245864867
                    ],
                    [
                        0.020457061704, -0.002370625927, -0.000250791503,
                        -0.000000000000, 0.000000000000, -0.000063787238
                    ],
                    [
                        -0.008822983622, 0.001846503447, -0.002200444185,
                        -0.000000000000, 0.000000000000, -0.002151104101
                    ],
                    [
                        -0.000000000000, 0.000000000000, -0.000000000000,
                        0.003054099377, -0.000000000000, -0.000000000000
                    ],
                    [
                        0.000000000000, -0.000000000000, 0.000000000000,
                        -0.000000000000, 0.003054099377, 0.000000000000
                    ],
                    [
                        -0.180871408859, -0.001658393584, 0.005668698026,
                        0.000000000000, -0.000000000000, 0.001514022306
                    ],
                ],
                [
                    [
                        0.004439188661, 0.003402441045, -0.000834936153,
                        -0.000000000000, 0.000000000000, -0.000063787238
                    ],
                    [
                        -0.002370625927, -0.063526140121, 0.017270499333,
                        0.000000000000, -0.000000000000, -0.061936163163
                    ],
                    [
                        0.001846503447, 0.025670390781, -0.004678725871,
                        -0.000000000000, 0.000000000000, 0.015928515323
                    ],
                    [
                        0.000000000000, 0.000000000000, -0.000000000000,
                        0.009787397833, -0.000000000000, 0.000000000000
                    ],
                    [
                        -0.000000000000, -0.000000000000, 0.000000000000,
                        -0.000000000000, 0.009787397833, -0.000000000000
                    ],
                    [
                        -0.001658393584, -0.227020979292, 0.021647052157,
                        0.000000000000, 0.000000000000, -0.067264366160
                    ],
                ],
                [
                    [
                        0.001154334853, -0.000834936153, -0.005204043582,
                        -0.000000000000, 0.000000000000, -0.002151104101
                    ],
                    [
                        -0.000250791503, 0.017270499333, 0.006142086782,
                        -0.000000000000, 0.000000000000, 0.015928515323
                    ],
                    [
                        -0.002200444185, -0.004678725871, -0.017990952215,
                        -0.000000000000, 0.000000000000, -0.013218346032
                    ],
                    [
                        -0.000000000000, -0.000000000000, -0.000000000000,
                        0.006866059415, -0.000000000000, -0.000000000000
                    ],
                    [
                        0.000000000000, 0.000000000000, 0.000000000000,
                        -0.000000000000, 0.006866059415, -0.000000000000
                    ],
                    [
                        0.005668698026, 0.021647052157, -0.120733914243,
                        0.000000000000, -0.000000000000, 0.022026122252
                    ],
                ],
                [
                    [
                        0.000000000000, -0.000000000000, -0.000000000000,
                        -0.000286532578, 0.000000000000, -0.000000000000
                    ],
                    [
                        -0.000000000000, 0.000000000000, -0.000000000000,
                        0.008018450351, -0.000000000000, 0.000000000000
                    ],
                    [
                        -0.000000000000, -0.000000000000, -0.000000000000,
                        -0.001097270199, 0.000000000000, -0.000000000000
                    ],
                    [
                        0.003054099377, 0.009787397833, 0.006866059415,
                        -0.000000000000, -0.000000000000, -0.009856730019
                    ],
                    [
                        -0.000000000000, -0.000000000000, -0.000000000000,
                        -0.000000000000, 0.000000000000, 0.000000000000
                    ],
                    [
                        0.000000000000, 0.000000000000, 0.000000000000,
                        -0.134097123893, 0.000000000000, 0.000000000000
                    ],
                ],
                [
                    [
                        -0.000000000000, 0.000000000000, 0.000000000000,
                        0.000000000000, -0.000286532578, 0.000000000000
                    ],
                    [
                        0.000000000000, -0.000000000000, 0.000000000000,
                        -0.000000000000, 0.008018450351, -0.000000000000
                    ],
                    [
                        0.000000000000, 0.000000000000, 0.000000000000,
                        0.000000000000, -0.001097270199, -0.000000000000
                    ],
                    [
                        -0.000000000000, -0.000000000000, -0.000000000000,
                        -0.000000000000, -0.000000000000, 0.000000000000
                    ],
                    [
                        0.003054099377, 0.009787397833, 0.006866059415,
                        0.000000000000, -0.000000000000, -0.009856730019
                    ],
                    [
                        -0.000000000000, 0.000000000000, -0.000000000000,
                        0.000000000000, -0.134097123893, -0.000000000000
                    ],
                ],
                [
                    [
                        -0.004245864867, -0.000063787238, -0.002151104101,
                        -0.000000000000, 0.000000000000, 0.001514022306
                    ],
                    [
                        -0.000063787238, -0.061936163163, 0.015928515323,
                        0.000000000000, -0.000000000000, -0.067264366160
                    ],
                    [
                        -0.002151104101, 0.015928515323, -0.013218346032,
                        -0.000000000000, -0.000000000000, 0.022026122252
                    ],
                    [
                        -0.000000000000, 0.000000000000, -0.000000000000,
                        -0.009856730019, 0.000000000000, 0.000000000000
                    ],
                    [
                        0.000000000000, -0.000000000000, -0.000000000000,
                        0.000000000000, -0.009856730019, -0.000000000000
                    ],
                    [
                        0.001514022306, -0.067264366160, 0.022026122252,
                        0.000000000000, -0.000000000000, -0.226979256575
                    ],
                ],
            ],
        ])

        return h1e, h2e, wfn

    elif target == "dipole":

        dip_ref = np.array([0.000000000000, -0.000000000000, 12.281283595669])

        dip_mat = np.array([
            [
                [
                    -0.000000000000, 0.000000000000, -0.000000000000,
                    -0.097319048732, 0.181959198487, 0.000000000000
                ],
                [
                    0.000000000000, 0.000000000000, 0.000000000000,
                    -0.460281402069, 0.860596523393, -0.000000000000
                ],
                [
                    -0.000000000000, 0.000000000000, -0.000000000000,
                    -0.643791246003, 1.203708221992, 0.000000000000
                ],
                [
                    -0.097319048732, -0.460281402069, -0.643791246003,
                    -0.000000000000, -0.000000000000, 0.408732594627
                ],
                [
                    0.181959198487, 0.860596523393, 1.203708221992,
                    -0.000000000000, 0.000000000000, -0.764214778942
                ],
                [
                    0.000000000000, -0.000000000000, 0.000000000000,
                    0.408732594627, -0.764214778942, -0.000000000000
                ],
            ],
            [
                [
                    0.000000000000, 0.000000000000, -0.000000000000,
                    0.181959198487, 0.097319048732, 0.000000000000
                ],
                [
                    0.000000000000, 0.000000000000, -0.000000000000,
                    0.860596523393, 0.460281402069, 0.000000000000
                ],
                [
                    -0.000000000000, -0.000000000000, -0.000000000000,
                    1.203708221992, 0.643791246003, 0.000000000000
                ],
                [
                    0.181959198487, 0.860596523393, 1.203708221992,
                    0.000000000000, 0.000000000000, -0.764214778942
                ],
                [
                    0.097319048732, 0.460281402069, 0.643791246003,
                    0.000000000000, 0.000000000000, -0.408732594627
                ],
                [
                    0.000000000000, 0.000000000000, 0.000000000000,
                    -0.764214778942, -0.408732594627, -0.000000000000
                ],
            ],
            [
                [
                    -0.002022198765, 0.109184978254, -0.144952227695,
                    -0.000000000000, -0.000000000000, -0.117389831351
                ],
                [
                    0.109184978254, 2.464623177255, -0.430837039263,
                    -0.000000000000, -0.000000000000, 0.704703631330
                ],
                [
                    -0.144952227695, -0.430837039263, -1.631390411173,
                    -0.000000000000, -0.000000000000, -0.984504810605
                ],
                [
                    -0.000000000000, -0.000000000000, -0.000000000000,
                    -0.000000000000, -0.000000000000, -0.000000000000
                ],
                [
                    -0.000000000000, -0.000000000000, -0.000000000000,
                    -0.000000000000, -0.000000000000, -0.000000000000
                ],
                [
                    -0.117389831351, 0.704703631330, -0.984504810605,
                    -0.000000000000, -0.000000000000, 1.816974245432
                ],
            ],
        ])

        return dip_ref, dip_mat, wfn

    else:
        raise ValueError(
            "Expected 'energy' or 'dipole' for arg `target` but received "
            f"{target}.")
