# OpenFermion-FQE
The Fermionic Quantum Emulator (FQE) is a light weight fermionic circuit simulator.  
The emulator uses number and projected spin quantum numbers to reduce the cost of simulating state 
evolutions under fermionic generators. 

![Python package](https://github.com/quantumlib/OpenFermion-FQE/workflows/Python%20package/badge.svg?branch=master)

## Getting Started
Installing FQE requires pip. Make sure that you are using an up-to-date version of it. 
For information about getting started beyond what is provided below please see our 
tutorial in the examples folder as well as our detailed code documentation.

To build the docs navigate the the `docs` folder in the command line and type `make html`.

## How to contribute
We'd love to accept your contributions and patches to OpenFermion-FQE. 
There are a few small guidelines you need to follow. 
Contributions to OpenFermion-FQE must be accompanied by a Contributor License Agreement. 
You (or your employer) retain the copyright to your contribution, this simply gives us permission 
to use and redistribute your contributions as part of the project. 
Head over to https://cla.developers.google.com/ to see your current agreements on file or to sign a new one.

All submissions, including submissions by project members, require review. 
We use GitHub pull requests for this purpose. Consult GitHub Help for more information on using pull requests. 
Furthermore, please make sure your new code comes with extensive tests! We use automatic testing to 
make sure all pull requests pass tests and do not decrease overall test coverage by too much. 
Make sure you adhere to our style guide. Just have a look at our code for clues. 
We mostly follow PEP 8 and use the corresponding linter to check for it. 
Code should always come with documentation, which is generated automatically and can be found here.

We use Github issues for tracking requests and bugs. 
Please post questions to the Quantum Computing Stack Exchange with an 'openfermion-fqe' tag.

## How to cite
When using OpenFermion-FQE for research projects, please cite:

```
@misc{fqe_2020,
    author       = {Nicholas C. Rubin, Toru Shiozaki, Kyle Throssell, Garnet Chan, Ryan Babbush},
    title        = {The Fermionic Quantum Emulator},
    month        = {Aug},
    year         = {2020},
    url          = {https://github.com/quantumlib/OpenFermion-FQE} 
    }
```

## Disclaimer
Copyright 2020 Google LLC. This is not an official Google product.
