/*
 * Decompiled with CFR 0.152.
 */
package org.planit.output.configuration;

import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import org.planit.network.physical.macroscopic.MacroscopicLinkSegmentImpl;
import org.planit.output.configuration.OutputTypeConfiguration;
import org.planit.output.enums.OutputType;
import org.planit.output.enums.RouteIdType;
import org.planit.output.property.BaseOutputProperty;
import org.planit.output.property.OutputProperty;
import org.planit.trafficassignment.TrafficAssignment;
import org.planit.utils.exceptions.PlanItException;

public class PathOutputTypeConfiguration
extends OutputTypeConfiguration {
    private static final Logger LOGGER = Logger.getLogger(MacroscopicLinkSegmentImpl.class.getCanonicalName());
    private static final int ORIGIN_DESTINATION_ID_IDENTIFICATION = 1;
    private static final int ORIGIN_DESTINATION_EXTERNAL_ID_IDENTIFICATION = 2;
    private static final int ORIGIN_DESTINATION_NOT_IDENTIFIED = 3;
    private RouteIdType pathIdType;

    private int findIdentificationMethod(OutputProperty[] outputKeyProperties) {
        List<OutputProperty> outputKeyPropertyList = Arrays.asList(outputKeyProperties);
        if (outputKeyPropertyList.contains((Object)OutputProperty.ORIGIN_ZONE_ID) && outputKeyPropertyList.contains((Object)OutputProperty.DESTINATION_ZONE_ID)) {
            return 1;
        }
        if (outputKeyPropertyList.contains((Object)OutputProperty.ORIGIN_ZONE_EXTERNAL_ID) && outputKeyPropertyList.contains((Object)OutputProperty.DESTINATION_ZONE_EXTERNAL_ID)) {
            return 2;
        }
        return 3;
    }

    public PathOutputTypeConfiguration(TrafficAssignment trafficAssignment) throws PlanItException {
        super(trafficAssignment, OutputType.PATH);
        this.addProperty(OutputProperty.RUN_ID);
        this.addProperty(OutputProperty.PATH_ID);
        this.addProperty(OutputProperty.TIME_PERIOD_EXTERNAL_ID);
        this.addProperty(OutputProperty.MODE_EXTERNAL_ID);
        this.addProperty(OutputProperty.ORIGIN_ZONE_EXTERNAL_ID);
        this.addProperty(OutputProperty.DESTINATION_ZONE_EXTERNAL_ID);
        this.addProperty(OutputProperty.PATH_STRING);
        this.pathIdType = RouteIdType.LINK_SEGMENT_EXTERNAL_ID;
    }

    @Override
    public OutputProperty[] validateAndFilterKeyProperties(OutputProperty[] outputKeyProperties) {
        OutputProperty[] outputKeyPropertiesArray = null;
        boolean valid = false;
        switch (this.findIdentificationMethod(outputKeyProperties)) {
            case 1: {
                outputKeyPropertiesArray = new OutputProperty[]{OutputProperty.ORIGIN_ZONE_ID, OutputProperty.DESTINATION_ZONE_ID};
                valid = true;
                break;
            }
            case 2: {
                outputKeyPropertiesArray = new OutputProperty[]{OutputProperty.ORIGIN_ZONE_EXTERNAL_ID, OutputProperty.DESTINATION_ZONE_EXTERNAL_ID};
                valid = true;
                break;
            }
            default: {
                LOGGER.warning("configured keys cannot identify origin-destination cell in the skim matrix");
            }
        }
        if (valid) {
            return outputKeyPropertiesArray;
        }
        return null;
    }

    public void setPathIdType(RouteIdType pathIdType) throws PlanItException {
        this.pathIdType = pathIdType;
    }

    public RouteIdType getPathIdType() {
        return this.pathIdType;
    }

    @Override
    public boolean isOutputPropertyValid(BaseOutputProperty baseOutputProperty) {
        switch (baseOutputProperty.getOutputProperty()) {
            case DESTINATION_ZONE_EXTERNAL_ID: {
                return true;
            }
            case DESTINATION_ZONE_ID: {
                return true;
            }
            case ITERATION_INDEX: {
                return true;
            }
            case MODE_EXTERNAL_ID: {
                return true;
            }
            case MODE_ID: {
                return true;
            }
            case PATH_STRING: {
                return true;
            }
            case ORIGIN_ZONE_EXTERNAL_ID: {
                return true;
            }
            case ORIGIN_ZONE_ID: {
                return true;
            }
            case RUN_ID: {
                return true;
            }
            case PATH_ID: {
                return true;
            }
            case TIME_PERIOD_EXTERNAL_ID: {
                return true;
            }
            case TIME_PERIOD_ID: {
                return true;
            }
        }
        LOGGER.warning("tried to add " + baseOutputProperty.getName() + " as an ouput property, which is inappropriate for Path output.  This will be ignored");
        return false;
    }
}

