/*
 * Decompiled with CFR 0.152.
 */
package org.planit.od.odmatrix;

import java.util.logging.Logger;
import org.ojalgo.array.Array2D;
import org.planit.network.virtual.Zoning;
import org.planit.od.ODDataImpl;
import org.planit.od.odmatrix.ODMatrixIterator;
import org.planit.utils.network.virtual.Zone;

public abstract class ODMatrix
extends ODDataImpl<Double> {
    private static final Logger LOGGER = Logger.getLogger(ODMatrix.class.getCanonicalName());
    protected Array2D<Double> matrixContents = Array2D.PRIMITIVE32.makeZero(this.getNumberOfTravelAnalysisZones(), this.getNumberOfTravelAnalysisZones());

    public ODMatrix(Zoning.Zones zones) {
        super(zones);
    }

    @Override
    public void setValue(Zone origin, Zone destination, Double value) {
        long destinationId;
        long originId = origin.getId();
        if (originId == (destinationId = destination.getId())) {
            this.matrixContents.set(originId, destinationId, 0.0);
        } else {
            this.matrixContents.set(originId, destinationId, value);
        }
    }

    @Override
    public Double getValue(Zone origin, Zone destination) {
        long originId = origin.getId();
        long destinationId = destination.getId();
        return this.matrixContents.get(originId, destinationId);
    }

    public ODMatrixIterator iterator() {
        return new ODMatrixIterator(this.matrixContents, this.zones);
    }
}

