/*
 * Decompiled with CFR 0.152.
 */
package org.planit.network.virtual;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import org.planit.demands.Demands;
import org.planit.network.physical.PhysicalNetwork;
import org.planit.network.virtual.VirtualNetwork;
import org.planit.network.virtual.ZoneImpl;
import org.planit.od.odmatrix.demand.ODDemandMatrix;
import org.planit.time.TimePeriod;
import org.planit.trafficassignment.TrafficAssignmentComponent;
import org.planit.utils.id.IdGroupingToken;
import org.planit.utils.network.physical.Mode;
import org.planit.utils.network.virtual.Centroid;
import org.planit.utils.network.virtual.Zone;

public class Zoning
extends TrafficAssignmentComponent<Zoning>
implements Serializable {
    private static final long serialVersionUID = -2986366471146628179L;
    private static final Logger LOGGER = Logger.getLogger(Zoning.class.getCanonicalName());
    protected final Map<Long, Zone> zoneMap = new TreeMap<Long, Zone>();
    protected final VirtualNetwork virtualNetwork;
    public final Zones zones = new Zones();

    public Zoning(IdGroupingToken groupId, IdGroupingToken networkGroupId) {
        super(groupId, Zoning.class);
        this.virtualNetwork = new VirtualNetwork(networkGroupId);
    }

    public VirtualNetwork getVirtualNetwork() {
        return this.virtualNetwork;
    }

    public boolean isCompatibleWithDemands(Demands demands, PhysicalNetwork.Modes modes) {
        int noZonesInZoning = this.zones.getNumberOfZones();
        for (Mode mode : modes) {
            for (TimePeriod timePeriod : demands.timePeriods) {
                ODDemandMatrix odMatrix = demands.get(mode, timePeriod);
                if (odMatrix == null || noZonesInZoning == odMatrix.getNumberOfTravelAnalysisZones()) continue;
                return false;
            }
        }
        return true;
    }

    public class Zones
    implements Iterable<Zone> {
        protected Zone registerZone(Zone zone) {
            return Zoning.this.zoneMap.put(zone.getId(), zone);
        }

        public Zone createAndRegisterNewZone(Object externalId) {
            ZoneImpl newZone = new ZoneImpl(Zoning.this.groupId, externalId);
            Centroid centroid = Zoning.this.virtualNetwork.centroids.registerNewCentroid(newZone);
            newZone.setCentroid(centroid);
            this.registerZone(newZone);
            return newZone;
        }

        public Zone getZoneById(long id) {
            return Zoning.this.zoneMap.get(id);
        }

        @Override
        public Iterator<Zone> iterator() {
            return Zoning.this.zoneMap.values().iterator();
        }

        public int getNumberOfZones() {
            return Zoning.this.zoneMap.size();
        }
    }
}

