/*
 * Decompiled with CFR 0.152.
 */
package org.planit.network.virtual;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.planit.network.virtual.CentroidImpl;
import org.planit.network.virtual.ConnectoidImpl;
import org.planit.network.virtual.ConnectoidSegmentImpl;
import org.planit.utils.exceptions.PlanItException;
import org.planit.utils.id.IdGroupingToken;
import org.planit.utils.network.physical.Node;
import org.planit.utils.network.virtual.Centroid;
import org.planit.utils.network.virtual.Connectoid;
import org.planit.utils.network.virtual.ConnectoidSegment;
import org.planit.utils.network.virtual.Zone;

public class VirtualNetwork {
    protected final IdGroupingToken groupId;
    protected Map<Long, Connectoid> connectoidMap = new TreeMap<Long, Connectoid>();
    protected Map<Long, ConnectoidSegment> connectoidSegmentMap = new TreeMap<Long, ConnectoidSegment>();
    protected Map<Long, Centroid> centroidMap = new TreeMap<Long, Centroid>();
    public final Connectoids connectoids = new Connectoids();
    public final ConnectoidSegments connectoidSegments = new ConnectoidSegments();
    public final Centroids centroids = new Centroids();

    public VirtualNetwork(IdGroupingToken groupId) {
        this.groupId = groupId;
    }

    public class Centroids
    implements Iterable<Centroid> {
        public Centroid registerCentroid(Centroid centroid) {
            return VirtualNetwork.this.centroidMap.put(centroid.getId(), centroid);
        }

        public Centroid registerNewCentroid(Zone zone) {
            CentroidImpl newCentroid = new CentroidImpl(VirtualNetwork.this.groupId, zone);
            this.registerCentroid(newCentroid);
            return newCentroid;
        }

        @Override
        public Iterator<Centroid> iterator() {
            return VirtualNetwork.this.centroidMap.values().iterator();
        }

        public int getNumberOfCentroids() {
            return VirtualNetwork.this.centroidMap.size();
        }
    }

    public class ConnectoidSegments
    implements Iterable<ConnectoidSegment> {
        protected ConnectoidSegment registerConnectoidSegment(ConnectoidSegment connectoidSegment) {
            return VirtualNetwork.this.connectoidSegmentMap.put(connectoidSegment.getId(), connectoidSegment);
        }

        @Override
        public Iterator<ConnectoidSegment> iterator() {
            return VirtualNetwork.this.connectoidSegmentMap.values().iterator();
        }

        public ConnectoidSegment createAndRegisterConnectoidSegment(Connectoid parentConnectoid, boolean directionAB) throws PlanItException {
            ConnectoidSegmentImpl connectoidSegment = new ConnectoidSegmentImpl(VirtualNetwork.this.groupId, parentConnectoid, directionAB);
            parentConnectoid.registerConnectoidSegment(connectoidSegment, directionAB);
            this.registerConnectoidSegment(connectoidSegment);
            return connectoidSegment;
        }

        public ConnectoidSegment getConnectoidSegment(long id) {
            return VirtualNetwork.this.connectoidSegmentMap.get(id);
        }

        public int getNumberOfConnectoidSegments() {
            return VirtualNetwork.this.connectoidSegmentMap.size();
        }
    }

    public class Connectoids
    implements Iterable<Connectoid> {
        protected Connectoid registerConnectoid(Connectoid connectoid) {
            return VirtualNetwork.this.connectoidMap.put(connectoid.getId(), connectoid);
        }

        public Connectoid registerNewConnectoid(Centroid centroid, Node node, double length, Object externalId) throws PlanItException {
            ConnectoidImpl newConnectoid = new ConnectoidImpl(VirtualNetwork.this.groupId, centroid, node, length, externalId);
            this.registerConnectoid(newConnectoid);
            return newConnectoid;
        }

        public Connectoid registerNewConnectoid(Centroid centroid, Node node, double length) throws PlanItException {
            ConnectoidImpl newConnectoid = new ConnectoidImpl(VirtualNetwork.this.groupId, centroid, node, length);
            this.registerConnectoid(newConnectoid);
            return newConnectoid;
        }

        public Connectoid getConnectoid(long id) {
            return VirtualNetwork.this.connectoidMap.get(id);
        }

        public int getNumberOfConnectoids() {
            return VirtualNetwork.this.connectoidMap.size();
        }

        @Override
        public Iterator<Connectoid> iterator() {
            return VirtualNetwork.this.connectoidMap.values().iterator();
        }
    }
}

