/*
 * Decompiled with CFR 0.152.
 */
package org.planit.io.xml.network;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.planit.input.InputBuilderListener;
import org.planit.io.xml.network.physical.macroscopic.MacroscopicLinkSegmentTypeXmlHelper;
import org.planit.network.physical.PhysicalNetwork;
import org.planit.utils.exceptions.PlanItException;
import org.planit.utils.network.physical.Mode;
import org.planit.xml.generated.XMLElementLinkConfiguration;
import org.planit.xml.generated.XMLElementLinkSegmentTypes;
import org.planit.xml.generated.XMLElementModes;

public class ProcessLinkConfiguration {
    private static final Logger LOGGER = Logger.getLogger(ProcessLinkConfiguration.class.getCanonicalName());

    public static void createAndRegisterModes(PhysicalNetwork physicalNetwork, XMLElementLinkConfiguration linkconfiguration, InputBuilderListener inputBuilderListener) throws PlanItException {
        for (XMLElementModes.Mode generatedMode : linkconfiguration.getModes().getMode()) {
            double pcu;
            long externalModeId = generatedMode.getId().longValue();
            if (externalModeId == 0L) {
                String errorMessage = "Found a Mode value of 0 in the modes definition file, this is prohibited";
                throw new PlanItException(errorMessage);
            }
            String name = generatedMode.getName();
            Mode mode = physicalNetwork.modes.registerNewMode(externalModeId, name, pcu = (double)generatedMode.getPcu().floatValue());
            boolean duplicateModeExternalId = inputBuilderListener.addModeToExternalIdMap(mode.getExternalId(), mode);
            if (!duplicateModeExternalId || !inputBuilderListener.isErrorIfDuplicateExternalId()) continue;
            String errorMessage = "Duplicate mode external id " + mode.getExternalId() + " found in network file.";
            throw new PlanItException(errorMessage);
        }
    }

    public static Map<Long, MacroscopicLinkSegmentTypeXmlHelper> createLinkSegmentTypeHelperMap(XMLElementLinkConfiguration linkconfiguration, InputBuilderListener inputBuilderListener) throws PlanItException {
        MacroscopicLinkSegmentTypeXmlHelper.reset();
        HashMap<Long, MacroscopicLinkSegmentTypeXmlHelper> macroscopicLinkSegmentTypeXmlHelperMap = new HashMap<Long, MacroscopicLinkSegmentTypeXmlHelper>();
        for (XMLElementLinkSegmentTypes.Linksegmenttype linkSegmentTypeGenerated : linkconfiguration.getLinksegmenttypes().getLinksegmenttype()) {
            long externalId = linkSegmentTypeGenerated.getId().longValue();
            if (macroscopicLinkSegmentTypeXmlHelperMap.containsKey(externalId) && inputBuilderListener.isErrorIfDuplicateExternalId()) {
                String errorMessage = "Duplicate link segment type external id " + externalId + " found in network file.";
                throw new PlanItException(errorMessage);
            }
            String name = linkSegmentTypeGenerated.getName();
            double capacity = linkSegmentTypeGenerated.getCapacitylane() == null ? 1800.0 : (double)linkSegmentTypeGenerated.getCapacitylane().floatValue();
            double maximumDensity = linkSegmentTypeGenerated.getMaxdensitylane() == null ? 180.0 : (double)linkSegmentTypeGenerated.getMaxdensitylane().floatValue();
            for (XMLElementLinkSegmentTypes.Linksegmenttype.Modes.Mode mode : linkSegmentTypeGenerated.getModes().getMode()) {
                int modeExternalId = mode.getRef().intValue();
                double maxSpeed = mode.getMaxspeed() == null ? 80.0 : (double)mode.getMaxspeed().floatValue();
                double critSpeed = mode.getCritspeed() == null ? 60.0 : (double)mode.getCritspeed().floatValue();
                MacroscopicLinkSegmentTypeXmlHelper macroscopicLinkSegmentTypeXmlHelper = MacroscopicLinkSegmentTypeXmlHelper.createOrUpdateLinkSegmentTypeHelper(name, capacity, maximumDensity, maxSpeed, critSpeed, modeExternalId, externalId, inputBuilderListener);
                macroscopicLinkSegmentTypeXmlHelperMap.put(externalId, macroscopicLinkSegmentTypeXmlHelper);
            }
        }
        return macroscopicLinkSegmentTypeXmlHelperMap;
    }
}

