/*
 * Decompiled with CFR 0.152.
 */
package org.planit.io.input;

import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.LongFunction;
import java.util.logging.Logger;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.djutils.event.EventInterface;
import org.opengis.geometry.DirectPosition;
import org.planit.cost.physical.initial.InitialLinkSegmentCost;
import org.planit.cost.physical.initial.InitialPhysicalCost;
import org.planit.demands.Demands;
import org.planit.input.InputBuilderListener;
import org.planit.io.xml.demands.DemandsPopulator;
import org.planit.io.xml.demands.ProcessConfiguration;
import org.planit.io.xml.network.ProcessInfrastructure;
import org.planit.io.xml.network.ProcessLinkConfiguration;
import org.planit.io.xml.network.physical.macroscopic.MacroscopicLinkSegmentTypeXmlHelper;
import org.planit.io.xml.util.XmlUtils;
import org.planit.io.xml.zoning.UpdateZoning;
import org.planit.network.physical.PhysicalNetwork;
import org.planit.network.physical.macroscopic.MacroscopicNetwork;
import org.planit.network.virtual.Zoning;
import org.planit.output.property.BaseOutputProperty;
import org.planit.output.property.OutputProperty;
import org.planit.trafficassignment.TrafficAssignmentComponentFactory;
import org.planit.utils.exceptions.PlanItException;
import org.planit.utils.misc.LoggingUtils;
import org.planit.utils.network.physical.LinkSegment;
import org.planit.utils.network.physical.Mode;
import org.planit.utils.network.virtual.Centroid;
import org.planit.utils.network.virtual.Zone;
import org.planit.xml.generated.XMLElementDemandConfiguration;
import org.planit.xml.generated.XMLElementInfrastructure;
import org.planit.xml.generated.XMLElementLinkConfiguration;
import org.planit.xml.generated.XMLElementLinkSegmentTypes;
import org.planit.xml.generated.XMLElementMacroscopicDemand;
import org.planit.xml.generated.XMLElementMacroscopicNetwork;
import org.planit.xml.generated.XMLElementMacroscopicZoning;
import org.planit.xml.generated.XMLElementModes;
import org.planit.xml.generated.XMLElementOdMatrix;
import org.planit.xml.generated.XMLElementPLANit;
import org.planit.xml.generated.XMLElementZones;

public class PlanItInputBuilder
extends InputBuilderListener {
    private static final long serialVersionUID = -8928911341112445424L;
    private static final Logger LOGGER = Logger.getLogger(PlanItInputBuilder.class.getCanonicalName());
    private XMLElementMacroscopicNetwork macroscopicnetwork;
    private XMLElementMacroscopicDemand macroscopicdemand;
    private XMLElementMacroscopicZoning macroscopiczoning;
    private static final String DEFAULT_XML_NAME_EXTENSION = ".xml";
    private static final float DEFAULT_PCU_VALUE = 1.0f;
    private static final long DEFAULT_EXTERNAL_ID = 1L;
    private static final float DEFAULT_MAXIMUM_CAPACITY_PER_LANE = 1800.0f;
    private static final String NETWORK_XSD_FILE = "src\\main\\resources\\xsd\\macroscopicnetworkinput.xsd";
    private static final String ZONING_XSD_FILE = "src\\main\\resources\\xsd\\macroscopiczoninginput.xsd";
    private static final String DEMAND_XSD_FILE = "src\\main\\resources\\xsd\\macroscopicdemandinput.xsd";
    public static final String DEFAULT_SEPARATOR = ",";

    private void createGeneratedClassesFromXmlLocations(String zoningXmlFileLocation, String demandXmlFileLocation, String networkXmlFileLocation) throws PlanItException {
        try {
            this.macroscopiczoning = (XMLElementMacroscopicZoning)XmlUtils.generateObjectFromXml(XMLElementMacroscopicZoning.class, zoningXmlFileLocation);
            this.macroscopicdemand = (XMLElementMacroscopicDemand)XmlUtils.generateObjectFromXml(XMLElementMacroscopicDemand.class, demandXmlFileLocation);
            this.macroscopicnetwork = (XMLElementMacroscopicNetwork)XmlUtils.generateObjectFromXml(XMLElementMacroscopicNetwork.class, networkXmlFileLocation);
        }
        catch (Exception e) {
            LOGGER.severe(e.getMessage());
            throw new PlanItException("Error while generating classes from XML locations in PLANitIO", e);
        }
    }

    private void setInputFiles(String projectPath, String xmlNameExtension) throws PlanItException {
        String[] xmlFileNames = this.getXmlFileNames(projectPath, xmlNameExtension);
        boolean inputFilesSet = this.setInputFilesSingleFile(xmlFileNames) || this.setInputFilesSeparateFiles(xmlFileNames);
        PlanItException.throwIf(!inputFilesSet, "The directory " + projectPath + " does not contain either one file with all the macroscopic inputs or a separate file for each of zoning, demand and network");
    }

    private String[] getXmlFileNames(String projectPath, String xmlNameExtension) throws PlanItException {
        File xmlFilesDirectory = new File(projectPath);
        PlanItException.throwIf(!xmlFilesDirectory.isDirectory(), projectPath + " is not a valid directory");
        String[] fileNames = xmlFilesDirectory.list((d, name) -> name.endsWith(xmlNameExtension));
        PlanItException.throwIf(fileNames.length == 0, "Directory " + projectPath + " contains no files with extension " + xmlNameExtension);
        for (int i = 0; i < fileNames.length; ++i) {
            fileNames[i] = projectPath + "\\" + fileNames[i];
        }
        return fileNames;
    }

    private boolean setInputFilesSingleFile(String[] xmlFileNames) {
        for (int i = 0; i < xmlFileNames.length; ++i) {
            try {
                XMLElementPLANit planit = (XMLElementPLANit)XmlUtils.generateObjectFromXml(XMLElementPLANit.class, xmlFileNames[i]);
                this.macroscopiczoning = planit.getMacroscopiczoning();
                this.macroscopicnetwork = planit.getMacroscopicnetwork();
                this.macroscopicdemand = planit.getMacroscopicdemand();
                LOGGER.info(LoggingUtils.getClassNameWithBrackets(this) + "file " + xmlFileNames[i] + " provides the network, demands and zoning input data.");
                return true;
            }
            catch (Exception exception) {
                continue;
            }
        }
        return false;
    }

    private boolean setInputFilesSeparateFiles(String[] xmlFileNames) {
        boolean foundZoningFile = false;
        boolean foundNetworkFile = false;
        boolean foundDemandFile = false;
        for (int i = 0; i < xmlFileNames.length; ++i) {
            if (!foundZoningFile) {
                try {
                    this.macroscopiczoning = (XMLElementMacroscopicZoning)XmlUtils.generateObjectFromXml(XMLElementMacroscopicZoning.class, xmlFileNames[i]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                foundZoningFile = true;
                LOGGER.info(LoggingUtils.getClassNameWithBrackets(this) + "file " + xmlFileNames[i] + " provides the zoning input data.");
                continue;
            }
            if (!foundNetworkFile) {
                try {
                    this.macroscopicnetwork = (XMLElementMacroscopicNetwork)XmlUtils.generateObjectFromXml(XMLElementMacroscopicNetwork.class, xmlFileNames[i]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                foundNetworkFile = true;
                LOGGER.info(LoggingUtils.getClassNameWithBrackets(this) + "file " + xmlFileNames[i] + " provides the network input data.");
                continue;
            }
            if (foundDemandFile) continue;
            try {
                this.macroscopicdemand = (XMLElementMacroscopicDemand)XmlUtils.generateObjectFromXml(XMLElementMacroscopicDemand.class, xmlFileNames[i]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            foundDemandFile = true;
            LOGGER.info(LoggingUtils.getClassNameWithBrackets(this) + "file " + xmlFileNames[i] + " provides the demand input data.");
        }
        return foundZoningFile && foundNetworkFile && foundDemandFile;
    }

    private void setInputFilesSeparateFilesWithValidation(String projectPath, String[] xmlFileNames) throws PlanItException {
        boolean foundZoningFile = false;
        String zoningFileName = null;
        boolean foundNetworkFile = false;
        String networkFileName = null;
        boolean foundDemandFile = false;
        String demandFileName = null;
        for (int i = 0; i < xmlFileNames.length; ++i) {
            if (zoningFileName == null && PlanItInputBuilder.validateXmlInputFile(xmlFileNames[i], ZONING_XSD_FILE)) {
                zoningFileName = xmlFileNames[i];
            }
            if (networkFileName == null && PlanItInputBuilder.validateXmlInputFile(xmlFileNames[i], NETWORK_XSD_FILE)) {
                networkFileName = xmlFileNames[i];
            }
            if (demandFileName != null || !PlanItInputBuilder.validateXmlInputFile(xmlFileNames[i], DEMAND_XSD_FILE)) continue;
            demandFileName = xmlFileNames[i];
        }
        PlanItException.throwIf(zoningFileName == null, "Failed to find a valid zoning input file in the project directory " + projectPath);
        PlanItException.throwIf(networkFileName == null, "Failed to find a valid network input file in the project directory " + projectPath);
        PlanItException.throwIf(demandFileName == null, "Failed to find a valid demand input file in the project directory " + projectPath);
        LOGGER.info(LoggingUtils.getClassNameWithBrackets(this) + "file " + zoningFileName + " provides the zoning input data.");
        LOGGER.info(LoggingUtils.getClassNameWithBrackets(this) + "file " + networkFileName + " provides the network input data.");
        LOGGER.info(LoggingUtils.getClassNameWithBrackets(this) + "file " + demandFileName + " provides the demand input data.");
        this.createGeneratedClassesFromXmlLocations(zoningFileName, demandFileName, networkFileName);
    }

    private OutputProperty getLinkIdentificationMethod(Set<String> headers) throws PlanItException {
        boolean linkSegmentExternalIdPresent = false;
        boolean linkSegmentIdPresent = false;
        boolean upstreamNodeExternalIdPresent = false;
        boolean downstreamNodeExternalIdPresent = false;
        boolean modeExternalIdPresent = false;
        boolean costPresent = false;
        for (String header : headers) {
            OutputProperty outputProperty = OutputProperty.fromHeaderName(header);
            switch (outputProperty) {
                case LINK_SEGMENT_EXTERNAL_ID: {
                    linkSegmentExternalIdPresent = true;
                    break;
                }
                case LINK_SEGMENT_ID: {
                    linkSegmentIdPresent = true;
                    break;
                }
                case MODE_EXTERNAL_ID: {
                    modeExternalIdPresent = true;
                    break;
                }
                case UPSTREAM_NODE_EXTERNAL_ID: {
                    upstreamNodeExternalIdPresent = true;
                    break;
                }
                case DOWNSTREAM_NODE_EXTERNAL_ID: {
                    downstreamNodeExternalIdPresent = true;
                    break;
                }
                case LINK_COST: {
                    costPresent = true;
                }
            }
        }
        PlanItException.throwIf(!costPresent, "Cost column not present in initial link segment costs file");
        PlanItException.throwIf(!modeExternalIdPresent, "Mode External Id not present in initial link segment costs file");
        PlanItException.throwIf(!modeExternalIdPresent, "Mode External Id not present in initial link segment costs file");
        if (linkSegmentExternalIdPresent) {
            return OutputProperty.LINK_SEGMENT_EXTERNAL_ID;
        }
        if (linkSegmentIdPresent) {
            return OutputProperty.LINK_SEGMENT_ID;
        }
        if (upstreamNodeExternalIdPresent && downstreamNodeExternalIdPresent) {
            return OutputProperty.UPSTREAM_NODE_EXTERNAL_ID;
        }
        throw new PlanItException("Links not correctly identified in initial link segment costs file");
    }

    private void setInitialLinkSegmentCost(InitialLinkSegmentCost initialLinkSegmentCost, CSVRecord record, LinkSegment linkSegment) throws PlanItException {
        long modeExternalId = Long.parseLong(record.get("Mode External Id"));
        Mode mode = this.getModeByExternalId(modeExternalId);
        PlanItException.throwIf(mode == null, "mode external id not available in configuration");
        double cost = Double.parseDouble(record.get("Cost"));
        initialLinkSegmentCost.setSegmentCost(mode, linkSegment, cost);
    }

    private void updateInitialLinkSegmentCost(InitialLinkSegmentCost initialLinkSegmentCost, CSVParser parser, CSVRecord record, OutputProperty outputProperty, String header, LongFunction<LinkSegment> findLinkSegmentFunction) throws PlanItException {
        long id = Long.parseLong(record.get(header));
        LinkSegment linkSegment = findLinkSegmentFunction.apply(id);
        PlanItException.throwIf(linkSegment == null, "Failed to find link segment");
        this.setInitialLinkSegmentCost(initialLinkSegmentCost, record, linkSegment);
    }

    private void updateInitialLinkSegmentCostFromStartAndEndNodeExternalId(PhysicalNetwork network, InitialLinkSegmentCost initialLinkSegmentCost, CSVParser parser, CSVRecord record, OutputProperty startOutputProperty, OutputProperty endOutputProperty, String startHeader, String endHeader) throws PlanItException {
        long endId;
        long upstreamNodeExternalId = Long.parseLong(record.get(startHeader));
        long downstreamNodeExternalId = Long.parseLong(record.get(endHeader));
        long startId = this.getNodeByExternalId(upstreamNodeExternalId).getId();
        LinkSegment linkSegment = network.linkSegments.getLinkSegmentByStartAndEndNodeId(startId, endId = this.getNodeByExternalId(downstreamNodeExternalId).getId());
        PlanItException.throwIf(linkSegment == null, "Failed to find link segment");
        this.setInitialLinkSegmentCost(initialLinkSegmentCost, record, linkSegment);
    }

    private void addDefaultValuesToXmlMacroscopicNetwork() {
        if (this.macroscopicnetwork.getLinkconfiguration() == null) {
            this.macroscopicnetwork.setLinkconfiguration(new XMLElementLinkConfiguration());
        }
        if (this.macroscopicnetwork.getLinkconfiguration().getModes() == null) {
            this.macroscopicnetwork.getLinkconfiguration().setModes(new XMLElementModes());
            XMLElementModes.Mode xmlElementMode = new XMLElementModes.Mode();
            xmlElementMode.setPcu(Float.valueOf(1.0f));
            xmlElementMode.setName("");
            xmlElementMode.setId(BigInteger.valueOf(1L));
            this.macroscopicnetwork.getLinkconfiguration().getModes().getMode().add(xmlElementMode);
        }
        if (this.macroscopicnetwork.getLinkconfiguration().getLinksegmenttypes() == null) {
            this.macroscopicnetwork.getLinkconfiguration().setLinksegmenttypes(new XMLElementLinkSegmentTypes());
            XMLElementLinkSegmentTypes.Linksegmenttype xmlLinkSegmentType = new XMLElementLinkSegmentTypes.Linksegmenttype();
            xmlLinkSegmentType.setName("");
            xmlLinkSegmentType.setId(BigInteger.valueOf(1L));
            xmlLinkSegmentType.setCapacitylane(Float.valueOf(1800.0f));
            xmlLinkSegmentType.setMaxdensitylane(Float.valueOf(180.0f));
            this.macroscopicnetwork.getLinkconfiguration().getLinksegmenttypes().getLinksegmenttype().add(xmlLinkSegmentType);
        }
        for (XMLElementLinkSegmentTypes.Linksegmenttype xmlLinkSegmentType : this.macroscopicnetwork.getLinkconfiguration().getLinksegmenttypes().getLinksegmenttype()) {
            if (xmlLinkSegmentType.getModes() != null) continue;
            XMLElementLinkSegmentTypes.Linksegmenttype.Modes xmlLinkSegmentModes = new XMLElementLinkSegmentTypes.Linksegmenttype.Modes();
            XMLElementLinkSegmentTypes.Linksegmenttype.Modes.Mode xmlLinkSegmentMode = new XMLElementLinkSegmentTypes.Linksegmenttype.Modes.Mode();
            xmlLinkSegmentMode.setRef(BigInteger.valueOf(0L));
            xmlLinkSegmentModes.getMode().add(xmlLinkSegmentMode);
            xmlLinkSegmentType.setModes(xmlLinkSegmentModes);
        }
    }

    protected void populatePhysicalNetwork(PhysicalNetwork physicalNetwork) throws PlanItException {
        LOGGER.fine(LoggingUtils.getClassNameWithBrackets(this) + "populating Network");
        MacroscopicNetwork network = (MacroscopicNetwork)physicalNetwork;
        try {
            this.addDefaultValuesToXmlMacroscopicNetwork();
            XMLElementLinkConfiguration linkconfiguration = this.macroscopicnetwork.getLinkconfiguration();
            ProcessLinkConfiguration.createAndRegisterModes(physicalNetwork, linkconfiguration, this);
            Map<Long, MacroscopicLinkSegmentTypeXmlHelper> linkSegmentTypeHelperMap = ProcessLinkConfiguration.createLinkSegmentTypeHelperMap(linkconfiguration, this);
            XMLElementInfrastructure infrastructure = this.macroscopicnetwork.getInfrastructure();
            ProcessInfrastructure.createAndRegisterNodes(infrastructure, network, this);
            ProcessInfrastructure.createAndRegisterLinkSegments(infrastructure, network, linkSegmentTypeHelperMap, this);
        }
        catch (PlanItException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.severe(e.getMessage());
            throw new PlanItException("Error while populating physical network in PLANitIO", e);
        }
    }

    protected void populateZoning(Zoning zoning, Object parameter1) throws PlanItException {
        LOGGER.fine(LoggingUtils.getClassNameWithBrackets(this) + "populating Zoning");
        PlanItException.throwIf(!(parameter1 instanceof PhysicalNetwork), "Parameter of call to populateZoning() is not of class PhysicalNetwork");
        PhysicalNetwork physicalNetwork = (PhysicalNetwork)parameter1;
        PhysicalNetwork.Nodes nodes = physicalNetwork.nodes;
        try {
            for (XMLElementZones.Zone xmlZone : this.macroscopiczoning.getZones().getZone()) {
                long zoneExternalId = xmlZone.getId().longValue();
                Zone zone = zoning.zones.createAndRegisterNewZone(zoneExternalId);
                this.addZoneToExternalIdMap(zone.getExternalId(), zone);
                Centroid centroid = zone.getCentroid();
                if (xmlZone.getCentroid().getPoint() != null) {
                    DirectPosition centrePointGeometry = UpdateZoning.getCentrePointGeometry(xmlZone);
                    centroid.setCentrePointGeometry(centrePointGeometry);
                }
                UpdateZoning.registerNewConnectoid(zoning, nodes, xmlZone, centroid, this);
            }
        }
        catch (PlanItException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.severe(e.getMessage());
            throw new PlanItException("Error when populating zoning in PLANitIO", e);
        }
    }

    protected void populateDemands(Demands demands, Object parameter1, Object parameter2) throws PlanItException {
        LOGGER.fine(LoggingUtils.getClassNameWithBrackets(this) + "populating Demands");
        PlanItException.throwIf(!(parameter1 instanceof Zoning), "Parameter 1 of call to populateDemands() is not of class Zoning");
        PlanItException.throwIf(!(parameter2 instanceof PhysicalNetwork), "Parameter 2 of call to populateDemands() is not of class PhysicalNetwork");
        Zoning zoning = (Zoning)parameter1;
        PhysicalNetwork physicalNetwork = (PhysicalNetwork)parameter2;
        try {
            XMLElementDemandConfiguration demandconfiguration = this.macroscopicdemand.getDemandconfiguration();
            ProcessConfiguration.generateAndStoreConfigurationData(demands, demandconfiguration, physicalNetwork, this);
            List<XMLElementOdMatrix> oddemands = this.macroscopicdemand.getOddemands().getOdcellbycellmatrixOrOdrowmatrixOrOdrawmatrix();
            DemandsPopulator.createAndRegisterDemandMatrix(demands, oddemands, zoning.zones, this);
        }
        catch (Exception e) {
            LOGGER.severe(e.getMessage());
            throw new PlanItException("Error when populating demands in PLANitIO", e);
        }
    }

    protected void populateInitialLinkSegmentCost(InitialLinkSegmentCost initialLinkSegmentCost, Object parameter1, Object parameter2) throws PlanItException {
        LOGGER.fine(LoggingUtils.getClassNameWithBrackets(this) + "populating Initial Link Segment Costs");
        PlanItException.throwIf(!(parameter1 instanceof PhysicalNetwork), "Parameter 1 of call to populateInitialLinkSegments() is not of class PhysicalNework");
        PlanItException.throwIf(!(parameter2 instanceof String), "Parameter 2 of call to populateInitialLinkSegments() is not a file name");
        PhysicalNetwork network = (PhysicalNetwork)parameter1;
        String fileName = (String)parameter2;
        try {
            FileReader in = new FileReader(fileName);
            CSVParser parser = CSVParser.parse(in, CSVFormat.DEFAULT.withFirstRecordAsHeader());
            Set<String> headers = parser.getHeaderMap().keySet();
            OutputProperty linkIdentificationMethod = this.getLinkIdentificationMethod(headers);
            block7: for (CSVRecord record : parser) {
                switch (linkIdentificationMethod) {
                    case LINK_SEGMENT_ID: {
                        this.updateInitialLinkSegmentCost(initialLinkSegmentCost, parser, record, OutputProperty.LINK_SEGMENT_ID, "Link Segment Id", id -> network.linkSegments.getLinkSegment(id));
                        continue block7;
                    }
                    case LINK_SEGMENT_EXTERNAL_ID: {
                        this.updateInitialLinkSegmentCost(initialLinkSegmentCost, parser, record, OutputProperty.LINK_SEGMENT_EXTERNAL_ID, "Link Segment External Id", externalId -> this.getLinkSegmentByExternalId(externalId));
                        continue block7;
                    }
                    case UPSTREAM_NODE_EXTERNAL_ID: {
                        this.updateInitialLinkSegmentCostFromStartAndEndNodeExternalId(network, initialLinkSegmentCost, parser, record, OutputProperty.UPSTREAM_NODE_EXTERNAL_ID, OutputProperty.DOWNSTREAM_NODE_EXTERNAL_ID, "Upstream Node External Id", "Downstream Node External Id");
                        continue block7;
                    }
                }
                throw new PlanItException("Invalid Output Property " + BaseOutputProperty.convertToBaseOutputProperty(linkIdentificationMethod).getName() + " found in header of Initial Link Segment Cost CSV file");
            }
            ((Reader)in).close();
        }
        catch (Exception e) {
            LOGGER.severe(e.getMessage());
            throw new PlanItException("Error when initialising link segment costs in PLANitIO", e);
        }
    }

    public PlanItInputBuilder(String projectPath) throws PlanItException {
        this(projectPath, DEFAULT_XML_NAME_EXTENSION);
    }

    public PlanItInputBuilder(String projectPath, String xmlNameExtension) throws PlanItException {
        LOGGER.info(LoggingUtils.getClassNameWithBrackets(this) + "project path is set to: " + projectPath);
        this.setInputFiles(projectPath, xmlNameExtension);
    }

    public static boolean validateXmlInputFile(String xmlFileLocation, String schemaFileLocation) {
        try {
            XmlUtils.validateXml(xmlFileLocation, schemaFileLocation);
            return true;
        }
        catch (Exception e) {
            LOGGER.info(e.getMessage());
            return false;
        }
    }

    @Override
    public void notify(EventInterface event) throws RemoteException {
        if (event.getType() == TrafficAssignmentComponentFactory.TRAFFICCOMPONENT_CREATE) {
            Object[] content = (Object[])event.getContent();
            Object projectComponent = content[0];
            Object[] parameters = (Object[])content[1];
            try {
                if (projectComponent instanceof PhysicalNetwork) {
                    this.populatePhysicalNetwork((PhysicalNetwork)projectComponent);
                } else if (projectComponent instanceof Zoning) {
                    this.populateZoning((Zoning)projectComponent, parameters[0]);
                } else if (projectComponent instanceof Demands) {
                    this.populateDemands((Demands)projectComponent, parameters[0], parameters[1]);
                } else if (projectComponent instanceof InitialPhysicalCost) {
                    this.populateInitialLinkSegmentCost((InitialLinkSegmentCost)projectComponent, parameters[0], parameters[1]);
                } else {
                    LOGGER.fine("Event component is " + projectComponent.getClass().getCanonicalName() + " which is not handled by PlanItInputBuilder.");
                }
            }
            catch (PlanItException e) {
                LOGGER.severe(e.getMessage());
                throw new RemoteException("Rethrowing as remote exception in notify", e);
            }
        }
    }
}

