/*
 * Decompiled with CFR 0.152.
 */
package org.planit.input;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.djutils.event.EventListenerInterface;
import org.planit.time.TimePeriod;
import org.planit.userclass.TravelerType;
import org.planit.userclass.UserClass;
import org.planit.utils.network.physical.LinkSegment;
import org.planit.utils.network.physical.Mode;
import org.planit.utils.network.physical.Node;
import org.planit.utils.network.physical.macroscopic.MacroscopicLinkSegmentType;
import org.planit.utils.network.virtual.Zone;

public abstract class InputBuilderListener
implements EventListenerInterface {
    private static final Logger LOGGER = Logger.getLogger(InputBuilderListener.class.getCanonicalName());
    private static final long serialVersionUID = 4223028100274802893L;
    private Map<Object, Node> nodeExternalIdToNodeMap = new HashMap<Object, Node>();
    private Map<Object, MacroscopicLinkSegmentType> linkSegmentTypeExternalIdToLinkSegmentTypeMap = new HashMap<Object, MacroscopicLinkSegmentType>();
    private Map<Object, Mode> modeExternalIdToModeMap = new HashMap<Object, Mode>();
    protected Map<Object, TravelerType> travelerTypeExternalIdToTravelerTypeMap = new HashMap<Object, TravelerType>();
    protected Map<Object, UserClass> userClassExternalIdToUserClassMap = new HashMap<Object, UserClass>();
    private Map<Object, TimePeriod> timePeriodExternalIdToTimePeriodMap = new HashMap<Object, TimePeriod>();
    private Map<Object, Zone> zoneExternalIdToZoneMap = new HashMap<Object, Zone>();
    private Map<Object, LinkSegment> linkSegmentExternalIdToLinkSegmentMap = new HashMap<Object, LinkSegment>();
    private boolean errorIfDuplicateExternalId = true;

    private <T> boolean addObjectToExternalIdMap(Object externalId, T obj, Map<Object, T> map, String objectName) {
        boolean containsDuplicates = map.containsKey(externalId);
        map.put(externalId, obj);
        return containsDuplicates;
    }

    public Node getNodeByExternalId(Object externalId) {
        return this.nodeExternalIdToNodeMap.get(externalId);
    }

    public boolean addNodeToExternalIdMap(Object externalId, Node node) {
        return this.addObjectToExternalIdMap(externalId, node, this.nodeExternalIdToNodeMap, "node");
    }

    public MacroscopicLinkSegmentType getLinkSegmentTypeByExternalId(Object externalId) {
        return this.linkSegmentTypeExternalIdToLinkSegmentTypeMap.get(externalId);
    }

    public boolean addLinkSegmentTypeToExternalIdMap(Object externalId, MacroscopicLinkSegmentType macroscopicLinkSegmentType) {
        return this.addObjectToExternalIdMap(externalId, macroscopicLinkSegmentType, this.linkSegmentTypeExternalIdToLinkSegmentTypeMap, "link segment type");
    }

    public Mode getModeByExternalId(Object externalId) {
        return this.modeExternalIdToModeMap.get(externalId);
    }

    public Collection<Mode> getAllModes() {
        return this.modeExternalIdToModeMap.values();
    }

    public boolean addModeToExternalIdMap(Object externalId, Mode mode) {
        return this.addObjectToExternalIdMap(externalId, mode, this.modeExternalIdToModeMap, "mode");
    }

    public TravelerType getTravelerTypeByExternalId(Object externalId) {
        return this.travelerTypeExternalIdToTravelerTypeMap.get(externalId);
    }

    public boolean addTravelerTypeToExternalIdMap(Object externalId, TravelerType travelerType) {
        return this.addObjectToExternalIdMap(externalId, travelerType, this.travelerTypeExternalIdToTravelerTypeMap, "traveller type");
    }

    public UserClass getUserClassByExternalId(Object externalId) {
        return this.userClassExternalIdToUserClassMap.get(externalId);
    }

    public boolean addUserClassToExternalIdMap(Object externalId, UserClass userClass) {
        return this.addObjectToExternalIdMap(externalId, userClass, this.userClassExternalIdToUserClassMap, "user class");
    }

    public TimePeriod getTimePeriodByExternalId(Object externalId) {
        return this.timePeriodExternalIdToTimePeriodMap.get(externalId);
    }

    public boolean isTimePeriodExternalIdRegistered(Object externalId) {
        return this.timePeriodExternalIdToTimePeriodMap.keySet().contains(externalId);
    }

    public int getNumberOfRegisteredTimePeriods() {
        return this.timePeriodExternalIdToTimePeriodMap.keySet().size();
    }

    public List<Object> getTimePeriodExternalIds() {
        return new ArrayList<Object>(this.timePeriodExternalIdToTimePeriodMap.keySet());
    }

    public boolean addTimePeriodToExternalIdMap(Object externalId, TimePeriod timePeriod) {
        return this.addObjectToExternalIdMap(externalId, timePeriod, this.timePeriodExternalIdToTimePeriodMap, "time period");
    }

    public Zone getZoneByExternalId(Object externalId) {
        return this.zoneExternalIdToZoneMap.get(externalId);
    }

    public boolean addZoneToExternalIdMap(Object externalId, Zone zone) {
        return this.addObjectToExternalIdMap(externalId, zone, this.zoneExternalIdToZoneMap, "zone");
    }

    public LinkSegment getLinkSegmentByExternalId(Object externalId) {
        return this.linkSegmentExternalIdToLinkSegmentMap.get(externalId);
    }

    public boolean addLinkSegmentToExternalIdMap(Object externalId, LinkSegment linkSegment) {
        return this.addObjectToExternalIdMap(externalId, linkSegment, this.linkSegmentExternalIdToLinkSegmentMap, "link segment");
    }

    public boolean isErrorIfDuplicateExternalId() {
        return this.errorIfDuplicateExternalId;
    }

    public void setErrorIfDuplicateExternalId(boolean errorIfDuplicateExternalId) {
        this.errorIfDuplicateExternalId = errorIfDuplicateExternalId;
    }
}

