/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.structure;

import org.ojalgo.function.aggregator.Aggregator;
import org.ojalgo.structure.Structure1D;

public interface Structure2D
extends Structure1D {
    public static <R, C> RowColumnMapper<R, C> mapperOf(Structure2D structure, Structure1D.IndexMapper<R> rowMappwer, Structure1D.IndexMapper<C> columnMappwer) {
        return new RowColumnMapper<R, C>(structure, rowMappwer, columnMappwer);
    }

    public static int column(int index, int structure) {
        return index / structure;
    }

    public static int column(int index, int[] structure) {
        return Structure2D.column(index, structure[0]);
    }

    public static int column(long index, int structure) {
        return (int)(index / (long)structure);
    }

    public static long column(long index, long structure) {
        return index / structure;
    }

    public static long column(long index, long[] structure) {
        return Structure2D.column(index, structure[0]);
    }

    public static long count(long numberOfRows, long numberOfColumnns) {
        return numberOfRows * numberOfColumnns;
    }

    public static int index(int structure, int row, int column) {
        return row + column * structure;
    }

    public static long index(long structure, long row, long column) {
        return row + column * structure;
    }

    public static void loopMatching(Structure2D structureA, Structure2D structureB, RowColumnCallback callback) {
        long tmpCountRows = Math.min(structureA.countRows(), structureB.countRows());
        long tmpCountColumns = Math.min(structureA.countColumns(), structureB.countColumns());
        for (long j = 0L; j < tmpCountColumns; ++j) {
            for (long i = 0L; i < tmpCountRows; ++i) {
                callback.call(i, j);
            }
        }
    }

    public static int row(int index, int structure) {
        return index % structure;
    }

    public static int row(int index, int[] structure) {
        return Structure2D.row(index, structure[0]);
    }

    public static int row(long index, int structure) {
        return (int)(index % (long)structure);
    }

    public static long row(long index, long structure) {
        return index % structure;
    }

    public static long row(long index, long[] structure) {
        return Structure2D.row(index, structure[0]);
    }

    @Override
    default public long count() {
        return this.countRows() * this.countColumns();
    }

    public long countColumns();

    public long countRows();

    default public boolean isEmpty() {
        return this.countRows() <= 0L || this.countColumns() <= 0L;
    }

    default public boolean isFat() {
        long tmpCountRows = this.countRows();
        return tmpCountRows > 0L && tmpCountRows < this.countColumns();
    }

    default public boolean isScalar() {
        return this.countRows() == 1L && this.countColumns() == 1L;
    }

    default public boolean isSquare() {
        long tmpCountRows = this.countRows();
        return tmpCountRows > 0L && tmpCountRows == this.countColumns();
    }

    default public boolean isTall() {
        long tmpCountColumns = this.countColumns();
        return tmpCountColumns > 0L && this.countRows() > tmpCountColumns;
    }

    default public boolean isVector() {
        return this.countColumns() == 1L || this.countRows() == 1L;
    }

    default public void loopAll(RowColumnCallback callback) {
        long tmpCountRows = this.countRows();
        long tmpCountColumns = this.countColumns();
        for (long j = 0L; j < tmpCountColumns; ++j) {
            for (long i = 0L; i < tmpCountRows; ++i) {
                callback.call(i, j);
            }
        }
    }

    default public void loopColumn(long row, long col, RowColumnCallback callback) {
        long tmpCountRows = this.countRows();
        for (long i = row; i < tmpCountRows; ++i) {
            callback.call(i, col);
        }
    }

    default public void loopColumn(long col, RowColumnCallback callback) {
        this.loopColumn(0L, col, callback);
    }

    default public void loopDiagonal(long row, long col, RowColumnCallback callback) {
        long tmpLimit = Math.min(this.countRows() - row, this.countColumns() - col);
        for (long ij = 0L; ij < tmpLimit; ++ij) {
            callback.call(row + ij, col + ij);
        }
    }

    default public void loopRow(long row, long col, RowColumnCallback callback) {
        long tmpCountColumns = this.countColumns();
        for (long j = col; j < tmpCountColumns; ++j) {
            callback.call(row, j);
        }
    }

    default public void loopRow(long row, RowColumnCallback callback) {
        this.loopRow(row, 0L, callback);
    }

    public static class RowColumnMapper<R, C>
    implements Structure1D.IndexMapper<RowColumnKey<R, C>> {
        private final Structure1D.IndexMapper<C> myColumnMapper;
        private final Structure1D.IndexMapper<R> myRowMapper;
        private final long myStructure;

        protected RowColumnMapper(Structure2D structure, Structure1D.IndexMapper<R> rowMapper, Structure1D.IndexMapper<C> columnMapper) {
            this.myStructure = structure.countRows();
            this.myRowMapper = rowMapper;
            this.myColumnMapper = columnMapper;
        }

        public C toColumnKey(long index) {
            long col = Structure2D.column(index, this.myStructure);
            return this.myColumnMapper.toKey(col);
        }

        public long toIndex(R rowKey, C colKey) {
            long row = this.myRowMapper.toIndex(rowKey);
            long col = this.myColumnMapper.toIndex(colKey);
            return Structure2D.index(this.myStructure, row, col);
        }

        @Override
        public long toIndex(RowColumnKey<R, C> key) {
            return this.toIndex(key.row, key.column);
        }

        @Override
        public RowColumnKey<R, C> toKey(long index) {
            return RowColumnKey.of(this.toRowKey(index), this.toColumnKey(index));
        }

        public R toRowKey(long index) {
            long row = Structure2D.row(index, this.myStructure);
            return this.myRowMapper.toKey(row);
        }
    }

    public static class RowColumnKey<R, C> {
        public final C column;
        public final R row;

        public static <R, C> RowColumnKey<R, C> of(R row, C col) {
            return new RowColumnKey<R, C>(row, col);
        }

        public RowColumnKey(R row, C col) {
            this.row = row;
            this.column = col;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof RowColumnKey)) {
                return false;
            }
            RowColumnKey other = (RowColumnKey)obj;
            if (this.column == null ? other.column != null : !this.column.equals(other.column)) {
                return false;
            }
            return !(this.row == null ? other.row != null : !this.row.equals(other.row));
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.column == null ? 0 : this.column.hashCode());
            result = 31 * result + (this.row == null ? 0 : this.row.hashCode());
            return result;
        }
    }

    @FunctionalInterface
    public static interface RowColumnCallback {
        public void call(long var1, long var3);
    }

    public static interface ReducibleTo1D<R extends Structure1D>
    extends Structure2D {
        public R reduceColumns(Aggregator var1);

        public R reduceRows(Aggregator var1);
    }

    public static final class LongRowColumn
    implements Comparable<LongRowColumn> {
        public final long column;
        public final long row;

        public LongRowColumn(long aRow, long aCol) {
            this.row = aRow;
            this.column = aCol;
        }

        private LongRowColumn() {
            this(-1L, -1L);
        }

        @Override
        public int compareTo(LongRowColumn ref) {
            if (this.column == ref.column) {
                return Long.compare(this.row, ref.row);
            }
            return Long.compare(this.column, ref.column);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof LongRowColumn)) {
                return false;
            }
            LongRowColumn other = (LongRowColumn)obj;
            if (this.column != other.column) {
                return false;
            }
            return this.row == other.row;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (int)(this.column ^ this.column >>> 32);
            result = 31 * result + (int)(this.row ^ this.row >>> 32);
            return result;
        }

        public String toString() {
            return "<" + Long.toString(this.row) + "," + Long.toString(this.column) + ">";
        }
    }

    public static interface Logical<S extends Structure2D, B extends Logical<S, ?>>
    extends Structure2D {
        public B above(S ... var1);

        public B below(S ... var1);

        public B diagonally(S ... var1);

        public S get();

        public B left(S ... var1);

        public B right(S ... var1);
    }

    public static final class IntRowColumn
    implements Comparable<IntRowColumn> {
        public final int column;
        public final int row;

        public IntRowColumn(int aRow, int aCol) {
            this.row = aRow;
            this.column = aCol;
        }

        private IntRowColumn() {
            this(-1, -1);
        }

        @Override
        public int compareTo(IntRowColumn ref) {
            if (this.column == ref.column) {
                return Integer.compare(this.row, ref.row);
            }
            return Integer.compare(this.column, ref.column);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            IntRowColumn other = (IntRowColumn)obj;
            if (this.column != other.column) {
                return false;
            }
            return this.row == other.row;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.column;
            result = 31 * result + this.row;
            return result;
        }

        public String toString() {
            return "<" + Integer.toString(this.row) + "," + Integer.toString(this.column) + ">";
        }
    }
}

