/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import org.ojalgo.RecoverableCondition;
import org.ojalgo.array.Array1D;
import org.ojalgo.array.Primitive64Array;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.matrix.decomposition.BidiagonalDecomposition;
import org.ojalgo.matrix.decomposition.DecompositionStore;
import org.ojalgo.matrix.decomposition.DiagonalArray1D;
import org.ojalgo.matrix.decomposition.GenericDecomposition;
import org.ojalgo.matrix.decomposition.SingularValue;
import org.ojalgo.matrix.decomposition.function.ExchangeColumns;
import org.ojalgo.matrix.decomposition.function.NegateColumn;
import org.ojalgo.matrix.decomposition.function.RotateRight;
import org.ojalgo.matrix.store.GenericDenseStore;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.PrimitiveDenseStore;
import org.ojalgo.netio.BasicLogger;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.scalar.Quaternion;
import org.ojalgo.scalar.RationalNumber;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.structure.Access2D;
import org.ojalgo.structure.Structure2D;
import org.ojalgo.type.context.NumberContext;

abstract class SingularValueDecomposition<N extends Number>
extends GenericDecomposition<N>
implements SingularValue<N> {
    private double[] e = null;
    private final BidiagonalDecomposition<N> myBidiagonal;
    private transient MatrixStore<N> myD = null;
    private final boolean myFullSize;
    private final Structure2D myInputStructure = new Structure2D(){

        @Override
        public long countColumns() {
            return SingularValueDecomposition.this.myTransposed ? (long)SingularValueDecomposition.this.myBidiagonal.getRowDim() : (long)SingularValueDecomposition.this.myBidiagonal.getColDim();
        }

        @Override
        public long countRows() {
            return SingularValueDecomposition.this.myTransposed ? (long)SingularValueDecomposition.this.myBidiagonal.getColDim() : (long)SingularValueDecomposition.this.myBidiagonal.getRowDim();
        }
    };
    private transient MatrixStore<N> myInverse = null;
    private transient MatrixStore<N> myQ1 = null;
    private transient MatrixStore<N> myQ2 = null;
    private transient Array1D<Double> mySingularValues = null;
    private boolean myTransposed = false;
    private boolean myValuesOnly = false;
    private double[] s = null;

    private static void doCase1(double[] s, double[] e, int p, int k, RotateRight q2RotR) {
        double sin;
        double cos;
        double tmp;
        double f = e[p - 2];
        e[p - 2] = PrimitiveMath.ZERO;
        for (int j = p - 2; j > k; --j) {
            tmp = PrimitiveFunction.HYPOT.invoke(s[j], f);
            cos = s[j] / tmp;
            sin = f / tmp;
            s[j] = tmp;
            q2RotR.rotateRight(p - 1, j, cos, sin);
            tmp = e[j - 1];
            f = -sin * tmp;
            e[j - 1] = cos * tmp;
        }
        tmp = PrimitiveFunction.HYPOT.invoke(s[k], f);
        cos = s[k] / tmp;
        sin = f / tmp;
        s[k] = tmp;
        q2RotR.rotateRight(p - 1, k, cos, sin);
    }

    private static void doCase2(double[] s, double[] e, int p, int k, RotateRight mtrxQ1) {
        double f = e[k - 1];
        e[k - 1] = PrimitiveMath.ZERO;
        for (int j = k; j < p; ++j) {
            double tmp = PrimitiveFunction.HYPOT.invoke(s[j], f);
            double cos = s[j] / tmp;
            double sin = f / tmp;
            s[j] = tmp;
            mtrxQ1.rotateRight(k - 1, j, cos, sin);
            tmp = e[j];
            f = -sin * tmp;
            e[j] = cos * tmp;
        }
    }

    private static void doCase3(double[] s, double[] e, int p, int k, RotateRight q1RotR, RotateRight q2RotR) {
        double scale = PrimitiveFunction.MAX.invoke(PrimitiveFunction.MAX.invoke(PrimitiveFunction.MAX.invoke(PrimitiveFunction.MAX.invoke(PrimitiveFunction.ABS.invoke(s[p - 1]), PrimitiveFunction.ABS.invoke(s[p - 2])), PrimitiveFunction.ABS.invoke(e[p - 2])), PrimitiveFunction.ABS.invoke(s[k])), PrimitiveFunction.ABS.invoke(e[k]));
        double s_p1 = s[p - 1] / scale;
        double s_p2 = s[p - 2] / scale;
        double e_p2 = e[p - 2] / scale;
        double s_k = s[k] / scale;
        double e_k = e[k] / scale;
        double b = ((s_p2 + s_p1) * (s_p2 - s_p1) + e_p2 * e_p2) / PrimitiveMath.TWO;
        double c = s_p1 * e_p2 * (s_p1 * e_p2);
        double shift = PrimitiveMath.ZERO;
        if (NumberContext.compare(b, PrimitiveMath.ZERO) != 0 || NumberContext.compare(c, PrimitiveMath.ZERO) != 0) {
            shift = PrimitiveFunction.SQRT.invoke(b * b + c);
            if (b < PrimitiveMath.ZERO) {
                shift = -shift;
            }
            shift = c / (b + shift);
        }
        double f = (s_k + s_p1) * (s_k - s_p1) + shift;
        double g = s_k * e_k;
        for (int j = k; j < p - 1; ++j) {
            double tmp = PrimitiveFunction.HYPOT.invoke(f, g);
            double cos = f / tmp;
            double sin = g / tmp;
            if (j != k) {
                e[j - 1] = tmp;
            }
            f = cos * s[j] + sin * e[j];
            e[j] = cos * e[j] - sin * s[j];
            g = sin * s[j + 1];
            s[j + 1] = cos * s[j + 1];
            q2RotR.rotateRight(j + 1, j, cos, sin);
            tmp = PrimitiveFunction.HYPOT.invoke(f, g);
            cos = f / tmp;
            sin = g / tmp;
            s[j] = tmp;
            f = cos * e[j] + sin * s[j + 1];
            s[j + 1] = -sin * e[j] + cos * s[j + 1];
            g = sin * e[j + 1];
            e[j + 1] = cos * e[j + 1];
            q1RotR.rotateRight(j + 1, j, cos, sin);
        }
        e[p - 2] = f;
    }

    private static void doCase4(double[] s, int k, NegateColumn q2NegCol, ExchangeColumns q1XchgCols, ExchangeColumns q2XchgCols) {
        if (s[k] <= PrimitiveMath.ZERO) {
            s[k] = s[k] < PrimitiveMath.ZERO ? -s[k] : PrimitiveMath.ZERO;
            q2NegCol.negateColumn(k);
        }
        int size = s.length;
        int iter = k;
        for (int next = iter + 1; next < size && s[iter] < s[next]; ++next) {
            double tmp = s[iter];
            s[iter] = s[next];
            s[next] = tmp;
            q1XchgCols.exchangeColumns(iter, next);
            q2XchgCols.exchangeColumns(iter, next);
            ++iter;
        }
    }

    static void toDiagonal(double[] s, double[] e, RotateRight q1RotR, RotateRight q2RotR, ExchangeColumns q1XchgCols, ExchangeColumns q2XchgCols, NegateColumn q2NegCol) {
        int p = s.length;
        block6: while (p > 0) {
            int kase;
            int k;
            for (k = p - 2; k >= -1 && k != -1; --k) {
                if (!(PrimitiveFunction.ABS.invoke(e[k]) <= PrimitiveMath.TINY + PrimitiveMath.MACHINE_EPSILON * (PrimitiveFunction.ABS.invoke(s[k]) + PrimitiveFunction.ABS.invoke(s[k + 1])))) continue;
                e[k] = PrimitiveMath.ZERO;
                break;
            }
            if (k == p - 2) {
                kase = 4;
            } else {
                int ks;
                for (ks = p - 1; ks >= k && ks != k; --ks) {
                    double t = (ks != p ? PrimitiveFunction.ABS.invoke(e[ks]) : PrimitiveMath.ZERO) + (ks != k + 1 ? PrimitiveFunction.ABS.invoke(e[ks - 1]) : PrimitiveMath.ZERO);
                    if (!(PrimitiveFunction.ABS.invoke(s[ks]) <= PrimitiveMath.TINY + PrimitiveMath.MACHINE_EPSILON * t)) continue;
                    s[ks] = PrimitiveMath.ZERO;
                    break;
                }
                if (ks == k) {
                    kase = 3;
                } else if (ks == p - 1) {
                    kase = 1;
                } else {
                    kase = 2;
                    k = ks;
                }
            }
            ++k;
            switch (kase) {
                case 1: {
                    SingularValueDecomposition.doCase1(s, e, p, k, q2RotR);
                    continue block6;
                }
                case 2: {
                    SingularValueDecomposition.doCase2(s, e, p, k, q1RotR);
                    continue block6;
                }
                case 3: {
                    SingularValueDecomposition.doCase3(s, e, p, k, q1RotR, q2RotR);
                    continue block6;
                }
                case 4: {
                    SingularValueDecomposition.doCase4(s, k, q2NegCol, q1XchgCols, q2XchgCols);
                    --p;
                    continue block6;
                }
            }
            throw new IllegalStateException();
        }
    }

    private SingularValueDecomposition(PhysicalStore.Factory<N, ? extends DecompositionStore<N>> factory) {
        this(factory, null, false);
    }

    protected SingularValueDecomposition(PhysicalStore.Factory<N, ? extends DecompositionStore<N>> factory, BidiagonalDecomposition<N> bidiagonal, boolean fullSize) {
        super(factory);
        this.myBidiagonal = bidiagonal;
        this.myFullSize = fullSize;
    }

    @Override
    public boolean computeValuesOnly(Access2D.Collectable<N, ? super PhysicalStore<N>> matrix) {
        return this.compute(matrix, true, false);
    }

    @Override
    public boolean decompose(Access2D.Collectable<N, ? super PhysicalStore<N>> matrix) {
        return this.compute(matrix, false, this.isFullSize());
    }

    @Override
    public double getCondition() {
        Array1D<Double> tmpSingularValues = this.getSingularValues();
        return tmpSingularValues.doubleValue(0L) / tmpSingularValues.doubleValue(tmpSingularValues.length - 1L);
    }

    @Override
    public MatrixStore<N> getD() {
        if (this.isComputed() && this.myD == null) {
            this.myD = this.makeD();
        }
        return this.myD;
    }

    @Override
    public double getFrobeniusNorm() {
        double retVal = PrimitiveMath.ZERO;
        Array1D<Double> tmpSingularValues = this.getSingularValues();
        for (int i = tmpSingularValues.size() - 1; i >= 0; --i) {
            double tmpVal = tmpSingularValues.doubleValue(i);
            retVal += tmpVal * tmpVal;
        }
        return PrimitiveFunction.SQRT.invoke(retVal);
    }

    @Override
    public MatrixStore<N> getInverse() {
        return this.getInverse(this.preallocate(this.myInputStructure));
    }

    @Override
    public MatrixStore<N> getInverse(PhysicalStore<N> preallocated) {
        if (this.myInverse == null) {
            MatrixStore<N> tmpQ1 = this.getQ1();
            Array1D<Double> tmpSingulars = this.getSingularValues();
            MatrixStore<N> tmpQ2 = this.getQ2();
            int rank = this.getRank();
            PhysicalStore tmpMtrx = tmpQ2.logical().limits(-1, rank).copy();
            Scalar.Factory tmpScalar = this.scalar();
            BinaryFunction tmpDivide = this.function().divide();
            for (int j = 0; j < rank; ++j) {
                tmpMtrx.modifyColumn(0L, j, tmpDivide.second(tmpScalar.cast(tmpSingulars.doubleValue(j))));
            }
            preallocated.fillByMultiplying(tmpMtrx, tmpQ1.logical().limits(-1, rank).conjugate().get());
            this.myInverse = preallocated;
        }
        return this.myInverse;
    }

    @Override
    public double getKyFanNorm(int k) {
        Array1D<Double> tmpSingularValues = this.getSingularValues();
        double retVal = PrimitiveMath.ZERO;
        for (int i = Math.min(tmpSingularValues.size(), k) - 1; i >= 0; --i) {
            retVal += tmpSingularValues.doubleValue(i);
        }
        return retVal;
    }

    @Override
    public double getOperatorNorm() {
        return this.getSingularValues().doubleValue(0L);
    }

    @Override
    public MatrixStore<N> getQ1() {
        if (!this.myValuesOnly && this.isComputed() && this.myQ1 == null) {
            this.myQ1 = this.myTransposed ? this.makeQ2() : this.makeQ1();
        }
        return this.myQ1;
    }

    @Override
    public MatrixStore<N> getQ2() {
        if (!this.myValuesOnly && this.isComputed() && this.myQ2 == null) {
            this.myQ2 = this.myTransposed ? this.makeQ1() : this.makeQ2();
        }
        return this.myQ2;
    }

    @Override
    public int getRank() {
        double tolerance = this.s[0] * this.getDimensionalEpsilon();
        int rank = 0;
        for (int i = 0; i < this.s.length; ++i) {
            if (!(this.s[i] > tolerance)) continue;
            ++rank;
        }
        return rank;
    }

    @Override
    public Array1D<Double> getSingularValues() {
        if (this.mySingularValues == null && this.isComputed()) {
            this.mySingularValues = this.makeSingularValues();
        }
        return this.mySingularValues;
    }

    @Override
    public MatrixStore<N> getSolution(Access2D.Collectable<N, ? super PhysicalStore<N>> rhs) {
        return this.getInverse().multiply(this.collect(rhs));
    }

    @Override
    public MatrixStore<N> getSolution(Access2D.Collectable<N, ? super PhysicalStore<N>> rhs, PhysicalStore<N> preallocated) {
        preallocated.fillByMultiplying(this.getInverse(), this.collect(rhs));
        return preallocated;
    }

    @Override
    public double getTraceNorm() {
        return this.getKyFanNorm(this.getSingularValues().size());
    }

    @Override
    public MatrixStore<N> invert(Access2D<?> original) throws RecoverableCondition {
        this.decompose(this.wrap(original));
        if (this.isSolvable()) {
            return this.getInverse();
        }
        throw RecoverableCondition.newMatrixNotInvertible();
    }

    @Override
    public MatrixStore<N> invert(Access2D<?> original, PhysicalStore<N> preallocated) throws RecoverableCondition {
        this.decompose(this.wrap(original));
        if (this.isSolvable()) {
            return this.getInverse(preallocated);
        }
        throw RecoverableCondition.newMatrixNotInvertible();
    }

    @Override
    public boolean isFullRank() {
        return this.getRank() == this.myBidiagonal.getMinDim();
    }

    @Override
    public boolean isFullSize() {
        return this.myFullSize;
    }

    @Override
    public boolean isOrdered() {
        return true;
    }

    @Override
    public PhysicalStore<N> preallocate(Structure2D template) {
        return this.allocate(template.countColumns(), template.countRows());
    }

    @Override
    public PhysicalStore<N> preallocate(Structure2D templateBody, Structure2D templateRHS) {
        return this.allocate(templateRHS.countRows(), templateRHS.countColumns());
    }

    @Override
    public void reset() {
        super.reset();
        this.myBidiagonal.reset();
        this.myD = null;
        this.myQ1 = null;
        this.myQ2 = null;
        this.mySingularValues = null;
        this.myInverse = null;
        this.myValuesOnly = false;
        this.myTransposed = false;
    }

    @Override
    public MatrixStore<N> solve(Access2D<?> body, Access2D<?> rhs) throws RecoverableCondition {
        this.decompose(this.wrap(body));
        if (this.isSolvable()) {
            return this.getSolution(this.wrap(rhs));
        }
        throw RecoverableCondition.newEquationSystemNotSolvable();
    }

    @Override
    public MatrixStore<N> solve(Access2D<?> body, Access2D<?> rhs, PhysicalStore<N> preallocated) throws RecoverableCondition {
        this.decompose(this.wrap(body));
        if (this.isSolvable()) {
            return this.getSolution(this.wrap(rhs), preallocated);
        }
        throw RecoverableCondition.newEquationSystemNotSolvable();
    }

    private MatrixStore<N> getInverseOldVersion(DecompositionStore<N> preallocated) {
        if (this.myInverse == null) {
            MatrixStore<N> tmpQ1 = this.getQ1();
            Array1D<Double> tmpSingulars = this.getSingularValues();
            MatrixStore<N> tmpQ2 = this.getQ2();
            int tmpRowDim = (int)tmpSingulars.count();
            int tmpColDim = (int)tmpQ1.countRows();
            DecompositionStore tmpMtrx = this.makeZero(tmpRowDim, tmpColDim);
            int rank = this.getRank();
            for (int i = 0; i < rank; ++i) {
                double tmpValue = tmpSingulars.doubleValue(i);
                for (int j = 0; j < tmpColDim; ++j) {
                    tmpMtrx.set((long)i, (long)j, (Number)((Scalar)((Scalar)tmpQ1.toScalar(j, i).conjugate()).divide(tmpValue)).get());
                }
            }
            preallocated.fillByMultiplying(tmpQ2, tmpMtrx);
            this.myInverse = preallocated;
        }
        return this.myInverse;
    }

    @Override
    protected boolean checkSolvability() {
        return this.isComputed();
    }

    protected boolean compute(Access2D.Collectable<N, ? super PhysicalStore<N>> matrix, boolean valuesOnly, boolean fullSize) {
        this.reset();
        this.myTransposed = matrix.countRows() < matrix.countColumns();
        this.myValuesOnly = valuesOnly;
        boolean computeOK = false;
        try {
            computeOK = this.doCompute((Access2D.Collectable<N, ? super PhysicalStore<N>>)(this.myTransposed ? this.collect(matrix).conjugate() : matrix), valuesOnly, fullSize);
        }
        catch (Exception xcptn) {
            BasicLogger.error(xcptn.toString());
            this.reset();
            computeOK = false;
        }
        return this.computed(computeOK);
    }

    protected boolean computeBidiagonal(Access2D.Collectable<N, ? super PhysicalStore<N>> matrix, boolean fullSize) {
        return this.myBidiagonal.decompose(matrix);
    }

    protected boolean doCompute(Access2D.Collectable<N, ? super PhysicalStore<N>> matrix, boolean valuesOnly, boolean fullSize) {
        this.computeBidiagonal(matrix, fullSize);
        DiagonalArray1D<N> tmpBidiagonal = this.getBidiagonal();
        DecompositionStore<N> tmpQ1 = valuesOnly ? null : this.getBidiagonalQ1();
        DecompositionStore<N> tmpQ2 = valuesOnly ? null : this.getBidiagonalQ2();
        int size = tmpBidiagonal.getDimension();
        if (this.s == null || this.s.length != size) {
            this.s = new double[size];
            this.e = new double[size];
        }
        ((Array1D)tmpBidiagonal.mainDiagonal).supplyTo(this.s);
        ((Array1D)tmpBidiagonal.superdiagonal).supplyTo(this.e);
        RotateRight q1RotR = tmpQ1 != null ? tmpQ1 : RotateRight.NULL;
        RotateRight q2RotR = tmpQ2 != null ? tmpQ2 : RotateRight.NULL;
        ExchangeColumns q1XchgCols = tmpQ1 != null ? tmpQ1 : ExchangeColumns.NULL;
        ExchangeColumns q2XchgCols = tmpQ2 != null ? tmpQ2 : ExchangeColumns.NULL;
        NegateColumn q2NegCol = tmpQ1 != null ? tmpQ2 : NegateColumn.NULL;
        SingularValueDecomposition.toDiagonal(this.s, this.e, q1RotR, q2RotR, q1XchgCols, q2XchgCols, q2NegCol);
        return this.computed(true);
    }

    protected DiagonalArray1D<N> getBidiagonal() {
        return this.myBidiagonal.getDiagonal();
    }

    protected DecompositionStore<N> getBidiagonalQ1() {
        return (DecompositionStore)this.myBidiagonal.getQ1();
    }

    protected DecompositionStore<N> getBidiagonalQ2() {
        return (DecompositionStore)this.myBidiagonal.getQ2();
    }

    @Override
    protected double getDimensionalEpsilon() {
        return (double)this.myBidiagonal.getMaxDim() * PrimitiveMath.MACHINE_EPSILON;
    }

    protected boolean isTransposed() {
        return this.myTransposed;
    }

    protected MatrixStore<N> makeD() {
        Object retVal = this.wrap(new DiagonalArray1D<Double>(this.getSingularValues(), null, null, Double.valueOf(PrimitiveMath.ZERO))).get();
        if (this.myFullSize) {
            if (this.myInputStructure.countRows() > retVal.countRows()) {
                retVal = retVal.logical().below((int)(this.myInputStructure.countRows() - retVal.countRows())).get();
            } else if (this.myInputStructure.countColumns() > retVal.countColumns()) {
                retVal = retVal.logical().right((int)(this.myInputStructure.countColumns() - retVal.countColumns())).get();
            }
        }
        return retVal;
    }

    protected MatrixStore<N> makeQ1() {
        return this.getBidiagonalQ1();
    }

    protected MatrixStore<N> makeQ2() {
        return this.getBidiagonalQ2();
    }

    protected Array1D<Double> makeSingularValues() {
        return Array1D.PRIMITIVE64.wrap(Primitive64Array.wrap(this.s));
    }

    void setD(MatrixStore<N> someD) {
        this.myD = someD;
    }

    void setSingularValues(Array1D<Double> singularValues) {
        this.mySingularValues = singularValues;
    }

    static final class Rational
    extends SingularValueDecomposition<RationalNumber> {
        Rational() {
            this(false);
        }

        Rational(boolean fullSize) {
            super(GenericDenseStore.RATIONAL, new BidiagonalDecomposition.Rational(fullSize), fullSize);
        }
    }

    static final class Quat
    extends SingularValueDecomposition<Quaternion> {
        Quat() {
            this(false);
        }

        Quat(boolean fullSize) {
            super(GenericDenseStore.QUATERNION, new BidiagonalDecomposition.Quat(fullSize), fullSize);
        }
    }

    static final class Primitive
    extends SingularValueDecomposition<Double> {
        Primitive() {
            this(false);
        }

        Primitive(boolean fullSize) {
            super(PrimitiveDenseStore.FACTORY, new BidiagonalDecomposition.Primitive(fullSize), fullSize);
        }
    }

    static final class Complex
    extends SingularValueDecomposition<ComplexNumber> {
        Complex() {
            this(false);
        }

        Complex(boolean fullSize) {
            super(GenericDenseStore.COMPLEX, new BidiagonalDecomposition.Complex(fullSize), fullSize);
        }
    }
}

