/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix;

import org.ojalgo.matrix.AbstractMatrix;
import org.ojalgo.matrix.MatrixFactory;
import org.ojalgo.matrix.decomposition.Eigenvalue;
import org.ojalgo.matrix.decomposition.LU;
import org.ojalgo.matrix.decomposition.QR;
import org.ojalgo.matrix.decomposition.SingularValue;
import org.ojalgo.matrix.store.ElementsSupplier;
import org.ojalgo.matrix.store.GenericDenseStore;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.task.DeterminantTask;
import org.ojalgo.matrix.task.InverterTask;
import org.ojalgo.matrix.task.SolverTask;
import org.ojalgo.scalar.RationalNumber;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.Access2D;
import org.ojalgo.structure.Structure2D;

public final class RationalMatrix
extends AbstractMatrix<RationalNumber, RationalMatrix> {
    public static final MatrixFactory<RationalNumber, RationalMatrix> FACTORY = new MatrixFactory<RationalNumber, RationalMatrix>(RationalMatrix.class, GenericDenseStore.RATIONAL);

    RationalMatrix(MatrixStore<RationalNumber> aStore) {
        super(aStore);
    }

    @Override
    ElementsSupplier<RationalNumber> cast(Access1D<?> matrix) {
        if (matrix instanceof RationalMatrix) {
            return ((RationalMatrix)matrix).getStore();
        }
        if (matrix instanceof ElementsSupplier && matrix.count() > 0L && matrix.get(0L) instanceof RationalNumber) {
            return (ElementsSupplier)((Object)matrix);
        }
        if (matrix instanceof Access2D) {
            Access2D tmpAccess2D = (Access2D)matrix;
            return this.getStore().physical().builder().makeWrapper(tmpAccess2D);
        }
        return (ElementsSupplier)this.getStore().physical().columns(matrix);
    }

    @Override
    Eigenvalue<RationalNumber> getDecompositionEigenvalue(Structure2D typical) {
        return Eigenvalue.RATIONAL.make(typical, this.isHermitian());
    }

    @Override
    LU<RationalNumber> getDecompositionLU(Structure2D typical) {
        return (LU)LU.RATIONAL.make(typical);
    }

    @Override
    QR<RationalNumber> getDecompositionQR(Structure2D typical) {
        return QR.RATIONAL.make(typical);
    }

    @Override
    SingularValue<RationalNumber> getDecompositionSingularValue(Structure2D typical) {
        return SingularValue.RATIONAL.make(typical);
    }

    @Override
    MatrixFactory<RationalNumber, RationalMatrix> getFactory() {
        return FACTORY;
    }

    @Override
    DeterminantTask<RationalNumber> getTaskDeterminant(MatrixStore<RationalNumber> template) {
        return DeterminantTask.RATIONAL.make(template, this.isHermitian(), false);
    }

    @Override
    InverterTask<RationalNumber> getTaskInverter(MatrixStore<RationalNumber> template) {
        return InverterTask.RATIONAL.make(template, this.isHermitian(), false);
    }

    @Override
    SolverTask<RationalNumber> getTaskSolver(MatrixStore<RationalNumber> templateBody, Access2D<?> templateRHS) {
        return SolverTask.RATIONAL.make(templateBody, templateRHS, this.isHermitian(), false);
    }
}

