/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.array;

import java.util.List;
import org.ojalgo.OjAlgoUtils;
import org.ojalgo.array.BasicArray;
import org.ojalgo.array.SegmentedArray;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.FunctionSet;
import org.ojalgo.function.NullaryFunction;
import org.ojalgo.function.aggregator.AggregatorSet;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.Factory1D;
import org.ojalgo.structure.StructureAnyD;

abstract class ArrayFactory<N extends Number, I extends BasicArray<N>>
implements Factory1D<BasicArray<N>> {
    ArrayFactory() {
    }

    public abstract AggregatorSet<N> aggregator();

    @Override
    public final I copy(Access1D<?> source) {
        long count = source.count();
        I retVal = this.makeToBeFilled(count);
        retVal.fillMatching(source);
        return retVal;
    }

    @Override
    public final I copy(double ... source) {
        int length = source.length;
        I retVal = this.makeToBeFilled(length);
        for (int i = 0; i < length; ++i) {
            retVal.set((long)i, source[i]);
        }
        return retVal;
    }

    @Override
    public final I copy(List<? extends Number> source) {
        int size = source.size();
        I retVal = this.makeToBeFilled(size);
        for (int i = 0; i < size; ++i) {
            retVal.set((long)i, source.get(i));
        }
        return retVal;
    }

    @Override
    public final I copy(Number ... source) {
        int length = source.length;
        I retVal = this.makeToBeFilled(length);
        for (int i = 0; i < length; ++i) {
            retVal.set((long)i, source[i]);
        }
        return retVal;
    }

    public abstract FunctionSet<N> function();

    @Override
    public final I makeFilled(long count, NullaryFunction<?> supplier) {
        I retVal = this.makeToBeFilled(count);
        if (((BasicArray)retVal).isPrimitive()) {
            for (long i = 0L; i < count; ++i) {
                retVal.set(i, supplier.doubleValue());
            }
        } else {
            for (long i = 0L; i < count; ++i) {
                retVal.set(i, (Number)supplier.get());
            }
        }
        return retVal;
    }

    @Override
    public final I makeZero(long count) {
        return this.makeStructuredZero(count);
    }

    public abstract Scalar.Factory<N> scalar();

    abstract long getCapacityLimit();

    final SegmentedArray<N> makeSegmented(long ... structure) {
        long totalCount = StructureAnyD.count(structure);
        int max = PrimitiveMath.powerOf2Smaller(Math.min(totalCount, this.getCapacityLimit()));
        int min = PrimitiveMath.powerOf2Larger(totalCount / 0x7FFFFFF7L);
        if (min > max) {
            throw new IllegalArgumentException();
        }
        int indexBits = Math.max(min, max - OjAlgoUtils.ENVIRONMENT.cores);
        return new SegmentedArray(totalCount, indexBits, this);
    }

    abstract I makeStructuredZero(long ... var1);

    abstract I makeToBeFilled(long ... var1);

    @SafeVarargs
    final SegmentedArray<N> wrapAsSegments(BasicArray<N> ... segments) {
        return new SegmentedArray<N>(segments, this);
    }
}

