/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.iso.util.algorithm2D;

import java.util.Iterator;
import java.util.List;
import org.geotools.geometry.iso.aggregate.MultiSurfaceImpl;
import org.geotools.geometry.iso.coordinate.DirectPositionImpl;
import org.geotools.geometry.iso.primitive.CurveImpl;
import org.geotools.geometry.iso.primitive.RingImplUnsafe;
import org.geotools.geometry.iso.primitive.SurfaceBoundaryImpl;
import org.geotools.geometry.iso.primitive.SurfaceImpl;
import org.geotools.geometry.iso.root.GeometryImpl;
import org.geotools.geometry.iso.util.algorithm2D.CGAlgorithms;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.primitive.OrientableSurface;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class CentroidArea2D {
    static final int X = 0;
    static final int Y = 1;
    static final int Z = 2;
    private CoordinateReferenceSystem crs = null;
    private DirectPosition basePt = null;
    private double areasum2 = 0.0;
    double centSumX = 0.0;
    double centSumY = 0.0;
    double centSumZ = 0.0;

    public CentroidArea2D(CoordinateReferenceSystem crs) {
        this.crs = crs;
        this.basePt = null;
    }

    public void add(GeometryImpl geom) {
        if (geom instanceof SurfaceImpl) {
            SurfaceBoundaryImpl sb = ((SurfaceImpl)geom).getBoundary();
            this.setBasePoint(((CurveImpl)sb.getExterior().getGenerators().iterator().next()).getStartPoint());
            this.addSurface(sb);
        } else if (geom instanceof MultiSurfaceImpl) {
            Iterator<OrientableSurface> surfaces = ((MultiSurfaceImpl)geom).getElements().iterator();
            while (surfaces.hasNext()) {
                this.add((GeometryImpl)((Object)surfaces.next()));
            }
        }
    }

    public DirectPositionImpl getCentroid() {
        DirectPositionImpl centroid = new DirectPositionImpl(this.crs);
        centroid.setX(this.centSumX / 3.0 / this.areasum2);
        centroid.setY(this.centSumY / 3.0 / this.areasum2);
        return centroid;
    }

    private void setBasePoint(DirectPosition basePt) {
        if (this.basePt == null) {
            this.basePt = basePt;
        }
    }

    private void addSurface(SurfaceBoundaryImpl sb) {
        this.addShell(((RingImplUnsafe)sb.getExterior()).asDirectPositions());
        for (int i = 0; i < sb.getInteriors().size(); ++i) {
            this.addHole(((RingImplUnsafe)sb.getInteriors().get(i)).asDirectPositions());
        }
    }

    private void addShell(List<DirectPosition> pts) {
        boolean isPositiveArea = !CGAlgorithms.isCCW(pts);
        for (int i = 0; i < pts.size() - 1; ++i) {
            this.addTriangle(this.basePt, pts.get(i), pts.get(i + 1), isPositiveArea);
        }
    }

    private void addHole(List<DirectPosition> pts) {
        boolean isPositiveArea = CGAlgorithms.isCCW(pts);
        for (int i = 0; i < pts.size() - 1; ++i) {
            this.addTriangle(this.basePt, pts.get(i), pts.get(i + 1), isPositiveArea);
        }
    }

    private void addTriangle(DirectPosition p0, DirectPosition p1, DirectPosition p2, boolean isPositiveArea) {
        double sign = isPositiveArea ? 1.0 : -1.0;
        double tempSumX = p0.getOrdinate(0) + p1.getOrdinate(0) + p2.getOrdinate(0);
        double tempSumY = p0.getOrdinate(1) + p1.getOrdinate(1) + p2.getOrdinate(1);
        double area2 = CentroidArea2D.area2(p0, p1, p2);
        this.centSumX += sign * area2 * tempSumX;
        this.centSumY += sign * area2 * tempSumY;
        this.areasum2 += sign * area2;
    }

    private static double area2(DirectPosition p1, DirectPosition p2, DirectPosition p3) {
        return (p2.getOrdinate(0) - p1.getOrdinate(0)) * (p3.getOrdinate(1) - p1.getOrdinate(1)) - (p3.getOrdinate(0) - p1.getOrdinate(0)) * (p2.getOrdinate(1) - p1.getOrdinate(1));
    }
}

