/*
 * Decompiled with CFR 0.152.
 */
package org.djutils.reflection;

import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.djutils.io.URLResource;
import org.djutils.primitives.Primitive;
import org.djutils.reflection.FieldSignature;

public final class ClassUtil {
    private static final Map<String, Object> CACHE = Collections.synchronizedMap(new LinkedHashMap());

    private ClassUtil() {
    }

    public static <T> Constructor<T>[] getAllConstructors(Class<T> clazz) {
        return clazz.getDeclaredConstructors();
    }

    private static <T> Constructor<T> resolveConstructorCache(Class<T> clazz, Class<?>[] parameterTypes) throws NoSuchMethodException {
        String key = "CONSTRUCTOR:" + clazz + "@" + FieldSignature.toDescriptor(parameterTypes);
        if (CACHE.containsKey(key)) {
            return (Constructor)CACHE.get(key);
        }
        Constructor<T> constructor = clazz.getDeclaredConstructor(parameterTypes);
        CACHE.put(key, constructor);
        return constructor;
    }

    public static <T> Constructor<T> resolveConstructor(Class<T> clazz, Class<?> callerClass, Class<?>[] parameterTypes) throws NoSuchMethodException, IllegalAccessException {
        Constructor<T> constructor = ClassUtil.resolveConstructor(clazz, parameterTypes);
        if (ClassUtil.isVisible(constructor, callerClass.getClass())) {
            return constructor;
        }
        throw new IllegalAccessException("constructor resolved but not visible");
    }

    public static <T> Constructor<T> resolveConstructor(Class<T> clazz, Class<?>[] parameterTypes) throws NoSuchMethodException {
        try {
            return ClassUtil.resolveConstructorCache(clazz, (Class[])ClassUtil.checkInput(parameterTypes, Class.class));
        }
        catch (Exception exception) {
            String className = clazz.getName();
            if (className.indexOf("$") >= 0) {
                Class<?> parentClass = null;
                try {
                    parentClass = Class.forName(className.substring(0, className.lastIndexOf("$")));
                }
                catch (Exception e2) {
                    throw new NoSuchMethodException("class " + parentClass + " not found to resolve constructor");
                }
                return ClassUtil.resolveConstructor(parentClass, (Class[])ClassUtil.checkInput(parameterTypes, Class.class));
            }
            throw new NoSuchMethodException("class " + clazz + " does not contain constructor");
        }
    }

    public static <T> Constructor<T> resolveConstructor(Class<T> clazz, Object[] arguments) throws NoSuchMethodException {
        Class<?>[] parameterTypes = ClassUtil.getClass(arguments);
        String key = "CONSTRUCTOR:" + clazz + "@" + FieldSignature.toDescriptor(parameterTypes);
        if (CACHE.containsKey(key)) {
            return (Constructor)CACHE.get(key);
        }
        try {
            return ClassUtil.resolveConstructor(clazz, parameterTypes);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Constructor<T>[] constructors = ClassUtil.getAllConstructors(clazz);
            constructors = ClassUtil.matchSignature(constructors, parameterTypes);
            Constructor<?> result = ClassUtil.getSpecificConstructor(constructors);
            CACHE.put(key, result);
            return result;
        }
    }

    public static boolean matchSignature(Constructor<?> constructor, Class<?>[] argTypes) {
        if (constructor.getParameterTypes().length != argTypes.length) {
            return false;
        }
        Class<?>[] types = constructor.getParameterTypes();
        for (int i = 0; i < constructor.getParameterTypes().length; ++i) {
            if (types[i].isAssignableFrom(argTypes[i]) || types[i].equals(Primitive.getPrimitive(argTypes[i]))) continue;
            return false;
        }
        return true;
    }

    public static <T> Constructor<T>[] matchSignature(Constructor<T>[] constructors, Class<?>[] argTypes) {
        ArrayList<Constructor<T>> results = new ArrayList<Constructor<T>>();
        for (int i = 0; i < constructors.length; ++i) {
            if (!ClassUtil.matchSignature(constructors[i], argTypes)) continue;
            results.add(constructors[i]);
        }
        return results.toArray(new Constructor[results.size()]);
    }

    public static Set<Field> getAllFields(Class<?> clazz, Set<Field> result) {
        Field[] fields = clazz.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            result.add(fields[i]);
        }
        if (clazz.getSuperclass() != null) {
            return ClassUtil.getAllFields(clazz.getSuperclass(), result);
        }
        return result;
    }

    public static Set<Field> getAllFields(Class<?> clazz) {
        LinkedHashSet<Field> fieldSet = new LinkedHashSet<Field>();
        return ClassUtil.getAllFields(clazz, fieldSet);
    }

    public static Field resolveField(Class<?> clazz, String fieldName) throws NoSuchFieldException {
        try {
            return ClassUtil.resolveFieldSuper(clazz, fieldName);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            String className = clazz.getName();
            if (className.indexOf("$") >= 0) {
                Class<?> clazz2 = null;
                try {
                    clazz2 = Class.forName(className.substring(0, className.lastIndexOf("$")));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoSuchFieldException("class " + clazz + " not found to resolve field " + fieldName);
                }
                return ClassUtil.resolveField(clazz2, fieldName);
            }
            throw new NoSuchFieldException("class " + clazz + " does not contain field " + fieldName);
        }
    }

    public static Field resolveField(Class<?> clazz, Class<?> callerClass, String name) throws NoSuchFieldException {
        Field field = ClassUtil.resolveField(clazz, name);
        if (ClassUtil.isVisible(field, callerClass.getClass())) {
            return field;
        }
        throw new NoSuchFieldException("field resolved but not visible");
    }

    public static Field resolveField(Object object, String fieldName) throws NoSuchFieldException {
        if (object == null) {
            throw new NoSuchFieldException("resolveField: object is null for field " + fieldName);
        }
        return ClassUtil.resolveField(object.getClass(), fieldName);
    }

    public static List<Method> getAllMethods(Class<?> clazz, List<Method> result) {
        Method[] methods = clazz.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            result.add(methods[i]);
        }
        if (clazz.getSuperclass() != null) {
            return ClassUtil.getAllMethods(clazz.getSuperclass(), result);
        }
        return result;
    }

    public static List<Method> getAllMethods(Class<?> clazz) {
        ArrayList<Method> methodSet = new ArrayList<Method>();
        return ClassUtil.getAllMethods(clazz, methodSet);
    }

    public static List<Method> getAllMethods(Class<?> clazz, String name, List<Method> result) {
        Method[] methods = clazz.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(name)) continue;
            result.add(methods[i]);
        }
        if (clazz.getSuperclass() != null) {
            return ClassUtil.getAllMethods(clazz.getSuperclass(), name, result);
        }
        return result;
    }

    public static List<Method> getAllMethods(Class<?> clazz, String name) {
        ArrayList<Method> methodSet = new ArrayList<Method>();
        return ClassUtil.getAllMethods(clazz, name, methodSet);
    }

    public static Method resolveMethod(Class<?> clazz, Class<?> callerClass, String name, Class<?>[] parameterTypes) throws NoSuchMethodException {
        Method method = ClassUtil.resolveMethod(clazz, name, parameterTypes);
        if (ClassUtil.isVisible(method, callerClass)) {
            return method;
        }
        throw new NoSuchMethodException("method found but not visible");
    }

    public static Method resolveMethod(Class<?> clazz, String name, Class<?>[] parameterTypes) throws NoSuchMethodException {
        try {
            return ClassUtil.resolveMethodSuper(clazz, name, (Class[])ClassUtil.checkInput(parameterTypes, Class.class));
        }
        catch (Exception exception) {
            String className = clazz.getName();
            if (className.indexOf("$") >= 0) {
                Class<?> parentClass = null;
                try {
                    parentClass = Class.forName(className.substring(0, className.lastIndexOf("$")));
                }
                catch (Exception e2) {
                    throw new NoSuchMethodException("class " + parentClass + " not found to resolve method " + name);
                }
                return ClassUtil.resolveMethod(parentClass, name, (Class[])ClassUtil.checkInput(parameterTypes, Class.class));
            }
            throw new NoSuchMethodException("class " + clazz + " does not contain method " + name);
        }
    }

    public static Method resolveMethod(Object object, String name, Class<?>[] parameterTypes) throws NoSuchMethodException {
        if (object == null) {
            throw new NoSuchMethodException("resolveField: object is null for method " + name);
        }
        return ClassUtil.resolveMethod(object.getClass(), name, parameterTypes);
    }

    public static Method resolveMethod(Object object, String name, Object[] arguments) throws NoSuchMethodException {
        Class<?>[] parameterTypes = ClassUtil.getClass(arguments);
        String key = "METHOD:" + object.getClass() + "@" + name + "@" + FieldSignature.toDescriptor(parameterTypes);
        if (CACHE.containsKey(key)) {
            return (Method)CACHE.get(key);
        }
        try {
            return ClassUtil.resolveMethod(object, name, parameterTypes);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            List<Method> methods = ClassUtil.getAllMethods(object.getClass(), name);
            if (methods.size() == 0) {
                throw new NoSuchMethodException("No such method: " + name + " for object " + object);
            }
            if ((methods = ClassUtil.matchSignature(methods, name, parameterTypes)).size() == 0) {
                throw new NoSuchMethodException("No method with right signature: " + name + " for object " + object);
            }
            Method result = ClassUtil.getSpecificMethod(methods);
            CACHE.put(key, result);
            return result;
        }
    }

    public static Set<Annotation> getAllAnnotations(Class<?> clazz, Set<Annotation> result) {
        Annotation[] annotations = clazz.getDeclaredAnnotations();
        for (int i = 0; i < annotations.length; ++i) {
            result.add(annotations[i]);
        }
        if (clazz.getSuperclass() != null) {
            return ClassUtil.getAllAnnotations(clazz.getSuperclass(), result);
        }
        return result;
    }

    public static Set<Annotation> getAllAnnotations(Class<?> clazz) {
        LinkedHashSet<Annotation> annotationSet = new LinkedHashSet<Annotation>();
        return ClassUtil.getAllAnnotations(clazz, annotationSet);
    }

    public static Annotation resolveAnnotation(Class<?> clazz, Class<? extends Annotation> annotationClass) throws NoSuchElementException {
        try {
            return ClassUtil.resolveAnnotationSuper(clazz, annotationClass);
        }
        catch (NoSuchElementException noSuchAnnotationException) {
            String className = clazz.getName();
            if (className.indexOf("$") >= 0) {
                Class<?> clazz2 = null;
                try {
                    clazz2 = Class.forName(className.substring(0, className.lastIndexOf("$")));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoSuchElementException("class " + clazz + " not found to resolve annotation " + annotationClass);
                }
                return ClassUtil.resolveAnnotation(clazz2, annotationClass);
            }
            throw new NoSuchElementException("class " + clazz + " does not contain annotation " + annotationClass);
        }
    }

    public static boolean isVisible(int modifiers, Class<?> declaringClass, Class<?> caller) {
        if (Modifier.isPublic(modifiers)) {
            return true;
        }
        if (Modifier.isProtected(modifiers)) {
            if (declaringClass.isAssignableFrom(caller)) {
                return true;
            }
            return declaringClass.getPackage().equals(caller.getPackage());
        }
        return declaringClass.equals(caller);
    }

    public static boolean isMoreSpecific(Class<?>[] a, Class<?>[] b) {
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (b[i].isAssignableFrom(a[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isMoreSpecific(Constructor<?> a, Constructor<?> b) {
        if (Arrays.equals(a.getParameterTypes(), b.getParameterTypes()) && b.getDeclaringClass().isAssignableFrom(a.getDeclaringClass())) {
            return true;
        }
        return ClassUtil.isMoreSpecific(a.getParameterTypes(), b.getParameterTypes());
    }

    public static boolean isMoreSpecific(Method a, Method b) {
        if (!a.getName().equals(b.getName())) {
            return false;
        }
        return ClassUtil.isMoreSpecific(a.getParameterTypes(), b.getParameterTypes());
    }

    public static boolean isVisible(Field field, Class<?> caller) {
        return ClassUtil.isVisible(field.getModifiers(), field.getDeclaringClass(), caller);
    }

    public static boolean isVisible(Constructor<?> constructor, Class<?> caller) {
        return ClassUtil.isVisible(constructor.getModifiers(), constructor.getDeclaringClass(), caller);
    }

    public static boolean isVisible(Method method, Class<?> caller) {
        return ClassUtil.isVisible(method.getModifiers(), method.getDeclaringClass(), caller);
    }

    public static List<Method> matchSignature(List<Method> methods, String name, Class<?>[] argTypes) {
        ArrayList<Method> results = new ArrayList<Method>();
        for (int i = 0; i < methods.size(); ++i) {
            if (!ClassUtil.matchSignature(methods.get(i), name, argTypes)) continue;
            results.add(methods.get(i));
        }
        return results;
    }

    public static boolean matchSignature(Method method, String name, Class<?>[] argTypes) {
        if (!method.getName().equals(name)) {
            return false;
        }
        if (method.getParameterTypes().length != argTypes.length) {
            return false;
        }
        Class<?>[] types = method.getParameterTypes();
        for (int i = 0; i < method.getParameterTypes().length; ++i) {
            if (types[i].isAssignableFrom(argTypes[i]) || types[i].equals(Primitive.getPrimitive(argTypes[i]))) continue;
            return false;
        }
        return true;
    }

    public static Class<?>[] getClass(Object[] array) {
        if (array == null) {
            return new Class[0];
        }
        Class[] result = new Class[array.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = array[i] == null ? null : array[i].getClass();
        }
        return result;
    }

    private static Object checkInput(Object[] array, Class<?> myClass) {
        if (array != null) {
            return array;
        }
        return Array.newInstance(myClass, 0);
    }

    private static Constructor<?> getSpecificConstructor(Constructor<?>[] methods) throws NoSuchMethodException {
        if (methods.length == 0) {
            throw new NoSuchMethodException();
        }
        if (methods.length == 1) {
            return methods[0];
        }
        for (int resultID = 0; resultID < methods.length; ++resultID) {
            boolean success = true;
            for (int i = 0; i < methods.length; ++i) {
                if (resultID == i || ClassUtil.isMoreSpecific(methods[resultID], methods[i])) continue;
                success = false;
            }
            if (!success) continue;
            return methods[resultID];
        }
        throw new NoSuchMethodException();
    }

    private static Method getSpecificMethod(List<Method> methods) throws NoSuchMethodException {
        if (methods.size() == 0) {
            throw new NoSuchMethodException();
        }
        if (methods.size() == 1) {
            return methods.get(0);
        }
        for (int resultID = 0; resultID < methods.size(); ++resultID) {
            boolean success = true;
            for (int i = 0; i < methods.size(); ++i) {
                if (resultID == i || ClassUtil.isMoreSpecific(methods.get(resultID), methods.get(i))) continue;
                success = false;
            }
            if (!success) continue;
            return methods.get(resultID);
        }
        throw new NoSuchMethodException();
    }

    private static Method resolveMethodSuper(Class<?> clazz, String name, Class<?>[] parameterTypes) throws NoSuchMethodException {
        String key = "METHOD:" + clazz + "@" + name + "@" + FieldSignature.toDescriptor(parameterTypes);
        try {
            if (CACHE.containsKey(key)) {
                return (Method)CACHE.get(key);
            }
            Method method = clazz.getDeclaredMethod(name, parameterTypes);
            CACHE.put(key, method);
            return method;
        }
        catch (Exception exception) {
            if (clazz.getSuperclass() != null) {
                Method method = ClassUtil.resolveMethodSuper(clazz.getSuperclass(), name, parameterTypes);
                CACHE.put(key, method);
                return method;
            }
            throw new NoSuchMethodException(exception.getMessage());
        }
    }

    private static Field resolveFieldSuper(Class<?> clazz, String fieldName) throws NoSuchFieldException {
        String key = "FIELD:" + clazz + "@" + fieldName;
        try {
            if (CACHE.containsKey(key)) {
                return (Field)CACHE.get(key);
            }
            Field result = clazz.getDeclaredField(fieldName);
            CACHE.put(key, result);
            return result;
        }
        catch (Exception exception) {
            if (clazz.getSuperclass() != null) {
                Field result = ClassUtil.resolveFieldSuper(clazz.getSuperclass(), fieldName);
                CACHE.put(key, result);
                return result;
            }
            throw new NoSuchFieldException(exception.getMessage());
        }
    }

    private static Annotation resolveAnnotationSuper(Class<?> clazz, Class<? extends Annotation> annotationClass) throws NoSuchElementException {
        String key = "ANNOTATION:" + clazz + "@" + annotationClass;
        try {
            if (CACHE.containsKey(key)) {
                return (Annotation)CACHE.get(key);
            }
            Annotation[] annotations = clazz.getDeclaredAnnotations();
            Annotation result = null;
            for (Annotation annotation : annotations) {
                if (!annotation.annotationType().equals(annotationClass)) continue;
                result = annotation;
                break;
            }
            if (result == null) {
                throw new NoSuchElementException("Annotation " + annotationClass + " not found in class " + clazz.getName());
            }
            CACHE.put(key, result);
            return result;
        }
        catch (Exception exception) {
            if (clazz.getSuperclass() != null) {
                Annotation result = ClassUtil.resolveAnnotationSuper(clazz.getSuperclass(), annotationClass);
                CACHE.put(key, result);
                return result;
            }
            throw new NoSuchElementException(exception.getMessage());
        }
    }

    public static ClassFileDescriptor classFileDescriptor(Object object) {
        return ClassUtil.classFileDescriptor(object.getClass());
    }

    public static ClassFileDescriptor classFileDescriptor(Class<?> clazz) {
        URL clazzUrl = URLResource.getResource("/" + clazz.getName().replaceAll("\\.", "/") + ".class");
        return ClassUtil.classFileDescriptor(clazzUrl);
    }

    public static ClassFileDescriptor classFileDescriptor(URL clazzUrl) {
        if (clazzUrl.toString().startsWith("jar:file:") && clazzUrl.toString().contains("!")) {
            ClassFileDescriptor classFileDescriptor;
            String[] parts = clazzUrl.toString().split("\\!");
            String jarFileName = parts[0].replace("jar:file:", "");
            URL jarURL = new URL("file:" + jarFileName);
            File jarUrlFile = new File(jarURL.toURI());
            JarFile jarFile = new JarFile(jarUrlFile);
            try {
                if (parts[1].startsWith("/")) {
                    parts[1] = parts[1].substring(1);
                }
                JarEntry jarEntry = jarFile.getJarEntry(parts[1]);
                classFileDescriptor = new ClassFileDescriptor(jarEntry, jarFileName + "!" + parts[1]);
            }
            catch (Throwable jarEntry) {
                try {
                    try {
                        try {
                            jarFile.close();
                        }
                        catch (Throwable throwable) {
                            jarEntry.addSuppressed(throwable);
                        }
                        throw jarEntry;
                    }
                    catch (Exception exception) {
                        URL jarURL2 = new URL("file:" + jarFileName);
                        return new ClassFileDescriptor(new File(jarURL2.toURI()));
                    }
                }
                catch (MalformedURLException | URISyntaxException exception) {
                    return new ClassFileDescriptor(new File(jarFileName));
                }
            }
            jarFile.close();
            return classFileDescriptor;
        }
        try {
            return new ClassFileDescriptor(new File(clazzUrl.toURI()));
        }
        catch (URISyntaxException exception) {
            return new ClassFileDescriptor(new File(clazzUrl.getPath()));
        }
    }

    public static class ClassFileDescriptor {
        private final String name;
        private final String path;
        private final boolean jar;
        private long lastChangedDate;

        public ClassFileDescriptor(File classFile) {
            this.name = classFile.getName();
            this.path = classFile.getPath();
            this.jar = false;
            long lastModified = classFile.lastModified();
            if (lastModified == 0L) {
                try {
                    BasicFileAttributes attributes = Files.readAttributes(Paths.get(this.path, new String[0]), BasicFileAttributes.class, new LinkOption[0]);
                    lastModified = attributes.lastModifiedTime().toMillis();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.lastChangedDate = lastModified;
        }

        public ClassFileDescriptor(JarEntry jarEntry, String path) {
            this.name = jarEntry.getName();
            this.path = path;
            this.jar = true;
            this.lastChangedDate = jarEntry.getLastModifiedTime().toMillis();
        }

        public ClassFileDescriptor(ZipEntry zipEntry, String path) {
            this.name = zipEntry.getName();
            this.path = path;
            this.jar = true;
            this.lastChangedDate = zipEntry.getLastModifiedTime().toMillis();
        }

        public String getName() {
            return this.name;
        }

        public String getPath() {
            return this.path;
        }

        public boolean isJar() {
            return this.jar;
        }

        public long getLastChangedDate() {
            return this.lastChangedDate;
        }

        public String toString() {
            return "ClassFileDescriptor [name=" + this.name + ", path=" + this.path + ", jar=" + this.jar + ", lastChangedDate=" + this.lastChangedDate + "]";
        }
    }
}

