/*
 * Decompiled with CFR 0.152.
 */
package org.djutils.immutablecollections;

import java.util.Collection;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.djutils.exceptions.Throw;
import org.djutils.immutablecollections.Immutable;
import org.djutils.immutablecollections.ImmutableAbstractCollection;
import org.djutils.immutablecollections.ImmutableCollection;
import org.djutils.immutablecollections.ImmutableIterator;
import org.djutils.immutablecollections.ImmutableSet;

public abstract class ImmutableAbstractSet<E>
extends ImmutableAbstractCollection<E>
implements ImmutableSet<E> {
    private static final long serialVersionUID = 20160507L;
    private final Set<E> set;

    protected ImmutableAbstractSet(Set<E> set, Immutable copyOrWrap) {
        super(copyOrWrap);
        Throw.whenNull(set, "the collection argument cannot be null");
        this.set = set;
    }

    @Override
    public final Collection<E> toCollection() {
        return this.toSet();
    }

    @Override
    protected Set<E> getUnderlyingCollection() {
        return this.set;
    }

    @Override
    public final int size() {
        return this.set.size();
    }

    @Override
    public final boolean isEmpty() {
        return this.set.isEmpty();
    }

    @Override
    public final boolean contains(Object o) {
        return this.set.contains(o);
    }

    @Override
    public final Object[] toArray() {
        return this.set.toArray();
    }

    @Override
    public final <T> T[] toArray(T[] a) {
        return this.set.toArray(a);
    }

    @Override
    public final ImmutableIterator<E> iterator() {
        return new ImmutableIterator<E>(this.set.iterator());
    }

    @Override
    public final void forEach(Consumer<? super E> action) {
        this.set.forEach(action);
    }

    @Override
    public final Spliterator<E> spliterator() {
        return this.set.spliterator();
    }

    @Override
    public final boolean containsAll(Collection<?> c) {
        return this.set.containsAll(c);
    }

    @Override
    public final boolean containsAll(ImmutableCollection<?> c) {
        return this.set.containsAll(c.toCollection());
    }

    @Override
    public final Stream<E> stream() {
        return this.set.stream();
    }

    @Override
    public final Stream<E> parallelStream() {
        return this.set.parallelStream();
    }

    @Override
    public final boolean isWrap() {
        return this.copyOrWrap.isWrap();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.set == null ? 0 : this.set.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImmutableAbstractSet other = (ImmutableAbstractSet)obj;
        return !(this.set == null ? other.set != null : !this.set.equals(other.set));
    }
}

