import unittest
from panoptes_aggregation import extractors
from .base_test_class import ExtractorTest, annotation_by_task

classification = {
    "annotations": [{
        "task": "T0",
        "value": [
            {
                "frame": 0,
                "tool": 0,
                "y": 202.87478637695312,
                "details": [],
                "x": 452.18341064453125
            },
            {
                "frame": 0,
                "tool": 1,
                "y": 583.4398803710938,
                "details": [],
                "x": 404.61279296875
            },
            {
                "frame": 0,
                "tool": 0,
                "y": 306.410888671875,
                "details": [],
                "x": 190.54489135742188
            },
            {
                "frame": 0,
                "tool": 1,
                "y": 568.0493774414062,
                "details": [],
                "x": 422.8015441894531
            },
            {
                "frame": 0,
                "tool": 1,
                "y": 612.82177734375,
                "details": [],
                "x": 435.3937683105469
            },
            {
                "frame": 0,
                "tool": 1,
                "y": 617.0191650390625,
                "details": [],
                "x": 371.03350830078125
            },
            {
                "frame": 0,
                "tool": 0,
                "y": 235.054931640625,
                "details": [],
                "x": 408.8101806640625
            },
            {
                "frame": 0,
                "tool": 0,
                "y": 158.1024169921875,
                "details": [],
                "x": 411.60845947265625
            },
            {
                "frame": 0,
                "tool": 0,
                "y": 180.4886016845703,
                "details": [],
                "x": 482.96441650390625
            }
        ]
    }]
}

expected = {
    'frame0': {
        'T0_tool0_x': [
            452.18341064453125,
            190.54489135742188,
            408.8101806640625,
            411.60845947265625,
            482.96441650390625
        ],
        'T0_tool0_y': [
            202.87478637695312,
            306.410888671875,
            235.054931640625,
            158.1024169921875,
            180.4886016845703
        ],
        'T0_tool1_x': [
            404.61279296875,
            422.8015441894531,
            435.3937683105469,
            371.03350830078125
        ],
        'T0_tool1_y': [
            583.4398803710938,
            568.0493774414062,
            612.82177734375,
            617.0191650390625
        ]
    }
}

TestPointByFrame = ExtractorTest(
    extractors.point_extractor_by_frame,
    classification,
    expected,
    'Test point by frame',
    test_name='TestPointByFrame'
)

TestPointByFrameTask = ExtractorTest(
    extractors.point_extractor_by_frame,
    classification,
    expected,
    'Test point by frame with task specified',
    kwargs={'task': 'T0'},
    test_name='TestPointByFrameTask'
)

TestPointByFrameAllTools = ExtractorTest(
    extractors.point_extractor_by_frame,
    classification,
    expected,
    'Test point by frame with all tools specified',
    kwargs={
        'task': 'T0',
        'tools': [0, 1]
    },
    test_name='TestPointByFrameAllTools'
)

expected_0 = {
    'frame0': {
        'T0_tool0_x': expected['frame0']['T0_tool0_x'],
        'T0_tool0_y': expected['frame0']['T0_tool0_y']
    }
}

TestPointByFrameOneTool = ExtractorTest(
    extractors.point_extractor_by_frame,
    classification,
    expected_0,
    'Test point by frame with one tool specified',
    kwargs={
        'task': 'T0',
        'tools': [0]
    },
    test_name='TestPointByFrameOneTool'
)


classification_v2 = {
    'annotations': [{
        'task': 'T0',
        'taskType': 'drawing',
        'value': [{
            'frame': 0,
            'toolIndex': 0,
            'toolType': 'point',
            'x': 452.18341064453125,
            'y': 202.87478637695312,
            'details': []
        }]
    }]
}


class PointExtractorByFrameDeprecation(unittest.TestCase):
    def test_deprecation(self):
        with self.assertRaises(DeprecationWarning):
            extractors.point_extractor_by_frame(annotation_by_task(classification_v2), task='T0', tools=[0])
