"""
Create a new dashboard with an audit logs query
"""

from datadog_api_client.v1 import ApiClient, Configuration
from datadog_api_client.v1.api.dashboards_api import DashboardsApi
from datadog_api_client.v1.model.dashboard import Dashboard
from datadog_api_client.v1.model.dashboard_layout_type import DashboardLayoutType
from datadog_api_client.v1.model.formula_and_function_event_aggregation import FormulaAndFunctionEventAggregation
from datadog_api_client.v1.model.formula_and_function_event_query_definition import (
    FormulaAndFunctionEventQueryDefinition,
)
from datadog_api_client.v1.model.formula_and_function_event_query_definition_compute import (
    FormulaAndFunctionEventQueryDefinitionCompute,
)
from datadog_api_client.v1.model.formula_and_function_event_query_definition_search import (
    FormulaAndFunctionEventQueryDefinitionSearch,
)
from datadog_api_client.v1.model.formula_and_function_events_data_source import FormulaAndFunctionEventsDataSource
from datadog_api_client.v1.model.formula_and_function_response_format import FormulaAndFunctionResponseFormat
from datadog_api_client.v1.model.timeseries_widget_definition import TimeseriesWidgetDefinition
from datadog_api_client.v1.model.timeseries_widget_definition_type import TimeseriesWidgetDefinitionType
from datadog_api_client.v1.model.timeseries_widget_request import TimeseriesWidgetRequest
from datadog_api_client.v1.model.widget import Widget
from datadog_api_client.v1.model.widget_layout import WidgetLayout

body = Dashboard(
    layout_type=DashboardLayoutType("ordered"),
    title="Example-Create_a_new_dashboard_with_an_audit_logs_query with Audit Logs Query",
    widgets=[
        Widget(
            definition=TimeseriesWidgetDefinition(
                type=TimeseriesWidgetDefinitionType("timeseries"),
                requests=[
                    TimeseriesWidgetRequest(
                        response_format=FormulaAndFunctionResponseFormat("timeseries"),
                        queries=[
                            FormulaAndFunctionEventQueryDefinition(
                                search=FormulaAndFunctionEventQueryDefinitionSearch(
                                    query="",
                                ),
                                data_source=FormulaAndFunctionEventsDataSource("audit"),
                                compute=FormulaAndFunctionEventQueryDefinitionCompute(
                                    aggregation=FormulaAndFunctionEventAggregation("count"),
                                ),
                                name="query1",
                                indexes=[
                                    "*",
                                ],
                                group_by=[],
                            ),
                        ],
                    ),
                ],
            ),
            layout=WidgetLayout(
                x=2,
                y=0,
                width=4,
                height=2,
            ),
        ),
    ],
)

configuration = Configuration()
with ApiClient(configuration) as api_client:
    api_instance = DashboardsApi(api_client)
    response = api_instance.create_dashboard(body=body)

    print(response)
