"""
Create a new dashboard with query_value widget
"""

from datadog_api_client.v1 import ApiClient, Configuration
from datadog_api_client.v1.api.dashboards_api import DashboardsApi
from datadog_api_client.v1.model.dashboard import Dashboard
from datadog_api_client.v1.model.dashboard_layout_type import DashboardLayoutType
from datadog_api_client.v1.model.formula_and_function_metric_aggregation import FormulaAndFunctionMetricAggregation
from datadog_api_client.v1.model.formula_and_function_metric_data_source import FormulaAndFunctionMetricDataSource
from datadog_api_client.v1.model.formula_and_function_metric_query_definition import (
    FormulaAndFunctionMetricQueryDefinition,
)
from datadog_api_client.v1.model.formula_and_function_response_format import FormulaAndFunctionResponseFormat
from datadog_api_client.v1.model.query_value_widget_definition import QueryValueWidgetDefinition
from datadog_api_client.v1.model.query_value_widget_definition_type import QueryValueWidgetDefinitionType
from datadog_api_client.v1.model.query_value_widget_request import QueryValueWidgetRequest
from datadog_api_client.v1.model.widget import Widget
from datadog_api_client.v1.model.widget_layout import WidgetLayout
from datadog_api_client.v1.model.widget_text_align import WidgetTextAlign
from datadog_api_client.v1.model.widget_time import WidgetTime

body = Dashboard(
    title="Example-Create_a_new_dashboard_with_query_value_widget",
    description="",
    widgets=[
        Widget(
            layout=WidgetLayout(
                x=0,
                y=0,
                width=47,
                height=15,
            ),
            definition=QueryValueWidgetDefinition(
                title="",
                title_size="16",
                title_align=WidgetTextAlign("left"),
                time=WidgetTime(),
                type=QueryValueWidgetDefinitionType("query_value"),
                requests=[
                    QueryValueWidgetRequest(
                        response_format=FormulaAndFunctionResponseFormat("scalar"),
                        queries=[
                            FormulaAndFunctionMetricQueryDefinition(
                                name="query1",
                                data_source=FormulaAndFunctionMetricDataSource("metrics"),
                                query="avg:system.cpu.user{*}",
                                aggregator=FormulaAndFunctionMetricAggregation("avg"),
                            ),
                        ],
                    ),
                ],
                autoscale=True,
                precision=2,
            ),
        ),
    ],
    template_variables=[],
    layout_type=DashboardLayoutType("free"),
    is_read_only=False,
    notify_list=[],
)

configuration = Configuration()
with ApiClient(configuration) as api_client:
    api_instance = DashboardsApi(api_client)
    response = api_instance.create_dashboard(body=body)

    print(response)
