from typing import List
from dialog_api import groups_pb2
from dialog_api.groups_pb2 import GROUPADMINPERMISSION_EDITSHORTNAME, GROUPADMINPERMISSION_INVITE, \
    GROUPADMINPERMISSION_KICK, GROUPADMINPERMISSION_UPDATEINFO, GROUPADMINPERMISSION_SETPERMISSIONS, \
    GROUPADMINPERMISSION_EDITMESSAGE, GROUPADMINPERMISSION_DELETEMESSAGE, GROUPADMINPERMISSION_GETINTEGRATIONTOKEN, \
    GROUPADMINPERMISSION_SENDMESSAGE, GROUPADMINPERMISSION_PINMESSAGE, GROUPADMINPERMISSION_VIEWMEMBERS, \
    GROUPADMINPERMISSION_LEAVE, GROUPADMINPERMISSION_TARGETING


PERMISSION_TO_STRING = {
    GROUPADMINPERMISSION_EDITSHORTNAME: "edit short_name",
    GROUPADMINPERMISSION_INVITE: "invite",
    GROUPADMINPERMISSION_KICK: "kick",
    GROUPADMINPERMISSION_UPDATEINFO: "update info",
    GROUPADMINPERMISSION_SETPERMISSIONS: "set permissions",
    GROUPADMINPERMISSION_EDITMESSAGE: "edit message",
    GROUPADMINPERMISSION_DELETEMESSAGE: "delete message",
    GROUPADMINPERMISSION_GETINTEGRATIONTOKEN: "get integration token",
    GROUPADMINPERMISSION_SENDMESSAGE: "send message",
    GROUPADMINPERMISSION_PINMESSAGE: "pen message",
    GROUPADMINPERMISSION_VIEWMEMBERS: "view members",
    GROUPADMINPERMISSION_LEAVE: "leave",
    GROUPADMINPERMISSION_TARGETING: "targeting",
}


class GroupPermission:
    GROUPADMINPERMISSION_EDITSHORTNAME = GROUPADMINPERMISSION_EDITSHORTNAME
    GROUPADMINPERMISSION_INVITE = GROUPADMINPERMISSION_INVITE
    GROUPADMINPERMISSION_KICK = GROUPADMINPERMISSION_KICK
    GROUPADMINPERMISSION_UPDATEINFO = GROUPADMINPERMISSION_UPDATEINFO
    GROUPADMINPERMISSION_SETPERMISSIONS = GROUPADMINPERMISSION_SETPERMISSIONS
    GROUPADMINPERMISSION_EDITMESSAGE = GROUPADMINPERMISSION_EDITMESSAGE
    GROUPADMINPERMISSION_DELETEMESSAGE = GROUPADMINPERMISSION_DELETEMESSAGE
    GROUPADMINPERMISSION_GETINTEGRATIONTOKEN = GROUPADMINPERMISSION_GETINTEGRATIONTOKEN
    GROUPADMINPERMISSION_SENDMESSAGE = GROUPADMINPERMISSION_SENDMESSAGE
    GROUPADMINPERMISSION_PINMESSAGE = GROUPADMINPERMISSION_PINMESSAGE
    GROUPADMINPERMISSION_VIEWMEMBERS = GROUPADMINPERMISSION_VIEWMEMBERS
    GROUPADMINPERMISSION_LEAVE = GROUPADMINPERMISSION_LEAVE
    GROUPADMINPERMISSION_TARGETING = GROUPADMINPERMISSION_TARGETING


class Permissions:
    def __init__(self, user_id: int, permissions: List[GroupPermission]) -> None:
        self.user_id = user_id
        self.permissions = permissions

    @classmethod
    def from_api(cls, permissions: groups_pb2.GroupMemberPermission) -> 'Permissions':
        return cls(permissions.user_id, [x for x in permissions.permissions])

    def __dict__(self):
        return {"user_id": self.user_id, "permissions": [PERMISSION_TO_STRING[x] for x in self.permissions]}

    def __str__(self):
        return "Permissions({})".format(self.__dict__())
