# mypy-boto3-sagemaker-a2i-runtime

[![PyPI - mypy-boto3-sagemaker-a2i-runtime](https://img.shields.io/pypi/v/mypy-boto3-sagemaker-a2i-runtime.svg?color=blue)](https://pypi.org/project/mypy-boto3-sagemaker-a2i-runtime)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-sagemaker-a2i-runtime.svg?color=blue)](https://pypi.org/project/mypy-boto3-sagemaker-a2i-runtime)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.AugmentedAIRuntime 1.15.18](https://boto3.amazonaws.com/v1/documentation/api/1.15.18/reference/services/sagemaker-a2i-runtime.html#AugmentedAIRuntime) service
compatible with
[VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright)
and other tools.

Generated by [mypy-boto3-buider 3.2.1](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

- [mypy-boto3-sagemaker-a2i-runtime](#mypy-boto3-sagemaker-a2i-runtime)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Service Resource annotations](#service-resource-annotations)
    - [Other resources annotations](#other-resources-annotations)
    - [Collections annotations](#collections-annotations)
    - [Typed dictionations](#typed-dictionations)

## How to install

Install `boto3-stubs` for `AugmentedAIRuntime` service.

```bash
python -m pip install boto3-stubs[sagemaker-a2i-runtime]
```

## Usage

### VSCode

- Install [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[sagemaker-a2i-runtime]` in your environment: `python -m pip install 'boto3-stubs[sagemaker-a2i-runtime]'`

Both type checking and auto-complete should work for `AugmentedAIRuntime` service.
No explicit type annotations required, write your `boto3` code as usual.

### PyCharm

- Install `boto-stubs[sagemaker-a2i-runtime]` in your environment: `python -m pip install 'boto3-stubs[sagemaker-a2i-runtime]'`

Both type checking and auto-complete should work for `AugmentedAIRuntime` service.
No explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed `boto3-stubs` submodules.

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything should work.

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[sagemaker-a2i-runtime]` in your environment: `python -m pip install 'boto3-stubs[sagemaker-a2i-runtime]'`
- Run `mypy` as usual

Type checking should work for `AugmentedAIRuntime` service.
No explicit type annotations required, write your `boto3` code as usual.

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[sagemaker-a2i-runtime]` in your environment: `python -m pip install 'boto3-stubs[sagemaker-a2i-runtime]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `AugmentedAIRuntime` service.
No explicit type annotations required, write your `boto3` code as usual.

## Explicit type annotations

### Client annotations

`AugmentedAIRuntimeClient` provides annotations for `boto3.client("sagemaker-a2i-runtime")`.

```python
import boto3

from mypy_boto3_sagemaker_a2i_runtime import AugmentedAIRuntimeClient

client: AugmentedAIRuntimeClient = boto3.client("sagemaker-a2i-runtime")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: AugmentedAIRuntimeClient = session.client("sagemaker-a2i-runtime")
```

### Paginators annotations

`mypy_boto3_sagemaker_a2i_runtime.paginator` module contains type annotations for all paginators.

```python
from mypy_boto3_sagemaker_a2i_runtime import AugmentedAIRuntimeClient
from mypy_boto3_sagemaker_a2i_runtime.paginator import ListHumanLoopsPaginator

client: AugmentedAIRuntimeClient = boto3.client("sagemaker-a2i-runtime")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
list_human_loops_paginator: ListHumanLoopsPaginator = client.get_paginator("list_human_loops")
```







### Typed dictionations

`mypy_boto3_sagemaker_a2i_runtime.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_sagemaker_a2i_runtime.type_defs import (
    DescribeHumanLoopResponseTypeDef,
    HumanLoopDataAttributesTypeDef,
    HumanLoopInputTypeDef,
    HumanLoopOutputTypeDef,
    HumanLoopSummaryTypeDef,
    ListHumanLoopsResponseTypeDef,
    PaginatorConfigTypeDef,
    ResponseMetadata,
    StartHumanLoopResponseTypeDef,
)

def get_structure() -> HumanLoopOutputTypeDef:
    return {
      ...
    }
```
