#!/usr/bin/env python3

"""
This module provide one function called print_lol()
which prints lists that may or not include nested lists.
"""

def print_lol(the_list, indent=False, level=0, fh=sys.stdout):
    """
    recursion function to print list from sub-list
    :param the_list:
    :return:
    """
    for each_item in the_list:
        if isinstance(each_item, list):
            print_lol(each_item, indent, level+1, fh)
        else:
            if indent:
                for tab_stop in range(level):
                    print("\t", end='', file=fh)
            print(each_item, file=fh)


