from .language import Language


class CPP(Language):
    keywords = [
		"abstract",
		"amp",
		"array",
		"auto",
		"bool",
		"break",
		"case",
		"catch",
		"char",
		"class",
		"const",
		"constexpr",
		"const_cast",
		"continue",
		"cpu",
		"decltype",
		"default",
		"delegate",
		"delete",
		"do",
		"double",
		"dynamic_cast",
		"each",
		"else",
		"enum",
		"event",
		"explicit",
		"export",
		"extern",
		"false",
		"final",
		"finally",
		"float",
		"for",
		"friend",
		"gcnew",
		"generic",
		"goto",
		"if",
		"in",
		"initonly",
		"inline",
		"int",
		"interface",
		"interior_ptr",
		"internal",
		"literal",
		"long",
		"mutable",
		"namespace",
		"new",
		"noexcept",
		"nullptr",
		"__nullptr",
		"operator",
		"override",
		"partial",
		"pascal",
		"pin_ptr",
		"private",
		"property",
		"protected",
		"public",
		"ref",
		"register",
		"reinterpret_cast",
		"restrict",
		"return",
		"safe_cast",
		"sealed",
		"short",
		"signed",
		"sizeof",
		"static",
		"static_assert",
		"static_cast",
		"struct",
		"switch",
		"template",
		"this",
		"thread_local",
		"throw",
		"tile_static",
		"true",
		"try",
		"typedef",
		"typeid",
		"typename",
		"union",
		"unsigned",
		"using",
		"virtual",
		"void",
		"volatile",
		"wchar_t",
		"where",
		"while",

		"_asm",
		"_based",
		"_cdecl",
		"_declspec",
		"_fastcall",
		"_if_exists",
		"_if_not_exists",
		"_inline",
		"_multiple_inheritance",
		"_pascal",
		"_single_inheritance",
		"_stdcall",
		"_virtual_inheritance",
		"_w64",

		"__abstract",
		"__alignof",
		"__asm",
		"__assume",
		"__based",
		"__box",
		"__builtin_alignof",
		"__cdecl",
		"__clrcall",
		"__declspec",
		"__delegate",
		"__event",
		"__except",
		"__fastcall",
		"__finally",
		"__forceinline",
		"__gc",
		"__hook",
		"__identifier",
		"__if_exists",
		"__if_not_exists",
		"__inline",
		"__int128",
		"__int16",
		"__int32",
		"__int64",
		"__int8",
		"__interface",
		"__leave",
		"__m128",
		"__m128d",
		"__m128i",
		"__m256",
		"__m256d",
		"__m256i",
		"__m64",
		"__multiple_inheritance",
		"__newslot",
		"__nogc",
		"__noop",
		"__nounwind",
		"__novtordisp",
		"__pascal",
		"__pin",
		"__pragma",
		"__property",
		"__ptr32",
		"__ptr64",
		"__raise",
		"__restrict",
		"__resume",
		"__sealed",
		"__single_inheritance",
		"__stdcall",
		"__super",
		"__thiscall",
		"__try",
		"__try_cast",
		"__typeof",
		"__unaligned",
		"__unhook",
		"__uuidof",
		"__value",
		"__virtual_inheritance",
		"__w64",
		"__wchar_t"]
	
    strings = ["(\\'(.)\\')", "(\"(.)*\")"]
    numbers = ["0", "1", "2", "3", "4", "5", "6", "7", "8", "9"]
    comments = ["(//(.)*)", "(\/\\*(.*?)\\*\/)"]
