import {Request} from '../lib/request';
import {Response} from '../lib/response';
import {AWSError} from '../lib/error';
import {Service} from '../lib/service';
import {ServiceConfigurationOptions} from '../lib/service';
import {ConfigBase as Config} from '../lib/config';
interface Blob {}
declare class PersonalizeEvents extends Service {
  /**
   * Constructs a service object. This object has one method for each API operation.
   */
  constructor(options?: PersonalizeEvents.Types.ClientConfiguration)
  config: Config & PersonalizeEvents.Types.ClientConfiguration;
  /**
   * Records user interaction event data.
   */
  putEvents(params: PersonalizeEvents.Types.PutEventsRequest, callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
  /**
   * Records user interaction event data.
   */
  putEvents(callback?: (err: AWSError, data: {}) => void): Request<{}, AWSError>;
}
declare namespace PersonalizeEvents {
  export type _Date = Date;
  export interface Event {
    /**
     * An ID associated with the event. If an event ID is not provided, Amazon Personalize generates a unique ID for the event. An event ID is not used as an input to the model. Amazon Personalize uses the event ID to distinquish unique events. Any subsequent events after the first with the same event ID are not used in model training.
     */
    eventId?: StringType;
    /**
     * The type of event. This property corresponds to the EVENT_TYPE field of the Interactions schema.
     */
    eventType: StringType;
    /**
     * A string map of event-specific data that you might choose to record. For example, if a user rates a movie on your site, you might send the movie ID and rating, and the number of movie ratings made by the user. Each item in the map consists of a key-value pair. For example,  {"itemId": "movie1"}   {"itemId": "movie2", "eventValue": "4.5"}   {"itemId": "movie3", "eventValue": "3", "numberOfRatings": "12"}  The keys use camel case names that match the fields in the Interactions schema. The itemId and eventValue keys correspond to the ITEM_ID and EVENT_VALUE fields. In the above example, the eventType might be 'MovieRating' with eventValue being the rating. The numberOfRatings would match the 'NUMBER_OF_RATINGS' field defined in the Interactions schema.
     */
    properties: EventPropertiesJSON;
    /**
     * The timestamp on the client side when the event occurred.
     */
    sentAt: _Date;
  }
  export type EventList = Event[];
  export type EventPropertiesJSON = string;
  export interface PutEventsRequest {
    /**
     * The tracking ID for the event. The ID is generated by a call to the CreateEventTracker API.
     */
    trackingId: StringType;
    /**
     * The user associated with the event.
     */
    userId?: UserId;
    /**
     * The session ID associated with the user's visit.
     */
    sessionId: StringType;
    /**
     * A list of event data from the session.
     */
    eventList: EventList;
  }
  export type StringType = string;
  export type UserId = string;
  /**
   * A string in YYYY-MM-DD format that represents the latest possible API version that can be used in this service. Specify 'latest' to use the latest possible version.
   */
  export type apiVersion = "2018-03-22"|"latest"|string;
  export interface ClientApiVersions {
    /**
     * A string in YYYY-MM-DD format that represents the latest possible API version that can be used in this service. Specify 'latest' to use the latest possible version.
     */
    apiVersion?: apiVersion;
  }
  export type ClientConfiguration = ServiceConfigurationOptions & ClientApiVersions;
  /**
   * Contains interfaces for use with the PersonalizeEvents client.
   */
  export import Types = PersonalizeEvents;
}
export = PersonalizeEvents;
