# Generated by Django 2.0 on 2020-10-21 08:29

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='SocialAccount',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('account_token', models.CharField(max_length=32, unique=True)),
                ('access_token', models.TextField(verbose_name='access token')),
                ('expires_at', models.DateTimeField(blank=True, null=True, verbose_name='access token expires at')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='created at')),
                ('extra_json', models.TextField(blank=True, null=True)),
                ('user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL, verbose_name='user')),
            ],
            options={
                'verbose_name': 'social account',
                'verbose_name_plural': 'social accounts',
            },
        ),
        migrations.CreateModel(
            name='SocialProfile',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('uid', models.CharField(help_text='User ID in the social network', max_length=255, verbose_name='UID')),
                ('network', models.CharField(help_text='Social network ID', max_length=255, verbose_name='network')),
                ('human_name', models.CharField(max_length=255, verbose_name='human-readable name')),
                ('username', models.CharField(max_length=255, verbose_name='latinized username')),
                ('email', models.CharField(blank=True, max_length=255, null=True, verbose_name='email')),
                ('picture', models.TextField(blank=True, null=True, verbose_name='picture URL')),
                ('account', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='profile', related_query_name='profile', to='onesocial_django.SocialAccount', verbose_name='social account')),
            ],
            options={
                'verbose_name': 'social profile',
                'verbose_name_plural': 'social profiles',
            },
        ),
    ]
