/*
 * Decompiled with CFR 0.152.
 */
package net.razorvine.serpent.ast;

import java.util.ArrayList;
import java.util.List;
import net.razorvine.serpent.ast.INode;
import net.razorvine.serpent.ast.INodeVisitor;

public abstract class SequenceNode
implements INode {
    public List<INode> elements = new ArrayList<INode>();

    public abstract char getOpenChar();

    public abstract char getCloseChar();

    public int hashCode() {
        int hashCode = 0;
        for (INode elt : this.elements) {
            hashCode += 1000000007 * elt.hashCode();
        }
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof SequenceNode)) {
            return false;
        }
        SequenceNode other = (SequenceNode)obj;
        return this.elements.equals(other.elements);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getOpenChar());
        if (this.elements != null) {
            for (INode elt : this.elements) {
                sb.append(elt.toString());
                sb.append(',');
            }
        }
        if (this.elements.size() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append(this.getCloseChar());
        return sb.toString();
    }

    @Override
    public abstract void accept(INodeVisitor var1);
}

