/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.scorecard;

import java.util.List;
import java.util.Map;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.ResultFeature;
import org.dmg.pmml.scorecard.Attribute;
import org.dmg.pmml.scorecard.Characteristic;
import org.dmg.pmml.scorecard.Characteristics;
import org.dmg.pmml.scorecard.PMMLAttributes;
import org.dmg.pmml.scorecard.Scorecard;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.PMMLUtil;
import org.jpmml.evaluator.PredicateUtil;
import org.jpmml.evaluator.TargetField;
import org.jpmml.evaluator.TargetUtil;
import org.jpmml.evaluator.UndefinedResultException;
import org.jpmml.evaluator.UnsupportedAttributeException;
import org.jpmml.evaluator.Value;
import org.jpmml.evaluator.ValueFactory;
import org.jpmml.evaluator.annotations.Functionality;
import org.jpmml.evaluator.scorecard.ScorecardEvaluator;

@Functionality(value={ResultFeature.PREDICTED_VALUE})
public class SimpleScorecardEvaluator
extends ScorecardEvaluator {
    private SimpleScorecardEvaluator() {
    }

    public SimpleScorecardEvaluator(PMML pmml) {
        this(pmml, PMMLUtil.findModel(pmml, Scorecard.class));
    }

    public SimpleScorecardEvaluator(PMML pmml, Scorecard scorecard) {
        super(pmml, scorecard);
        boolean useReasonCodes = scorecard.isUseReasonCodes();
        if (useReasonCodes) {
            throw new UnsupportedAttributeException((PMMLObject)scorecard, PMMLAttributes.SCORECARD_USEREASONCODES, useReasonCodes);
        }
    }

    @Override
    protected <V extends Number> Map<FieldName, ?> evaluateRegression(ValueFactory<V> valueFactory, EvaluationContext context) {
        Scorecard scorecard = (Scorecard)this.getModel();
        TargetField targetField = this.getTargetField();
        Value<V> score = valueFactory.newValue(scorecard.getInitialScore());
        Characteristics characteristics = scorecard.getCharacteristics();
        for (Characteristic characteristic : characteristics) {
            Number partialScore = null;
            List attributes = characteristic.getAttributes();
            for (Attribute attribute : attributes) {
                Boolean status = PredicateUtil.evaluatePredicateContainer(attribute, context);
                if (status == null || !status.booleanValue()) continue;
                partialScore = SimpleScorecardEvaluator.evaluatePartialScore(attribute, context);
                if (partialScore == null) {
                    return TargetUtil.evaluateRegressionDefault(valueFactory, targetField);
                }
                score.add(partialScore);
                break;
            }
            if (partialScore != null) continue;
            throw new UndefinedResultException().ensureContext((PMMLObject)characteristic);
        }
        return TargetUtil.evaluateRegression(targetField, score);
    }
}

